// services/network/public/mojom/tls_socket.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_TLS_SOCKET_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_TLS_SOCKET_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/tls_socket.mojom-shared-internal.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "services/network/public/mojom/ssl_config.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace network::mojom {
class TLSClientSocketOptionsDataView;



}  // network::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::TLSClientSocketOptionsDataView> {
  using Data = ::network::mojom::internal::TLSClientSocketOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {
// Interface base classes. They are used for type safety check.
class TLSClientSocketInterfaceBase {};

using TLSClientSocketPtrDataView =
    mojo::InterfacePtrDataView<TLSClientSocketInterfaceBase>;
using TLSClientSocketRequestDataView =
    mojo::InterfaceRequestDataView<TLSClientSocketInterfaceBase>;
using TLSClientSocketAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<TLSClientSocketInterfaceBase>;
using TLSClientSocketAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<TLSClientSocketInterfaceBase>;


class TLSClientSocketOptionsDataView {
 public:
  TLSClientSocketOptionsDataView() = default;

  TLSClientSocketOptionsDataView(
      internal::TLSClientSocketOptions_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadVersionMin(UserType* output) const {
    auto data_value = data_->version_min;
    return mojo::internal::Deserialize<::network::mojom::SSLVersion>(
        data_value, output);
  }
  ::network::mojom::SSLVersion version_min() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::SSLVersion>(data_->version_min));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadVersionMax(UserType* output) const {
    auto data_value = data_->version_max;
    return mojo::internal::Deserialize<::network::mojom::SSLVersion>(
        data_value, output);
  }
  ::network::mojom::SSLVersion version_max() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::SSLVersion>(data_->version_max));
  }
  bool send_ssl_info() const {
    return data_->send_ssl_info;
  }
  bool unsafely_skip_cert_verification() const {
    return data_->unsafely_skip_cert_verification;
  }
 private:
  internal::TLSClientSocketOptions_Data* data_ = nullptr;
};


}  // network::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::TLSClientSocketOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::TLSClientSocketOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::TLSClientSocketOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::network::mojom::SSLVersion>(
        Traits::version_min(input), &fragment->version_min);
    mojo::internal::Serialize<::network::mojom::SSLVersion>(
        Traits::version_max(input), &fragment->version_max);
    fragment->send_ssl_info = Traits::send_ssl_info(input);
    fragment->unsafely_skip_cert_verification = Traits::unsafely_skip_cert_verification(input);
  }

  static bool Deserialize(::network::mojom::internal::TLSClientSocketOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::TLSClientSocketOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {




}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_TLS_SOCKET_MOJOM_SHARED_H_