// services/viz/privileged/mojom/compositing/renderer_settings.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_RENDERER_SETTINGS_MOJOM_SHARED_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_RENDERER_SETTINGS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/privileged/mojom/compositing/renderer_settings.mojom-shared-internal.h"
#include "services/viz/privileged/mojom/compositing/overlay_strategy.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/color_space.mojom-shared.h"







namespace viz::mojom {
class OcclusionCullerSettingsDataView;

class RendererSettingsDataView;

class DebugRendererSettingsDataView;



}  // viz::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::OcclusionCullerSettingsDataView> {
  using Data = ::viz::mojom::internal::OcclusionCullerSettings_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::RendererSettingsDataView> {
  using Data = ::viz::mojom::internal::RendererSettings_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::DebugRendererSettingsDataView> {
  using Data = ::viz::mojom::internal::DebugRendererSettings_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


class OcclusionCullerSettingsDataView {
 public:
  OcclusionCullerSettingsDataView() = default;

  OcclusionCullerSettingsDataView(
      internal::OcclusionCullerSettings_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint16_t quad_split_limit() const {
    return data_->quad_split_limit;
  }
  uint16_t maximum_occluder_complexity() const {
    return data_->maximum_occluder_complexity;
  }
  uint16_t minimum_fragments_reduced() const {
    return data_->minimum_fragments_reduced;
  }
 private:
  internal::OcclusionCullerSettings_Data* data_ = nullptr;
};


class RendererSettingsDataView {
 public:
  RendererSettingsDataView() = default;

  RendererSettingsDataView(
      internal::RendererSettings_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool allow_antialiasing() const {
    return data_->allow_antialiasing;
  }
  bool force_antialiasing() const {
    return data_->force_antialiasing;
  }
  bool force_blending_with_shaders() const {
    return data_->force_blending_with_shaders;
  }
  int32_t highp_threshold_min() const {
    return data_->highp_threshold_min;
  }
  bool partial_swap_enabled() const {
    return data_->partial_swap_enabled;
  }
  bool release_overlay_resources_after_gpu_query() const {
    return data_->release_overlay_resources_after_gpu_query;
  }
  bool should_clear_root_render_pass() const {
    return data_->should_clear_root_render_pass;
  }
  int32_t slow_down_compositing_scale_factor() const {
    return data_->slow_down_compositing_scale_factor;
  }
  bool auto_resize_output_surface() const {
    return data_->auto_resize_output_surface;
  }
  bool requires_alpha_channel() const {
    return data_->requires_alpha_channel;
  }
  inline void GetOcclusionCullerSettingsDataView(
      OcclusionCullerSettingsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOcclusionCullerSettings(UserType* output) {
    
    auto* pointer = data_->occlusion_culler_settings.Get();
    return mojo::internal::Deserialize<::viz::mojom::OcclusionCullerSettingsDataView>(
        pointer, output, message_);
  }
  inline void GetOverlayStrategiesDataView(
      mojo::ArrayDataView<::viz::mojom::OverlayStrategy>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOverlayStrategies(UserType* output) {
    
    auto* pointer = data_->overlay_strategies.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::OverlayStrategy>>(
        pointer, output, message_);
  }
 private:
  internal::RendererSettings_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DebugRendererSettingsDataView {
 public:
  DebugRendererSettingsDataView() = default;

  DebugRendererSettingsDataView(
      internal::DebugRendererSettings_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool tint_composited_content() const {
    return data_->tint_composited_content;
  }
  bool tint_composited_content_modulate() const {
    return data_->tint_composited_content_modulate;
  }
  bool show_overdraw_feedback() const {
    return data_->show_overdraw_feedback;
  }
  bool show_dc_layer_debug_borders() const {
    return data_->show_dc_layer_debug_borders;
  }
  bool show_aggregated_damage() const {
    return data_->show_aggregated_damage;
  }
 private:
  internal::DebugRendererSettings_Data* data_ = nullptr;
};


}  // viz::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::OcclusionCullerSettingsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::OcclusionCullerSettingsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::OcclusionCullerSettings_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->quad_split_limit = Traits::quad_split_limit(input);
    fragment->maximum_occluder_complexity = Traits::maximum_occluder_complexity(input);
    fragment->minimum_fragments_reduced = Traits::minimum_fragments_reduced(input);
  }

  static bool Deserialize(::viz::mojom::internal::OcclusionCullerSettings_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::OcclusionCullerSettingsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::RendererSettingsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::RendererSettingsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::RendererSettings_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->allow_antialiasing = Traits::allow_antialiasing(input);
    fragment->force_antialiasing = Traits::force_antialiasing(input);
    fragment->force_blending_with_shaders = Traits::force_blending_with_shaders(input);
    fragment->highp_threshold_min = Traits::highp_threshold_min(input);
    fragment->partial_swap_enabled = Traits::partial_swap_enabled(input);
    fragment->release_overlay_resources_after_gpu_query = Traits::release_overlay_resources_after_gpu_query(input);
    fragment->should_clear_root_render_pass = Traits::should_clear_root_render_pass(input);
    fragment->slow_down_compositing_scale_factor = Traits::slow_down_compositing_scale_factor(input);
    fragment->auto_resize_output_surface = Traits::auto_resize_output_surface(input);
    fragment->requires_alpha_channel = Traits::requires_alpha_channel(input);
    decltype(Traits::occlusion_culler_settings(input)) in_occlusion_culler_settings = Traits::occlusion_culler_settings(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->occlusion_culler_settings)::BaseType> occlusion_culler_settings_fragment(
            fragment.message());
    mojo::internal::Serialize<::viz::mojom::OcclusionCullerSettingsDataView>(
        in_occlusion_culler_settings, occlusion_culler_settings_fragment);
    fragment->occlusion_culler_settings.Set(
        occlusion_culler_settings_fragment.is_null() ? nullptr : occlusion_culler_settings_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->occlusion_culler_settings.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null occlusion_culler_settings in RendererSettings struct");
    decltype(Traits::overlay_strategies(input)) in_overlay_strategies = Traits::overlay_strategies(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->overlay_strategies)::BaseType>
        overlay_strategies_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& overlay_strategies_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::viz::mojom::internal::OverlayStrategy_Data::Validate>();
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::OverlayStrategy>>(
        in_overlay_strategies, overlay_strategies_fragment, &overlay_strategies_validate_params);
    fragment->overlay_strategies.Set(
        overlay_strategies_fragment.is_null() ? nullptr : overlay_strategies_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->overlay_strategies.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null overlay_strategies in RendererSettings struct");
  }

  static bool Deserialize(::viz::mojom::internal::RendererSettings_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::RendererSettingsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::DebugRendererSettingsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::DebugRendererSettingsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::DebugRendererSettings_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->tint_composited_content = Traits::tint_composited_content(input);
    fragment->tint_composited_content_modulate = Traits::tint_composited_content_modulate(input);
    fragment->show_overdraw_feedback = Traits::show_overdraw_feedback(input);
    fragment->show_dc_layer_debug_borders = Traits::show_dc_layer_debug_borders(input);
    fragment->show_aggregated_damage = Traits::show_aggregated_damage(input);
  }

  static bool Deserialize(::viz::mojom::internal::DebugRendererSettings_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::DebugRendererSettingsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {



inline void RendererSettingsDataView::GetOcclusionCullerSettingsDataView(
    OcclusionCullerSettingsDataView* output) {
  auto pointer = data_->occlusion_culler_settings.Get();
  *output = OcclusionCullerSettingsDataView(pointer, message_);
}
inline void RendererSettingsDataView::GetOverlayStrategiesDataView(
    mojo::ArrayDataView<::viz::mojom::OverlayStrategy>* output) {
  auto pointer = data_->overlay_strategies.Get();
  *output = mojo::ArrayDataView<::viz::mojom::OverlayStrategy>(pointer, message_);
}





}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_RENDERER_SETTINGS_MOJOM_SHARED_H_