// third_party/blink/public/mojom/on_device_translation/translation_manager.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/on_device_translation/translation_manager.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/on_device_translation/translation_manager.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* CanCreateTranslatorResultToStringHelper(CanCreateTranslatorResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CanCreateTranslatorResult::kReadily:
      return "kReadily";
    case CanCreateTranslatorResult::kAfterDownloadLibraryNotReady:
      return "kAfterDownloadLibraryNotReady";
    case CanCreateTranslatorResult::kAfterDownloadLanguagePackNotReady:
      return "kAfterDownloadLanguagePackNotReady";
    case CanCreateTranslatorResult::kAfterDownloadLibraryAndLanguagePackNotReady:
      return "kAfterDownloadLibraryAndLanguagePackNotReady";
    case CanCreateTranslatorResult::kNoNotSupportedLanguage:
      return "kNoNotSupportedLanguage";
    case CanCreateTranslatorResult::kNoAcceptLanguagesCheckFailed:
      return "kNoAcceptLanguagesCheckFailed";
    case CanCreateTranslatorResult::kNoExceedsLanguagePackCountLimitation:
      return "kNoExceedsLanguagePackCountLimitation";
    case CanCreateTranslatorResult::kNoServiceCrashed:
      return "kNoServiceCrashed";
    case CanCreateTranslatorResult::kNoDisallowedByPolicy:
      return "kNoDisallowedByPolicy";
    case CanCreateTranslatorResult::kNoExceedsServiceCountLimitation:
      return "kNoExceedsServiceCountLimitation";
    default:
      return nullptr;
  }
}

std::string CanCreateTranslatorResultToString(CanCreateTranslatorResult value) {
  const char *str = CanCreateTranslatorResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CanCreateTranslatorResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CanCreateTranslatorResult value) {
  return os << CanCreateTranslatorResultToString(value);
}

NOINLINE static const char* CreateTranslatorErrorToStringHelper(CreateTranslatorError value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CreateTranslatorError::kInvalidBinary:
      return "kInvalidBinary";
    case CreateTranslatorError::kInvalidFunctionPointer:
      return "kInvalidFunctionPointer";
    case CreateTranslatorError::kFailedToInitialize:
      return "kFailedToInitialize";
    case CreateTranslatorError::kFailedToCreateTranslator:
      return "kFailedToCreateTranslator";
    case CreateTranslatorError::kAcceptLanguagesCheckFailed:
      return "kAcceptLanguagesCheckFailed";
    case CreateTranslatorError::kExceedsLanguagePackCountLimitation:
      return "kExceedsLanguagePackCountLimitation";
    case CreateTranslatorError::kServiceCrashed:
      return "kServiceCrashed";
    case CreateTranslatorError::kDisallowedByPolicy:
      return "kDisallowedByPolicy";
    case CreateTranslatorError::kExceedsServiceCountLimitation:
      return "kExceedsServiceCountLimitation";
    case CreateTranslatorError::kExceedsPendingTaskCountLimitation:
      return "kExceedsPendingTaskCountLimitation";
    case CreateTranslatorError::kInvalidVersion:
      return "kInvalidVersion";
    default:
      return nullptr;
  }
}

std::string CreateTranslatorErrorToString(CreateTranslatorError value) {
  const char *str = CreateTranslatorErrorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CreateTranslatorError value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CreateTranslatorError value) {
  return os << CreateTranslatorErrorToString(value);
}

NOINLINE static const char* TranslationAvailabilityToStringHelper(TranslationAvailability value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TranslationAvailability::kNo:
      return "kNo";
    case TranslationAvailability::kReadily:
      return "kReadily";
    case TranslationAvailability::kAfterDownload:
      return "kAfterDownload";
    default:
      return nullptr;
  }
}

std::string TranslationAvailabilityToString(TranslationAvailability value) {
  const char *str = TranslationAvailabilityToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TranslationAvailability value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TranslationAvailability value) {
  return os << TranslationAvailabilityToString(value);
}

namespace internal {
// static
bool CreateTranslatorResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const CreateTranslatorResult_Data* object = static_cast<const CreateTranslatorResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case CreateTranslatorResult_Tag::kTranslator: {

      if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
              object->data.f_translator, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateHandleOrInterface(object->data.f_translator,
                                                     validation_context)) {
        return false;
      }
      return true;
    }
    case CreateTranslatorResult_Tag::kError: {


      if (!::blink::mojom::internal::CreateTranslatorError_Data
            ::Validate(object->data.f_error, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in CreateTranslatorResult");
      return false;
    }
  }
}


// static
bool TranslatorLanguageCode_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TranslatorLanguageCode_Data* object =
      static_cast<const TranslatorLanguageCode_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->code, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& code_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->code, validation_context,
                                         &code_validate_params)) {
    return false;
  }

  return true;
}

TranslatorLanguageCode_Data::TranslatorLanguageCode_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TranslatorCreateOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TranslatorCreateOptions_Data* object =
      static_cast<const TranslatorCreateOptions_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_lang, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_lang, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->target_lang, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->target_lang, validation_context))
    return false;

  return true;
}

TranslatorCreateOptions_Data::TranslatorCreateOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TranslatorAvailabilityInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TranslatorAvailabilityInfo_Data* object =
      static_cast<const TranslatorAvailabilityInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->language_categories, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& language_categories_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->language_categories, validation_context,
                                         &language_categories_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->language_availability_matrix, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& language_availability_matrix_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::TranslationAvailability_Data::Validate>()>();
  if (!mojo::internal::ValidateContainer(object->language_availability_matrix, validation_context,
                                         &language_availability_matrix_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::TranslationAvailability_Data
        ::Validate(object->availability, validation_context))
    return false;

  return true;
}

TranslatorAvailabilityInfo_Data::TranslatorAvailabilityInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TranslationManagerCreateTranslatorClient_OnResult_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TranslationManagerCreateTranslatorClient_OnResult_Params_Data* object =
      static_cast<const TranslationManagerCreateTranslatorClient_OnResult_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

TranslationManagerCreateTranslatorClient_OnResult_Params_Data::TranslationManagerCreateTranslatorClient_OnResult_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TranslationManager_CanCreateTranslator_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TranslationManager_CanCreateTranslator_Params_Data* object =
      static_cast<const TranslationManager_CanCreateTranslator_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_lang, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_lang, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->target_lang, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->target_lang, validation_context))
    return false;

  return true;
}

TranslationManager_CanCreateTranslator_Params_Data::TranslationManager_CanCreateTranslator_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TranslationManager_CanCreateTranslator_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TranslationManager_CanCreateTranslator_ResponseParams_Data* object =
      static_cast<const TranslationManager_CanCreateTranslator_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::CanCreateTranslatorResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

TranslationManager_CanCreateTranslator_ResponseParams_Data::TranslationManager_CanCreateTranslator_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TranslationManager_CreateTranslator_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TranslationManager_CreateTranslator_Params_Data* object =
      static_cast<const TranslationManager_CreateTranslator_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

TranslationManager_CreateTranslator_Params_Data::TranslationManager_CreateTranslator_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TranslationManager_GetTranslatorAvailabilityInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TranslationManager_GetTranslatorAvailabilityInfo_Params_Data* object =
      static_cast<const TranslationManager_GetTranslatorAvailabilityInfo_Params_Data*>(data);

  return true;
}

TranslationManager_GetTranslatorAvailabilityInfo_Params_Data::TranslationManager_GetTranslatorAvailabilityInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TranslationManager_GetTranslatorAvailabilityInfo_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TranslationManager_GetTranslatorAvailabilityInfo_ResponseParams_Data* object =
      static_cast<const TranslationManager_GetTranslatorAvailabilityInfo_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;

  return true;
}

TranslationManager_GetTranslatorAvailabilityInfo_ResponseParams_Data::TranslationManager_GetTranslatorAvailabilityInfo_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::CanCreateTranslatorResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::CanCreateTranslatorResult value) {
  return std::move(context).WriteString(::blink::mojom::CanCreateTranslatorResultToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::CreateTranslatorError>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::CreateTranslatorError value) {
  return std::move(context).WriteString(::blink::mojom::CreateTranslatorErrorToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::TranslationAvailability>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::TranslationAvailability value) {
  return std::move(context).WriteString(::blink::mojom::TranslationAvailabilityToString(value));
}

} // namespace perfetto