// third_party/blink/public/mojom/private_network_device/private_network_device.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRIVATE_NETWORK_DEVICE_PRIVATE_NETWORK_DEVICE_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRIVATE_NETWORK_DEVICE_PRIVATE_NETWORK_DEVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/private_network_device/private_network_device.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/private_network_device/private_network_device.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/private_network_device/private_network_device.mojom-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/ip_address.mojom.h"
#include <string>
#include <vector>




#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {








class BLINK_COMMON_EXPORT PrivateNetworkDevice {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PrivateNetworkDevice, T>::value>;
  using DataView = PrivateNetworkDeviceDataView;
  using Data_ = internal::PrivateNetworkDevice_Data;

  template <typename... Args>
  static PrivateNetworkDevicePtr New(Args&&... args) {
    return PrivateNetworkDevicePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PrivateNetworkDevicePtr From(const U& u) {
    return mojo::TypeConverter<PrivateNetworkDevicePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PrivateNetworkDevice>::Convert(*this);
  }


  PrivateNetworkDevice();

  PrivateNetworkDevice(
      const std::optional<std::string>& id,
      const std::optional<std::string>& name,
      const ::net::IPAddress& ip_address);


  ~PrivateNetworkDevice();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PrivateNetworkDevicePtr>
  PrivateNetworkDevicePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PrivateNetworkDevice::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PrivateNetworkDevice::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PrivateNetworkDevice::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PrivateNetworkDevice::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PrivateNetworkDevice::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PrivateNetworkDevice_UnserializedMessageContext<
            UserType, PrivateNetworkDevice::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PrivateNetworkDevice::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PrivateNetworkDevice::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PrivateNetworkDevice_UnserializedMessageContext<
            UserType, PrivateNetworkDevice::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PrivateNetworkDevice::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<std::string> id;
  
  std::optional<std::string> name;
  
  ::net::IPAddress ip_address;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PrivateNetworkDevice::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PrivateNetworkDevice::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PrivateNetworkDevice::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PrivateNetworkDevice::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PrivateNetworkDevicePtr PrivateNetworkDevice::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(name),
      mojo::Clone(ip_address)
  );
}

template <typename T, PrivateNetworkDevice::EnableIfSame<T>*>
bool PrivateNetworkDevice::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->ip_address, other_struct.ip_address))
    return false;
  return true;
}

template <typename T, PrivateNetworkDevice::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.ip_address < rhs.ip_address)
    return true;
  if (rhs.ip_address < lhs.ip_address)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::PrivateNetworkDevice::DataView,
                                         ::blink::mojom::PrivateNetworkDevicePtr> {
  static bool IsNull(const ::blink::mojom::PrivateNetworkDevicePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PrivateNetworkDevicePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::PrivateNetworkDevice::id)& id(
      const ::blink::mojom::PrivateNetworkDevicePtr& input) {
    return input->id;
  }

  static const decltype(::blink::mojom::PrivateNetworkDevice::name)& name(
      const ::blink::mojom::PrivateNetworkDevicePtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::PrivateNetworkDevice::ip_address)& ip_address(
      const ::blink::mojom::PrivateNetworkDevicePtr& input) {
    return input->ip_address;
  }

  static bool Read(::blink::mojom::PrivateNetworkDevice::DataView input, ::blink::mojom::PrivateNetworkDevicePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRIVATE_NETWORK_DEVICE_PRIVATE_NETWORK_DEVICE_MOJOM_H_