// ui/gfx/mojom/native_handle_types.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_NATIVE_HANDLE_TYPES_MOJOM_SHARED_H_
#define UI_GFX_MOJOM_NATIVE_HANDLE_TYPES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/mojom/native_handle_types.mojom-shared-internal.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace gfx::mojom {
class NativePixmapPlaneDataView;

class NativePixmapHandleDataView;

class GpuMemoryBufferPlatformHandleDataView;


}  // gfx::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gfx::mojom::NativePixmapPlaneDataView> {
  using Data = ::gfx::mojom::internal::NativePixmapPlane_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gfx::mojom::NativePixmapHandleDataView> {
  using Data = ::gfx::mojom::internal::NativePixmapHandle_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gfx::mojom::GpuMemoryBufferPlatformHandleDataView> {
  using Data = ::gfx::mojom::internal::GpuMemoryBufferPlatformHandle_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace gfx::mojom {


class NativePixmapPlaneDataView {
 public:
  NativePixmapPlaneDataView() = default;

  NativePixmapPlaneDataView(
      internal::NativePixmapPlane_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t stride() const {
    return data_->stride;
  }
  uint64_t offset() const {
    return data_->offset;
  }
  uint64_t size() const {
    return data_->size;
  }
  mojo::PlatformHandle TakeBufferHandle() {
    mojo::PlatformHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::PlatformHandle>(
            &data_->buffer_handle, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::NativePixmapPlane_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NativePixmapHandleDataView {
 public:
  NativePixmapHandleDataView() = default;

  NativePixmapHandleDataView(
      internal::NativePixmapHandle_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPlanesDataView(
      mojo::ArrayDataView<NativePixmapPlaneDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPlanes(UserType* output) {
    
    auto* pointer = data_->planes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::NativePixmapPlaneDataView>>(
        pointer, output, message_);
  }
  uint64_t modifier() const {
    return data_->modifier;
  }
  bool supports_zero_copy_webgpu_import() const {
    return data_->supports_zero_copy_webgpu_import;
  }
 private:
  internal::NativePixmapHandle_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GpuMemoryBufferPlatformHandleDataView {
 public:
  using Tag = internal::GpuMemoryBufferPlatformHandle_Data::GpuMemoryBufferPlatformHandle_Tag;

  GpuMemoryBufferPlatformHandleDataView() = default;

  GpuMemoryBufferPlatformHandleDataView(
      internal::GpuMemoryBufferPlatformHandle_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_shared_memory_handle() const { return data_->tag == Tag::kSharedMemoryHandle; }
  inline void GetSharedMemoryHandleDataView(
      ::mojo_base::mojom::UnsafeSharedMemoryRegionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSharedMemoryHandle(UserType* output) const {
    
    CHECK(is_shared_memory_handle());
    return mojo::internal::Deserialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView>(
        data_->data.f_shared_memory_handle.Get(), output, message_);
  }
  bool is_native_pixmap_handle() const { return data_->tag == Tag::kNativePixmapHandle; }
  inline void GetNativePixmapHandleDataView(
      NativePixmapHandleDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadNativePixmapHandle(UserType* output) const {
    
    CHECK(is_native_pixmap_handle());
    return mojo::internal::Deserialize<::gfx::mojom::NativePixmapHandleDataView>(
        data_->data.f_native_pixmap_handle.Get(), output, message_);
  }

 private:
  internal::GpuMemoryBufferPlatformHandle_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // gfx::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::NativePixmapPlaneDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::NativePixmapPlaneDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::NativePixmapPlane_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->stride = Traits::stride(input);
    fragment->offset = Traits::offset(input);
    fragment->size = Traits::size(input);
    decltype(Traits::buffer_handle(input)) in_buffer_handle = Traits::buffer_handle(input);
    mojo::internal::Serialize<mojo::PlatformHandle>(
        in_buffer_handle, &fragment->buffer_handle, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->buffer_handle),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid buffer_handle in NativePixmapPlane struct");
  }

  static bool Deserialize(::gfx::mojom::internal::NativePixmapPlane_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::NativePixmapPlaneDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::NativePixmapHandleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::NativePixmapHandleDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::NativePixmapHandle_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::planes(input)) in_planes = Traits::planes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->planes)::BaseType>
        planes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& planes_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::NativePixmapPlaneDataView>>(
        in_planes, planes_fragment, &planes_validate_params);
    fragment->planes.Set(
        planes_fragment.is_null() ? nullptr : planes_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->planes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null planes in NativePixmapHandle struct");
    fragment->modifier = Traits::modifier(input);
    fragment->supports_zero_copy_webgpu_import = Traits::supports_zero_copy_webgpu_import(input);
  }

  static bool Deserialize(::gfx::mojom::internal::NativePixmapHandle_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::NativePixmapHandleDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::GpuMemoryBufferPlatformHandleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::gfx::mojom::GpuMemoryBufferPlatformHandleDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::gfx::mojom::internal::GpuMemoryBufferPlatformHandle_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::gfx::mojom::GpuMemoryBufferPlatformHandleDataView::Tag::kSharedMemoryHandle: {
        decltype(Traits::shared_memory_handle(input))
            in_shared_memory_handle = Traits::shared_memory_handle(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_shared_memory_handle)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView>(
            in_shared_memory_handle, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null shared_memory_handle in GpuMemoryBufferPlatformHandle union");
        fragment->data.f_shared_memory_handle.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::gfx::mojom::GpuMemoryBufferPlatformHandleDataView::Tag::kNativePixmapHandle: {
        decltype(Traits::native_pixmap_handle(input))
            in_native_pixmap_handle = Traits::native_pixmap_handle(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_native_pixmap_handle)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::gfx::mojom::NativePixmapHandleDataView>(
            in_native_pixmap_handle, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null native_pixmap_handle in GpuMemoryBufferPlatformHandle union");
        fragment->data.f_native_pixmap_handle.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::gfx::mojom::internal::GpuMemoryBufferPlatformHandle_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::GpuMemoryBufferPlatformHandleDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gfx::mojom {



inline void NativePixmapHandleDataView::GetPlanesDataView(
    mojo::ArrayDataView<NativePixmapPlaneDataView>* output) {
  auto pointer = data_->planes.Get();
  *output = mojo::ArrayDataView<NativePixmapPlaneDataView>(pointer, message_);
}


inline void GpuMemoryBufferPlatformHandleDataView::GetSharedMemoryHandleDataView(
    ::mojo_base::mojom::UnsafeSharedMemoryRegionDataView* output) const {
  CHECK(is_shared_memory_handle());
  *output = ::mojo_base::mojom::UnsafeSharedMemoryRegionDataView(data_->data.f_shared_memory_handle.Get(), message_);
}
inline void GpuMemoryBufferPlatformHandleDataView::GetNativePixmapHandleDataView(
    NativePixmapHandleDataView* output) const {
  CHECK(is_native_pixmap_handle());
  *output = NativePixmapHandleDataView(data_->data.f_native_pixmap_handle.Get(), message_);
}


}  // gfx::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // UI_GFX_MOJOM_NATIVE_HANDLE_TYPES_MOJOM_SHARED_H_