// services/media_session/public/mojom/audio_focus.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/media_session/public/mojom/audio_focus.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/media_session/public/mojom/audio_focus.mojom-params-data.h"
namespace media_session {
namespace mojom {

NOINLINE static const char* EnforcementModeToStringHelper(EnforcementMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case EnforcementMode::kDefault:
      return "kDefault";
    case EnforcementMode::kNone:
      return "kNone";
    case EnforcementMode::kSingleGroup:
      return "kSingleGroup";
    case EnforcementMode::kSingleSession:
      return "kSingleSession";
    default:
      return nullptr;
  }
}

std::string EnforcementModeToString(EnforcementMode value) {
  const char *str = EnforcementModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown EnforcementMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, EnforcementMode value) {
  return os << EnforcementModeToString(value);
}

NOINLINE static const char* AudioFocusTypeToStringHelper(AudioFocusType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AudioFocusType::kGain:
      return "kGain";
    case AudioFocusType::kGainTransientMayDuck:
      return "kGainTransientMayDuck";
    case AudioFocusType::kGainTransient:
      return "kGainTransient";
    case AudioFocusType::kAmbient:
      return "kAmbient";
    default:
      return nullptr;
  }
}

std::string AudioFocusTypeToString(AudioFocusType value) {
  const char *str = AudioFocusTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AudioFocusType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AudioFocusType value) {
  return os << AudioFocusTypeToString(value);
}

namespace internal {


// static
bool AudioFocusRequestState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  static constexpr mojo::internal::StructVersionSize kVersionSizes[] = {
    { 0, 24 },
    { 2, 32 },
    { 3, 40 },
    { 9, 48 },
  };
  if (!ValidateStructHeaderAndVersionSizeAndClaimMemory(
          data, kVersionSizes, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioFocusRequestState_Data* object =
      static_cast<const AudioFocusRequestState_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->session_info, validation_context))
    return false;


  if (!::media_session::mojom::internal::AudioFocusType_Data
        ::Validate(object->audio_focus_type, validation_context))
    return false;
  if (object->header_.version < 2)
    return true;

  constexpr const mojo::internal::ContainerValidateParams& source_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->source_name, validation_context,
                                         &source_name_validate_params)) {
    return false;
  }
  if (object->header_.version < 3)
    return true;

  if (!mojo::internal::ValidateStruct(object->request_id, validation_context))
    return false;
  if (object->header_.version < 9)
    return true;

  if (!mojo::internal::ValidateStruct(object->source_id, validation_context))
    return false;

  return true;
}

AudioFocusRequestState_Data::AudioFocusRequestState_Data()
    : header_({sizeof(*this), 9}) {}


// static
bool AudioFocusObserver_OnFocusGained_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioFocusObserver_OnFocusGained_Params_Data* object =
      static_cast<const AudioFocusObserver_OnFocusGained_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->state, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->state, validation_context))
    return false;

  return true;
}

AudioFocusObserver_OnFocusGained_Params_Data::AudioFocusObserver_OnFocusGained_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioFocusObserver_OnFocusLost_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioFocusObserver_OnFocusLost_Params_Data* object =
      static_cast<const AudioFocusObserver_OnFocusLost_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->state, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->state, validation_context))
    return false;

  return true;
}

AudioFocusObserver_OnFocusLost_Params_Data::AudioFocusObserver_OnFocusLost_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioFocusObserver_OnRequestIdReleased_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioFocusObserver_OnRequestIdReleased_Params_Data* object =
      static_cast<const AudioFocusObserver_OnRequestIdReleased_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request_id, validation_context))
    return false;

  return true;
}

AudioFocusObserver_OnRequestIdReleased_Params_Data::AudioFocusObserver_OnRequestIdReleased_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioFocusRequestClient_RequestAudioFocus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioFocusRequestClient_RequestAudioFocus_Params_Data* object =
      static_cast<const AudioFocusRequestClient_RequestAudioFocus_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->session_info, validation_context))
    return false;


  if (!::media_session::mojom::internal::AudioFocusType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

AudioFocusRequestClient_RequestAudioFocus_Params_Data::AudioFocusRequestClient_RequestAudioFocus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioFocusRequestClient_RequestAudioFocus_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioFocusRequestClient_RequestAudioFocus_ResponseParams_Data* object =
      static_cast<const AudioFocusRequestClient_RequestAudioFocus_ResponseParams_Data*>(data);

  return true;
}

AudioFocusRequestClient_RequestAudioFocus_ResponseParams_Data::AudioFocusRequestClient_RequestAudioFocus_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioFocusRequestClient_AbandonAudioFocus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioFocusRequestClient_AbandonAudioFocus_Params_Data* object =
      static_cast<const AudioFocusRequestClient_AbandonAudioFocus_Params_Data*>(data);

  return true;
}

AudioFocusRequestClient_AbandonAudioFocus_Params_Data::AudioFocusRequestClient_AbandonAudioFocus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioFocusRequestClient_MediaSessionInfoChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioFocusRequestClient_MediaSessionInfoChanged_Params_Data* object =
      static_cast<const AudioFocusRequestClient_MediaSessionInfoChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->session_info, validation_context))
    return false;

  return true;
}

AudioFocusRequestClient_MediaSessionInfoChanged_Params_Data::AudioFocusRequestClient_MediaSessionInfoChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioFocusManager_RequestAudioFocus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioFocusManager_RequestAudioFocus_Params_Data* object =
      static_cast<const AudioFocusManager_RequestAudioFocus_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->session, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->session,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_info, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->session_info, validation_context))
    return false;


  if (!::media_session::mojom::internal::AudioFocusType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

AudioFocusManager_RequestAudioFocus_Params_Data::AudioFocusManager_RequestAudioFocus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioFocusManager_RequestAudioFocus_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioFocusManager_RequestAudioFocus_ResponseParams_Data* object =
      static_cast<const AudioFocusManager_RequestAudioFocus_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request_id, validation_context))
    return false;

  return true;
}

AudioFocusManager_RequestAudioFocus_ResponseParams_Data::AudioFocusManager_RequestAudioFocus_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioFocusManager_RequestGroupedAudioFocus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioFocusManager_RequestGroupedAudioFocus_Params_Data* object =
      static_cast<const AudioFocusManager_RequestGroupedAudioFocus_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request_id, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->session, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->session,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_info, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->session_info, validation_context))
    return false;


  if (!::media_session::mojom::internal::AudioFocusType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group_id, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->group_id, validation_context))
    return false;

  return true;
}

AudioFocusManager_RequestGroupedAudioFocus_Params_Data::AudioFocusManager_RequestGroupedAudioFocus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioFocusManager_RequestGroupedAudioFocus_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioFocusManager_RequestGroupedAudioFocus_ResponseParams_Data* object =
      static_cast<const AudioFocusManager_RequestGroupedAudioFocus_ResponseParams_Data*>(data);

  return true;
}

AudioFocusManager_RequestGroupedAudioFocus_ResponseParams_Data::AudioFocusManager_RequestGroupedAudioFocus_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioFocusManager_GetFocusRequests_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioFocusManager_GetFocusRequests_Params_Data* object =
      static_cast<const AudioFocusManager_GetFocusRequests_Params_Data*>(data);

  return true;
}

AudioFocusManager_GetFocusRequests_Params_Data::AudioFocusManager_GetFocusRequests_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioFocusManager_GetFocusRequests_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioFocusManager_GetFocusRequests_ResponseParams_Data* object =
      static_cast<const AudioFocusManager_GetFocusRequests_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->requests, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& requests_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->requests, validation_context,
                                         &requests_validate_params)) {
    return false;
  }

  return true;
}

AudioFocusManager_GetFocusRequests_ResponseParams_Data::AudioFocusManager_GetFocusRequests_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioFocusManager_AddObserver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioFocusManager_AddObserver_Params_Data* object =
      static_cast<const AudioFocusManager_AddObserver_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

AudioFocusManager_AddObserver_Params_Data::AudioFocusManager_AddObserver_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioFocusManager_SetSource_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioFocusManager_SetSource_Params_Data* object =
      static_cast<const AudioFocusManager_SetSource_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->identity, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->identity, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  return true;
}

AudioFocusManager_SetSource_Params_Data::AudioFocusManager_SetSource_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioFocusManager_SetEnforcementMode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioFocusManager_SetEnforcementMode_Params_Data* object =
      static_cast<const AudioFocusManager_SetEnforcementMode_Params_Data*>(data);


  if (!::media_session::mojom::internal::EnforcementMode_Data
        ::Validate(object->mode, validation_context))
    return false;

  return true;
}

AudioFocusManager_SetEnforcementMode_Params_Data::AudioFocusManager_SetEnforcementMode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioFocusManager_AddSourceObserver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioFocusManager_AddSourceObserver_Params_Data* object =
      static_cast<const AudioFocusManager_AddSourceObserver_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_id, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

AudioFocusManager_AddSourceObserver_Params_Data::AudioFocusManager_AddSourceObserver_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioFocusManager_GetSourceFocusRequests_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioFocusManager_GetSourceFocusRequests_Params_Data* object =
      static_cast<const AudioFocusManager_GetSourceFocusRequests_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_id, validation_context))
    return false;

  return true;
}

AudioFocusManager_GetSourceFocusRequests_Params_Data::AudioFocusManager_GetSourceFocusRequests_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioFocusManager_GetSourceFocusRequests_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioFocusManager_GetSourceFocusRequests_ResponseParams_Data* object =
      static_cast<const AudioFocusManager_GetSourceFocusRequests_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->requests, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& requests_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->requests, validation_context,
                                         &requests_validate_params)) {
    return false;
  }

  return true;
}

AudioFocusManager_GetSourceFocusRequests_ResponseParams_Data::AudioFocusManager_GetSourceFocusRequests_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioFocusManager_RequestIdReleased_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioFocusManager_RequestIdReleased_Params_Data* object =
      static_cast<const AudioFocusManager_RequestIdReleased_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request_id, validation_context))
    return false;

  return true;
}

AudioFocusManager_RequestIdReleased_Params_Data::AudioFocusManager_RequestIdReleased_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioFocusManager_StartDuckingAllAudio_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioFocusManager_StartDuckingAllAudio_Params_Data* object =
      static_cast<const AudioFocusManager_StartDuckingAllAudio_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->exempted_request_id, validation_context))
    return false;

  return true;
}

AudioFocusManager_StartDuckingAllAudio_Params_Data::AudioFocusManager_StartDuckingAllAudio_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioFocusManager_StopDuckingAllAudio_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioFocusManager_StopDuckingAllAudio_Params_Data* object =
      static_cast<const AudioFocusManager_StopDuckingAllAudio_Params_Data*>(data);

  return true;
}

AudioFocusManager_StopDuckingAllAudio_Params_Data::AudioFocusManager_StopDuckingAllAudio_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioFocusManager_FlushForTesting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioFocusManager_FlushForTesting_Params_Data* object =
      static_cast<const AudioFocusManager_FlushForTesting_Params_Data*>(data);

  return true;
}

AudioFocusManager_FlushForTesting_Params_Data::AudioFocusManager_FlushForTesting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioFocusManager_FlushForTesting_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioFocusManager_FlushForTesting_ResponseParams_Data* object =
      static_cast<const AudioFocusManager_FlushForTesting_ResponseParams_Data*>(data);

  return true;
}

AudioFocusManager_FlushForTesting_ResponseParams_Data::AudioFocusManager_FlushForTesting_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioFocusManagerDebug_GetDebugInfoForRequest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioFocusManagerDebug_GetDebugInfoForRequest_Params_Data* object =
      static_cast<const AudioFocusManagerDebug_GetDebugInfoForRequest_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request_id, validation_context))
    return false;

  return true;
}

AudioFocusManagerDebug_GetDebugInfoForRequest_Params_Data::AudioFocusManagerDebug_GetDebugInfoForRequest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParams_Data* object =
      static_cast<const AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->debug_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->debug_info, validation_context))
    return false;

  return true;
}

AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParams_Data::AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media_session

namespace perfetto {

// static
void TraceFormatTraits<::media_session::mojom::EnforcementMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::media_session::mojom::EnforcementMode value) {
  return std::move(context).WriteString(::media_session::mojom::EnforcementModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media_session::mojom::AudioFocusType>::WriteIntoTrace(
   perfetto::TracedValue context, ::media_session::mojom::AudioFocusType value) {
  return std::move(context).WriteString(::media_session::mojom::AudioFocusTypeToString(value));
}

} // namespace perfetto