// third_party/blink/public/mojom/buckets/bucket_manager_host.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BUCKETS_BUCKET_MANAGER_HOST_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BUCKETS_BUCKET_MANAGER_HOST_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/buckets/bucket_manager_host.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/cache_storage/cache_storage.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_error.mojom-shared.h"
#include "third_party/blink/public/mojom/indexeddb/indexeddb.mojom-shared.h"
#include "third_party/blink/public/mojom/locks/lock_manager.mojom-shared.h"
#include "third_party/blink/public/mojom/quota/quota_types.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "base/component_export.h"




namespace blink::mojom {
class BucketPoliciesDataView;



}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::BucketPoliciesDataView> {
  using Data = ::blink::mojom::internal::BucketPolicies_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class BucketError : int32_t {
  
  kUnknown = 0,
  
  kQuotaExceeded = 1,
  
  kInvalidExpiration = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, BucketError value);
inline bool IsKnownEnumValue(BucketError value) {
  return internal::BucketError_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class BucketHostInterfaceBase {};

using BucketHostPtrDataView =
    mojo::InterfacePtrDataView<BucketHostInterfaceBase>;
using BucketHostRequestDataView =
    mojo::InterfaceRequestDataView<BucketHostInterfaceBase>;
using BucketHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<BucketHostInterfaceBase>;
using BucketHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<BucketHostInterfaceBase>;
class BucketManagerHostInterfaceBase {};

using BucketManagerHostPtrDataView =
    mojo::InterfacePtrDataView<BucketManagerHostInterfaceBase>;
using BucketManagerHostRequestDataView =
    mojo::InterfaceRequestDataView<BucketManagerHostInterfaceBase>;
using BucketManagerHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<BucketManagerHostInterfaceBase>;
using BucketManagerHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<BucketManagerHostInterfaceBase>;


class BucketPoliciesDataView {
 public:
  BucketPoliciesDataView() = default;

  BucketPoliciesDataView(
      internal::BucketPolicies_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool persisted() const {
    return data_->persisted;
  }
  bool has_persisted() const {
    return data_->has_persisted;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDurability(UserType* output) const {
    auto data_value = data_->durability;
    return mojo::internal::Deserialize<::blink::mojom::BucketDurability>(
        data_value, output);
  }
  ::blink::mojom::BucketDurability durability() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::BucketDurability>(data_->durability));
  }
  bool has_durability() const {
    return data_->has_durability;
  }
  int64_t quota() const {
    return data_->quota;
  }
  bool has_quota() const {
    return data_->has_quota;
  }
  inline void GetExpiresDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExpires(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDataView, UserType>(),
    "Attempting to read the optional `expires` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadExpires` instead "
    "of `ReadExpires if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->expires.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::BucketPolicies_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

namespace std {

template <>
struct hash<::blink::mojom::BucketError>
    : public mojo::internal::EnumHashImpl<::blink::mojom::BucketError> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::BucketError, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::BucketError, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::BucketError>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::BucketPoliciesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::BucketPoliciesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::BucketPolicies_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->persisted = Traits::persisted(input);
    fragment->has_persisted = Traits::has_persisted(input);
    mojo::internal::Serialize<::blink::mojom::BucketDurability>(
        Traits::durability(input), &fragment->durability);
    fragment->has_durability = Traits::has_durability(input);
    fragment->quota = Traits::quota(input);
    fragment->has_quota = Traits::has_quota(input);
    decltype(Traits::expires(input)) in_expires = Traits::expires(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->expires)::BaseType> expires_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_expires, expires_fragment);
    fragment->expires.Set(
        expires_fragment.is_null() ? nullptr : expires_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::BucketPolicies_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::BucketPoliciesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void BucketPoliciesDataView::GetExpiresDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->expires.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::BucketError> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::BucketError value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_BUCKETS_BUCKET_MANAGER_HOST_MOJOM_SHARED_H_