// third_party/blink/public/mojom/credentialmanagement/credential_manager.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/credentialmanagement/credential_manager.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/credentialmanagement/credential_manager.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* CredentialTypeToStringHelper(CredentialType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CredentialType::EMPTY:
      return "EMPTY";
    case CredentialType::PASSWORD:
      return "PASSWORD";
    case CredentialType::FEDERATED:
      return "FEDERATED";
    default:
      return nullptr;
  }
}

std::string CredentialTypeToString(CredentialType value) {
  const char *str = CredentialTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CredentialType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CredentialType value) {
  return os << CredentialTypeToString(value);
}

NOINLINE static const char* CredentialMediationRequirementToStringHelper(CredentialMediationRequirement value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CredentialMediationRequirement::kSilent:
      return "kSilent";
    case CredentialMediationRequirement::kOptional:
      return "kOptional";
    case CredentialMediationRequirement::kRequired:
      return "kRequired";
    default:
      return nullptr;
  }
}

std::string CredentialMediationRequirementToString(CredentialMediationRequirement value) {
  const char *str = CredentialMediationRequirementToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CredentialMediationRequirement value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CredentialMediationRequirement value) {
  return os << CredentialMediationRequirementToString(value);
}

NOINLINE static const char* CredentialManagerErrorToStringHelper(CredentialManagerError value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CredentialManagerError::SUCCESS:
      return "SUCCESS";
    case CredentialManagerError::PENDING_REQUEST:
      return "PENDING_REQUEST";
    case CredentialManagerError::PASSWORD_STORE_UNAVAILABLE:
      return "PASSWORD_STORE_UNAVAILABLE";
    case CredentialManagerError::UNKNOWN:
      return "UNKNOWN";
    default:
      return nullptr;
  }
}

std::string CredentialManagerErrorToString(CredentialManagerError value) {
  const char *str = CredentialManagerErrorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CredentialManagerError value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CredentialManagerError value) {
  return os << CredentialManagerErrorToString(value);
}

namespace internal {


// static
bool CredentialInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CredentialInfo_Data* object =
      static_cast<const CredentialInfo_Data*>(data);


  if (!::blink::mojom::internal::CredentialType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icon, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->icon, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->password, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->federation, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->federation, validation_context))
    return false;

  return true;
}

CredentialInfo_Data::CredentialInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CredentialManager_Store_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CredentialManager_Store_Params_Data* object =
      static_cast<const CredentialManager_Store_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->credential, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->credential, validation_context))
    return false;

  return true;
}

CredentialManager_Store_Params_Data::CredentialManager_Store_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CredentialManager_Store_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CredentialManager_Store_ResponseParams_Data* object =
      static_cast<const CredentialManager_Store_ResponseParams_Data*>(data);

  return true;
}

CredentialManager_Store_ResponseParams_Data::CredentialManager_Store_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CredentialManager_PreventSilentAccess_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CredentialManager_PreventSilentAccess_Params_Data* object =
      static_cast<const CredentialManager_PreventSilentAccess_Params_Data*>(data);

  return true;
}

CredentialManager_PreventSilentAccess_Params_Data::CredentialManager_PreventSilentAccess_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CredentialManager_PreventSilentAccess_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CredentialManager_PreventSilentAccess_ResponseParams_Data* object =
      static_cast<const CredentialManager_PreventSilentAccess_ResponseParams_Data*>(data);

  return true;
}

CredentialManager_PreventSilentAccess_ResponseParams_Data::CredentialManager_PreventSilentAccess_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CredentialManager_Get_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CredentialManager_Get_Params_Data* object =
      static_cast<const CredentialManager_Get_Params_Data*>(data);


  if (!::blink::mojom::internal::CredentialMediationRequirement_Data
        ::Validate(object->mediation, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->federations, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& federations_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->federations, validation_context,
                                         &federations_validate_params)) {
    return false;
  }

  return true;
}

CredentialManager_Get_Params_Data::CredentialManager_Get_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CredentialManager_Get_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CredentialManager_Get_ResponseParams_Data* object =
      static_cast<const CredentialManager_Get_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::CredentialManagerError_Data
        ::Validate(object->error, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->credential, validation_context))
    return false;

  return true;
}

CredentialManager_Get_ResponseParams_Data::CredentialManager_Get_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::CredentialType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::CredentialType value) {
  return std::move(context).WriteString(::blink::mojom::CredentialTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::CredentialMediationRequirement>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::CredentialMediationRequirement value) {
  return std::move(context).WriteString(::blink::mojom::CredentialMediationRequirementToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::CredentialManagerError>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::CredentialManagerError value) {
  return std::move(context).WriteString(::blink::mojom::CredentialManagerErrorToString(value));
}

} // namespace perfetto