// components/os_crypt/async/common/encryptor.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_OS_CRYPT_ASYNC_COMMON_ENCRYPTOR_MOJOM_DATA_VIEW_H_
#define COMPONENTS_OS_CRYPT_ASYNC_COMMON_ENCRYPTOR_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "components/os_crypt/async/common/encryptor.mojom-shared-internal.h"
#include "components/os_crypt/async/common/algorithm.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"


namespace os_crypt_async::mojom {
class KeyDataView;

class EncryptorDataView;



}  // os_crypt_async::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::os_crypt_async::mojom::KeyDataView> {
  using Data = ::os_crypt_async::mojom::internal::Key_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::os_crypt_async::mojom::EncryptorDataView> {
  using Data = ::os_crypt_async::mojom::internal::Encryptor_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace os_crypt_async::mojom {


class KeyDataView {
 public:
  KeyDataView() = default;

  KeyDataView(
      internal::Key_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadAlgorithm(UserType* output) const {
    auto data_value = data_->algorithm;
    return mojo::internal::Deserialize<::os_crypt_async::mojom::Algorithm>(
        data_value, output);
  }
  ::os_crypt_async::mojom::Algorithm algorithm() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::os_crypt_async::mojom::Algorithm>(data_->algorithm));
  }
  inline void GetKeyDataView(
      ::mojo_base::mojom::UnsafeSharedMemoryRegionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKey(UserType* output) {
    
    auto* pointer = data_->key.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView>(
        pointer, output, message_);
  }
 private:
  internal::Key_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class EncryptorDataView {
 public:
  EncryptorDataView() = default;

  EncryptorDataView(
      internal::Encryptor_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetProviderForEncryptionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProviderForEncryption(UserType* output) {
    
    auto* pointer = data_->provider_for_encryption.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetKeyEntriesDataView(
      mojo::MapDataView<mojo::StringDataView, KeyDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeyEntries(UserType* output) {
    
    auto* pointer = data_->key_entries.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::os_crypt_async::mojom::KeyDataView>>(
        pointer, output, message_);
  }
 private:
  internal::Encryptor_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // os_crypt_async::mojom

#endif  // COMPONENTS_OS_CRYPT_ASYNC_COMMON_ENCRYPTOR_MOJOM_DATA_VIEW_H_