// components/printing/common/print.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PRINTING_COMMON_PRINT_MOJOM_DATA_VIEW_H_
#define COMPONENTS_PRINTING_COMMON_PRINT_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "components/printing/common/print.mojom-shared-internal.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "printing/mojom/print.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace printing::mojom {
class PreviewIdsDataView;

class RequestPrintPreviewParamsDataView;

class PrintFrameContentParamsDataView;

class OptionsFromDocumentParamsDataView;

class DidPrintContentParamsDataView;

class DidStartPreviewParamsDataView;

class DidPreviewPageParamsDataView;

class DidPreviewDocumentParamsDataView;

class PrintParamsDataView;

class PrintPagesParamsDataView;

class DidPrintDocumentParamsDataView;

class ScriptedPrintParamsDataView;

class PrintWithParamsResultDataDataView;

class PrintRenderFrame_PrintWithParams_ResponseParam_ResultDataView;


}  // printing::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::printing::mojom::PreviewIdsDataView> {
  using Data = ::printing::mojom::internal::PreviewIds_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::RequestPrintPreviewParamsDataView> {
  using Data = ::printing::mojom::internal::RequestPrintPreviewParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::PrintFrameContentParamsDataView> {
  using Data = ::printing::mojom::internal::PrintFrameContentParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::OptionsFromDocumentParamsDataView> {
  using Data = ::printing::mojom::internal::OptionsFromDocumentParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::DidPrintContentParamsDataView> {
  using Data = ::printing::mojom::internal::DidPrintContentParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::DidStartPreviewParamsDataView> {
  using Data = ::printing::mojom::internal::DidStartPreviewParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::DidPreviewPageParamsDataView> {
  using Data = ::printing::mojom::internal::DidPreviewPageParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::DidPreviewDocumentParamsDataView> {
  using Data = ::printing::mojom::internal::DidPreviewDocumentParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::PrintParamsDataView> {
  using Data = ::printing::mojom::internal::PrintParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::PrintPagesParamsDataView> {
  using Data = ::printing::mojom::internal::PrintPagesParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::DidPrintDocumentParamsDataView> {
  using Data = ::printing::mojom::internal::DidPrintDocumentParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::ScriptedPrintParamsDataView> {
  using Data = ::printing::mojom::internal::ScriptedPrintParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::PrintWithParamsResultDataDataView> {
  using Data = ::printing::mojom::internal::PrintWithParamsResultData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::PrintRenderFrame_PrintWithParams_ResponseParam_ResultDataView> {
  using Data = ::printing::mojom::internal::PrintRenderFrame_PrintWithParams_ResponseParam_Result_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace printing::mojom {


enum class PrintFailureReason : int32_t {
  
  kGeneralFailure = 0,
  
  kInvalidPageRange = 1,
  
  kPrintingInProgress = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, PrintFailureReason value);
inline bool IsKnownEnumValue(PrintFailureReason value) {
  return internal::PrintFailureReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PrintPreviewUIInterfaceBase {};

using PrintPreviewUIPtrDataView =
    mojo::InterfacePtrDataView<PrintPreviewUIInterfaceBase>;
using PrintPreviewUIRequestDataView =
    mojo::InterfaceRequestDataView<PrintPreviewUIInterfaceBase>;
using PrintPreviewUIAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PrintPreviewUIInterfaceBase>;
using PrintPreviewUIAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PrintPreviewUIInterfaceBase>;
class PrintRenderFrameInterfaceBase {};

using PrintRenderFramePtrDataView =
    mojo::InterfacePtrDataView<PrintRenderFrameInterfaceBase>;
using PrintRenderFrameRequestDataView =
    mojo::InterfaceRequestDataView<PrintRenderFrameInterfaceBase>;
using PrintRenderFrameAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PrintRenderFrameInterfaceBase>;
using PrintRenderFrameAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PrintRenderFrameInterfaceBase>;
class PrintManagerHostInterfaceBase {};

using PrintManagerHostPtrDataView =
    mojo::InterfacePtrDataView<PrintManagerHostInterfaceBase>;
using PrintManagerHostRequestDataView =
    mojo::InterfaceRequestDataView<PrintManagerHostInterfaceBase>;
using PrintManagerHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PrintManagerHostInterfaceBase>;
using PrintManagerHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PrintManagerHostInterfaceBase>;


class PreviewIdsDataView {
 public:
  PreviewIdsDataView() = default;

  PreviewIdsDataView(
      internal::PreviewIds_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t request_id() const {
    return data_->request_id;
  }
  int32_t ui_id() const {
    return data_->ui_id;
  }
 private:
  internal::PreviewIds_Data* data_ = nullptr;
};


class RequestPrintPreviewParamsDataView {
 public:
  RequestPrintPreviewParamsDataView() = default;

  RequestPrintPreviewParamsDataView(
      internal::RequestPrintPreviewParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool is_modifiable() const {
    return data_->is_modifiable;
  }
  bool webnode_only() const {
    return data_->webnode_only;
  }
  bool has_selection() const {
    return data_->has_selection;
  }
  bool selection_only() const {
    return data_->selection_only;
  }
 private:
  internal::RequestPrintPreviewParams_Data* data_ = nullptr;
};


class PrintFrameContentParamsDataView {
 public:
  PrintFrameContentParamsDataView() = default;

  PrintFrameContentParamsDataView(
      internal::PrintFrameContentParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPrintableAreaDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrintableArea(UserType* output) {
    
    auto* pointer = data_->printable_area.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  int32_t document_cookie() const {
    return data_->document_cookie;
  }
 private:
  internal::PrintFrameContentParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class OptionsFromDocumentParamsDataView {
 public:
  OptionsFromDocumentParamsDataView() = default;

  OptionsFromDocumentParamsDataView(
      internal::OptionsFromDocumentParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool is_scaling_disabled() const {
    return data_->is_scaling_disabled;
  }
  int32_t copies() const {
    return data_->copies;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDuplex(UserType* output) const {
    auto data_value = data_->duplex;
    return mojo::internal::Deserialize<::printing::mojom::DuplexMode>(
        data_value, output);
  }
  ::printing::mojom::DuplexMode duplex() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::printing::mojom::DuplexMode>(data_->duplex));
  }
 private:
  internal::OptionsFromDocumentParams_Data* data_ = nullptr;
};


class DidPrintContentParamsDataView {
 public:
  DidPrintContentParamsDataView() = default;

  DidPrintContentParamsDataView(
      internal::DidPrintContentParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMetafileDataRegionDataView(
      ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMetafileDataRegion(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView, UserType>(),
    "Attempting to read the optional `metafile_data_region` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMetafileDataRegion` instead "
    "of `ReadMetafileDataRegion if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->metafile_data_region.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
        pointer, output, message_);
  }
  inline void GetSubframeContentInfoDataView(
      mojo::MapDataView<uint32_t, ::mojo_base::mojom::UnguessableTokenDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubframeContentInfo(UserType* output) {
    
    auto* pointer = data_->subframe_content_info.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<uint32_t, ::mojo_base::mojom::UnguessableTokenDataView>>(
        pointer, output, message_);
  }
 private:
  internal::DidPrintContentParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DidStartPreviewParamsDataView {
 public:
  DidStartPreviewParamsDataView() = default;

  DidStartPreviewParamsDataView(
      internal::DidStartPreviewParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t page_count() const {
    return data_->page_count;
  }
  inline void GetPagesToRenderDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPagesToRender(UserType* output) {
    
    auto* pointer = data_->pages_to_render.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, message_);
  }
  int32_t pages_per_sheet() const {
    return data_->pages_per_sheet;
  }
  inline void GetPageSizeDataView(
      ::gfx::mojom::SizeFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPageSize(UserType* output) {
    
    auto* pointer = data_->page_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeFDataView>(
        pointer, output, message_);
  }
  int32_t fit_to_page_scaling() const {
    return data_->fit_to_page_scaling;
  }
 private:
  internal::DidStartPreviewParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DidPreviewPageParamsDataView {
 public:
  DidPreviewPageParamsDataView() = default;

  DidPreviewPageParamsDataView(
      internal::DidPreviewPageParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetContentDataView(
      DidPrintContentParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContent(UserType* output) {
    
    auto* pointer = data_->content.Get();
    return mojo::internal::Deserialize<::printing::mojom::DidPrintContentParamsDataView>(
        pointer, output, message_);
  }
  uint32_t page_index() const {
    return data_->page_index;
  }
  int32_t document_cookie() const {
    return data_->document_cookie;
  }
 private:
  internal::DidPreviewPageParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DidPreviewDocumentParamsDataView {
 public:
  DidPreviewDocumentParamsDataView() = default;

  DidPreviewDocumentParamsDataView(
      internal::DidPreviewDocumentParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetContentDataView(
      DidPrintContentParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContent(UserType* output) {
    
    auto* pointer = data_->content.Get();
    return mojo::internal::Deserialize<::printing::mojom::DidPrintContentParamsDataView>(
        pointer, output, message_);
  }
  int32_t document_cookie() const {
    return data_->document_cookie;
  }
  uint32_t expected_pages_count() const {
    return data_->expected_pages_count;
  }
 private:
  internal::DidPreviewDocumentParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PrintParamsDataView {
 public:
  PrintParamsDataView() = default;

  PrintParamsDataView(
      internal::PrintParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPageSizeDataView(
      ::gfx::mojom::SizeFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPageSize(UserType* output) {
    
    auto* pointer = data_->page_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeFDataView>(
        pointer, output, message_);
  }
  inline void GetContentSizeDataView(
      ::gfx::mojom::SizeFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentSize(UserType* output) {
    
    auto* pointer = data_->content_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeFDataView>(
        pointer, output, message_);
  }
  inline void GetPrintableAreaDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrintableArea(UserType* output) {
    
    auto* pointer = data_->printable_area.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, message_);
  }
  float margin_top() const {
    return data_->margin_top;
  }
  float margin_left() const {
    return data_->margin_left;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPageOrientation(UserType* output) const {
    auto data_value = data_->page_orientation;
    return mojo::internal::Deserialize<::printing::mojom::PageOrientation>(
        data_value, output);
  }
  ::printing::mojom::PageOrientation page_orientation() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::printing::mojom::PageOrientation>(data_->page_orientation));
  }
  inline void GetDpiDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDpi(UserType* output) {
    
    auto* pointer = data_->dpi.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  double scale_factor() const {
    return data_->scale_factor;
  }
  int32_t document_cookie() const {
    return data_->document_cookie;
  }
  bool selection_only() const {
    return data_->selection_only;
  }
  int32_t preview_ui_id() const {
    return data_->preview_ui_id;
  }
  int32_t preview_request_id() const {
    return data_->preview_request_id;
  }
  bool is_first_request() const {
    return data_->is_first_request;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPrintScalingOption(UserType* output) const {
    auto data_value = data_->print_scaling_option;
    return mojo::internal::Deserialize<::printing::mojom::PrintScalingOption>(
        data_value, output);
  }
  ::printing::mojom::PrintScalingOption print_scaling_option() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::printing::mojom::PrintScalingOption>(data_->print_scaling_option));
  }
  bool print_to_pdf() const {
    return data_->print_to_pdf;
  }
  bool display_header_footer() const {
    return data_->display_header_footer;
  }
  inline void GetTitleDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetHeaderTemplateDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeaderTemplate(UserType* output) {
    
    auto* pointer = data_->header_template.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetFooterTemplateDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFooterTemplate(UserType* output) {
    
    auto* pointer = data_->footer_template.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  bool rasterize_pdf() const {
    return data_->rasterize_pdf;
  }
  int32_t rasterize_pdf_dpi() const {
    return data_->rasterize_pdf_dpi;
  }
  bool should_print_backgrounds() const {
    return data_->should_print_backgrounds;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPrintedDocType(UserType* output) const {
    auto data_value = data_->printed_doc_type;
    return mojo::internal::Deserialize<::printing::mojom::SkiaDocumentType>(
        data_value, output);
  }
  ::printing::mojom::SkiaDocumentType printed_doc_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::printing::mojom::SkiaDocumentType>(data_->printed_doc_type));
  }
  bool prefer_css_page_size() const {
    return data_->prefer_css_page_size;
  }
  uint32_t pages_per_sheet() const {
    return data_->pages_per_sheet;
  }
  std::optional<bool> generate_tagged_pdf() const {

    return data_->generate_tagged_pdf_$flag
        ? std::make_optional(!!data_->generate_tagged_pdf_$value)
        : std::nullopt;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadGenerateDocumentOutline(UserType* output) const {
    auto data_value = data_->generate_document_outline;
    return mojo::internal::Deserialize<::printing::mojom::GenerateDocumentOutline>(
        data_value, output);
  }
  ::printing::mojom::GenerateDocumentOutline generate_document_outline() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::printing::mojom::GenerateDocumentOutline>(data_->generate_document_outline));
  }
 private:
  internal::PrintParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PrintPagesParamsDataView {
 public:
  PrintPagesParamsDataView() = default;

  PrintPagesParamsDataView(
      internal::PrintPagesParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetParamsDataView(
      PrintParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::printing::mojom::PrintParamsDataView>(
        pointer, output, message_);
  }
  inline void GetPagesDataView(
      mojo::ArrayDataView<::printing::mojom::PageRangeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPages(UserType* output) {
    
    auto* pointer = data_->pages.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::printing::mojom::PageRangeDataView>>(
        pointer, output, message_);
  }
 private:
  internal::PrintPagesParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DidPrintDocumentParamsDataView {
 public:
  DidPrintDocumentParamsDataView() = default;

  DidPrintDocumentParamsDataView(
      internal::DidPrintDocumentParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetContentDataView(
      DidPrintContentParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContent(UserType* output) {
    
    auto* pointer = data_->content.Get();
    return mojo::internal::Deserialize<::printing::mojom::DidPrintContentParamsDataView>(
        pointer, output, message_);
  }
  int32_t document_cookie() const {
    return data_->document_cookie;
  }
  inline void GetPageSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPageSize(UserType* output) {
    
    auto* pointer = data_->page_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetContentAreaDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentArea(UserType* output) {
    
    auto* pointer = data_->content_area.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetPhysicalOffsetsDataView(
      ::gfx::mojom::PointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPhysicalOffsets(UserType* output) {
    
    auto* pointer = data_->physical_offsets.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        pointer, output, message_);
  }
 private:
  internal::DidPrintDocumentParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ScriptedPrintParamsDataView {
 public:
  ScriptedPrintParamsDataView() = default;

  ScriptedPrintParamsDataView(
      internal::ScriptedPrintParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t cookie() const {
    return data_->cookie;
  }
  uint32_t expected_pages_count() const {
    return data_->expected_pages_count;
  }
  bool has_selection() const {
    return data_->has_selection;
  }
  bool is_scripted() const {
    return data_->is_scripted;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMarginType(UserType* output) const {
    auto data_value = data_->margin_type;
    return mojo::internal::Deserialize<::printing::mojom::MarginType>(
        data_value, output);
  }
  ::printing::mojom::MarginType margin_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::printing::mojom::MarginType>(data_->margin_type));
  }
 private:
  internal::ScriptedPrintParams_Data* data_ = nullptr;
};


class PrintWithParamsResultDataDataView {
 public:
  PrintWithParamsResultDataDataView() = default;

  PrintWithParamsResultDataDataView(
      internal::PrintWithParamsResultData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetParamsDataView(
      DidPrintDocumentParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::printing::mojom::DidPrintDocumentParamsDataView>(
        pointer, output, message_);
  }
  inline void GetAccessibilityTreeDataView(
      ::ax::mojom::AXTreeUpdateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAccessibilityTree(UserType* output) {
    
    auto* pointer = data_->accessibility_tree.Get();
    return mojo::internal::Deserialize<::ax::mojom::AXTreeUpdateDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadGenerateDocumentOutline(UserType* output) const {
    auto data_value = data_->generate_document_outline;
    return mojo::internal::Deserialize<::printing::mojom::GenerateDocumentOutline>(
        data_value, output);
  }
  ::printing::mojom::GenerateDocumentOutline generate_document_outline() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::printing::mojom::GenerateDocumentOutline>(data_->generate_document_outline));
  }
 private:
  internal::PrintWithParamsResultData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PrintRenderFrame_PrintWithParams_ResponseParam_ResultDataView {
 public:
  using Tag = internal::PrintRenderFrame_PrintWithParams_ResponseParam_Result_Data::PrintRenderFrame_PrintWithParams_ResponseParam_Result_Tag;

  PrintRenderFrame_PrintWithParams_ResponseParam_ResultDataView() = default;

  PrintRenderFrame_PrintWithParams_ResponseParam_ResultDataView(
      internal::PrintRenderFrame_PrintWithParams_ResponseParam_Result_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  inline void GetSuccessDataView(
      PrintWithParamsResultDataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    
    CHECK(is_success());
    return mojo::internal::Deserialize<::printing::mojom::PrintWithParamsResultDataDataView>(
        data_->data.f_success.Get(), output, message_);
  }
  bool is_failure() const { return data_->tag == Tag::kFailure; }
  template <typename UserType>
  [[nodiscard]] bool ReadFailure(UserType* output) const {
    CHECK(is_failure());
    return mojo::internal::Deserialize<::printing::mojom::PrintFailureReason>(
        data_->data.f_failure, output);
  }
  PrintFailureReason failure() const {
    CHECK(is_failure());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::printing::mojom::PrintFailureReason>(data_->data.f_failure));
  }

 private:
  internal::PrintRenderFrame_PrintWithParams_ResponseParam_Result_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // printing::mojom

#endif  // COMPONENTS_PRINTING_COMMON_PRINT_MOJOM_DATA_VIEW_H_