// components/services/unzip/public/mojom/unzipper.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_UNZIP_PUBLIC_MOJOM_UNZIPPER_MOJOM_DATA_VIEW_H_
#define COMPONENTS_SERVICES_UNZIP_PUBLIC_MOJOM_UNZIPPER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "components/services/unzip/public/mojom/unzipper.mojom-shared-internal.h"
#include "components/services/storage/public/mojom/filesystem/directory.mojom-shared.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"


namespace unzip::mojom {
class UnzipOptionsDataView;

class InfoDataView;



}  // unzip::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::unzip::mojom::UnzipOptionsDataView> {
  using Data = ::unzip::mojom::internal::UnzipOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::unzip::mojom::InfoDataView> {
  using Data = ::unzip::mojom::internal::Info_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace unzip::mojom {
// Interface base classes. They are used for type safety check.
class UnzipFilterInterfaceBase {};

using UnzipFilterPtrDataView =
    mojo::InterfacePtrDataView<UnzipFilterInterfaceBase>;
using UnzipFilterRequestDataView =
    mojo::InterfaceRequestDataView<UnzipFilterInterfaceBase>;
using UnzipFilterAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<UnzipFilterInterfaceBase>;
using UnzipFilterAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<UnzipFilterInterfaceBase>;
class UnzipListenerInterfaceBase {};

using UnzipListenerPtrDataView =
    mojo::InterfacePtrDataView<UnzipListenerInterfaceBase>;
using UnzipListenerRequestDataView =
    mojo::InterfaceRequestDataView<UnzipListenerInterfaceBase>;
using UnzipListenerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<UnzipListenerInterfaceBase>;
using UnzipListenerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<UnzipListenerInterfaceBase>;
class UnzipperInterfaceBase {};

using UnzipperPtrDataView =
    mojo::InterfacePtrDataView<UnzipperInterfaceBase>;
using UnzipperRequestDataView =
    mojo::InterfaceRequestDataView<UnzipperInterfaceBase>;
using UnzipperAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<UnzipperInterfaceBase>;
using UnzipperAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<UnzipperInterfaceBase>;


class UnzipOptionsDataView {
 public:
  UnzipOptionsDataView() = default;

  UnzipOptionsDataView(
      internal::UnzipOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetEncodingDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEncoding(UserType* output) {
    
    auto* pointer = data_->encoding.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPasswordDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPassword(UserType* output) {
    
    auto* pointer = data_->password.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::UnzipOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class InfoDataView {
 public:
  InfoDataView() = default;

  InfoDataView(
      internal::Info_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool size_is_valid() const {
    return data_->size_is_valid;
  }
  uint64_t size() const {
    return data_->size;
  }
  bool is_encrypted() const {
    return data_->is_encrypted;
  }
  bool uses_aes_encryption() const {
    return data_->uses_aes_encryption;
  }
 private:
  internal::Info_Data* data_ = nullptr;
};


}  // unzip::mojom

#endif  // COMPONENTS_SERVICES_UNZIP_PUBLIC_MOJOM_UNZIPPER_MOJOM_DATA_VIEW_H_