// content/browser/private_aggregation/private_aggregation_internals.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/browser/private_aggregation/private_aggregation_internals.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/browser/private_aggregation/private_aggregation_internals.mojom-params-data.h"
namespace private_aggregation_internals {
namespace mojom {

NOINLINE static const char* ReportStatusToStringHelper(ReportStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ReportStatus::kPending:
      return "kPending";
    case ReportStatus::kSent:
      return "kSent";
    case ReportStatus::kFailedToAssemble:
      return "kFailedToAssemble";
    case ReportStatus::kFailedToSend:
      return "kFailedToSend";
    default:
      return nullptr;
  }
}

std::string ReportStatusToString(ReportStatus value) {
  const char *str = ReportStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ReportStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ReportStatus value) {
  return os << ReportStatusToString(value);
}

namespace internal {


// static
bool AggregatableReportRequestID_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AggregatableReportRequestID_Data* object =
      static_cast<const AggregatableReportRequestID_Data*>(data);

  return true;
}

AggregatableReportRequestID_Data::AggregatableReportRequestID_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AggregatableHistogramContribution_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AggregatableHistogramContribution_Data* object =
      static_cast<const AggregatableHistogramContribution_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bucket, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bucket, validation_context))
    return false;

  return true;
}

AggregatableHistogramContribution_Data::AggregatableHistogramContribution_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebUIAggregatableReport_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebUIAggregatableReport_Data* object =
      static_cast<const WebUIAggregatableReport_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->api_identifier, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& api_identifier_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->api_identifier, validation_context,
                                         &api_identifier_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->api_version, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& api_version_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->api_version, validation_context,
                                         &api_version_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->report_url, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->report_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->contributions, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& contributions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->contributions, validation_context,
                                         &contributions_validate_params)) {
    return false;
  }


  if (!::private_aggregation_internals::mojom::internal::ReportStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->report_body, 8, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& report_body_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->report_body, validation_context,
                                         &report_body_validate_params)) {
    return false;
  }

  return true;
}

WebUIAggregatableReport_Data::WebUIAggregatableReport_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Observer_OnRequestStorageModified_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Observer_OnRequestStorageModified_Params_Data* object =
      static_cast<const Observer_OnRequestStorageModified_Params_Data*>(data);

  return true;
}

Observer_OnRequestStorageModified_Params_Data::Observer_OnRequestStorageModified_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Observer_OnReportHandled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Observer_OnReportHandled_Params_Data* object =
      static_cast<const Observer_OnReportHandled_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->report, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->report, validation_context))
    return false;

  return true;
}

Observer_OnReportHandled_Params_Data::Observer_OnReportHandled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Handler_GetReports_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Handler_GetReports_Params_Data* object =
      static_cast<const Handler_GetReports_Params_Data*>(data);

  return true;
}

Handler_GetReports_Params_Data::Handler_GetReports_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Handler_GetReports_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Handler_GetReports_ResponseParams_Data* object =
      static_cast<const Handler_GetReports_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reports, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& reports_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->reports, validation_context,
                                         &reports_validate_params)) {
    return false;
  }

  return true;
}

Handler_GetReports_ResponseParams_Data::Handler_GetReports_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Handler_SendReports_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Handler_SendReports_Params_Data* object =
      static_cast<const Handler_SendReports_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->ids, validation_context,
                                         &ids_validate_params)) {
    return false;
  }

  return true;
}

Handler_SendReports_Params_Data::Handler_SendReports_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Handler_SendReports_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Handler_SendReports_ResponseParams_Data* object =
      static_cast<const Handler_SendReports_ResponseParams_Data*>(data);

  return true;
}

Handler_SendReports_ResponseParams_Data::Handler_SendReports_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Handler_ClearStorage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Handler_ClearStorage_Params_Data* object =
      static_cast<const Handler_ClearStorage_Params_Data*>(data);

  return true;
}

Handler_ClearStorage_Params_Data::Handler_ClearStorage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Handler_ClearStorage_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Handler_ClearStorage_ResponseParams_Data* object =
      static_cast<const Handler_ClearStorage_ResponseParams_Data*>(data);

  return true;
}

Handler_ClearStorage_ResponseParams_Data::Handler_ClearStorage_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Factory_Create_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Factory_Create_Params_Data* object =
      static_cast<const Factory_Create_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Factory_Create_Params_Data::Factory_Create_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace private_aggregation_internals

namespace perfetto {

// static
void TraceFormatTraits<::private_aggregation_internals::mojom::ReportStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::private_aggregation_internals::mojom::ReportStatus value) {
  return std::move(context).WriteString(::private_aggregation_internals::mojom::ReportStatusToString(value));
}

} // namespace perfetto