// content/services/auction_worklet/public/mojom/in_progress_auction_download.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_IN_PROGRESS_AUCTION_DOWNLOAD_MOJOM_SHARED_H_
#define CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_IN_PROGRESS_AUCTION_DOWNLOAD_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/services/auction_worklet/public/mojom/in_progress_auction_download.mojom-shared-internal.h"
#include "services/network/public/mojom/url_loader.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "content/services/auction_worklet/public/mojom/in_progress_auction_download.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::InProgressAuctionDownloadDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::auction_worklet::mojom::InProgressAuctionDownloadDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::auction_worklet::mojom::internal::InProgressAuctionDownload_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in InProgressAuctionDownload struct");

    decltype(Traits::endpoints(input)) in_endpoints = Traits::endpoints(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->endpoints)::BaseType> endpoints_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::URLLoaderClientEndpointsDataView>(
      in_endpoints,
      endpoints_fragment);

    fragment->endpoints.Set(
        endpoints_fragment.is_null() ? nullptr : endpoints_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->endpoints.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null endpoints in InProgressAuctionDownload struct");

    decltype(Traits::devtools_request_id(input)) in_devtools_request_id = Traits::devtools_request_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->devtools_request_id)::BaseType> devtools_request_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_devtools_request_id,
      devtools_request_id_fragment);

    fragment->devtools_request_id.Set(
        devtools_request_id_fragment.is_null() ? nullptr : devtools_request_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->devtools_request_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null devtools_request_id in InProgressAuctionDownload struct");
  }

  static bool Deserialize(::auction_worklet::mojom::internal::InProgressAuctionDownload_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::auction_worklet::mojom::InProgressAuctionDownloadDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace auction_worklet::mojom {

inline void InProgressAuctionDownloadDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void InProgressAuctionDownloadDataView::GetEndpointsDataView(
    ::network::mojom::URLLoaderClientEndpointsDataView* output) {
  auto pointer = data_->endpoints.Get();
  *output = ::network::mojom::URLLoaderClientEndpointsDataView(pointer, message_);
}
inline void InProgressAuctionDownloadDataView::GetDevtoolsRequestIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->devtools_request_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // auction_worklet::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_IN_PROGRESS_AUCTION_DOWNLOAD_MOJOM_SHARED_H_