// content/services/auction_worklet/public/mojom/trusted_signals_cache.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/services/auction_worklet/public/mojom/trusted_signals_cache.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/services/auction_worklet/public/mojom/trusted_signals_cache.mojom-params-data.h"
#include "content/services/auction_worklet/public/mojom/trusted_signals_cache.mojom-shared-message-ids.h"

#include "content/services/auction_worklet/public/mojom/trusted_signals_cache.mojom-import-headers.h"
#include "content/services/auction_worklet/public/mojom/trusted_signals_cache.mojom-test-utils.h"


namespace auction_worklet::mojom {
TrustedSignalsCacheKey::TrustedSignalsCacheKey()
    : compression_group_token(),
      partition_id() {}

TrustedSignalsCacheKey::TrustedSignalsCacheKey(
    const ::base::UnguessableToken& compression_group_token_in,
    int32_t partition_id_in)
    : compression_group_token(std::move(compression_group_token_in)),
      partition_id(std::move(partition_id_in)) {}

TrustedSignalsCacheKey::~TrustedSignalsCacheKey() = default;

void TrustedSignalsCacheKey::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "compression_group_token"), this->compression_group_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::UnguessableToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "partition_id"), this->partition_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TrustedSignalsCacheKey::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

TrustedSignalsCacheClient::IPCStableHashFunction TrustedSignalsCacheClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::TrustedSignalsCacheClient>(message.name())) {
    case messages::TrustedSignalsCacheClient::kOnSuccess: {
      return &TrustedSignalsCacheClient::OnSuccess_Sym::IPCStableHash;
    }
    case messages::TrustedSignalsCacheClient::kOnError: {
      return &TrustedSignalsCacheClient::OnError_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* TrustedSignalsCacheClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::TrustedSignalsCacheClient>(message.name())) {
      case messages::TrustedSignalsCacheClient::kOnSuccess:
            return "Receive auction_worklet::mojom::TrustedSignalsCacheClient::OnSuccess";
      case messages::TrustedSignalsCacheClient::kOnError:
            return "Receive auction_worklet::mojom::TrustedSignalsCacheClient::OnError";
    }
  } else {
    switch (static_cast<messages::TrustedSignalsCacheClient>(message.name())) {
      case messages::TrustedSignalsCacheClient::kOnSuccess:
            return "Receive reply auction_worklet::mojom::TrustedSignalsCacheClient::OnSuccess";
      case messages::TrustedSignalsCacheClient::kOnError:
            return "Receive reply auction_worklet::mojom::TrustedSignalsCacheClient::OnError";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t TrustedSignalsCacheClient::OnSuccess_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd63d6069;  // IPCStableHash for auction_worklet::mojom::TrustedSignalsCacheClient::OnSuccess
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TrustedSignalsCacheClient::OnError_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd0b42c05;  // IPCStableHash for auction_worklet::mojom::TrustedSignalsCacheClient::OnError
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

TrustedSignalsCacheClientProxy::TrustedSignalsCacheClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TrustedSignalsCacheClientProxy::OnSuccess(
    TrustedSignalsCompressionScheme in_compression_scheme, ::mojo_base::BigBuffer in_compression_group_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send auction_worklet::mojom::TrustedSignalsCacheClient::OnSuccess", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("compression_scheme"), in_compression_scheme,
                        "<value of type TrustedSignalsCompressionScheme>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("compression_group_data"), in_compression_group_data,
                        "<value of type ::mojo_base::BigBuffer>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TrustedSignalsCacheClient::kOnSuccess), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::TrustedSignalsCacheClient_OnSuccess_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::auction_worklet::mojom::TrustedSignalsCompressionScheme>(
    in_compression_scheme,
    &params->compression_scheme);
  mojo::internal::MessageFragment<decltype(params->compression_group_data)>
      compression_group_data_fragment(params.message());
  compression_group_data_fragment.Claim(&params->compression_group_data);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_compression_group_data,
    compression_group_data_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->compression_group_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null compression_group_data in TrustedSignalsCacheClient.OnSuccess request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TrustedSignalsCacheClient::Name_);
  message.set_method_name("OnSuccess");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void TrustedSignalsCacheClientProxy::OnError(
    const std::string& in_error_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send auction_worklet::mojom::TrustedSignalsCacheClient::OnError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_message"), in_error_message,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TrustedSignalsCacheClient::kOnError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::TrustedSignalsCacheClient_OnError_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error_message)::BaseType> error_message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error_message,
    error_message_fragment);

  params->error_message.Set(
      error_message_fragment.is_null() ? nullptr : error_message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->error_message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null error_message in TrustedSignalsCacheClient.OnError request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TrustedSignalsCacheClient::Name_);
  message.set_method_name("OnError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool TrustedSignalsCacheClientStubDispatch::Accept(
    TrustedSignalsCacheClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::TrustedSignalsCacheClient>(message->header()->name)) {
    case messages::TrustedSignalsCacheClient::kOnSuccess: {
      DCHECK(message->is_serialized());
      internal::TrustedSignalsCacheClient_OnSuccess_Params_Data* params =
          reinterpret_cast<internal::TrustedSignalsCacheClient_OnSuccess_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TrustedSignalsCacheClient.0
      bool success = true;
      TrustedSignalsCompressionScheme p_compression_scheme{};
      ::mojo_base::BigBuffer p_compression_group_data{};
      TrustedSignalsCacheClient_OnSuccess_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCompressionScheme(&p_compression_scheme))
        success = false;
      if (success && !input_data_view.ReadCompressionGroupData(&p_compression_group_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TrustedSignalsCacheClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSuccess(        
        std::move(p_compression_scheme), 
        std::move(p_compression_group_data));
      return true;
    }
    case messages::TrustedSignalsCacheClient::kOnError: {
      DCHECK(message->is_serialized());
      internal::TrustedSignalsCacheClient_OnError_Params_Data* params =
          reinterpret_cast<internal::TrustedSignalsCacheClient_OnError_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TrustedSignalsCacheClient.1
      bool success = true;
      std::string p_error_message{};
      TrustedSignalsCacheClient_OnError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadErrorMessage(&p_error_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TrustedSignalsCacheClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnError(        
        std::move(p_error_message));
      return true;
    }
  }
  return false;
}

// static
bool TrustedSignalsCacheClientStubDispatch::AcceptWithResponder(
    TrustedSignalsCacheClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::TrustedSignalsCacheClient>(message->header()->name)) {
    case messages::TrustedSignalsCacheClient::kOnSuccess: {
      break;
    }
    case messages::TrustedSignalsCacheClient::kOnError: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kTrustedSignalsCacheClientValidationInfo[] = {
    {base::to_underlying(messages::TrustedSignalsCacheClient::kOnSuccess),
     { &internal::TrustedSignalsCacheClient_OnSuccess_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::TrustedSignalsCacheClient::kOnError),
     { &internal::TrustedSignalsCacheClient_OnError_Params_Data::Validate,
      nullptr /* no response */}},
};

bool TrustedSignalsCacheClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::auction_worklet::mojom::TrustedSignalsCacheClient::Name_,
    kTrustedSignalsCacheClientValidationInfo);
}

// The declaration includes the definition on other builds.

TrustedSignalsCache::IPCStableHashFunction TrustedSignalsCache::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::TrustedSignalsCache>(message.name())) {
    case messages::TrustedSignalsCache::kGetTrustedSignals: {
      return &TrustedSignalsCache::GetTrustedSignals_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* TrustedSignalsCache::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::TrustedSignalsCache>(message.name())) {
      case messages::TrustedSignalsCache::kGetTrustedSignals:
            return "Receive auction_worklet::mojom::TrustedSignalsCache::GetTrustedSignals";
    }
  } else {
    switch (static_cast<messages::TrustedSignalsCache>(message.name())) {
      case messages::TrustedSignalsCache::kGetTrustedSignals:
            return "Receive reply auction_worklet::mojom::TrustedSignalsCache::GetTrustedSignals";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t TrustedSignalsCache::GetTrustedSignals_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9465cb60;  // IPCStableHash for auction_worklet::mojom::TrustedSignalsCache::GetTrustedSignals
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

TrustedSignalsCacheProxy::TrustedSignalsCacheProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TrustedSignalsCacheProxy::GetTrustedSignals(
    const ::base::UnguessableToken& in_compression_group_token, ::mojo::PendingRemote<TrustedSignalsCacheClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send auction_worklet::mojom::TrustedSignalsCache::GetTrustedSignals", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("compression_group_token"), in_compression_group_token,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<TrustedSignalsCacheClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TrustedSignalsCache::kGetTrustedSignals), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::TrustedSignalsCache_GetTrustedSignals_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->compression_group_token)::BaseType> compression_group_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_compression_group_token,
    compression_group_token_fragment);

  params->compression_group_token.Set(
      compression_group_token_fragment.is_null() ? nullptr : compression_group_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->compression_group_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null compression_group_token in TrustedSignalsCache.GetTrustedSignals request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::auction_worklet::mojom::TrustedSignalsCacheClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in TrustedSignalsCache.GetTrustedSignals request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TrustedSignalsCache::Name_);
  message.set_method_name("GetTrustedSignals");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool TrustedSignalsCacheStubDispatch::Accept(
    TrustedSignalsCache* impl,
    mojo::Message* message) {
  switch (static_cast<messages::TrustedSignalsCache>(message->header()->name)) {
    case messages::TrustedSignalsCache::kGetTrustedSignals: {
      DCHECK(message->is_serialized());
      internal::TrustedSignalsCache_GetTrustedSignals_Params_Data* params =
          reinterpret_cast<internal::TrustedSignalsCache_GetTrustedSignals_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TrustedSignalsCache.0
      bool success = true;
      ::base::UnguessableToken p_compression_group_token{};
      ::mojo::PendingRemote<TrustedSignalsCacheClient> p_client{};
      TrustedSignalsCache_GetTrustedSignals_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCompressionGroupToken(&p_compression_group_token))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TrustedSignalsCache::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetTrustedSignals(        
        std::move(p_compression_group_token), 
        std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool TrustedSignalsCacheStubDispatch::AcceptWithResponder(
    TrustedSignalsCache* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::TrustedSignalsCache>(message->header()->name)) {
    case messages::TrustedSignalsCache::kGetTrustedSignals: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kTrustedSignalsCacheValidationInfo[] = {
    {base::to_underlying(messages::TrustedSignalsCache::kGetTrustedSignals),
     { &internal::TrustedSignalsCache_GetTrustedSignals_Params_Data::Validate,
      nullptr /* no response */}},
};

bool TrustedSignalsCacheRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::auction_worklet::mojom::TrustedSignalsCache::Name_,
    kTrustedSignalsCacheValidationInfo);
}



}  // auction_worklet::mojom


namespace mojo {


// static
bool StructTraits<::auction_worklet::mojom::TrustedSignalsCacheKey::DataView, ::auction_worklet::mojom::TrustedSignalsCacheKeyPtr>::Read(
    ::auction_worklet::mojom::TrustedSignalsCacheKey::DataView input,
    ::auction_worklet::mojom::TrustedSignalsCacheKeyPtr* output) {
  bool success = true;
  ::auction_worklet::mojom::TrustedSignalsCacheKeyPtr result(::auction_worklet::mojom::TrustedSignalsCacheKey::New());
  
      if (success && !input.ReadCompressionGroupToken(&result->compression_group_token))
        success = false;
      if (success)
        result->partition_id = input.partition_id();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace auction_worklet::mojom {


void TrustedSignalsCacheClientInterceptorForTesting::OnSuccess(TrustedSignalsCompressionScheme compression_scheme, ::mojo_base::BigBuffer compression_group_data) {
  GetForwardingInterface()->OnSuccess(
    std::move(compression_scheme)
    , 
    std::move(compression_group_data)
    );
}
void TrustedSignalsCacheClientInterceptorForTesting::OnError(const std::string& error_message) {
  GetForwardingInterface()->OnError(
    std::move(error_message)
    );
}
TrustedSignalsCacheClientAsyncWaiter::TrustedSignalsCacheClientAsyncWaiter(
    TrustedSignalsCacheClient* proxy) : proxy_(proxy) {}

TrustedSignalsCacheClientAsyncWaiter::~TrustedSignalsCacheClientAsyncWaiter() = default;





void TrustedSignalsCacheInterceptorForTesting::GetTrustedSignals(const ::base::UnguessableToken& compression_group_token, ::mojo::PendingRemote<TrustedSignalsCacheClient> client) {
  GetForwardingInterface()->GetTrustedSignals(
    std::move(compression_group_token)
    , 
    std::move(client)
    );
}
TrustedSignalsCacheAsyncWaiter::TrustedSignalsCacheAsyncWaiter(
    TrustedSignalsCache* proxy) : proxy_(proxy) {}

TrustedSignalsCacheAsyncWaiter::~TrustedSignalsCacheAsyncWaiter() = default;







}  // auction_worklet::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif