// extensions/common/mojom/event_router.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "extensions/common/mojom/event_router.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/mojom/event_router.mojom-params-data.h"
#include "extensions/common/mojom/event_router.mojom-shared-message-ids.h"

#include "extensions/common/mojom/event_router.mojom-import-headers.h"
#include "extensions/common/mojom/event_router.mojom-test-utils.h"


namespace extensions::mojom {
ServiceWorkerContext::ServiceWorkerContext()
    : scope_url(),
      version_id(),
      thread_id() {}

ServiceWorkerContext::ServiceWorkerContext(
    const ::GURL& scope_url_in,
    int64_t version_id_in,
    int32_t thread_id_in)
    : scope_url(std::move(scope_url_in)),
      version_id(std::move(version_id_in)),
      thread_id(std::move(thread_id_in)) {}

ServiceWorkerContext::~ServiceWorkerContext() = default;

void ServiceWorkerContext::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scope_url"), this->scope_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version_id"), this->version_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "thread_id"), this->thread_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ServiceWorkerContext::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
EventListener::EventListener()
    : listener_owner(),
      event_name(),
      service_worker_context(),
      filter() {}

EventListener::EventListener(
    EventListenerOwnerPtr listener_owner_in,
    const std::string& event_name_in,
    ServiceWorkerContextPtr service_worker_context_in,
    std::optional<::base::Value::Dict> filter_in)
    : listener_owner(std::move(listener_owner_in)),
      event_name(std::move(event_name_in)),
      service_worker_context(std::move(service_worker_context_in)),
      filter(std::move(filter_in)) {}

EventListener::~EventListener() = default;

void EventListener::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "listener_owner"), this->listener_owner,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type EventListenerOwnerPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "event_name"), this->event_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "service_worker_context"), this->service_worker_context,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ServiceWorkerContextPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filter"), this->filter,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::Value::Dict>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool EventListener::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
EventListenerOwnerPtr
EventListenerOwner::NewExtensionId(
    const ::extensions::ExtensionId& value) {
  return EventListenerOwnerPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kExtensionId)>,
      std::move(value));
}

EventListenerOwnerPtr
EventListenerOwner::NewListenerUrl(
    const ::GURL& value) {
  return EventListenerOwnerPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kListenerUrl)>,
      std::move(value));
}

EventListenerOwner::EventListenerOwner(
    std::in_place_index_t<static_cast<size_t>(Tag::kExtensionId)>,
    const ::extensions::ExtensionId& value)
    : tag_(Tag::kExtensionId),
      data_(std::in_place_index<static_cast<size_t>(Tag::kExtensionId)>,
            std::move(value)) {}

EventListenerOwner::EventListenerOwner(
    std::in_place_index_t<static_cast<size_t>(Tag::kListenerUrl)>,
    const ::GURL& value)
    : tag_(Tag::kListenerUrl),
      data_(std::in_place_index<static_cast<size_t>(Tag::kListenerUrl)>,
            std::move(value)) {}
EventListenerOwner::~EventListenerOwner() {
  DestroyActive();
}

void EventListenerOwner::set_extension_id(const ::extensions::ExtensionId& extension_id) {
  if (tag_ == Tag::kExtensionId) {
    data_.extension_id = std::move(extension_id);
  } else {
    DestroyActive();
    tag_ = Tag::kExtensionId;
    new (&data_.extension_id) ::extensions::ExtensionId(
        std::move(extension_id));
  }
}

void EventListenerOwner::set_listener_url(const ::GURL& listener_url) {
  if (tag_ == Tag::kListenerUrl) {
    data_.listener_url = std::move(listener_url);
  } else {
    DestroyActive();
    tag_ = Tag::kListenerUrl;
    new (&data_.listener_url) ::GURL(
        std::move(listener_url));
  }
}


EventListenerOwner::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kExtensionId)>,
    const ::extensions::ExtensionId& value)
    : extension_id(std::move(value)) {}

EventListenerOwner::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kListenerUrl)>,
    const ::GURL& value)
    : listener_url(std::move(value)) {}

void EventListenerOwner::DestroyActive() {
  switch (tag_) {

    case Tag::kExtensionId:
      std::destroy_at(&data_.extension_id);
      break;
    case Tag::kListenerUrl:
      std::destroy_at(&data_.listener_url);
      break;
  }
}

bool EventListenerOwner::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

EventRouter::IPCStableHashFunction EventRouter::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::EventRouter>(message.name())) {
    case messages::EventRouter::kAddListenerForMainThread: {
      return &EventRouter::AddListenerForMainThread_Sym::IPCStableHash;
    }
    case messages::EventRouter::kAddListenerForServiceWorker: {
      return &EventRouter::AddListenerForServiceWorker_Sym::IPCStableHash;
    }
    case messages::EventRouter::kAddLazyListenerForMainThread: {
      return &EventRouter::AddLazyListenerForMainThread_Sym::IPCStableHash;
    }
    case messages::EventRouter::kAddLazyListenerForServiceWorker: {
      return &EventRouter::AddLazyListenerForServiceWorker_Sym::IPCStableHash;
    }
    case messages::EventRouter::kAddFilteredListenerForMainThread: {
      return &EventRouter::AddFilteredListenerForMainThread_Sym::IPCStableHash;
    }
    case messages::EventRouter::kAddFilteredListenerForServiceWorker: {
      return &EventRouter::AddFilteredListenerForServiceWorker_Sym::IPCStableHash;
    }
    case messages::EventRouter::kRemoveListenerForMainThread: {
      return &EventRouter::RemoveListenerForMainThread_Sym::IPCStableHash;
    }
    case messages::EventRouter::kRemoveListenerForServiceWorker: {
      return &EventRouter::RemoveListenerForServiceWorker_Sym::IPCStableHash;
    }
    case messages::EventRouter::kRemoveLazyListenerForMainThread: {
      return &EventRouter::RemoveLazyListenerForMainThread_Sym::IPCStableHash;
    }
    case messages::EventRouter::kRemoveLazyListenerForServiceWorker: {
      return &EventRouter::RemoveLazyListenerForServiceWorker_Sym::IPCStableHash;
    }
    case messages::EventRouter::kRemoveFilteredListenerForMainThread: {
      return &EventRouter::RemoveFilteredListenerForMainThread_Sym::IPCStableHash;
    }
    case messages::EventRouter::kRemoveFilteredListenerForServiceWorker: {
      return &EventRouter::RemoveFilteredListenerForServiceWorker_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* EventRouter::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::EventRouter>(message.name())) {
      case messages::EventRouter::kAddListenerForMainThread:
            return "Receive extensions::mojom::EventRouter::AddListenerForMainThread";
      case messages::EventRouter::kAddListenerForServiceWorker:
            return "Receive extensions::mojom::EventRouter::AddListenerForServiceWorker";
      case messages::EventRouter::kAddLazyListenerForMainThread:
            return "Receive extensions::mojom::EventRouter::AddLazyListenerForMainThread";
      case messages::EventRouter::kAddLazyListenerForServiceWorker:
            return "Receive extensions::mojom::EventRouter::AddLazyListenerForServiceWorker";
      case messages::EventRouter::kAddFilteredListenerForMainThread:
            return "Receive extensions::mojom::EventRouter::AddFilteredListenerForMainThread";
      case messages::EventRouter::kAddFilteredListenerForServiceWorker:
            return "Receive extensions::mojom::EventRouter::AddFilteredListenerForServiceWorker";
      case messages::EventRouter::kRemoveListenerForMainThread:
            return "Receive extensions::mojom::EventRouter::RemoveListenerForMainThread";
      case messages::EventRouter::kRemoveListenerForServiceWorker:
            return "Receive extensions::mojom::EventRouter::RemoveListenerForServiceWorker";
      case messages::EventRouter::kRemoveLazyListenerForMainThread:
            return "Receive extensions::mojom::EventRouter::RemoveLazyListenerForMainThread";
      case messages::EventRouter::kRemoveLazyListenerForServiceWorker:
            return "Receive extensions::mojom::EventRouter::RemoveLazyListenerForServiceWorker";
      case messages::EventRouter::kRemoveFilteredListenerForMainThread:
            return "Receive extensions::mojom::EventRouter::RemoveFilteredListenerForMainThread";
      case messages::EventRouter::kRemoveFilteredListenerForServiceWorker:
            return "Receive extensions::mojom::EventRouter::RemoveFilteredListenerForServiceWorker";
    }
  } else {
    switch (static_cast<messages::EventRouter>(message.name())) {
      case messages::EventRouter::kAddListenerForMainThread:
            return "Receive reply extensions::mojom::EventRouter::AddListenerForMainThread";
      case messages::EventRouter::kAddListenerForServiceWorker:
            return "Receive reply extensions::mojom::EventRouter::AddListenerForServiceWorker";
      case messages::EventRouter::kAddLazyListenerForMainThread:
            return "Receive reply extensions::mojom::EventRouter::AddLazyListenerForMainThread";
      case messages::EventRouter::kAddLazyListenerForServiceWorker:
            return "Receive reply extensions::mojom::EventRouter::AddLazyListenerForServiceWorker";
      case messages::EventRouter::kAddFilteredListenerForMainThread:
            return "Receive reply extensions::mojom::EventRouter::AddFilteredListenerForMainThread";
      case messages::EventRouter::kAddFilteredListenerForServiceWorker:
            return "Receive reply extensions::mojom::EventRouter::AddFilteredListenerForServiceWorker";
      case messages::EventRouter::kRemoveListenerForMainThread:
            return "Receive reply extensions::mojom::EventRouter::RemoveListenerForMainThread";
      case messages::EventRouter::kRemoveListenerForServiceWorker:
            return "Receive reply extensions::mojom::EventRouter::RemoveListenerForServiceWorker";
      case messages::EventRouter::kRemoveLazyListenerForMainThread:
            return "Receive reply extensions::mojom::EventRouter::RemoveLazyListenerForMainThread";
      case messages::EventRouter::kRemoveLazyListenerForServiceWorker:
            return "Receive reply extensions::mojom::EventRouter::RemoveLazyListenerForServiceWorker";
      case messages::EventRouter::kRemoveFilteredListenerForMainThread:
            return "Receive reply extensions::mojom::EventRouter::RemoveFilteredListenerForMainThread";
      case messages::EventRouter::kRemoveFilteredListenerForServiceWorker:
            return "Receive reply extensions::mojom::EventRouter::RemoveFilteredListenerForServiceWorker";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t EventRouter::AddListenerForMainThread_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0c8e2429;  // IPCStableHash for extensions::mojom::EventRouter::AddListenerForMainThread
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t EventRouter::AddListenerForServiceWorker_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x990196a2;  // IPCStableHash for extensions::mojom::EventRouter::AddListenerForServiceWorker
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t EventRouter::AddLazyListenerForMainThread_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x315bee00;  // IPCStableHash for extensions::mojom::EventRouter::AddLazyListenerForMainThread
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t EventRouter::AddLazyListenerForServiceWorker_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x10764ce3;  // IPCStableHash for extensions::mojom::EventRouter::AddLazyListenerForServiceWorker
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t EventRouter::AddFilteredListenerForMainThread_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x60081b80;  // IPCStableHash for extensions::mojom::EventRouter::AddFilteredListenerForMainThread
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t EventRouter::AddFilteredListenerForServiceWorker_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x809ab1ab;  // IPCStableHash for extensions::mojom::EventRouter::AddFilteredListenerForServiceWorker
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t EventRouter::RemoveListenerForMainThread_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x11a9f609;  // IPCStableHash for extensions::mojom::EventRouter::RemoveListenerForMainThread
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t EventRouter::RemoveListenerForServiceWorker_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x31cd0fb0;  // IPCStableHash for extensions::mojom::EventRouter::RemoveListenerForServiceWorker
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t EventRouter::RemoveLazyListenerForMainThread_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb6cf23f9;  // IPCStableHash for extensions::mojom::EventRouter::RemoveLazyListenerForMainThread
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t EventRouter::RemoveLazyListenerForServiceWorker_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5a17babb;  // IPCStableHash for extensions::mojom::EventRouter::RemoveLazyListenerForServiceWorker
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t EventRouter::RemoveFilteredListenerForMainThread_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x10837553;  // IPCStableHash for extensions::mojom::EventRouter::RemoveFilteredListenerForMainThread
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t EventRouter::RemoveFilteredListenerForServiceWorker_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb1febddb;  // IPCStableHash for extensions::mojom::EventRouter::RemoveFilteredListenerForServiceWorker
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

EventRouterProxy::EventRouterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void EventRouterProxy::AddListenerForMainThread(
    EventListenerPtr in_event_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::EventRouter::AddListenerForMainThread", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_listener"), in_event_listener,
                        "<value of type EventListenerPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EventRouter::kAddListenerForMainThread), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::EventRouter_AddListenerForMainThread_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event_listener)::BaseType> event_listener_fragment(
          params.message());
  
  mojo::internal::Serialize<::extensions::mojom::EventListenerDataView>(
    in_event_listener,
    event_listener_fragment);

  params->event_listener.Set(
      event_listener_fragment.is_null() ? nullptr : event_listener_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event_listener.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event_listener in EventRouter.AddListenerForMainThread request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EventRouter::Name_);
  message.set_method_name("AddListenerForMainThread");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void EventRouterProxy::AddListenerForServiceWorker(
    EventListenerPtr in_event_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::EventRouter::AddListenerForServiceWorker", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_listener"), in_event_listener,
                        "<value of type EventListenerPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EventRouter::kAddListenerForServiceWorker), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::EventRouter_AddListenerForServiceWorker_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event_listener)::BaseType> event_listener_fragment(
          params.message());
  
  mojo::internal::Serialize<::extensions::mojom::EventListenerDataView>(
    in_event_listener,
    event_listener_fragment);

  params->event_listener.Set(
      event_listener_fragment.is_null() ? nullptr : event_listener_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event_listener.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event_listener in EventRouter.AddListenerForServiceWorker request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EventRouter::Name_);
  message.set_method_name("AddListenerForServiceWorker");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void EventRouterProxy::AddLazyListenerForMainThread(
    const ::extensions::ExtensionId& in_extension_id, const std::string& in_event_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::EventRouter::AddLazyListenerForMainThread", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const ::extensions::ExtensionId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_name"), in_event_name,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EventRouter::kAddLazyListenerForMainThread), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::EventRouter_AddLazyListenerForMainThread_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::extensions::mojom::ExtensionIdDataView>(
    in_extension_id,
    extension_id_fragment);

  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->extension_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null extension_id in EventRouter.AddLazyListenerForMainThread request");
  mojo::internal::MessageFragment<
      typename decltype(params->event_name)::BaseType> event_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_event_name,
    event_name_fragment);

  params->event_name.Set(
      event_name_fragment.is_null() ? nullptr : event_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event_name in EventRouter.AddLazyListenerForMainThread request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EventRouter::Name_);
  message.set_method_name("AddLazyListenerForMainThread");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void EventRouterProxy::AddLazyListenerForServiceWorker(
    const ::extensions::ExtensionId& in_extension_id, const ::GURL& in_worker_scope_url, const std::string& in_event_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::EventRouter::AddLazyListenerForServiceWorker", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const ::extensions::ExtensionId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("worker_scope_url"), in_worker_scope_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_name"), in_event_name,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EventRouter::kAddLazyListenerForServiceWorker), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::EventRouter_AddLazyListenerForServiceWorker_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::extensions::mojom::ExtensionIdDataView>(
    in_extension_id,
    extension_id_fragment);

  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->extension_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null extension_id in EventRouter.AddLazyListenerForServiceWorker request");
  mojo::internal::MessageFragment<
      typename decltype(params->worker_scope_url)::BaseType> worker_scope_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_worker_scope_url,
    worker_scope_url_fragment);

  params->worker_scope_url.Set(
      worker_scope_url_fragment.is_null() ? nullptr : worker_scope_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->worker_scope_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null worker_scope_url in EventRouter.AddLazyListenerForServiceWorker request");
  mojo::internal::MessageFragment<
      typename decltype(params->event_name)::BaseType> event_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_event_name,
    event_name_fragment);

  params->event_name.Set(
      event_name_fragment.is_null() ? nullptr : event_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event_name in EventRouter.AddLazyListenerForServiceWorker request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EventRouter::Name_);
  message.set_method_name("AddLazyListenerForServiceWorker");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void EventRouterProxy::AddFilteredListenerForMainThread(
    EventListenerOwnerPtr in_listener_owner, const std::string& in_event_name, ::base::Value::Dict in_filter, bool in_add_lazy_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::EventRouter::AddFilteredListenerForMainThread", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("listener_owner"), in_listener_owner,
                        "<value of type EventListenerOwnerPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_name"), in_event_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("filter"), in_filter,
                        "<value of type ::base::Value::Dict>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("add_lazy_listener"), in_add_lazy_listener,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EventRouter::kAddFilteredListenerForMainThread), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::EventRouter_AddFilteredListenerForMainThread_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->listener_owner)>
      listener_owner_fragment(params.message());
  listener_owner_fragment.Claim(&params->listener_owner);
  
  mojo::internal::Serialize<::extensions::mojom::EventListenerOwnerDataView>(
    in_listener_owner,
    listener_owner_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->listener_owner.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null listener_owner in EventRouter.AddFilteredListenerForMainThread request");
  mojo::internal::MessageFragment<
      typename decltype(params->event_name)::BaseType> event_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_event_name,
    event_name_fragment);

  params->event_name.Set(
      event_name_fragment.is_null() ? nullptr : event_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event_name in EventRouter.AddFilteredListenerForMainThread request");
  mojo::internal::MessageFragment<
      typename decltype(params->filter)::BaseType> filter_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
    in_filter,
    filter_fragment);

  params->filter.Set(
      filter_fragment.is_null() ? nullptr : filter_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->filter.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null filter in EventRouter.AddFilteredListenerForMainThread request");

  params->add_lazy_listener = in_add_lazy_listener;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EventRouter::Name_);
  message.set_method_name("AddFilteredListenerForMainThread");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void EventRouterProxy::AddFilteredListenerForServiceWorker(
    const ::extensions::ExtensionId& in_extension_id, const std::string& in_event_name, ServiceWorkerContextPtr in_service_worker_context, ::base::Value::Dict in_filter, bool in_add_lazy_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::EventRouter::AddFilteredListenerForServiceWorker", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const ::extensions::ExtensionId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_name"), in_event_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_context"), in_service_worker_context,
                        "<value of type ServiceWorkerContextPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("filter"), in_filter,
                        "<value of type ::base::Value::Dict>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("add_lazy_listener"), in_add_lazy_listener,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EventRouter::kAddFilteredListenerForServiceWorker), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::EventRouter_AddFilteredListenerForServiceWorker_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::extensions::mojom::ExtensionIdDataView>(
    in_extension_id,
    extension_id_fragment);

  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->extension_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null extension_id in EventRouter.AddFilteredListenerForServiceWorker request");
  mojo::internal::MessageFragment<
      typename decltype(params->event_name)::BaseType> event_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_event_name,
    event_name_fragment);

  params->event_name.Set(
      event_name_fragment.is_null() ? nullptr : event_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event_name in EventRouter.AddFilteredListenerForServiceWorker request");
  mojo::internal::MessageFragment<
      typename decltype(params->service_worker_context)::BaseType> service_worker_context_fragment(
          params.message());
  
  mojo::internal::Serialize<::extensions::mojom::ServiceWorkerContextDataView>(
    in_service_worker_context,
    service_worker_context_fragment);

  params->service_worker_context.Set(
      service_worker_context_fragment.is_null() ? nullptr : service_worker_context_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_worker_context.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_worker_context in EventRouter.AddFilteredListenerForServiceWorker request");
  mojo::internal::MessageFragment<
      typename decltype(params->filter)::BaseType> filter_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
    in_filter,
    filter_fragment);

  params->filter.Set(
      filter_fragment.is_null() ? nullptr : filter_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->filter.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null filter in EventRouter.AddFilteredListenerForServiceWorker request");

  params->add_lazy_listener = in_add_lazy_listener;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EventRouter::Name_);
  message.set_method_name("AddFilteredListenerForServiceWorker");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void EventRouterProxy::RemoveListenerForMainThread(
    EventListenerPtr in_event_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::EventRouter::RemoveListenerForMainThread", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_listener"), in_event_listener,
                        "<value of type EventListenerPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EventRouter::kRemoveListenerForMainThread), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::EventRouter_RemoveListenerForMainThread_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event_listener)::BaseType> event_listener_fragment(
          params.message());
  
  mojo::internal::Serialize<::extensions::mojom::EventListenerDataView>(
    in_event_listener,
    event_listener_fragment);

  params->event_listener.Set(
      event_listener_fragment.is_null() ? nullptr : event_listener_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event_listener.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event_listener in EventRouter.RemoveListenerForMainThread request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EventRouter::Name_);
  message.set_method_name("RemoveListenerForMainThread");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void EventRouterProxy::RemoveListenerForServiceWorker(
    EventListenerPtr in_event_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::EventRouter::RemoveListenerForServiceWorker", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_listener"), in_event_listener,
                        "<value of type EventListenerPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EventRouter::kRemoveListenerForServiceWorker), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::EventRouter_RemoveListenerForServiceWorker_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event_listener)::BaseType> event_listener_fragment(
          params.message());
  
  mojo::internal::Serialize<::extensions::mojom::EventListenerDataView>(
    in_event_listener,
    event_listener_fragment);

  params->event_listener.Set(
      event_listener_fragment.is_null() ? nullptr : event_listener_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event_listener.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event_listener in EventRouter.RemoveListenerForServiceWorker request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EventRouter::Name_);
  message.set_method_name("RemoveListenerForServiceWorker");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void EventRouterProxy::RemoveLazyListenerForMainThread(
    const ::extensions::ExtensionId& in_extension_id, const std::string& in_event_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::EventRouter::RemoveLazyListenerForMainThread", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const ::extensions::ExtensionId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_name"), in_event_name,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EventRouter::kRemoveLazyListenerForMainThread), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::EventRouter_RemoveLazyListenerForMainThread_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::extensions::mojom::ExtensionIdDataView>(
    in_extension_id,
    extension_id_fragment);

  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->extension_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null extension_id in EventRouter.RemoveLazyListenerForMainThread request");
  mojo::internal::MessageFragment<
      typename decltype(params->event_name)::BaseType> event_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_event_name,
    event_name_fragment);

  params->event_name.Set(
      event_name_fragment.is_null() ? nullptr : event_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event_name in EventRouter.RemoveLazyListenerForMainThread request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EventRouter::Name_);
  message.set_method_name("RemoveLazyListenerForMainThread");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void EventRouterProxy::RemoveLazyListenerForServiceWorker(
    const ::extensions::ExtensionId& in_extension_id, const ::GURL& in_worker_scope_url, const std::string& in_event_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::EventRouter::RemoveLazyListenerForServiceWorker", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const ::extensions::ExtensionId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("worker_scope_url"), in_worker_scope_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_name"), in_event_name,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EventRouter::kRemoveLazyListenerForServiceWorker), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::EventRouter_RemoveLazyListenerForServiceWorker_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::extensions::mojom::ExtensionIdDataView>(
    in_extension_id,
    extension_id_fragment);

  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->extension_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null extension_id in EventRouter.RemoveLazyListenerForServiceWorker request");
  mojo::internal::MessageFragment<
      typename decltype(params->worker_scope_url)::BaseType> worker_scope_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_worker_scope_url,
    worker_scope_url_fragment);

  params->worker_scope_url.Set(
      worker_scope_url_fragment.is_null() ? nullptr : worker_scope_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->worker_scope_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null worker_scope_url in EventRouter.RemoveLazyListenerForServiceWorker request");
  mojo::internal::MessageFragment<
      typename decltype(params->event_name)::BaseType> event_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_event_name,
    event_name_fragment);

  params->event_name.Set(
      event_name_fragment.is_null() ? nullptr : event_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event_name in EventRouter.RemoveLazyListenerForServiceWorker request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EventRouter::Name_);
  message.set_method_name("RemoveLazyListenerForServiceWorker");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void EventRouterProxy::RemoveFilteredListenerForMainThread(
    EventListenerOwnerPtr in_listener_owner, const std::string& in_event_name, ::base::Value::Dict in_filter, bool in_remove_lazy_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::EventRouter::RemoveFilteredListenerForMainThread", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("listener_owner"), in_listener_owner,
                        "<value of type EventListenerOwnerPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_name"), in_event_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("filter"), in_filter,
                        "<value of type ::base::Value::Dict>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remove_lazy_listener"), in_remove_lazy_listener,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EventRouter::kRemoveFilteredListenerForMainThread), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::EventRouter_RemoveFilteredListenerForMainThread_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->listener_owner)>
      listener_owner_fragment(params.message());
  listener_owner_fragment.Claim(&params->listener_owner);
  
  mojo::internal::Serialize<::extensions::mojom::EventListenerOwnerDataView>(
    in_listener_owner,
    listener_owner_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->listener_owner.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null listener_owner in EventRouter.RemoveFilteredListenerForMainThread request");
  mojo::internal::MessageFragment<
      typename decltype(params->event_name)::BaseType> event_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_event_name,
    event_name_fragment);

  params->event_name.Set(
      event_name_fragment.is_null() ? nullptr : event_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event_name in EventRouter.RemoveFilteredListenerForMainThread request");
  mojo::internal::MessageFragment<
      typename decltype(params->filter)::BaseType> filter_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
    in_filter,
    filter_fragment);

  params->filter.Set(
      filter_fragment.is_null() ? nullptr : filter_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->filter.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null filter in EventRouter.RemoveFilteredListenerForMainThread request");

  params->remove_lazy_listener = in_remove_lazy_listener;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EventRouter::Name_);
  message.set_method_name("RemoveFilteredListenerForMainThread");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void EventRouterProxy::RemoveFilteredListenerForServiceWorker(
    const ::extensions::ExtensionId& in_extension_id, const std::string& in_event_name, ServiceWorkerContextPtr in_service_worker_context, ::base::Value::Dict in_filter, bool in_remove_lazy_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::EventRouter::RemoveFilteredListenerForServiceWorker", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const ::extensions::ExtensionId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_name"), in_event_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_context"), in_service_worker_context,
                        "<value of type ServiceWorkerContextPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("filter"), in_filter,
                        "<value of type ::base::Value::Dict>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remove_lazy_listener"), in_remove_lazy_listener,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EventRouter::kRemoveFilteredListenerForServiceWorker), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::EventRouter_RemoveFilteredListenerForServiceWorker_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::extensions::mojom::ExtensionIdDataView>(
    in_extension_id,
    extension_id_fragment);

  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->extension_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null extension_id in EventRouter.RemoveFilteredListenerForServiceWorker request");
  mojo::internal::MessageFragment<
      typename decltype(params->event_name)::BaseType> event_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_event_name,
    event_name_fragment);

  params->event_name.Set(
      event_name_fragment.is_null() ? nullptr : event_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event_name in EventRouter.RemoveFilteredListenerForServiceWorker request");
  mojo::internal::MessageFragment<
      typename decltype(params->service_worker_context)::BaseType> service_worker_context_fragment(
          params.message());
  
  mojo::internal::Serialize<::extensions::mojom::ServiceWorkerContextDataView>(
    in_service_worker_context,
    service_worker_context_fragment);

  params->service_worker_context.Set(
      service_worker_context_fragment.is_null() ? nullptr : service_worker_context_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_worker_context.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_worker_context in EventRouter.RemoveFilteredListenerForServiceWorker request");
  mojo::internal::MessageFragment<
      typename decltype(params->filter)::BaseType> filter_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
    in_filter,
    filter_fragment);

  params->filter.Set(
      filter_fragment.is_null() ? nullptr : filter_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->filter.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null filter in EventRouter.RemoveFilteredListenerForServiceWorker request");

  params->remove_lazy_listener = in_remove_lazy_listener;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EventRouter::Name_);
  message.set_method_name("RemoveFilteredListenerForServiceWorker");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool EventRouterStubDispatch::Accept(
    EventRouter* impl,
    mojo::Message* message) {
  switch (static_cast<messages::EventRouter>(message->header()->name)) {
    case messages::EventRouter::kAddListenerForMainThread: {
      DCHECK(message->is_serialized());
      internal::EventRouter_AddListenerForMainThread_Params_Data* params =
          reinterpret_cast<internal::EventRouter_AddListenerForMainThread_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EventRouter.0
      bool success = true;
      EventListenerPtr p_event_listener{};
      EventRouter_AddListenerForMainThread_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEventListener(&p_event_listener))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EventRouter::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddListenerForMainThread(        
        std::move(p_event_listener));
      return true;
    }
    case messages::EventRouter::kAddListenerForServiceWorker: {
      DCHECK(message->is_serialized());
      internal::EventRouter_AddListenerForServiceWorker_Params_Data* params =
          reinterpret_cast<internal::EventRouter_AddListenerForServiceWorker_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EventRouter.1
      bool success = true;
      EventListenerPtr p_event_listener{};
      EventRouter_AddListenerForServiceWorker_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEventListener(&p_event_listener))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EventRouter::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddListenerForServiceWorker(        
        std::move(p_event_listener));
      return true;
    }
    case messages::EventRouter::kAddLazyListenerForMainThread: {
      DCHECK(message->is_serialized());
      internal::EventRouter_AddLazyListenerForMainThread_Params_Data* params =
          reinterpret_cast<internal::EventRouter_AddLazyListenerForMainThread_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EventRouter.2
      bool success = true;
      ::extensions::ExtensionId p_extension_id{};
      std::string p_event_name{};
      EventRouter_AddLazyListenerForMainThread_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (success && !input_data_view.ReadEventName(&p_event_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EventRouter::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddLazyListenerForMainThread(        
        std::move(p_extension_id), 
        std::move(p_event_name));
      return true;
    }
    case messages::EventRouter::kAddLazyListenerForServiceWorker: {
      DCHECK(message->is_serialized());
      internal::EventRouter_AddLazyListenerForServiceWorker_Params_Data* params =
          reinterpret_cast<internal::EventRouter_AddLazyListenerForServiceWorker_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EventRouter.3
      bool success = true;
      ::extensions::ExtensionId p_extension_id{};
      ::GURL p_worker_scope_url{};
      std::string p_event_name{};
      EventRouter_AddLazyListenerForServiceWorker_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (success && !input_data_view.ReadWorkerScopeUrl(&p_worker_scope_url))
        success = false;
      if (success && !input_data_view.ReadEventName(&p_event_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EventRouter::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddLazyListenerForServiceWorker(        
        std::move(p_extension_id), 
        std::move(p_worker_scope_url), 
        std::move(p_event_name));
      return true;
    }
    case messages::EventRouter::kAddFilteredListenerForMainThread: {
      DCHECK(message->is_serialized());
      internal::EventRouter_AddFilteredListenerForMainThread_Params_Data* params =
          reinterpret_cast<internal::EventRouter_AddFilteredListenerForMainThread_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EventRouter.4
      bool success = true;
      EventListenerOwnerPtr p_listener_owner{};
      std::string p_event_name{};
      ::base::Value::Dict p_filter{};
      bool p_add_lazy_listener{};
      EventRouter_AddFilteredListenerForMainThread_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadListenerOwner(&p_listener_owner))
        success = false;
      if (success && !input_data_view.ReadEventName(&p_event_name))
        success = false;
      if (success && !input_data_view.ReadFilter(&p_filter))
        success = false;
      if (success)
        p_add_lazy_listener = input_data_view.add_lazy_listener();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EventRouter::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddFilteredListenerForMainThread(        
        std::move(p_listener_owner), 
        std::move(p_event_name), 
        std::move(p_filter), 
        std::move(p_add_lazy_listener));
      return true;
    }
    case messages::EventRouter::kAddFilteredListenerForServiceWorker: {
      DCHECK(message->is_serialized());
      internal::EventRouter_AddFilteredListenerForServiceWorker_Params_Data* params =
          reinterpret_cast<internal::EventRouter_AddFilteredListenerForServiceWorker_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EventRouter.5
      bool success = true;
      ::extensions::ExtensionId p_extension_id{};
      std::string p_event_name{};
      ServiceWorkerContextPtr p_service_worker_context{};
      ::base::Value::Dict p_filter{};
      bool p_add_lazy_listener{};
      EventRouter_AddFilteredListenerForServiceWorker_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (success && !input_data_view.ReadEventName(&p_event_name))
        success = false;
      if (success && !input_data_view.ReadServiceWorkerContext(&p_service_worker_context))
        success = false;
      if (success && !input_data_view.ReadFilter(&p_filter))
        success = false;
      if (success)
        p_add_lazy_listener = input_data_view.add_lazy_listener();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EventRouter::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddFilteredListenerForServiceWorker(        
        std::move(p_extension_id), 
        std::move(p_event_name), 
        std::move(p_service_worker_context), 
        std::move(p_filter), 
        std::move(p_add_lazy_listener));
      return true;
    }
    case messages::EventRouter::kRemoveListenerForMainThread: {
      DCHECK(message->is_serialized());
      internal::EventRouter_RemoveListenerForMainThread_Params_Data* params =
          reinterpret_cast<internal::EventRouter_RemoveListenerForMainThread_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EventRouter.6
      bool success = true;
      EventListenerPtr p_event_listener{};
      EventRouter_RemoveListenerForMainThread_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEventListener(&p_event_listener))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EventRouter::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveListenerForMainThread(        
        std::move(p_event_listener));
      return true;
    }
    case messages::EventRouter::kRemoveListenerForServiceWorker: {
      DCHECK(message->is_serialized());
      internal::EventRouter_RemoveListenerForServiceWorker_Params_Data* params =
          reinterpret_cast<internal::EventRouter_RemoveListenerForServiceWorker_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EventRouter.7
      bool success = true;
      EventListenerPtr p_event_listener{};
      EventRouter_RemoveListenerForServiceWorker_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEventListener(&p_event_listener))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EventRouter::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveListenerForServiceWorker(        
        std::move(p_event_listener));
      return true;
    }
    case messages::EventRouter::kRemoveLazyListenerForMainThread: {
      DCHECK(message->is_serialized());
      internal::EventRouter_RemoveLazyListenerForMainThread_Params_Data* params =
          reinterpret_cast<internal::EventRouter_RemoveLazyListenerForMainThread_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EventRouter.8
      bool success = true;
      ::extensions::ExtensionId p_extension_id{};
      std::string p_event_name{};
      EventRouter_RemoveLazyListenerForMainThread_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (success && !input_data_view.ReadEventName(&p_event_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EventRouter::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveLazyListenerForMainThread(        
        std::move(p_extension_id), 
        std::move(p_event_name));
      return true;
    }
    case messages::EventRouter::kRemoveLazyListenerForServiceWorker: {
      DCHECK(message->is_serialized());
      internal::EventRouter_RemoveLazyListenerForServiceWorker_Params_Data* params =
          reinterpret_cast<internal::EventRouter_RemoveLazyListenerForServiceWorker_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EventRouter.9
      bool success = true;
      ::extensions::ExtensionId p_extension_id{};
      ::GURL p_worker_scope_url{};
      std::string p_event_name{};
      EventRouter_RemoveLazyListenerForServiceWorker_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (success && !input_data_view.ReadWorkerScopeUrl(&p_worker_scope_url))
        success = false;
      if (success && !input_data_view.ReadEventName(&p_event_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EventRouter::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveLazyListenerForServiceWorker(        
        std::move(p_extension_id), 
        std::move(p_worker_scope_url), 
        std::move(p_event_name));
      return true;
    }
    case messages::EventRouter::kRemoveFilteredListenerForMainThread: {
      DCHECK(message->is_serialized());
      internal::EventRouter_RemoveFilteredListenerForMainThread_Params_Data* params =
          reinterpret_cast<internal::EventRouter_RemoveFilteredListenerForMainThread_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EventRouter.10
      bool success = true;
      EventListenerOwnerPtr p_listener_owner{};
      std::string p_event_name{};
      ::base::Value::Dict p_filter{};
      bool p_remove_lazy_listener{};
      EventRouter_RemoveFilteredListenerForMainThread_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadListenerOwner(&p_listener_owner))
        success = false;
      if (success && !input_data_view.ReadEventName(&p_event_name))
        success = false;
      if (success && !input_data_view.ReadFilter(&p_filter))
        success = false;
      if (success)
        p_remove_lazy_listener = input_data_view.remove_lazy_listener();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EventRouter::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveFilteredListenerForMainThread(        
        std::move(p_listener_owner), 
        std::move(p_event_name), 
        std::move(p_filter), 
        std::move(p_remove_lazy_listener));
      return true;
    }
    case messages::EventRouter::kRemoveFilteredListenerForServiceWorker: {
      DCHECK(message->is_serialized());
      internal::EventRouter_RemoveFilteredListenerForServiceWorker_Params_Data* params =
          reinterpret_cast<internal::EventRouter_RemoveFilteredListenerForServiceWorker_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EventRouter.11
      bool success = true;
      ::extensions::ExtensionId p_extension_id{};
      std::string p_event_name{};
      ServiceWorkerContextPtr p_service_worker_context{};
      ::base::Value::Dict p_filter{};
      bool p_remove_lazy_listener{};
      EventRouter_RemoveFilteredListenerForServiceWorker_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (success && !input_data_view.ReadEventName(&p_event_name))
        success = false;
      if (success && !input_data_view.ReadServiceWorkerContext(&p_service_worker_context))
        success = false;
      if (success && !input_data_view.ReadFilter(&p_filter))
        success = false;
      if (success)
        p_remove_lazy_listener = input_data_view.remove_lazy_listener();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EventRouter::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveFilteredListenerForServiceWorker(        
        std::move(p_extension_id), 
        std::move(p_event_name), 
        std::move(p_service_worker_context), 
        std::move(p_filter), 
        std::move(p_remove_lazy_listener));
      return true;
    }
  }
  return false;
}

// static
bool EventRouterStubDispatch::AcceptWithResponder(
    EventRouter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::EventRouter>(message->header()->name)) {
    case messages::EventRouter::kAddListenerForMainThread: {
      break;
    }
    case messages::EventRouter::kAddListenerForServiceWorker: {
      break;
    }
    case messages::EventRouter::kAddLazyListenerForMainThread: {
      break;
    }
    case messages::EventRouter::kAddLazyListenerForServiceWorker: {
      break;
    }
    case messages::EventRouter::kAddFilteredListenerForMainThread: {
      break;
    }
    case messages::EventRouter::kAddFilteredListenerForServiceWorker: {
      break;
    }
    case messages::EventRouter::kRemoveListenerForMainThread: {
      break;
    }
    case messages::EventRouter::kRemoveListenerForServiceWorker: {
      break;
    }
    case messages::EventRouter::kRemoveLazyListenerForMainThread: {
      break;
    }
    case messages::EventRouter::kRemoveLazyListenerForServiceWorker: {
      break;
    }
    case messages::EventRouter::kRemoveFilteredListenerForMainThread: {
      break;
    }
    case messages::EventRouter::kRemoveFilteredListenerForServiceWorker: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kEventRouterValidationInfo[] = {
    {base::to_underlying(messages::EventRouter::kAddListenerForMainThread),
     { &internal::EventRouter_AddListenerForMainThread_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::EventRouter::kAddListenerForServiceWorker),
     { &internal::EventRouter_AddListenerForServiceWorker_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::EventRouter::kAddLazyListenerForMainThread),
     { &internal::EventRouter_AddLazyListenerForMainThread_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::EventRouter::kAddLazyListenerForServiceWorker),
     { &internal::EventRouter_AddLazyListenerForServiceWorker_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::EventRouter::kAddFilteredListenerForMainThread),
     { &internal::EventRouter_AddFilteredListenerForMainThread_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::EventRouter::kAddFilteredListenerForServiceWorker),
     { &internal::EventRouter_AddFilteredListenerForServiceWorker_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::EventRouter::kRemoveListenerForMainThread),
     { &internal::EventRouter_RemoveListenerForMainThread_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::EventRouter::kRemoveListenerForServiceWorker),
     { &internal::EventRouter_RemoveListenerForServiceWorker_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::EventRouter::kRemoveLazyListenerForMainThread),
     { &internal::EventRouter_RemoveLazyListenerForMainThread_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::EventRouter::kRemoveLazyListenerForServiceWorker),
     { &internal::EventRouter_RemoveLazyListenerForServiceWorker_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::EventRouter::kRemoveFilteredListenerForMainThread),
     { &internal::EventRouter_RemoveFilteredListenerForMainThread_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::EventRouter::kRemoveFilteredListenerForServiceWorker),
     { &internal::EventRouter_RemoveFilteredListenerForServiceWorker_Params_Data::Validate,
      nullptr /* no response */}},
};

bool EventRouterRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::extensions::mojom::EventRouter::Name_,
    kEventRouterValidationInfo);
}



}  // extensions::mojom


namespace mojo {


// static
bool StructTraits<::extensions::mojom::ServiceWorkerContext::DataView, ::extensions::mojom::ServiceWorkerContextPtr>::Read(
    ::extensions::mojom::ServiceWorkerContext::DataView input,
    ::extensions::mojom::ServiceWorkerContextPtr* output) {
  bool success = true;
  ::extensions::mojom::ServiceWorkerContextPtr result(::extensions::mojom::ServiceWorkerContext::New());
  
      if (success && !input.ReadScopeUrl(&result->scope_url))
        success = false;
      if (success)
        result->version_id = input.version_id();
      if (success)
        result->thread_id = input.thread_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::extensions::mojom::EventListener::DataView, ::extensions::mojom::EventListenerPtr>::Read(
    ::extensions::mojom::EventListener::DataView input,
    ::extensions::mojom::EventListenerPtr* output) {
  bool success = true;
  ::extensions::mojom::EventListenerPtr result(::extensions::mojom::EventListener::New());
  
      if (success && !input.ReadListenerOwner(&result->listener_owner))
        success = false;
      if (success && !input.ReadEventName(&result->event_name))
        success = false;
      if (success && !input.ReadServiceWorkerContext(&result->service_worker_context))
        success = false;
      if (success && !input.ReadFilter(&result->filter))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::extensions::mojom::EventListenerOwner::DataView, ::extensions::mojom::EventListenerOwnerPtr>::Read(
    ::extensions::mojom::EventListenerOwner::DataView input,
    ::extensions::mojom::EventListenerOwnerPtr* output) {
  using UnionType = ::extensions::mojom::EventListenerOwner;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kExtensionId: {
      ::extensions::ExtensionId result_extension_id{};
      if (!input.ReadExtensionId(&result_extension_id))
        return false;

      *output = UnionType::NewExtensionId(
          std::move(result_extension_id));
      break;
    }
    case Tag::kListenerUrl: {
      ::GURL result_listener_url{};
      if (!input.ReadListenerUrl(&result_listener_url))
        return false;

      *output = UnionType::NewListenerUrl(
          std::move(result_listener_url));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace extensions::mojom {


void EventRouterInterceptorForTesting::AddListenerForMainThread(EventListenerPtr event_listener) {
  GetForwardingInterface()->AddListenerForMainThread(
    std::move(event_listener)
    );
}
void EventRouterInterceptorForTesting::AddListenerForServiceWorker(EventListenerPtr event_listener) {
  GetForwardingInterface()->AddListenerForServiceWorker(
    std::move(event_listener)
    );
}
void EventRouterInterceptorForTesting::AddLazyListenerForMainThread(const ::extensions::ExtensionId& extension_id, const std::string& event_name) {
  GetForwardingInterface()->AddLazyListenerForMainThread(
    std::move(extension_id)
    , 
    std::move(event_name)
    );
}
void EventRouterInterceptorForTesting::AddLazyListenerForServiceWorker(const ::extensions::ExtensionId& extension_id, const ::GURL& worker_scope_url, const std::string& event_name) {
  GetForwardingInterface()->AddLazyListenerForServiceWorker(
    std::move(extension_id)
    , 
    std::move(worker_scope_url)
    , 
    std::move(event_name)
    );
}
void EventRouterInterceptorForTesting::AddFilteredListenerForMainThread(EventListenerOwnerPtr listener_owner, const std::string& event_name, ::base::Value::Dict filter, bool add_lazy_listener) {
  GetForwardingInterface()->AddFilteredListenerForMainThread(
    std::move(listener_owner)
    , 
    std::move(event_name)
    , 
    std::move(filter)
    , 
    std::move(add_lazy_listener)
    );
}
void EventRouterInterceptorForTesting::AddFilteredListenerForServiceWorker(const ::extensions::ExtensionId& extension_id, const std::string& event_name, ServiceWorkerContextPtr service_worker_context, ::base::Value::Dict filter, bool add_lazy_listener) {
  GetForwardingInterface()->AddFilteredListenerForServiceWorker(
    std::move(extension_id)
    , 
    std::move(event_name)
    , 
    std::move(service_worker_context)
    , 
    std::move(filter)
    , 
    std::move(add_lazy_listener)
    );
}
void EventRouterInterceptorForTesting::RemoveListenerForMainThread(EventListenerPtr event_listener) {
  GetForwardingInterface()->RemoveListenerForMainThread(
    std::move(event_listener)
    );
}
void EventRouterInterceptorForTesting::RemoveListenerForServiceWorker(EventListenerPtr event_listener) {
  GetForwardingInterface()->RemoveListenerForServiceWorker(
    std::move(event_listener)
    );
}
void EventRouterInterceptorForTesting::RemoveLazyListenerForMainThread(const ::extensions::ExtensionId& extension_id, const std::string& event_name) {
  GetForwardingInterface()->RemoveLazyListenerForMainThread(
    std::move(extension_id)
    , 
    std::move(event_name)
    );
}
void EventRouterInterceptorForTesting::RemoveLazyListenerForServiceWorker(const ::extensions::ExtensionId& extension_id, const ::GURL& worker_scope_url, const std::string& event_name) {
  GetForwardingInterface()->RemoveLazyListenerForServiceWorker(
    std::move(extension_id)
    , 
    std::move(worker_scope_url)
    , 
    std::move(event_name)
    );
}
void EventRouterInterceptorForTesting::RemoveFilteredListenerForMainThread(EventListenerOwnerPtr listener_owner, const std::string& event_name, ::base::Value::Dict filter, bool remove_lazy_listener) {
  GetForwardingInterface()->RemoveFilteredListenerForMainThread(
    std::move(listener_owner)
    , 
    std::move(event_name)
    , 
    std::move(filter)
    , 
    std::move(remove_lazy_listener)
    );
}
void EventRouterInterceptorForTesting::RemoveFilteredListenerForServiceWorker(const ::extensions::ExtensionId& extension_id, const std::string& event_name, ServiceWorkerContextPtr service_worker_context, ::base::Value::Dict filter, bool remove_lazy_listener) {
  GetForwardingInterface()->RemoveFilteredListenerForServiceWorker(
    std::move(extension_id)
    , 
    std::move(event_name)
    , 
    std::move(service_worker_context)
    , 
    std::move(filter)
    , 
    std::move(remove_lazy_listener)
    );
}
EventRouterAsyncWaiter::EventRouterAsyncWaiter(
    EventRouter* proxy) : proxy_(proxy) {}

EventRouterAsyncWaiter::~EventRouterAsyncWaiter() = default;







}  // extensions::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif