// gpu/ipc/common/gpu_channel.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "gpu/ipc/common/gpu_channel.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "gpu/ipc/common/gpu_channel.mojom-params-data.h"
#include "gpu/ipc/common/gpu_channel.mojom-shared-message-ids.h"

#include "gpu/ipc/common/gpu_channel.mojom-import-headers.h"
#include "gpu/ipc/common/gpu_channel.mojom-test-utils.h"


namespace gpu::mojom {
ContextCreationAttribs::ContextCreationAttribs()
    : gpu_preference(mojo::internal::ConvertEnumValue<::gl::mojom::GpuPreference, ::gl::GpuPreference>(::gl::mojom::GpuPreference::kLowPower)),
      fail_if_major_perf_caveat(false),
      lose_context_when_out_of_memory(false),
      enable_gles2_interface(true),
      enable_grcontext(false),
      enable_raster_interface(false),
      enable_gpu_rasterization(false),
      context_type(mojo::internal::ConvertEnumValue<ContextType, ::gpu::ContextType>(ContextType::kOpenGLES2)) {}

ContextCreationAttribs::ContextCreationAttribs(
    ::gl::GpuPreference gpu_preference_in,
    bool fail_if_major_perf_caveat_in,
    bool lose_context_when_out_of_memory_in,
    bool enable_gles2_interface_in,
    bool enable_grcontext_in,
    bool enable_raster_interface_in,
    bool enable_gpu_rasterization_in,
    ::gpu::ContextType context_type_in)
    : gpu_preference(std::move(gpu_preference_in)),
      fail_if_major_perf_caveat(std::move(fail_if_major_perf_caveat_in)),
      lose_context_when_out_of_memory(std::move(lose_context_when_out_of_memory_in)),
      enable_gles2_interface(std::move(enable_gles2_interface_in)),
      enable_grcontext(std::move(enable_grcontext_in)),
      enable_raster_interface(std::move(enable_raster_interface_in)),
      enable_gpu_rasterization(std::move(enable_gpu_rasterization_in)),
      context_type(std::move(context_type_in)) {}

ContextCreationAttribs::~ContextCreationAttribs() = default;

void ContextCreationAttribs::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gpu_preference"), this->gpu_preference,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gl::GpuPreference>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fail_if_major_perf_caveat"), this->fail_if_major_perf_caveat,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "lose_context_when_out_of_memory"), this->lose_context_when_out_of_memory,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_gles2_interface"), this->enable_gles2_interface,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_grcontext"), this->enable_grcontext,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_raster_interface"), this->enable_raster_interface,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_gpu_rasterization"), this->enable_gpu_rasterization,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "context_type"), this->context_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gpu::ContextType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ContextCreationAttribs::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreateCommandBufferParams::CreateCommandBufferParams()
    : share_group_id(),
      stream_id(),
      stream_priority(),
      attribs(),
      active_url(),
      label() {}

CreateCommandBufferParams::CreateCommandBufferParams(
    int32_t share_group_id_in,
    int32_t stream_id_in,
    ::gpu::SchedulingPriority stream_priority_in,
    const ::gpu::ContextCreationAttribs& attribs_in,
    const ::GURL& active_url_in,
    const std::string& label_in)
    : share_group_id(std::move(share_group_id_in)),
      stream_id(std::move(stream_id_in)),
      stream_priority(std::move(stream_priority_in)),
      attribs(std::move(attribs_in)),
      active_url(std::move(active_url_in)),
      label(std::move(label_in)) {}

CreateCommandBufferParams::~CreateCommandBufferParams() = default;

void CreateCommandBufferParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "share_group_id"), this->share_group_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stream_id"), this->stream_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stream_priority"), this->stream_priority,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gpu::SchedulingPriority>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attribs"), this->attribs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gpu::ContextCreationAttribs&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "active_url"), this->active_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CreateCommandBufferParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CommandBufferState::CommandBufferState()
    : get_offset(),
      token(),
      release_count(),
      error(),
      context_lost_reason(),
      generation(),
      set_get_buffer_count() {}

CommandBufferState::CommandBufferState(
    int32_t get_offset_in,
    int32_t token_in,
    uint64_t release_count_in,
    ::gpu::error::Error error_in,
    ::gpu::error::ContextLostReason context_lost_reason_in,
    uint32_t generation_in,
    uint32_t set_get_buffer_count_in)
    : get_offset(std::move(get_offset_in)),
      token(std::move(token_in)),
      release_count(std::move(release_count_in)),
      error(std::move(error_in)),
      context_lost_reason(std::move(context_lost_reason_in)),
      generation(std::move(generation_in)),
      set_get_buffer_count(std::move(set_get_buffer_count_in)) {}

CommandBufferState::~CommandBufferState() = default;

void CommandBufferState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "get_offset"), this->get_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "token"), this->token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "release_count"), this->release_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "error"), this->error,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gpu::error::Error>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "context_lost_reason"), this->context_lost_reason,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gpu::error::ContextLostReason>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "generation"), this->generation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "set_get_buffer_count"), this->set_get_buffer_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CommandBufferState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ScheduleImageDecodeParams::ScheduleImageDecodeParams()
    : encoded_data(),
      output_size(),
      raster_decoder_route_id(),
      transfer_cache_entry_id(),
      discardable_handle_shm_id(),
      discardable_handle_shm_offset(),
      discardable_handle_release_count(),
      target_color_space(),
      needs_mips() {}

ScheduleImageDecodeParams::ScheduleImageDecodeParams(
    std::vector<uint8_t> encoded_data_in,
    const ::gfx::Size& output_size_in,
    int32_t raster_decoder_route_id_in,
    uint32_t transfer_cache_entry_id_in,
    int32_t discardable_handle_shm_id_in,
    uint32_t discardable_handle_shm_offset_in,
    uint64_t discardable_handle_release_count_in,
    const ::gfx::ColorSpace& target_color_space_in,
    bool needs_mips_in)
    : encoded_data(std::move(encoded_data_in)),
      output_size(std::move(output_size_in)),
      raster_decoder_route_id(std::move(raster_decoder_route_id_in)),
      transfer_cache_entry_id(std::move(transfer_cache_entry_id_in)),
      discardable_handle_shm_id(std::move(discardable_handle_shm_id_in)),
      discardable_handle_shm_offset(std::move(discardable_handle_shm_offset_in)),
      discardable_handle_release_count(std::move(discardable_handle_release_count_in)),
      target_color_space(std::move(target_color_space_in)),
      needs_mips(std::move(needs_mips_in)) {}

ScheduleImageDecodeParams::~ScheduleImageDecodeParams() = default;

void ScheduleImageDecodeParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encoded_data"), this->encoded_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_size"), this->output_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "raster_decoder_route_id"), this->raster_decoder_route_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transfer_cache_entry_id"), this->transfer_cache_entry_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "discardable_handle_shm_id"), this->discardable_handle_shm_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "discardable_handle_shm_offset"), this->discardable_handle_shm_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "discardable_handle_release_count"), this->discardable_handle_release_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_color_space"), this->target_color_space,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::ColorSpace&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "needs_mips"), this->needs_mips,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ScheduleImageDecodeParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DeferredRequest::DeferredRequest()
    : params(),
      sync_token_fences(),
      release_count() {}

DeferredRequest::DeferredRequest(
    DeferredRequestParamsPtr params_in,
    std::vector<::gpu::SyncToken> sync_token_fences_in,
    uint64_t release_count_in)
    : params(std::move(params_in)),
      sync_token_fences(std::move(sync_token_fences_in)),
      release_count(std::move(release_count_in)) {}

DeferredRequest::~DeferredRequest() = default;

void DeferredRequest::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "params"), this->params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DeferredRequestParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sync_token_fences"), this->sync_token_fences,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::gpu::SyncToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "release_count"), this->release_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DeferredRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DeferredCommandBufferRequest::DeferredCommandBufferRequest()
    : routing_id(),
      params() {}

DeferredCommandBufferRequest::DeferredCommandBufferRequest(
    int32_t routing_id_in,
    DeferredCommandBufferRequestParamsPtr params_in)
    : routing_id(std::move(routing_id_in)),
      params(std::move(params_in)) {}

DeferredCommandBufferRequest::~DeferredCommandBufferRequest() = default;

void DeferredCommandBufferRequest::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "routing_id"), this->routing_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "params"), this->params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DeferredCommandBufferRequestParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DeferredCommandBufferRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AsyncFlushParams::AsyncFlushParams()
    : put_offset(),
      flush_id(),
      sync_token_fences() {}

AsyncFlushParams::AsyncFlushParams(
    int32_t put_offset_in,
    uint32_t flush_id_in,
    std::vector<::gpu::SyncToken> sync_token_fences_in)
    : put_offset(std::move(put_offset_in)),
      flush_id(std::move(flush_id_in)),
      sync_token_fences(std::move(sync_token_fences_in)) {}

AsyncFlushParams::~AsyncFlushParams() = default;

void AsyncFlushParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "put_offset"), this->put_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "flush_id"), this->flush_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sync_token_fences"), this->sync_token_fences,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::gpu::SyncToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AsyncFlushParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SharedImageInfo::SharedImageInfo()
    : meta(),
      debug_label() {}

SharedImageInfo::SharedImageInfo(
    const ::gpu::SharedImageMetadata& meta_in,
    const std::string& debug_label_in)
    : meta(std::move(meta_in)),
      debug_label(std::move(debug_label_in)) {}

SharedImageInfo::~SharedImageInfo() = default;

void SharedImageInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "meta"), this->meta,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gpu::SharedImageMetadata&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "debug_label"), this->debug_label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SharedImageInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreateSharedImageParams::CreateSharedImageParams()
    : mailbox(),
      si_info(),
      pool_id() {}

CreateSharedImageParams::CreateSharedImageParams(
    const ::gpu::Mailbox& mailbox_in,
    SharedImageInfoPtr si_info_in,
    const std::optional<::gpu::SharedImagePoolId>& pool_id_in)
    : mailbox(std::move(mailbox_in)),
      si_info(std::move(si_info_in)),
      pool_id(std::move(pool_id_in)) {}

CreateSharedImageParams::~CreateSharedImageParams() = default;

void CreateSharedImageParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mailbox"), this->mailbox,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gpu::Mailbox&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "si_info"), this->si_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SharedImageInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pool_id"), this->pool_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gpu::SharedImagePoolId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CreateSharedImageParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreateSharedImageWithDataParams::CreateSharedImageWithDataParams()
    : mailbox(),
      si_info(),
      pixel_data_offset(),
      pixel_data_size(),
      done_with_shm() {}

CreateSharedImageWithDataParams::CreateSharedImageWithDataParams(
    const ::gpu::Mailbox& mailbox_in,
    SharedImageInfoPtr si_info_in,
    uint32_t pixel_data_offset_in,
    uint32_t pixel_data_size_in,
    bool done_with_shm_in)
    : mailbox(std::move(mailbox_in)),
      si_info(std::move(si_info_in)),
      pixel_data_offset(std::move(pixel_data_offset_in)),
      pixel_data_size(std::move(pixel_data_size_in)),
      done_with_shm(std::move(done_with_shm_in)) {}

CreateSharedImageWithDataParams::~CreateSharedImageWithDataParams() = default;

void CreateSharedImageWithDataParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mailbox"), this->mailbox,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gpu::Mailbox&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "si_info"), this->si_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SharedImageInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pixel_data_offset"), this->pixel_data_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pixel_data_size"), this->pixel_data_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "done_with_shm"), this->done_with_shm,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CreateSharedImageWithDataParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreateSharedImageWithBufferParams::CreateSharedImageWithBufferParams()
    : mailbox(),
      si_info(),
      buffer_handle(),
      pool_id() {}

CreateSharedImageWithBufferParams::CreateSharedImageWithBufferParams(
    const ::gpu::Mailbox& mailbox_in,
    SharedImageInfoPtr si_info_in,
    ::gfx::GpuMemoryBufferHandle buffer_handle_in,
    const std::optional<::gpu::SharedImagePoolId>& pool_id_in)
    : mailbox(std::move(mailbox_in)),
      si_info(std::move(si_info_in)),
      buffer_handle(std::move(buffer_handle_in)),
      pool_id(std::move(pool_id_in)) {}

CreateSharedImageWithBufferParams::~CreateSharedImageWithBufferParams() = default;

void CreateSharedImageWithBufferParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mailbox"), this->mailbox,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gpu::Mailbox&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "si_info"), this->si_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SharedImageInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buffer_handle"), this->buffer_handle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gfx::GpuMemoryBufferHandle>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pool_id"), this->pool_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gpu::SharedImagePoolId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CreateSharedImageWithBufferParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
UpdateSharedImageParams::UpdateSharedImageParams()
    : mailbox(),
      in_fence_handle() {}

UpdateSharedImageParams::UpdateSharedImageParams(
    const ::gpu::Mailbox& mailbox_in,
    ::gfx::GpuFenceHandle in_fence_handle_in)
    : mailbox(std::move(mailbox_in)),
      in_fence_handle(std::move(in_fence_handle_in)) {}

UpdateSharedImageParams::~UpdateSharedImageParams() = default;

void UpdateSharedImageParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mailbox"), this->mailbox,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gpu::Mailbox&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "in_fence_handle"), this->in_fence_handle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gfx::GpuFenceHandle>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool UpdateSharedImageParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AddReferenceToSharedImageParams::AddReferenceToSharedImageParams()
    : mailbox() {}

AddReferenceToSharedImageParams::AddReferenceToSharedImageParams(
    const ::gpu::Mailbox& mailbox_in)
    : mailbox(std::move(mailbox_in)) {}

AddReferenceToSharedImageParams::~AddReferenceToSharedImageParams() = default;

void AddReferenceToSharedImageParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mailbox"), this->mailbox,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gpu::Mailbox&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AddReferenceToSharedImageParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CopyToGpuMemoryBufferParams::CopyToGpuMemoryBufferParams()
    : mailbox() {}

CopyToGpuMemoryBufferParams::CopyToGpuMemoryBufferParams(
    const ::gpu::Mailbox& mailbox_in)
    : mailbox(std::move(mailbox_in)) {}

CopyToGpuMemoryBufferParams::~CopyToGpuMemoryBufferParams() = default;

void CopyToGpuMemoryBufferParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mailbox"), this->mailbox,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gpu::Mailbox&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CopyToGpuMemoryBufferParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreateSharedImagePoolParams::CreateSharedImagePoolParams()
    : pool_id(),
      client_remote() {}

CreateSharedImagePoolParams::CreateSharedImagePoolParams(
    const ::gpu::SharedImagePoolId& pool_id_in,
    ::mojo::PendingRemote<::gpu::mojom::SharedImagePoolClientInterface> client_remote_in)
    : pool_id(std::move(pool_id_in)),
      client_remote(std::move(client_remote_in)) {}

CreateSharedImagePoolParams::~CreateSharedImagePoolParams() = default;

void CreateSharedImagePoolParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pool_id"), this->pool_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gpu::SharedImagePoolId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_remote"), this->client_remote,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::gpu::mojom::SharedImagePoolClientInterface>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CreateSharedImagePoolParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DestroySharedImagePoolParams::DestroySharedImagePoolParams()
    : pool_id() {}

DestroySharedImagePoolParams::DestroySharedImagePoolParams(
    const ::gpu::SharedImagePoolId& pool_id_in)
    : pool_id(std::move(pool_id_in)) {}

DestroySharedImagePoolParams::~DestroySharedImagePoolParams() = default;

void DestroySharedImagePoolParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pool_id"), this->pool_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gpu::SharedImagePoolId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DestroySharedImagePoolParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DeferredRequestParamsPtr
DeferredRequestParams::NewCommandBufferRequest(
    DeferredCommandBufferRequestPtr value) {
  return DeferredRequestParamsPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kCommandBufferRequest)>,
      std::move(value));
}

DeferredRequestParamsPtr
DeferredRequestParams::NewSharedImageRequest(
    DeferredSharedImageRequestPtr value) {
  return DeferredRequestParamsPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSharedImageRequest)>,
      std::move(value));
}

DeferredRequestParams::DeferredRequestParams(
    std::in_place_index_t<static_cast<size_t>(Tag::kCommandBufferRequest)>,
    DeferredCommandBufferRequestPtr value)
    : tag_(Tag::kCommandBufferRequest),
      data_(std::in_place_index<static_cast<size_t>(Tag::kCommandBufferRequest)>,
            std::move(value)) {}

DeferredRequestParams::DeferredRequestParams(
    std::in_place_index_t<static_cast<size_t>(Tag::kSharedImageRequest)>,
    DeferredSharedImageRequestPtr value)
    : tag_(Tag::kSharedImageRequest),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSharedImageRequest)>,
            std::move(value)) {}
DeferredRequestParams::~DeferredRequestParams() {
  DestroyActive();
}

void DeferredRequestParams::set_command_buffer_request(DeferredCommandBufferRequestPtr command_buffer_request) {
  if (tag_ == Tag::kCommandBufferRequest) {
    data_.command_buffer_request = std::move(command_buffer_request);
  } else {
    DestroyActive();
    tag_ = Tag::kCommandBufferRequest;
    new (&data_.command_buffer_request) DeferredCommandBufferRequestPtr(
        std::move(command_buffer_request));
  }
}

void DeferredRequestParams::set_shared_image_request(DeferredSharedImageRequestPtr shared_image_request) {
  if (tag_ == Tag::kSharedImageRequest) {
    data_.shared_image_request = std::move(shared_image_request);
  } else {
    DestroyActive();
    tag_ = Tag::kSharedImageRequest;
    new (&data_.shared_image_request) DeferredSharedImageRequestPtr(
        std::move(shared_image_request));
  }
}


DeferredRequestParams::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kCommandBufferRequest)>,
    DeferredCommandBufferRequestPtr value)
    : command_buffer_request(std::move(value)) {}

DeferredRequestParams::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSharedImageRequest)>,
    DeferredSharedImageRequestPtr value)
    : shared_image_request(std::move(value)) {}

void DeferredRequestParams::DestroyActive() {
  switch (tag_) {

    case Tag::kCommandBufferRequest:
      std::destroy_at(&data_.command_buffer_request);
      break;
    case Tag::kSharedImageRequest:
      std::destroy_at(&data_.shared_image_request);
      break;
  }
}

bool DeferredRequestParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
DeferredCommandBufferRequestParamsPtr
DeferredCommandBufferRequestParams::NewAsyncFlush(
    AsyncFlushParamsPtr value) {
  return DeferredCommandBufferRequestParamsPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kAsyncFlush)>,
      std::move(value));
}

DeferredCommandBufferRequestParamsPtr
DeferredCommandBufferRequestParams::NewDestroyTransferBuffer(
    int32_t value) {
  return DeferredCommandBufferRequestParamsPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kDestroyTransferBuffer)>,
      std::move(value));
}

DeferredCommandBufferRequestParams::DeferredCommandBufferRequestParams(
    std::in_place_index_t<static_cast<size_t>(Tag::kAsyncFlush)>,
    AsyncFlushParamsPtr value)
    : tag_(Tag::kAsyncFlush),
      data_(std::in_place_index<static_cast<size_t>(Tag::kAsyncFlush)>,
            std::move(value)) {}

DeferredCommandBufferRequestParams::DeferredCommandBufferRequestParams(
    std::in_place_index_t<static_cast<size_t>(Tag::kDestroyTransferBuffer)>,
    int32_t value)
    : tag_(Tag::kDestroyTransferBuffer),
      data_(std::in_place_index<static_cast<size_t>(Tag::kDestroyTransferBuffer)>,
            std::move(value)) {}
DeferredCommandBufferRequestParams::~DeferredCommandBufferRequestParams() {
  DestroyActive();
}

void DeferredCommandBufferRequestParams::set_async_flush(AsyncFlushParamsPtr async_flush) {
  if (tag_ == Tag::kAsyncFlush) {
    data_.async_flush = std::move(async_flush);
  } else {
    DestroyActive();
    tag_ = Tag::kAsyncFlush;
    new (&data_.async_flush) AsyncFlushParamsPtr(
        std::move(async_flush));
  }
}

void DeferredCommandBufferRequestParams::set_destroy_transfer_buffer(int32_t destroy_transfer_buffer) {
  if (tag_ != Tag::kDestroyTransferBuffer) {
    DestroyActive();
    tag_ = Tag::kDestroyTransferBuffer;
  }
  data_.destroy_transfer_buffer = destroy_transfer_buffer;
}


DeferredCommandBufferRequestParams::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kAsyncFlush)>,
    AsyncFlushParamsPtr value)
    : async_flush(std::move(value)) {}

DeferredCommandBufferRequestParams::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kDestroyTransferBuffer)>,
    int32_t value)
    : destroy_transfer_buffer(std::move(value)) {}

void DeferredCommandBufferRequestParams::DestroyActive() {
  switch (tag_) {

    case Tag::kAsyncFlush:
      std::destroy_at(&data_.async_flush);
      break;
    case Tag::kDestroyTransferBuffer:
      std::destroy_at(&data_.destroy_transfer_buffer);
      break;
  }
}

bool DeferredCommandBufferRequestParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
DeferredSharedImageRequestPtr
DeferredSharedImageRequest::NewNop(
    uint8_t value) {
  return DeferredSharedImageRequestPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kNop)>,
      std::move(value));
}

DeferredSharedImageRequestPtr
DeferredSharedImageRequest::NewCreateSharedImage(
    CreateSharedImageParamsPtr value) {
  return DeferredSharedImageRequestPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kCreateSharedImage)>,
      std::move(value));
}

DeferredSharedImageRequestPtr
DeferredSharedImageRequest::NewCreateSharedImageWithData(
    CreateSharedImageWithDataParamsPtr value) {
  return DeferredSharedImageRequestPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kCreateSharedImageWithData)>,
      std::move(value));
}

DeferredSharedImageRequestPtr
DeferredSharedImageRequest::NewCreateSharedImageWithBuffer(
    CreateSharedImageWithBufferParamsPtr value) {
  return DeferredSharedImageRequestPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kCreateSharedImageWithBuffer)>,
      std::move(value));
}

DeferredSharedImageRequestPtr
DeferredSharedImageRequest::NewRegisterUploadBuffer(
    ::base::ReadOnlySharedMemoryRegion value) {
  return DeferredSharedImageRequestPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kRegisterUploadBuffer)>,
      std::move(value));
}

DeferredSharedImageRequestPtr
DeferredSharedImageRequest::NewUpdateSharedImage(
    UpdateSharedImageParamsPtr value) {
  return DeferredSharedImageRequestPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kUpdateSharedImage)>,
      std::move(value));
}

DeferredSharedImageRequestPtr
DeferredSharedImageRequest::NewCopyToGpuMemoryBuffer(
    CopyToGpuMemoryBufferParamsPtr value) {
  return DeferredSharedImageRequestPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kCopyToGpuMemoryBuffer)>,
      std::move(value));
}

DeferredSharedImageRequestPtr
DeferredSharedImageRequest::NewDestroySharedImage(
    const ::gpu::Mailbox& value) {
  return DeferredSharedImageRequestPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kDestroySharedImage)>,
      std::move(value));
}

DeferredSharedImageRequestPtr
DeferredSharedImageRequest::NewAddReferenceToSharedImage(
    AddReferenceToSharedImageParamsPtr value) {
  return DeferredSharedImageRequestPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kAddReferenceToSharedImage)>,
      std::move(value));
}

DeferredSharedImageRequestPtr
DeferredSharedImageRequest::NewCreateSharedImagePool(
    CreateSharedImagePoolParamsPtr value) {
  return DeferredSharedImageRequestPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kCreateSharedImagePool)>,
      std::move(value));
}

DeferredSharedImageRequestPtr
DeferredSharedImageRequest::NewDestroySharedImagePool(
    DestroySharedImagePoolParamsPtr value) {
  return DeferredSharedImageRequestPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kDestroySharedImagePool)>,
      std::move(value));
}

DeferredSharedImageRequest::DeferredSharedImageRequest(
    std::in_place_index_t<static_cast<size_t>(Tag::kNop)>,
    uint8_t value)
    : tag_(Tag::kNop),
      data_(std::in_place_index<static_cast<size_t>(Tag::kNop)>,
            std::move(value)) {}

DeferredSharedImageRequest::DeferredSharedImageRequest(
    std::in_place_index_t<static_cast<size_t>(Tag::kCreateSharedImage)>,
    CreateSharedImageParamsPtr value)
    : tag_(Tag::kCreateSharedImage),
      data_(std::in_place_index<static_cast<size_t>(Tag::kCreateSharedImage)>,
            std::move(value)) {}

DeferredSharedImageRequest::DeferredSharedImageRequest(
    std::in_place_index_t<static_cast<size_t>(Tag::kCreateSharedImageWithData)>,
    CreateSharedImageWithDataParamsPtr value)
    : tag_(Tag::kCreateSharedImageWithData),
      data_(std::in_place_index<static_cast<size_t>(Tag::kCreateSharedImageWithData)>,
            std::move(value)) {}

DeferredSharedImageRequest::DeferredSharedImageRequest(
    std::in_place_index_t<static_cast<size_t>(Tag::kCreateSharedImageWithBuffer)>,
    CreateSharedImageWithBufferParamsPtr value)
    : tag_(Tag::kCreateSharedImageWithBuffer),
      data_(std::in_place_index<static_cast<size_t>(Tag::kCreateSharedImageWithBuffer)>,
            std::move(value)) {}

DeferredSharedImageRequest::DeferredSharedImageRequest(
    std::in_place_index_t<static_cast<size_t>(Tag::kRegisterUploadBuffer)>,
    ::base::ReadOnlySharedMemoryRegion value)
    : tag_(Tag::kRegisterUploadBuffer),
      data_(std::in_place_index<static_cast<size_t>(Tag::kRegisterUploadBuffer)>,
            std::move(value)) {}

DeferredSharedImageRequest::DeferredSharedImageRequest(
    std::in_place_index_t<static_cast<size_t>(Tag::kUpdateSharedImage)>,
    UpdateSharedImageParamsPtr value)
    : tag_(Tag::kUpdateSharedImage),
      data_(std::in_place_index<static_cast<size_t>(Tag::kUpdateSharedImage)>,
            std::move(value)) {}

DeferredSharedImageRequest::DeferredSharedImageRequest(
    std::in_place_index_t<static_cast<size_t>(Tag::kCopyToGpuMemoryBuffer)>,
    CopyToGpuMemoryBufferParamsPtr value)
    : tag_(Tag::kCopyToGpuMemoryBuffer),
      data_(std::in_place_index<static_cast<size_t>(Tag::kCopyToGpuMemoryBuffer)>,
            std::move(value)) {}

DeferredSharedImageRequest::DeferredSharedImageRequest(
    std::in_place_index_t<static_cast<size_t>(Tag::kDestroySharedImage)>,
    const ::gpu::Mailbox& value)
    : tag_(Tag::kDestroySharedImage),
      data_(std::in_place_index<static_cast<size_t>(Tag::kDestroySharedImage)>,
            std::move(value)) {}

DeferredSharedImageRequest::DeferredSharedImageRequest(
    std::in_place_index_t<static_cast<size_t>(Tag::kAddReferenceToSharedImage)>,
    AddReferenceToSharedImageParamsPtr value)
    : tag_(Tag::kAddReferenceToSharedImage),
      data_(std::in_place_index<static_cast<size_t>(Tag::kAddReferenceToSharedImage)>,
            std::move(value)) {}

DeferredSharedImageRequest::DeferredSharedImageRequest(
    std::in_place_index_t<static_cast<size_t>(Tag::kCreateSharedImagePool)>,
    CreateSharedImagePoolParamsPtr value)
    : tag_(Tag::kCreateSharedImagePool),
      data_(std::in_place_index<static_cast<size_t>(Tag::kCreateSharedImagePool)>,
            std::move(value)) {}

DeferredSharedImageRequest::DeferredSharedImageRequest(
    std::in_place_index_t<static_cast<size_t>(Tag::kDestroySharedImagePool)>,
    DestroySharedImagePoolParamsPtr value)
    : tag_(Tag::kDestroySharedImagePool),
      data_(std::in_place_index<static_cast<size_t>(Tag::kDestroySharedImagePool)>,
            std::move(value)) {}
DeferredSharedImageRequest::~DeferredSharedImageRequest() {
  DestroyActive();
}

void DeferredSharedImageRequest::set_nop(uint8_t nop) {
  if (tag_ != Tag::kNop) {
    DestroyActive();
    tag_ = Tag::kNop;
  }
  data_.nop = nop;
}

void DeferredSharedImageRequest::set_create_shared_image(CreateSharedImageParamsPtr create_shared_image) {
  if (tag_ == Tag::kCreateSharedImage) {
    data_.create_shared_image = std::move(create_shared_image);
  } else {
    DestroyActive();
    tag_ = Tag::kCreateSharedImage;
    new (&data_.create_shared_image) CreateSharedImageParamsPtr(
        std::move(create_shared_image));
  }
}

void DeferredSharedImageRequest::set_create_shared_image_with_data(CreateSharedImageWithDataParamsPtr create_shared_image_with_data) {
  if (tag_ == Tag::kCreateSharedImageWithData) {
    data_.create_shared_image_with_data = std::move(create_shared_image_with_data);
  } else {
    DestroyActive();
    tag_ = Tag::kCreateSharedImageWithData;
    new (&data_.create_shared_image_with_data) CreateSharedImageWithDataParamsPtr(
        std::move(create_shared_image_with_data));
  }
}

void DeferredSharedImageRequest::set_create_shared_image_with_buffer(CreateSharedImageWithBufferParamsPtr create_shared_image_with_buffer) {
  if (tag_ == Tag::kCreateSharedImageWithBuffer) {
    data_.create_shared_image_with_buffer = std::move(create_shared_image_with_buffer);
  } else {
    DestroyActive();
    tag_ = Tag::kCreateSharedImageWithBuffer;
    new (&data_.create_shared_image_with_buffer) CreateSharedImageWithBufferParamsPtr(
        std::move(create_shared_image_with_buffer));
  }
}

void DeferredSharedImageRequest::set_register_upload_buffer(::base::ReadOnlySharedMemoryRegion register_upload_buffer) {
  if (tag_ == Tag::kRegisterUploadBuffer) {
    data_.register_upload_buffer = std::move(register_upload_buffer);
  } else {
    DestroyActive();
    tag_ = Tag::kRegisterUploadBuffer;
    new (&data_.register_upload_buffer) ::base::ReadOnlySharedMemoryRegion(
        std::move(register_upload_buffer));
  }
}

void DeferredSharedImageRequest::set_update_shared_image(UpdateSharedImageParamsPtr update_shared_image) {
  if (tag_ == Tag::kUpdateSharedImage) {
    data_.update_shared_image = std::move(update_shared_image);
  } else {
    DestroyActive();
    tag_ = Tag::kUpdateSharedImage;
    new (&data_.update_shared_image) UpdateSharedImageParamsPtr(
        std::move(update_shared_image));
  }
}

void DeferredSharedImageRequest::set_copy_to_gpu_memory_buffer(CopyToGpuMemoryBufferParamsPtr copy_to_gpu_memory_buffer) {
  if (tag_ == Tag::kCopyToGpuMemoryBuffer) {
    data_.copy_to_gpu_memory_buffer = std::move(copy_to_gpu_memory_buffer);
  } else {
    DestroyActive();
    tag_ = Tag::kCopyToGpuMemoryBuffer;
    new (&data_.copy_to_gpu_memory_buffer) CopyToGpuMemoryBufferParamsPtr(
        std::move(copy_to_gpu_memory_buffer));
  }
}

void DeferredSharedImageRequest::set_destroy_shared_image(const ::gpu::Mailbox& destroy_shared_image) {
  if (tag_ == Tag::kDestroySharedImage) {
    data_.destroy_shared_image = std::move(destroy_shared_image);
  } else {
    DestroyActive();
    tag_ = Tag::kDestroySharedImage;
    new (&data_.destroy_shared_image) ::gpu::Mailbox(
        std::move(destroy_shared_image));
  }
}

void DeferredSharedImageRequest::set_add_reference_to_shared_image(AddReferenceToSharedImageParamsPtr add_reference_to_shared_image) {
  if (tag_ == Tag::kAddReferenceToSharedImage) {
    data_.add_reference_to_shared_image = std::move(add_reference_to_shared_image);
  } else {
    DestroyActive();
    tag_ = Tag::kAddReferenceToSharedImage;
    new (&data_.add_reference_to_shared_image) AddReferenceToSharedImageParamsPtr(
        std::move(add_reference_to_shared_image));
  }
}

void DeferredSharedImageRequest::set_create_shared_image_pool(CreateSharedImagePoolParamsPtr create_shared_image_pool) {
  if (tag_ == Tag::kCreateSharedImagePool) {
    data_.create_shared_image_pool = std::move(create_shared_image_pool);
  } else {
    DestroyActive();
    tag_ = Tag::kCreateSharedImagePool;
    new (&data_.create_shared_image_pool) CreateSharedImagePoolParamsPtr(
        std::move(create_shared_image_pool));
  }
}

void DeferredSharedImageRequest::set_destroy_shared_image_pool(DestroySharedImagePoolParamsPtr destroy_shared_image_pool) {
  if (tag_ == Tag::kDestroySharedImagePool) {
    data_.destroy_shared_image_pool = std::move(destroy_shared_image_pool);
  } else {
    DestroyActive();
    tag_ = Tag::kDestroySharedImagePool;
    new (&data_.destroy_shared_image_pool) DestroySharedImagePoolParamsPtr(
        std::move(destroy_shared_image_pool));
  }
}


DeferredSharedImageRequest::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kNop)>,
    uint8_t value)
    : nop(std::move(value)) {}

DeferredSharedImageRequest::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kCreateSharedImage)>,
    CreateSharedImageParamsPtr value)
    : create_shared_image(std::move(value)) {}

DeferredSharedImageRequest::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kCreateSharedImageWithData)>,
    CreateSharedImageWithDataParamsPtr value)
    : create_shared_image_with_data(std::move(value)) {}

DeferredSharedImageRequest::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kCreateSharedImageWithBuffer)>,
    CreateSharedImageWithBufferParamsPtr value)
    : create_shared_image_with_buffer(std::move(value)) {}

DeferredSharedImageRequest::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kRegisterUploadBuffer)>,
    ::base::ReadOnlySharedMemoryRegion value)
    : register_upload_buffer(std::move(value)) {}

DeferredSharedImageRequest::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kUpdateSharedImage)>,
    UpdateSharedImageParamsPtr value)
    : update_shared_image(std::move(value)) {}

DeferredSharedImageRequest::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kCopyToGpuMemoryBuffer)>,
    CopyToGpuMemoryBufferParamsPtr value)
    : copy_to_gpu_memory_buffer(std::move(value)) {}

DeferredSharedImageRequest::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kDestroySharedImage)>,
    const ::gpu::Mailbox& value)
    : destroy_shared_image(std::move(value)) {}

DeferredSharedImageRequest::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kAddReferenceToSharedImage)>,
    AddReferenceToSharedImageParamsPtr value)
    : add_reference_to_shared_image(std::move(value)) {}

DeferredSharedImageRequest::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kCreateSharedImagePool)>,
    CreateSharedImagePoolParamsPtr value)
    : create_shared_image_pool(std::move(value)) {}

DeferredSharedImageRequest::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kDestroySharedImagePool)>,
    DestroySharedImagePoolParamsPtr value)
    : destroy_shared_image_pool(std::move(value)) {}

void DeferredSharedImageRequest::DestroyActive() {
  switch (tag_) {

    case Tag::kNop:
      std::destroy_at(&data_.nop);
      break;
    case Tag::kCreateSharedImage:
      std::destroy_at(&data_.create_shared_image);
      break;
    case Tag::kCreateSharedImageWithData:
      std::destroy_at(&data_.create_shared_image_with_data);
      break;
    case Tag::kCreateSharedImageWithBuffer:
      std::destroy_at(&data_.create_shared_image_with_buffer);
      break;
    case Tag::kRegisterUploadBuffer:
      std::destroy_at(&data_.register_upload_buffer);
      break;
    case Tag::kUpdateSharedImage:
      std::destroy_at(&data_.update_shared_image);
      break;
    case Tag::kCopyToGpuMemoryBuffer:
      std::destroy_at(&data_.copy_to_gpu_memory_buffer);
      break;
    case Tag::kDestroySharedImage:
      std::destroy_at(&data_.destroy_shared_image);
      break;
    case Tag::kAddReferenceToSharedImage:
      std::destroy_at(&data_.add_reference_to_shared_image);
      break;
    case Tag::kCreateSharedImagePool:
      std::destroy_at(&data_.create_shared_image_pool);
      break;
    case Tag::kDestroySharedImagePool:
      std::destroy_at(&data_.destroy_shared_image_pool);
      break;
  }
}

bool DeferredSharedImageRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

GpuChannel::IPCStableHashFunction GpuChannel::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::GpuChannel>(message.name())) {
    case messages::GpuChannel::kCrashForTesting: {
      return &GpuChannel::CrashForTesting_Sym::IPCStableHash;
    }
    case messages::GpuChannel::kTerminateForTesting: {
      return &GpuChannel::TerminateForTesting_Sym::IPCStableHash;
    }
    case messages::GpuChannel::kGetChannelToken: {
      return &GpuChannel::GetChannelToken_Sym::IPCStableHash;
    }
    case messages::GpuChannel::kFlush: {
      return &GpuChannel::Flush_Sym::IPCStableHash;
    }
    case messages::GpuChannel::kGetSharedMemoryForFlushId: {
      return &GpuChannel::GetSharedMemoryForFlushId_Sym::IPCStableHash;
    }
    case messages::GpuChannel::kCreateCommandBuffer: {
      return &GpuChannel::CreateCommandBuffer_Sym::IPCStableHash;
    }
    case messages::GpuChannel::kDestroyCommandBuffer: {
      return &GpuChannel::DestroyCommandBuffer_Sym::IPCStableHash;
    }
    case messages::GpuChannel::kScheduleImageDecode: {
      return &GpuChannel::ScheduleImageDecode_Sym::IPCStableHash;
    }
    case messages::GpuChannel::kFlushDeferredRequests: {
      return &GpuChannel::FlushDeferredRequests_Sym::IPCStableHash;
    }
    case messages::GpuChannel::kCreateGpuMemoryBuffer: {
      return &GpuChannel::CreateGpuMemoryBuffer_Sym::IPCStableHash;
    }
    case messages::GpuChannel::kWaitForTokenInRange: {
      return &GpuChannel::WaitForTokenInRange_Sym::IPCStableHash;
    }
    case messages::GpuChannel::kWaitForGetOffsetInRange: {
      return &GpuChannel::WaitForGetOffsetInRange_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* GpuChannel::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::GpuChannel>(message.name())) {
      case messages::GpuChannel::kCrashForTesting:
            return "Receive gpu::mojom::GpuChannel::CrashForTesting";
      case messages::GpuChannel::kTerminateForTesting:
            return "Receive gpu::mojom::GpuChannel::TerminateForTesting";
      case messages::GpuChannel::kGetChannelToken:
            return "Receive gpu::mojom::GpuChannel::GetChannelToken";
      case messages::GpuChannel::kFlush:
            return "Receive gpu::mojom::GpuChannel::Flush";
      case messages::GpuChannel::kGetSharedMemoryForFlushId:
            return "Receive gpu::mojom::GpuChannel::GetSharedMemoryForFlushId";
      case messages::GpuChannel::kCreateCommandBuffer:
            return "Receive gpu::mojom::GpuChannel::CreateCommandBuffer";
      case messages::GpuChannel::kDestroyCommandBuffer:
            return "Receive gpu::mojom::GpuChannel::DestroyCommandBuffer";
      case messages::GpuChannel::kScheduleImageDecode:
            return "Receive gpu::mojom::GpuChannel::ScheduleImageDecode";
      case messages::GpuChannel::kFlushDeferredRequests:
            return "Receive gpu::mojom::GpuChannel::FlushDeferredRequests";
      case messages::GpuChannel::kCreateGpuMemoryBuffer:
            return "Receive gpu::mojom::GpuChannel::CreateGpuMemoryBuffer";
      case messages::GpuChannel::kWaitForTokenInRange:
            return "Receive gpu::mojom::GpuChannel::WaitForTokenInRange";
      case messages::GpuChannel::kWaitForGetOffsetInRange:
            return "Receive gpu::mojom::GpuChannel::WaitForGetOffsetInRange";
    }
  } else {
    switch (static_cast<messages::GpuChannel>(message.name())) {
      case messages::GpuChannel::kCrashForTesting:
            return "Receive reply gpu::mojom::GpuChannel::CrashForTesting";
      case messages::GpuChannel::kTerminateForTesting:
            return "Receive reply gpu::mojom::GpuChannel::TerminateForTesting";
      case messages::GpuChannel::kGetChannelToken:
            return "Receive reply gpu::mojom::GpuChannel::GetChannelToken";
      case messages::GpuChannel::kFlush:
            return "Receive reply gpu::mojom::GpuChannel::Flush";
      case messages::GpuChannel::kGetSharedMemoryForFlushId:
            return "Receive reply gpu::mojom::GpuChannel::GetSharedMemoryForFlushId";
      case messages::GpuChannel::kCreateCommandBuffer:
            return "Receive reply gpu::mojom::GpuChannel::CreateCommandBuffer";
      case messages::GpuChannel::kDestroyCommandBuffer:
            return "Receive reply gpu::mojom::GpuChannel::DestroyCommandBuffer";
      case messages::GpuChannel::kScheduleImageDecode:
            return "Receive reply gpu::mojom::GpuChannel::ScheduleImageDecode";
      case messages::GpuChannel::kFlushDeferredRequests:
            return "Receive reply gpu::mojom::GpuChannel::FlushDeferredRequests";
      case messages::GpuChannel::kCreateGpuMemoryBuffer:
            return "Receive reply gpu::mojom::GpuChannel::CreateGpuMemoryBuffer";
      case messages::GpuChannel::kWaitForTokenInRange:
            return "Receive reply gpu::mojom::GpuChannel::WaitForTokenInRange";
      case messages::GpuChannel::kWaitForGetOffsetInRange:
            return "Receive reply gpu::mojom::GpuChannel::WaitForGetOffsetInRange";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t GpuChannel::CrashForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x44e59dbe;  // IPCStableHash for gpu::mojom::GpuChannel::CrashForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuChannel::TerminateForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc6dc3ed6;  // IPCStableHash for gpu::mojom::GpuChannel::TerminateForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuChannel::GetChannelToken_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9d4b6977;  // IPCStableHash for gpu::mojom::GpuChannel::GetChannelToken
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuChannel::Flush_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xff91ee72;  // IPCStableHash for gpu::mojom::GpuChannel::Flush
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuChannel::GetSharedMemoryForFlushId_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x21f560ba;  // IPCStableHash for gpu::mojom::GpuChannel::GetSharedMemoryForFlushId
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuChannel::CreateCommandBuffer_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa1484eef;  // IPCStableHash for gpu::mojom::GpuChannel::CreateCommandBuffer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuChannel::DestroyCommandBuffer_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd0377b65;  // IPCStableHash for gpu::mojom::GpuChannel::DestroyCommandBuffer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuChannel::ScheduleImageDecode_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x65b86876;  // IPCStableHash for gpu::mojom::GpuChannel::ScheduleImageDecode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuChannel::FlushDeferredRequests_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x39cf93f0;  // IPCStableHash for gpu::mojom::GpuChannel::FlushDeferredRequests
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuChannel::CreateGpuMemoryBuffer_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2230c997;  // IPCStableHash for gpu::mojom::GpuChannel::CreateGpuMemoryBuffer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuChannel::WaitForTokenInRange_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8ba66bd0;  // IPCStableHash for gpu::mojom::GpuChannel::WaitForTokenInRange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuChannel::WaitForGetOffsetInRange_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1b4dc7e8;  // IPCStableHash for gpu::mojom::GpuChannel::WaitForGetOffsetInRange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool GpuChannel::GetChannelToken(::base::UnguessableToken* out_token) {
  NOTREACHED();
}
bool GpuChannel::Flush() {
  NOTREACHED();
}
bool GpuChannel::GetSharedMemoryForFlushId(::base::ReadOnlySharedMemoryRegion* out_version_buffer) {
  NOTREACHED();
}
bool GpuChannel::CreateCommandBuffer(CreateCommandBufferParamsPtr params, int32_t routing_id, ::base::UnsafeSharedMemoryRegion shared_state, ::mojo::PendingAssociatedReceiver<CommandBuffer> receiver, ::mojo::PendingAssociatedRemote<CommandBufferClient> client, ::gpu::ContextResult* out_result, ::gpu::Capabilities* out_capabilties, ::gpu::GLCapabilities* out_gl_capabilities) {
  NOTREACHED();
}
bool GpuChannel::DestroyCommandBuffer(int32_t routing_id) {
  NOTREACHED();
}
bool GpuChannel::CreateGpuMemoryBuffer(const ::gfx::Size& size, const ::viz::SharedImageFormat& format, ::gfx::BufferUsage buffer_usage, ::gfx::GpuMemoryBufferHandle* out_buffer_handle) {
  NOTREACHED();
}
bool GpuChannel::WaitForTokenInRange(int32_t routing_id, int32_t start, int32_t end, ::gpu::CommandBuffer::State* out_state) {
  NOTREACHED();
}
bool GpuChannel::WaitForGetOffsetInRange(int32_t routing_id, uint32_t set_get_buffer_count, int32_t start, int32_t end, ::gpu::CommandBuffer::State* out_state) {
  NOTREACHED();
}
class GpuChannel_GetChannelToken_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  GpuChannel_GetChannelToken_HandleSyncResponse(
      bool* result, ::base::UnguessableToken* out_token)
      : result_(result), out_token_(out_token) {
    DCHECK(!*result_);
  }

  GpuChannel_GetChannelToken_HandleSyncResponse(const GpuChannel_GetChannelToken_HandleSyncResponse&) = delete;
  GpuChannel_GetChannelToken_HandleSyncResponse& operator=(const GpuChannel_GetChannelToken_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::UnguessableToken* out_token_;};

class GpuChannel_GetChannelToken_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuChannel_GetChannelToken_ForwardToCallback(
      GpuChannel::GetChannelTokenCallback callback
      ) : callback_(std::move(callback)) {
  }

  GpuChannel_GetChannelToken_ForwardToCallback(const GpuChannel_GetChannelToken_ForwardToCallback&) = delete;
  GpuChannel_GetChannelToken_ForwardToCallback& operator=(const GpuChannel_GetChannelToken_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  GpuChannel::GetChannelTokenCallback callback_;
};
class GpuChannel_Flush_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  GpuChannel_Flush_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }

  GpuChannel_Flush_HandleSyncResponse(const GpuChannel_Flush_HandleSyncResponse&) = delete;
  GpuChannel_Flush_HandleSyncResponse& operator=(const GpuChannel_Flush_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;};

class GpuChannel_Flush_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuChannel_Flush_ForwardToCallback(
      GpuChannel::FlushCallback callback
      ) : callback_(std::move(callback)) {
  }

  GpuChannel_Flush_ForwardToCallback(const GpuChannel_Flush_ForwardToCallback&) = delete;
  GpuChannel_Flush_ForwardToCallback& operator=(const GpuChannel_Flush_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  GpuChannel::FlushCallback callback_;
};
class GpuChannel_GetSharedMemoryForFlushId_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  GpuChannel_GetSharedMemoryForFlushId_HandleSyncResponse(
      bool* result, ::base::ReadOnlySharedMemoryRegion* out_version_buffer)
      : result_(result), out_version_buffer_(out_version_buffer) {
    DCHECK(!*result_);
  }

  GpuChannel_GetSharedMemoryForFlushId_HandleSyncResponse(const GpuChannel_GetSharedMemoryForFlushId_HandleSyncResponse&) = delete;
  GpuChannel_GetSharedMemoryForFlushId_HandleSyncResponse& operator=(const GpuChannel_GetSharedMemoryForFlushId_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::ReadOnlySharedMemoryRegion* out_version_buffer_;};

class GpuChannel_GetSharedMemoryForFlushId_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuChannel_GetSharedMemoryForFlushId_ForwardToCallback(
      GpuChannel::GetSharedMemoryForFlushIdCallback callback
      ) : callback_(std::move(callback)) {
  }

  GpuChannel_GetSharedMemoryForFlushId_ForwardToCallback(const GpuChannel_GetSharedMemoryForFlushId_ForwardToCallback&) = delete;
  GpuChannel_GetSharedMemoryForFlushId_ForwardToCallback& operator=(const GpuChannel_GetSharedMemoryForFlushId_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  GpuChannel::GetSharedMemoryForFlushIdCallback callback_;
};
class GpuChannel_CreateCommandBuffer_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  GpuChannel_CreateCommandBuffer_HandleSyncResponse(
      bool* result, ::gpu::ContextResult* out_result, ::gpu::Capabilities* out_capabilties, ::gpu::GLCapabilities* out_gl_capabilities)
      : result_(result), out_result_(out_result), out_capabilties_(out_capabilties), out_gl_capabilities_(out_gl_capabilities) {
    DCHECK(!*result_);
  }

  GpuChannel_CreateCommandBuffer_HandleSyncResponse(const GpuChannel_CreateCommandBuffer_HandleSyncResponse&) = delete;
  GpuChannel_CreateCommandBuffer_HandleSyncResponse& operator=(const GpuChannel_CreateCommandBuffer_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::gpu::ContextResult* out_result_;
  ::gpu::Capabilities* out_capabilties_;
  ::gpu::GLCapabilities* out_gl_capabilities_;};

class GpuChannel_CreateCommandBuffer_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuChannel_CreateCommandBuffer_ForwardToCallback(
      GpuChannel::CreateCommandBufferCallback callback
      ) : callback_(std::move(callback)) {
  }

  GpuChannel_CreateCommandBuffer_ForwardToCallback(const GpuChannel_CreateCommandBuffer_ForwardToCallback&) = delete;
  GpuChannel_CreateCommandBuffer_ForwardToCallback& operator=(const GpuChannel_CreateCommandBuffer_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  GpuChannel::CreateCommandBufferCallback callback_;
};
class GpuChannel_DestroyCommandBuffer_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  GpuChannel_DestroyCommandBuffer_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }

  GpuChannel_DestroyCommandBuffer_HandleSyncResponse(const GpuChannel_DestroyCommandBuffer_HandleSyncResponse&) = delete;
  GpuChannel_DestroyCommandBuffer_HandleSyncResponse& operator=(const GpuChannel_DestroyCommandBuffer_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;};

class GpuChannel_DestroyCommandBuffer_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuChannel_DestroyCommandBuffer_ForwardToCallback(
      GpuChannel::DestroyCommandBufferCallback callback
      ) : callback_(std::move(callback)) {
  }

  GpuChannel_DestroyCommandBuffer_ForwardToCallback(const GpuChannel_DestroyCommandBuffer_ForwardToCallback&) = delete;
  GpuChannel_DestroyCommandBuffer_ForwardToCallback& operator=(const GpuChannel_DestroyCommandBuffer_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  GpuChannel::DestroyCommandBufferCallback callback_;
};
class GpuChannel_CreateGpuMemoryBuffer_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  GpuChannel_CreateGpuMemoryBuffer_HandleSyncResponse(
      bool* result, ::gfx::GpuMemoryBufferHandle* out_buffer_handle)
      : result_(result), out_buffer_handle_(out_buffer_handle) {
    DCHECK(!*result_);
  }

  GpuChannel_CreateGpuMemoryBuffer_HandleSyncResponse(const GpuChannel_CreateGpuMemoryBuffer_HandleSyncResponse&) = delete;
  GpuChannel_CreateGpuMemoryBuffer_HandleSyncResponse& operator=(const GpuChannel_CreateGpuMemoryBuffer_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::gfx::GpuMemoryBufferHandle* out_buffer_handle_;};

class GpuChannel_CreateGpuMemoryBuffer_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuChannel_CreateGpuMemoryBuffer_ForwardToCallback(
      GpuChannel::CreateGpuMemoryBufferCallback callback
      ) : callback_(std::move(callback)) {
  }

  GpuChannel_CreateGpuMemoryBuffer_ForwardToCallback(const GpuChannel_CreateGpuMemoryBuffer_ForwardToCallback&) = delete;
  GpuChannel_CreateGpuMemoryBuffer_ForwardToCallback& operator=(const GpuChannel_CreateGpuMemoryBuffer_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  GpuChannel::CreateGpuMemoryBufferCallback callback_;
};
class GpuChannel_WaitForTokenInRange_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  GpuChannel_WaitForTokenInRange_HandleSyncResponse(
      bool* result, ::gpu::CommandBuffer::State* out_state)
      : result_(result), out_state_(out_state) {
    DCHECK(!*result_);
  }

  GpuChannel_WaitForTokenInRange_HandleSyncResponse(const GpuChannel_WaitForTokenInRange_HandleSyncResponse&) = delete;
  GpuChannel_WaitForTokenInRange_HandleSyncResponse& operator=(const GpuChannel_WaitForTokenInRange_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::gpu::CommandBuffer::State* out_state_;};

class GpuChannel_WaitForTokenInRange_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuChannel_WaitForTokenInRange_ForwardToCallback(
      GpuChannel::WaitForTokenInRangeCallback callback
      ) : callback_(std::move(callback)) {
  }

  GpuChannel_WaitForTokenInRange_ForwardToCallback(const GpuChannel_WaitForTokenInRange_ForwardToCallback&) = delete;
  GpuChannel_WaitForTokenInRange_ForwardToCallback& operator=(const GpuChannel_WaitForTokenInRange_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  GpuChannel::WaitForTokenInRangeCallback callback_;
};
class GpuChannel_WaitForGetOffsetInRange_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  GpuChannel_WaitForGetOffsetInRange_HandleSyncResponse(
      bool* result, ::gpu::CommandBuffer::State* out_state)
      : result_(result), out_state_(out_state) {
    DCHECK(!*result_);
  }

  GpuChannel_WaitForGetOffsetInRange_HandleSyncResponse(const GpuChannel_WaitForGetOffsetInRange_HandleSyncResponse&) = delete;
  GpuChannel_WaitForGetOffsetInRange_HandleSyncResponse& operator=(const GpuChannel_WaitForGetOffsetInRange_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::gpu::CommandBuffer::State* out_state_;};

class GpuChannel_WaitForGetOffsetInRange_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuChannel_WaitForGetOffsetInRange_ForwardToCallback(
      GpuChannel::WaitForGetOffsetInRangeCallback callback
      ) : callback_(std::move(callback)) {
  }

  GpuChannel_WaitForGetOffsetInRange_ForwardToCallback(const GpuChannel_WaitForGetOffsetInRange_ForwardToCallback&) = delete;
  GpuChannel_WaitForGetOffsetInRange_ForwardToCallback& operator=(const GpuChannel_WaitForGetOffsetInRange_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  GpuChannel::WaitForGetOffsetInRangeCallback callback_;
};

GpuChannelProxy::GpuChannelProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GpuChannelProxy::CrashForTesting(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send gpu::mojom::GpuChannel::CrashForTesting");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuChannel::kCrashForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_CrashForTesting_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("CrashForTesting");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuChannelProxy::TerminateForTesting(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send gpu::mojom::GpuChannel::TerminateForTesting");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuChannel::kTerminateForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_TerminateForTesting_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("TerminateForTesting");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
bool GpuChannelProxy::GetChannelToken(
    ::base::UnguessableToken* out_param_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call gpu::mojom::GpuChannel::GetChannelToken (sync)");
#else
  TRACE_EVENT0("mojom", "GpuChannel::GetChannelToken");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuChannel::kGetChannelToken), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_GetChannelToken_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("GetChannelToken");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuChannel_GetChannelToken_HandleSyncResponse(
          &result, out_param_token));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "GpuChannel::GetChannelToken", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), out_param_token,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif
  return result;
}

void GpuChannelProxy::GetChannelToken(
    GetChannelTokenCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send gpu::mojom::GpuChannel::GetChannelToken");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuChannel::kGetChannelToken), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_GetChannelToken_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("GetChannelToken");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuChannel_GetChannelToken_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool GpuChannelProxy::Flush(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call gpu::mojom::GpuChannel::Flush (sync)");
#else
  TRACE_EVENT0("mojom", "GpuChannel::Flush");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      false;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuChannel::kFlush), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_Flush_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("Flush");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuChannel_Flush_HandleSyncResponse(
          &result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "GpuChannel::Flush");
#endif
  return result;
}

void GpuChannelProxy::Flush(
    FlushCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send gpu::mojom::GpuChannel::Flush");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuChannel::kFlush), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_Flush_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("Flush");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuChannel_Flush_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool GpuChannelProxy::GetSharedMemoryForFlushId(
    ::base::ReadOnlySharedMemoryRegion* out_param_version_buffer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call gpu::mojom::GpuChannel::GetSharedMemoryForFlushId (sync)");
#else
  TRACE_EVENT0("mojom", "GpuChannel::GetSharedMemoryForFlushId");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      false;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuChannel::kGetSharedMemoryForFlushId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_GetSharedMemoryForFlushId_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("GetSharedMemoryForFlushId");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuChannel_GetSharedMemoryForFlushId_HandleSyncResponse(
          &result, out_param_version_buffer));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "GpuChannel::GetSharedMemoryForFlushId", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("version_buffer"), out_param_version_buffer,
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
   });
#endif
  return result;
}

void GpuChannelProxy::GetSharedMemoryForFlushId(
    GetSharedMemoryForFlushIdCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send gpu::mojom::GpuChannel::GetSharedMemoryForFlushId");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuChannel::kGetSharedMemoryForFlushId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_GetSharedMemoryForFlushId_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("GetSharedMemoryForFlushId");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuChannel_GetSharedMemoryForFlushId_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool GpuChannelProxy::CreateCommandBuffer(
    CreateCommandBufferParamsPtr param_params, int32_t param_routing_id, ::base::UnsafeSharedMemoryRegion param_shared_state, ::mojo::PendingAssociatedReceiver<CommandBuffer> param_receiver, ::mojo::PendingAssociatedRemote<CommandBufferClient> param_client, ::gpu::ContextResult* out_param_result, ::gpu::Capabilities* out_param_capabilties, ::gpu::GLCapabilities* out_param_gl_capabilities) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call gpu::mojom::GpuChannel::CreateCommandBuffer (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), param_params,
                        "<value of type CreateCommandBufferParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("routing_id"), param_routing_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shared_state"), param_shared_state,
                        "<value of type ::base::UnsafeSharedMemoryRegion>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), param_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<CommandBuffer>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), param_client,
                        "<value of type ::mojo::PendingAssociatedRemote<CommandBufferClient>>");
   });
#else
  TRACE_EVENT0("mojom", "GpuChannel::CreateCommandBuffer");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      false;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuChannel::kCreateCommandBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_CreateCommandBuffer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::gpu::mojom::CreateCommandBufferParamsDataView>(
    param_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in GpuChannel.CreateCommandBuffer request");

  params->routing_id = param_routing_id;
  mojo::internal::MessageFragment<
      typename decltype(params->shared_state)::BaseType> shared_state_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView>(
    param_shared_state,
    shared_state_fragment);

  params->shared_state.Set(
      shared_state_fragment.is_null() ? nullptr : shared_state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->shared_state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null shared_state in GpuChannel.CreateCommandBuffer request");

  
  mojo::internal::Serialize<::gpu::mojom::CommandBufferAssociatedRequestDataView>(
    param_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid receiver in GpuChannel.CreateCommandBuffer request");

  
  mojo::internal::Serialize<::gpu::mojom::CommandBufferClientAssociatedPtrInfoDataView>(
    param_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in GpuChannel.CreateCommandBuffer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("CreateCommandBuffer");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuChannel_CreateCommandBuffer_HandleSyncResponse(
          &result, out_param_result, out_param_capabilties, out_param_gl_capabilities));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "GpuChannel::CreateCommandBuffer", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), out_param_result,
                        "<value of type ::gpu::ContextResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("capabilties"), out_param_capabilties,
                        "<value of type const ::gpu::Capabilities&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gl_capabilities"), out_param_gl_capabilities,
                        "<value of type const ::gpu::GLCapabilities&>");
   });
#endif
  return result;
}

void GpuChannelProxy::CreateCommandBuffer(
    CreateCommandBufferParamsPtr in_params, int32_t in_routing_id, ::base::UnsafeSharedMemoryRegion in_shared_state, ::mojo::PendingAssociatedReceiver<CommandBuffer> in_receiver, ::mojo::PendingAssociatedRemote<CommandBufferClient> in_client, CreateCommandBufferCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send gpu::mojom::GpuChannel::CreateCommandBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type CreateCommandBufferParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("routing_id"), in_routing_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shared_state"), in_shared_state,
                        "<value of type ::base::UnsafeSharedMemoryRegion>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<CommandBuffer>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<CommandBufferClient>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuChannel::kCreateCommandBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_CreateCommandBuffer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::gpu::mojom::CreateCommandBufferParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in GpuChannel.CreateCommandBuffer request");

  params->routing_id = in_routing_id;
  mojo::internal::MessageFragment<
      typename decltype(params->shared_state)::BaseType> shared_state_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView>(
    in_shared_state,
    shared_state_fragment);

  params->shared_state.Set(
      shared_state_fragment.is_null() ? nullptr : shared_state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->shared_state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null shared_state in GpuChannel.CreateCommandBuffer request");

  
  mojo::internal::Serialize<::gpu::mojom::CommandBufferAssociatedRequestDataView>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid receiver in GpuChannel.CreateCommandBuffer request");

  
  mojo::internal::Serialize<::gpu::mojom::CommandBufferClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in GpuChannel.CreateCommandBuffer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("CreateCommandBuffer");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuChannel_CreateCommandBuffer_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool GpuChannelProxy::DestroyCommandBuffer(
    int32_t param_routing_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call gpu::mojom::GpuChannel::DestroyCommandBuffer (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("routing_id"), param_routing_id,
                        "<value of type int32_t>");
   });
#else
  TRACE_EVENT0("mojom", "GpuChannel::DestroyCommandBuffer");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      false;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuChannel::kDestroyCommandBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_DestroyCommandBuffer_Params_Data> params(
          message);
  params.Allocate();

  params->routing_id = param_routing_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("DestroyCommandBuffer");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuChannel_DestroyCommandBuffer_HandleSyncResponse(
          &result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "GpuChannel::DestroyCommandBuffer");
#endif
  return result;
}

void GpuChannelProxy::DestroyCommandBuffer(
    int32_t in_routing_id, DestroyCommandBufferCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send gpu::mojom::GpuChannel::DestroyCommandBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("routing_id"), in_routing_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuChannel::kDestroyCommandBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_DestroyCommandBuffer_Params_Data> params(
          message);
  params.Allocate();

  params->routing_id = in_routing_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("DestroyCommandBuffer");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuChannel_DestroyCommandBuffer_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void GpuChannelProxy::ScheduleImageDecode(
    ScheduleImageDecodeParamsPtr in_params, uint64_t in_decode_release_count) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send gpu::mojom::GpuChannel::ScheduleImageDecode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type ScheduleImageDecodeParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("decode_release_count"), in_decode_release_count,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuChannel::kScheduleImageDecode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_ScheduleImageDecode_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::gpu::mojom::ScheduleImageDecodeParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in GpuChannel.ScheduleImageDecode request");

  params->decode_release_count = in_decode_release_count;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("ScheduleImageDecode");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuChannelProxy::FlushDeferredRequests(
    std::vector<DeferredRequestPtr> in_requests, uint32_t in_flushed_deferred_message_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send gpu::mojom::GpuChannel::FlushDeferredRequests", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requests"), in_requests,
                        "<value of type std::vector<DeferredRequestPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("flushed_deferred_message_id"), in_flushed_deferred_message_id,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuChannel::kFlushDeferredRequests), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_FlushDeferredRequests_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->requests)::BaseType>
      requests_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& requests_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::gpu::mojom::DeferredRequestDataView>>(
    in_requests,
    requests_fragment,
    &requests_validate_params);

  params->requests.Set(
      requests_fragment.is_null() ? nullptr : requests_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->requests.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null requests in GpuChannel.FlushDeferredRequests request");

  params->flushed_deferred_message_id = in_flushed_deferred_message_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("FlushDeferredRequests");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
bool GpuChannelProxy::CreateGpuMemoryBuffer(
    const ::gfx::Size& param_size, const ::viz::SharedImageFormat& param_format, ::gfx::BufferUsage param_buffer_usage, ::gfx::GpuMemoryBufferHandle* out_param_buffer_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call gpu::mojom::GpuChannel::CreateGpuMemoryBuffer (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), param_size,
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("format"), param_format,
                        "<value of type const ::viz::SharedImageFormat&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_usage"), param_buffer_usage,
                        "<value of type ::gfx::BufferUsage>");
   });
#else
  TRACE_EVENT0("mojom", "GpuChannel::CreateGpuMemoryBuffer");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuChannel::kCreateGpuMemoryBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_CreateGpuMemoryBuffer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->size)::BaseType> size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    param_size,
    size_fragment);

  params->size.Set(
      size_fragment.is_null() ? nullptr : size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null size in GpuChannel.CreateGpuMemoryBuffer request");
  mojo::internal::MessageFragment<decltype(params->format)>
      format_fragment(params.message());
  format_fragment.Claim(&params->format);
  
  mojo::internal::Serialize<::viz::mojom::SharedImageFormatDataView>(
    param_format,
    format_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->format.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null format in GpuChannel.CreateGpuMemoryBuffer request");

  
  mojo::internal::Serialize<::gfx::mojom::BufferUsage>(
    param_buffer_usage,
    &params->buffer_usage);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("CreateGpuMemoryBuffer");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuChannel_CreateGpuMemoryBuffer_HandleSyncResponse(
          &result, out_param_buffer_handle));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "GpuChannel::CreateGpuMemoryBuffer", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_handle"), out_param_buffer_handle,
                        "<value of type ::gfx::GpuMemoryBufferHandle>");
   });
#endif
  return result;
}

void GpuChannelProxy::CreateGpuMemoryBuffer(
    const ::gfx::Size& in_size, const ::viz::SharedImageFormat& in_format, ::gfx::BufferUsage in_buffer_usage, CreateGpuMemoryBufferCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send gpu::mojom::GpuChannel::CreateGpuMemoryBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), in_size,
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("format"), in_format,
                        "<value of type const ::viz::SharedImageFormat&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_usage"), in_buffer_usage,
                        "<value of type ::gfx::BufferUsage>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuChannel::kCreateGpuMemoryBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_CreateGpuMemoryBuffer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->size)::BaseType> size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_size,
    size_fragment);

  params->size.Set(
      size_fragment.is_null() ? nullptr : size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null size in GpuChannel.CreateGpuMemoryBuffer request");
  mojo::internal::MessageFragment<decltype(params->format)>
      format_fragment(params.message());
  format_fragment.Claim(&params->format);
  
  mojo::internal::Serialize<::viz::mojom::SharedImageFormatDataView>(
    in_format,
    format_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->format.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null format in GpuChannel.CreateGpuMemoryBuffer request");

  
  mojo::internal::Serialize<::gfx::mojom::BufferUsage>(
    in_buffer_usage,
    &params->buffer_usage);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("CreateGpuMemoryBuffer");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuChannel_CreateGpuMemoryBuffer_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool GpuChannelProxy::WaitForTokenInRange(
    int32_t param_routing_id, int32_t param_start, int32_t param_end, ::gpu::CommandBuffer::State* out_param_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call gpu::mojom::GpuChannel::WaitForTokenInRange (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("routing_id"), param_routing_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("start"), param_start,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("end"), param_end,
                        "<value of type int32_t>");
   });
#else
  TRACE_EVENT0("mojom", "GpuChannel::WaitForTokenInRange");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      false;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuChannel::kWaitForTokenInRange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_WaitForTokenInRange_Params_Data> params(
          message);
  params.Allocate();

  params->routing_id = param_routing_id;

  params->start = param_start;

  params->end = param_end;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("WaitForTokenInRange");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuChannel_WaitForTokenInRange_HandleSyncResponse(
          &result, out_param_state));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "GpuChannel::WaitForTokenInRange", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), out_param_state,
                        "<value of type const ::gpu::CommandBuffer::State&>");
   });
#endif
  return result;
}

void GpuChannelProxy::WaitForTokenInRange(
    int32_t in_routing_id, int32_t in_start, int32_t in_end, WaitForTokenInRangeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send gpu::mojom::GpuChannel::WaitForTokenInRange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("routing_id"), in_routing_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("start"), in_start,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("end"), in_end,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuChannel::kWaitForTokenInRange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_WaitForTokenInRange_Params_Data> params(
          message);
  params.Allocate();

  params->routing_id = in_routing_id;

  params->start = in_start;

  params->end = in_end;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("WaitForTokenInRange");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuChannel_WaitForTokenInRange_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool GpuChannelProxy::WaitForGetOffsetInRange(
    int32_t param_routing_id, uint32_t param_set_get_buffer_count, int32_t param_start, int32_t param_end, ::gpu::CommandBuffer::State* out_param_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call gpu::mojom::GpuChannel::WaitForGetOffsetInRange (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("routing_id"), param_routing_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("set_get_buffer_count"), param_set_get_buffer_count,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("start"), param_start,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("end"), param_end,
                        "<value of type int32_t>");
   });
#else
  TRACE_EVENT0("mojom", "GpuChannel::WaitForGetOffsetInRange");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      false;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuChannel::kWaitForGetOffsetInRange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_WaitForGetOffsetInRange_Params_Data> params(
          message);
  params.Allocate();

  params->routing_id = param_routing_id;

  params->set_get_buffer_count = param_set_get_buffer_count;

  params->start = param_start;

  params->end = param_end;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("WaitForGetOffsetInRange");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuChannel_WaitForGetOffsetInRange_HandleSyncResponse(
          &result, out_param_state));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "GpuChannel::WaitForGetOffsetInRange", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), out_param_state,
                        "<value of type const ::gpu::CommandBuffer::State&>");
   });
#endif
  return result;
}

void GpuChannelProxy::WaitForGetOffsetInRange(
    int32_t in_routing_id, uint32_t in_set_get_buffer_count, int32_t in_start, int32_t in_end, WaitForGetOffsetInRangeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send gpu::mojom::GpuChannel::WaitForGetOffsetInRange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("routing_id"), in_routing_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("set_get_buffer_count"), in_set_get_buffer_count,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("start"), in_start,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("end"), in_end,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuChannel::kWaitForGetOffsetInRange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_WaitForGetOffsetInRange_Params_Data> params(
          message);
  params.Allocate();

  params->routing_id = in_routing_id;

  params->set_get_buffer_count = in_set_get_buffer_count;

  params->start = in_start;

  params->end = in_end;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("WaitForGetOffsetInRange");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuChannel_WaitForGetOffsetInRange_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class GpuChannel_GetChannelToken_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static GpuChannel::GetChannelTokenCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<GpuChannel_GetChannelToken_ProxyToResponder> proxy(
        new GpuChannel_GetChannelToken_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&GpuChannel_GetChannelToken_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuChannel_GetChannelToken_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  GpuChannel_GetChannelToken_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GpuChannel::GetChannelTokenCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::base::UnguessableToken& in_token);
};

bool GpuChannel_GetChannelToken_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GpuChannel_GetChannelToken_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuChannel_GetChannelToken_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for GpuChannel.2
  bool success = true;
  ::base::UnguessableToken p_token{};
  GpuChannel_GetChannelToken_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadToken(&p_token))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuChannel::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_token));
  }
  return true;
}

void GpuChannel_GetChannelToken_ProxyToResponder::Run(
    const ::base::UnguessableToken& in_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply gpu::mojom::GpuChannel::GetChannelToken", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuChannel::kGetChannelToken), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_GetChannelToken_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->token)::BaseType> token_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_token,
    token_fragment);

  params->token.Set(
      token_fragment.is_null() ? nullptr : token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null token in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("GetChannelToken");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool GpuChannel_GetChannelToken_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GpuChannel_GetChannelToken_ResponseParams_Data* params =
      reinterpret_cast<internal::GpuChannel_GetChannelToken_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for GpuChannel.2
  bool success = true;
  ::base::UnguessableToken p_token{};
  GpuChannel_GetChannelToken_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadToken(&p_token))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuChannel::Name_, 2, true);
    return false;
  }
  *out_token_ = std::move(p_token);
  *result_ = true;
  return true;
}
class GpuChannel_Flush_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static GpuChannel::FlushCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<GpuChannel_Flush_ProxyToResponder> proxy(
        new GpuChannel_Flush_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&GpuChannel_Flush_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuChannel_Flush_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  GpuChannel_Flush_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GpuChannel::FlushCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool GpuChannel_Flush_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GpuChannel_Flush_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuChannel_Flush_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for GpuChannel.3
  bool success = true;
  GpuChannel_Flush_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuChannel::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void GpuChannel_Flush_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply gpu::mojom::GpuChannel::Flush");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuChannel::kFlush), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_Flush_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("Flush");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool GpuChannel_Flush_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GpuChannel_Flush_ResponseParams_Data* params =
      reinterpret_cast<internal::GpuChannel_Flush_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for GpuChannel.3
  bool success = true;
  GpuChannel_Flush_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuChannel::Name_, 3, true);
    return false;
  }
  *result_ = true;
  return true;
}
class GpuChannel_GetSharedMemoryForFlushId_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static GpuChannel::GetSharedMemoryForFlushIdCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<GpuChannel_GetSharedMemoryForFlushId_ProxyToResponder> proxy(
        new GpuChannel_GetSharedMemoryForFlushId_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&GpuChannel_GetSharedMemoryForFlushId_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuChannel_GetSharedMemoryForFlushId_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  GpuChannel_GetSharedMemoryForFlushId_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GpuChannel::GetSharedMemoryForFlushIdCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::ReadOnlySharedMemoryRegion in_version_buffer);
};

bool GpuChannel_GetSharedMemoryForFlushId_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GpuChannel_GetSharedMemoryForFlushId_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuChannel_GetSharedMemoryForFlushId_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for GpuChannel.4
  bool success = true;
  ::base::ReadOnlySharedMemoryRegion p_version_buffer{};
  GpuChannel_GetSharedMemoryForFlushId_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadVersionBuffer(&p_version_buffer))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuChannel::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_version_buffer));
  }
  return true;
}

void GpuChannel_GetSharedMemoryForFlushId_ProxyToResponder::Run(
    ::base::ReadOnlySharedMemoryRegion in_version_buffer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply gpu::mojom::GpuChannel::GetSharedMemoryForFlushId", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("version_buffer"), in_version_buffer,
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuChannel::kGetSharedMemoryForFlushId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_GetSharedMemoryForFlushId_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->version_buffer)::BaseType> version_buffer_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
    in_version_buffer,
    version_buffer_fragment);

  params->version_buffer.Set(
      version_buffer_fragment.is_null() ? nullptr : version_buffer_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("GetSharedMemoryForFlushId");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool GpuChannel_GetSharedMemoryForFlushId_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GpuChannel_GetSharedMemoryForFlushId_ResponseParams_Data* params =
      reinterpret_cast<internal::GpuChannel_GetSharedMemoryForFlushId_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for GpuChannel.4
  bool success = true;
  ::base::ReadOnlySharedMemoryRegion p_version_buffer{};
  GpuChannel_GetSharedMemoryForFlushId_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadVersionBuffer(&p_version_buffer))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuChannel::Name_, 4, true);
    return false;
  }
  *out_version_buffer_ = std::move(p_version_buffer);
  *result_ = true;
  return true;
}
class GpuChannel_CreateCommandBuffer_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static GpuChannel::CreateCommandBufferCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<GpuChannel_CreateCommandBuffer_ProxyToResponder> proxy(
        new GpuChannel_CreateCommandBuffer_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&GpuChannel_CreateCommandBuffer_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuChannel_CreateCommandBuffer_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  GpuChannel_CreateCommandBuffer_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GpuChannel::CreateCommandBufferCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::gpu::ContextResult in_result, const ::gpu::Capabilities& in_capabilties, const ::gpu::GLCapabilities& in_gl_capabilities);
};

bool GpuChannel_CreateCommandBuffer_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GpuChannel_CreateCommandBuffer_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuChannel_CreateCommandBuffer_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for GpuChannel.5
  bool success = true;
  ::gpu::ContextResult p_result{};
  ::gpu::Capabilities p_capabilties{};
  ::gpu::GLCapabilities p_gl_capabilities{};
  GpuChannel_CreateCommandBuffer_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadCapabilties(&p_capabilties))
    success = false;
  if (success && !input_data_view.ReadGlCapabilities(&p_gl_capabilities))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuChannel::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_capabilties), 
std::move(p_gl_capabilities));
  }
  return true;
}

void GpuChannel_CreateCommandBuffer_ProxyToResponder::Run(
    ::gpu::ContextResult in_result, const ::gpu::Capabilities& in_capabilties, const ::gpu::GLCapabilities& in_gl_capabilities) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply gpu::mojom::GpuChannel::CreateCommandBuffer", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::gpu::ContextResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("capabilties"), in_capabilties,
                        "<value of type const ::gpu::Capabilities&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gl_capabilities"), in_gl_capabilities,
                        "<value of type const ::gpu::GLCapabilities&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuChannel::kCreateCommandBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_CreateCommandBuffer_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::gpu::mojom::ContextResult>(
    in_result,
    &params->result);
  mojo::internal::MessageFragment<
      typename decltype(params->capabilties)::BaseType> capabilties_fragment(
          params.message());
  
  mojo::internal::Serialize<::gpu::mojom::CapabilitiesDataView>(
    in_capabilties,
    capabilties_fragment);

  params->capabilties.Set(
      capabilties_fragment.is_null() ? nullptr : capabilties_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->capabilties.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null capabilties in ");
  mojo::internal::MessageFragment<
      typename decltype(params->gl_capabilities)::BaseType> gl_capabilities_fragment(
          params.message());
  
  mojo::internal::Serialize<::gpu::mojom::GLCapabilitiesDataView>(
    in_gl_capabilities,
    gl_capabilities_fragment);

  params->gl_capabilities.Set(
      gl_capabilities_fragment.is_null() ? nullptr : gl_capabilities_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->gl_capabilities.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null gl_capabilities in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("CreateCommandBuffer");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool GpuChannel_CreateCommandBuffer_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GpuChannel_CreateCommandBuffer_ResponseParams_Data* params =
      reinterpret_cast<internal::GpuChannel_CreateCommandBuffer_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for GpuChannel.5
  bool success = true;
  ::gpu::ContextResult p_result{};
  ::gpu::Capabilities p_capabilties{};
  ::gpu::GLCapabilities p_gl_capabilities{};
  GpuChannel_CreateCommandBuffer_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadCapabilties(&p_capabilties))
    success = false;
  if (success && !input_data_view.ReadGlCapabilities(&p_gl_capabilities))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuChannel::Name_, 5, true);
    return false;
  }
  *out_result_ = std::move(p_result);
  *out_capabilties_ = std::move(p_capabilties);
  *out_gl_capabilities_ = std::move(p_gl_capabilities);
  *result_ = true;
  return true;
}
class GpuChannel_DestroyCommandBuffer_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static GpuChannel::DestroyCommandBufferCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<GpuChannel_DestroyCommandBuffer_ProxyToResponder> proxy(
        new GpuChannel_DestroyCommandBuffer_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&GpuChannel_DestroyCommandBuffer_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuChannel_DestroyCommandBuffer_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  GpuChannel_DestroyCommandBuffer_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GpuChannel::DestroyCommandBufferCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool GpuChannel_DestroyCommandBuffer_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GpuChannel_DestroyCommandBuffer_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuChannel_DestroyCommandBuffer_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for GpuChannel.6
  bool success = true;
  GpuChannel_DestroyCommandBuffer_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuChannel::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void GpuChannel_DestroyCommandBuffer_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply gpu::mojom::GpuChannel::DestroyCommandBuffer");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuChannel::kDestroyCommandBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_DestroyCommandBuffer_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("DestroyCommandBuffer");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool GpuChannel_DestroyCommandBuffer_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GpuChannel_DestroyCommandBuffer_ResponseParams_Data* params =
      reinterpret_cast<internal::GpuChannel_DestroyCommandBuffer_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for GpuChannel.6
  bool success = true;
  GpuChannel_DestroyCommandBuffer_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuChannel::Name_, 6, true);
    return false;
  }
  *result_ = true;
  return true;
}
class GpuChannel_CreateGpuMemoryBuffer_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static GpuChannel::CreateGpuMemoryBufferCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<GpuChannel_CreateGpuMemoryBuffer_ProxyToResponder> proxy(
        new GpuChannel_CreateGpuMemoryBuffer_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&GpuChannel_CreateGpuMemoryBuffer_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuChannel_CreateGpuMemoryBuffer_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  GpuChannel_CreateGpuMemoryBuffer_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GpuChannel::CreateGpuMemoryBufferCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::gfx::GpuMemoryBufferHandle in_buffer_handle);
};

bool GpuChannel_CreateGpuMemoryBuffer_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GpuChannel_CreateGpuMemoryBuffer_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuChannel_CreateGpuMemoryBuffer_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for GpuChannel.9
  bool success = true;
  ::gfx::GpuMemoryBufferHandle p_buffer_handle{};
  GpuChannel_CreateGpuMemoryBuffer_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadBufferHandle(&p_buffer_handle))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuChannel::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_buffer_handle));
  }
  return true;
}

void GpuChannel_CreateGpuMemoryBuffer_ProxyToResponder::Run(
    ::gfx::GpuMemoryBufferHandle in_buffer_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply gpu::mojom::GpuChannel::CreateGpuMemoryBuffer", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_handle"), in_buffer_handle,
                        "<value of type ::gfx::GpuMemoryBufferHandle>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuChannel::kCreateGpuMemoryBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_CreateGpuMemoryBuffer_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->buffer_handle)::BaseType> buffer_handle_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::GpuMemoryBufferHandleDataView>(
    in_buffer_handle,
    buffer_handle_fragment);

  params->buffer_handle.Set(
      buffer_handle_fragment.is_null() ? nullptr : buffer_handle_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->buffer_handle.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null buffer_handle in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("CreateGpuMemoryBuffer");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool GpuChannel_CreateGpuMemoryBuffer_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GpuChannel_CreateGpuMemoryBuffer_ResponseParams_Data* params =
      reinterpret_cast<internal::GpuChannel_CreateGpuMemoryBuffer_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for GpuChannel.9
  bool success = true;
  ::gfx::GpuMemoryBufferHandle p_buffer_handle{};
  GpuChannel_CreateGpuMemoryBuffer_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadBufferHandle(&p_buffer_handle))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuChannel::Name_, 9, true);
    return false;
  }
  *out_buffer_handle_ = std::move(p_buffer_handle);
  *result_ = true;
  return true;
}
class GpuChannel_WaitForTokenInRange_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static GpuChannel::WaitForTokenInRangeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<GpuChannel_WaitForTokenInRange_ProxyToResponder> proxy(
        new GpuChannel_WaitForTokenInRange_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&GpuChannel_WaitForTokenInRange_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuChannel_WaitForTokenInRange_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  GpuChannel_WaitForTokenInRange_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GpuChannel::WaitForTokenInRangeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::gpu::CommandBuffer::State& in_state);
};

bool GpuChannel_WaitForTokenInRange_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GpuChannel_WaitForTokenInRange_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuChannel_WaitForTokenInRange_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for GpuChannel.10
  bool success = true;
  ::gpu::CommandBuffer::State p_state{};
  GpuChannel_WaitForTokenInRange_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadState(&p_state))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuChannel::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_state));
  }
  return true;
}

void GpuChannel_WaitForTokenInRange_ProxyToResponder::Run(
    const ::gpu::CommandBuffer::State& in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply gpu::mojom::GpuChannel::WaitForTokenInRange", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type const ::gpu::CommandBuffer::State&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuChannel::kWaitForTokenInRange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_WaitForTokenInRange_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->state)::BaseType> state_fragment(
          params.message());
  
  mojo::internal::Serialize<::gpu::mojom::CommandBufferStateDataView>(
    in_state,
    state_fragment);

  params->state.Set(
      state_fragment.is_null() ? nullptr : state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null state in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("WaitForTokenInRange");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool GpuChannel_WaitForTokenInRange_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GpuChannel_WaitForTokenInRange_ResponseParams_Data* params =
      reinterpret_cast<internal::GpuChannel_WaitForTokenInRange_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for GpuChannel.10
  bool success = true;
  ::gpu::CommandBuffer::State p_state{};
  GpuChannel_WaitForTokenInRange_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadState(&p_state))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuChannel::Name_, 10, true);
    return false;
  }
  *out_state_ = std::move(p_state);
  *result_ = true;
  return true;
}
class GpuChannel_WaitForGetOffsetInRange_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static GpuChannel::WaitForGetOffsetInRangeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<GpuChannel_WaitForGetOffsetInRange_ProxyToResponder> proxy(
        new GpuChannel_WaitForGetOffsetInRange_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&GpuChannel_WaitForGetOffsetInRange_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuChannel_WaitForGetOffsetInRange_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  GpuChannel_WaitForGetOffsetInRange_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GpuChannel::WaitForGetOffsetInRangeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::gpu::CommandBuffer::State& in_state);
};

bool GpuChannel_WaitForGetOffsetInRange_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GpuChannel_WaitForGetOffsetInRange_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuChannel_WaitForGetOffsetInRange_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for GpuChannel.11
  bool success = true;
  ::gpu::CommandBuffer::State p_state{};
  GpuChannel_WaitForGetOffsetInRange_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadState(&p_state))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuChannel::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_state));
  }
  return true;
}

void GpuChannel_WaitForGetOffsetInRange_ProxyToResponder::Run(
    const ::gpu::CommandBuffer::State& in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply gpu::mojom::GpuChannel::WaitForGetOffsetInRange", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type const ::gpu::CommandBuffer::State&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuChannel::kWaitForGetOffsetInRange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_WaitForGetOffsetInRange_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->state)::BaseType> state_fragment(
          params.message());
  
  mojo::internal::Serialize<::gpu::mojom::CommandBufferStateDataView>(
    in_state,
    state_fragment);

  params->state.Set(
      state_fragment.is_null() ? nullptr : state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null state in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("WaitForGetOffsetInRange");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool GpuChannel_WaitForGetOffsetInRange_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GpuChannel_WaitForGetOffsetInRange_ResponseParams_Data* params =
      reinterpret_cast<internal::GpuChannel_WaitForGetOffsetInRange_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for GpuChannel.11
  bool success = true;
  ::gpu::CommandBuffer::State p_state{};
  GpuChannel_WaitForGetOffsetInRange_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadState(&p_state))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuChannel::Name_, 11, true);
    return false;
  }
  *out_state_ = std::move(p_state);
  *result_ = true;
  return true;
}

// static
bool GpuChannelStubDispatch::Accept(
    GpuChannel* impl,
    mojo::Message* message) {
  switch (static_cast<messages::GpuChannel>(message->header()->name)) {
    case messages::GpuChannel::kCrashForTesting: {
      DCHECK(message->is_serialized());
      internal::GpuChannel_CrashForTesting_Params_Data* params =
          reinterpret_cast<internal::GpuChannel_CrashForTesting_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GpuChannel.0
      bool success = true;
      GpuChannel_CrashForTesting_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuChannel::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CrashForTesting(        );
      return true;
    }
    case messages::GpuChannel::kTerminateForTesting: {
      DCHECK(message->is_serialized());
      internal::GpuChannel_TerminateForTesting_Params_Data* params =
          reinterpret_cast<internal::GpuChannel_TerminateForTesting_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GpuChannel.1
      bool success = true;
      GpuChannel_TerminateForTesting_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuChannel::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TerminateForTesting(        );
      return true;
    }
    case messages::GpuChannel::kGetChannelToken: {
      break;
    }
    case messages::GpuChannel::kFlush: {
      break;
    }
    case messages::GpuChannel::kGetSharedMemoryForFlushId: {
      break;
    }
    case messages::GpuChannel::kCreateCommandBuffer: {
      break;
    }
    case messages::GpuChannel::kDestroyCommandBuffer: {
      break;
    }
    case messages::GpuChannel::kScheduleImageDecode: {
      DCHECK(message->is_serialized());
      internal::GpuChannel_ScheduleImageDecode_Params_Data* params =
          reinterpret_cast<internal::GpuChannel_ScheduleImageDecode_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GpuChannel.7
      bool success = true;
      ScheduleImageDecodeParamsPtr p_params{};
      uint64_t p_decode_release_count{};
      GpuChannel_ScheduleImageDecode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success)
        p_decode_release_count = input_data_view.decode_release_count();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuChannel::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ScheduleImageDecode(        
        std::move(p_params), 
        std::move(p_decode_release_count));
      return true;
    }
    case messages::GpuChannel::kFlushDeferredRequests: {
      DCHECK(message->is_serialized());
      internal::GpuChannel_FlushDeferredRequests_Params_Data* params =
          reinterpret_cast<internal::GpuChannel_FlushDeferredRequests_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GpuChannel.8
      bool success = true;
      std::vector<DeferredRequestPtr> p_requests{};
      uint32_t p_flushed_deferred_message_id{};
      GpuChannel_FlushDeferredRequests_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequests(&p_requests))
        success = false;
      if (success)
        p_flushed_deferred_message_id = input_data_view.flushed_deferred_message_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuChannel::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FlushDeferredRequests(        
        std::move(p_requests), 
        std::move(p_flushed_deferred_message_id));
      return true;
    }
    case messages::GpuChannel::kCreateGpuMemoryBuffer: {
      break;
    }
    case messages::GpuChannel::kWaitForTokenInRange: {
      break;
    }
    case messages::GpuChannel::kWaitForGetOffsetInRange: {
      break;
    }
  }
  return false;
}

// static
bool GpuChannelStubDispatch::AcceptWithResponder(
    GpuChannel* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::GpuChannel>(message->header()->name)) {
    case messages::GpuChannel::kCrashForTesting: {
      break;
    }
    case messages::GpuChannel::kTerminateForTesting: {
      break;
    }
    case messages::GpuChannel::kGetChannelToken: {
      internal::GpuChannel_GetChannelToken_Params_Data* params =
          reinterpret_cast<
              internal::GpuChannel_GetChannelToken_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for GpuChannel.2
      bool success = true;
      GpuChannel_GetChannelToken_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuChannel::Name_, 2, false);
        return false;
      }
      auto callback =
          GpuChannel_GetChannelToken_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetChannelToken(std::move(callback));
      return true;
    }
    case messages::GpuChannel::kFlush: {
      internal::GpuChannel_Flush_Params_Data* params =
          reinterpret_cast<
              internal::GpuChannel_Flush_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for GpuChannel.3
      bool success = true;
      GpuChannel_Flush_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuChannel::Name_, 3, false);
        return false;
      }
      auto callback =
          GpuChannel_Flush_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Flush(std::move(callback));
      return true;
    }
    case messages::GpuChannel::kGetSharedMemoryForFlushId: {
      internal::GpuChannel_GetSharedMemoryForFlushId_Params_Data* params =
          reinterpret_cast<
              internal::GpuChannel_GetSharedMemoryForFlushId_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for GpuChannel.4
      bool success = true;
      GpuChannel_GetSharedMemoryForFlushId_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuChannel::Name_, 4, false);
        return false;
      }
      auto callback =
          GpuChannel_GetSharedMemoryForFlushId_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSharedMemoryForFlushId(std::move(callback));
      return true;
    }
    case messages::GpuChannel::kCreateCommandBuffer: {
      internal::GpuChannel_CreateCommandBuffer_Params_Data* params =
          reinterpret_cast<
              internal::GpuChannel_CreateCommandBuffer_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for GpuChannel.5
      bool success = true;
      CreateCommandBufferParamsPtr p_params{};
      int32_t p_routing_id{};
      ::base::UnsafeSharedMemoryRegion p_shared_state{};
      ::mojo::PendingAssociatedReceiver<CommandBuffer> p_receiver{};
      ::mojo::PendingAssociatedRemote<CommandBufferClient> p_client{};
      GpuChannel_CreateCommandBuffer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success)
        p_routing_id = input_data_view.routing_id();
      if (success && !input_data_view.ReadSharedState(&p_shared_state))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuChannel::Name_, 5, false);
        return false;
      }
      auto callback =
          GpuChannel_CreateCommandBuffer_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateCommandBuffer(        
        std::move(p_params), 
        std::move(p_routing_id), 
        std::move(p_shared_state), 
        std::move(p_receiver), 
        std::move(p_client), std::move(callback));
      return true;
    }
    case messages::GpuChannel::kDestroyCommandBuffer: {
      internal::GpuChannel_DestroyCommandBuffer_Params_Data* params =
          reinterpret_cast<
              internal::GpuChannel_DestroyCommandBuffer_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for GpuChannel.6
      bool success = true;
      int32_t p_routing_id{};
      GpuChannel_DestroyCommandBuffer_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_routing_id = input_data_view.routing_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuChannel::Name_, 6, false);
        return false;
      }
      auto callback =
          GpuChannel_DestroyCommandBuffer_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DestroyCommandBuffer(        
        std::move(p_routing_id), std::move(callback));
      return true;
    }
    case messages::GpuChannel::kScheduleImageDecode: {
      break;
    }
    case messages::GpuChannel::kFlushDeferredRequests: {
      break;
    }
    case messages::GpuChannel::kCreateGpuMemoryBuffer: {
      internal::GpuChannel_CreateGpuMemoryBuffer_Params_Data* params =
          reinterpret_cast<
              internal::GpuChannel_CreateGpuMemoryBuffer_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for GpuChannel.9
      bool success = true;
      ::gfx::Size p_size{};
      ::viz::SharedImageFormat p_format{};
      ::gfx::BufferUsage p_buffer_usage{};
      GpuChannel_CreateGpuMemoryBuffer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSize(&p_size))
        success = false;
      if (success && !input_data_view.ReadFormat(&p_format))
        success = false;
      if (success && !input_data_view.ReadBufferUsage(&p_buffer_usage))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuChannel::Name_, 9, false);
        return false;
      }
      auto callback =
          GpuChannel_CreateGpuMemoryBuffer_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateGpuMemoryBuffer(        
        std::move(p_size), 
        std::move(p_format), 
        std::move(p_buffer_usage), std::move(callback));
      return true;
    }
    case messages::GpuChannel::kWaitForTokenInRange: {
      internal::GpuChannel_WaitForTokenInRange_Params_Data* params =
          reinterpret_cast<
              internal::GpuChannel_WaitForTokenInRange_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for GpuChannel.10
      bool success = true;
      int32_t p_routing_id{};
      int32_t p_start{};
      int32_t p_end{};
      GpuChannel_WaitForTokenInRange_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_routing_id = input_data_view.routing_id();
      if (success)
        p_start = input_data_view.start();
      if (success)
        p_end = input_data_view.end();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuChannel::Name_, 10, false);
        return false;
      }
      auto callback =
          GpuChannel_WaitForTokenInRange_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WaitForTokenInRange(        
        std::move(p_routing_id), 
        std::move(p_start), 
        std::move(p_end), std::move(callback));
      return true;
    }
    case messages::GpuChannel::kWaitForGetOffsetInRange: {
      internal::GpuChannel_WaitForGetOffsetInRange_Params_Data* params =
          reinterpret_cast<
              internal::GpuChannel_WaitForGetOffsetInRange_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for GpuChannel.11
      bool success = true;
      int32_t p_routing_id{};
      uint32_t p_set_get_buffer_count{};
      int32_t p_start{};
      int32_t p_end{};
      GpuChannel_WaitForGetOffsetInRange_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_routing_id = input_data_view.routing_id();
      if (success)
        p_set_get_buffer_count = input_data_view.set_get_buffer_count();
      if (success)
        p_start = input_data_view.start();
      if (success)
        p_end = input_data_view.end();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuChannel::Name_, 11, false);
        return false;
      }
      auto callback =
          GpuChannel_WaitForGetOffsetInRange_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WaitForGetOffsetInRange(        
        std::move(p_routing_id), 
        std::move(p_set_get_buffer_count), 
        std::move(p_start), 
        std::move(p_end), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kGpuChannelValidationInfo[] = {
    {base::to_underlying(messages::GpuChannel::kCrashForTesting),
     { &internal::GpuChannel_CrashForTesting_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::GpuChannel::kTerminateForTesting),
     { &internal::GpuChannel_TerminateForTesting_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::GpuChannel::kGetChannelToken),
     { &internal::GpuChannel_GetChannelToken_Params_Data::Validate,
      &internal::GpuChannel_GetChannelToken_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::GpuChannel::kFlush),
     { &internal::GpuChannel_Flush_Params_Data::Validate,
      &internal::GpuChannel_Flush_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::GpuChannel::kGetSharedMemoryForFlushId),
     { &internal::GpuChannel_GetSharedMemoryForFlushId_Params_Data::Validate,
      &internal::GpuChannel_GetSharedMemoryForFlushId_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::GpuChannel::kCreateCommandBuffer),
     { &internal::GpuChannel_CreateCommandBuffer_Params_Data::Validate,
      &internal::GpuChannel_CreateCommandBuffer_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::GpuChannel::kDestroyCommandBuffer),
     { &internal::GpuChannel_DestroyCommandBuffer_Params_Data::Validate,
      &internal::GpuChannel_DestroyCommandBuffer_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::GpuChannel::kScheduleImageDecode),
     { &internal::GpuChannel_ScheduleImageDecode_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::GpuChannel::kFlushDeferredRequests),
     { &internal::GpuChannel_FlushDeferredRequests_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::GpuChannel::kCreateGpuMemoryBuffer),
     { &internal::GpuChannel_CreateGpuMemoryBuffer_Params_Data::Validate,
      &internal::GpuChannel_CreateGpuMemoryBuffer_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::GpuChannel::kWaitForTokenInRange),
     { &internal::GpuChannel_WaitForTokenInRange_Params_Data::Validate,
      &internal::GpuChannel_WaitForTokenInRange_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::GpuChannel::kWaitForGetOffsetInRange),
     { &internal::GpuChannel_WaitForGetOffsetInRange_Params_Data::Validate,
      &internal::GpuChannel_WaitForGetOffsetInRange_ResponseParams_Data::Validate}},
};

bool GpuChannelRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::gpu::mojom::GpuChannel::Name_,
    kGpuChannelValidationInfo);
}

bool GpuChannelResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::gpu::mojom::GpuChannel::Name_,
    kGpuChannelValidationInfo);

}
// The declaration includes the definition on other builds.

CommandBuffer::IPCStableHashFunction CommandBuffer::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CommandBuffer>(message.name())) {
    case messages::CommandBuffer::kSetGetBuffer: {
      return &CommandBuffer::SetGetBuffer_Sym::IPCStableHash;
    }
    case messages::CommandBuffer::kRegisterTransferBuffer: {
      return &CommandBuffer::RegisterTransferBuffer_Sym::IPCStableHash;
    }
    case messages::CommandBuffer::kCreateGpuFenceFromHandle: {
      return &CommandBuffer::CreateGpuFenceFromHandle_Sym::IPCStableHash;
    }
    case messages::CommandBuffer::kGetGpuFenceHandle: {
      return &CommandBuffer::GetGpuFenceHandle_Sym::IPCStableHash;
    }
    case messages::CommandBuffer::kSignalSyncToken: {
      return &CommandBuffer::SignalSyncToken_Sym::IPCStableHash;
    }
    case messages::CommandBuffer::kSignalQuery: {
      return &CommandBuffer::SignalQuery_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CommandBuffer::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CommandBuffer>(message.name())) {
      case messages::CommandBuffer::kSetGetBuffer:
            return "Receive gpu::mojom::CommandBuffer::SetGetBuffer";
      case messages::CommandBuffer::kRegisterTransferBuffer:
            return "Receive gpu::mojom::CommandBuffer::RegisterTransferBuffer";
      case messages::CommandBuffer::kCreateGpuFenceFromHandle:
            return "Receive gpu::mojom::CommandBuffer::CreateGpuFenceFromHandle";
      case messages::CommandBuffer::kGetGpuFenceHandle:
            return "Receive gpu::mojom::CommandBuffer::GetGpuFenceHandle";
      case messages::CommandBuffer::kSignalSyncToken:
            return "Receive gpu::mojom::CommandBuffer::SignalSyncToken";
      case messages::CommandBuffer::kSignalQuery:
            return "Receive gpu::mojom::CommandBuffer::SignalQuery";
    }
  } else {
    switch (static_cast<messages::CommandBuffer>(message.name())) {
      case messages::CommandBuffer::kSetGetBuffer:
            return "Receive reply gpu::mojom::CommandBuffer::SetGetBuffer";
      case messages::CommandBuffer::kRegisterTransferBuffer:
            return "Receive reply gpu::mojom::CommandBuffer::RegisterTransferBuffer";
      case messages::CommandBuffer::kCreateGpuFenceFromHandle:
            return "Receive reply gpu::mojom::CommandBuffer::CreateGpuFenceFromHandle";
      case messages::CommandBuffer::kGetGpuFenceHandle:
            return "Receive reply gpu::mojom::CommandBuffer::GetGpuFenceHandle";
      case messages::CommandBuffer::kSignalSyncToken:
            return "Receive reply gpu::mojom::CommandBuffer::SignalSyncToken";
      case messages::CommandBuffer::kSignalQuery:
            return "Receive reply gpu::mojom::CommandBuffer::SignalQuery";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CommandBuffer::SetGetBuffer_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5391799f;  // IPCStableHash for gpu::mojom::CommandBuffer::SetGetBuffer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CommandBuffer::RegisterTransferBuffer_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa9f26fae;  // IPCStableHash for gpu::mojom::CommandBuffer::RegisterTransferBuffer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CommandBuffer::CreateGpuFenceFromHandle_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x75431a93;  // IPCStableHash for gpu::mojom::CommandBuffer::CreateGpuFenceFromHandle
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CommandBuffer::GetGpuFenceHandle_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0c2da215;  // IPCStableHash for gpu::mojom::CommandBuffer::GetGpuFenceHandle
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CommandBuffer::SignalSyncToken_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcf135daa;  // IPCStableHash for gpu::mojom::CommandBuffer::SignalSyncToken
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CommandBuffer::SignalQuery_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x24f9b3d7;  // IPCStableHash for gpu::mojom::CommandBuffer::SignalQuery
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class CommandBuffer_GetGpuFenceHandle_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CommandBuffer_GetGpuFenceHandle_ForwardToCallback(
      CommandBuffer::GetGpuFenceHandleCallback callback
      ) : callback_(std::move(callback)) {
  }

  CommandBuffer_GetGpuFenceHandle_ForwardToCallback(const CommandBuffer_GetGpuFenceHandle_ForwardToCallback&) = delete;
  CommandBuffer_GetGpuFenceHandle_ForwardToCallback& operator=(const CommandBuffer_GetGpuFenceHandle_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CommandBuffer::GetGpuFenceHandleCallback callback_;
};

CommandBufferProxy::CommandBufferProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CommandBufferProxy::SetGetBuffer(
    int32_t in_shm_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send gpu::mojom::CommandBuffer::SetGetBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shm_id"), in_shm_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CommandBuffer::kSetGetBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::CommandBuffer_SetGetBuffer_Params_Data> params(
          message);
  params.Allocate();

  params->shm_id = in_shm_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommandBuffer::Name_);
  message.set_method_name("SetGetBuffer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CommandBufferProxy::RegisterTransferBuffer(
    int32_t in_id, ::base::UnsafeSharedMemoryRegion in_buffer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send gpu::mojom::CommandBuffer::RegisterTransferBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type ::base::UnsafeSharedMemoryRegion>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CommandBuffer::kRegisterTransferBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::CommandBuffer_RegisterTransferBuffer_Params_Data> params(
          message);
  params.Allocate();

  params->id = in_id;
  mojo::internal::MessageFragment<
      typename decltype(params->buffer)::BaseType> buffer_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView>(
    in_buffer,
    buffer_fragment);

  params->buffer.Set(
      buffer_fragment.is_null() ? nullptr : buffer_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->buffer.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null buffer in CommandBuffer.RegisterTransferBuffer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommandBuffer::Name_);
  message.set_method_name("RegisterTransferBuffer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CommandBufferProxy::CreateGpuFenceFromHandle(
    uint32_t in_gpu_fence_id, ::gfx::GpuFenceHandle in_fence_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send gpu::mojom::CommandBuffer::CreateGpuFenceFromHandle", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gpu_fence_id"), in_gpu_fence_id,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fence_handle"), in_fence_handle,
                        "<value of type ::gfx::GpuFenceHandle>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CommandBuffer::kCreateGpuFenceFromHandle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::CommandBuffer_CreateGpuFenceFromHandle_Params_Data> params(
          message);
  params.Allocate();

  params->gpu_fence_id = in_gpu_fence_id;
  mojo::internal::MessageFragment<
      typename decltype(params->fence_handle)::BaseType> fence_handle_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::GpuFenceHandleDataView>(
    in_fence_handle,
    fence_handle_fragment);

  params->fence_handle.Set(
      fence_handle_fragment.is_null() ? nullptr : fence_handle_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->fence_handle.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null fence_handle in CommandBuffer.CreateGpuFenceFromHandle request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommandBuffer::Name_);
  message.set_method_name("CreateGpuFenceFromHandle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CommandBufferProxy::GetGpuFenceHandle(
    uint32_t in_id, GetGpuFenceHandleCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send gpu::mojom::CommandBuffer::GetGpuFenceHandle", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CommandBuffer::kGetGpuFenceHandle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::CommandBuffer_GetGpuFenceHandle_Params_Data> params(
          message);
  params.Allocate();

  params->id = in_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommandBuffer::Name_);
  message.set_method_name("GetGpuFenceHandle");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CommandBuffer_GetGpuFenceHandle_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CommandBufferProxy::SignalSyncToken(
    const ::gpu::SyncToken& in_sync_token, uint32_t in_signal_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send gpu::mojom::CommandBuffer::SignalSyncToken", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sync_token"), in_sync_token,
                        "<value of type const ::gpu::SyncToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("signal_id"), in_signal_id,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CommandBuffer::kSignalSyncToken), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::CommandBuffer_SignalSyncToken_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->sync_token)::BaseType> sync_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView>(
    in_sync_token,
    sync_token_fragment);

  params->sync_token.Set(
      sync_token_fragment.is_null() ? nullptr : sync_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->sync_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null sync_token in CommandBuffer.SignalSyncToken request");

  params->signal_id = in_signal_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommandBuffer::Name_);
  message.set_method_name("SignalSyncToken");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CommandBufferProxy::SignalQuery(
    uint32_t in_query, uint32_t in_signal_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send gpu::mojom::CommandBuffer::SignalQuery", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("query"), in_query,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("signal_id"), in_signal_id,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CommandBuffer::kSignalQuery), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::CommandBuffer_SignalQuery_Params_Data> params(
          message);
  params.Allocate();

  params->query = in_query;

  params->signal_id = in_signal_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommandBuffer::Name_);
  message.set_method_name("SignalQuery");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class CommandBuffer_GetGpuFenceHandle_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CommandBuffer::GetGpuFenceHandleCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CommandBuffer_GetGpuFenceHandle_ProxyToResponder> proxy(
        new CommandBuffer_GetGpuFenceHandle_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CommandBuffer_GetGpuFenceHandle_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CommandBuffer_GetGpuFenceHandle_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CommandBuffer_GetGpuFenceHandle_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CommandBuffer::GetGpuFenceHandleCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::gfx::GpuFenceHandle in_fence_handle);
};

bool CommandBuffer_GetGpuFenceHandle_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CommandBuffer_GetGpuFenceHandle_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CommandBuffer_GetGpuFenceHandle_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CommandBuffer.3
  bool success = true;
  ::gfx::GpuFenceHandle p_fence_handle{};
  CommandBuffer_GetGpuFenceHandle_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFenceHandle(&p_fence_handle))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CommandBuffer::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_fence_handle));
  }
  return true;
}

void CommandBuffer_GetGpuFenceHandle_ProxyToResponder::Run(
    ::gfx::GpuFenceHandle in_fence_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply gpu::mojom::CommandBuffer::GetGpuFenceHandle", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fence_handle"), in_fence_handle,
                        "<value of type ::gfx::GpuFenceHandle>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CommandBuffer::kGetGpuFenceHandle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::CommandBuffer_GetGpuFenceHandle_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->fence_handle)::BaseType> fence_handle_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::GpuFenceHandleDataView>(
    in_fence_handle,
    fence_handle_fragment);

  params->fence_handle.Set(
      fence_handle_fragment.is_null() ? nullptr : fence_handle_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommandBuffer::Name_);
  message.set_method_name("GetGpuFenceHandle");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CommandBufferStubDispatch::Accept(
    CommandBuffer* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CommandBuffer>(message->header()->name)) {
    case messages::CommandBuffer::kSetGetBuffer: {
      DCHECK(message->is_serialized());
      internal::CommandBuffer_SetGetBuffer_Params_Data* params =
          reinterpret_cast<internal::CommandBuffer_SetGetBuffer_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CommandBuffer.0
      bool success = true;
      int32_t p_shm_id{};
      CommandBuffer_SetGetBuffer_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_shm_id = input_data_view.shm_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommandBuffer::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetGetBuffer(        
        std::move(p_shm_id));
      return true;
    }
    case messages::CommandBuffer::kRegisterTransferBuffer: {
      DCHECK(message->is_serialized());
      internal::CommandBuffer_RegisterTransferBuffer_Params_Data* params =
          reinterpret_cast<internal::CommandBuffer_RegisterTransferBuffer_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CommandBuffer.1
      bool success = true;
      int32_t p_id{};
      ::base::UnsafeSharedMemoryRegion p_buffer{};
      CommandBuffer_RegisterTransferBuffer_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_id = input_data_view.id();
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommandBuffer::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterTransferBuffer(        
        std::move(p_id), 
        std::move(p_buffer));
      return true;
    }
    case messages::CommandBuffer::kCreateGpuFenceFromHandle: {
      DCHECK(message->is_serialized());
      internal::CommandBuffer_CreateGpuFenceFromHandle_Params_Data* params =
          reinterpret_cast<internal::CommandBuffer_CreateGpuFenceFromHandle_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CommandBuffer.2
      bool success = true;
      uint32_t p_gpu_fence_id{};
      ::gfx::GpuFenceHandle p_fence_handle{};
      CommandBuffer_CreateGpuFenceFromHandle_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_gpu_fence_id = input_data_view.gpu_fence_id();
      if (success && !input_data_view.ReadFenceHandle(&p_fence_handle))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommandBuffer::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateGpuFenceFromHandle(        
        std::move(p_gpu_fence_id), 
        std::move(p_fence_handle));
      return true;
    }
    case messages::CommandBuffer::kGetGpuFenceHandle: {
      break;
    }
    case messages::CommandBuffer::kSignalSyncToken: {
      DCHECK(message->is_serialized());
      internal::CommandBuffer_SignalSyncToken_Params_Data* params =
          reinterpret_cast<internal::CommandBuffer_SignalSyncToken_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CommandBuffer.4
      bool success = true;
      ::gpu::SyncToken p_sync_token{};
      uint32_t p_signal_id{};
      CommandBuffer_SignalSyncToken_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSyncToken(&p_sync_token))
        success = false;
      if (success)
        p_signal_id = input_data_view.signal_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommandBuffer::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SignalSyncToken(        
        std::move(p_sync_token), 
        std::move(p_signal_id));
      return true;
    }
    case messages::CommandBuffer::kSignalQuery: {
      DCHECK(message->is_serialized());
      internal::CommandBuffer_SignalQuery_Params_Data* params =
          reinterpret_cast<internal::CommandBuffer_SignalQuery_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CommandBuffer.5
      bool success = true;
      uint32_t p_query{};
      uint32_t p_signal_id{};
      CommandBuffer_SignalQuery_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_query = input_data_view.query();
      if (success)
        p_signal_id = input_data_view.signal_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommandBuffer::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SignalQuery(        
        std::move(p_query), 
        std::move(p_signal_id));
      return true;
    }
  }
  return false;
}

// static
bool CommandBufferStubDispatch::AcceptWithResponder(
    CommandBuffer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CommandBuffer>(message->header()->name)) {
    case messages::CommandBuffer::kSetGetBuffer: {
      break;
    }
    case messages::CommandBuffer::kRegisterTransferBuffer: {
      break;
    }
    case messages::CommandBuffer::kCreateGpuFenceFromHandle: {
      break;
    }
    case messages::CommandBuffer::kGetGpuFenceHandle: {
      internal::CommandBuffer_GetGpuFenceHandle_Params_Data* params =
          reinterpret_cast<
              internal::CommandBuffer_GetGpuFenceHandle_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CommandBuffer.3
      bool success = true;
      uint32_t p_id{};
      CommandBuffer_GetGpuFenceHandle_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_id = input_data_view.id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommandBuffer::Name_, 3, false);
        return false;
      }
      auto callback =
          CommandBuffer_GetGpuFenceHandle_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetGpuFenceHandle(        
        std::move(p_id), std::move(callback));
      return true;
    }
    case messages::CommandBuffer::kSignalSyncToken: {
      break;
    }
    case messages::CommandBuffer::kSignalQuery: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCommandBufferValidationInfo[] = {
    {base::to_underlying(messages::CommandBuffer::kSetGetBuffer),
     { &internal::CommandBuffer_SetGetBuffer_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::CommandBuffer::kRegisterTransferBuffer),
     { &internal::CommandBuffer_RegisterTransferBuffer_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::CommandBuffer::kCreateGpuFenceFromHandle),
     { &internal::CommandBuffer_CreateGpuFenceFromHandle_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::CommandBuffer::kGetGpuFenceHandle),
     { &internal::CommandBuffer_GetGpuFenceHandle_Params_Data::Validate,
      &internal::CommandBuffer_GetGpuFenceHandle_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::CommandBuffer::kSignalSyncToken),
     { &internal::CommandBuffer_SignalSyncToken_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::CommandBuffer::kSignalQuery),
     { &internal::CommandBuffer_SignalQuery_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CommandBufferRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::gpu::mojom::CommandBuffer::Name_,
    kCommandBufferValidationInfo);
}

bool CommandBufferResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::gpu::mojom::CommandBuffer::Name_,
    kCommandBufferValidationInfo);

}
// The declaration includes the definition on other builds.

CommandBufferClient::IPCStableHashFunction CommandBufferClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CommandBufferClient>(message.name())) {
    case messages::CommandBufferClient::kOnConsoleMessage: {
      return &CommandBufferClient::OnConsoleMessage_Sym::IPCStableHash;
    }
    case messages::CommandBufferClient::kOnGpuSwitched: {
      return &CommandBufferClient::OnGpuSwitched_Sym::IPCStableHash;
    }
    case messages::CommandBufferClient::kOnDestroyed: {
      return &CommandBufferClient::OnDestroyed_Sym::IPCStableHash;
    }
    case messages::CommandBufferClient::kOnReturnData: {
      return &CommandBufferClient::OnReturnData_Sym::IPCStableHash;
    }
    case messages::CommandBufferClient::kOnSignalAck: {
      return &CommandBufferClient::OnSignalAck_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CommandBufferClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CommandBufferClient>(message.name())) {
      case messages::CommandBufferClient::kOnConsoleMessage:
            return "Receive gpu::mojom::CommandBufferClient::OnConsoleMessage";
      case messages::CommandBufferClient::kOnGpuSwitched:
            return "Receive gpu::mojom::CommandBufferClient::OnGpuSwitched";
      case messages::CommandBufferClient::kOnDestroyed:
            return "Receive gpu::mojom::CommandBufferClient::OnDestroyed";
      case messages::CommandBufferClient::kOnReturnData:
            return "Receive gpu::mojom::CommandBufferClient::OnReturnData";
      case messages::CommandBufferClient::kOnSignalAck:
            return "Receive gpu::mojom::CommandBufferClient::OnSignalAck";
    }
  } else {
    switch (static_cast<messages::CommandBufferClient>(message.name())) {
      case messages::CommandBufferClient::kOnConsoleMessage:
            return "Receive reply gpu::mojom::CommandBufferClient::OnConsoleMessage";
      case messages::CommandBufferClient::kOnGpuSwitched:
            return "Receive reply gpu::mojom::CommandBufferClient::OnGpuSwitched";
      case messages::CommandBufferClient::kOnDestroyed:
            return "Receive reply gpu::mojom::CommandBufferClient::OnDestroyed";
      case messages::CommandBufferClient::kOnReturnData:
            return "Receive reply gpu::mojom::CommandBufferClient::OnReturnData";
      case messages::CommandBufferClient::kOnSignalAck:
            return "Receive reply gpu::mojom::CommandBufferClient::OnSignalAck";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CommandBufferClient::OnConsoleMessage_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcd9e7434;  // IPCStableHash for gpu::mojom::CommandBufferClient::OnConsoleMessage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CommandBufferClient::OnGpuSwitched_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xaee76519;  // IPCStableHash for gpu::mojom::CommandBufferClient::OnGpuSwitched
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CommandBufferClient::OnDestroyed_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x278e479a;  // IPCStableHash for gpu::mojom::CommandBufferClient::OnDestroyed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CommandBufferClient::OnReturnData_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9f96904a;  // IPCStableHash for gpu::mojom::CommandBufferClient::OnReturnData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CommandBufferClient::OnSignalAck_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcbc93780;  // IPCStableHash for gpu::mojom::CommandBufferClient::OnSignalAck
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CommandBufferClientProxy::CommandBufferClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CommandBufferClientProxy::OnConsoleMessage(
    const std::string& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send gpu::mojom::CommandBufferClient::OnConsoleMessage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CommandBufferClient::kOnConsoleMessage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::CommandBufferClient_OnConsoleMessage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in CommandBufferClient.OnConsoleMessage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommandBufferClient::Name_);
  message.set_method_name("OnConsoleMessage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CommandBufferClientProxy::OnGpuSwitched(
    ::gl::GpuPreference in_active_gpu_heuristic) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send gpu::mojom::CommandBufferClient::OnGpuSwitched", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("active_gpu_heuristic"), in_active_gpu_heuristic,
                        "<value of type ::gl::GpuPreference>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CommandBufferClient::kOnGpuSwitched), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::CommandBufferClient_OnGpuSwitched_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::gl::mojom::GpuPreference>(
    in_active_gpu_heuristic,
    &params->active_gpu_heuristic);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommandBufferClient::Name_);
  message.set_method_name("OnGpuSwitched");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CommandBufferClientProxy::OnDestroyed(
    ::gpu::error::ContextLostReason in_reason, ::gpu::error::Error in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send gpu::mojom::CommandBufferClient::OnDestroyed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type ::gpu::error::ContextLostReason>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::gpu::error::Error>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CommandBufferClient::kOnDestroyed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::CommandBufferClient_OnDestroyed_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::gpu::mojom::ContextLostReason>(
    in_reason,
    &params->reason);

  
  mojo::internal::Serialize<::gpu::mojom::Error>(
    in_error,
    &params->error);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommandBufferClient::Name_);
  message.set_method_name("OnDestroyed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CommandBufferClientProxy::OnReturnData(
    const std::vector<uint8_t>& in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send gpu::mojom::CommandBufferClient::OnReturnData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CommandBufferClient::kOnReturnData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::CommandBufferClient_OnReturnData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_data,
    data_fragment,
    &data_validate_params);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in CommandBufferClient.OnReturnData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommandBufferClient::Name_);
  message.set_method_name("OnReturnData");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CommandBufferClientProxy::OnSignalAck(
    uint32_t in_signal_id, const ::gpu::CommandBuffer::State& in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send gpu::mojom::CommandBufferClient::OnSignalAck", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("signal_id"), in_signal_id,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type const ::gpu::CommandBuffer::State&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CommandBufferClient::kOnSignalAck), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::CommandBufferClient_OnSignalAck_Params_Data> params(
          message);
  params.Allocate();

  params->signal_id = in_signal_id;
  mojo::internal::MessageFragment<
      typename decltype(params->state)::BaseType> state_fragment(
          params.message());
  
  mojo::internal::Serialize<::gpu::mojom::CommandBufferStateDataView>(
    in_state,
    state_fragment);

  params->state.Set(
      state_fragment.is_null() ? nullptr : state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null state in CommandBufferClient.OnSignalAck request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommandBufferClient::Name_);
  message.set_method_name("OnSignalAck");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CommandBufferClientStubDispatch::Accept(
    CommandBufferClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CommandBufferClient>(message->header()->name)) {
    case messages::CommandBufferClient::kOnConsoleMessage: {
      DCHECK(message->is_serialized());
      internal::CommandBufferClient_OnConsoleMessage_Params_Data* params =
          reinterpret_cast<internal::CommandBufferClient_OnConsoleMessage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CommandBufferClient.0
      bool success = true;
      std::string p_message{};
      CommandBufferClient_OnConsoleMessage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommandBufferClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnConsoleMessage(        
        std::move(p_message));
      return true;
    }
    case messages::CommandBufferClient::kOnGpuSwitched: {
      DCHECK(message->is_serialized());
      internal::CommandBufferClient_OnGpuSwitched_Params_Data* params =
          reinterpret_cast<internal::CommandBufferClient_OnGpuSwitched_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CommandBufferClient.1
      bool success = true;
      ::gl::GpuPreference p_active_gpu_heuristic{};
      CommandBufferClient_OnGpuSwitched_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadActiveGpuHeuristic(&p_active_gpu_heuristic))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommandBufferClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnGpuSwitched(        
        std::move(p_active_gpu_heuristic));
      return true;
    }
    case messages::CommandBufferClient::kOnDestroyed: {
      DCHECK(message->is_serialized());
      internal::CommandBufferClient_OnDestroyed_Params_Data* params =
          reinterpret_cast<internal::CommandBufferClient_OnDestroyed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CommandBufferClient.2
      bool success = true;
      ::gpu::error::ContextLostReason p_reason{};
      ::gpu::error::Error p_error{};
      CommandBufferClient_OnDestroyed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (success && !input_data_view.ReadError(&p_error))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommandBufferClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDestroyed(        
        std::move(p_reason), 
        std::move(p_error));
      return true;
    }
    case messages::CommandBufferClient::kOnReturnData: {
      DCHECK(message->is_serialized());
      internal::CommandBufferClient_OnReturnData_Params_Data* params =
          reinterpret_cast<internal::CommandBufferClient_OnReturnData_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CommandBufferClient.3
      bool success = true;
      std::vector<uint8_t> p_data{};
      CommandBufferClient_OnReturnData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommandBufferClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReturnData(        
        std::move(p_data));
      return true;
    }
    case messages::CommandBufferClient::kOnSignalAck: {
      DCHECK(message->is_serialized());
      internal::CommandBufferClient_OnSignalAck_Params_Data* params =
          reinterpret_cast<internal::CommandBufferClient_OnSignalAck_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CommandBufferClient.4
      bool success = true;
      uint32_t p_signal_id{};
      ::gpu::CommandBuffer::State p_state{};
      CommandBufferClient_OnSignalAck_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_signal_id = input_data_view.signal_id();
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommandBufferClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSignalAck(        
        std::move(p_signal_id), 
        std::move(p_state));
      return true;
    }
  }
  return false;
}

// static
bool CommandBufferClientStubDispatch::AcceptWithResponder(
    CommandBufferClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CommandBufferClient>(message->header()->name)) {
    case messages::CommandBufferClient::kOnConsoleMessage: {
      break;
    }
    case messages::CommandBufferClient::kOnGpuSwitched: {
      break;
    }
    case messages::CommandBufferClient::kOnDestroyed: {
      break;
    }
    case messages::CommandBufferClient::kOnReturnData: {
      break;
    }
    case messages::CommandBufferClient::kOnSignalAck: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCommandBufferClientValidationInfo[] = {
    {base::to_underlying(messages::CommandBufferClient::kOnConsoleMessage),
     { &internal::CommandBufferClient_OnConsoleMessage_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::CommandBufferClient::kOnGpuSwitched),
     { &internal::CommandBufferClient_OnGpuSwitched_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::CommandBufferClient::kOnDestroyed),
     { &internal::CommandBufferClient_OnDestroyed_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::CommandBufferClient::kOnReturnData),
     { &internal::CommandBufferClient_OnReturnData_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::CommandBufferClient::kOnSignalAck),
     { &internal::CommandBufferClient_OnSignalAck_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CommandBufferClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::gpu::mojom::CommandBufferClient::Name_,
    kCommandBufferClientValidationInfo);
}



}  // gpu::mojom


namespace mojo {


// static
bool StructTraits<::gpu::mojom::ContextCreationAttribs::DataView, ::gpu::mojom::ContextCreationAttribsPtr>::Read(
    ::gpu::mojom::ContextCreationAttribs::DataView input,
    ::gpu::mojom::ContextCreationAttribsPtr* output) {
  bool success = true;
  ::gpu::mojom::ContextCreationAttribsPtr result(::gpu::mojom::ContextCreationAttribs::New());
  
      if (success && !input.ReadGpuPreference(&result->gpu_preference))
        success = false;
      if (success)
        result->fail_if_major_perf_caveat = input.fail_if_major_perf_caveat();
      if (success)
        result->lose_context_when_out_of_memory = input.lose_context_when_out_of_memory();
      if (success)
        result->enable_gles2_interface = input.enable_gles2_interface();
      if (success)
        result->enable_grcontext = input.enable_grcontext();
      if (success)
        result->enable_raster_interface = input.enable_raster_interface();
      if (success)
        result->enable_gpu_rasterization = input.enable_gpu_rasterization();
      if (success && !input.ReadContextType(&result->context_type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::CreateCommandBufferParams::DataView, ::gpu::mojom::CreateCommandBufferParamsPtr>::Read(
    ::gpu::mojom::CreateCommandBufferParams::DataView input,
    ::gpu::mojom::CreateCommandBufferParamsPtr* output) {
  bool success = true;
  ::gpu::mojom::CreateCommandBufferParamsPtr result(::gpu::mojom::CreateCommandBufferParams::New());
  
      if (success)
        result->share_group_id = input.share_group_id();
      if (success)
        result->stream_id = input.stream_id();
      if (success && !input.ReadStreamPriority(&result->stream_priority))
        success = false;
      if (success && !input.ReadAttribs(&result->attribs))
        success = false;
      if (success && !input.ReadActiveUrl(&result->active_url))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::CommandBufferState::DataView, ::gpu::mojom::CommandBufferStatePtr>::Read(
    ::gpu::mojom::CommandBufferState::DataView input,
    ::gpu::mojom::CommandBufferStatePtr* output) {
  bool success = true;
  ::gpu::mojom::CommandBufferStatePtr result(::gpu::mojom::CommandBufferState::New());
  
      if (success)
        result->get_offset = input.get_offset();
      if (success)
        result->token = input.token();
      if (success)
        result->release_count = input.release_count();
      if (success && !input.ReadError(&result->error))
        success = false;
      if (success && !input.ReadContextLostReason(&result->context_lost_reason))
        success = false;
      if (success)
        result->generation = input.generation();
      if (success)
        result->set_get_buffer_count = input.set_get_buffer_count();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::ScheduleImageDecodeParams::DataView, ::gpu::mojom::ScheduleImageDecodeParamsPtr>::Read(
    ::gpu::mojom::ScheduleImageDecodeParams::DataView input,
    ::gpu::mojom::ScheduleImageDecodeParamsPtr* output) {
  bool success = true;
  ::gpu::mojom::ScheduleImageDecodeParamsPtr result(::gpu::mojom::ScheduleImageDecodeParams::New());
  
      if (success && !input.ReadEncodedData(&result->encoded_data))
        success = false;
      if (success && !input.ReadOutputSize(&result->output_size))
        success = false;
      if (success)
        result->raster_decoder_route_id = input.raster_decoder_route_id();
      if (success)
        result->transfer_cache_entry_id = input.transfer_cache_entry_id();
      if (success)
        result->discardable_handle_shm_id = input.discardable_handle_shm_id();
      if (success)
        result->discardable_handle_shm_offset = input.discardable_handle_shm_offset();
      if (success)
        result->discardable_handle_release_count = input.discardable_handle_release_count();
      if (success && !input.ReadTargetColorSpace(&result->target_color_space))
        success = false;
      if (success)
        result->needs_mips = input.needs_mips();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::DeferredRequest::DataView, ::gpu::mojom::DeferredRequestPtr>::Read(
    ::gpu::mojom::DeferredRequest::DataView input,
    ::gpu::mojom::DeferredRequestPtr* output) {
  bool success = true;
  ::gpu::mojom::DeferredRequestPtr result(::gpu::mojom::DeferredRequest::New());
  
      if (success && !input.ReadParams(&result->params))
        success = false;
      if (success && !input.ReadSyncTokenFences(&result->sync_token_fences))
        success = false;
      if (success)
        result->release_count = input.release_count();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::DeferredCommandBufferRequest::DataView, ::gpu::mojom::DeferredCommandBufferRequestPtr>::Read(
    ::gpu::mojom::DeferredCommandBufferRequest::DataView input,
    ::gpu::mojom::DeferredCommandBufferRequestPtr* output) {
  bool success = true;
  ::gpu::mojom::DeferredCommandBufferRequestPtr result(::gpu::mojom::DeferredCommandBufferRequest::New());
  
      if (success)
        result->routing_id = input.routing_id();
      if (success && !input.ReadParams(&result->params))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::AsyncFlushParams::DataView, ::gpu::mojom::AsyncFlushParamsPtr>::Read(
    ::gpu::mojom::AsyncFlushParams::DataView input,
    ::gpu::mojom::AsyncFlushParamsPtr* output) {
  bool success = true;
  ::gpu::mojom::AsyncFlushParamsPtr result(::gpu::mojom::AsyncFlushParams::New());
  
      if (success)
        result->put_offset = input.put_offset();
      if (success)
        result->flush_id = input.flush_id();
      if (success && !input.ReadSyncTokenFences(&result->sync_token_fences))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::SharedImageInfo::DataView, ::gpu::mojom::SharedImageInfoPtr>::Read(
    ::gpu::mojom::SharedImageInfo::DataView input,
    ::gpu::mojom::SharedImageInfoPtr* output) {
  bool success = true;
  ::gpu::mojom::SharedImageInfoPtr result(::gpu::mojom::SharedImageInfo::New());
  
      if (success && !input.ReadMeta(&result->meta))
        success = false;
      if (success && !input.ReadDebugLabel(&result->debug_label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::CreateSharedImageParams::DataView, ::gpu::mojom::CreateSharedImageParamsPtr>::Read(
    ::gpu::mojom::CreateSharedImageParams::DataView input,
    ::gpu::mojom::CreateSharedImageParamsPtr* output) {
  bool success = true;
  ::gpu::mojom::CreateSharedImageParamsPtr result(::gpu::mojom::CreateSharedImageParams::New());
  
      if (success && !input.ReadMailbox(&result->mailbox))
        success = false;
      if (success && !input.ReadSiInfo(&result->si_info))
        success = false;
      if (success && !input.ReadPoolId(&result->pool_id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::CreateSharedImageWithDataParams::DataView, ::gpu::mojom::CreateSharedImageWithDataParamsPtr>::Read(
    ::gpu::mojom::CreateSharedImageWithDataParams::DataView input,
    ::gpu::mojom::CreateSharedImageWithDataParamsPtr* output) {
  bool success = true;
  ::gpu::mojom::CreateSharedImageWithDataParamsPtr result(::gpu::mojom::CreateSharedImageWithDataParams::New());
  
      if (success && !input.ReadMailbox(&result->mailbox))
        success = false;
      if (success && !input.ReadSiInfo(&result->si_info))
        success = false;
      if (success)
        result->pixel_data_offset = input.pixel_data_offset();
      if (success)
        result->pixel_data_size = input.pixel_data_size();
      if (success)
        result->done_with_shm = input.done_with_shm();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::CreateSharedImageWithBufferParams::DataView, ::gpu::mojom::CreateSharedImageWithBufferParamsPtr>::Read(
    ::gpu::mojom::CreateSharedImageWithBufferParams::DataView input,
    ::gpu::mojom::CreateSharedImageWithBufferParamsPtr* output) {
  bool success = true;
  ::gpu::mojom::CreateSharedImageWithBufferParamsPtr result(::gpu::mojom::CreateSharedImageWithBufferParams::New());
  
      if (success && !input.ReadMailbox(&result->mailbox))
        success = false;
      if (success && !input.ReadSiInfo(&result->si_info))
        success = false;
      if (success && !input.ReadBufferHandle(&result->buffer_handle))
        success = false;
      if (success && !input.ReadPoolId(&result->pool_id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::UpdateSharedImageParams::DataView, ::gpu::mojom::UpdateSharedImageParamsPtr>::Read(
    ::gpu::mojom::UpdateSharedImageParams::DataView input,
    ::gpu::mojom::UpdateSharedImageParamsPtr* output) {
  bool success = true;
  ::gpu::mojom::UpdateSharedImageParamsPtr result(::gpu::mojom::UpdateSharedImageParams::New());
  
      if (success && !input.ReadMailbox(&result->mailbox))
        success = false;
      if (success && !input.ReadInFenceHandle(&result->in_fence_handle))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::AddReferenceToSharedImageParams::DataView, ::gpu::mojom::AddReferenceToSharedImageParamsPtr>::Read(
    ::gpu::mojom::AddReferenceToSharedImageParams::DataView input,
    ::gpu::mojom::AddReferenceToSharedImageParamsPtr* output) {
  bool success = true;
  ::gpu::mojom::AddReferenceToSharedImageParamsPtr result(::gpu::mojom::AddReferenceToSharedImageParams::New());
  
      if (success && !input.ReadMailbox(&result->mailbox))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::CopyToGpuMemoryBufferParams::DataView, ::gpu::mojom::CopyToGpuMemoryBufferParamsPtr>::Read(
    ::gpu::mojom::CopyToGpuMemoryBufferParams::DataView input,
    ::gpu::mojom::CopyToGpuMemoryBufferParamsPtr* output) {
  bool success = true;
  ::gpu::mojom::CopyToGpuMemoryBufferParamsPtr result(::gpu::mojom::CopyToGpuMemoryBufferParams::New());
  
      if (success && !input.ReadMailbox(&result->mailbox))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::CreateSharedImagePoolParams::DataView, ::gpu::mojom::CreateSharedImagePoolParamsPtr>::Read(
    ::gpu::mojom::CreateSharedImagePoolParams::DataView input,
    ::gpu::mojom::CreateSharedImagePoolParamsPtr* output) {
  bool success = true;
  ::gpu::mojom::CreateSharedImagePoolParamsPtr result(::gpu::mojom::CreateSharedImagePoolParams::New());
  
      if (success && !input.ReadPoolId(&result->pool_id))
        success = false;
      if (success) {
        result->client_remote =
            input.TakeClientRemote<decltype(result->client_remote)>();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::DestroySharedImagePoolParams::DataView, ::gpu::mojom::DestroySharedImagePoolParamsPtr>::Read(
    ::gpu::mojom::DestroySharedImagePoolParams::DataView input,
    ::gpu::mojom::DestroySharedImagePoolParamsPtr* output) {
  bool success = true;
  ::gpu::mojom::DestroySharedImagePoolParamsPtr result(::gpu::mojom::DestroySharedImagePoolParams::New());
  
      if (success && !input.ReadPoolId(&result->pool_id))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::gpu::mojom::DeferredRequestParams::DataView, ::gpu::mojom::DeferredRequestParamsPtr>::Read(
    ::gpu::mojom::DeferredRequestParams::DataView input,
    ::gpu::mojom::DeferredRequestParamsPtr* output) {
  using UnionType = ::gpu::mojom::DeferredRequestParams;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kCommandBufferRequest: {
      ::gpu::mojom::DeferredCommandBufferRequestPtr result_command_buffer_request{};
      if (!input.ReadCommandBufferRequest(&result_command_buffer_request))
        return false;

      *output = UnionType::NewCommandBufferRequest(
          std::move(result_command_buffer_request));
      break;
    }
    case Tag::kSharedImageRequest: {
      ::gpu::mojom::DeferredSharedImageRequestPtr result_shared_image_request{};
      if (!input.ReadSharedImageRequest(&result_shared_image_request))
        return false;

      *output = UnionType::NewSharedImageRequest(
          std::move(result_shared_image_request));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::gpu::mojom::DeferredCommandBufferRequestParams::DataView, ::gpu::mojom::DeferredCommandBufferRequestParamsPtr>::Read(
    ::gpu::mojom::DeferredCommandBufferRequestParams::DataView input,
    ::gpu::mojom::DeferredCommandBufferRequestParamsPtr* output) {
  using UnionType = ::gpu::mojom::DeferredCommandBufferRequestParams;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kAsyncFlush: {
      ::gpu::mojom::AsyncFlushParamsPtr result_async_flush{};
      if (!input.ReadAsyncFlush(&result_async_flush))
        return false;

      *output = UnionType::NewAsyncFlush(
          std::move(result_async_flush));
      break;
    }
    case Tag::kDestroyTransferBuffer: {
      *output = UnionType::NewDestroyTransferBuffer(input.destroy_transfer_buffer());
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::gpu::mojom::DeferredSharedImageRequest::DataView, ::gpu::mojom::DeferredSharedImageRequestPtr>::Read(
    ::gpu::mojom::DeferredSharedImageRequest::DataView input,
    ::gpu::mojom::DeferredSharedImageRequestPtr* output) {
  using UnionType = ::gpu::mojom::DeferredSharedImageRequest;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kNop: {
      *output = UnionType::NewNop(input.nop());
      break;
    }
    case Tag::kCreateSharedImage: {
      ::gpu::mojom::CreateSharedImageParamsPtr result_create_shared_image{};
      if (!input.ReadCreateSharedImage(&result_create_shared_image))
        return false;

      *output = UnionType::NewCreateSharedImage(
          std::move(result_create_shared_image));
      break;
    }
    case Tag::kCreateSharedImageWithData: {
      ::gpu::mojom::CreateSharedImageWithDataParamsPtr result_create_shared_image_with_data{};
      if (!input.ReadCreateSharedImageWithData(&result_create_shared_image_with_data))
        return false;

      *output = UnionType::NewCreateSharedImageWithData(
          std::move(result_create_shared_image_with_data));
      break;
    }
    case Tag::kCreateSharedImageWithBuffer: {
      ::gpu::mojom::CreateSharedImageWithBufferParamsPtr result_create_shared_image_with_buffer{};
      if (!input.ReadCreateSharedImageWithBuffer(&result_create_shared_image_with_buffer))
        return false;

      *output = UnionType::NewCreateSharedImageWithBuffer(
          std::move(result_create_shared_image_with_buffer));
      break;
    }
    case Tag::kRegisterUploadBuffer: {
      ::base::ReadOnlySharedMemoryRegion result_register_upload_buffer{};
      if (!input.ReadRegisterUploadBuffer(&result_register_upload_buffer))
        return false;

      *output = UnionType::NewRegisterUploadBuffer(
          std::move(result_register_upload_buffer));
      break;
    }
    case Tag::kUpdateSharedImage: {
      ::gpu::mojom::UpdateSharedImageParamsPtr result_update_shared_image{};
      if (!input.ReadUpdateSharedImage(&result_update_shared_image))
        return false;

      *output = UnionType::NewUpdateSharedImage(
          std::move(result_update_shared_image));
      break;
    }
    case Tag::kCopyToGpuMemoryBuffer: {
      ::gpu::mojom::CopyToGpuMemoryBufferParamsPtr result_copy_to_gpu_memory_buffer{};
      if (!input.ReadCopyToGpuMemoryBuffer(&result_copy_to_gpu_memory_buffer))
        return false;

      *output = UnionType::NewCopyToGpuMemoryBuffer(
          std::move(result_copy_to_gpu_memory_buffer));
      break;
    }
    case Tag::kDestroySharedImage: {
      ::gpu::Mailbox result_destroy_shared_image{};
      if (!input.ReadDestroySharedImage(&result_destroy_shared_image))
        return false;

      *output = UnionType::NewDestroySharedImage(
          std::move(result_destroy_shared_image));
      break;
    }
    case Tag::kAddReferenceToSharedImage: {
      ::gpu::mojom::AddReferenceToSharedImageParamsPtr result_add_reference_to_shared_image{};
      if (!input.ReadAddReferenceToSharedImage(&result_add_reference_to_shared_image))
        return false;

      *output = UnionType::NewAddReferenceToSharedImage(
          std::move(result_add_reference_to_shared_image));
      break;
    }
    case Tag::kCreateSharedImagePool: {
      ::gpu::mojom::CreateSharedImagePoolParamsPtr result_create_shared_image_pool{};
      if (!input.ReadCreateSharedImagePool(&result_create_shared_image_pool))
        return false;

      *output = UnionType::NewCreateSharedImagePool(
          std::move(result_create_shared_image_pool));
      break;
    }
    case Tag::kDestroySharedImagePool: {
      ::gpu::mojom::DestroySharedImagePoolParamsPtr result_destroy_shared_image_pool{};
      if (!input.ReadDestroySharedImagePool(&result_destroy_shared_image_pool))
        return false;

      *output = UnionType::NewDestroySharedImagePool(
          std::move(result_destroy_shared_image_pool));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace gpu::mojom {


void GpuChannelInterceptorForTesting::CrashForTesting() {
  GetForwardingInterface()->CrashForTesting();
}
void GpuChannelInterceptorForTesting::TerminateForTesting() {
  GetForwardingInterface()->TerminateForTesting();
}
void GpuChannelInterceptorForTesting::GetChannelToken(GetChannelTokenCallback callback) {
  GetForwardingInterface()->GetChannelToken(std::move(callback));
}
void GpuChannelInterceptorForTesting::Flush(FlushCallback callback) {
  GetForwardingInterface()->Flush(std::move(callback));
}
void GpuChannelInterceptorForTesting::GetSharedMemoryForFlushId(GetSharedMemoryForFlushIdCallback callback) {
  GetForwardingInterface()->GetSharedMemoryForFlushId(std::move(callback));
}
void GpuChannelInterceptorForTesting::CreateCommandBuffer(CreateCommandBufferParamsPtr params, int32_t routing_id, ::base::UnsafeSharedMemoryRegion shared_state, ::mojo::PendingAssociatedReceiver<CommandBuffer> receiver, ::mojo::PendingAssociatedRemote<CommandBufferClient> client, CreateCommandBufferCallback callback) {
  GetForwardingInterface()->CreateCommandBuffer(
    std::move(params)
    , 
    std::move(routing_id)
    , 
    std::move(shared_state)
    , 
    std::move(receiver)
    , 
    std::move(client)
    , std::move(callback));
}
void GpuChannelInterceptorForTesting::DestroyCommandBuffer(int32_t routing_id, DestroyCommandBufferCallback callback) {
  GetForwardingInterface()->DestroyCommandBuffer(
    std::move(routing_id)
    , std::move(callback));
}
void GpuChannelInterceptorForTesting::ScheduleImageDecode(ScheduleImageDecodeParamsPtr params, uint64_t decode_release_count) {
  GetForwardingInterface()->ScheduleImageDecode(
    std::move(params)
    , 
    std::move(decode_release_count)
    );
}
void GpuChannelInterceptorForTesting::FlushDeferredRequests(std::vector<DeferredRequestPtr> requests, uint32_t flushed_deferred_message_id) {
  GetForwardingInterface()->FlushDeferredRequests(
    std::move(requests)
    , 
    std::move(flushed_deferred_message_id)
    );
}
void GpuChannelInterceptorForTesting::CreateGpuMemoryBuffer(const ::gfx::Size& size, const ::viz::SharedImageFormat& format, ::gfx::BufferUsage buffer_usage, CreateGpuMemoryBufferCallback callback) {
  GetForwardingInterface()->CreateGpuMemoryBuffer(
    std::move(size)
    , 
    std::move(format)
    , 
    std::move(buffer_usage)
    , std::move(callback));
}
void GpuChannelInterceptorForTesting::WaitForTokenInRange(int32_t routing_id, int32_t start, int32_t end, WaitForTokenInRangeCallback callback) {
  GetForwardingInterface()->WaitForTokenInRange(
    std::move(routing_id)
    , 
    std::move(start)
    , 
    std::move(end)
    , std::move(callback));
}
void GpuChannelInterceptorForTesting::WaitForGetOffsetInRange(int32_t routing_id, uint32_t set_get_buffer_count, int32_t start, int32_t end, WaitForGetOffsetInRangeCallback callback) {
  GetForwardingInterface()->WaitForGetOffsetInRange(
    std::move(routing_id)
    , 
    std::move(set_get_buffer_count)
    , 
    std::move(start)
    , 
    std::move(end)
    , std::move(callback));
}
GpuChannelAsyncWaiter::GpuChannelAsyncWaiter(
    GpuChannel* proxy) : proxy_(proxy) {}

GpuChannelAsyncWaiter::~GpuChannelAsyncWaiter() = default;


void GpuChannelAsyncWaiter::GetChannelToken(
    ::base::UnguessableToken* out_token) {
  base::RunLoop loop;
  proxy_->GetChannelToken(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::UnguessableToken* out_token
,
             const ::base::UnguessableToken& token) {*out_token = std::move(token);
            loop->Quit();
          },
          &loop,
          out_token));
  loop.Run();
}

::base::UnguessableToken GpuChannelAsyncWaiter::GetChannelToken(
    ) {
  ::base::UnguessableToken async_wait_result;
  GetChannelToken(&async_wait_result);
  return async_wait_result;
}

void GpuChannelAsyncWaiter::Flush(
    ) {
  base::RunLoop loop;
  proxy_->Flush(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void GpuChannelAsyncWaiter::GetSharedMemoryForFlushId(
    ::base::ReadOnlySharedMemoryRegion* out_version_buffer) {
  base::RunLoop loop;
  proxy_->GetSharedMemoryForFlushId(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::ReadOnlySharedMemoryRegion* out_version_buffer
,
             ::base::ReadOnlySharedMemoryRegion version_buffer) {*out_version_buffer = std::move(version_buffer);
            loop->Quit();
          },
          &loop,
          out_version_buffer));
  loop.Run();
}

::base::ReadOnlySharedMemoryRegion GpuChannelAsyncWaiter::GetSharedMemoryForFlushId(
    ) {
  ::base::ReadOnlySharedMemoryRegion async_wait_result;
  GetSharedMemoryForFlushId(&async_wait_result);
  return async_wait_result;
}

void GpuChannelAsyncWaiter::CreateCommandBuffer(
    CreateCommandBufferParamsPtr params, int32_t routing_id, ::base::UnsafeSharedMemoryRegion shared_state, ::mojo::PendingAssociatedReceiver<CommandBuffer> receiver, ::mojo::PendingAssociatedRemote<CommandBufferClient> client, ::gpu::ContextResult* out_result, ::gpu::Capabilities* out_capabilties, ::gpu::GLCapabilities* out_gl_capabilities) {
  base::RunLoop loop;
  proxy_->CreateCommandBuffer(
      std::move(params),
      std::move(routing_id),
      std::move(shared_state),
      std::move(receiver),
      std::move(client),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::gpu::ContextResult* out_result
,
             ::gpu::Capabilities* out_capabilties
,
             ::gpu::GLCapabilities* out_gl_capabilities
,
             ::gpu::ContextResult result,
             const ::gpu::Capabilities& capabilties,
             const ::gpu::GLCapabilities& gl_capabilities) {*out_result = std::move(result);*out_capabilties = std::move(capabilties);*out_gl_capabilities = std::move(gl_capabilities);
            loop->Quit();
          },
          &loop,
          out_result,
          out_capabilties,
          out_gl_capabilities));
  loop.Run();
}



void GpuChannelAsyncWaiter::DestroyCommandBuffer(
    int32_t routing_id) {
  base::RunLoop loop;
  proxy_->DestroyCommandBuffer(
      std::move(routing_id),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void GpuChannelAsyncWaiter::CreateGpuMemoryBuffer(
    const ::gfx::Size& size, const ::viz::SharedImageFormat& format, ::gfx::BufferUsage buffer_usage, ::gfx::GpuMemoryBufferHandle* out_buffer_handle) {
  base::RunLoop loop;
  proxy_->CreateGpuMemoryBuffer(
      std::move(size),
      std::move(format),
      std::move(buffer_usage),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::gfx::GpuMemoryBufferHandle* out_buffer_handle
,
             ::gfx::GpuMemoryBufferHandle buffer_handle) {*out_buffer_handle = std::move(buffer_handle);
            loop->Quit();
          },
          &loop,
          out_buffer_handle));
  loop.Run();
}

::gfx::GpuMemoryBufferHandle GpuChannelAsyncWaiter::CreateGpuMemoryBuffer(
    const ::gfx::Size& size, const ::viz::SharedImageFormat& format, ::gfx::BufferUsage buffer_usage) {
  ::gfx::GpuMemoryBufferHandle async_wait_result;
  CreateGpuMemoryBuffer(std::move(size),std::move(format),std::move(buffer_usage),&async_wait_result);
  return async_wait_result;
}

void GpuChannelAsyncWaiter::WaitForTokenInRange(
    int32_t routing_id, int32_t start, int32_t end, ::gpu::CommandBuffer::State* out_state) {
  base::RunLoop loop;
  proxy_->WaitForTokenInRange(
      std::move(routing_id),
      std::move(start),
      std::move(end),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::gpu::CommandBuffer::State* out_state
,
             const ::gpu::CommandBuffer::State& state) {*out_state = std::move(state);
            loop->Quit();
          },
          &loop,
          out_state));
  loop.Run();
}

::gpu::CommandBuffer::State GpuChannelAsyncWaiter::WaitForTokenInRange(
    int32_t routing_id, int32_t start, int32_t end) {
  ::gpu::CommandBuffer::State async_wait_result;
  WaitForTokenInRange(std::move(routing_id),std::move(start),std::move(end),&async_wait_result);
  return async_wait_result;
}

void GpuChannelAsyncWaiter::WaitForGetOffsetInRange(
    int32_t routing_id, uint32_t set_get_buffer_count, int32_t start, int32_t end, ::gpu::CommandBuffer::State* out_state) {
  base::RunLoop loop;
  proxy_->WaitForGetOffsetInRange(
      std::move(routing_id),
      std::move(set_get_buffer_count),
      std::move(start),
      std::move(end),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::gpu::CommandBuffer::State* out_state
,
             const ::gpu::CommandBuffer::State& state) {*out_state = std::move(state);
            loop->Quit();
          },
          &loop,
          out_state));
  loop.Run();
}

::gpu::CommandBuffer::State GpuChannelAsyncWaiter::WaitForGetOffsetInRange(
    int32_t routing_id, uint32_t set_get_buffer_count, int32_t start, int32_t end) {
  ::gpu::CommandBuffer::State async_wait_result;
  WaitForGetOffsetInRange(std::move(routing_id),std::move(set_get_buffer_count),std::move(start),std::move(end),&async_wait_result);
  return async_wait_result;
}




void CommandBufferInterceptorForTesting::SetGetBuffer(int32_t shm_id) {
  GetForwardingInterface()->SetGetBuffer(
    std::move(shm_id)
    );
}
void CommandBufferInterceptorForTesting::RegisterTransferBuffer(int32_t id, ::base::UnsafeSharedMemoryRegion buffer) {
  GetForwardingInterface()->RegisterTransferBuffer(
    std::move(id)
    , 
    std::move(buffer)
    );
}
void CommandBufferInterceptorForTesting::CreateGpuFenceFromHandle(uint32_t gpu_fence_id, ::gfx::GpuFenceHandle fence_handle) {
  GetForwardingInterface()->CreateGpuFenceFromHandle(
    std::move(gpu_fence_id)
    , 
    std::move(fence_handle)
    );
}
void CommandBufferInterceptorForTesting::GetGpuFenceHandle(uint32_t id, GetGpuFenceHandleCallback callback) {
  GetForwardingInterface()->GetGpuFenceHandle(
    std::move(id)
    , std::move(callback));
}
void CommandBufferInterceptorForTesting::SignalSyncToken(const ::gpu::SyncToken& sync_token, uint32_t signal_id) {
  GetForwardingInterface()->SignalSyncToken(
    std::move(sync_token)
    , 
    std::move(signal_id)
    );
}
void CommandBufferInterceptorForTesting::SignalQuery(uint32_t query, uint32_t signal_id) {
  GetForwardingInterface()->SignalQuery(
    std::move(query)
    , 
    std::move(signal_id)
    );
}
CommandBufferAsyncWaiter::CommandBufferAsyncWaiter(
    CommandBuffer* proxy) : proxy_(proxy) {}

CommandBufferAsyncWaiter::~CommandBufferAsyncWaiter() = default;


void CommandBufferAsyncWaiter::GetGpuFenceHandle(
    uint32_t id, ::gfx::GpuFenceHandle* out_fence_handle) {
  base::RunLoop loop;
  proxy_->GetGpuFenceHandle(
      std::move(id),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::gfx::GpuFenceHandle* out_fence_handle
,
             ::gfx::GpuFenceHandle fence_handle) {*out_fence_handle = std::move(fence_handle);
            loop->Quit();
          },
          &loop,
          out_fence_handle));
  loop.Run();
}

::gfx::GpuFenceHandle CommandBufferAsyncWaiter::GetGpuFenceHandle(
    uint32_t id) {
  ::gfx::GpuFenceHandle async_wait_result;
  GetGpuFenceHandle(std::move(id),&async_wait_result);
  return async_wait_result;
}




void CommandBufferClientInterceptorForTesting::OnConsoleMessage(const std::string& message) {
  GetForwardingInterface()->OnConsoleMessage(
    std::move(message)
    );
}
void CommandBufferClientInterceptorForTesting::OnGpuSwitched(::gl::GpuPreference active_gpu_heuristic) {
  GetForwardingInterface()->OnGpuSwitched(
    std::move(active_gpu_heuristic)
    );
}
void CommandBufferClientInterceptorForTesting::OnDestroyed(::gpu::error::ContextLostReason reason, ::gpu::error::Error error) {
  GetForwardingInterface()->OnDestroyed(
    std::move(reason)
    , 
    std::move(error)
    );
}
void CommandBufferClientInterceptorForTesting::OnReturnData(const std::vector<uint8_t>& data) {
  GetForwardingInterface()->OnReturnData(
    std::move(data)
    );
}
void CommandBufferClientInterceptorForTesting::OnSignalAck(uint32_t signal_id, const ::gpu::CommandBuffer::State& state) {
  GetForwardingInterface()->OnSignalAck(
    std::move(signal_id)
    , 
    std::move(state)
    );
}
CommandBufferClientAsyncWaiter::CommandBufferClientAsyncWaiter(
    CommandBufferClient* proxy) : proxy_(proxy) {}

CommandBufferClientAsyncWaiter::~CommandBufferClientAsyncWaiter() = default;







}  // gpu::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif