// gpu/ipc/common/gpu_preferences.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_GPU_PREFERENCES_MOJOM_DATA_VIEW_H_
#define GPU_IPC_COMMON_GPU_PREFERENCES_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "gpu/ipc/common/gpu_preferences.mojom-shared-internal.h"
#include "mojo/public/mojom/base/message_pump_type.mojom-shared.h"
#include "ui/gfx/mojom/buffer_types.mojom-shared.h"


namespace gpu::mojom {
class GpuPreferencesDataView;



}  // gpu::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gpu::mojom::GpuPreferencesDataView> {
  using Data = ::gpu::mojom::internal::GpuPreferences_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace gpu::mojom {


enum class VulkanImplementationName : int32_t {
  
  kNone = 0,
  
  kNative = 1,
  
  kForcedNative = 2,
  
  kSwiftshader = 3,
  
  kLast = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, VulkanImplementationName value);
inline bool IsKnownEnumValue(VulkanImplementationName value) {
  return internal::VulkanImplementationName_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class WebGPUAdapterName : int32_t {
  
  kDefault = 0,
  
  kD3D11 = 1,
  
  kOpenGLES = 2,
  
  kSwiftShader = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, WebGPUAdapterName value);
inline bool IsKnownEnumValue(WebGPUAdapterName value) {
  return internal::WebGPUAdapterName_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class WebGPUPowerPreference : int32_t {
  
  kNone = 0,
  
  kDefaultLowPower = 1,
  
  kDefaultHighPerformance = 2,
  
  kForceLowPower = 3,
  
  kForceHighPerformance = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, WebGPUPowerPreference value);
inline bool IsKnownEnumValue(WebGPUPowerPreference value) {
  return internal::WebGPUPowerPreference_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class GrContextType : int32_t {
  
  kNone = 0,
  
  kGL = 1,
  
  kVulkan = 2,
  
  kGraphiteDawn = 3,
  
  kGraphiteMetal = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, GrContextType value);
inline bool IsKnownEnumValue(GrContextType value) {
  return internal::GrContextType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class DawnBackendValidationLevel : int32_t {
  
  kDisabled = 0,
  
  kPartial = 1,
  
  kFull = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, DawnBackendValidationLevel value);
inline bool IsKnownEnumValue(DawnBackendValidationLevel value) {
  return internal::DawnBackendValidationLevel_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class GpuPreferencesDataView {
 public:
  GpuPreferencesDataView() = default;

  GpuPreferencesDataView(
      internal::GpuPreferences_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool disable_accelerated_video_decode() const {
    return data_->disable_accelerated_video_decode;
  }
  bool disable_accelerated_video_encode() const {
    return data_->disable_accelerated_video_encode;
  }
  bool gpu_startup_dialog() const {
    return data_->gpu_startup_dialog;
  }
  bool disable_gpu_watchdog() const {
    return data_->disable_gpu_watchdog;
  }
  bool gpu_sandbox_start_early() const {
    return data_->gpu_sandbox_start_early;
  }
  bool enable_low_latency_dxva() const {
    return data_->enable_low_latency_dxva;
  }
  bool enable_zero_copy_dxgi_video() const {
    return data_->enable_zero_copy_dxgi_video;
  }
  bool enable_nv12_dxgi_video() const {
    return data_->enable_nv12_dxgi_video;
  }
  bool disable_software_rasterizer() const {
    return data_->disable_software_rasterizer;
  }
  bool log_gpu_control_list_decisions() const {
    return data_->log_gpu_control_list_decisions;
  }
  bool compile_shader_always_succeeds() const {
    return data_->compile_shader_always_succeeds;
  }
  bool disable_gl_error_limit() const {
    return data_->disable_gl_error_limit;
  }
  bool disable_glsl_translator() const {
    return data_->disable_glsl_translator;
  }
  bool disable_shader_name_hashing() const {
    return data_->disable_shader_name_hashing;
  }
  bool enable_gpu_command_logging() const {
    return data_->enable_gpu_command_logging;
  }
  bool enable_gpu_debugging() const {
    return data_->enable_gpu_debugging;
  }
  bool enable_gpu_service_logging_gpu() const {
    return data_->enable_gpu_service_logging_gpu;
  }
  bool enable_gpu_driver_debug_logging() const {
    return data_->enable_gpu_driver_debug_logging;
  }
  bool disable_gpu_program_cache() const {
    return data_->disable_gpu_program_cache;
  }
  bool enforce_gl_minimums() const {
    return data_->enforce_gl_minimums;
  }
  uint32_t force_gpu_mem_discardable_limit_bytes() const {
    return data_->force_gpu_mem_discardable_limit_bytes;
  }
  uint32_t force_max_texture_size() const {
    return data_->force_max_texture_size;
  }
  uint32_t gpu_program_cache_size() const {
    return data_->gpu_program_cache_size;
  }
  bool disable_gpu_shader_disk_cache() const {
    return data_->disable_gpu_shader_disk_cache;
  }
  bool enable_threaded_texture_mailboxes() const {
    return data_->enable_threaded_texture_mailboxes;
  }
  bool gl_shader_interm_output() const {
    return data_->gl_shader_interm_output;
  }
  bool enable_android_surface_control() const {
    return data_->enable_android_surface_control;
  }
  bool perform_graphite_precompilation() const {
    return data_->perform_graphite_precompilation;
  }
  bool enable_gpu_service_logging() const {
    return data_->enable_gpu_service_logging;
  }
  bool enable_gpu_service_tracing() const {
    return data_->enable_gpu_service_tracing;
  }
  bool use_passthrough_cmd_decoder() const {
    return data_->use_passthrough_cmd_decoder;
  }
  bool ignore_gpu_blocklist() const {
    return data_->ignore_gpu_blocklist;
  }
  bool watchdog_starts_backgrounded() const {
    return data_->watchdog_starts_backgrounded;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadGrContextType(UserType* output) const {
    auto data_value = data_->gr_context_type;
    return mojo::internal::Deserialize<::gpu::mojom::GrContextType>(
        data_value, output);
  }
  GrContextType gr_context_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gpu::mojom::GrContextType>(data_->gr_context_type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadUseVulkan(UserType* output) const {
    auto data_value = data_->use_vulkan;
    return mojo::internal::Deserialize<::gpu::mojom::VulkanImplementationName>(
        data_value, output);
  }
  VulkanImplementationName use_vulkan() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gpu::mojom::VulkanImplementationName>(data_->use_vulkan));
  }
  bool enable_vulkan_protected_memory() const {
    return data_->enable_vulkan_protected_memory;
  }
  bool disable_vulkan_surface() const {
    return data_->disable_vulkan_surface;
  }
  bool disable_vulkan_fallback_to_gl_for_testing() const {
    return data_->disable_vulkan_fallback_to_gl_for_testing;
  }
  uint32_t vulkan_heap_memory_limit() const {
    return data_->vulkan_heap_memory_limit;
  }
  uint32_t vulkan_sync_cpu_memory_limit() const {
    return data_->vulkan_sync_cpu_memory_limit;
  }
  bool enable_gpu_benchmarking_extension() const {
    return data_->enable_gpu_benchmarking_extension;
  }
  bool enable_webgpu() const {
    return data_->enable_webgpu;
  }
  bool enable_unsafe_webgpu() const {
    return data_->enable_unsafe_webgpu;
  }
  bool enable_webgpu_developer_features() const {
    return data_->enable_webgpu_developer_features;
  }
  bool enable_webgpu_experimental_features() const {
    return data_->enable_webgpu_experimental_features;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadUseWebgpuAdapter(UserType* output) const {
    auto data_value = data_->use_webgpu_adapter;
    return mojo::internal::Deserialize<::gpu::mojom::WebGPUAdapterName>(
        data_value, output);
  }
  WebGPUAdapterName use_webgpu_adapter() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gpu::mojom::WebGPUAdapterName>(data_->use_webgpu_adapter));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadUseWebgpuPowerPreference(UserType* output) const {
    auto data_value = data_->use_webgpu_power_preference;
    return mojo::internal::Deserialize<::gpu::mojom::WebGPUPowerPreference>(
        data_value, output);
  }
  WebGPUPowerPreference use_webgpu_power_preference() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gpu::mojom::WebGPUPowerPreference>(data_->use_webgpu_power_preference));
  }
  bool force_webgpu_compat() const {
    return data_->force_webgpu_compat;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadEnableDawnBackendValidation(UserType* output) const {
    auto data_value = data_->enable_dawn_backend_validation;
    return mojo::internal::Deserialize<::gpu::mojom::DawnBackendValidationLevel>(
        data_value, output);
  }
  DawnBackendValidationLevel enable_dawn_backend_validation() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gpu::mojom::DawnBackendValidationLevel>(data_->enable_dawn_backend_validation));
  }
  inline void GetEnabledDawnFeaturesListDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEnabledDawnFeaturesList(UserType* output) {
    
    auto* pointer = data_->enabled_dawn_features_list.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetDisabledDawnFeaturesListDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisabledDawnFeaturesList(UserType* output) {
    
    auto* pointer = data_->disabled_dawn_features_list.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  bool enable_perf_data_collection() const {
    return data_->enable_perf_data_collection;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMessagePumpType(UserType* output) const {
    auto data_value = data_->message_pump_type;
    return mojo::internal::Deserialize<::mojo_base::mojom::MessagePumpType>(
        data_value, output);
  }
  ::mojo_base::mojom::MessagePumpType message_pump_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::MessagePumpType>(data_->message_pump_type));
  }
  bool enable_native_gpu_memory_buffers() const {
    return data_->enable_native_gpu_memory_buffers;
  }
  bool force_separate_egl_display_for_webgl_testing() const {
    return data_->force_separate_egl_display_for_webgl_testing;
  }
 private:
  internal::GpuPreferences_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // gpu::mojom

#endif  // GPU_IPC_COMMON_GPU_PREFERENCES_MOJOM_DATA_VIEW_H_