// gpu/ipc/common/vulkan_info.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_VULKAN_INFO_MOJOM_DATA_VIEW_H_
#define GPU_IPC_COMMON_VULKAN_INFO_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "gpu/ipc/common/vulkan_info.mojom-shared-internal.h"
#include "gpu/ipc/common/vulkan_types.mojom-shared.h"


namespace gpu::mojom {
class VulkanPhysicalDeviceInfoDataView;

class VulkanInfoDataView;



}  // gpu::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gpu::mojom::VulkanPhysicalDeviceInfoDataView> {
  using Data = ::gpu::mojom::internal::VulkanPhysicalDeviceInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::VulkanInfoDataView> {
  using Data = ::gpu::mojom::internal::VulkanInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace gpu::mojom {


class VulkanPhysicalDeviceInfoDataView {
 public:
  VulkanPhysicalDeviceInfoDataView() = default;

  VulkanPhysicalDeviceInfoDataView(
      internal::VulkanPhysicalDeviceInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPropertiesDataView(
      ::gpu::mojom::VkPhysicalDevicePropertiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProperties(UserType* output) {
    
    auto* pointer = data_->properties.Get();
    return mojo::internal::Deserialize<::gpu::mojom::VkPhysicalDevicePropertiesDataView>(
        pointer, output, message_);
  }
  inline void GetExtensionsDataView(
      mojo::ArrayDataView<::gpu::mojom::VkExtensionPropertiesDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtensions(UserType* output) {
    
    auto* pointer = data_->extensions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gpu::mojom::VkExtensionPropertiesDataView>>(
        pointer, output, message_);
  }
  inline void GetFeaturesDataView(
      ::gpu::mojom::VkPhysicalDeviceFeaturesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFeatures(UserType* output) {
    
    auto* pointer = data_->features.Get();
    return mojo::internal::Deserialize<::gpu::mojom::VkPhysicalDeviceFeaturesDataView>(
        pointer, output, message_);
  }
  bool feature_sampler_ycbcr_conversion() const {
    return data_->feature_sampler_ycbcr_conversion;
  }
  bool feature_protected_memory() const {
    return data_->feature_protected_memory;
  }
  inline void GetQueueFamiliesDataView(
      mojo::ArrayDataView<::gpu::mojom::VkQueueFamilyPropertiesDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadQueueFamilies(UserType* output) {
    
    auto* pointer = data_->queue_families.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gpu::mojom::VkQueueFamilyPropertiesDataView>>(
        pointer, output, message_);
  }
 private:
  internal::VulkanPhysicalDeviceInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VulkanInfoDataView {
 public:
  VulkanInfoDataView() = default;

  VulkanInfoDataView(
      internal::VulkanInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t api_version() const {
    return data_->api_version;
  }
  uint32_t used_api_version() const {
    return data_->used_api_version;
  }
  inline void GetInstanceExtensionsDataView(
      mojo::ArrayDataView<::gpu::mojom::VkExtensionPropertiesDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInstanceExtensions(UserType* output) {
    
    auto* pointer = data_->instance_extensions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gpu::mojom::VkExtensionPropertiesDataView>>(
        pointer, output, message_);
  }
  inline void GetEnabledInstanceExtensionsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEnabledInstanceExtensions(UserType* output) {
    
    auto* pointer = data_->enabled_instance_extensions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetInstanceLayersDataView(
      mojo::ArrayDataView<::gpu::mojom::VkLayerPropertiesDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInstanceLayers(UserType* output) {
    
    auto* pointer = data_->instance_layers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gpu::mojom::VkLayerPropertiesDataView>>(
        pointer, output, message_);
  }
  inline void GetPhysicalDevicesDataView(
      mojo::ArrayDataView<VulkanPhysicalDeviceInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPhysicalDevices(UserType* output) {
    
    auto* pointer = data_->physical_devices.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gpu::mojom::VulkanPhysicalDeviceInfoDataView>>(
        pointer, output, message_);
  }
 private:
  internal::VulkanInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // gpu::mojom

#endif  // GPU_IPC_COMMON_VULKAN_INFO_MOJOM_DATA_VIEW_H_