// media/mojo/mojom/audio_output_stream.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_AUDIO_OUTPUT_STREAM_MOJOM_H_
#define MEDIA_MOJO_MOJOM_AUDIO_OUTPUT_STREAM_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/audio_output_stream.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/audio_output_stream.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/audio_output_stream.mojom-forward.h"  // IWYU pragma: export
#include "media/mojo/mojom/audio_data_pipe.mojom-forward.h"
#include "media/mojo/mojom/audio_parameters.mojom.h"
#include "media/mojo/mojom/media_types.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace media::mojom {

class AudioOutputStreamProxy;

template <typename ImplRefTraits>
class AudioOutputStreamStub;

class AudioOutputStreamRequestValidator;


class AudioOutputStream
    : public AudioOutputStreamInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.AudioOutputStream";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AudioOutputStreamInterfaceBase;
  using Proxy_ = AudioOutputStreamProxy;

  template <typename ImplRefTraits>
  using Stub_ = AudioOutputStreamStub<ImplRefTraits>;

  using RequestValidator_ = AudioOutputStreamRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kPlayMinVersion = 0,
    kPauseMinVersion = 0,
    kFlushMinVersion = 0,
    kSetVolumeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Play_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Pause_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Flush_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetVolume_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AudioOutputStream() = default;

  virtual void Play() = 0;

  virtual void Pause() = 0;

  virtual void Flush() = 0;

  virtual void SetVolume(double volume) = 0;
};

class AudioOutputStreamObserverProxy;

template <typename ImplRefTraits>
class AudioOutputStreamObserverStub;

class AudioOutputStreamObserverRequestValidator;


class AudioOutputStreamObserver
    : public AudioOutputStreamObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.AudioOutputStreamObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AudioOutputStreamObserverInterfaceBase;
  using Proxy_ = AudioOutputStreamObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = AudioOutputStreamObserverStub<ImplRefTraits>;

  using RequestValidator_ = AudioOutputStreamObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kDidStartPlayingMinVersion = 0,
    kDidStopPlayingMinVersion = 0,
    kDidChangeAudibleStateMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct DidStartPlaying_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidStopPlaying_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidChangeAudibleState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  
  using DisconnectReason = AudioOutputStreamObserver_DisconnectReason;
  virtual ~AudioOutputStreamObserver() = default;

  virtual void DidStartPlaying() = 0;

  virtual void DidStopPlaying() = 0;

  virtual void DidChangeAudibleState(bool is_audible) = 0;
};

class AudioOutputStreamProviderProxy;

template <typename ImplRefTraits>
class AudioOutputStreamProviderStub;

class AudioOutputStreamProviderRequestValidator;


class AudioOutputStreamProvider
    : public AudioOutputStreamProviderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.AudioOutputStreamProvider";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AudioOutputStreamProviderInterfaceBase;
  using Proxy_ = AudioOutputStreamProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = AudioOutputStreamProviderStub<ImplRefTraits>;

  using RequestValidator_ = AudioOutputStreamProviderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAcquireMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Acquire_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AudioOutputStreamProvider() = default;

  virtual void Acquire(const ::media::AudioParameters& params, ::mojo::PendingRemote<AudioOutputStreamProviderClient> client) = 0;
};

class AudioOutputStreamProviderClientProxy;

template <typename ImplRefTraits>
class AudioOutputStreamProviderClientStub;

class AudioOutputStreamProviderClientRequestValidator;


class AudioOutputStreamProviderClient
    : public AudioOutputStreamProviderClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.AudioOutputStreamProviderClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AudioOutputStreamProviderClientInterfaceBase;
  using Proxy_ = AudioOutputStreamProviderClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = AudioOutputStreamProviderClientStub<ImplRefTraits>;

  using RequestValidator_ = AudioOutputStreamProviderClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreatedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Created_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AudioOutputStreamProviderClient() = default;

  virtual void Created(::mojo::PendingRemote<AudioOutputStream> stream, ::media::mojom::ReadWriteAudioDataPipePtr data_pipe) = 0;
};

class DeviceSwitchInterfaceProxy;

template <typename ImplRefTraits>
class DeviceSwitchInterfaceStub;

class DeviceSwitchInterfaceRequestValidator;


class DeviceSwitchInterface
    : public DeviceSwitchInterfaceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.DeviceSwitchInterface";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DeviceSwitchInterfaceInterfaceBase;
  using Proxy_ = DeviceSwitchInterfaceProxy;

  template <typename ImplRefTraits>
  using Stub_ = DeviceSwitchInterfaceStub<ImplRefTraits>;

  using RequestValidator_ = DeviceSwitchInterfaceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSwitchAudioOutputDeviceIdMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SwitchAudioOutputDeviceId_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DeviceSwitchInterface() = default;

  virtual void SwitchAudioOutputDeviceId(const std::string& output_device_id) = 0;
};



class  AudioOutputStreamProxy
    : public AudioOutputStream {
 public:
  using InterfaceType = AudioOutputStream;

  explicit AudioOutputStreamProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Play() final;
  
  void Pause() final;
  
  void Flush() final;
  
  void SetVolume(double volume) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  AudioOutputStreamObserverProxy
    : public AudioOutputStreamObserver {
 public:
  using InterfaceType = AudioOutputStreamObserver;

  explicit AudioOutputStreamObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DidStartPlaying() final;
  
  void DidStopPlaying() final;
  
  void DidChangeAudibleState(bool is_audible) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  AudioOutputStreamProviderProxy
    : public AudioOutputStreamProvider {
 public:
  using InterfaceType = AudioOutputStreamProvider;

  explicit AudioOutputStreamProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Acquire(const ::media::AudioParameters& params, ::mojo::PendingRemote<AudioOutputStreamProviderClient> client) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  AudioOutputStreamProviderClientProxy
    : public AudioOutputStreamProviderClient {
 public:
  using InterfaceType = AudioOutputStreamProviderClient;

  explicit AudioOutputStreamProviderClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Created(::mojo::PendingRemote<AudioOutputStream> stream, ::media::mojom::ReadWriteAudioDataPipePtr data_pipe) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  DeviceSwitchInterfaceProxy
    : public DeviceSwitchInterface {
 public:
  using InterfaceType = DeviceSwitchInterface;

  explicit DeviceSwitchInterfaceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SwitchAudioOutputDeviceId(const std::string& output_device_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  AudioOutputStreamStubDispatch {
 public:
  static bool Accept(AudioOutputStream* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AudioOutputStream* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AudioOutputStream>>
class AudioOutputStreamStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AudioOutputStreamStub() = default;
  ~AudioOutputStreamStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioOutputStreamStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioOutputStreamStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  AudioOutputStreamObserverStubDispatch {
 public:
  static bool Accept(AudioOutputStreamObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AudioOutputStreamObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AudioOutputStreamObserver>>
class AudioOutputStreamObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AudioOutputStreamObserverStub() = default;
  ~AudioOutputStreamObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioOutputStreamObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioOutputStreamObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  AudioOutputStreamProviderStubDispatch {
 public:
  static bool Accept(AudioOutputStreamProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AudioOutputStreamProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AudioOutputStreamProvider>>
class AudioOutputStreamProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AudioOutputStreamProviderStub() = default;
  ~AudioOutputStreamProviderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioOutputStreamProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioOutputStreamProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  AudioOutputStreamProviderClientStubDispatch {
 public:
  static bool Accept(AudioOutputStreamProviderClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AudioOutputStreamProviderClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AudioOutputStreamProviderClient>>
class AudioOutputStreamProviderClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AudioOutputStreamProviderClientStub() = default;
  ~AudioOutputStreamProviderClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioOutputStreamProviderClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioOutputStreamProviderClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DeviceSwitchInterfaceStubDispatch {
 public:
  static bool Accept(DeviceSwitchInterface* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DeviceSwitchInterface* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DeviceSwitchInterface>>
class DeviceSwitchInterfaceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DeviceSwitchInterfaceStub() = default;
  ~DeviceSwitchInterfaceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DeviceSwitchInterfaceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DeviceSwitchInterfaceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  AudioOutputStreamRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  AudioOutputStreamObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  AudioOutputStreamProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  AudioOutputStreamProviderClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  DeviceSwitchInterfaceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // media::mojom

namespace mojo {

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_AUDIO_OUTPUT_STREAM_MOJOM_H_