// media/mojo/mojom/cdm_context_for_oopvd.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_CDM_CONTEXT_FOR_OOPVD_MOJOM_BLINK_H_
#define MEDIA_MOJO_MOJOM_CDM_CONTEXT_FOR_OOPVD_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/cdm_context_for_oopvd.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/cdm_context_for_oopvd.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/cdm_context_for_oopvd.mojom-blink-forward.h"  // IWYU pragma: export
#include "media/mojo/mojom/media_types.mojom-blink-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace media::mojom::blink {

class CdmContextEventCallbackProxy;

template <typename ImplRefTraits>
class CdmContextEventCallbackStub;

class CdmContextEventCallbackRequestValidator;


class BLINK_PLATFORM_EXPORT CdmContextEventCallback
    : public CdmContextEventCallbackInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.CdmContextEventCallback";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CdmContextEventCallbackInterfaceBase;
  using Proxy_ = CdmContextEventCallbackProxy;

  template <typename ImplRefTraits>
  using Stub_ = CdmContextEventCallbackStub<ImplRefTraits>;

  using RequestValidator_ = CdmContextEventCallbackRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kEventCallbackMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct EventCallback_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CdmContextEventCallback() = default;

  virtual void EventCallback(CdmContextEvent event) = 0;
};

class CdmContextForOOPVDProxy;

template <typename ImplRefTraits>
class CdmContextForOOPVDStub;

class CdmContextForOOPVDRequestValidator;
class CdmContextForOOPVDResponseValidator;


class BLINK_PLATFORM_EXPORT CdmContextForOOPVD
    : public CdmContextForOOPVDInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.CdmContextForOOPVD";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CdmContextForOOPVDInterfaceBase;
  using Proxy_ = CdmContextForOOPVDProxy;

  template <typename ImplRefTraits>
  using Stub_ = CdmContextForOOPVDStub<ImplRefTraits>;

  using RequestValidator_ = CdmContextForOOPVDRequestValidator;
  using ResponseValidator_ = CdmContextForOOPVDResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetHwKeyDataMinVersion = 0,
    kRegisterEventCallbackMinVersion = 0,
    kGetHwConfigDataMinVersion = 0,
    kGetScreenResolutionsMinVersion = 0,
    kAllocateSecureBufferMinVersion = 0,
    kParseEncryptedSliceHeaderMinVersion = 0,
    kDecryptVideoBufferMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetHwKeyData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RegisterEventCallback_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetHwConfigData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetScreenResolutions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AllocateSecureBuffer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ParseEncryptedSliceHeader_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DecryptVideoBuffer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CdmContextForOOPVD() = default;

  using GetHwKeyDataCallback = base::OnceCallback<void(DecryptStatus, const ::blink::Vector<uint8_t>&)>;
  using GetHwKeyDataMojoCallback = base::OnceCallback<void(DecryptStatus, const ::blink::Vector<uint8_t>&)>;

  virtual void GetHwKeyData(::media::mojom::blink::DecryptConfigPtr decrypt_config, const ::blink::Vector<uint8_t>& hw_identifier, GetHwKeyDataCallback callback) = 0;

  virtual void RegisterEventCallback(::mojo::PendingRemote<CdmContextEventCallback> callback) = 0;

  using GetHwConfigDataCallback = base::OnceCallback<void(bool, const ::blink::Vector<uint8_t>&)>;
  using GetHwConfigDataMojoCallback = base::OnceCallback<void(bool, const ::blink::Vector<uint8_t>&)>;

  virtual void GetHwConfigData(GetHwConfigDataCallback callback) = 0;

  using GetScreenResolutionsCallback = base::OnceCallback<void(const ::blink::Vector<::gfx::Size>&)>;
  using GetScreenResolutionsMojoCallback = base::OnceCallback<void(const ::blink::Vector<::gfx::Size>&)>;

  virtual void GetScreenResolutions(GetScreenResolutionsCallback callback) = 0;

  using AllocateSecureBufferCallback = base::OnceCallback<void(::mojo::PlatformHandle)>;
  using AllocateSecureBufferMojoCallback = base::OnceCallback<void(::mojo::PlatformHandle)>;

  virtual void AllocateSecureBuffer(uint32_t size, AllocateSecureBufferCallback callback) = 0;

  using ParseEncryptedSliceHeaderCallback = base::OnceCallback<void(bool, const ::blink::Vector<uint8_t>&)>;
  using ParseEncryptedSliceHeaderMojoCallback = base::OnceCallback<void(bool, const ::blink::Vector<uint8_t>&)>;

  virtual void ParseEncryptedSliceHeader(uint64_t secure_handle, uint32_t offset, const ::blink::Vector<uint8_t>& stream_data, ParseEncryptedSliceHeaderCallback callback) = 0;

  using DecryptVideoBufferCallback = base::OnceCallback<void(DecryptStatus, ::media::mojom::blink::DecoderBufferPtr, const ::blink::Vector<uint8_t>&)>;
  using DecryptVideoBufferMojoCallback = base::OnceCallback<void(DecryptStatus, ::media::mojom::blink::DecoderBufferPtr, const ::blink::Vector<uint8_t>&)>;

  virtual void DecryptVideoBuffer(::media::mojom::blink::DecoderBufferPtr buffer, const ::blink::Vector<uint8_t>& bytes, DecryptVideoBufferCallback callback) = 0;
};



class BLINK_PLATFORM_EXPORT CdmContextEventCallbackProxy
    : public CdmContextEventCallback {
 public:
  using InterfaceType = CdmContextEventCallback;

  explicit CdmContextEventCallbackProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void EventCallback(CdmContextEvent event) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT CdmContextForOOPVDProxy
    : public CdmContextForOOPVD {
 public:
  using InterfaceType = CdmContextForOOPVD;

  explicit CdmContextForOOPVDProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetHwKeyData(::media::mojom::blink::DecryptConfigPtr decrypt_config, const ::blink::Vector<uint8_t>& hw_identifier, GetHwKeyDataCallback callback) final;
  
  void RegisterEventCallback(::mojo::PendingRemote<CdmContextEventCallback> callback) final;
  
  void GetHwConfigData(GetHwConfigDataCallback callback) final;
  
  void GetScreenResolutions(GetScreenResolutionsCallback callback) final;
  
  void AllocateSecureBuffer(uint32_t size, AllocateSecureBufferCallback callback) final;
  
  void ParseEncryptedSliceHeader(uint64_t secure_handle, uint32_t offset, const ::blink::Vector<uint8_t>& stream_data, ParseEncryptedSliceHeaderCallback callback) final;
  
  void DecryptVideoBuffer(::media::mojom::blink::DecoderBufferPtr buffer, const ::blink::Vector<uint8_t>& bytes, DecryptVideoBufferCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT CdmContextEventCallbackStubDispatch {
 public:
  static bool Accept(CdmContextEventCallback* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CdmContextEventCallback* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CdmContextEventCallback>>
class CdmContextEventCallbackStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CdmContextEventCallbackStub() = default;
  ~CdmContextEventCallbackStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CdmContextEventCallbackStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CdmContextEventCallbackStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT CdmContextForOOPVDStubDispatch {
 public:
  static bool Accept(CdmContextForOOPVD* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CdmContextForOOPVD* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CdmContextForOOPVD>>
class CdmContextForOOPVDStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CdmContextForOOPVDStub() = default;
  ~CdmContextForOOPVDStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CdmContextForOOPVDStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CdmContextForOOPVDStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT CdmContextEventCallbackRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT CdmContextForOOPVDRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT CdmContextForOOPVDResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // media::mojom::blink

namespace mojo {

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_CDM_CONTEXT_FOR_OOPVD_MOJOM_BLINK_H_