// media/mojo/mojom/cdm_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_CDM_SERVICE_MOJOM_H_
#define MEDIA_MOJO_MOJOM_CDM_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/cdm_service.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/cdm_service.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/cdm_service.mojom-forward.h"  // IWYU pragma: export
#include "media/mojo/mojom/content_decryption_module.mojom-forward.h"
#include "media/mojo/mojom/frame_interface_factory.mojom-forward.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "sandbox/policy/mojom/sandbox.mojom-forward.h"
#include "services/service_manager/public/mojom/interface_provider.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace media::mojom {

class CdmServiceProxy;

template <typename ImplRefTraits>
class CdmServiceStub;

class CdmServiceRequestValidator;


class CdmService
    : public CdmServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.CdmService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CdmServiceInterfaceBase;
  using Proxy_ = CdmServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = CdmServiceStub<ImplRefTraits>;

  using RequestValidator_ = CdmServiceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateCdmFactoryMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateCdmFactory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CdmService() = default;

  virtual void CreateCdmFactory(::mojo::PendingReceiver<::media::mojom::CdmFactory> factory, ::mojo::PendingRemote<::media::mojom::FrameInterfaceFactory> frame_interfaces) = 0;
};

class CdmServiceBrokerProxy;

template <typename ImplRefTraits>
class CdmServiceBrokerStub;

class CdmServiceBrokerRequestValidator;


class CdmServiceBroker
    : public CdmServiceBrokerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.CdmServiceBroker";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kCdm;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CdmServiceBrokerInterfaceBase;
  using Proxy_ = CdmServiceBrokerProxy;

  template <typename ImplRefTraits>
  using Stub_ = CdmServiceBrokerStub<ImplRefTraits>;

  using RequestValidator_ = CdmServiceBrokerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kGetServiceMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetService_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CdmServiceBroker() = default;

  virtual void GetService(const ::base::FilePath& cdm_path, ::mojo::PendingReceiver<CdmService> receiver) = 0;
};



class  CdmServiceProxy
    : public CdmService {
 public:
  using InterfaceType = CdmService;

  explicit CdmServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateCdmFactory(::mojo::PendingReceiver<::media::mojom::CdmFactory> factory, ::mojo::PendingRemote<::media::mojom::FrameInterfaceFactory> frame_interfaces) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  CdmServiceBrokerProxy
    : public CdmServiceBroker {
 public:
  using InterfaceType = CdmServiceBroker;

  explicit CdmServiceBrokerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetService(const ::base::FilePath& cdm_path, ::mojo::PendingReceiver<CdmService> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  CdmServiceStubDispatch {
 public:
  static bool Accept(CdmService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CdmService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CdmService>>
class CdmServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CdmServiceStub() = default;
  ~CdmServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CdmServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CdmServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CdmServiceBrokerStubDispatch {
 public:
  static bool Accept(CdmServiceBroker* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CdmServiceBroker* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CdmServiceBroker>>
class CdmServiceBrokerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CdmServiceBrokerStub() = default;
  ~CdmServiceBrokerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CdmServiceBrokerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CdmServiceBrokerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CdmServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CdmServiceBrokerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // media::mojom

namespace mojo {

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_CDM_SERVICE_MOJOM_H_