// media/mojo/mojom/renderer_extensions.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/renderer_extensions.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/renderer_extensions.mojom-params-data.h"
#include "media/mojo/mojom/renderer_extensions.mojom-shared-message-ids.h"

#include "media/mojo/mojom/renderer_extensions.mojom-import-headers.h"
#include "media/mojo/mojom/renderer_extensions.mojom-test-utils.h"


namespace media::mojom {
// The declaration includes the definition on other builds.

FlingingRendererClientExtension::IPCStableHashFunction FlingingRendererClientExtension::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FlingingRendererClientExtension>(message.name())) {
    case messages::FlingingRendererClientExtension::kOnRemotePlayStateChange: {
      return &FlingingRendererClientExtension::OnRemotePlayStateChange_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FlingingRendererClientExtension::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FlingingRendererClientExtension>(message.name())) {
      case messages::FlingingRendererClientExtension::kOnRemotePlayStateChange:
            return "Receive media::mojom::FlingingRendererClientExtension::OnRemotePlayStateChange";
    }
  } else {
    switch (static_cast<messages::FlingingRendererClientExtension>(message.name())) {
      case messages::FlingingRendererClientExtension::kOnRemotePlayStateChange:
            return "Receive reply media::mojom::FlingingRendererClientExtension::OnRemotePlayStateChange";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FlingingRendererClientExtension::OnRemotePlayStateChange_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd29bc593;  // IPCStableHash for media::mojom::FlingingRendererClientExtension::OnRemotePlayStateChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

FlingingRendererClientExtensionProxy::FlingingRendererClientExtensionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FlingingRendererClientExtensionProxy::OnRemotePlayStateChange(
    ::media::MediaStatus::State in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::FlingingRendererClientExtension::OnRemotePlayStateChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type ::media::MediaStatus::State>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FlingingRendererClientExtension::kOnRemotePlayStateChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::FlingingRendererClientExtension_OnRemotePlayStateChange_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::MediaStatusState>(
    in_state,
    &params->state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FlingingRendererClientExtension::Name_);
  message.set_method_name("OnRemotePlayStateChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool FlingingRendererClientExtensionStubDispatch::Accept(
    FlingingRendererClientExtension* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FlingingRendererClientExtension>(message->header()->name)) {
    case messages::FlingingRendererClientExtension::kOnRemotePlayStateChange: {
      DCHECK(message->is_serialized());
      internal::FlingingRendererClientExtension_OnRemotePlayStateChange_Params_Data* params =
          reinterpret_cast<internal::FlingingRendererClientExtension_OnRemotePlayStateChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FlingingRendererClientExtension.0
      bool success = true;
      ::media::MediaStatus::State p_state{};
      FlingingRendererClientExtension_OnRemotePlayStateChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FlingingRendererClientExtension::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnRemotePlayStateChange(        
        std::move(p_state));
      return true;
    }
  }
  return false;
}

// static
bool FlingingRendererClientExtensionStubDispatch::AcceptWithResponder(
    FlingingRendererClientExtension* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FlingingRendererClientExtension>(message->header()->name)) {
    case messages::FlingingRendererClientExtension::kOnRemotePlayStateChange: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFlingingRendererClientExtensionValidationInfo[] = {
    {base::to_underlying(messages::FlingingRendererClientExtension::kOnRemotePlayStateChange),
     { &internal::FlingingRendererClientExtension_OnRemotePlayStateChange_Params_Data::Validate,
      nullptr /* no response */}},
};

bool FlingingRendererClientExtensionRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::media::mojom::FlingingRendererClientExtension::Name_,
    kFlingingRendererClientExtensionValidationInfo);
}

// The declaration includes the definition on other builds.

MediaFoundationRendererObserver::IPCStableHashFunction MediaFoundationRendererObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MediaFoundationRendererObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
# endif // !BUILDFLAG(IS_FUCHSIA)

MediaFoundationRendererObserverProxy::MediaFoundationRendererObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

// static
bool MediaFoundationRendererObserverStubDispatch::Accept(
    MediaFoundationRendererObserver* impl,
    mojo::Message* message) {
  return false;
}

// static
bool MediaFoundationRendererObserverStubDispatch::AcceptWithResponder(
    MediaFoundationRendererObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  return false;
}
namespace {
}  // namespace

bool MediaFoundationRendererObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::media::mojom::MediaFoundationRendererObserver::Name_,
    {});
}

// The declaration includes the definition on other builds.

MediaFoundationRendererNotifier::IPCStableHashFunction MediaFoundationRendererNotifier::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MediaFoundationRendererNotifier>(message.name())) {
    case messages::MediaFoundationRendererNotifier::kMediaFoundationRendererCreated: {
      return &MediaFoundationRendererNotifier::MediaFoundationRendererCreated_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MediaFoundationRendererNotifier::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MediaFoundationRendererNotifier>(message.name())) {
      case messages::MediaFoundationRendererNotifier::kMediaFoundationRendererCreated:
            return "Receive media::mojom::MediaFoundationRendererNotifier::MediaFoundationRendererCreated";
    }
  } else {
    switch (static_cast<messages::MediaFoundationRendererNotifier>(message.name())) {
      case messages::MediaFoundationRendererNotifier::kMediaFoundationRendererCreated:
            return "Receive reply media::mojom::MediaFoundationRendererNotifier::MediaFoundationRendererCreated";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MediaFoundationRendererNotifier::MediaFoundationRendererCreated_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9fb568c5;  // IPCStableHash for media::mojom::MediaFoundationRendererNotifier::MediaFoundationRendererCreated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MediaFoundationRendererNotifierProxy::MediaFoundationRendererNotifierProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaFoundationRendererNotifierProxy::MediaFoundationRendererCreated(
    ::mojo::PendingReceiver<MediaFoundationRendererObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaFoundationRendererNotifier::MediaFoundationRendererCreated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingReceiver<MediaFoundationRendererObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaFoundationRendererNotifier::kMediaFoundationRendererCreated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaFoundationRendererNotifier_MediaFoundationRendererCreated_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::MediaFoundationRendererObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in MediaFoundationRendererNotifier.MediaFoundationRendererCreated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaFoundationRendererNotifier::Name_);
  message.set_method_name("MediaFoundationRendererCreated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MediaFoundationRendererNotifierStubDispatch::Accept(
    MediaFoundationRendererNotifier* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MediaFoundationRendererNotifier>(message->header()->name)) {
    case messages::MediaFoundationRendererNotifier::kMediaFoundationRendererCreated: {
      DCHECK(message->is_serialized());
      internal::MediaFoundationRendererNotifier_MediaFoundationRendererCreated_Params_Data* params =
          reinterpret_cast<internal::MediaFoundationRendererNotifier_MediaFoundationRendererCreated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaFoundationRendererNotifier.0
      bool success = true;
      ::mojo::PendingReceiver<MediaFoundationRendererObserver> p_observer{};
      MediaFoundationRendererNotifier_MediaFoundationRendererCreated_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaFoundationRendererNotifier::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MediaFoundationRendererCreated(        
        std::move(p_observer));
      return true;
    }
  }
  return false;
}

// static
bool MediaFoundationRendererNotifierStubDispatch::AcceptWithResponder(
    MediaFoundationRendererNotifier* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MediaFoundationRendererNotifier>(message->header()->name)) {
    case messages::MediaFoundationRendererNotifier::kMediaFoundationRendererCreated: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kMediaFoundationRendererNotifierValidationInfo[] = {
    {base::to_underlying(messages::MediaFoundationRendererNotifier::kMediaFoundationRendererCreated),
     { &internal::MediaFoundationRendererNotifier_MediaFoundationRendererCreated_Params_Data::Validate,
      nullptr /* no response */}},
};

bool MediaFoundationRendererNotifierRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::media::mojom::MediaFoundationRendererNotifier::Name_,
    kMediaFoundationRendererNotifierValidationInfo);
}



}  // media::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom {


void FlingingRendererClientExtensionInterceptorForTesting::OnRemotePlayStateChange(::media::MediaStatus::State state) {
  GetForwardingInterface()->OnRemotePlayStateChange(
    std::move(state)
    );
}
FlingingRendererClientExtensionAsyncWaiter::FlingingRendererClientExtensionAsyncWaiter(
    FlingingRendererClientExtension* proxy) : proxy_(proxy) {}

FlingingRendererClientExtensionAsyncWaiter::~FlingingRendererClientExtensionAsyncWaiter() = default;





MediaFoundationRendererObserverAsyncWaiter::MediaFoundationRendererObserverAsyncWaiter(
    MediaFoundationRendererObserver* proxy) : proxy_(proxy) {}

MediaFoundationRendererObserverAsyncWaiter::~MediaFoundationRendererObserverAsyncWaiter() = default;





void MediaFoundationRendererNotifierInterceptorForTesting::MediaFoundationRendererCreated(::mojo::PendingReceiver<MediaFoundationRendererObserver> observer) {
  GetForwardingInterface()->MediaFoundationRendererCreated(
    std::move(observer)
    );
}
MediaFoundationRendererNotifierAsyncWaiter::MediaFoundationRendererNotifierAsyncWaiter(
    MediaFoundationRendererNotifier* proxy) : proxy_(proxy) {}

MediaFoundationRendererNotifierAsyncWaiter::~MediaFoundationRendererNotifierAsyncWaiter() = default;







}  // media::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif