// mojo/public/mojom/base/values.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_MOJOM_BASE_VALUES_MOJOM_DATA_VIEW_H_
#define MOJO_PUBLIC_MOJOM_BASE_VALUES_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "mojo/public/mojom/base/values.mojom-shared-internal.h"


namespace mojo_base::mojom {
class DictionaryValueDataView;

class ListValueDataView;

class ValueDataView;


}  // mojo_base::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::mojo_base::mojom::DictionaryValueDataView> {
  using Data = ::mojo_base::mojom::internal::DictionaryValue_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojo_base::mojom::ListValueDataView> {
  using Data = ::mojo_base::mojom::internal::ListValue_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojo_base::mojom::ValueDataView> {
  using Data = ::mojo_base::mojom::internal::Value_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace mojo_base::mojom {


class DictionaryValueDataView {
 public:
  DictionaryValueDataView() = default;

  DictionaryValueDataView(
      internal::DictionaryValue_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStorageDataView(
      mojo::MapDataView<mojo::StringDataView, ValueDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStorage(UserType* output) {
    
    auto* pointer = data_->storage.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::ValueDataView>>(
        pointer, output, message_);
  }
 private:
  internal::DictionaryValue_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ListValueDataView {
 public:
  ListValueDataView() = default;

  ListValueDataView(
      internal::ListValue_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStorageDataView(
      mojo::ArrayDataView<ValueDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStorage(UserType* output) {
    
    auto* pointer = data_->storage.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::ValueDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ListValue_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ValueDataView {
 public:
  using Tag = internal::Value_Data::Value_Tag;

  ValueDataView() = default;

  ValueDataView(
      internal::Value_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_null_value() const { return data_->tag == Tag::kNullValue; }
  uint8_t null_value() const {
    CHECK(is_null_value());
    return data_->data.f_null_value;
  }
  bool is_bool_value() const { return data_->tag == Tag::kBoolValue; }
  bool bool_value() const {
    CHECK(is_bool_value());
    return data_->data.f_bool_value;
  }
  bool is_int_value() const { return data_->tag == Tag::kIntValue; }
  int32_t int_value() const {
    CHECK(is_int_value());
    return data_->data.f_int_value;
  }
  bool is_double_value() const { return data_->tag == Tag::kDoubleValue; }
  double double_value() const {
    CHECK(is_double_value());
    return data_->data.f_double_value;
  }
  bool is_string_value() const { return data_->tag == Tag::kStringValue; }
  inline void GetStringValueDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadStringValue(UserType* output) const {
    
    CHECK(is_string_value());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_string_value.Get(), output, message_);
  }
  bool is_binary_value() const { return data_->tag == Tag::kBinaryValue; }
  inline void GetBinaryValueDataView(
      mojo::ArrayDataView<uint8_t>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadBinaryValue(UserType* output) const {
    
    CHECK(is_binary_value());
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        data_->data.f_binary_value.Get(), output, message_);
  }
  bool is_dictionary_value() const { return data_->tag == Tag::kDictionaryValue; }
  inline void GetDictionaryValueDataView(
      DictionaryValueDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadDictionaryValue(UserType* output) const {
    
    CHECK(is_dictionary_value());
    return mojo::internal::Deserialize<::mojo_base::mojom::DictionaryValueDataView>(
        data_->data.f_dictionary_value.Get(), output, message_);
  }
  bool is_list_value() const { return data_->tag == Tag::kListValue; }
  inline void GetListValueDataView(
      ListValueDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadListValue(UserType* output) const {
    
    CHECK(is_list_value());
    return mojo::internal::Deserialize<::mojo_base::mojom::ListValueDataView>(
        data_->data.f_list_value.Get(), output, message_);
  }

 private:
  internal::Value_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // mojo_base::mojom

#endif  // MOJO_PUBLIC_MOJOM_BASE_VALUES_MOJOM_DATA_VIEW_H_