// pdf/mojom/pdf.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef PDF_MOJOM_PDF_MOJOM_H_
#define PDF_MOJOM_PDF_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "pdf/mojom/pdf.mojom-features.h"  // IWYU pragma: export
#include "pdf/mojom/pdf.mojom-shared.h"  // IWYU pragma: export
#include "pdf/mojom/pdf.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include "services/network/public/mojom/referrer_policy.mojom-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace pdf::mojom {

class PdfListenerProxy;

template <typename ImplRefTraits>
class PdfListenerStub;

class PdfListenerRequestValidator;
class PdfListenerResponseValidator;


class PdfListener
    : public PdfListenerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "pdf.mojom.PdfListener";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PdfListenerInterfaceBase;
  using Proxy_ = PdfListenerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PdfListenerStub<ImplRefTraits>;

  using RequestValidator_ = PdfListenerRequestValidator;
  using ResponseValidator_ = PdfListenerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetCaretPositionMinVersion = 0,
    kMoveRangeSelectionExtentMinVersion = 0,
    kSetSelectionBoundsMinVersion = 0,
    kGetPdfBytesMinVersion = 0,
    kGetPageTextMinVersion = 0,
    kGetMostVisiblePageIndexMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetCaretPosition_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MoveRangeSelectionExtent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetSelectionBounds_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetPdfBytes_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetPageText_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetMostVisiblePageIndex_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  
  using GetPdfBytesStatus = PdfListener_GetPdfBytesStatus;
  virtual ~PdfListener() = default;

  virtual void SetCaretPosition(const ::gfx::PointF& position) = 0;

  virtual void MoveRangeSelectionExtent(const ::gfx::PointF& extent) = 0;

  virtual void SetSelectionBounds(const ::gfx::PointF& base, const ::gfx::PointF& extent) = 0;

  using GetPdfBytesCallback = base::OnceCallback<void(PdfListener::GetPdfBytesStatus, const std::vector<uint8_t>&, uint32_t)>;
  using GetPdfBytesMojoCallback = base::OnceCallback<void(PdfListener::GetPdfBytesStatus, const std::vector<uint8_t>&, uint32_t)>;

  virtual void GetPdfBytes(uint32_t size_limit, GetPdfBytesCallback callback) = 0;

  using GetPageTextCallback = base::OnceCallback<void(const ::std::u16string&)>;
  using GetPageTextMojoCallback = base::OnceCallback<void(const ::std::u16string&)>;

  virtual void GetPageText(int32_t page_index, GetPageTextCallback callback) = 0;

  using GetMostVisiblePageIndexCallback = base::OnceCallback<void(std::optional<uint32_t>)>;
  using GetMostVisiblePageIndexMojoCallback = base::OnceCallback<void(std::optional<uint32_t>)>;

  virtual void GetMostVisiblePageIndex(GetMostVisiblePageIndexCallback callback) = 0;
};

class PdfHostProxy;

template <typename ImplRefTraits>
class PdfHostStub;

class PdfHostRequestValidator;


class PdfHost
    : public PdfHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "pdf.mojom.PdfHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PdfHostInterfaceBase;
  using Proxy_ = PdfHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = PdfHostStub<ImplRefTraits>;

  using RequestValidator_ = PdfHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetListenerMinVersion = 0,
    kOnDocumentLoadCompleteMinVersion = 0,
    kUpdateContentRestrictionsMinVersion = 0,
    kSaveUrlAsMinVersion = 0,
    kSelectionChangedMinVersion = 0,
    kSetPluginCanSaveMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetListener_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnDocumentLoadComplete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateContentRestrictions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SaveUrlAs_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SelectionChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPluginCanSave_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PdfHost() = default;

  virtual void SetListener(::mojo::PendingRemote<PdfListener> client) = 0;

  virtual void OnDocumentLoadComplete() = 0;

  virtual void UpdateContentRestrictions(int32_t restrictions) = 0;

  virtual void SaveUrlAs(const ::GURL& url, ::network::mojom::ReferrerPolicy policy) = 0;

  virtual void SelectionChanged(const ::gfx::PointF& left, int32_t left_height, const ::gfx::PointF& right, int32_t right_height) = 0;

  virtual void SetPluginCanSave(bool can_save) = 0;
};



class  PdfListenerProxy
    : public PdfListener {
 public:
  using InterfaceType = PdfListener;

  explicit PdfListenerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetCaretPosition(const ::gfx::PointF& position) final;
  
  void MoveRangeSelectionExtent(const ::gfx::PointF& extent) final;
  
  void SetSelectionBounds(const ::gfx::PointF& base, const ::gfx::PointF& extent) final;
  
  void GetPdfBytes(uint32_t size_limit, GetPdfBytesCallback callback) final;
  
  void GetPageText(int32_t page_index, GetPageTextCallback callback) final;
  
  void GetMostVisiblePageIndex(GetMostVisiblePageIndexCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PdfHostProxy
    : public PdfHost {
 public:
  using InterfaceType = PdfHost;

  explicit PdfHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetListener(::mojo::PendingRemote<PdfListener> client) final;
  
  void OnDocumentLoadComplete() final;
  
  void UpdateContentRestrictions(int32_t restrictions) final;
  
  void SaveUrlAs(const ::GURL& url, ::network::mojom::ReferrerPolicy policy) final;
  
  void SelectionChanged(const ::gfx::PointF& left, int32_t left_height, const ::gfx::PointF& right, int32_t right_height) final;
  
  void SetPluginCanSave(bool can_save) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PdfListenerStubDispatch {
 public:
  static bool Accept(PdfListener* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PdfListener* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PdfListener>>
class PdfListenerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PdfListenerStub() = default;
  ~PdfListenerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PdfListenerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PdfListenerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PdfHostStubDispatch {
 public:
  static bool Accept(PdfHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PdfHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PdfHost>>
class PdfHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PdfHostStub() = default;
  ~PdfHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PdfHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PdfHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PdfListenerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PdfHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PdfListenerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // pdf::mojom

namespace mojo {

}  // namespace mojo

#endif  // PDF_MOJOM_PDF_MOJOM_H_