// services/audio/public/mojom/audio_device_description.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_AUDIO_PUBLIC_MOJOM_AUDIO_DEVICE_DESCRIPTION_MOJOM_SHARED_H_
#define SERVICES_AUDIO_PUBLIC_MOJOM_AUDIO_DEVICE_DESCRIPTION_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/audio/public/mojom/audio_device_description.mojom-shared-internal.h"




#include "services/audio/public/mojom/audio_device_description.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::audio::mojom::AudioDeviceDescriptionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::audio::mojom::AudioDeviceDescriptionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::audio::mojom::internal::AudioDeviceDescription_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::device_name(input)) in_device_name = Traits::device_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->device_name)::BaseType> device_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_device_name,
      device_name_fragment);

    fragment->device_name.Set(
        device_name_fragment.is_null() ? nullptr : device_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->device_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_name in AudioDeviceDescription struct");

    decltype(Traits::unique_id(input)) in_unique_id = Traits::unique_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->unique_id)::BaseType> unique_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_unique_id,
      unique_id_fragment);

    fragment->unique_id.Set(
        unique_id_fragment.is_null() ? nullptr : unique_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->unique_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null unique_id in AudioDeviceDescription struct");

    decltype(Traits::group_id(input)) in_group_id = Traits::group_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->group_id)::BaseType> group_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_group_id,
      group_id_fragment);

    fragment->group_id.Set(
        group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->group_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null group_id in AudioDeviceDescription struct");

    fragment->is_system_default = Traits::is_system_default(input);

    fragment->is_communications_device = Traits::is_communications_device(input);
  }

  static bool Deserialize(::audio::mojom::internal::AudioDeviceDescription_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::audio::mojom::AudioDeviceDescriptionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace audio::mojom {

inline void AudioDeviceDescriptionDataView::GetDeviceNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->device_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AudioDeviceDescriptionDataView::GetUniqueIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->unique_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AudioDeviceDescriptionDataView::GetGroupIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->group_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // audio::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_AUDIO_PUBLIC_MOJOM_AUDIO_DEVICE_DESCRIPTION_MOJOM_SHARED_H_