// services/data_decoder/public/mojom/structured_headers_parser.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/data_decoder/public/mojom/structured_headers_parser.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/data_decoder/public/mojom/structured_headers_parser.mojom-params-data.h"
#include "services/data_decoder/public/mojom/structured_headers_parser.mojom-shared-message-ids.h"

#include "services/data_decoder/public/mojom/structured_headers_parser.mojom-import-headers.h"
#include "services/data_decoder/public/mojom/structured_headers_parser.mojom-test-utils.h"


namespace data_decoder::mojom {
// The declaration includes the definition on other builds.

StructuredHeadersParser::IPCStableHashFunction StructuredHeadersParser::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::StructuredHeadersParser>(message.name())) {
    case messages::StructuredHeadersParser::kParseItem: {
      return &StructuredHeadersParser::ParseItem_Sym::IPCStableHash;
    }
    case messages::StructuredHeadersParser::kParseList: {
      return &StructuredHeadersParser::ParseList_Sym::IPCStableHash;
    }
    case messages::StructuredHeadersParser::kParseDictionary: {
      return &StructuredHeadersParser::ParseDictionary_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* StructuredHeadersParser::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::StructuredHeadersParser>(message.name())) {
      case messages::StructuredHeadersParser::kParseItem:
            return "Receive data_decoder::mojom::StructuredHeadersParser::ParseItem";
      case messages::StructuredHeadersParser::kParseList:
            return "Receive data_decoder::mojom::StructuredHeadersParser::ParseList";
      case messages::StructuredHeadersParser::kParseDictionary:
            return "Receive data_decoder::mojom::StructuredHeadersParser::ParseDictionary";
    }
  } else {
    switch (static_cast<messages::StructuredHeadersParser>(message.name())) {
      case messages::StructuredHeadersParser::kParseItem:
            return "Receive reply data_decoder::mojom::StructuredHeadersParser::ParseItem";
      case messages::StructuredHeadersParser::kParseList:
            return "Receive reply data_decoder::mojom::StructuredHeadersParser::ParseList";
      case messages::StructuredHeadersParser::kParseDictionary:
            return "Receive reply data_decoder::mojom::StructuredHeadersParser::ParseDictionary";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t StructuredHeadersParser::ParseItem_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x133472f8;  // IPCStableHash for data_decoder::mojom::StructuredHeadersParser::ParseItem
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t StructuredHeadersParser::ParseList_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcc083a00;  // IPCStableHash for data_decoder::mojom::StructuredHeadersParser::ParseList
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t StructuredHeadersParser::ParseDictionary_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x68101d48;  // IPCStableHash for data_decoder::mojom::StructuredHeadersParser::ParseDictionary
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class StructuredHeadersParser_ParseItem_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  StructuredHeadersParser_ParseItem_ForwardToCallback(
      StructuredHeadersParser::ParseItemCallback callback
      ) : callback_(std::move(callback)) {
  }

  StructuredHeadersParser_ParseItem_ForwardToCallback(const StructuredHeadersParser_ParseItem_ForwardToCallback&) = delete;
  StructuredHeadersParser_ParseItem_ForwardToCallback& operator=(const StructuredHeadersParser_ParseItem_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  StructuredHeadersParser::ParseItemCallback callback_;
};

class StructuredHeadersParser_ParseList_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  StructuredHeadersParser_ParseList_ForwardToCallback(
      StructuredHeadersParser::ParseListCallback callback
      ) : callback_(std::move(callback)) {
  }

  StructuredHeadersParser_ParseList_ForwardToCallback(const StructuredHeadersParser_ParseList_ForwardToCallback&) = delete;
  StructuredHeadersParser_ParseList_ForwardToCallback& operator=(const StructuredHeadersParser_ParseList_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  StructuredHeadersParser::ParseListCallback callback_;
};

class StructuredHeadersParser_ParseDictionary_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  StructuredHeadersParser_ParseDictionary_ForwardToCallback(
      StructuredHeadersParser::ParseDictionaryCallback callback
      ) : callback_(std::move(callback)) {
  }

  StructuredHeadersParser_ParseDictionary_ForwardToCallback(const StructuredHeadersParser_ParseDictionary_ForwardToCallback&) = delete;
  StructuredHeadersParser_ParseDictionary_ForwardToCallback& operator=(const StructuredHeadersParser_ParseDictionary_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  StructuredHeadersParser::ParseDictionaryCallback callback_;
};

StructuredHeadersParserProxy::StructuredHeadersParserProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void StructuredHeadersParserProxy::ParseItem(
    const std::string& in_header, ParseItemCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send data_decoder::mojom::StructuredHeadersParser::ParseItem", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("header"), in_header,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StructuredHeadersParser::kParseItem), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::StructuredHeadersParser_ParseItem_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->header)::BaseType> header_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_header,
    header_fragment);

  params->header.Set(
      header_fragment.is_null() ? nullptr : header_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->header.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null header in StructuredHeadersParser.ParseItem request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StructuredHeadersParser::Name_);
  message.set_method_name("ParseItem");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new StructuredHeadersParser_ParseItem_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void StructuredHeadersParserProxy::ParseList(
    const std::string& in_header, ParseListCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send data_decoder::mojom::StructuredHeadersParser::ParseList", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("header"), in_header,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StructuredHeadersParser::kParseList), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::StructuredHeadersParser_ParseList_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->header)::BaseType> header_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_header,
    header_fragment);

  params->header.Set(
      header_fragment.is_null() ? nullptr : header_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->header.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null header in StructuredHeadersParser.ParseList request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StructuredHeadersParser::Name_);
  message.set_method_name("ParseList");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new StructuredHeadersParser_ParseList_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void StructuredHeadersParserProxy::ParseDictionary(
    const std::string& in_header, ParseDictionaryCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send data_decoder::mojom::StructuredHeadersParser::ParseDictionary", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("header"), in_header,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StructuredHeadersParser::kParseDictionary), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::StructuredHeadersParser_ParseDictionary_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->header)::BaseType> header_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_header,
    header_fragment);

  params->header.Set(
      header_fragment.is_null() ? nullptr : header_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->header.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null header in StructuredHeadersParser.ParseDictionary request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StructuredHeadersParser::Name_);
  message.set_method_name("ParseDictionary");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new StructuredHeadersParser_ParseDictionary_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class StructuredHeadersParser_ParseItem_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static StructuredHeadersParser::ParseItemCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<StructuredHeadersParser_ParseItem_ProxyToResponder> proxy(
        new StructuredHeadersParser_ParseItem_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&StructuredHeadersParser_ParseItem_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~StructuredHeadersParser_ParseItem_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  StructuredHeadersParser_ParseItem_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "StructuredHeadersParser::ParseItemCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<::net::structured_headers::ParameterizedItem> in_result);
};

bool StructuredHeadersParser_ParseItem_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::StructuredHeadersParser_ParseItem_ResponseParams_Data* params =
      reinterpret_cast<
          internal::StructuredHeadersParser_ParseItem_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for StructuredHeadersParser.0
  bool success = true;
  std::optional<::net::structured_headers::ParameterizedItem> p_result{};
  StructuredHeadersParser_ParseItem_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        StructuredHeadersParser::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void StructuredHeadersParser_ParseItem_ProxyToResponder::Run(
    std::optional<::net::structured_headers::ParameterizedItem> in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply data_decoder::mojom::StructuredHeadersParser::ParseItem", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type std::optional<::net::structured_headers::ParameterizedItem>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StructuredHeadersParser::kParseItem), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::StructuredHeadersParser_ParseItem_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::StructuredHeadersParameterizedItemDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StructuredHeadersParser::Name_);
  message.set_method_name("ParseItem");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class StructuredHeadersParser_ParseList_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static StructuredHeadersParser::ParseListCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<StructuredHeadersParser_ParseList_ProxyToResponder> proxy(
        new StructuredHeadersParser_ParseList_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&StructuredHeadersParser_ParseList_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~StructuredHeadersParser_ParseList_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  StructuredHeadersParser_ParseList_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "StructuredHeadersParser::ParseListCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<std::vector<::net::structured_headers::ParameterizedMember>> in_result);
};

bool StructuredHeadersParser_ParseList_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::StructuredHeadersParser_ParseList_ResponseParams_Data* params =
      reinterpret_cast<
          internal::StructuredHeadersParser_ParseList_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for StructuredHeadersParser.1
  bool success = true;
  std::optional<std::vector<::net::structured_headers::ParameterizedMember>> p_result{};
  StructuredHeadersParser_ParseList_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        StructuredHeadersParser::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void StructuredHeadersParser_ParseList_ProxyToResponder::Run(
    std::optional<std::vector<::net::structured_headers::ParameterizedMember>> in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply data_decoder::mojom::StructuredHeadersParser::ParseList", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type std::optional<std::vector<::net::structured_headers::ParameterizedMember>>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StructuredHeadersParser::kParseList), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::StructuredHeadersParser_ParseList_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType>
      result_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& result_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::StructuredHeadersParameterizedMemberDataView>>(
    in_result,
    result_fragment,
    &result_validate_params);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StructuredHeadersParser::Name_);
  message.set_method_name("ParseList");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class StructuredHeadersParser_ParseDictionary_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static StructuredHeadersParser::ParseDictionaryCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<StructuredHeadersParser_ParseDictionary_ProxyToResponder> proxy(
        new StructuredHeadersParser_ParseDictionary_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&StructuredHeadersParser_ParseDictionary_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~StructuredHeadersParser_ParseDictionary_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  StructuredHeadersParser_ParseDictionary_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "StructuredHeadersParser::ParseDictionaryCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<::net::structured_headers::Dictionary> in_result);
};

bool StructuredHeadersParser_ParseDictionary_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::StructuredHeadersParser_ParseDictionary_ResponseParams_Data* params =
      reinterpret_cast<
          internal::StructuredHeadersParser_ParseDictionary_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for StructuredHeadersParser.2
  bool success = true;
  std::optional<::net::structured_headers::Dictionary> p_result{};
  StructuredHeadersParser_ParseDictionary_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        StructuredHeadersParser::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void StructuredHeadersParser_ParseDictionary_ProxyToResponder::Run(
    std::optional<::net::structured_headers::Dictionary> in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply data_decoder::mojom::StructuredHeadersParser::ParseDictionary", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type std::optional<::net::structured_headers::Dictionary>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StructuredHeadersParser::kParseDictionary), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::StructuredHeadersParser_ParseDictionary_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::StructuredHeadersDictionaryDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StructuredHeadersParser::Name_);
  message.set_method_name("ParseDictionary");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool StructuredHeadersParserStubDispatch::Accept(
    StructuredHeadersParser* impl,
    mojo::Message* message) {
  switch (static_cast<messages::StructuredHeadersParser>(message->header()->name)) {
    case messages::StructuredHeadersParser::kParseItem: {
      break;
    }
    case messages::StructuredHeadersParser::kParseList: {
      break;
    }
    case messages::StructuredHeadersParser::kParseDictionary: {
      break;
    }
  }
  return false;
}

// static
bool StructuredHeadersParserStubDispatch::AcceptWithResponder(
    StructuredHeadersParser* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::StructuredHeadersParser>(message->header()->name)) {
    case messages::StructuredHeadersParser::kParseItem: {
      internal::StructuredHeadersParser_ParseItem_Params_Data* params =
          reinterpret_cast<
              internal::StructuredHeadersParser_ParseItem_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for StructuredHeadersParser.0
      bool success = true;
      std::string p_header{};
      StructuredHeadersParser_ParseItem_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHeader(&p_header))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StructuredHeadersParser::Name_, 0, false);
        return false;
      }
      auto callback =
          StructuredHeadersParser_ParseItem_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ParseItem(        
        std::move(p_header), std::move(callback));
      return true;
    }
    case messages::StructuredHeadersParser::kParseList: {
      internal::StructuredHeadersParser_ParseList_Params_Data* params =
          reinterpret_cast<
              internal::StructuredHeadersParser_ParseList_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for StructuredHeadersParser.1
      bool success = true;
      std::string p_header{};
      StructuredHeadersParser_ParseList_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHeader(&p_header))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StructuredHeadersParser::Name_, 1, false);
        return false;
      }
      auto callback =
          StructuredHeadersParser_ParseList_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ParseList(        
        std::move(p_header), std::move(callback));
      return true;
    }
    case messages::StructuredHeadersParser::kParseDictionary: {
      internal::StructuredHeadersParser_ParseDictionary_Params_Data* params =
          reinterpret_cast<
              internal::StructuredHeadersParser_ParseDictionary_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for StructuredHeadersParser.2
      bool success = true;
      std::string p_header{};
      StructuredHeadersParser_ParseDictionary_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHeader(&p_header))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StructuredHeadersParser::Name_, 2, false);
        return false;
      }
      auto callback =
          StructuredHeadersParser_ParseDictionary_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ParseDictionary(        
        std::move(p_header), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kStructuredHeadersParserValidationInfo[] = {
    {base::to_underlying(messages::StructuredHeadersParser::kParseItem),
     { &internal::StructuredHeadersParser_ParseItem_Params_Data::Validate,
      &internal::StructuredHeadersParser_ParseItem_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::StructuredHeadersParser::kParseList),
     { &internal::StructuredHeadersParser_ParseList_Params_Data::Validate,
      &internal::StructuredHeadersParser_ParseList_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::StructuredHeadersParser::kParseDictionary),
     { &internal::StructuredHeadersParser_ParseDictionary_Params_Data::Validate,
      &internal::StructuredHeadersParser_ParseDictionary_ResponseParams_Data::Validate}},
};

bool StructuredHeadersParserRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::data_decoder::mojom::StructuredHeadersParser::Name_,
    kStructuredHeadersParserValidationInfo);
}

bool StructuredHeadersParserResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::data_decoder::mojom::StructuredHeadersParser::Name_,
    kStructuredHeadersParserValidationInfo);

}


}  // data_decoder::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace data_decoder::mojom {


void StructuredHeadersParserInterceptorForTesting::ParseItem(const std::string& header, ParseItemCallback callback) {
  GetForwardingInterface()->ParseItem(
    std::move(header)
    , std::move(callback));
}
void StructuredHeadersParserInterceptorForTesting::ParseList(const std::string& header, ParseListCallback callback) {
  GetForwardingInterface()->ParseList(
    std::move(header)
    , std::move(callback));
}
void StructuredHeadersParserInterceptorForTesting::ParseDictionary(const std::string& header, ParseDictionaryCallback callback) {
  GetForwardingInterface()->ParseDictionary(
    std::move(header)
    , std::move(callback));
}
StructuredHeadersParserAsyncWaiter::StructuredHeadersParserAsyncWaiter(
    StructuredHeadersParser* proxy) : proxy_(proxy) {}

StructuredHeadersParserAsyncWaiter::~StructuredHeadersParserAsyncWaiter() = default;


void StructuredHeadersParserAsyncWaiter::ParseItem(
    const std::string& header, std::optional<::net::structured_headers::ParameterizedItem>* out_result) {
  base::RunLoop loop;
  proxy_->ParseItem(
      std::move(header),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::net::structured_headers::ParameterizedItem>* out_result
,
             std::optional<::net::structured_headers::ParameterizedItem> result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

std::optional<::net::structured_headers::ParameterizedItem> StructuredHeadersParserAsyncWaiter::ParseItem(
    const std::string& header) {
  std::optional<::net::structured_headers::ParameterizedItem> async_wait_result;
  ParseItem(std::move(header),&async_wait_result);
  return async_wait_result;
}

void StructuredHeadersParserAsyncWaiter::ParseList(
    const std::string& header, std::optional<std::vector<::net::structured_headers::ParameterizedMember>>* out_result) {
  base::RunLoop loop;
  proxy_->ParseList(
      std::move(header),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<std::vector<::net::structured_headers::ParameterizedMember>>* out_result
,
             std::optional<std::vector<::net::structured_headers::ParameterizedMember>> result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

std::optional<std::vector<::net::structured_headers::ParameterizedMember>> StructuredHeadersParserAsyncWaiter::ParseList(
    const std::string& header) {
  std::optional<std::vector<::net::structured_headers::ParameterizedMember>> async_wait_result;
  ParseList(std::move(header),&async_wait_result);
  return async_wait_result;
}

void StructuredHeadersParserAsyncWaiter::ParseDictionary(
    const std::string& header, std::optional<::net::structured_headers::Dictionary>* out_result) {
  base::RunLoop loop;
  proxy_->ParseDictionary(
      std::move(header),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::net::structured_headers::Dictionary>* out_result
,
             std::optional<::net::structured_headers::Dictionary> result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

std::optional<::net::structured_headers::Dictionary> StructuredHeadersParserAsyncWaiter::ParseDictionary(
    const std::string& header) {
  std::optional<::net::structured_headers::Dictionary> async_wait_result;
  ParseDictionary(std::move(header),&async_wait_result);
  return async_wait_result;
}






}  // data_decoder::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif