// services/network/public/mojom/ad_auction.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/ad_auction.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/ad_auction.mojom-params-data.h"
namespace network {
namespace mojom {

NOINLINE static const char* AdAuctionEventRecord_TypeToStringHelper(AdAuctionEventRecord_Type value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AdAuctionEventRecord_Type::kUninitialized:
      return "kUninitialized";
    case AdAuctionEventRecord_Type::kView:
      return "kView";
    case AdAuctionEventRecord_Type::kClick:
      return "kClick";
    default:
      return nullptr;
  }
}

std::string AdAuctionEventRecord_TypeToString(AdAuctionEventRecord_Type value) {
  const char *str = AdAuctionEventRecord_TypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AdAuctionEventRecord_Type value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AdAuctionEventRecord_Type value) {
  return os << AdAuctionEventRecord_TypeToString(value);
}

namespace internal {


// static
bool AdAuctionEventRecord_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AdAuctionEventRecord_Data* object =
      static_cast<const AdAuctionEventRecord_Data*>(data);


  if (!::network::mojom::internal::AdAuctionEventRecord_Type_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->providing_origin, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->providing_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->eligible_origins, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& eligible_origins_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->eligible_origins, validation_context,
                                         &eligible_origins_validate_params)) {
    return false;
  }

  return true;
}

AdAuctionEventRecord_Data::AdAuctionEventRecord_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::AdAuctionEventRecord_Type>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::AdAuctionEventRecord_Type value) {
  return std::move(context).WriteString(::network::mojom::AdAuctionEventRecord_TypeToString(value));
}

} // namespace perfetto