// services/network/public/mojom/cookie_manager.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_MANAGER_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_MANAGER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/cookie_manager.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/cookie_manager.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/cookie_manager.mojom-blink-forward.h"  // IWYU pragma: export
#include "components/content_settings/core/common/content_settings.mojom-blink-forward.h"
#include "components/content_settings/core/common/content_settings_types.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "sandbox/policy/mojom/context.mojom-blink-forward.h"
#include "services/network/public/mojom/cookie_partition_key.mojom-blink.h"
#include "services/network/public/mojom/first_party_sets.mojom-blink-forward.h"
#include "services/network/public/mojom/schemeful_site.mojom-blink-forward.h"
#include "services/network/public/mojom/site_for_cookies.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "services/network/public/cpp/cookie_manager_mojom_traits.h"
#include "services/network/public/cpp/cookie_manager_shared_mojom_traits.h"
#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {

class CookieChangeListenerProxy;

template <typename ImplRefTraits>
class CookieChangeListenerStub;

class CookieChangeListenerRequestValidator;


class BLINK_PLATFORM_EXPORT CookieChangeListener
    : public CookieChangeListenerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.CookieChangeListener";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CookieChangeListenerInterfaceBase;
  using Proxy_ = CookieChangeListenerProxy;

  template <typename ImplRefTraits>
  using Stub_ = CookieChangeListenerStub<ImplRefTraits>;

  using RequestValidator_ = CookieChangeListenerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnCookieChangeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnCookieChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CookieChangeListener() = default;

  virtual void OnCookieChange(CookieChangeInfoPtr change) = 0;
};

class CookieRemoteAccessFilterProxy;

template <typename ImplRefTraits>
class CookieRemoteAccessFilterStub;

class CookieRemoteAccessFilterRequestValidator;
class CookieRemoteAccessFilterResponseValidator;


class BLINK_PLATFORM_EXPORT CookieRemoteAccessFilter
    : public CookieRemoteAccessFilterInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.CookieRemoteAccessFilter";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CookieRemoteAccessFilterInterfaceBase;
  using Proxy_ = CookieRemoteAccessFilterProxy;

  template <typename ImplRefTraits>
  using Stub_ = CookieRemoteAccessFilterStub<ImplRefTraits>;

  using RequestValidator_ = CookieRemoteAccessFilterRequestValidator;
  using ResponseValidator_ = CookieRemoteAccessFilterResponseValidator;
  enum MethodMinVersions : uint32_t {
    kAllowedAccessMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AllowedAccess_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CookieRemoteAccessFilter() = default;

  using AllowedAccessCallback = base::OnceCallback<void(bool)>;
  using AllowedAccessMojoCallback = base::OnceCallback<void(bool)>;

  virtual void AllowedAccess(const ::blink::KURL& url, const ::net::SiteForCookies& site_for_cookies, AllowedAccessCallback callback) = 0;
};

class CookieManagerProxy;

template <typename ImplRefTraits>
class CookieManagerStub;

class CookieManagerRequestValidator;
class CookieManagerResponseValidator;


class BLINK_PLATFORM_EXPORT CookieManager
    : public CookieManagerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.CookieManager";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CookieManagerInterfaceBase;
  using Proxy_ = CookieManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = CookieManagerStub<ImplRefTraits>;

  using RequestValidator_ = CookieManagerRequestValidator;
  using ResponseValidator_ = CookieManagerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetAllCookiesMinVersion = 0,
    kGetAllCookiesWithAccessSemanticsMinVersion = 0,
    kGetCookieListMinVersion = 0,
    kSetCanonicalCookieMinVersion = 0,
    kDeleteCanonicalCookieMinVersion = 0,
    kDeleteCookiesMinVersion = 0,
    kDeleteSessionOnlyCookiesMinVersion = 0,
    kDeleteStaleSessionOnlyCookiesMinVersion = 0,
    kAddCookieChangeListenerMinVersion = 0,
    kAddGlobalChangeListenerMinVersion = 0,
    kCloneInterfaceMinVersion = 0,
    kFlushCookieStoreMinVersion = 0,
    kAllowFileSchemeCookiesMinVersion = 0,
    kSetContentSettingsMinVersion = 0,
    kSetRemoteFilterMinVersion = 0,
    kSetForceKeepSessionStateMinVersion = 0,
    kBlockThirdPartyCookiesMinVersion = 0,
    kSetMitigationsEnabledFor3pcdMinVersion = 0,
    kSetTrackingProtectionEnabledFor3pcdMinVersion = 0,
    kSetPreCommitCallbackDelayForTestingMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetAllCookies_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetAllCookiesWithAccessSemantics_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetCookieList_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetCanonicalCookie_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteCanonicalCookie_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteCookies_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteSessionOnlyCookies_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteStaleSessionOnlyCookies_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddCookieChangeListener_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddGlobalChangeListener_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CloneInterface_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FlushCookieStore_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AllowFileSchemeCookies_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetContentSettings_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetRemoteFilter_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetForceKeepSessionState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BlockThirdPartyCookies_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetMitigationsEnabledFor3pcd_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetTrackingProtectionEnabledFor3pcd_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPreCommitCallbackDelayForTesting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CookieManager() = default;

  using GetAllCookiesCallback = base::OnceCallback<void(const ::blink::Vector<::net::CanonicalCookie>&)>;
  using GetAllCookiesMojoCallback = base::OnceCallback<void(const ::blink::Vector<::net::CanonicalCookie>&)>;

  virtual void GetAllCookies(GetAllCookiesCallback callback) = 0;

  using GetAllCookiesWithAccessSemanticsCallback = base::OnceCallback<void(const ::blink::Vector<::net::CanonicalCookie>&, const ::blink::Vector<CookieAccessSemantics>&)>;
  using GetAllCookiesWithAccessSemanticsMojoCallback = base::OnceCallback<void(const ::blink::Vector<::net::CanonicalCookie>&, const ::blink::Vector<CookieAccessSemantics>&)>;

  virtual void GetAllCookiesWithAccessSemantics(GetAllCookiesWithAccessSemanticsCallback callback) = 0;

  using GetCookieListCallback = base::OnceCallback<void(::blink::Vector<CookieWithAccessResultPtr>, ::blink::Vector<CookieWithAccessResultPtr>)>;
  using GetCookieListMojoCallback = base::OnceCallback<void(::blink::Vector<CookieWithAccessResultPtr>, ::blink::Vector<CookieWithAccessResultPtr>)>;

  virtual void GetCookieList(const ::blink::KURL& url, CookieOptionsPtr cookie_options, ::network::mojom::blink::CookiePartitionKeyCollectionPtr cookie_partition_key_collection, GetCookieListCallback callback) = 0;

  using SetCanonicalCookieCallback = base::OnceCallback<void(CookieAccessResultPtr)>;
  using SetCanonicalCookieMojoCallback = base::OnceCallback<void(CookieAccessResultPtr)>;

  virtual void SetCanonicalCookie(const ::net::CanonicalCookie& cookie, const ::blink::KURL& source_url, CookieOptionsPtr cookie_options, SetCanonicalCookieCallback callback) = 0;

  using DeleteCanonicalCookieCallback = base::OnceCallback<void(bool)>;
  using DeleteCanonicalCookieMojoCallback = base::OnceCallback<void(bool)>;

  virtual void DeleteCanonicalCookie(const ::net::CanonicalCookie& cookie, DeleteCanonicalCookieCallback callback) = 0;

  using DeleteCookiesCallback = base::OnceCallback<void(uint32_t)>;
  using DeleteCookiesMojoCallback = base::OnceCallback<void(uint32_t)>;

  virtual void DeleteCookies(CookieDeletionFilterPtr filter, DeleteCookiesCallback callback) = 0;

  using DeleteSessionOnlyCookiesCallback = base::OnceCallback<void(uint32_t)>;
  using DeleteSessionOnlyCookiesMojoCallback = base::OnceCallback<void(uint32_t)>;

  virtual void DeleteSessionOnlyCookies(DeleteSessionOnlyCookiesCallback callback) = 0;

  using DeleteStaleSessionOnlyCookiesCallback = base::OnceCallback<void(uint32_t)>;
  using DeleteStaleSessionOnlyCookiesMojoCallback = base::OnceCallback<void(uint32_t)>;

  virtual void DeleteStaleSessionOnlyCookies(DeleteStaleSessionOnlyCookiesCallback callback) = 0;

  virtual void AddCookieChangeListener(const ::blink::KURL& url, const ::blink::String& name, ::mojo::PendingRemote<CookieChangeListener> listener) = 0;

  virtual void AddGlobalChangeListener(::mojo::PendingRemote<CookieChangeListener> notification_pointer) = 0;

  virtual void CloneInterface(::mojo::PendingReceiver<CookieManager> new_interface) = 0;

  using FlushCookieStoreCallback = base::OnceCallback<void()>;
  using FlushCookieStoreMojoCallback = base::OnceCallback<void()>;

  virtual void FlushCookieStore(FlushCookieStoreCallback callback) = 0;

  using AllowFileSchemeCookiesCallback = base::OnceCallback<void(bool)>;
  using AllowFileSchemeCookiesMojoCallback = base::OnceCallback<void(bool)>;

  virtual void AllowFileSchemeCookies(bool allow, AllowFileSchemeCookiesCallback callback) = 0;

  using SetContentSettingsCallback = base::OnceCallback<void()>;
  using SetContentSettingsMojoCallback = base::OnceCallback<void()>;

  virtual void SetContentSettings(::content_settings::mojom::blink::ContentSettingsType content_settings_type, ::blink::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr> settings, SetContentSettingsCallback callback) = 0;

  virtual void SetRemoteFilter(::mojo::PendingRemote<CookieRemoteAccessFilter> remote_access_filter) = 0;

  virtual void SetForceKeepSessionState() = 0;

  virtual void BlockThirdPartyCookies(bool block) = 0;

  virtual void SetMitigationsEnabledFor3pcd(bool enable) = 0;

  virtual void SetTrackingProtectionEnabledFor3pcd(bool enable) = 0;

  virtual void SetPreCommitCallbackDelayForTesting(::base::TimeDelta delay) = 0;
};



class BLINK_PLATFORM_EXPORT CookieChangeListenerProxy
    : public CookieChangeListener {
 public:
  using InterfaceType = CookieChangeListener;

  explicit CookieChangeListenerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnCookieChange(CookieChangeInfoPtr change) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT CookieRemoteAccessFilterProxy
    : public CookieRemoteAccessFilter {
 public:
  using InterfaceType = CookieRemoteAccessFilter;

  explicit CookieRemoteAccessFilterProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AllowedAccess(const ::blink::KURL& url, const ::net::SiteForCookies& site_for_cookies, AllowedAccessCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT CookieManagerProxy
    : public CookieManager {
 public:
  using InterfaceType = CookieManager;

  explicit CookieManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetAllCookies(GetAllCookiesCallback callback) final;
  
  void GetAllCookiesWithAccessSemantics(GetAllCookiesWithAccessSemanticsCallback callback) final;
  
  void GetCookieList(const ::blink::KURL& url, CookieOptionsPtr cookie_options, ::network::mojom::blink::CookiePartitionKeyCollectionPtr cookie_partition_key_collection, GetCookieListCallback callback) final;
  
  void SetCanonicalCookie(const ::net::CanonicalCookie& cookie, const ::blink::KURL& source_url, CookieOptionsPtr cookie_options, SetCanonicalCookieCallback callback) final;
  
  void DeleteCanonicalCookie(const ::net::CanonicalCookie& cookie, DeleteCanonicalCookieCallback callback) final;
  
  void DeleteCookies(CookieDeletionFilterPtr filter, DeleteCookiesCallback callback) final;
  
  void DeleteSessionOnlyCookies(DeleteSessionOnlyCookiesCallback callback) final;
  
  void DeleteStaleSessionOnlyCookies(DeleteStaleSessionOnlyCookiesCallback callback) final;
  
  void AddCookieChangeListener(const ::blink::KURL& url, const ::blink::String& name, ::mojo::PendingRemote<CookieChangeListener> listener) final;
  
  void AddGlobalChangeListener(::mojo::PendingRemote<CookieChangeListener> notification_pointer) final;
  
  void CloneInterface(::mojo::PendingReceiver<CookieManager> new_interface) final;
  
  void FlushCookieStore(FlushCookieStoreCallback callback) final;
  
  void AllowFileSchemeCookies(bool allow, AllowFileSchemeCookiesCallback callback) final;
  
  void SetContentSettings(::content_settings::mojom::blink::ContentSettingsType content_settings_type, ::blink::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr> settings, SetContentSettingsCallback callback) final;
  
  void SetRemoteFilter(::mojo::PendingRemote<CookieRemoteAccessFilter> remote_access_filter) final;
  
  void SetForceKeepSessionState() final;
  
  void BlockThirdPartyCookies(bool block) final;
  
  void SetMitigationsEnabledFor3pcd(bool enable) final;
  
  void SetTrackingProtectionEnabledFor3pcd(bool enable) final;
  
  void SetPreCommitCallbackDelayForTesting(::base::TimeDelta delay) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT CookieChangeListenerStubDispatch {
 public:
  static bool Accept(CookieChangeListener* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CookieChangeListener* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CookieChangeListener>>
class CookieChangeListenerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CookieChangeListenerStub() = default;
  ~CookieChangeListenerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CookieChangeListenerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CookieChangeListenerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT CookieRemoteAccessFilterStubDispatch {
 public:
  static bool Accept(CookieRemoteAccessFilter* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CookieRemoteAccessFilter* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CookieRemoteAccessFilter>>
class CookieRemoteAccessFilterStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CookieRemoteAccessFilterStub() = default;
  ~CookieRemoteAccessFilterStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CookieRemoteAccessFilterStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CookieRemoteAccessFilterStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT CookieManagerStubDispatch {
 public:
  static bool Accept(CookieManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CookieManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CookieManager>>
class CookieManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CookieManagerStub() = default;
  ~CookieManagerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CookieManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CookieManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT CookieChangeListenerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT CookieRemoteAccessFilterRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT CookieManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT CookieRemoteAccessFilterResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT CookieManagerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class BLINK_PLATFORM_EXPORT CookieSameSiteContextMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CookieSameSiteContextMetadata, T>::value>;
  using DataView = CookieSameSiteContextMetadataDataView;
  using Data_ = internal::CookieSameSiteContextMetadata_Data;

  template <typename... Args>
  static CookieSameSiteContextMetadataPtr New(Args&&... args) {
    return CookieSameSiteContextMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CookieSameSiteContextMetadataPtr From(const U& u) {
    return mojo::TypeConverter<CookieSameSiteContextMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CookieSameSiteContextMetadata>::Convert(*this);
  }


  CookieSameSiteContextMetadata();

  CookieSameSiteContextMetadata(
      CookieSameSiteContextMetadataDowngradeType cross_site_redirect_downgrade,
      ContextRedirectTypeBug1221316 redirect_type_bug_1221316);


  ~CookieSameSiteContextMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CookieSameSiteContextMetadataPtr>
  CookieSameSiteContextMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CookieSameSiteContextMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CookieSameSiteContextMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CookieSameSiteContextMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieSameSiteContextMetadata::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieSameSiteContextMetadata::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CookieSameSiteContextMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CookieSameSiteContextMetadata_UnserializedMessageContext<
            UserType, CookieSameSiteContextMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CookieSameSiteContextMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CookieSameSiteContextMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CookieSameSiteContextMetadata_UnserializedMessageContext<
            UserType, CookieSameSiteContextMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CookieSameSiteContextMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  CookieSameSiteContextMetadataDowngradeType cross_site_redirect_downgrade;
  
  ContextRedirectTypeBug1221316 redirect_type_bug_1221316;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CookieSameSiteContextMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CookieSameSiteContextMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CookieSameSiteContextMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CookieSameSiteContextMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class BLINK_PLATFORM_EXPORT ExclusionReasons {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ExclusionReasons, T>::value>;
  using DataView = ExclusionReasonsDataView;
  using Data_ = internal::ExclusionReasons_Data;

  template <typename... Args>
  static ExclusionReasonsPtr New(Args&&... args) {
    return ExclusionReasonsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ExclusionReasonsPtr From(const U& u) {
    return mojo::TypeConverter<ExclusionReasonsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ExclusionReasons>::Convert(*this);
  }


  ExclusionReasons();

  explicit ExclusionReasons(
      uint64_t exclusions_bitmask);


  ~ExclusionReasons();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ExclusionReasonsPtr>
  ExclusionReasonsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ExclusionReasons::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ExclusionReasons::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ExclusionReasons::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ExclusionReasons::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ExclusionReasons::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ExclusionReasons::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ExclusionReasons_UnserializedMessageContext<
            UserType, ExclusionReasons::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ExclusionReasons::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ExclusionReasons::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ExclusionReasons_UnserializedMessageContext<
            UserType, ExclusionReasons::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ExclusionReasons::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t exclusions_bitmask;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ExclusionReasons::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ExclusionReasons::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ExclusionReasons::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ExclusionReasons::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT WarningReasons {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WarningReasons, T>::value>;
  using DataView = WarningReasonsDataView;
  using Data_ = internal::WarningReasons_Data;

  template <typename... Args>
  static WarningReasonsPtr New(Args&&... args) {
    return WarningReasonsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WarningReasonsPtr From(const U& u) {
    return mojo::TypeConverter<WarningReasonsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WarningReasons>::Convert(*this);
  }


  WarningReasons();

  explicit WarningReasons(
      uint64_t warnings_bitmask);


  ~WarningReasons();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WarningReasonsPtr>
  WarningReasonsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WarningReasons::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WarningReasons::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WarningReasons::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WarningReasons::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WarningReasons::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WarningReasons::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WarningReasons_UnserializedMessageContext<
            UserType, WarningReasons::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WarningReasons::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WarningReasons::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WarningReasons_UnserializedMessageContext<
            UserType, WarningReasons::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WarningReasons::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t warnings_bitmask;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WarningReasons::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WarningReasons::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WarningReasons::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WarningReasons::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}












class BLINK_PLATFORM_EXPORT CookieOrLine {
 public:
  using DataView = CookieOrLineDataView;
  using Data_ = internal::CookieOrLine_Data;
  using Tag = Data_::CookieOrLine_Tag;

  template <typename... Args>
  static CookieOrLinePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |cookie|.
  static CookieOrLinePtr NewCookie(
      const ::net::CanonicalCookie& value);
  // Construct an instance holding |cookie_string|.
  static CookieOrLinePtr NewCookieString(
      const ::blink::String& value);

  template <typename U>
  static CookieOrLinePtr From(const U& u) {
    return mojo::TypeConverter<CookieOrLinePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CookieOrLine>::Convert(*this);
  }
  ~CookieOrLine();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  CookieOrLine(const CookieOrLine& other) = delete;
  CookieOrLine& operator=(const CookieOrLine& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = CookieOrLinePtr>
  CookieOrLinePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, CookieOrLine>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, CookieOrLine>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_cookie() const { return tag_ == Tag::kCookie; }
  const ::net::CanonicalCookie& get_cookie() const {
    CHECK(tag_ == Tag::kCookie);
    return data_.cookie;
  }
  ::net::CanonicalCookie& get_cookie() {
    CHECK(tag_ == Tag::kCookie);
    return data_.cookie;
  }
  void set_cookie(const ::net::CanonicalCookie& cookie);

  bool is_cookie_string() const { return tag_ == Tag::kCookieString; }
  const ::blink::String& get_cookie_string() const {
    CHECK(tag_ == Tag::kCookieString);
    return data_.cookie_string;
  }
  ::blink::String& get_cookie_string() {
    CHECK(tag_ == Tag::kCookieString);
    return data_.cookie_string;
  }
  void set_cookie_string(const ::blink::String& cookie_string);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CookieOrLine::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<CookieOrLine::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kCookie)>,
        const ::net::CanonicalCookie& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kCookieString)>,
        const ::blink::String& value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::net::CanonicalCookie cookie;
    ::blink::String cookie_string;
  };

  CookieOrLine(
      std::in_place_index_t<static_cast<size_t>(Tag::kCookie)>,
      const ::net::CanonicalCookie& value);
  CookieOrLine(
      std::in_place_index_t<static_cast<size_t>(Tag::kCookieString)>,
      const ::blink::String& value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class BLINK_PLATFORM_EXPORT CookieManagerParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CookieManagerParams, T>::value>;
  using DataView = CookieManagerParamsDataView;
  using Data_ = internal::CookieManagerParams_Data;

  template <typename... Args>
  static CookieManagerParamsPtr New(Args&&... args) {
    return CookieManagerParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CookieManagerParamsPtr From(const U& u) {
    return mojo::TypeConverter<CookieManagerParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CookieManagerParams>::Convert(*this);
  }


  CookieManagerParams();

  CookieManagerParams(
      bool block_third_party_cookies,
      bool tracking_protection_enabled_for_3pcd,
      bool mitigations_enabled_for_3pcd,
      ::blink::HashMap<::content_settings::mojom::blink::ContentSettingsType, ::blink::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr>> content_settings,
      ::blink::Vector<::blink::String> secure_origin_cookies_allowed_schemes,
      ::blink::Vector<::blink::String> matching_scheme_cookies_allowed_schemes,
      ::blink::Vector<::blink::String> third_party_cookies_allowed_schemes,
      bool allow_file_scheme_cookies,
      CookieAccessDelegateType cookie_access_delegate_type);

CookieManagerParams(const CookieManagerParams&) = delete;
CookieManagerParams& operator=(const CookieManagerParams&) = delete;

  ~CookieManagerParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CookieManagerParamsPtr>
  CookieManagerParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CookieManagerParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CookieManagerParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CookieManagerParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieManagerParams::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieManagerParams::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CookieManagerParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CookieManagerParams_UnserializedMessageContext<
            UserType, CookieManagerParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CookieManagerParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CookieManagerParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CookieManagerParams_UnserializedMessageContext<
            UserType, CookieManagerParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CookieManagerParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool block_third_party_cookies;
  
  bool tracking_protection_enabled_for_3pcd;
  
  bool mitigations_enabled_for_3pcd;
  
  ::blink::HashMap<::content_settings::mojom::blink::ContentSettingsType, ::blink::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr>> content_settings;
  
  ::blink::Vector<::blink::String> secure_origin_cookies_allowed_schemes;
  
  ::blink::Vector<::blink::String> matching_scheme_cookies_allowed_schemes;
  
  ::blink::Vector<::blink::String> third_party_cookies_allowed_schemes;
  
  bool allow_file_scheme_cookies;
  
  CookieAccessDelegateType cookie_access_delegate_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CookieManagerParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CookieManagerParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CookieManagerParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CookieManagerParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class BLINK_PLATFORM_EXPORT CookieSameSiteContext {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CookieSameSiteContext, T>::value>;
  using DataView = CookieSameSiteContextDataView;
  using Data_ = internal::CookieSameSiteContext_Data;

  template <typename... Args>
  static CookieSameSiteContextPtr New(Args&&... args) {
    return CookieSameSiteContextPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CookieSameSiteContextPtr From(const U& u) {
    return mojo::TypeConverter<CookieSameSiteContextPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CookieSameSiteContext>::Convert(*this);
  }


  CookieSameSiteContext();

  CookieSameSiteContext(
      ContextType context,
      ContextType schemeful_context,
      CookieSameSiteContextMetadataPtr metadata,
      CookieSameSiteContextMetadataPtr schemeful_metadata);

CookieSameSiteContext(const CookieSameSiteContext&) = delete;
CookieSameSiteContext& operator=(const CookieSameSiteContext&) = delete;

  ~CookieSameSiteContext();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CookieSameSiteContextPtr>
  CookieSameSiteContextPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CookieSameSiteContext::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CookieSameSiteContext::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CookieSameSiteContext::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieSameSiteContext::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieSameSiteContext::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CookieSameSiteContext::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CookieSameSiteContext_UnserializedMessageContext<
            UserType, CookieSameSiteContext::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CookieSameSiteContext::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CookieSameSiteContext::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CookieSameSiteContext_UnserializedMessageContext<
            UserType, CookieSameSiteContext::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CookieSameSiteContext::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ContextType context;
  
  ContextType schemeful_context;
  
  CookieSameSiteContextMetadataPtr metadata;
  
  CookieSameSiteContextMetadataPtr schemeful_metadata;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CookieSameSiteContext::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CookieSameSiteContext::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CookieSameSiteContext::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CookieSameSiteContext::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT CookieOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CookieOptions, T>::value>;
  using DataView = CookieOptionsDataView;
  using Data_ = internal::CookieOptions_Data;

  template <typename... Args>
  static CookieOptionsPtr New(Args&&... args) {
    return CookieOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CookieOptionsPtr From(const U& u) {
    return mojo::TypeConverter<CookieOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CookieOptions>::Convert(*this);
  }


  CookieOptions();

  CookieOptions(
      bool exclude_httponly,
      CookieSameSiteContextPtr same_site_cookie_context,
      bool update_access_time,
      bool return_excluded_cookies);

CookieOptions(const CookieOptions&) = delete;
CookieOptions& operator=(const CookieOptions&) = delete;

  ~CookieOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CookieOptionsPtr>
  CookieOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CookieOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CookieOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CookieOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieOptions::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieOptions::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CookieOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CookieOptions_UnserializedMessageContext<
            UserType, CookieOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CookieOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CookieOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CookieOptions_UnserializedMessageContext<
            UserType, CookieOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CookieOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool exclude_httponly;
  
  CookieSameSiteContextPtr same_site_cookie_context;
  
  bool update_access_time;
  
  bool return_excluded_cookies;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CookieOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CookieOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CookieOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CookieOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT CanonicalCookie {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CanonicalCookie, T>::value>;
  using DataView = CanonicalCookieDataView;
  using Data_ = internal::CanonicalCookie_Data;

  template <typename... Args>
  static CanonicalCookiePtr New(Args&&... args) {
    return CanonicalCookiePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CanonicalCookiePtr From(const U& u) {
    return mojo::TypeConverter<CanonicalCookiePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CanonicalCookie>::Convert(*this);
  }


  CanonicalCookie();

  CanonicalCookie(
      const ::blink::String& name,
      const ::blink::String& value,
      const ::blink::String& domain,
      const ::blink::String& path,
      ::base::Time creation,
      ::base::Time expiry,
      ::base::Time last_access,
      ::base::Time last_update,
      bool secure,
      bool httponly,
      CookieSameSite site_restrictions,
      CookiePriority priority,
      CookieSourceScheme source_scheme,
      ::network::mojom::blink::CookiePartitionKeyPtr partition_key,
      int32_t source_port,
      CookieSourceType source_type);

CanonicalCookie(const CanonicalCookie&) = delete;
CanonicalCookie& operator=(const CanonicalCookie&) = delete;

  ~CanonicalCookie();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CanonicalCookiePtr>
  CanonicalCookiePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CanonicalCookie::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CanonicalCookie::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CanonicalCookie::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CanonicalCookie::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CanonicalCookie::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CanonicalCookie::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CanonicalCookie_UnserializedMessageContext<
            UserType, CanonicalCookie::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CanonicalCookie::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CanonicalCookie::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CanonicalCookie_UnserializedMessageContext<
            UserType, CanonicalCookie::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CanonicalCookie::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String name;
  
  ::blink::String value;
  
  ::blink::String domain;
  
  ::blink::String path;
  
  ::base::Time creation;
  
  ::base::Time expiry;
  
  ::base::Time last_access;
  
  ::base::Time last_update;
  
  bool secure;
  
  bool httponly;
  
  CookieSameSite site_restrictions;
  
  CookiePriority priority;
  
  CookieSourceScheme source_scheme;
  
  ::network::mojom::blink::CookiePartitionKeyPtr partition_key;
  
  int32_t source_port;
  
  CookieSourceType source_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CanonicalCookie::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CanonicalCookie::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CanonicalCookie::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CanonicalCookie::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class BLINK_PLATFORM_EXPORT CookieInclusionStatus {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CookieInclusionStatus, T>::value>;
  using DataView = CookieInclusionStatusDataView;
  using Data_ = internal::CookieInclusionStatus_Data;

  template <typename... Args>
  static CookieInclusionStatusPtr New(Args&&... args) {
    return CookieInclusionStatusPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CookieInclusionStatusPtr From(const U& u) {
    return mojo::TypeConverter<CookieInclusionStatusPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CookieInclusionStatus>::Convert(*this);
  }


  CookieInclusionStatus();

  CookieInclusionStatus(
      ExclusionReasonsPtr exclusion_reasons,
      WarningReasonsPtr warning_reasons,
      CookieExemptionReason exemption_reason);

CookieInclusionStatus(const CookieInclusionStatus&) = delete;
CookieInclusionStatus& operator=(const CookieInclusionStatus&) = delete;

  ~CookieInclusionStatus();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CookieInclusionStatusPtr>
  CookieInclusionStatusPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CookieInclusionStatus::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CookieInclusionStatus::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CookieInclusionStatus::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieInclusionStatus::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieInclusionStatus::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CookieInclusionStatus::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CookieInclusionStatus_UnserializedMessageContext<
            UserType, CookieInclusionStatus::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CookieInclusionStatus::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CookieInclusionStatus::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CookieInclusionStatus_UnserializedMessageContext<
            UserType, CookieInclusionStatus::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CookieInclusionStatus::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ExclusionReasonsPtr exclusion_reasons;
  
  WarningReasonsPtr warning_reasons;
  
  CookieExemptionReason exemption_reason;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CookieInclusionStatus::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CookieInclusionStatus::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CookieInclusionStatus::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CookieInclusionStatus::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT CookieAndLineWithAccessResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CookieAndLineWithAccessResult, T>::value>;
  using DataView = CookieAndLineWithAccessResultDataView;
  using Data_ = internal::CookieAndLineWithAccessResult_Data;

  template <typename... Args>
  static CookieAndLineWithAccessResultPtr New(Args&&... args) {
    return CookieAndLineWithAccessResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CookieAndLineWithAccessResultPtr From(const U& u) {
    return mojo::TypeConverter<CookieAndLineWithAccessResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CookieAndLineWithAccessResult>::Convert(*this);
  }


  CookieAndLineWithAccessResult();

  CookieAndLineWithAccessResult(
      const std::optional<::net::CanonicalCookie>& cookie,
      const ::blink::String& cookie_string,
      CookieAccessResultPtr access_result);

CookieAndLineWithAccessResult(const CookieAndLineWithAccessResult&) = delete;
CookieAndLineWithAccessResult& operator=(const CookieAndLineWithAccessResult&) = delete;

  ~CookieAndLineWithAccessResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CookieAndLineWithAccessResultPtr>
  CookieAndLineWithAccessResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CookieAndLineWithAccessResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CookieAndLineWithAccessResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CookieAndLineWithAccessResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieAndLineWithAccessResult::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieAndLineWithAccessResult::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CookieAndLineWithAccessResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CookieAndLineWithAccessResult_UnserializedMessageContext<
            UserType, CookieAndLineWithAccessResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CookieAndLineWithAccessResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CookieAndLineWithAccessResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CookieAndLineWithAccessResult_UnserializedMessageContext<
            UserType, CookieAndLineWithAccessResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CookieAndLineWithAccessResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::net::CanonicalCookie> cookie;
  
  ::blink::String cookie_string;
  
  CookieAccessResultPtr access_result;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CookieAndLineWithAccessResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CookieAndLineWithAccessResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CookieAndLineWithAccessResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CookieAndLineWithAccessResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT CookieOrLineWithAccessResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CookieOrLineWithAccessResult, T>::value>;
  using DataView = CookieOrLineWithAccessResultDataView;
  using Data_ = internal::CookieOrLineWithAccessResult_Data;

  template <typename... Args>
  static CookieOrLineWithAccessResultPtr New(Args&&... args) {
    return CookieOrLineWithAccessResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CookieOrLineWithAccessResultPtr From(const U& u) {
    return mojo::TypeConverter<CookieOrLineWithAccessResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CookieOrLineWithAccessResult>::Convert(*this);
  }


  CookieOrLineWithAccessResult();

  CookieOrLineWithAccessResult(
      CookieOrLinePtr cookie_or_line,
      CookieAccessResultPtr access_result);

CookieOrLineWithAccessResult(const CookieOrLineWithAccessResult&) = delete;
CookieOrLineWithAccessResult& operator=(const CookieOrLineWithAccessResult&) = delete;

  ~CookieOrLineWithAccessResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CookieOrLineWithAccessResultPtr>
  CookieOrLineWithAccessResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CookieOrLineWithAccessResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CookieOrLineWithAccessResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CookieOrLineWithAccessResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieOrLineWithAccessResult::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieOrLineWithAccessResult::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CookieOrLineWithAccessResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CookieOrLineWithAccessResult_UnserializedMessageContext<
            UserType, CookieOrLineWithAccessResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CookieOrLineWithAccessResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CookieOrLineWithAccessResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CookieOrLineWithAccessResult_UnserializedMessageContext<
            UserType, CookieOrLineWithAccessResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CookieOrLineWithAccessResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  CookieOrLinePtr cookie_or_line;
  
  CookieAccessResultPtr access_result;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CookieOrLineWithAccessResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CookieOrLineWithAccessResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CookieOrLineWithAccessResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CookieOrLineWithAccessResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT CookieAccessResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CookieAccessResult, T>::value>;
  using DataView = CookieAccessResultDataView;
  using Data_ = internal::CookieAccessResult_Data;

  template <typename... Args>
  static CookieAccessResultPtr New(Args&&... args) {
    return CookieAccessResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CookieAccessResultPtr From(const U& u) {
    return mojo::TypeConverter<CookieAccessResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CookieAccessResult>::Convert(*this);
  }


  CookieAccessResult();

  CookieAccessResult(
      CookieEffectiveSameSite effective_same_site,
      CookieAccessSemantics access_semantics,
      CookieScopeSemantics scope_semantics,
      ::net::CookieInclusionStatus status,
      bool is_allowed_to_access_secure_cookies);

CookieAccessResult(const CookieAccessResult&) = delete;
CookieAccessResult& operator=(const CookieAccessResult&) = delete;

  ~CookieAccessResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CookieAccessResultPtr>
  CookieAccessResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CookieAccessResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CookieAccessResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CookieAccessResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieAccessResult::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieAccessResult::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CookieAccessResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CookieAccessResult_UnserializedMessageContext<
            UserType, CookieAccessResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CookieAccessResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CookieAccessResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CookieAccessResult_UnserializedMessageContext<
            UserType, CookieAccessResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CookieAccessResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  CookieEffectiveSameSite effective_same_site;
  
  CookieAccessSemantics access_semantics;
  
  CookieScopeSemantics scope_semantics;
  
  ::net::CookieInclusionStatus status;
  
  bool is_allowed_to_access_secure_cookies;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CookieAccessResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CookieAccessResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CookieAccessResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CookieAccessResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT CookieWithAccessResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CookieWithAccessResult, T>::value>;
  using DataView = CookieWithAccessResultDataView;
  using Data_ = internal::CookieWithAccessResult_Data;

  template <typename... Args>
  static CookieWithAccessResultPtr New(Args&&... args) {
    return CookieWithAccessResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CookieWithAccessResultPtr From(const U& u) {
    return mojo::TypeConverter<CookieWithAccessResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CookieWithAccessResult>::Convert(*this);
  }


  CookieWithAccessResult();

  CookieWithAccessResult(
      const ::net::CanonicalCookie& cookie,
      CookieAccessResultPtr access_result);

CookieWithAccessResult(const CookieWithAccessResult&) = delete;
CookieWithAccessResult& operator=(const CookieWithAccessResult&) = delete;

  ~CookieWithAccessResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CookieWithAccessResultPtr>
  CookieWithAccessResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CookieWithAccessResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CookieWithAccessResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CookieWithAccessResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieWithAccessResult::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieWithAccessResult::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CookieWithAccessResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CookieWithAccessResult_UnserializedMessageContext<
            UserType, CookieWithAccessResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CookieWithAccessResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CookieWithAccessResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CookieWithAccessResult_UnserializedMessageContext<
            UserType, CookieWithAccessResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CookieWithAccessResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::net::CanonicalCookie cookie;
  
  CookieAccessResultPtr access_result;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CookieWithAccessResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CookieWithAccessResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CookieWithAccessResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CookieWithAccessResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT CookieChangeInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CookieChangeInfo, T>::value>;
  using DataView = CookieChangeInfoDataView;
  using Data_ = internal::CookieChangeInfo_Data;

  template <typename... Args>
  static CookieChangeInfoPtr New(Args&&... args) {
    return CookieChangeInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CookieChangeInfoPtr From(const U& u) {
    return mojo::TypeConverter<CookieChangeInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CookieChangeInfo>::Convert(*this);
  }


  CookieChangeInfo();

  CookieChangeInfo(
      const ::net::CanonicalCookie& cookie,
      CookieAccessResultPtr access_result,
      CookieChangeCause cause);

CookieChangeInfo(const CookieChangeInfo&) = delete;
CookieChangeInfo& operator=(const CookieChangeInfo&) = delete;

  ~CookieChangeInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CookieChangeInfoPtr>
  CookieChangeInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CookieChangeInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CookieChangeInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CookieChangeInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieChangeInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieChangeInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CookieChangeInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CookieChangeInfo_UnserializedMessageContext<
            UserType, CookieChangeInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CookieChangeInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CookieChangeInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CookieChangeInfo_UnserializedMessageContext<
            UserType, CookieChangeInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CookieChangeInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::net::CanonicalCookie cookie;
  
  CookieAccessResultPtr access_result;
  
  CookieChangeCause cause;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CookieChangeInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CookieChangeInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CookieChangeInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CookieChangeInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT CookieDeletionFilter {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CookieDeletionFilter, T>::value>;
  using DataView = CookieDeletionFilterDataView;
  using Data_ = internal::CookieDeletionFilter_Data;

  template <typename... Args>
  static CookieDeletionFilterPtr New(Args&&... args) {
    return CookieDeletionFilterPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CookieDeletionFilterPtr From(const U& u) {
    return mojo::TypeConverter<CookieDeletionFilterPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CookieDeletionFilter>::Convert(*this);
  }


  CookieDeletionFilter();

  CookieDeletionFilter(
      std::optional<::base::Time> created_after_time,
      std::optional<::base::Time> created_before_time,
      std::optional<::blink::Vector<::blink::String>> excluding_domains,
      std::optional<::blink::Vector<::blink::String>> including_domains,
      const ::blink::String& cookie_name,
      const ::blink::String& host_name,
      const std::optional<::blink::KURL>& url,
      CookieDeletionSessionControl session_control,
      ::network::mojom::blink::CookiePartitionKeyCollectionPtr cookie_partition_key_collection,
      bool partitioned_state_only);

CookieDeletionFilter(const CookieDeletionFilter&) = delete;
CookieDeletionFilter& operator=(const CookieDeletionFilter&) = delete;

  ~CookieDeletionFilter();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CookieDeletionFilterPtr>
  CookieDeletionFilterPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CookieDeletionFilter::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CookieDeletionFilter::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CookieDeletionFilter::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieDeletionFilter::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieDeletionFilter::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CookieDeletionFilter::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CookieDeletionFilter_UnserializedMessageContext<
            UserType, CookieDeletionFilter::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CookieDeletionFilter::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CookieDeletionFilter::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CookieDeletionFilter_UnserializedMessageContext<
            UserType, CookieDeletionFilter::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CookieDeletionFilter::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::base::Time> created_after_time;
  
  std::optional<::base::Time> created_before_time;
  
  std::optional<::blink::Vector<::blink::String>> excluding_domains;
  
  std::optional<::blink::Vector<::blink::String>> including_domains;
  
  ::blink::String cookie_name;
  
  ::blink::String host_name;
  
  std::optional<::blink::KURL> url;
  
  CookieDeletionSessionControl session_control;
  
  ::network::mojom::blink::CookiePartitionKeyCollectionPtr cookie_partition_key_collection;
  
  bool partitioned_state_only;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CookieDeletionFilter::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CookieDeletionFilter::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CookieDeletionFilter::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CookieDeletionFilter::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
CookieOrLinePtr CookieOrLine::Clone() const {
  switch (tag_) {
    case Tag::kCookie:
      return NewCookie(
          mojo::Clone(data_.cookie));
    case Tag::kCookieString:
      return NewCookieString(
          mojo::Clone(data_.cookie_string));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, CookieOrLine>::value>::type*>
bool CookieOrLine::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kCookie:
      return mojo::Equals(data_.cookie, other.data_.cookie);
    case Tag::kCookieString:
      return mojo::Equals(data_.cookie_string, other.data_.cookie_string);
  }

  return false;
}
template <typename StructPtrType>
CookieManagerParamsPtr CookieManagerParams::Clone() const {
  return New(
      mojo::Clone(block_third_party_cookies),
      mojo::Clone(tracking_protection_enabled_for_3pcd),
      mojo::Clone(mitigations_enabled_for_3pcd),
      mojo::Clone(content_settings),
      mojo::Clone(secure_origin_cookies_allowed_schemes),
      mojo::Clone(matching_scheme_cookies_allowed_schemes),
      mojo::Clone(third_party_cookies_allowed_schemes),
      mojo::Clone(allow_file_scheme_cookies),
      mojo::Clone(cookie_access_delegate_type)
  );
}

template <typename T, CookieManagerParams::EnableIfSame<T>*>
bool CookieManagerParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->block_third_party_cookies, other_struct.block_third_party_cookies))
    return false;
  if (!mojo::Equals(this->tracking_protection_enabled_for_3pcd, other_struct.tracking_protection_enabled_for_3pcd))
    return false;
  if (!mojo::Equals(this->mitigations_enabled_for_3pcd, other_struct.mitigations_enabled_for_3pcd))
    return false;
  if (!mojo::Equals(this->content_settings, other_struct.content_settings))
    return false;
  if (!mojo::Equals(this->secure_origin_cookies_allowed_schemes, other_struct.secure_origin_cookies_allowed_schemes))
    return false;
  if (!mojo::Equals(this->matching_scheme_cookies_allowed_schemes, other_struct.matching_scheme_cookies_allowed_schemes))
    return false;
  if (!mojo::Equals(this->third_party_cookies_allowed_schemes, other_struct.third_party_cookies_allowed_schemes))
    return false;
  if (!mojo::Equals(this->allow_file_scheme_cookies, other_struct.allow_file_scheme_cookies))
    return false;
  if (!mojo::Equals(this->cookie_access_delegate_type, other_struct.cookie_access_delegate_type))
    return false;
  return true;
}

template <typename T, CookieManagerParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.block_third_party_cookies < rhs.block_third_party_cookies)
    return true;
  if (rhs.block_third_party_cookies < lhs.block_third_party_cookies)
    return false;
  if (lhs.tracking_protection_enabled_for_3pcd < rhs.tracking_protection_enabled_for_3pcd)
    return true;
  if (rhs.tracking_protection_enabled_for_3pcd < lhs.tracking_protection_enabled_for_3pcd)
    return false;
  if (lhs.mitigations_enabled_for_3pcd < rhs.mitigations_enabled_for_3pcd)
    return true;
  if (rhs.mitigations_enabled_for_3pcd < lhs.mitigations_enabled_for_3pcd)
    return false;
  if (lhs.content_settings < rhs.content_settings)
    return true;
  if (rhs.content_settings < lhs.content_settings)
    return false;
  if (lhs.secure_origin_cookies_allowed_schemes < rhs.secure_origin_cookies_allowed_schemes)
    return true;
  if (rhs.secure_origin_cookies_allowed_schemes < lhs.secure_origin_cookies_allowed_schemes)
    return false;
  if (lhs.matching_scheme_cookies_allowed_schemes < rhs.matching_scheme_cookies_allowed_schemes)
    return true;
  if (rhs.matching_scheme_cookies_allowed_schemes < lhs.matching_scheme_cookies_allowed_schemes)
    return false;
  if (lhs.third_party_cookies_allowed_schemes < rhs.third_party_cookies_allowed_schemes)
    return true;
  if (rhs.third_party_cookies_allowed_schemes < lhs.third_party_cookies_allowed_schemes)
    return false;
  if (lhs.allow_file_scheme_cookies < rhs.allow_file_scheme_cookies)
    return true;
  if (rhs.allow_file_scheme_cookies < lhs.allow_file_scheme_cookies)
    return false;
  if (lhs.cookie_access_delegate_type < rhs.cookie_access_delegate_type)
    return true;
  if (rhs.cookie_access_delegate_type < lhs.cookie_access_delegate_type)
    return false;
  return false;
}
template <typename StructPtrType>
CookieSameSiteContextMetadataPtr CookieSameSiteContextMetadata::Clone() const {
  return New(
      mojo::Clone(cross_site_redirect_downgrade),
      mojo::Clone(redirect_type_bug_1221316)
  );
}

template <typename T, CookieSameSiteContextMetadata::EnableIfSame<T>*>
bool CookieSameSiteContextMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->cross_site_redirect_downgrade, other_struct.cross_site_redirect_downgrade))
    return false;
  if (!mojo::Equals(this->redirect_type_bug_1221316, other_struct.redirect_type_bug_1221316))
    return false;
  return true;
}

template <typename T, CookieSameSiteContextMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.cross_site_redirect_downgrade < rhs.cross_site_redirect_downgrade)
    return true;
  if (rhs.cross_site_redirect_downgrade < lhs.cross_site_redirect_downgrade)
    return false;
  if (lhs.redirect_type_bug_1221316 < rhs.redirect_type_bug_1221316)
    return true;
  if (rhs.redirect_type_bug_1221316 < lhs.redirect_type_bug_1221316)
    return false;
  return false;
}
template <typename StructPtrType>
CookieSameSiteContextPtr CookieSameSiteContext::Clone() const {
  return New(
      mojo::Clone(context),
      mojo::Clone(schemeful_context),
      mojo::Clone(metadata),
      mojo::Clone(schemeful_metadata)
  );
}

template <typename T, CookieSameSiteContext::EnableIfSame<T>*>
bool CookieSameSiteContext::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->context, other_struct.context))
    return false;
  if (!mojo::Equals(this->schemeful_context, other_struct.schemeful_context))
    return false;
  if (!mojo::Equals(this->metadata, other_struct.metadata))
    return false;
  if (!mojo::Equals(this->schemeful_metadata, other_struct.schemeful_metadata))
    return false;
  return true;
}

template <typename T, CookieSameSiteContext::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.context < rhs.context)
    return true;
  if (rhs.context < lhs.context)
    return false;
  if (lhs.schemeful_context < rhs.schemeful_context)
    return true;
  if (rhs.schemeful_context < lhs.schemeful_context)
    return false;
  if (lhs.metadata < rhs.metadata)
    return true;
  if (rhs.metadata < lhs.metadata)
    return false;
  if (lhs.schemeful_metadata < rhs.schemeful_metadata)
    return true;
  if (rhs.schemeful_metadata < lhs.schemeful_metadata)
    return false;
  return false;
}
template <typename StructPtrType>
CookieOptionsPtr CookieOptions::Clone() const {
  return New(
      mojo::Clone(exclude_httponly),
      mojo::Clone(same_site_cookie_context),
      mojo::Clone(update_access_time),
      mojo::Clone(return_excluded_cookies)
  );
}

template <typename T, CookieOptions::EnableIfSame<T>*>
bool CookieOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->exclude_httponly, other_struct.exclude_httponly))
    return false;
  if (!mojo::Equals(this->same_site_cookie_context, other_struct.same_site_cookie_context))
    return false;
  if (!mojo::Equals(this->update_access_time, other_struct.update_access_time))
    return false;
  if (!mojo::Equals(this->return_excluded_cookies, other_struct.return_excluded_cookies))
    return false;
  return true;
}

template <typename T, CookieOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.exclude_httponly < rhs.exclude_httponly)
    return true;
  if (rhs.exclude_httponly < lhs.exclude_httponly)
    return false;
  if (lhs.same_site_cookie_context < rhs.same_site_cookie_context)
    return true;
  if (rhs.same_site_cookie_context < lhs.same_site_cookie_context)
    return false;
  if (lhs.update_access_time < rhs.update_access_time)
    return true;
  if (rhs.update_access_time < lhs.update_access_time)
    return false;
  if (lhs.return_excluded_cookies < rhs.return_excluded_cookies)
    return true;
  if (rhs.return_excluded_cookies < lhs.return_excluded_cookies)
    return false;
  return false;
}
template <typename StructPtrType>
CanonicalCookiePtr CanonicalCookie::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(value),
      mojo::Clone(domain),
      mojo::Clone(path),
      mojo::Clone(creation),
      mojo::Clone(expiry),
      mojo::Clone(last_access),
      mojo::Clone(last_update),
      mojo::Clone(secure),
      mojo::Clone(httponly),
      mojo::Clone(site_restrictions),
      mojo::Clone(priority),
      mojo::Clone(source_scheme),
      mojo::Clone(partition_key),
      mojo::Clone(source_port),
      mojo::Clone(source_type)
  );
}

template <typename T, CanonicalCookie::EnableIfSame<T>*>
bool CanonicalCookie::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  if (!mojo::Equals(this->domain, other_struct.domain))
    return false;
  if (!mojo::Equals(this->path, other_struct.path))
    return false;
  if (!mojo::Equals(this->creation, other_struct.creation))
    return false;
  if (!mojo::Equals(this->expiry, other_struct.expiry))
    return false;
  if (!mojo::Equals(this->last_access, other_struct.last_access))
    return false;
  if (!mojo::Equals(this->last_update, other_struct.last_update))
    return false;
  if (!mojo::Equals(this->secure, other_struct.secure))
    return false;
  if (!mojo::Equals(this->httponly, other_struct.httponly))
    return false;
  if (!mojo::Equals(this->site_restrictions, other_struct.site_restrictions))
    return false;
  if (!mojo::Equals(this->priority, other_struct.priority))
    return false;
  if (!mojo::Equals(this->source_scheme, other_struct.source_scheme))
    return false;
  if (!mojo::Equals(this->partition_key, other_struct.partition_key))
    return false;
  if (!mojo::Equals(this->source_port, other_struct.source_port))
    return false;
  if (!mojo::Equals(this->source_type, other_struct.source_type))
    return false;
  return true;
}

template <typename T, CanonicalCookie::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  if (lhs.domain < rhs.domain)
    return true;
  if (rhs.domain < lhs.domain)
    return false;
  if (lhs.path < rhs.path)
    return true;
  if (rhs.path < lhs.path)
    return false;
  if (lhs.creation < rhs.creation)
    return true;
  if (rhs.creation < lhs.creation)
    return false;
  if (lhs.expiry < rhs.expiry)
    return true;
  if (rhs.expiry < lhs.expiry)
    return false;
  if (lhs.last_access < rhs.last_access)
    return true;
  if (rhs.last_access < lhs.last_access)
    return false;
  if (lhs.last_update < rhs.last_update)
    return true;
  if (rhs.last_update < lhs.last_update)
    return false;
  if (lhs.secure < rhs.secure)
    return true;
  if (rhs.secure < lhs.secure)
    return false;
  if (lhs.httponly < rhs.httponly)
    return true;
  if (rhs.httponly < lhs.httponly)
    return false;
  if (lhs.site_restrictions < rhs.site_restrictions)
    return true;
  if (rhs.site_restrictions < lhs.site_restrictions)
    return false;
  if (lhs.priority < rhs.priority)
    return true;
  if (rhs.priority < lhs.priority)
    return false;
  if (lhs.source_scheme < rhs.source_scheme)
    return true;
  if (rhs.source_scheme < lhs.source_scheme)
    return false;
  if (lhs.partition_key < rhs.partition_key)
    return true;
  if (rhs.partition_key < lhs.partition_key)
    return false;
  if (lhs.source_port < rhs.source_port)
    return true;
  if (rhs.source_port < lhs.source_port)
    return false;
  if (lhs.source_type < rhs.source_type)
    return true;
  if (rhs.source_type < lhs.source_type)
    return false;
  return false;
}
template <typename StructPtrType>
ExclusionReasonsPtr ExclusionReasons::Clone() const {
  return New(
      mojo::Clone(exclusions_bitmask)
  );
}

template <typename T, ExclusionReasons::EnableIfSame<T>*>
bool ExclusionReasons::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->exclusions_bitmask, other_struct.exclusions_bitmask))
    return false;
  return true;
}

template <typename T, ExclusionReasons::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.exclusions_bitmask < rhs.exclusions_bitmask)
    return true;
  if (rhs.exclusions_bitmask < lhs.exclusions_bitmask)
    return false;
  return false;
}
template <typename StructPtrType>
WarningReasonsPtr WarningReasons::Clone() const {
  return New(
      mojo::Clone(warnings_bitmask)
  );
}

template <typename T, WarningReasons::EnableIfSame<T>*>
bool WarningReasons::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->warnings_bitmask, other_struct.warnings_bitmask))
    return false;
  return true;
}

template <typename T, WarningReasons::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.warnings_bitmask < rhs.warnings_bitmask)
    return true;
  if (rhs.warnings_bitmask < lhs.warnings_bitmask)
    return false;
  return false;
}
template <typename StructPtrType>
CookieInclusionStatusPtr CookieInclusionStatus::Clone() const {
  return New(
      mojo::Clone(exclusion_reasons),
      mojo::Clone(warning_reasons),
      mojo::Clone(exemption_reason)
  );
}

template <typename T, CookieInclusionStatus::EnableIfSame<T>*>
bool CookieInclusionStatus::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->exclusion_reasons, other_struct.exclusion_reasons))
    return false;
  if (!mojo::Equals(this->warning_reasons, other_struct.warning_reasons))
    return false;
  if (!mojo::Equals(this->exemption_reason, other_struct.exemption_reason))
    return false;
  return true;
}

template <typename T, CookieInclusionStatus::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.exclusion_reasons < rhs.exclusion_reasons)
    return true;
  if (rhs.exclusion_reasons < lhs.exclusion_reasons)
    return false;
  if (lhs.warning_reasons < rhs.warning_reasons)
    return true;
  if (rhs.warning_reasons < lhs.warning_reasons)
    return false;
  if (lhs.exemption_reason < rhs.exemption_reason)
    return true;
  if (rhs.exemption_reason < lhs.exemption_reason)
    return false;
  return false;
}
template <typename StructPtrType>
CookieAndLineWithAccessResultPtr CookieAndLineWithAccessResult::Clone() const {
  return New(
      mojo::Clone(cookie),
      mojo::Clone(cookie_string),
      mojo::Clone(access_result)
  );
}

template <typename T, CookieAndLineWithAccessResult::EnableIfSame<T>*>
bool CookieAndLineWithAccessResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->cookie, other_struct.cookie))
    return false;
  if (!mojo::Equals(this->cookie_string, other_struct.cookie_string))
    return false;
  if (!mojo::Equals(this->access_result, other_struct.access_result))
    return false;
  return true;
}

template <typename T, CookieAndLineWithAccessResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.cookie < rhs.cookie)
    return true;
  if (rhs.cookie < lhs.cookie)
    return false;
  if (lhs.cookie_string < rhs.cookie_string)
    return true;
  if (rhs.cookie_string < lhs.cookie_string)
    return false;
  if (lhs.access_result < rhs.access_result)
    return true;
  if (rhs.access_result < lhs.access_result)
    return false;
  return false;
}
template <typename StructPtrType>
CookieOrLineWithAccessResultPtr CookieOrLineWithAccessResult::Clone() const {
  return New(
      mojo::Clone(cookie_or_line),
      mojo::Clone(access_result)
  );
}

template <typename T, CookieOrLineWithAccessResult::EnableIfSame<T>*>
bool CookieOrLineWithAccessResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->cookie_or_line, other_struct.cookie_or_line))
    return false;
  if (!mojo::Equals(this->access_result, other_struct.access_result))
    return false;
  return true;
}

template <typename T, CookieOrLineWithAccessResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.cookie_or_line < rhs.cookie_or_line)
    return true;
  if (rhs.cookie_or_line < lhs.cookie_or_line)
    return false;
  if (lhs.access_result < rhs.access_result)
    return true;
  if (rhs.access_result < lhs.access_result)
    return false;
  return false;
}
template <typename StructPtrType>
CookieAccessResultPtr CookieAccessResult::Clone() const {
  return New(
      mojo::Clone(effective_same_site),
      mojo::Clone(access_semantics),
      mojo::Clone(scope_semantics),
      mojo::Clone(status),
      mojo::Clone(is_allowed_to_access_secure_cookies)
  );
}

template <typename T, CookieAccessResult::EnableIfSame<T>*>
bool CookieAccessResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->effective_same_site, other_struct.effective_same_site))
    return false;
  if (!mojo::Equals(this->access_semantics, other_struct.access_semantics))
    return false;
  if (!mojo::Equals(this->scope_semantics, other_struct.scope_semantics))
    return false;
  if (!mojo::Equals(this->status, other_struct.status))
    return false;
  if (!mojo::Equals(this->is_allowed_to_access_secure_cookies, other_struct.is_allowed_to_access_secure_cookies))
    return false;
  return true;
}

template <typename T, CookieAccessResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.effective_same_site < rhs.effective_same_site)
    return true;
  if (rhs.effective_same_site < lhs.effective_same_site)
    return false;
  if (lhs.access_semantics < rhs.access_semantics)
    return true;
  if (rhs.access_semantics < lhs.access_semantics)
    return false;
  if (lhs.scope_semantics < rhs.scope_semantics)
    return true;
  if (rhs.scope_semantics < lhs.scope_semantics)
    return false;
  if (lhs.status < rhs.status)
    return true;
  if (rhs.status < lhs.status)
    return false;
  if (lhs.is_allowed_to_access_secure_cookies < rhs.is_allowed_to_access_secure_cookies)
    return true;
  if (rhs.is_allowed_to_access_secure_cookies < lhs.is_allowed_to_access_secure_cookies)
    return false;
  return false;
}
template <typename StructPtrType>
CookieWithAccessResultPtr CookieWithAccessResult::Clone() const {
  return New(
      mojo::Clone(cookie),
      mojo::Clone(access_result)
  );
}

template <typename T, CookieWithAccessResult::EnableIfSame<T>*>
bool CookieWithAccessResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->cookie, other_struct.cookie))
    return false;
  if (!mojo::Equals(this->access_result, other_struct.access_result))
    return false;
  return true;
}

template <typename T, CookieWithAccessResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.cookie < rhs.cookie)
    return true;
  if (rhs.cookie < lhs.cookie)
    return false;
  if (lhs.access_result < rhs.access_result)
    return true;
  if (rhs.access_result < lhs.access_result)
    return false;
  return false;
}
template <typename StructPtrType>
CookieChangeInfoPtr CookieChangeInfo::Clone() const {
  return New(
      mojo::Clone(cookie),
      mojo::Clone(access_result),
      mojo::Clone(cause)
  );
}

template <typename T, CookieChangeInfo::EnableIfSame<T>*>
bool CookieChangeInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->cookie, other_struct.cookie))
    return false;
  if (!mojo::Equals(this->access_result, other_struct.access_result))
    return false;
  if (!mojo::Equals(this->cause, other_struct.cause))
    return false;
  return true;
}

template <typename T, CookieChangeInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.cookie < rhs.cookie)
    return true;
  if (rhs.cookie < lhs.cookie)
    return false;
  if (lhs.access_result < rhs.access_result)
    return true;
  if (rhs.access_result < lhs.access_result)
    return false;
  if (lhs.cause < rhs.cause)
    return true;
  if (rhs.cause < lhs.cause)
    return false;
  return false;
}
template <typename StructPtrType>
CookieDeletionFilterPtr CookieDeletionFilter::Clone() const {
  return New(
      mojo::Clone(created_after_time),
      mojo::Clone(created_before_time),
      mojo::Clone(excluding_domains),
      mojo::Clone(including_domains),
      mojo::Clone(cookie_name),
      mojo::Clone(host_name),
      mojo::Clone(url),
      mojo::Clone(session_control),
      mojo::Clone(cookie_partition_key_collection),
      mojo::Clone(partitioned_state_only)
  );
}

template <typename T, CookieDeletionFilter::EnableIfSame<T>*>
bool CookieDeletionFilter::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->created_after_time, other_struct.created_after_time))
    return false;
  if (!mojo::Equals(this->created_before_time, other_struct.created_before_time))
    return false;
  if (!mojo::Equals(this->excluding_domains, other_struct.excluding_domains))
    return false;
  if (!mojo::Equals(this->including_domains, other_struct.including_domains))
    return false;
  if (!mojo::Equals(this->cookie_name, other_struct.cookie_name))
    return false;
  if (!mojo::Equals(this->host_name, other_struct.host_name))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->session_control, other_struct.session_control))
    return false;
  if (!mojo::Equals(this->cookie_partition_key_collection, other_struct.cookie_partition_key_collection))
    return false;
  if (!mojo::Equals(this->partitioned_state_only, other_struct.partitioned_state_only))
    return false;
  return true;
}

template <typename T, CookieDeletionFilter::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.created_after_time < rhs.created_after_time)
    return true;
  if (rhs.created_after_time < lhs.created_after_time)
    return false;
  if (lhs.created_before_time < rhs.created_before_time)
    return true;
  if (rhs.created_before_time < lhs.created_before_time)
    return false;
  if (lhs.excluding_domains < rhs.excluding_domains)
    return true;
  if (rhs.excluding_domains < lhs.excluding_domains)
    return false;
  if (lhs.including_domains < rhs.including_domains)
    return true;
  if (rhs.including_domains < lhs.including_domains)
    return false;
  if (lhs.cookie_name < rhs.cookie_name)
    return true;
  if (rhs.cookie_name < lhs.cookie_name)
    return false;
  if (lhs.host_name < rhs.host_name)
    return true;
  if (rhs.host_name < lhs.host_name)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.session_control < rhs.session_control)
    return true;
  if (rhs.session_control < lhs.session_control)
    return false;
  if (lhs.cookie_partition_key_collection < rhs.cookie_partition_key_collection)
    return true;
  if (rhs.cookie_partition_key_collection < lhs.cookie_partition_key_collection)
    return false;
  if (lhs.partitioned_state_only < rhs.partitioned_state_only)
    return true;
  if (rhs.partitioned_state_only < lhs.partitioned_state_only)
    return false;
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::CookieManagerParams::DataView,
                                         ::network::mojom::blink::CookieManagerParamsPtr> {
  static bool IsNull(const ::network::mojom::blink::CookieManagerParamsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::CookieManagerParamsPtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::CookieManagerParams::block_third_party_cookies) block_third_party_cookies(
      const ::network::mojom::blink::CookieManagerParamsPtr& input) {
    return input->block_third_party_cookies;
  }

  static decltype(::network::mojom::blink::CookieManagerParams::tracking_protection_enabled_for_3pcd) tracking_protection_enabled_for_3pcd(
      const ::network::mojom::blink::CookieManagerParamsPtr& input) {
    return input->tracking_protection_enabled_for_3pcd;
  }

  static decltype(::network::mojom::blink::CookieManagerParams::mitigations_enabled_for_3pcd) mitigations_enabled_for_3pcd(
      const ::network::mojom::blink::CookieManagerParamsPtr& input) {
    return input->mitigations_enabled_for_3pcd;
  }

  static const decltype(::network::mojom::blink::CookieManagerParams::content_settings)& content_settings(
      const ::network::mojom::blink::CookieManagerParamsPtr& input) {
    return input->content_settings;
  }

  static const decltype(::network::mojom::blink::CookieManagerParams::secure_origin_cookies_allowed_schemes)& secure_origin_cookies_allowed_schemes(
      const ::network::mojom::blink::CookieManagerParamsPtr& input) {
    return input->secure_origin_cookies_allowed_schemes;
  }

  static const decltype(::network::mojom::blink::CookieManagerParams::matching_scheme_cookies_allowed_schemes)& matching_scheme_cookies_allowed_schemes(
      const ::network::mojom::blink::CookieManagerParamsPtr& input) {
    return input->matching_scheme_cookies_allowed_schemes;
  }

  static const decltype(::network::mojom::blink::CookieManagerParams::third_party_cookies_allowed_schemes)& third_party_cookies_allowed_schemes(
      const ::network::mojom::blink::CookieManagerParamsPtr& input) {
    return input->third_party_cookies_allowed_schemes;
  }

  static decltype(::network::mojom::blink::CookieManagerParams::allow_file_scheme_cookies) allow_file_scheme_cookies(
      const ::network::mojom::blink::CookieManagerParamsPtr& input) {
    return input->allow_file_scheme_cookies;
  }

  static decltype(::network::mojom::blink::CookieManagerParams::cookie_access_delegate_type) cookie_access_delegate_type(
      const ::network::mojom::blink::CookieManagerParamsPtr& input) {
    return input->cookie_access_delegate_type;
  }

  static bool Read(::network::mojom::blink::CookieManagerParams::DataView input, ::network::mojom::blink::CookieManagerParamsPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::CookieSameSiteContextMetadata::DataView,
                                         ::network::mojom::blink::CookieSameSiteContextMetadataPtr> {
  static bool IsNull(const ::network::mojom::blink::CookieSameSiteContextMetadataPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::CookieSameSiteContextMetadataPtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::CookieSameSiteContextMetadata::cross_site_redirect_downgrade) cross_site_redirect_downgrade(
      const ::network::mojom::blink::CookieSameSiteContextMetadataPtr& input) {
    return input->cross_site_redirect_downgrade;
  }

  static decltype(::network::mojom::blink::CookieSameSiteContextMetadata::redirect_type_bug_1221316) redirect_type_bug_1221316(
      const ::network::mojom::blink::CookieSameSiteContextMetadataPtr& input) {
    return input->redirect_type_bug_1221316;
  }

  static bool Read(::network::mojom::blink::CookieSameSiteContextMetadata::DataView input, ::network::mojom::blink::CookieSameSiteContextMetadataPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::CookieSameSiteContext::DataView,
                                         ::network::mojom::blink::CookieSameSiteContextPtr> {
  static bool IsNull(const ::network::mojom::blink::CookieSameSiteContextPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::CookieSameSiteContextPtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::CookieSameSiteContext::context) context(
      const ::network::mojom::blink::CookieSameSiteContextPtr& input) {
    return input->context;
  }

  static decltype(::network::mojom::blink::CookieSameSiteContext::schemeful_context) schemeful_context(
      const ::network::mojom::blink::CookieSameSiteContextPtr& input) {
    return input->schemeful_context;
  }

  static const decltype(::network::mojom::blink::CookieSameSiteContext::metadata)& metadata(
      const ::network::mojom::blink::CookieSameSiteContextPtr& input) {
    return input->metadata;
  }

  static const decltype(::network::mojom::blink::CookieSameSiteContext::schemeful_metadata)& schemeful_metadata(
      const ::network::mojom::blink::CookieSameSiteContextPtr& input) {
    return input->schemeful_metadata;
  }

  static bool Read(::network::mojom::blink::CookieSameSiteContext::DataView input, ::network::mojom::blink::CookieSameSiteContextPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::CookieOptions::DataView,
                                         ::network::mojom::blink::CookieOptionsPtr> {
  static bool IsNull(const ::network::mojom::blink::CookieOptionsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::CookieOptionsPtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::CookieOptions::exclude_httponly) exclude_httponly(
      const ::network::mojom::blink::CookieOptionsPtr& input) {
    return input->exclude_httponly;
  }

  static const decltype(::network::mojom::blink::CookieOptions::same_site_cookie_context)& same_site_cookie_context(
      const ::network::mojom::blink::CookieOptionsPtr& input) {
    return input->same_site_cookie_context;
  }

  static decltype(::network::mojom::blink::CookieOptions::update_access_time) update_access_time(
      const ::network::mojom::blink::CookieOptionsPtr& input) {
    return input->update_access_time;
  }

  static decltype(::network::mojom::blink::CookieOptions::return_excluded_cookies) return_excluded_cookies(
      const ::network::mojom::blink::CookieOptionsPtr& input) {
    return input->return_excluded_cookies;
  }

  static bool Read(::network::mojom::blink::CookieOptions::DataView input, ::network::mojom::blink::CookieOptionsPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::CanonicalCookie::DataView,
                                         ::network::mojom::blink::CanonicalCookiePtr> {
  static bool IsNull(const ::network::mojom::blink::CanonicalCookiePtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::CanonicalCookiePtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::CanonicalCookie::name)& name(
      const ::network::mojom::blink::CanonicalCookiePtr& input) {
    return input->name;
  }

  static const decltype(::network::mojom::blink::CanonicalCookie::value)& value(
      const ::network::mojom::blink::CanonicalCookiePtr& input) {
    return input->value;
  }

  static const decltype(::network::mojom::blink::CanonicalCookie::domain)& domain(
      const ::network::mojom::blink::CanonicalCookiePtr& input) {
    return input->domain;
  }

  static const decltype(::network::mojom::blink::CanonicalCookie::path)& path(
      const ::network::mojom::blink::CanonicalCookiePtr& input) {
    return input->path;
  }

  static const decltype(::network::mojom::blink::CanonicalCookie::creation)& creation(
      const ::network::mojom::blink::CanonicalCookiePtr& input) {
    return input->creation;
  }

  static const decltype(::network::mojom::blink::CanonicalCookie::expiry)& expiry(
      const ::network::mojom::blink::CanonicalCookiePtr& input) {
    return input->expiry;
  }

  static const decltype(::network::mojom::blink::CanonicalCookie::last_access)& last_access(
      const ::network::mojom::blink::CanonicalCookiePtr& input) {
    return input->last_access;
  }

  static const decltype(::network::mojom::blink::CanonicalCookie::last_update)& last_update(
      const ::network::mojom::blink::CanonicalCookiePtr& input) {
    return input->last_update;
  }

  static decltype(::network::mojom::blink::CanonicalCookie::secure) secure(
      const ::network::mojom::blink::CanonicalCookiePtr& input) {
    return input->secure;
  }

  static decltype(::network::mojom::blink::CanonicalCookie::httponly) httponly(
      const ::network::mojom::blink::CanonicalCookiePtr& input) {
    return input->httponly;
  }

  static decltype(::network::mojom::blink::CanonicalCookie::site_restrictions) site_restrictions(
      const ::network::mojom::blink::CanonicalCookiePtr& input) {
    return input->site_restrictions;
  }

  static decltype(::network::mojom::blink::CanonicalCookie::priority) priority(
      const ::network::mojom::blink::CanonicalCookiePtr& input) {
    return input->priority;
  }

  static decltype(::network::mojom::blink::CanonicalCookie::source_scheme) source_scheme(
      const ::network::mojom::blink::CanonicalCookiePtr& input) {
    return input->source_scheme;
  }

  static const decltype(::network::mojom::blink::CanonicalCookie::partition_key)& partition_key(
      const ::network::mojom::blink::CanonicalCookiePtr& input) {
    return input->partition_key;
  }

  static decltype(::network::mojom::blink::CanonicalCookie::source_port) source_port(
      const ::network::mojom::blink::CanonicalCookiePtr& input) {
    return input->source_port;
  }

  static decltype(::network::mojom::blink::CanonicalCookie::source_type) source_type(
      const ::network::mojom::blink::CanonicalCookiePtr& input) {
    return input->source_type;
  }

  static bool Read(::network::mojom::blink::CanonicalCookie::DataView input, ::network::mojom::blink::CanonicalCookiePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::ExclusionReasons::DataView,
                                         ::network::mojom::blink::ExclusionReasonsPtr> {
  static bool IsNull(const ::network::mojom::blink::ExclusionReasonsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::ExclusionReasonsPtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::ExclusionReasons::exclusions_bitmask) exclusions_bitmask(
      const ::network::mojom::blink::ExclusionReasonsPtr& input) {
    return input->exclusions_bitmask;
  }

  static bool Read(::network::mojom::blink::ExclusionReasons::DataView input, ::network::mojom::blink::ExclusionReasonsPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::WarningReasons::DataView,
                                         ::network::mojom::blink::WarningReasonsPtr> {
  static bool IsNull(const ::network::mojom::blink::WarningReasonsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::WarningReasonsPtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::WarningReasons::warnings_bitmask) warnings_bitmask(
      const ::network::mojom::blink::WarningReasonsPtr& input) {
    return input->warnings_bitmask;
  }

  static bool Read(::network::mojom::blink::WarningReasons::DataView input, ::network::mojom::blink::WarningReasonsPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::CookieInclusionStatus::DataView,
                                         ::network::mojom::blink::CookieInclusionStatusPtr> {
  static bool IsNull(const ::network::mojom::blink::CookieInclusionStatusPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::CookieInclusionStatusPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::CookieInclusionStatus::exclusion_reasons)& exclusion_reasons(
      const ::network::mojom::blink::CookieInclusionStatusPtr& input) {
    return input->exclusion_reasons;
  }

  static const decltype(::network::mojom::blink::CookieInclusionStatus::warning_reasons)& warning_reasons(
      const ::network::mojom::blink::CookieInclusionStatusPtr& input) {
    return input->warning_reasons;
  }

  static decltype(::network::mojom::blink::CookieInclusionStatus::exemption_reason) exemption_reason(
      const ::network::mojom::blink::CookieInclusionStatusPtr& input) {
    return input->exemption_reason;
  }

  static bool Read(::network::mojom::blink::CookieInclusionStatus::DataView input, ::network::mojom::blink::CookieInclusionStatusPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::CookieAndLineWithAccessResult::DataView,
                                         ::network::mojom::blink::CookieAndLineWithAccessResultPtr> {
  static bool IsNull(const ::network::mojom::blink::CookieAndLineWithAccessResultPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::CookieAndLineWithAccessResultPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::CookieAndLineWithAccessResult::cookie)& cookie(
      const ::network::mojom::blink::CookieAndLineWithAccessResultPtr& input) {
    return input->cookie;
  }

  static const decltype(::network::mojom::blink::CookieAndLineWithAccessResult::cookie_string)& cookie_string(
      const ::network::mojom::blink::CookieAndLineWithAccessResultPtr& input) {
    return input->cookie_string;
  }

  static const decltype(::network::mojom::blink::CookieAndLineWithAccessResult::access_result)& access_result(
      const ::network::mojom::blink::CookieAndLineWithAccessResultPtr& input) {
    return input->access_result;
  }

  static bool Read(::network::mojom::blink::CookieAndLineWithAccessResult::DataView input, ::network::mojom::blink::CookieAndLineWithAccessResultPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::CookieOrLineWithAccessResult::DataView,
                                         ::network::mojom::blink::CookieOrLineWithAccessResultPtr> {
  static bool IsNull(const ::network::mojom::blink::CookieOrLineWithAccessResultPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::CookieOrLineWithAccessResultPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::CookieOrLineWithAccessResult::cookie_or_line)& cookie_or_line(
      const ::network::mojom::blink::CookieOrLineWithAccessResultPtr& input) {
    return input->cookie_or_line;
  }

  static const decltype(::network::mojom::blink::CookieOrLineWithAccessResult::access_result)& access_result(
      const ::network::mojom::blink::CookieOrLineWithAccessResultPtr& input) {
    return input->access_result;
  }

  static bool Read(::network::mojom::blink::CookieOrLineWithAccessResult::DataView input, ::network::mojom::blink::CookieOrLineWithAccessResultPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::CookieAccessResult::DataView,
                                         ::network::mojom::blink::CookieAccessResultPtr> {
  static bool IsNull(const ::network::mojom::blink::CookieAccessResultPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::CookieAccessResultPtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::CookieAccessResult::effective_same_site) effective_same_site(
      const ::network::mojom::blink::CookieAccessResultPtr& input) {
    return input->effective_same_site;
  }

  static decltype(::network::mojom::blink::CookieAccessResult::access_semantics) access_semantics(
      const ::network::mojom::blink::CookieAccessResultPtr& input) {
    return input->access_semantics;
  }

  static decltype(::network::mojom::blink::CookieAccessResult::scope_semantics) scope_semantics(
      const ::network::mojom::blink::CookieAccessResultPtr& input) {
    return input->scope_semantics;
  }

  static const decltype(::network::mojom::blink::CookieAccessResult::status)& status(
      const ::network::mojom::blink::CookieAccessResultPtr& input) {
    return input->status;
  }

  static decltype(::network::mojom::blink::CookieAccessResult::is_allowed_to_access_secure_cookies) is_allowed_to_access_secure_cookies(
      const ::network::mojom::blink::CookieAccessResultPtr& input) {
    return input->is_allowed_to_access_secure_cookies;
  }

  static bool Read(::network::mojom::blink::CookieAccessResult::DataView input, ::network::mojom::blink::CookieAccessResultPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::CookieWithAccessResult::DataView,
                                         ::network::mojom::blink::CookieWithAccessResultPtr> {
  static bool IsNull(const ::network::mojom::blink::CookieWithAccessResultPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::CookieWithAccessResultPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::CookieWithAccessResult::cookie)& cookie(
      const ::network::mojom::blink::CookieWithAccessResultPtr& input) {
    return input->cookie;
  }

  static const decltype(::network::mojom::blink::CookieWithAccessResult::access_result)& access_result(
      const ::network::mojom::blink::CookieWithAccessResultPtr& input) {
    return input->access_result;
  }

  static bool Read(::network::mojom::blink::CookieWithAccessResult::DataView input, ::network::mojom::blink::CookieWithAccessResultPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::CookieChangeInfo::DataView,
                                         ::network::mojom::blink::CookieChangeInfoPtr> {
  static bool IsNull(const ::network::mojom::blink::CookieChangeInfoPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::CookieChangeInfoPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::CookieChangeInfo::cookie)& cookie(
      const ::network::mojom::blink::CookieChangeInfoPtr& input) {
    return input->cookie;
  }

  static const decltype(::network::mojom::blink::CookieChangeInfo::access_result)& access_result(
      const ::network::mojom::blink::CookieChangeInfoPtr& input) {
    return input->access_result;
  }

  static decltype(::network::mojom::blink::CookieChangeInfo::cause) cause(
      const ::network::mojom::blink::CookieChangeInfoPtr& input) {
    return input->cause;
  }

  static bool Read(::network::mojom::blink::CookieChangeInfo::DataView input, ::network::mojom::blink::CookieChangeInfoPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::CookieDeletionFilter::DataView,
                                         ::network::mojom::blink::CookieDeletionFilterPtr> {
  static bool IsNull(const ::network::mojom::blink::CookieDeletionFilterPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::CookieDeletionFilterPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::CookieDeletionFilter::created_after_time)& created_after_time(
      const ::network::mojom::blink::CookieDeletionFilterPtr& input) {
    return input->created_after_time;
  }

  static const decltype(::network::mojom::blink::CookieDeletionFilter::created_before_time)& created_before_time(
      const ::network::mojom::blink::CookieDeletionFilterPtr& input) {
    return input->created_before_time;
  }

  static const decltype(::network::mojom::blink::CookieDeletionFilter::excluding_domains)& excluding_domains(
      const ::network::mojom::blink::CookieDeletionFilterPtr& input) {
    return input->excluding_domains;
  }

  static const decltype(::network::mojom::blink::CookieDeletionFilter::including_domains)& including_domains(
      const ::network::mojom::blink::CookieDeletionFilterPtr& input) {
    return input->including_domains;
  }

  static const decltype(::network::mojom::blink::CookieDeletionFilter::cookie_name)& cookie_name(
      const ::network::mojom::blink::CookieDeletionFilterPtr& input) {
    return input->cookie_name;
  }

  static const decltype(::network::mojom::blink::CookieDeletionFilter::host_name)& host_name(
      const ::network::mojom::blink::CookieDeletionFilterPtr& input) {
    return input->host_name;
  }

  static const decltype(::network::mojom::blink::CookieDeletionFilter::url)& url(
      const ::network::mojom::blink::CookieDeletionFilterPtr& input) {
    return input->url;
  }

  static decltype(::network::mojom::blink::CookieDeletionFilter::session_control) session_control(
      const ::network::mojom::blink::CookieDeletionFilterPtr& input) {
    return input->session_control;
  }

  static const decltype(::network::mojom::blink::CookieDeletionFilter::cookie_partition_key_collection)& cookie_partition_key_collection(
      const ::network::mojom::blink::CookieDeletionFilterPtr& input) {
    return input->cookie_partition_key_collection;
  }

  static decltype(::network::mojom::blink::CookieDeletionFilter::partitioned_state_only) partitioned_state_only(
      const ::network::mojom::blink::CookieDeletionFilterPtr& input) {
    return input->partitioned_state_only;
  }

  static bool Read(::network::mojom::blink::CookieDeletionFilter::DataView input, ::network::mojom::blink::CookieDeletionFilterPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT UnionTraits<::network::mojom::blink::CookieOrLine::DataView,
                                        ::network::mojom::blink::CookieOrLinePtr> {
  static bool IsNull(const ::network::mojom::blink::CookieOrLinePtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::CookieOrLinePtr* output) { output->reset(); }

  static ::network::mojom::blink::CookieOrLine::Tag GetTag(const ::network::mojom::blink::CookieOrLinePtr& input) {
    return input->which();
  }

  static const ::net::CanonicalCookie& cookie(const ::network::mojom::blink::CookieOrLinePtr& input) {
    return input->get_cookie();
  }

  static const ::blink::String& cookie_string(const ::network::mojom::blink::CookieOrLinePtr& input) {
    return input->get_cookie_string();
  }

  static bool Read(::network::mojom::blink::CookieOrLine::DataView input, ::network::mojom::blink::CookieOrLinePtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_MANAGER_MOJOM_BLINK_H_