// services/network/public/mojom/integrity_policy.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_INTEGRITY_POLICY_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_INTEGRITY_POLICY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/integrity_policy.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/integrity_policy.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/integrity_policy.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "services/network/public/cpp/integrity_policy_mojom_traits.h"




namespace network::mojom {








class  IntegrityPolicy {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IntegrityPolicy, T>::value>;
  using DataView = IntegrityPolicyDataView;
  using Data_ = internal::IntegrityPolicy_Data;
  using Destination = IntegrityPolicy_Destination;
  using Source = IntegrityPolicy_Source;

  template <typename... Args>
  static IntegrityPolicyPtr New(Args&&... args) {
    return IntegrityPolicyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IntegrityPolicyPtr From(const U& u) {
    return mojo::TypeConverter<IntegrityPolicyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IntegrityPolicy>::Convert(*this);
  }


  IntegrityPolicy();

  IntegrityPolicy(
      std::vector<IntegrityPolicy::Destination> blocked_destinations,
      std::vector<IntegrityPolicy::Source> sources,
      std::vector<std::string> endpoints,
      std::vector<std::string> parsing_errors);


  ~IntegrityPolicy();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IntegrityPolicyPtr>
  IntegrityPolicyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IntegrityPolicy::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IntegrityPolicy::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IntegrityPolicy::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IntegrityPolicy::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IntegrityPolicy::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IntegrityPolicy::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IntegrityPolicy_UnserializedMessageContext<
            UserType, IntegrityPolicy::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IntegrityPolicy::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IntegrityPolicy::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IntegrityPolicy_UnserializedMessageContext<
            UserType, IntegrityPolicy::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IntegrityPolicy::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<IntegrityPolicy::Destination> blocked_destinations;
  
  std::vector<IntegrityPolicy::Source> sources;
  
  std::vector<std::string> endpoints;
  
  std::vector<std::string> parsing_errors;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IntegrityPolicy::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IntegrityPolicy::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IntegrityPolicy::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IntegrityPolicy::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
IntegrityPolicyPtr IntegrityPolicy::Clone() const {
  return New(
      mojo::Clone(blocked_destinations),
      mojo::Clone(sources),
      mojo::Clone(endpoints),
      mojo::Clone(parsing_errors)
  );
}

template <typename T, IntegrityPolicy::EnableIfSame<T>*>
bool IntegrityPolicy::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->blocked_destinations, other_struct.blocked_destinations))
    return false;
  if (!mojo::Equals(this->sources, other_struct.sources))
    return false;
  if (!mojo::Equals(this->endpoints, other_struct.endpoints))
    return false;
  if (!mojo::Equals(this->parsing_errors, other_struct.parsing_errors))
    return false;
  return true;
}

template <typename T, IntegrityPolicy::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.blocked_destinations < rhs.blocked_destinations)
    return true;
  if (rhs.blocked_destinations < lhs.blocked_destinations)
    return false;
  if (lhs.sources < rhs.sources)
    return true;
  if (rhs.sources < lhs.sources)
    return false;
  if (lhs.endpoints < rhs.endpoints)
    return true;
  if (rhs.endpoints < lhs.endpoints)
    return false;
  if (lhs.parsing_errors < rhs.parsing_errors)
    return true;
  if (rhs.parsing_errors < lhs.parsing_errors)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::IntegrityPolicy::DataView,
                                         ::network::mojom::IntegrityPolicyPtr> {
  static bool IsNull(const ::network::mojom::IntegrityPolicyPtr& input) { return !input; }
  static void SetToNull(::network::mojom::IntegrityPolicyPtr* output) { output->reset(); }

  static const decltype(::network::mojom::IntegrityPolicy::blocked_destinations)& blocked_destinations(
      const ::network::mojom::IntegrityPolicyPtr& input) {
    return input->blocked_destinations;
  }

  static const decltype(::network::mojom::IntegrityPolicy::sources)& sources(
      const ::network::mojom::IntegrityPolicyPtr& input) {
    return input->sources;
  }

  static const decltype(::network::mojom::IntegrityPolicy::endpoints)& endpoints(
      const ::network::mojom::IntegrityPolicyPtr& input) {
    return input->endpoints;
  }

  static const decltype(::network::mojom::IntegrityPolicy::parsing_errors)& parsing_errors(
      const ::network::mojom::IntegrityPolicyPtr& input) {
    return input->parsing_errors;
  }

  static bool Read(::network::mojom::IntegrityPolicy::DataView input, ::network::mojom::IntegrityPolicyPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_INTEGRITY_POLICY_MOJOM_H_