// services/network/public/mojom/load_timing_info.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_LOAD_TIMING_INFO_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_LOAD_TIMING_INFO_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/load_timing_info.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/load_timing_info.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/load_timing_info.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {









class BLINK_PLATFORM_EXPORT LoadTimingInfoConnectTiming {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LoadTimingInfoConnectTiming, T>::value>;
  using DataView = LoadTimingInfoConnectTimingDataView;
  using Data_ = internal::LoadTimingInfoConnectTiming_Data;

  template <typename... Args>
  static LoadTimingInfoConnectTimingPtr New(Args&&... args) {
    return LoadTimingInfoConnectTimingPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LoadTimingInfoConnectTimingPtr From(const U& u) {
    return mojo::TypeConverter<LoadTimingInfoConnectTimingPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LoadTimingInfoConnectTiming>::Convert(*this);
  }


  LoadTimingInfoConnectTiming();

  LoadTimingInfoConnectTiming(
      ::base::TimeTicks domain_lookup_start,
      ::base::TimeTicks domain_lookup_end,
      ::base::TimeTicks connect_start,
      ::base::TimeTicks connect_end,
      ::base::TimeTicks ssl_start,
      ::base::TimeTicks ssl_end);


  ~LoadTimingInfoConnectTiming();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LoadTimingInfoConnectTimingPtr>
  LoadTimingInfoConnectTimingPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LoadTimingInfoConnectTiming::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LoadTimingInfoConnectTiming::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LoadTimingInfoConnectTiming::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LoadTimingInfoConnectTiming::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LoadTimingInfoConnectTiming::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LoadTimingInfoConnectTiming::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LoadTimingInfoConnectTiming_UnserializedMessageContext<
            UserType, LoadTimingInfoConnectTiming::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LoadTimingInfoConnectTiming::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LoadTimingInfoConnectTiming::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LoadTimingInfoConnectTiming_UnserializedMessageContext<
            UserType, LoadTimingInfoConnectTiming::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LoadTimingInfoConnectTiming::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::TimeTicks domain_lookup_start;
  
  ::base::TimeTicks domain_lookup_end;
  
  ::base::TimeTicks connect_start;
  
  ::base::TimeTicks connect_end;
  
  ::base::TimeTicks ssl_start;
  
  ::base::TimeTicks ssl_end;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LoadTimingInfoConnectTiming::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LoadTimingInfoConnectTiming::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LoadTimingInfoConnectTiming::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LoadTimingInfoConnectTiming::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT LoadTimingInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LoadTimingInfo, T>::value>;
  using DataView = LoadTimingInfoDataView;
  using Data_ = internal::LoadTimingInfo_Data;

  template <typename... Args>
  static LoadTimingInfoPtr New(Args&&... args) {
    return LoadTimingInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LoadTimingInfoPtr From(const U& u) {
    return mojo::TypeConverter<LoadTimingInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LoadTimingInfo>::Convert(*this);
  }


  LoadTimingInfo();

  LoadTimingInfo(
      bool socket_reused,
      uint32_t socket_log_id,
      ::base::Time request_start_time,
      ::base::TimeTicks request_start,
      ::base::TimeTicks proxy_resolve_start,
      ::base::TimeTicks proxy_resolve_end,
      LoadTimingInfoConnectTimingPtr connect_timing,
      ::base::TimeTicks send_start,
      ::base::TimeTicks send_end,
      ::base::TimeTicks receive_headers_start,
      ::base::TimeTicks receive_headers_end,
      ::base::TimeTicks receive_non_informational_headers_start,
      ::base::TimeTicks first_early_hints_time,
      ::base::TimeTicks push_start,
      ::base::TimeTicks push_end,
      ::base::TimeTicks service_worker_start_time,
      ::base::TimeTicks service_worker_ready_time,
      ::base::TimeTicks service_worker_fetch_start,
      ::base::TimeTicks service_worker_respond_with_settled,
      ::base::TimeTicks service_worker_router_evaluation_start,
      ::base::TimeTicks service_worker_cache_lookup_start);

LoadTimingInfo(const LoadTimingInfo&) = delete;
LoadTimingInfo& operator=(const LoadTimingInfo&) = delete;

  ~LoadTimingInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LoadTimingInfoPtr>
  LoadTimingInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LoadTimingInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LoadTimingInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LoadTimingInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LoadTimingInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LoadTimingInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LoadTimingInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LoadTimingInfo_UnserializedMessageContext<
            UserType, LoadTimingInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LoadTimingInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LoadTimingInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LoadTimingInfo_UnserializedMessageContext<
            UserType, LoadTimingInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LoadTimingInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool socket_reused;
  
  uint32_t socket_log_id;
  
  ::base::Time request_start_time;
  
  ::base::TimeTicks request_start;
  
  ::base::TimeTicks proxy_resolve_start;
  
  ::base::TimeTicks proxy_resolve_end;
  
  LoadTimingInfoConnectTimingPtr connect_timing;
  
  ::base::TimeTicks send_start;
  
  ::base::TimeTicks send_end;
  
  ::base::TimeTicks receive_headers_start;
  
  ::base::TimeTicks receive_headers_end;
  
  ::base::TimeTicks receive_non_informational_headers_start;
  
  ::base::TimeTicks first_early_hints_time;
  
  ::base::TimeTicks push_start;
  
  ::base::TimeTicks push_end;
  
  ::base::TimeTicks service_worker_start_time;
  
  ::base::TimeTicks service_worker_ready_time;
  
  ::base::TimeTicks service_worker_fetch_start;
  
  ::base::TimeTicks service_worker_respond_with_settled;
  
  ::base::TimeTicks service_worker_router_evaluation_start;
  
  ::base::TimeTicks service_worker_cache_lookup_start;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LoadTimingInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LoadTimingInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LoadTimingInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LoadTimingInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
LoadTimingInfoConnectTimingPtr LoadTimingInfoConnectTiming::Clone() const {
  return New(
      mojo::Clone(domain_lookup_start),
      mojo::Clone(domain_lookup_end),
      mojo::Clone(connect_start),
      mojo::Clone(connect_end),
      mojo::Clone(ssl_start),
      mojo::Clone(ssl_end)
  );
}

template <typename T, LoadTimingInfoConnectTiming::EnableIfSame<T>*>
bool LoadTimingInfoConnectTiming::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->domain_lookup_start, other_struct.domain_lookup_start))
    return false;
  if (!mojo::Equals(this->domain_lookup_end, other_struct.domain_lookup_end))
    return false;
  if (!mojo::Equals(this->connect_start, other_struct.connect_start))
    return false;
  if (!mojo::Equals(this->connect_end, other_struct.connect_end))
    return false;
  if (!mojo::Equals(this->ssl_start, other_struct.ssl_start))
    return false;
  if (!mojo::Equals(this->ssl_end, other_struct.ssl_end))
    return false;
  return true;
}

template <typename T, LoadTimingInfoConnectTiming::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.domain_lookup_start < rhs.domain_lookup_start)
    return true;
  if (rhs.domain_lookup_start < lhs.domain_lookup_start)
    return false;
  if (lhs.domain_lookup_end < rhs.domain_lookup_end)
    return true;
  if (rhs.domain_lookup_end < lhs.domain_lookup_end)
    return false;
  if (lhs.connect_start < rhs.connect_start)
    return true;
  if (rhs.connect_start < lhs.connect_start)
    return false;
  if (lhs.connect_end < rhs.connect_end)
    return true;
  if (rhs.connect_end < lhs.connect_end)
    return false;
  if (lhs.ssl_start < rhs.ssl_start)
    return true;
  if (rhs.ssl_start < lhs.ssl_start)
    return false;
  if (lhs.ssl_end < rhs.ssl_end)
    return true;
  if (rhs.ssl_end < lhs.ssl_end)
    return false;
  return false;
}
template <typename StructPtrType>
LoadTimingInfoPtr LoadTimingInfo::Clone() const {
  return New(
      mojo::Clone(socket_reused),
      mojo::Clone(socket_log_id),
      mojo::Clone(request_start_time),
      mojo::Clone(request_start),
      mojo::Clone(proxy_resolve_start),
      mojo::Clone(proxy_resolve_end),
      mojo::Clone(connect_timing),
      mojo::Clone(send_start),
      mojo::Clone(send_end),
      mojo::Clone(receive_headers_start),
      mojo::Clone(receive_headers_end),
      mojo::Clone(receive_non_informational_headers_start),
      mojo::Clone(first_early_hints_time),
      mojo::Clone(push_start),
      mojo::Clone(push_end),
      mojo::Clone(service_worker_start_time),
      mojo::Clone(service_worker_ready_time),
      mojo::Clone(service_worker_fetch_start),
      mojo::Clone(service_worker_respond_with_settled),
      mojo::Clone(service_worker_router_evaluation_start),
      mojo::Clone(service_worker_cache_lookup_start)
  );
}

template <typename T, LoadTimingInfo::EnableIfSame<T>*>
bool LoadTimingInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->socket_reused, other_struct.socket_reused))
    return false;
  if (!mojo::Equals(this->socket_log_id, other_struct.socket_log_id))
    return false;
  if (!mojo::Equals(this->request_start_time, other_struct.request_start_time))
    return false;
  if (!mojo::Equals(this->request_start, other_struct.request_start))
    return false;
  if (!mojo::Equals(this->proxy_resolve_start, other_struct.proxy_resolve_start))
    return false;
  if (!mojo::Equals(this->proxy_resolve_end, other_struct.proxy_resolve_end))
    return false;
  if (!mojo::Equals(this->connect_timing, other_struct.connect_timing))
    return false;
  if (!mojo::Equals(this->send_start, other_struct.send_start))
    return false;
  if (!mojo::Equals(this->send_end, other_struct.send_end))
    return false;
  if (!mojo::Equals(this->receive_headers_start, other_struct.receive_headers_start))
    return false;
  if (!mojo::Equals(this->receive_headers_end, other_struct.receive_headers_end))
    return false;
  if (!mojo::Equals(this->receive_non_informational_headers_start, other_struct.receive_non_informational_headers_start))
    return false;
  if (!mojo::Equals(this->first_early_hints_time, other_struct.first_early_hints_time))
    return false;
  if (!mojo::Equals(this->push_start, other_struct.push_start))
    return false;
  if (!mojo::Equals(this->push_end, other_struct.push_end))
    return false;
  if (!mojo::Equals(this->service_worker_start_time, other_struct.service_worker_start_time))
    return false;
  if (!mojo::Equals(this->service_worker_ready_time, other_struct.service_worker_ready_time))
    return false;
  if (!mojo::Equals(this->service_worker_fetch_start, other_struct.service_worker_fetch_start))
    return false;
  if (!mojo::Equals(this->service_worker_respond_with_settled, other_struct.service_worker_respond_with_settled))
    return false;
  if (!mojo::Equals(this->service_worker_router_evaluation_start, other_struct.service_worker_router_evaluation_start))
    return false;
  if (!mojo::Equals(this->service_worker_cache_lookup_start, other_struct.service_worker_cache_lookup_start))
    return false;
  return true;
}

template <typename T, LoadTimingInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.socket_reused < rhs.socket_reused)
    return true;
  if (rhs.socket_reused < lhs.socket_reused)
    return false;
  if (lhs.socket_log_id < rhs.socket_log_id)
    return true;
  if (rhs.socket_log_id < lhs.socket_log_id)
    return false;
  if (lhs.request_start_time < rhs.request_start_time)
    return true;
  if (rhs.request_start_time < lhs.request_start_time)
    return false;
  if (lhs.request_start < rhs.request_start)
    return true;
  if (rhs.request_start < lhs.request_start)
    return false;
  if (lhs.proxy_resolve_start < rhs.proxy_resolve_start)
    return true;
  if (rhs.proxy_resolve_start < lhs.proxy_resolve_start)
    return false;
  if (lhs.proxy_resolve_end < rhs.proxy_resolve_end)
    return true;
  if (rhs.proxy_resolve_end < lhs.proxy_resolve_end)
    return false;
  if (lhs.connect_timing < rhs.connect_timing)
    return true;
  if (rhs.connect_timing < lhs.connect_timing)
    return false;
  if (lhs.send_start < rhs.send_start)
    return true;
  if (rhs.send_start < lhs.send_start)
    return false;
  if (lhs.send_end < rhs.send_end)
    return true;
  if (rhs.send_end < lhs.send_end)
    return false;
  if (lhs.receive_headers_start < rhs.receive_headers_start)
    return true;
  if (rhs.receive_headers_start < lhs.receive_headers_start)
    return false;
  if (lhs.receive_headers_end < rhs.receive_headers_end)
    return true;
  if (rhs.receive_headers_end < lhs.receive_headers_end)
    return false;
  if (lhs.receive_non_informational_headers_start < rhs.receive_non_informational_headers_start)
    return true;
  if (rhs.receive_non_informational_headers_start < lhs.receive_non_informational_headers_start)
    return false;
  if (lhs.first_early_hints_time < rhs.first_early_hints_time)
    return true;
  if (rhs.first_early_hints_time < lhs.first_early_hints_time)
    return false;
  if (lhs.push_start < rhs.push_start)
    return true;
  if (rhs.push_start < lhs.push_start)
    return false;
  if (lhs.push_end < rhs.push_end)
    return true;
  if (rhs.push_end < lhs.push_end)
    return false;
  if (lhs.service_worker_start_time < rhs.service_worker_start_time)
    return true;
  if (rhs.service_worker_start_time < lhs.service_worker_start_time)
    return false;
  if (lhs.service_worker_ready_time < rhs.service_worker_ready_time)
    return true;
  if (rhs.service_worker_ready_time < lhs.service_worker_ready_time)
    return false;
  if (lhs.service_worker_fetch_start < rhs.service_worker_fetch_start)
    return true;
  if (rhs.service_worker_fetch_start < lhs.service_worker_fetch_start)
    return false;
  if (lhs.service_worker_respond_with_settled < rhs.service_worker_respond_with_settled)
    return true;
  if (rhs.service_worker_respond_with_settled < lhs.service_worker_respond_with_settled)
    return false;
  if (lhs.service_worker_router_evaluation_start < rhs.service_worker_router_evaluation_start)
    return true;
  if (rhs.service_worker_router_evaluation_start < lhs.service_worker_router_evaluation_start)
    return false;
  if (lhs.service_worker_cache_lookup_start < rhs.service_worker_cache_lookup_start)
    return true;
  if (rhs.service_worker_cache_lookup_start < lhs.service_worker_cache_lookup_start)
    return false;
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::LoadTimingInfoConnectTiming::DataView,
                                         ::network::mojom::blink::LoadTimingInfoConnectTimingPtr> {
  static bool IsNull(const ::network::mojom::blink::LoadTimingInfoConnectTimingPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::LoadTimingInfoConnectTimingPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::LoadTimingInfoConnectTiming::domain_lookup_start)& domain_lookup_start(
      const ::network::mojom::blink::LoadTimingInfoConnectTimingPtr& input) {
    return input->domain_lookup_start;
  }

  static const decltype(::network::mojom::blink::LoadTimingInfoConnectTiming::domain_lookup_end)& domain_lookup_end(
      const ::network::mojom::blink::LoadTimingInfoConnectTimingPtr& input) {
    return input->domain_lookup_end;
  }

  static const decltype(::network::mojom::blink::LoadTimingInfoConnectTiming::connect_start)& connect_start(
      const ::network::mojom::blink::LoadTimingInfoConnectTimingPtr& input) {
    return input->connect_start;
  }

  static const decltype(::network::mojom::blink::LoadTimingInfoConnectTiming::connect_end)& connect_end(
      const ::network::mojom::blink::LoadTimingInfoConnectTimingPtr& input) {
    return input->connect_end;
  }

  static const decltype(::network::mojom::blink::LoadTimingInfoConnectTiming::ssl_start)& ssl_start(
      const ::network::mojom::blink::LoadTimingInfoConnectTimingPtr& input) {
    return input->ssl_start;
  }

  static const decltype(::network::mojom::blink::LoadTimingInfoConnectTiming::ssl_end)& ssl_end(
      const ::network::mojom::blink::LoadTimingInfoConnectTimingPtr& input) {
    return input->ssl_end;
  }

  static bool Read(::network::mojom::blink::LoadTimingInfoConnectTiming::DataView input, ::network::mojom::blink::LoadTimingInfoConnectTimingPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::LoadTimingInfo::DataView,
                                         ::network::mojom::blink::LoadTimingInfoPtr> {
  static bool IsNull(const ::network::mojom::blink::LoadTimingInfoPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::LoadTimingInfoPtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::LoadTimingInfo::socket_reused) socket_reused(
      const ::network::mojom::blink::LoadTimingInfoPtr& input) {
    return input->socket_reused;
  }

  static decltype(::network::mojom::blink::LoadTimingInfo::socket_log_id) socket_log_id(
      const ::network::mojom::blink::LoadTimingInfoPtr& input) {
    return input->socket_log_id;
  }

  static const decltype(::network::mojom::blink::LoadTimingInfo::request_start_time)& request_start_time(
      const ::network::mojom::blink::LoadTimingInfoPtr& input) {
    return input->request_start_time;
  }

  static const decltype(::network::mojom::blink::LoadTimingInfo::request_start)& request_start(
      const ::network::mojom::blink::LoadTimingInfoPtr& input) {
    return input->request_start;
  }

  static const decltype(::network::mojom::blink::LoadTimingInfo::proxy_resolve_start)& proxy_resolve_start(
      const ::network::mojom::blink::LoadTimingInfoPtr& input) {
    return input->proxy_resolve_start;
  }

  static const decltype(::network::mojom::blink::LoadTimingInfo::proxy_resolve_end)& proxy_resolve_end(
      const ::network::mojom::blink::LoadTimingInfoPtr& input) {
    return input->proxy_resolve_end;
  }

  static const decltype(::network::mojom::blink::LoadTimingInfo::connect_timing)& connect_timing(
      const ::network::mojom::blink::LoadTimingInfoPtr& input) {
    return input->connect_timing;
  }

  static const decltype(::network::mojom::blink::LoadTimingInfo::send_start)& send_start(
      const ::network::mojom::blink::LoadTimingInfoPtr& input) {
    return input->send_start;
  }

  static const decltype(::network::mojom::blink::LoadTimingInfo::send_end)& send_end(
      const ::network::mojom::blink::LoadTimingInfoPtr& input) {
    return input->send_end;
  }

  static const decltype(::network::mojom::blink::LoadTimingInfo::receive_headers_start)& receive_headers_start(
      const ::network::mojom::blink::LoadTimingInfoPtr& input) {
    return input->receive_headers_start;
  }

  static const decltype(::network::mojom::blink::LoadTimingInfo::receive_headers_end)& receive_headers_end(
      const ::network::mojom::blink::LoadTimingInfoPtr& input) {
    return input->receive_headers_end;
  }

  static const decltype(::network::mojom::blink::LoadTimingInfo::receive_non_informational_headers_start)& receive_non_informational_headers_start(
      const ::network::mojom::blink::LoadTimingInfoPtr& input) {
    return input->receive_non_informational_headers_start;
  }

  static const decltype(::network::mojom::blink::LoadTimingInfo::first_early_hints_time)& first_early_hints_time(
      const ::network::mojom::blink::LoadTimingInfoPtr& input) {
    return input->first_early_hints_time;
  }

  static const decltype(::network::mojom::blink::LoadTimingInfo::push_start)& push_start(
      const ::network::mojom::blink::LoadTimingInfoPtr& input) {
    return input->push_start;
  }

  static const decltype(::network::mojom::blink::LoadTimingInfo::push_end)& push_end(
      const ::network::mojom::blink::LoadTimingInfoPtr& input) {
    return input->push_end;
  }

  static const decltype(::network::mojom::blink::LoadTimingInfo::service_worker_start_time)& service_worker_start_time(
      const ::network::mojom::blink::LoadTimingInfoPtr& input) {
    return input->service_worker_start_time;
  }

  static const decltype(::network::mojom::blink::LoadTimingInfo::service_worker_ready_time)& service_worker_ready_time(
      const ::network::mojom::blink::LoadTimingInfoPtr& input) {
    return input->service_worker_ready_time;
  }

  static const decltype(::network::mojom::blink::LoadTimingInfo::service_worker_fetch_start)& service_worker_fetch_start(
      const ::network::mojom::blink::LoadTimingInfoPtr& input) {
    return input->service_worker_fetch_start;
  }

  static const decltype(::network::mojom::blink::LoadTimingInfo::service_worker_respond_with_settled)& service_worker_respond_with_settled(
      const ::network::mojom::blink::LoadTimingInfoPtr& input) {
    return input->service_worker_respond_with_settled;
  }

  static const decltype(::network::mojom::blink::LoadTimingInfo::service_worker_router_evaluation_start)& service_worker_router_evaluation_start(
      const ::network::mojom::blink::LoadTimingInfoPtr& input) {
    return input->service_worker_router_evaluation_start;
  }

  static const decltype(::network::mojom::blink::LoadTimingInfo::service_worker_cache_lookup_start)& service_worker_cache_lookup_start(
      const ::network::mojom::blink::LoadTimingInfoPtr& input) {
    return input->service_worker_cache_lookup_start;
  }

  static bool Read(::network::mojom::blink::LoadTimingInfo::DataView input, ::network::mojom::blink::LoadTimingInfoPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_LOAD_TIMING_INFO_MOJOM_BLINK_H_