// services/network/public/mojom/network_context.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_CONTEXT_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_CONTEXT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/network_context.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/network_context.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/network_context.mojom-forward.h"  // IWYU pragma: export
#include "components/content_settings/core/common/content_settings.mojom.h"
#include "components/ip_protection/mojom/core.mojom-forward.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "mojo/public/mojom/base/values.mojom.h"
#include "sandbox/policy/mojom/context.mojom-forward.h"
#include "services/network/public/mojom/address_list.mojom.h"
#include "services/network/public/mojom/cert_verifier_service.mojom-forward.h"
#include "services/network/public/mojom/clear_data_filter.mojom-forward.h"
#include "services/network/public/mojom/client_security_state.mojom.h"
#include "services/network/public/mojom/cookie_access_observer.mojom-forward.h"
#include "services/network/public/mojom/cookie_encryption_provider.mojom-forward.h"
#include "services/network/public/mojom/cookie_manager.mojom.h"
#include "services/network/public/mojom/cookie_setting_overrides.mojom.h"
#include "services/network/public/mojom/cors_origin_pattern.mojom.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-forward.h"
#include "services/network/public/mojom/default_credentials.mojom.h"
#include "services/network/public/mojom/device_bound_sessions.mojom-forward.h"
#include "services/network/public/mojom/devtools_observer.mojom-forward.h"
#include "services/network/public/mojom/document_isolation_policy.mojom-forward.h"
#include "services/network/public/mojom/fetch_api.mojom-forward.h"
#include "services/network/public/mojom/first_party_sets_access_delegate.mojom.h"
#include "services/network/public/mojom/hash_value.mojom.h"
#include "services/network/public/mojom/host_resolver.mojom.h"
#include "services/network/public/mojom/http_cache_backend_file_operations.mojom-forward.h"
#include "services/network/public/mojom/http_request_headers.mojom.h"
#include "services/network/public/mojom/ip_address.mojom.h"
#include "services/network/public/mojom/ip_address_space.mojom-forward.h"
#include "services/network/public/mojom/ip_endpoint.mojom.h"
#include "services/network/public/mojom/isolation_info.mojom.h"
#include "services/network/public/mojom/mdns_responder.mojom-forward.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom.h"
#include "services/network/public/mojom/net_log.mojom-forward.h"
#include "services/network/public/mojom/network_anonymization_key.mojom.h"
#include "services/network/public/mojom/network_context_client.mojom-forward.h"
#include "services/network/public/mojom/network_isolation_key.mojom.h"
#include "services/network/public/mojom/network_param.mojom.h"
#include "services/network/public/mojom/oblivious_http_request.mojom-forward.h"
#include "services/network/public/mojom/parsed_headers.mojom-forward.h"
#include "services/network/public/mojom/proxy_config.mojom.h"
#include "services/network/public/mojom/proxy_config_with_annotation.mojom.h"
#include "services/network/public/mojom/proxy_lookup_client.mojom-forward.h"
#include "services/network/public/mojom/proxy_resolving_socket.mojom-forward.h"
#include "services/network/public/mojom/connection_change_observer_client.mojom.h"
#include "services/network/public/mojom/reporting_service.mojom-forward.h"
#include "services/network/public/mojom/restricted_cookie_manager.mojom-forward.h"
#include "services/network/public/mojom/restricted_udp_socket.mojom-forward.h"
#include "services/network/public/mojom/shared_dictionary_access_observer.mojom-forward.h"
#include "services/network/public/mojom/shared_dictionary_isolation_key.mojom.h"
#include "services/network/public/mojom/shared_dictionary_usage_info.mojom.h"
#include "services/network/public/mojom/site_for_cookies.mojom.h"
#include "services/network/public/mojom/socket_broker.mojom-forward.h"
#include "services/network/public/mojom/ssl_config.mojom.h"
#include "services/network/public/mojom/storage_access_api.mojom.h"
#include "services/network/public/mojom/tcp_socket.mojom-forward.h"
#include "services/network/public/mojom/transferable_directory.mojom.h"
#include "services/network/public/mojom/trust_token_access_observer.mojom-forward.h"
#include "services/network/public/mojom/trust_tokens.mojom-forward.h"
#include "services/network/public/mojom/udp_socket.mojom-forward.h"
#include "services/network/public/mojom/url_loader.mojom-forward.h"
#include "services/network/public/mojom/url_loader_factory.mojom-forward.h"
#include "services/network/public/mojom/url_loader_network_service_observer.mojom-forward.h"
#include "services/network/public/mojom/url_request.mojom-forward.h"
#include "services/network/public/mojom/url_response_head.mojom-forward.h"
#include "services/network/public/mojom/web_transport.mojom-forward.h"
#include "services/network/public/mojom/websocket.mojom-forward.h"
#include "services/proxy_resolver/public/mojom/proxy_resolver.mojom-forward.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"
#include "services/network/public/mojom/p2p.mojom-forward.h"
#include "services/network/public/mojom/p2p_trusted.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"




namespace network { struct ResourceRequest; }


namespace network::mojom {

class CustomProxyConnectionObserverProxy;

template <typename ImplRefTraits>
class CustomProxyConnectionObserverStub;

class CustomProxyConnectionObserverRequestValidator;


class CustomProxyConnectionObserver
    : public CustomProxyConnectionObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.CustomProxyConnectionObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CustomProxyConnectionObserverInterfaceBase;
  using Proxy_ = CustomProxyConnectionObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = CustomProxyConnectionObserverStub<ImplRefTraits>;

  using RequestValidator_ = CustomProxyConnectionObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnFallbackMinVersion = 0,
    kOnTunnelHeadersReceivedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnFallback_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnTunnelHeadersReceived_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CustomProxyConnectionObserver() = default;

  virtual void OnFallback(const ::net::ProxyChain& bad_chain, int32_t net_error) = 0;

  virtual void OnTunnelHeadersReceived(const ::net::ProxyChain& proxy_chain, uint64_t chain_index, const ::scoped_refptr<::net::HttpResponseHeaders>& response_headers) = 0;
};

class CustomProxyConfigClientProxy;

template <typename ImplRefTraits>
class CustomProxyConfigClientStub;

class CustomProxyConfigClientRequestValidator;
class CustomProxyConfigClientResponseValidator;


class CustomProxyConfigClient
    : public CustomProxyConfigClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.CustomProxyConfigClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CustomProxyConfigClientInterfaceBase;
  using Proxy_ = CustomProxyConfigClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = CustomProxyConfigClientStub<ImplRefTraits>;

  using RequestValidator_ = CustomProxyConfigClientRequestValidator;
  using ResponseValidator_ = CustomProxyConfigClientResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOnCustomProxyConfigUpdatedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnCustomProxyConfigUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CustomProxyConfigClient() = default;

  using OnCustomProxyConfigUpdatedCallback = base::OnceCallback<void()>;
  using OnCustomProxyConfigUpdatedMojoCallback = base::OnceCallback<void()>;

  virtual void OnCustomProxyConfigUpdated(CustomProxyConfigPtr proxy_config, OnCustomProxyConfigUpdatedCallback callback) = 0;
};

class TrustedHeaderClientProxy;

template <typename ImplRefTraits>
class TrustedHeaderClientStub;

class TrustedHeaderClientRequestValidator;
class TrustedHeaderClientResponseValidator;


class TrustedHeaderClient
    : public TrustedHeaderClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.TrustedHeaderClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = TrustedHeaderClientInterfaceBase;
  using Proxy_ = TrustedHeaderClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = TrustedHeaderClientStub<ImplRefTraits>;

  using RequestValidator_ = TrustedHeaderClientRequestValidator;
  using ResponseValidator_ = TrustedHeaderClientResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOnBeforeSendHeadersMinVersion = 0,
    kOnHeadersReceivedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnBeforeSendHeaders_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnHeadersReceived_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~TrustedHeaderClient() = default;

  using OnBeforeSendHeadersCallback = base::OnceCallback<void(int32_t, const std::optional<::net::HttpRequestHeaders>&)>;
  using OnBeforeSendHeadersMojoCallback = base::OnceCallback<void(int32_t, const std::optional<::net::HttpRequestHeaders>&)>;

  virtual void OnBeforeSendHeaders(const ::net::HttpRequestHeaders& headers, OnBeforeSendHeadersCallback callback) = 0;

  using OnHeadersReceivedCallback = base::OnceCallback<void(int32_t, const std::optional<std::string>&, const std::optional<::GURL>&)>;
  using OnHeadersReceivedMojoCallback = base::OnceCallback<void(int32_t, const std::optional<std::string>&, const std::optional<::GURL>&)>;

  virtual void OnHeadersReceived(const std::string& headers, const ::net::IPEndPoint& remote_endpoint, OnHeadersReceivedCallback callback) = 0;
};

class TrustedURLLoaderHeaderClientProxy;

template <typename ImplRefTraits>
class TrustedURLLoaderHeaderClientStub;

class TrustedURLLoaderHeaderClientRequestValidator;


class TrustedURLLoaderHeaderClient
    : public TrustedURLLoaderHeaderClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.TrustedURLLoaderHeaderClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = TrustedURLLoaderHeaderClientInterfaceBase;
  using Proxy_ = TrustedURLLoaderHeaderClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = TrustedURLLoaderHeaderClientStub<ImplRefTraits>;

  using RequestValidator_ = TrustedURLLoaderHeaderClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnLoaderCreatedMinVersion = 0,
    kOnLoaderForCorsPreflightCreatedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnLoaderCreated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnLoaderForCorsPreflightCreated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~TrustedURLLoaderHeaderClient() = default;

  virtual void OnLoaderCreated(int32_t request_id, ::mojo::PendingReceiver<TrustedHeaderClient> header_client) = 0;

  virtual void OnLoaderForCorsPreflightCreated(const ::network::ResourceRequest& request, ::mojo::PendingReceiver<TrustedHeaderClient> header_client) = 0;
  // Default implementation for non-const ref params. This method can be
  // implemented as a performance optimization for non-const ref types.
  virtual void OnLoaderForCorsPreflightCreated(::network::ResourceRequest& request, ::mojo::PendingReceiver<TrustedHeaderClient> header_client) {
    OnLoaderForCorsPreflightCreated(const_cast<const ::network::ResourceRequest&>(request), std::move(header_client));
  }
};

class PreloadedSharedDictionaryInfoHandleProxy;

template <typename ImplRefTraits>
class PreloadedSharedDictionaryInfoHandleStub;

class PreloadedSharedDictionaryInfoHandleRequestValidator;


class PreloadedSharedDictionaryInfoHandle
    : public PreloadedSharedDictionaryInfoHandleInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.PreloadedSharedDictionaryInfoHandle";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PreloadedSharedDictionaryInfoHandleInterfaceBase;
  using Proxy_ = PreloadedSharedDictionaryInfoHandleProxy;

  template <typename ImplRefTraits>
  using Stub_ = PreloadedSharedDictionaryInfoHandleStub<ImplRefTraits>;

  using RequestValidator_ = PreloadedSharedDictionaryInfoHandleRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PreloadedSharedDictionaryInfoHandle() = default;
};

class NetworkContextProxy;

template <typename ImplRefTraits>
class NetworkContextStub;

class NetworkContextRequestValidator;
class NetworkContextResponseValidator;


class NetworkContext
    : public NetworkContextInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.NetworkContext";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    172614107, 
    531204221, 
    1143176580, 
    1486202305
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = NetworkContextInterfaceBase;
  using Proxy_ = NetworkContextProxy;

  template <typename ImplRefTraits>
  using Stub_ = NetworkContextStub<ImplRefTraits>;

  using RequestValidator_ = NetworkContextRequestValidator;
  using ResponseValidator_ = NetworkContextResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetClientMinVersion = 0,
    kCreateURLLoaderFactoryMinVersion = 0,
    kResetURLLoaderFactoriesMinVersion = 0,
    kGetViaObliviousHttpMinVersion = 0,
    kGetCookieManagerMinVersion = 0,
    kGetRestrictedCookieManagerMinVersion = 0,
    kGetTrustTokenQueryAnswererMinVersion = 0,
    kClearTrustTokenDataMinVersion = 0,
    kClearTrustTokenSessionOnlyDataMinVersion = 0,
    kGetStoredTrustTokenCountsMinVersion = 0,
    kGetPrivateStateTokenRedemptionRecordsMinVersion = 0,
    kDeleteStoredTrustTokensMinVersion = 0,
    kSetBlockTrustTokensMinVersion = 0,
    kSetTrackingProtectionContentSettingMinVersion = 0,
    kClearNetworkingHistoryBetweenMinVersion = 0,
    kClearHttpCacheMinVersion = 0,
    kComputeHttpCacheSizeMinVersion = 0,
    kNotifyExternalCacheHitMinVersion = 0,
    kClearHostCacheMinVersion = 0,
    kClearHttpAuthCacheMinVersion = 0,
    kClearCorsPreflightCacheMinVersion = 0,
    kClearReportingCacheReportsMinVersion = 0,
    kClearReportingCacheClientsMinVersion = 0,
    kClearNetworkErrorLoggingMinVersion = 0,
    kClearDomainReliabilityMinVersion = 0,
    kClearSharedDictionaryCacheMinVersion = 0,
    kClearSharedDictionaryCacheForIsolationKeyMinVersion = 0,
    kSetDocumentReportingEndpointsMinVersion = 0,
    kSetEnterpriseReportingEndpointsMinVersion = 0,
    kSendReportsAndRemoveSourceMinVersion = 0,
    kQueueReportMinVersion = 0,
    kQueueEnterpriseReportMinVersion = 0,
    kQueueSignedExchangeReportMinVersion = 0,
    kCloseAllConnectionsMinVersion = 0,
    kCloseIdleConnectionsMinVersion = 0,
    kSetNetworkConditionsMinVersion = 0,
    kSetAcceptLanguageMinVersion = 0,
    kSetUserAgentMinVersion = 0,
    kSetEnableReferrersMinVersion = 0,
    kSetCTPolicyMinVersion = 0,
    kCreateUDPSocketMinVersion = 0,
    kCreateRestrictedUDPSocketMinVersion = 0,
    kCreateTCPServerSocketMinVersion = 0,
    kCreateTCPConnectedSocketMinVersion = 0,
    kCreateTCPBoundSocketMinVersion = 0,
    kCreateProxyResolvingSocketFactoryMinVersion = 0,
    kLookUpProxyForURLMinVersion = 0,
    kForceReloadProxyConfigMinVersion = 0,
    kClearBadProxiesCacheMinVersion = 0,
    kCreateWebSocketMinVersion = 0,
    kCreateWebTransportMinVersion = 0,
    kCreateNetLogExporterMinVersion = 0,
    kPreconnectSocketsMinVersion = 0,
    kCreateP2PSocketManagerMinVersion = 0,
    kCreateMdnsResponderMinVersion = 0,
    kResolveHostMinVersion = 0,
    kCreateHostResolverMinVersion = 0,
    kVerifyCertMinVersion = 0,
    kVerifyCertForSignedExchangeMinVersion = 0,
    kVerify2QwacCertBindingMinVersion = 0,
    kAddHSTSMinVersion = 0,
    kIsHSTSActiveForHostMinVersion = 0,
    kGetHSTSStateMinVersion = 0,
    kSetCorsOriginAccessListsForOriginMinVersion = 0,
    kDeleteDynamicDataForHostMinVersion = 0,
    kSetSplitAuthCacheByNetworkAnonymizationKeyMinVersion = 0,
    kSaveHttpAuthCacheProxyEntriesMinVersion = 0,
    kLoadHttpAuthCacheProxyEntriesMinVersion = 0,
    kAddAuthCacheEntryMinVersion = 0,
    kSetCorsNonWildcardRequestHeadersSupportMinVersion = 0,
    kLookupServerBasicAuthCredentialsMinVersion = 0,
    kEnableStaticKeyPinningForTestingMinVersion = 0,
    kVerifyCertificateForTestingMinVersion = 0,
    kGetTrustAnchorIDsForTestingMinVersion = 0,
    kAddDomainReliabilityContextForTestingMinVersion = 0,
    kForceDomainReliabilityUploadsForTestingMinVersion = 0,
    kSetSCTAuditingModeMinVersion = 0,
    kGetSharedDictionaryUsageInfoMinVersion = 0,
    kGetSharedDictionaryInfoMinVersion = 0,
    kGetSharedDictionaryOriginsBetweenMinVersion = 0,
    kSetSharedDictionaryCacheMaxSizeMinVersion = 0,
    kPreloadSharedDictionaryInfoForDocumentMinVersion = 0,
    kHasPreloadedSharedDictionaryInfoForTestingMinVersion = 0,
    kResourceSchedulerClientVisibilityChangedMinVersion = 0,
    kFlushCachedClientCertIfNeededMinVersion = 0,
    kFlushMatchingCachedClientCertMinVersion = 0,
    kSetCookieDeprecationLabelMinVersion = 0,
    kRevokeNetworkForNoncesMinVersion = 0,
    kClearNoncesMinVersion = 0,
    kExemptUrlFromNetworkRevocationForNonceMinVersion = 0,
    kPrefetchMinVersion = 0,
    kGetBoundNetworkForTestingMinVersion = 0,
    kGetDeviceBoundSessionManagerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateURLLoaderFactory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ResetURLLoaderFactories_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetViaObliviousHttp_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetCookieManager_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetRestrictedCookieManager_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetTrustTokenQueryAnswerer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearTrustTokenData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearTrustTokenSessionOnlyData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetStoredTrustTokenCounts_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetPrivateStateTokenRedemptionRecords_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteStoredTrustTokens_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetBlockTrustTokens_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetTrackingProtectionContentSetting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearNetworkingHistoryBetween_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearHttpCache_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ComputeHttpCacheSize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyExternalCacheHit_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearHostCache_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearHttpAuthCache_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearCorsPreflightCache_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearReportingCacheReports_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearReportingCacheClients_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearNetworkErrorLogging_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearDomainReliability_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearSharedDictionaryCache_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearSharedDictionaryCacheForIsolationKey_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetDocumentReportingEndpoints_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetEnterpriseReportingEndpoints_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SendReportsAndRemoveSource_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct QueueReport_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct QueueEnterpriseReport_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct QueueSignedExchangeReport_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CloseAllConnections_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CloseIdleConnections_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetNetworkConditions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetAcceptLanguage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetUserAgent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetEnableReferrers_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetCTPolicy_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateUDPSocket_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateRestrictedUDPSocket_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateTCPServerSocket_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateTCPConnectedSocket_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateTCPBoundSocket_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateProxyResolvingSocketFactory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LookUpProxyForURL_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ForceReloadProxyConfig_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearBadProxiesCache_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateWebSocket_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateWebTransport_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateNetLogExporter_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PreconnectSockets_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateP2PSocketManager_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateMdnsResponder_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ResolveHost_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateHostResolver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct VerifyCert_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct VerifyCertForSignedExchange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Verify2QwacCertBinding_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddHSTS_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IsHSTSActiveForHost_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetHSTSState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetCorsOriginAccessListsForOrigin_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteDynamicDataForHost_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetSplitAuthCacheByNetworkAnonymizationKey_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SaveHttpAuthCacheProxyEntries_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LoadHttpAuthCacheProxyEntries_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddAuthCacheEntry_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetCorsNonWildcardRequestHeadersSupport_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LookupServerBasicAuthCredentials_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnableStaticKeyPinningForTesting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct VerifyCertificateForTesting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetTrustAnchorIDsForTesting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddDomainReliabilityContextForTesting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ForceDomainReliabilityUploadsForTesting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetSCTAuditingMode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetSharedDictionaryUsageInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetSharedDictionaryInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetSharedDictionaryOriginsBetween_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetSharedDictionaryCacheMaxSize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PreloadSharedDictionaryInfoForDocument_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HasPreloadedSharedDictionaryInfoForTesting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ResourceSchedulerClientVisibilityChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FlushCachedClientCertIfNeeded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FlushMatchingCachedClientCert_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetCookieDeprecationLabel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RevokeNetworkForNonces_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearNonces_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExemptUrlFromNetworkRevocationForNonce_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Prefetch_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetBoundNetworkForTesting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetDeviceBoundSessionManager_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  
  using DomainReliabilityClearMode = NetworkContext_DomainReliabilityClearMode;
  virtual ~NetworkContext() = default;

  virtual void SetClient(::mojo::PendingRemote<::network::mojom::NetworkContextClient> client) = 0;

  virtual void CreateURLLoaderFactory(::mojo::PendingReceiver<::network::mojom::URLLoaderFactory> url_loader_factory, URLLoaderFactoryParamsPtr params) = 0;

  virtual void ResetURLLoaderFactories() = 0;

  virtual void GetViaObliviousHttp(::network::mojom::ObliviousHttpRequestPtr request, ::mojo::PendingRemote<::network::mojom::ObliviousHttpClient> client) = 0;

  virtual void GetCookieManager(::mojo::PendingReceiver<::network::mojom::CookieManager> cookie_manager) = 0;

  virtual void GetRestrictedCookieManager(::mojo::PendingReceiver<::network::mojom::RestrictedCookieManager> restricted_cookie_manager, ::network::mojom::RestrictedCookieManagerRole role, const ::url::Origin& origin, const ::net::IsolationInfo& isolation_info, const ::net::CookieSettingOverrides& cookie_setting_overrides, const ::net::CookieSettingOverrides& devtools_cookie_setting_overrides, ::mojo::PendingRemote<::network::mojom::CookieAccessObserver> cookie_observer) = 0;

  virtual void GetTrustTokenQueryAnswerer(::mojo::PendingReceiver<::network::mojom::TrustTokenQueryAnswerer> trust_token_query_answerer, const ::url::Origin& top_frame_origin) = 0;

  using ClearTrustTokenDataCallback = base::OnceCallback<void()>;
  using ClearTrustTokenDataMojoCallback = base::OnceCallback<void()>;

  virtual void ClearTrustTokenData(::network::mojom::ClearDataFilterPtr filter, ClearTrustTokenDataCallback callback) = 0;

  using ClearTrustTokenSessionOnlyDataCallback = base::OnceCallback<void(bool)>;
  using ClearTrustTokenSessionOnlyDataMojoCallback = base::OnceCallback<void(bool)>;

  virtual void ClearTrustTokenSessionOnlyData(ClearTrustTokenSessionOnlyDataCallback callback) = 0;

  using GetStoredTrustTokenCountsCallback = base::OnceCallback<void(std::vector<::network::mojom::StoredTrustTokensForIssuerPtr>)>;
  using GetStoredTrustTokenCountsMojoCallback = base::OnceCallback<void(std::vector<::network::mojom::StoredTrustTokensForIssuerPtr>)>;

  virtual void GetStoredTrustTokenCounts(GetStoredTrustTokenCountsCallback callback) = 0;

  using GetPrivateStateTokenRedemptionRecordsCallback = base::OnceCallback<void(base::flat_map<::url::Origin, std::vector<::network::mojom::ToplevelRedemptionRecordPtr>>)>;
  using GetPrivateStateTokenRedemptionRecordsMojoCallback = base::OnceCallback<void(base::flat_map<::url::Origin, std::vector<::network::mojom::ToplevelRedemptionRecordPtr>>)>;

  virtual void GetPrivateStateTokenRedemptionRecords(GetPrivateStateTokenRedemptionRecordsCallback callback) = 0;

  using DeleteStoredTrustTokensCallback = base::OnceCallback<void(::network::mojom::DeleteStoredTrustTokensStatus)>;
  using DeleteStoredTrustTokensMojoCallback = base::OnceCallback<void(::network::mojom::DeleteStoredTrustTokensStatus)>;

  virtual void DeleteStoredTrustTokens(const ::url::Origin& issuer, DeleteStoredTrustTokensCallback callback) = 0;

  virtual void SetBlockTrustTokens(bool block) = 0;

  virtual void SetTrackingProtectionContentSetting(const std::vector<::ContentSettingPatternSource>& settings) = 0;

  using ClearNetworkingHistoryBetweenCallback = base::OnceCallback<void()>;
  using ClearNetworkingHistoryBetweenMojoCallback = base::OnceCallback<void()>;

  virtual void ClearNetworkingHistoryBetween(::base::Time start_time, ::base::Time end_time, ClearNetworkingHistoryBetweenCallback callback) = 0;

  using ClearHttpCacheCallback = base::OnceCallback<void()>;
  using ClearHttpCacheMojoCallback = base::OnceCallback<void()>;

  virtual void ClearHttpCache(::base::Time start_time, ::base::Time end_time, ::network::mojom::ClearDataFilterPtr filter, ClearHttpCacheCallback callback) = 0;

  using ComputeHttpCacheSizeCallback = base::OnceCallback<void(bool, int64_t)>;
  using ComputeHttpCacheSizeMojoCallback = base::OnceCallback<void(bool, int64_t)>;

  virtual void ComputeHttpCacheSize(::base::Time start_time, ::base::Time end_time, ComputeHttpCacheSizeCallback callback) = 0;

  virtual void NotifyExternalCacheHit(const ::GURL& url, const std::string& http_method, const ::net::NetworkIsolationKey& key, bool include_credentials) = 0;

  using ClearHostCacheCallback = base::OnceCallback<void()>;
  using ClearHostCacheMojoCallback = base::OnceCallback<void()>;

  virtual void ClearHostCache(::network::mojom::ClearDataFilterPtr filter, ClearHostCacheCallback callback) = 0;

  using ClearHttpAuthCacheCallback = base::OnceCallback<void()>;
  using ClearHttpAuthCacheMojoCallback = base::OnceCallback<void()>;

  virtual void ClearHttpAuthCache(::base::Time start_time, ::base::Time end_time, ::network::mojom::ClearDataFilterPtr filter, ClearHttpAuthCacheCallback callback) = 0;

  using ClearCorsPreflightCacheCallback = base::OnceCallback<void()>;
  using ClearCorsPreflightCacheMojoCallback = base::OnceCallback<void()>;

  virtual void ClearCorsPreflightCache(::network::mojom::ClearDataFilterPtr filter, ClearCorsPreflightCacheCallback callback) = 0;

  using ClearReportingCacheReportsCallback = base::OnceCallback<void()>;
  using ClearReportingCacheReportsMojoCallback = base::OnceCallback<void()>;

  virtual void ClearReportingCacheReports(::network::mojom::ClearDataFilterPtr filter, ClearReportingCacheReportsCallback callback) = 0;

  using ClearReportingCacheClientsCallback = base::OnceCallback<void()>;
  using ClearReportingCacheClientsMojoCallback = base::OnceCallback<void()>;

  virtual void ClearReportingCacheClients(::network::mojom::ClearDataFilterPtr filter, ClearReportingCacheClientsCallback callback) = 0;

  using ClearNetworkErrorLoggingCallback = base::OnceCallback<void()>;
  using ClearNetworkErrorLoggingMojoCallback = base::OnceCallback<void()>;

  virtual void ClearNetworkErrorLogging(::network::mojom::ClearDataFilterPtr filter, ClearNetworkErrorLoggingCallback callback) = 0;

  using ClearDomainReliabilityCallback = base::OnceCallback<void()>;
  using ClearDomainReliabilityMojoCallback = base::OnceCallback<void()>;

  virtual void ClearDomainReliability(::network::mojom::ClearDataFilterPtr filter, NetworkContext::DomainReliabilityClearMode mode, ClearDomainReliabilityCallback callback) = 0;

  using ClearSharedDictionaryCacheCallback = base::OnceCallback<void()>;
  using ClearSharedDictionaryCacheMojoCallback = base::OnceCallback<void()>;

  virtual void ClearSharedDictionaryCache(::base::Time start_time, ::base::Time end_time, ::network::mojom::ClearDataFilterPtr filter, ClearSharedDictionaryCacheCallback callback) = 0;

  using ClearSharedDictionaryCacheForIsolationKeyCallback = base::OnceCallback<void()>;
  using ClearSharedDictionaryCacheForIsolationKeyMojoCallback = base::OnceCallback<void()>;

  virtual void ClearSharedDictionaryCacheForIsolationKey(const ::net::SharedDictionaryIsolationKey& isolation_key, ClearSharedDictionaryCacheForIsolationKeyCallback callback) = 0;

  virtual void SetDocumentReportingEndpoints(const ::base::UnguessableToken& reporting_source, const ::url::Origin& origin, const ::net::IsolationInfo& isolation_info, const base::flat_map<std::string, std::string>& endpoints) = 0;

  virtual void SetEnterpriseReportingEndpoints(const base::flat_map<std::string, ::GURL>& endpoints) = 0;

  virtual void SendReportsAndRemoveSource(const ::base::UnguessableToken& reporting_source) = 0;

  virtual void QueueReport(const std::string& type, const std::string& group, const ::GURL& url, const std::optional<::base::UnguessableToken>& reporting_source, const ::net::NetworkAnonymizationKey& network_anonymization_key, ::base::Value::Dict body) = 0;

  virtual void QueueEnterpriseReport(const std::string& type, const std::string& group, const ::GURL& url, ::base::Value::Dict body) = 0;

  virtual void QueueSignedExchangeReport(SignedExchangeReportPtr report, const ::net::NetworkAnonymizationKey& network_anonymization_key) = 0;

  using CloseAllConnectionsCallback = base::OnceCallback<void()>;
  using CloseAllConnectionsMojoCallback = base::OnceCallback<void()>;

  virtual void CloseAllConnections(CloseAllConnectionsCallback callback) = 0;

  using CloseIdleConnectionsCallback = base::OnceCallback<void()>;
  using CloseIdleConnectionsMojoCallback = base::OnceCallback<void()>;

  virtual void CloseIdleConnections(CloseIdleConnectionsCallback callback) = 0;

  virtual void SetNetworkConditions(const ::base::UnguessableToken& throttling_profile_id, NetworkConditionsPtr conditions) = 0;

  virtual void SetAcceptLanguage(const std::string& new_accept_language) = 0;

  virtual void SetUserAgent(const std::string& new_user_agent) = 0;

  virtual void SetEnableReferrers(bool enable_referrers) = 0;

  virtual void SetCTPolicy(CTPolicyPtr ct_policy) = 0;

  virtual void CreateUDPSocket(::mojo::PendingReceiver<::network::mojom::UDPSocket> receiver, ::mojo::PendingRemote<::network::mojom::UDPSocketListener> listener) = 0;

  using CreateRestrictedUDPSocketCallback = base::OnceCallback<void(int32_t, const std::optional<::net::IPEndPoint>&)>;
  using CreateRestrictedUDPSocketMojoCallback = base::OnceCallback<void(int32_t, const std::optional<::net::IPEndPoint>&)>;

  virtual void CreateRestrictedUDPSocket(const ::net::IPEndPoint& addr, ::network::mojom::RestrictedUDPSocketMode mode, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::network::mojom::RestrictedUDPSocketParamsPtr params, ::mojo::PendingReceiver<::network::mojom::RestrictedUDPSocket> receiver, ::mojo::PendingRemote<::network::mojom::UDPSocketListener> listener, CreateRestrictedUDPSocketCallback callback) = 0;

  using CreateTCPServerSocketCallback = base::OnceCallback<void(int32_t, const std::optional<::net::IPEndPoint>&)>;
  using CreateTCPServerSocketMojoCallback = base::OnceCallback<void(int32_t, const std::optional<::net::IPEndPoint>&)>;

  virtual void CreateTCPServerSocket(const ::net::IPEndPoint& local_addr, ::network::mojom::TCPServerSocketOptionsPtr options, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TCPServerSocket> socket, CreateTCPServerSocketCallback callback) = 0;

  using CreateTCPConnectedSocketCallback = base::OnceCallback<void(int32_t, const std::optional<::net::IPEndPoint>&, const std::optional<::net::IPEndPoint>&, ::mojo::ScopedDataPipeConsumerHandle, ::mojo::ScopedDataPipeProducerHandle)>;
  using CreateTCPConnectedSocketMojoCallback = base::OnceCallback<void(int32_t, const std::optional<::net::IPEndPoint>&, const std::optional<::net::IPEndPoint>&, ::mojo::ScopedDataPipeConsumerHandle, ::mojo::ScopedDataPipeProducerHandle)>;

  virtual void CreateTCPConnectedSocket(const std::optional<::net::IPEndPoint>& local_addr, const ::net::AddressList& remote_addr_list, ::network::mojom::TCPConnectedSocketOptionsPtr tcp_connected_socket_options, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TCPConnectedSocket> socket, ::mojo::PendingRemote<::network::mojom::SocketObserver> observer, CreateTCPConnectedSocketCallback callback) = 0;

  using CreateTCPBoundSocketCallback = base::OnceCallback<void(int32_t, const std::optional<::net::IPEndPoint>&)>;
  using CreateTCPBoundSocketMojoCallback = base::OnceCallback<void(int32_t, const std::optional<::net::IPEndPoint>&)>;

  virtual void CreateTCPBoundSocket(const ::net::IPEndPoint& local_addr, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TCPBoundSocket> socket, CreateTCPBoundSocketCallback callback) = 0;

  virtual void CreateProxyResolvingSocketFactory(::mojo::PendingReceiver<::network::mojom::ProxyResolvingSocketFactory> factory) = 0;

  virtual void LookUpProxyForURL(const ::GURL& url, const ::net::NetworkAnonymizationKey& network_anonymization_key, ::mojo::PendingRemote<::network::mojom::ProxyLookupClient> proxy_lookup_client) = 0;

  using ForceReloadProxyConfigCallback = base::OnceCallback<void()>;
  using ForceReloadProxyConfigMojoCallback = base::OnceCallback<void()>;

  virtual void ForceReloadProxyConfig(ForceReloadProxyConfigCallback callback) = 0;

  using ClearBadProxiesCacheCallback = base::OnceCallback<void()>;
  using ClearBadProxiesCacheMojoCallback = base::OnceCallback<void()>;

  virtual void ClearBadProxiesCache(ClearBadProxiesCacheCallback callback) = 0;

  virtual void CreateWebSocket(const ::GURL& url, const std::vector<std::string>& requested_protocols, const ::net::SiteForCookies& site_for_cookies, ::net::StorageAccessApiStatus storage_access_api_status, const ::net::IsolationInfo& isolation_info, std::vector<::network::mojom::HttpHeaderPtr> additional_headers, int32_t process_id, const ::url::Origin& origin, uint32_t options, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingRemote<::network::mojom::WebSocketHandshakeClient> handshake_client, ::mojo::PendingRemote<::network::mojom::URLLoaderNetworkServiceObserver> url_loader_network_observer, ::mojo::PendingRemote<::network::mojom::WebSocketAuthenticationHandler> auth_handler, ::mojo::PendingRemote<TrustedHeaderClient> header_client, const std::optional<::base::UnguessableToken>& throttling_profile_id) = 0;

  virtual void CreateWebTransport(const ::GURL& url, const ::url::Origin& origin, const ::net::NetworkAnonymizationKey& network_anonymization_key, std::vector<::network::mojom::WebTransportCertificateFingerprintPtr> fingerprints, const std::vector<std::string>& application_protocols, ::mojo::PendingRemote<::network::mojom::WebTransportHandshakeClient> handshake_client) = 0;

  virtual void CreateNetLogExporter(::mojo::PendingReceiver<::network::mojom::NetLogExporter> receiver) = 0;

  virtual void PreconnectSockets(uint32_t num_streams, const ::GURL& url, ::network::mojom::CredentialsMode credentials_mode, const ::net::NetworkAnonymizationKey& network_anonymization_key, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, const std::optional<::net::ConnectionKeepAliveConfig>& keepalive_config, ::mojo::PendingRemote<::network::mojom::ConnectionChangeObserverClient> observer_client) = 0;

  virtual void CreateP2PSocketManager(const ::net::NetworkAnonymizationKey& network_anonymization_key, ::mojo::PendingRemote<::network::mojom::P2PTrustedSocketManagerClient> client, ::mojo::PendingReceiver<::network::mojom::P2PTrustedSocketManager> trusted_socket_manager, ::mojo::PendingReceiver<::network::mojom::P2PSocketManager> socket_manager) = 0;

  virtual void CreateMdnsResponder(::mojo::PendingReceiver<::network::mojom::MdnsResponder> responder_receiver) = 0;

  virtual void ResolveHost(::network::mojom::HostResolverHostPtr host, const ::net::NetworkAnonymizationKey& network_anonymization_key, ::network::mojom::ResolveHostParametersPtr optional_parameters, ::mojo::PendingRemote<::network::mojom::ResolveHostClient> response_client) = 0;

  virtual void CreateHostResolver(const std::optional<::net::DnsConfigOverrides>& config_overrides, ::mojo::PendingReceiver<::network::mojom::HostResolver> host_resolver) = 0;

  using VerifyCertCallback = base::OnceCallback<void(int32_t, const ::net::CertVerifyResult&, bool)>;
  using VerifyCertMojoCallback = base::OnceCallback<void(int32_t, const ::net::CertVerifyResult&, bool)>;

  virtual void VerifyCert(const ::scoped_refptr<::net::X509Certificate>& certificate, const ::net::HostPortPair& host_port, const std::string& ocsp_response, const std::string& sct_list, VerifyCertCallback callback) = 0;

  using VerifyCertForSignedExchangeCallback = base::OnceCallback<void(int32_t, const ::net::CertVerifyResult&, bool)>;
  using VerifyCertForSignedExchangeMojoCallback = base::OnceCallback<void(int32_t, const ::net::CertVerifyResult&, bool)>;

  virtual void VerifyCertForSignedExchange(const ::scoped_refptr<::net::X509Certificate>& certificate, const ::net::HostPortPair& host_port, const std::string& ocsp_response, const std::string& sct_list, VerifyCertForSignedExchangeCallback callback) = 0;

  using Verify2QwacCertBindingCallback = base::OnceCallback<void(const ::scoped_refptr<::net::X509Certificate>&)>;
  using Verify2QwacCertBindingMojoCallback = base::OnceCallback<void(const ::scoped_refptr<::net::X509Certificate>&)>;

  virtual void Verify2QwacCertBinding(const std::string& binding, const std::string& hostname, const ::scoped_refptr<::net::X509Certificate>& tls_certificate, Verify2QwacCertBindingCallback callback) = 0;

  using AddHSTSCallback = base::OnceCallback<void()>;
  using AddHSTSMojoCallback = base::OnceCallback<void()>;

  virtual void AddHSTS(const std::string& host, ::base::Time expiry, bool include_subdomains, AddHSTSCallback callback) = 0;

  using IsHSTSActiveForHostCallback = base::OnceCallback<void(bool)>;
  using IsHSTSActiveForHostMojoCallback = base::OnceCallback<void(bool)>;

  virtual void IsHSTSActiveForHost(const std::string& host, bool is_top_level_nav, IsHSTSActiveForHostCallback callback) = 0;

  using GetHSTSStateCallback = base::OnceCallback<void(::base::Value::Dict)>;
  using GetHSTSStateMojoCallback = base::OnceCallback<void(::base::Value::Dict)>;

  virtual void GetHSTSState(const std::string& domain, GetHSTSStateCallback callback) = 0;

  using SetCorsOriginAccessListsForOriginCallback = base::OnceCallback<void()>;
  using SetCorsOriginAccessListsForOriginMojoCallback = base::OnceCallback<void()>;

  virtual void SetCorsOriginAccessListsForOrigin(const ::url::Origin& source_origin, std::vector<::network::mojom::CorsOriginPatternPtr> allow_patterns, std::vector<::network::mojom::CorsOriginPatternPtr> block_patterns, SetCorsOriginAccessListsForOriginCallback callback) = 0;

  using DeleteDynamicDataForHostCallback = base::OnceCallback<void(bool)>;
  using DeleteDynamicDataForHostMojoCallback = base::OnceCallback<void(bool)>;

  virtual void DeleteDynamicDataForHost(const std::string& host, DeleteDynamicDataForHostCallback callback) = 0;

  virtual void SetSplitAuthCacheByNetworkAnonymizationKey(bool split_auth_cache_by_network_anonymization_key) = 0;

  using SaveHttpAuthCacheProxyEntriesCallback = base::OnceCallback<void(const ::base::UnguessableToken&)>;
  using SaveHttpAuthCacheProxyEntriesMojoCallback = base::OnceCallback<void(const ::base::UnguessableToken&)>;

  virtual void SaveHttpAuthCacheProxyEntries(SaveHttpAuthCacheProxyEntriesCallback callback) = 0;

  using LoadHttpAuthCacheProxyEntriesCallback = base::OnceCallback<void()>;
  using LoadHttpAuthCacheProxyEntriesMojoCallback = base::OnceCallback<void()>;

  virtual void LoadHttpAuthCacheProxyEntries(const ::base::UnguessableToken& cache_key, LoadHttpAuthCacheProxyEntriesCallback callback) = 0;

  using AddAuthCacheEntryCallback = base::OnceCallback<void()>;
  using AddAuthCacheEntryMojoCallback = base::OnceCallback<void()>;

  virtual void AddAuthCacheEntry(const ::net::AuthChallengeInfo& challenge, const ::net::NetworkAnonymizationKey& network_anonymization_key, const ::net::AuthCredentials& credentials, AddAuthCacheEntryCallback callback) = 0;

  virtual void SetCorsNonWildcardRequestHeadersSupport(bool value) = 0;

  using LookupServerBasicAuthCredentialsCallback = base::OnceCallback<void(const std::optional<::net::AuthCredentials>&)>;
  using LookupServerBasicAuthCredentialsMojoCallback = base::OnceCallback<void(const std::optional<::net::AuthCredentials>&)>;

  virtual void LookupServerBasicAuthCredentials(const ::GURL& url, const ::net::NetworkAnonymizationKey& network_anonymization_key, LookupServerBasicAuthCredentialsCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool EnableStaticKeyPinningForTesting();
  using EnableStaticKeyPinningForTestingCallback = base::OnceCallback<void()>;
  using EnableStaticKeyPinningForTestingMojoCallback = base::OnceCallback<void()>;

  virtual void EnableStaticKeyPinningForTesting(EnableStaticKeyPinningForTestingCallback callback) = 0;

  using VerifyCertificateForTestingCallback = base::OnceCallback<void(int32_t)>;
  using VerifyCertificateForTestingMojoCallback = base::OnceCallback<void(int32_t)>;

  virtual void VerifyCertificateForTesting(const ::scoped_refptr<::net::X509Certificate>& certificate, const std::string& hostname, const std::string& ocsp_response, const std::string& sct_list, VerifyCertificateForTestingCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetTrustAnchorIDsForTesting(std::vector<std::vector<uint8_t>>* out_trust_anchor_ids);
  using GetTrustAnchorIDsForTestingCallback = base::OnceCallback<void(const std::vector<std::vector<uint8_t>>&)>;
  using GetTrustAnchorIDsForTestingMojoCallback = base::OnceCallback<void(const std::vector<std::vector<uint8_t>>&)>;

  virtual void GetTrustAnchorIDsForTesting(GetTrustAnchorIDsForTestingCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool AddDomainReliabilityContextForTesting(const ::url::Origin& origin, const ::GURL& upload_url);
  using AddDomainReliabilityContextForTestingCallback = base::OnceCallback<void()>;
  using AddDomainReliabilityContextForTestingMojoCallback = base::OnceCallback<void()>;

  virtual void AddDomainReliabilityContextForTesting(const ::url::Origin& origin, const ::GURL& upload_url, AddDomainReliabilityContextForTestingCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool ForceDomainReliabilityUploadsForTesting();
  using ForceDomainReliabilityUploadsForTestingCallback = base::OnceCallback<void()>;
  using ForceDomainReliabilityUploadsForTestingMojoCallback = base::OnceCallback<void()>;

  virtual void ForceDomainReliabilityUploadsForTesting(ForceDomainReliabilityUploadsForTestingCallback callback) = 0;

  virtual void SetSCTAuditingMode(SCTAuditingMode mode) = 0;

  using GetSharedDictionaryUsageInfoCallback = base::OnceCallback<void(const std::vector<::net::SharedDictionaryUsageInfo>&)>;
  using GetSharedDictionaryUsageInfoMojoCallback = base::OnceCallback<void(const std::vector<::net::SharedDictionaryUsageInfo>&)>;

  virtual void GetSharedDictionaryUsageInfo(GetSharedDictionaryUsageInfoCallback callback) = 0;

  using GetSharedDictionaryInfoCallback = base::OnceCallback<void(std::vector<SharedDictionaryInfoPtr>)>;
  using GetSharedDictionaryInfoMojoCallback = base::OnceCallback<void(std::vector<SharedDictionaryInfoPtr>)>;

  virtual void GetSharedDictionaryInfo(const ::net::SharedDictionaryIsolationKey& isolation_key, GetSharedDictionaryInfoCallback callback) = 0;

  using GetSharedDictionaryOriginsBetweenCallback = base::OnceCallback<void(const std::vector<::url::Origin>&)>;
  using GetSharedDictionaryOriginsBetweenMojoCallback = base::OnceCallback<void(const std::vector<::url::Origin>&)>;

  virtual void GetSharedDictionaryOriginsBetween(::base::Time start_time, ::base::Time end_time, GetSharedDictionaryOriginsBetweenCallback callback) = 0;

  virtual void SetSharedDictionaryCacheMaxSize(uint64_t cache_max_size) = 0;

  virtual void PreloadSharedDictionaryInfoForDocument(const std::vector<::GURL>& urls, ::mojo::PendingReceiver<PreloadedSharedDictionaryInfoHandle> preload_handle) = 0;

  using HasPreloadedSharedDictionaryInfoForTestingCallback = base::OnceCallback<void(bool)>;
  using HasPreloadedSharedDictionaryInfoForTestingMojoCallback = base::OnceCallback<void(bool)>;

  virtual void HasPreloadedSharedDictionaryInfoForTesting(HasPreloadedSharedDictionaryInfoForTestingCallback callback) = 0;

  virtual void ResourceSchedulerClientVisibilityChanged(const ::base::UnguessableToken& client_token, bool visible) = 0;

  virtual void FlushCachedClientCertIfNeeded(const ::net::HostPortPair& host, const ::scoped_refptr<::net::X509Certificate>& certificate) = 0;

  virtual void FlushMatchingCachedClientCert(const ::scoped_refptr<::net::X509Certificate>& certificate) = 0;

  virtual void SetCookieDeprecationLabel(const std::optional<std::string>& label) = 0;

  using RevokeNetworkForNoncesCallback = base::OnceCallback<void()>;
  using RevokeNetworkForNoncesMojoCallback = base::OnceCallback<void()>;

  virtual void RevokeNetworkForNonces(const std::vector<::base::UnguessableToken>& nonces, RevokeNetworkForNoncesCallback callback) = 0;

  virtual void ClearNonces(const std::vector<::base::UnguessableToken>& nonces) = 0;

  using ExemptUrlFromNetworkRevocationForNonceCallback = base::OnceCallback<void()>;
  using ExemptUrlFromNetworkRevocationForNonceMojoCallback = base::OnceCallback<void()>;

  virtual void ExemptUrlFromNetworkRevocationForNonce(const ::GURL& exempted_url, const ::base::UnguessableToken& nonce, ExemptUrlFromNetworkRevocationForNonceCallback callback) = 0;

  virtual void Prefetch(int32_t request_id, uint32_t options, const ::network::ResourceRequest& request, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation) = 0;
  // Default implementation for non-const ref params. This method can be
  // implemented as a performance optimization for non-const ref types.
  virtual void Prefetch(int32_t request_id, uint32_t options, ::network::ResourceRequest& request, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation) {
    Prefetch(std::move(request_id), std::move(options), const_cast<const ::network::ResourceRequest&>(request), std::move(traffic_annotation));
  }

  using GetBoundNetworkForTestingCallback = base::OnceCallback<void(int64_t)>;
  using GetBoundNetworkForTestingMojoCallback = base::OnceCallback<void(int64_t)>;

  virtual void GetBoundNetworkForTesting(GetBoundNetworkForTestingCallback callback) = 0;

  virtual void GetDeviceBoundSessionManager(::mojo::PendingReceiver<::network::mojom::DeviceBoundSessionManager> device_bound_session_manager) = 0;
};



class  CustomProxyConnectionObserverProxy
    : public CustomProxyConnectionObserver {
 public:
  using InterfaceType = CustomProxyConnectionObserver;

  explicit CustomProxyConnectionObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnFallback(const ::net::ProxyChain& bad_chain, int32_t net_error) final;
  
  void OnTunnelHeadersReceived(const ::net::ProxyChain& proxy_chain, uint64_t chain_index, const ::scoped_refptr<::net::HttpResponseHeaders>& response_headers) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  CustomProxyConfigClientProxy
    : public CustomProxyConfigClient {
 public:
  using InterfaceType = CustomProxyConfigClient;

  explicit CustomProxyConfigClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnCustomProxyConfigUpdated(CustomProxyConfigPtr proxy_config, OnCustomProxyConfigUpdatedCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  TrustedHeaderClientProxy
    : public TrustedHeaderClient {
 public:
  using InterfaceType = TrustedHeaderClient;

  explicit TrustedHeaderClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnBeforeSendHeaders(const ::net::HttpRequestHeaders& headers, OnBeforeSendHeadersCallback callback) final;
  
  void OnHeadersReceived(const std::string& headers, const ::net::IPEndPoint& remote_endpoint, OnHeadersReceivedCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  TrustedURLLoaderHeaderClientProxy
    : public TrustedURLLoaderHeaderClient {
 public:
  using InterfaceType = TrustedURLLoaderHeaderClient;

  explicit TrustedURLLoaderHeaderClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnLoaderCreated(int32_t request_id, ::mojo::PendingReceiver<TrustedHeaderClient> header_client) final;
  
  void OnLoaderForCorsPreflightCreated(const ::network::ResourceRequest& request, ::mojo::PendingReceiver<TrustedHeaderClient> header_client) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PreloadedSharedDictionaryInfoHandleProxy
    : public PreloadedSharedDictionaryInfoHandle {
 public:
  using InterfaceType = PreloadedSharedDictionaryInfoHandle;

  explicit PreloadedSharedDictionaryInfoHandleProxy(mojo::MessageReceiverWithResponder* receiver);

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  NetworkContextProxy
    : public NetworkContext {
 public:
  using InterfaceType = NetworkContext;

  explicit NetworkContextProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetClient(::mojo::PendingRemote<::network::mojom::NetworkContextClient> client) final;
  
  void CreateURLLoaderFactory(::mojo::PendingReceiver<::network::mojom::URLLoaderFactory> url_loader_factory, URLLoaderFactoryParamsPtr params) final;
  
  void ResetURLLoaderFactories() final;
  
  void GetViaObliviousHttp(::network::mojom::ObliviousHttpRequestPtr request, ::mojo::PendingRemote<::network::mojom::ObliviousHttpClient> client) final;
  
  void GetCookieManager(::mojo::PendingReceiver<::network::mojom::CookieManager> cookie_manager) final;
  
  void GetRestrictedCookieManager(::mojo::PendingReceiver<::network::mojom::RestrictedCookieManager> restricted_cookie_manager, ::network::mojom::RestrictedCookieManagerRole role, const ::url::Origin& origin, const ::net::IsolationInfo& isolation_info, const ::net::CookieSettingOverrides& cookie_setting_overrides, const ::net::CookieSettingOverrides& devtools_cookie_setting_overrides, ::mojo::PendingRemote<::network::mojom::CookieAccessObserver> cookie_observer) final;
  
  void GetTrustTokenQueryAnswerer(::mojo::PendingReceiver<::network::mojom::TrustTokenQueryAnswerer> trust_token_query_answerer, const ::url::Origin& top_frame_origin) final;
  
  void ClearTrustTokenData(::network::mojom::ClearDataFilterPtr filter, ClearTrustTokenDataCallback callback) final;
  
  void ClearTrustTokenSessionOnlyData(ClearTrustTokenSessionOnlyDataCallback callback) final;
  
  void GetStoredTrustTokenCounts(GetStoredTrustTokenCountsCallback callback) final;
  
  void GetPrivateStateTokenRedemptionRecords(GetPrivateStateTokenRedemptionRecordsCallback callback) final;
  
  void DeleteStoredTrustTokens(const ::url::Origin& issuer, DeleteStoredTrustTokensCallback callback) final;
  
  void SetBlockTrustTokens(bool block) final;
  
  void SetTrackingProtectionContentSetting(const std::vector<::ContentSettingPatternSource>& settings) final;
  
  void ClearNetworkingHistoryBetween(::base::Time start_time, ::base::Time end_time, ClearNetworkingHistoryBetweenCallback callback) final;
  
  void ClearHttpCache(::base::Time start_time, ::base::Time end_time, ::network::mojom::ClearDataFilterPtr filter, ClearHttpCacheCallback callback) final;
  
  void ComputeHttpCacheSize(::base::Time start_time, ::base::Time end_time, ComputeHttpCacheSizeCallback callback) final;
  
  void NotifyExternalCacheHit(const ::GURL& url, const std::string& http_method, const ::net::NetworkIsolationKey& key, bool include_credentials) final;
  
  void ClearHostCache(::network::mojom::ClearDataFilterPtr filter, ClearHostCacheCallback callback) final;
  
  void ClearHttpAuthCache(::base::Time start_time, ::base::Time end_time, ::network::mojom::ClearDataFilterPtr filter, ClearHttpAuthCacheCallback callback) final;
  
  void ClearCorsPreflightCache(::network::mojom::ClearDataFilterPtr filter, ClearCorsPreflightCacheCallback callback) final;
  
  void ClearReportingCacheReports(::network::mojom::ClearDataFilterPtr filter, ClearReportingCacheReportsCallback callback) final;
  
  void ClearReportingCacheClients(::network::mojom::ClearDataFilterPtr filter, ClearReportingCacheClientsCallback callback) final;
  
  void ClearNetworkErrorLogging(::network::mojom::ClearDataFilterPtr filter, ClearNetworkErrorLoggingCallback callback) final;
  
  void ClearDomainReliability(::network::mojom::ClearDataFilterPtr filter, NetworkContext::DomainReliabilityClearMode mode, ClearDomainReliabilityCallback callback) final;
  
  void ClearSharedDictionaryCache(::base::Time start_time, ::base::Time end_time, ::network::mojom::ClearDataFilterPtr filter, ClearSharedDictionaryCacheCallback callback) final;
  
  void ClearSharedDictionaryCacheForIsolationKey(const ::net::SharedDictionaryIsolationKey& isolation_key, ClearSharedDictionaryCacheForIsolationKeyCallback callback) final;
  
  void SetDocumentReportingEndpoints(const ::base::UnguessableToken& reporting_source, const ::url::Origin& origin, const ::net::IsolationInfo& isolation_info, const base::flat_map<std::string, std::string>& endpoints) final;
  
  void SetEnterpriseReportingEndpoints(const base::flat_map<std::string, ::GURL>& endpoints) final;
  
  void SendReportsAndRemoveSource(const ::base::UnguessableToken& reporting_source) final;
  
  void QueueReport(const std::string& type, const std::string& group, const ::GURL& url, const std::optional<::base::UnguessableToken>& reporting_source, const ::net::NetworkAnonymizationKey& network_anonymization_key, ::base::Value::Dict body) final;
  
  void QueueEnterpriseReport(const std::string& type, const std::string& group, const ::GURL& url, ::base::Value::Dict body) final;
  
  void QueueSignedExchangeReport(SignedExchangeReportPtr report, const ::net::NetworkAnonymizationKey& network_anonymization_key) final;
  
  void CloseAllConnections(CloseAllConnectionsCallback callback) final;
  
  void CloseIdleConnections(CloseIdleConnectionsCallback callback) final;
  
  void SetNetworkConditions(const ::base::UnguessableToken& throttling_profile_id, NetworkConditionsPtr conditions) final;
  
  void SetAcceptLanguage(const std::string& new_accept_language) final;
  
  void SetUserAgent(const std::string& new_user_agent) final;
  
  void SetEnableReferrers(bool enable_referrers) final;
  
  void SetCTPolicy(CTPolicyPtr ct_policy) final;
  
  void CreateUDPSocket(::mojo::PendingReceiver<::network::mojom::UDPSocket> receiver, ::mojo::PendingRemote<::network::mojom::UDPSocketListener> listener) final;
  
  void CreateRestrictedUDPSocket(const ::net::IPEndPoint& addr, ::network::mojom::RestrictedUDPSocketMode mode, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::network::mojom::RestrictedUDPSocketParamsPtr params, ::mojo::PendingReceiver<::network::mojom::RestrictedUDPSocket> receiver, ::mojo::PendingRemote<::network::mojom::UDPSocketListener> listener, CreateRestrictedUDPSocketCallback callback) final;
  
  void CreateTCPServerSocket(const ::net::IPEndPoint& local_addr, ::network::mojom::TCPServerSocketOptionsPtr options, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TCPServerSocket> socket, CreateTCPServerSocketCallback callback) final;
  
  void CreateTCPConnectedSocket(const std::optional<::net::IPEndPoint>& local_addr, const ::net::AddressList& remote_addr_list, ::network::mojom::TCPConnectedSocketOptionsPtr tcp_connected_socket_options, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TCPConnectedSocket> socket, ::mojo::PendingRemote<::network::mojom::SocketObserver> observer, CreateTCPConnectedSocketCallback callback) final;
  
  void CreateTCPBoundSocket(const ::net::IPEndPoint& local_addr, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TCPBoundSocket> socket, CreateTCPBoundSocketCallback callback) final;
  
  void CreateProxyResolvingSocketFactory(::mojo::PendingReceiver<::network::mojom::ProxyResolvingSocketFactory> factory) final;
  
  void LookUpProxyForURL(const ::GURL& url, const ::net::NetworkAnonymizationKey& network_anonymization_key, ::mojo::PendingRemote<::network::mojom::ProxyLookupClient> proxy_lookup_client) final;
  
  void ForceReloadProxyConfig(ForceReloadProxyConfigCallback callback) final;
  
  void ClearBadProxiesCache(ClearBadProxiesCacheCallback callback) final;
  
  void CreateWebSocket(const ::GURL& url, const std::vector<std::string>& requested_protocols, const ::net::SiteForCookies& site_for_cookies, ::net::StorageAccessApiStatus storage_access_api_status, const ::net::IsolationInfo& isolation_info, std::vector<::network::mojom::HttpHeaderPtr> additional_headers, int32_t process_id, const ::url::Origin& origin, uint32_t options, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingRemote<::network::mojom::WebSocketHandshakeClient> handshake_client, ::mojo::PendingRemote<::network::mojom::URLLoaderNetworkServiceObserver> url_loader_network_observer, ::mojo::PendingRemote<::network::mojom::WebSocketAuthenticationHandler> auth_handler, ::mojo::PendingRemote<TrustedHeaderClient> header_client, const std::optional<::base::UnguessableToken>& throttling_profile_id) final;
  
  void CreateWebTransport(const ::GURL& url, const ::url::Origin& origin, const ::net::NetworkAnonymizationKey& network_anonymization_key, std::vector<::network::mojom::WebTransportCertificateFingerprintPtr> fingerprints, const std::vector<std::string>& application_protocols, ::mojo::PendingRemote<::network::mojom::WebTransportHandshakeClient> handshake_client) final;
  
  void CreateNetLogExporter(::mojo::PendingReceiver<::network::mojom::NetLogExporter> receiver) final;
  
  void PreconnectSockets(uint32_t num_streams, const ::GURL& url, ::network::mojom::CredentialsMode credentials_mode, const ::net::NetworkAnonymizationKey& network_anonymization_key, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, const std::optional<::net::ConnectionKeepAliveConfig>& keepalive_config, ::mojo::PendingRemote<::network::mojom::ConnectionChangeObserverClient> observer_client) final;
  
  void CreateP2PSocketManager(const ::net::NetworkAnonymizationKey& network_anonymization_key, ::mojo::PendingRemote<::network::mojom::P2PTrustedSocketManagerClient> client, ::mojo::PendingReceiver<::network::mojom::P2PTrustedSocketManager> trusted_socket_manager, ::mojo::PendingReceiver<::network::mojom::P2PSocketManager> socket_manager) final;
  
  void CreateMdnsResponder(::mojo::PendingReceiver<::network::mojom::MdnsResponder> responder_receiver) final;
  
  void ResolveHost(::network::mojom::HostResolverHostPtr host, const ::net::NetworkAnonymizationKey& network_anonymization_key, ::network::mojom::ResolveHostParametersPtr optional_parameters, ::mojo::PendingRemote<::network::mojom::ResolveHostClient> response_client) final;
  
  void CreateHostResolver(const std::optional<::net::DnsConfigOverrides>& config_overrides, ::mojo::PendingReceiver<::network::mojom::HostResolver> host_resolver) final;
  
  void VerifyCert(const ::scoped_refptr<::net::X509Certificate>& certificate, const ::net::HostPortPair& host_port, const std::string& ocsp_response, const std::string& sct_list, VerifyCertCallback callback) final;
  
  void VerifyCertForSignedExchange(const ::scoped_refptr<::net::X509Certificate>& certificate, const ::net::HostPortPair& host_port, const std::string& ocsp_response, const std::string& sct_list, VerifyCertForSignedExchangeCallback callback) final;
  
  void Verify2QwacCertBinding(const std::string& binding, const std::string& hostname, const ::scoped_refptr<::net::X509Certificate>& tls_certificate, Verify2QwacCertBindingCallback callback) final;
  
  void AddHSTS(const std::string& host, ::base::Time expiry, bool include_subdomains, AddHSTSCallback callback) final;
  
  void IsHSTSActiveForHost(const std::string& host, bool is_top_level_nav, IsHSTSActiveForHostCallback callback) final;
  
  void GetHSTSState(const std::string& domain, GetHSTSStateCallback callback) final;
  
  void SetCorsOriginAccessListsForOrigin(const ::url::Origin& source_origin, std::vector<::network::mojom::CorsOriginPatternPtr> allow_patterns, std::vector<::network::mojom::CorsOriginPatternPtr> block_patterns, SetCorsOriginAccessListsForOriginCallback callback) final;
  
  void DeleteDynamicDataForHost(const std::string& host, DeleteDynamicDataForHostCallback callback) final;
  
  void SetSplitAuthCacheByNetworkAnonymizationKey(bool split_auth_cache_by_network_anonymization_key) final;
  
  void SaveHttpAuthCacheProxyEntries(SaveHttpAuthCacheProxyEntriesCallback callback) final;
  
  void LoadHttpAuthCacheProxyEntries(const ::base::UnguessableToken& cache_key, LoadHttpAuthCacheProxyEntriesCallback callback) final;
  
  void AddAuthCacheEntry(const ::net::AuthChallengeInfo& challenge, const ::net::NetworkAnonymizationKey& network_anonymization_key, const ::net::AuthCredentials& credentials, AddAuthCacheEntryCallback callback) final;
  
  void SetCorsNonWildcardRequestHeadersSupport(bool value) final;
  
  void LookupServerBasicAuthCredentials(const ::GURL& url, const ::net::NetworkAnonymizationKey& network_anonymization_key, LookupServerBasicAuthCredentialsCallback callback) final;
  
  bool EnableStaticKeyPinningForTesting() final;
  
  void EnableStaticKeyPinningForTesting(EnableStaticKeyPinningForTestingCallback callback) final;
  
  void VerifyCertificateForTesting(const ::scoped_refptr<::net::X509Certificate>& certificate, const std::string& hostname, const std::string& ocsp_response, const std::string& sct_list, VerifyCertificateForTestingCallback callback) final;
  
  bool GetTrustAnchorIDsForTesting(std::vector<std::vector<uint8_t>>* out_trust_anchor_ids) final;
  
  void GetTrustAnchorIDsForTesting(GetTrustAnchorIDsForTestingCallback callback) final;
  
  bool AddDomainReliabilityContextForTesting(const ::url::Origin& origin, const ::GURL& upload_url) final;
  
  void AddDomainReliabilityContextForTesting(const ::url::Origin& origin, const ::GURL& upload_url, AddDomainReliabilityContextForTestingCallback callback) final;
  
  bool ForceDomainReliabilityUploadsForTesting() final;
  
  void ForceDomainReliabilityUploadsForTesting(ForceDomainReliabilityUploadsForTestingCallback callback) final;
  
  void SetSCTAuditingMode(SCTAuditingMode mode) final;
  
  void GetSharedDictionaryUsageInfo(GetSharedDictionaryUsageInfoCallback callback) final;
  
  void GetSharedDictionaryInfo(const ::net::SharedDictionaryIsolationKey& isolation_key, GetSharedDictionaryInfoCallback callback) final;
  
  void GetSharedDictionaryOriginsBetween(::base::Time start_time, ::base::Time end_time, GetSharedDictionaryOriginsBetweenCallback callback) final;
  
  void SetSharedDictionaryCacheMaxSize(uint64_t cache_max_size) final;
  
  void PreloadSharedDictionaryInfoForDocument(const std::vector<::GURL>& urls, ::mojo::PendingReceiver<PreloadedSharedDictionaryInfoHandle> preload_handle) final;
  
  void HasPreloadedSharedDictionaryInfoForTesting(HasPreloadedSharedDictionaryInfoForTestingCallback callback) final;
  
  void ResourceSchedulerClientVisibilityChanged(const ::base::UnguessableToken& client_token, bool visible) final;
  
  void FlushCachedClientCertIfNeeded(const ::net::HostPortPair& host, const ::scoped_refptr<::net::X509Certificate>& certificate) final;
  
  void FlushMatchingCachedClientCert(const ::scoped_refptr<::net::X509Certificate>& certificate) final;
  
  void SetCookieDeprecationLabel(const std::optional<std::string>& label) final;
  
  void RevokeNetworkForNonces(const std::vector<::base::UnguessableToken>& nonces, RevokeNetworkForNoncesCallback callback) final;
  
  void ClearNonces(const std::vector<::base::UnguessableToken>& nonces) final;
  
  void ExemptUrlFromNetworkRevocationForNonce(const ::GURL& exempted_url, const ::base::UnguessableToken& nonce, ExemptUrlFromNetworkRevocationForNonceCallback callback) final;
  
  void Prefetch(int32_t request_id, uint32_t options, const ::network::ResourceRequest& request, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation) final;
  
  void GetBoundNetworkForTesting(GetBoundNetworkForTestingCallback callback) final;
  
  void GetDeviceBoundSessionManager(::mojo::PendingReceiver<::network::mojom::DeviceBoundSessionManager> device_bound_session_manager) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  CustomProxyConnectionObserverStubDispatch {
 public:
  static bool Accept(CustomProxyConnectionObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CustomProxyConnectionObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CustomProxyConnectionObserver>>
class CustomProxyConnectionObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CustomProxyConnectionObserverStub() = default;
  ~CustomProxyConnectionObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CustomProxyConnectionObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CustomProxyConnectionObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CustomProxyConfigClientStubDispatch {
 public:
  static bool Accept(CustomProxyConfigClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CustomProxyConfigClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CustomProxyConfigClient>>
class CustomProxyConfigClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CustomProxyConfigClientStub() = default;
  ~CustomProxyConfigClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CustomProxyConfigClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CustomProxyConfigClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  TrustedHeaderClientStubDispatch {
 public:
  static bool Accept(TrustedHeaderClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      TrustedHeaderClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<TrustedHeaderClient>>
class TrustedHeaderClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  TrustedHeaderClientStub() = default;
  ~TrustedHeaderClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TrustedHeaderClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TrustedHeaderClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  TrustedURLLoaderHeaderClientStubDispatch {
 public:
  static bool Accept(TrustedURLLoaderHeaderClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      TrustedURLLoaderHeaderClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<TrustedURLLoaderHeaderClient>>
class TrustedURLLoaderHeaderClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  TrustedURLLoaderHeaderClientStub() = default;
  ~TrustedURLLoaderHeaderClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TrustedURLLoaderHeaderClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TrustedURLLoaderHeaderClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PreloadedSharedDictionaryInfoHandleStubDispatch {
 public:
  static bool Accept(PreloadedSharedDictionaryInfoHandle* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PreloadedSharedDictionaryInfoHandle* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PreloadedSharedDictionaryInfoHandle>>
class PreloadedSharedDictionaryInfoHandleStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PreloadedSharedDictionaryInfoHandleStub() = default;
  ~PreloadedSharedDictionaryInfoHandleStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PreloadedSharedDictionaryInfoHandleStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PreloadedSharedDictionaryInfoHandleStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  NetworkContextStubDispatch {
 public:
  static bool Accept(NetworkContext* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NetworkContext* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NetworkContext>>
class NetworkContextStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NetworkContextStub() = default;
  ~NetworkContextStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetworkContextStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetworkContextStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CustomProxyConnectionObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CustomProxyConfigClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  TrustedHeaderClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  TrustedURLLoaderHeaderClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PreloadedSharedDictionaryInfoHandleRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  NetworkContextRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CustomProxyConfigClientResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  TrustedHeaderClientResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  NetworkContextResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};







class  HttpAuthStaticNetworkContextParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HttpAuthStaticNetworkContextParams, T>::value>;
  using DataView = HttpAuthStaticNetworkContextParamsDataView;
  using Data_ = internal::HttpAuthStaticNetworkContextParams_Data;

  template <typename... Args>
  static HttpAuthStaticNetworkContextParamsPtr New(Args&&... args) {
    return HttpAuthStaticNetworkContextParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HttpAuthStaticNetworkContextParamsPtr From(const U& u) {
    return mojo::TypeConverter<HttpAuthStaticNetworkContextParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HttpAuthStaticNetworkContextParams>::Convert(*this);
  }


  HttpAuthStaticNetworkContextParams();

  explicit HttpAuthStaticNetworkContextParams(
      ::net::HttpAuthPreferences::DefaultCredentials allow_default_credentials);


  ~HttpAuthStaticNetworkContextParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HttpAuthStaticNetworkContextParamsPtr>
  HttpAuthStaticNetworkContextParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HttpAuthStaticNetworkContextParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HttpAuthStaticNetworkContextParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HttpAuthStaticNetworkContextParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HttpAuthStaticNetworkContextParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HttpAuthStaticNetworkContextParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HttpAuthStaticNetworkContextParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HttpAuthStaticNetworkContextParams_UnserializedMessageContext<
            UserType, HttpAuthStaticNetworkContextParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HttpAuthStaticNetworkContextParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HttpAuthStaticNetworkContextParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HttpAuthStaticNetworkContextParams_UnserializedMessageContext<
            UserType, HttpAuthStaticNetworkContextParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HttpAuthStaticNetworkContextParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::net::HttpAuthPreferences::DefaultCredentials allow_default_credentials;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HttpAuthStaticNetworkContextParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HttpAuthStaticNetworkContextParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HttpAuthStaticNetworkContextParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HttpAuthStaticNetworkContextParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}















class  CustomProxyConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CustomProxyConfig, T>::value>;
  using DataView = CustomProxyConfigDataView;
  using Data_ = internal::CustomProxyConfig_Data;

  template <typename... Args>
  static CustomProxyConfigPtr New(Args&&... args) {
    return CustomProxyConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CustomProxyConfigPtr From(const U& u) {
    return mojo::TypeConverter<CustomProxyConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CustomProxyConfig>::Convert(*this);
  }


  CustomProxyConfig();

  CustomProxyConfig(
      const ::net::ProxyConfig::ProxyRules& rules,
      bool should_override_existing_config,
      bool allow_non_idempotent_methods,
      const ::net::HttpRequestHeaders& connect_tunnel_headers);


  ~CustomProxyConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CustomProxyConfigPtr>
  CustomProxyConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CustomProxyConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CustomProxyConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CustomProxyConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CustomProxyConfig::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CustomProxyConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CustomProxyConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CustomProxyConfig_UnserializedMessageContext<
            UserType, CustomProxyConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CustomProxyConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CustomProxyConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CustomProxyConfig_UnserializedMessageContext<
            UserType, CustomProxyConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CustomProxyConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::net::ProxyConfig::ProxyRules rules;
  
  bool should_override_existing_config;
  
  bool allow_non_idempotent_methods;
  
  ::net::HttpRequestHeaders connect_tunnel_headers;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CustomProxyConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CustomProxyConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CustomProxyConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CustomProxyConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  CertVerifierServiceRemoteParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CertVerifierServiceRemoteParams, T>::value>;
  using DataView = CertVerifierServiceRemoteParamsDataView;
  using Data_ = internal::CertVerifierServiceRemoteParams_Data;

  template <typename... Args>
  static CertVerifierServiceRemoteParamsPtr New(Args&&... args) {
    return CertVerifierServiceRemoteParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CertVerifierServiceRemoteParamsPtr From(const U& u) {
    return mojo::TypeConverter<CertVerifierServiceRemoteParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CertVerifierServiceRemoteParams>::Convert(*this);
  }


  CertVerifierServiceRemoteParams();

  CertVerifierServiceRemoteParams(
      ::mojo::PendingRemote<::cert_verifier::mojom::CertVerifierService> cert_verifier_service,
      ::mojo::PendingReceiver<::cert_verifier::mojom::CertVerifierServiceClient> cert_verifier_service_client_receiver);

CertVerifierServiceRemoteParams(const CertVerifierServiceRemoteParams&) = delete;
CertVerifierServiceRemoteParams& operator=(const CertVerifierServiceRemoteParams&) = delete;

  ~CertVerifierServiceRemoteParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CertVerifierServiceRemoteParamsPtr>
  CertVerifierServiceRemoteParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CertVerifierServiceRemoteParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CertVerifierServiceRemoteParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CertVerifierServiceRemoteParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CertVerifierServiceRemoteParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CertVerifierServiceRemoteParams_UnserializedMessageContext<
            UserType, CertVerifierServiceRemoteParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CertVerifierServiceRemoteParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CertVerifierServiceRemoteParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CertVerifierServiceRemoteParams_UnserializedMessageContext<
            UserType, CertVerifierServiceRemoteParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CertVerifierServiceRemoteParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingRemote<::cert_verifier::mojom::CertVerifierService> cert_verifier_service;
  
  ::mojo::PendingReceiver<::cert_verifier::mojom::CertVerifierServiceClient> cert_verifier_service_client_receiver;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CertVerifierServiceRemoteParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CertVerifierServiceRemoteParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CertVerifierServiceRemoteParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CertVerifierServiceRemoteParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  CTPolicy {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CTPolicy, T>::value>;
  using DataView = CTPolicyDataView;
  using Data_ = internal::CTPolicy_Data;

  template <typename... Args>
  static CTPolicyPtr New(Args&&... args) {
    return CTPolicyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CTPolicyPtr From(const U& u) {
    return mojo::TypeConverter<CTPolicyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CTPolicy>::Convert(*this);
  }


  CTPolicy();

  CTPolicy(
      std::vector<std::string> excluded_hosts,
      std::vector<std::string> excluded_spkis);


  ~CTPolicy();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CTPolicyPtr>
  CTPolicyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CTPolicy::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CTPolicy::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CTPolicy::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CTPolicy::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CTPolicy::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CTPolicy::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CTPolicy_UnserializedMessageContext<
            UserType, CTPolicy::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CTPolicy::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CTPolicy::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CTPolicy_UnserializedMessageContext<
            UserType, CTPolicy::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CTPolicy::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<std::string> excluded_hosts;
  
  std::vector<std::string> excluded_spkis;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CTPolicy::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CTPolicy::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CTPolicy::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CTPolicy::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  NetworkContextFilePaths {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NetworkContextFilePaths, T>::value>;
  using DataView = NetworkContextFilePathsDataView;
  using Data_ = internal::NetworkContextFilePaths_Data;

  template <typename... Args>
  static NetworkContextFilePathsPtr New(Args&&... args) {
    return NetworkContextFilePathsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NetworkContextFilePathsPtr From(const U& u) {
    return mojo::TypeConverter<NetworkContextFilePathsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NetworkContextFilePaths>::Convert(*this);
  }


  NetworkContextFilePaths();

  NetworkContextFilePaths(
      std::optional<::network::TransferableDirectory> shared_dictionary_directory,
      std::optional<::network::TransferableDirectory> http_cache_directory,
      std::optional<::network::TransferableDirectory> no_vary_search_directory,
      ::network::TransferableDirectory data_directory,
      const std::optional<::base::FilePath>& unsandboxed_data_path,
      const std::optional<::base::FilePath>& cookie_database_name,
      const std::optional<::base::FilePath>& device_bound_sessions_database_name,
      const std::optional<::base::FilePath>& trust_token_database_name,
      const std::optional<::base::FilePath>& http_server_properties_file_name,
      const std::optional<::base::FilePath>& transport_security_persister_file_name,
      const std::optional<::base::FilePath>& reporting_and_nel_store_database_name,
      const std::optional<::base::FilePath>& sct_auditing_pending_reports_file_name,
      bool trigger_migration);

NetworkContextFilePaths(const NetworkContextFilePaths&) = delete;
NetworkContextFilePaths& operator=(const NetworkContextFilePaths&) = delete;

  ~NetworkContextFilePaths();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NetworkContextFilePathsPtr>
  NetworkContextFilePathsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NetworkContextFilePaths::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NetworkContextFilePaths::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NetworkContextFilePaths::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NetworkContextFilePaths::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NetworkContextFilePaths_UnserializedMessageContext<
            UserType, NetworkContextFilePaths::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NetworkContextFilePaths::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NetworkContextFilePaths::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NetworkContextFilePaths_UnserializedMessageContext<
            UserType, NetworkContextFilePaths::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NetworkContextFilePaths::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::network::TransferableDirectory> shared_dictionary_directory;
  
  std::optional<::network::TransferableDirectory> http_cache_directory;
  
  std::optional<::network::TransferableDirectory> no_vary_search_directory;
  
  ::network::TransferableDirectory data_directory;
  
  std::optional<::base::FilePath> unsandboxed_data_path;
  
  std::optional<::base::FilePath> cookie_database_name;
  
  std::optional<::base::FilePath> device_bound_sessions_database_name;
  
  std::optional<::base::FilePath> trust_token_database_name;
  
  std::optional<::base::FilePath> http_server_properties_file_name;
  
  std::optional<::base::FilePath> transport_security_persister_file_name;
  
  std::optional<::base::FilePath> reporting_and_nel_store_database_name;
  
  std::optional<::base::FilePath> sct_auditing_pending_reports_file_name;
  
  bool trigger_migration;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NetworkContextFilePaths::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NetworkContextFilePaths::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NetworkContextFilePaths::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NetworkContextFilePaths::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  NetworkContextParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NetworkContextParams, T>::value>;
  using DataView = NetworkContextParamsDataView;
  using Data_ = internal::NetworkContextParams_Data;

  template <typename... Args>
  static NetworkContextParamsPtr New(Args&&... args) {
    return NetworkContextParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NetworkContextParamsPtr From(const U& u) {
    return mojo::TypeConverter<NetworkContextParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NetworkContextParams>::Convert(*this);
  }


  NetworkContextParams();

  NetworkContextParams(
      const std::string& user_agent,
      const std::string& accept_language,
      bool enable_brotli,
      bool enable_zstd,
      bool enable_referrers,
      bool validate_referrer_policy_on_initial_request,
      ::mojo::PendingRemote<::proxy_resolver::mojom::ProxyResolverFactory> proxy_resolver_factory,
      bool enable_encrypted_cookies,
      bool restore_old_session_cookies,
      bool persist_session_cookies,
      bool http_cache_enabled,
      int32_t http_cache_max_size,
      ::mojo::PendingRemote<::network::mojom::HttpCacheBackendFileOperationsFactory> http_cache_file_operations_factory,
      bool disable_idle_sockets_close_on_memory_pressure,
      ::network::mojom::SSLConfigPtr initial_ssl_config,
      ::mojo::PendingReceiver<::network::mojom::SSLConfigClient> ssl_config_client_receiver,
      const std::optional<::net::ProxyConfigWithAnnotation>& initial_proxy_config,
      ::mojo::PendingReceiver<::network::mojom::ProxyConfigClient> proxy_config_client_receiver,
      CustomProxyConfigPtr initial_custom_proxy_config,
      ::mojo::PendingReceiver<CustomProxyConfigClient> custom_proxy_config_client_receiver,
      ::mojo::PendingRemote<CustomProxyConnectionObserver> custom_proxy_connection_observer_remote,
      ::mojo::PendingRemote<::network::mojom::ProxyConfigPollerClient> proxy_config_poller_client,
      ::mojo::PendingRemote<::network::mojom::ProxyErrorClient> proxy_error_client,
      ::mojo::PendingRemote<::ip_protection::mojom::CoreHost> ip_protection_core_host,
      ::mojo::PendingReceiver<::ip_protection::mojom::CoreControl> ip_protection_control,
      bool enable_ip_protection,
      bool ip_protection_incognito,
      const std::optional<::base::FilePath>& ip_protection_data_directory,
      bool pac_quick_check_enabled,
      bool enable_certificate_reporting,
      bool enforce_chrome_ct_policy,
      SCTAuditingMode sct_auditing_mode,
      CTPolicyPtr ct_policy,
      CertVerifierServiceRemoteParamsPtr cert_verifier_params,
      ::network::mojom::CookieManagerParamsPtr cookie_manager_params,
      ::mojo::PendingReceiver<::network::mojom::CookieManager> cookie_manager,
      bool enable_domain_reliability,
      const std::string& domain_reliability_upload_reporter,
      bool discard_domain_reliablity_uploads,
      std::optional<::base::TimeDelta> reporting_delivery_interval,
      bool skip_reporting_send_permission_check,
      std::vector<::network::mojom::CorsOriginAccessPatternsPtr> cors_origin_access_list,
      std::vector<std::string> cors_exempt_header_list,
      bool allow_any_cors_exempt_header_for_browser,
      std::vector<std::string> hsts_policy_bypass_list,
      HttpAuthStaticNetworkContextParamsPtr http_auth_static_network_context_params,
      bool reset_http_cache_backend,
      bool split_auth_cache_by_network_anonymization_key,
      bool require_network_anonymization_key,
      NetworkContextFilePathsPtr file_paths,
      bool block_trust_tokens,
      bool shared_dictionary_enabled,
      uint64_t shared_dictionary_cache_max_size,
      ::network::mojom::FirstPartySetsAccessDelegateParamsPtr first_party_sets_access_delegate_params,
      ::mojo::PendingReceiver<::network::mojom::FirstPartySetsAccessDelegate> first_party_sets_access_delegate_receiver,
      bool acam_preflight_spec_conformant,
      const std::optional<std::string>& cookie_deprecation_label,
      ::mojo::PendingRemote<::network::mojom::CookieEncryptionProvider> cookie_encryption_provider,
      bool device_bound_sessions_enabled,
      int64_t bound_network,
      const std::optional<base::flat_map<std::string, ::GURL>>& enterprise_reporting_endpoints,
      std::optional<int64_t> quic_idle_connection_timeout_seconds);

NetworkContextParams(const NetworkContextParams&) = delete;
NetworkContextParams& operator=(const NetworkContextParams&) = delete;

  ~NetworkContextParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NetworkContextParamsPtr>
  NetworkContextParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NetworkContextParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NetworkContextParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NetworkContextParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NetworkContextParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NetworkContextParams_UnserializedMessageContext<
            UserType, NetworkContextParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NetworkContextParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NetworkContextParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NetworkContextParams_UnserializedMessageContext<
            UserType, NetworkContextParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NetworkContextParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string user_agent;
  
  std::string accept_language;
  
  bool enable_brotli;
  
  bool enable_zstd;
  
  bool enable_referrers;
  
  bool validate_referrer_policy_on_initial_request;
  
  ::mojo::PendingRemote<::proxy_resolver::mojom::ProxyResolverFactory> proxy_resolver_factory;
  
  bool enable_encrypted_cookies;
  
  bool restore_old_session_cookies;
  
  bool persist_session_cookies;
  
  bool http_cache_enabled;
  
  int32_t http_cache_max_size;
  
  ::mojo::PendingRemote<::network::mojom::HttpCacheBackendFileOperationsFactory> http_cache_file_operations_factory;
  
  bool disable_idle_sockets_close_on_memory_pressure;
  
  ::network::mojom::SSLConfigPtr initial_ssl_config;
  
  ::mojo::PendingReceiver<::network::mojom::SSLConfigClient> ssl_config_client_receiver;
  
  std::optional<::net::ProxyConfigWithAnnotation> initial_proxy_config;
  
  ::mojo::PendingReceiver<::network::mojom::ProxyConfigClient> proxy_config_client_receiver;
  
  CustomProxyConfigPtr initial_custom_proxy_config;
  
  ::mojo::PendingReceiver<CustomProxyConfigClient> custom_proxy_config_client_receiver;
  
  ::mojo::PendingRemote<CustomProxyConnectionObserver> custom_proxy_connection_observer_remote;
  
  ::mojo::PendingRemote<::network::mojom::ProxyConfigPollerClient> proxy_config_poller_client;
  
  ::mojo::PendingRemote<::network::mojom::ProxyErrorClient> proxy_error_client;
  
  ::mojo::PendingRemote<::ip_protection::mojom::CoreHost> ip_protection_core_host;
  
  ::mojo::PendingReceiver<::ip_protection::mojom::CoreControl> ip_protection_control;
  
  bool enable_ip_protection;
  
  bool ip_protection_incognito;
  
  std::optional<::base::FilePath> ip_protection_data_directory;
  
  bool pac_quick_check_enabled;
  
  bool enable_certificate_reporting;
  
  bool enforce_chrome_ct_policy;
  
  SCTAuditingMode sct_auditing_mode;
  
  CTPolicyPtr ct_policy;
  
  CertVerifierServiceRemoteParamsPtr cert_verifier_params;
  
  ::network::mojom::CookieManagerParamsPtr cookie_manager_params;
  
  ::mojo::PendingReceiver<::network::mojom::CookieManager> cookie_manager;
  
  bool enable_domain_reliability;
  
  std::string domain_reliability_upload_reporter;
  
  bool discard_domain_reliablity_uploads;
  
  std::optional<::base::TimeDelta> reporting_delivery_interval;
  
  bool skip_reporting_send_permission_check;
  
  std::vector<::network::mojom::CorsOriginAccessPatternsPtr> cors_origin_access_list;
  
  std::vector<std::string> cors_exempt_header_list;
  
  bool allow_any_cors_exempt_header_for_browser;
  
  std::vector<std::string> hsts_policy_bypass_list;
  
  HttpAuthStaticNetworkContextParamsPtr http_auth_static_network_context_params;
  
  bool reset_http_cache_backend;
  
  bool split_auth_cache_by_network_anonymization_key;
  
  bool require_network_anonymization_key;
  
  NetworkContextFilePathsPtr file_paths;
  
  bool block_trust_tokens;
  
  bool shared_dictionary_enabled;
  
  uint64_t shared_dictionary_cache_max_size;
  
  ::network::mojom::FirstPartySetsAccessDelegateParamsPtr first_party_sets_access_delegate_params;
  
  ::mojo::PendingReceiver<::network::mojom::FirstPartySetsAccessDelegate> first_party_sets_access_delegate_receiver;
  
  bool acam_preflight_spec_conformant;
  
  std::optional<std::string> cookie_deprecation_label;
  
  ::mojo::PendingRemote<::network::mojom::CookieEncryptionProvider> cookie_encryption_provider;
  
  bool device_bound_sessions_enabled;
  
  int64_t bound_network;
  
  std::optional<base::flat_map<std::string, ::GURL>> enterprise_reporting_endpoints;
  
  std::optional<int64_t> quic_idle_connection_timeout_seconds;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NetworkContextParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NetworkContextParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NetworkContextParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NetworkContextParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  NetworkConditions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NetworkConditions, T>::value>;
  using DataView = NetworkConditionsDataView;
  using Data_ = internal::NetworkConditions_Data;

  template <typename... Args>
  static NetworkConditionsPtr New(Args&&... args) {
    return NetworkConditionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NetworkConditionsPtr From(const U& u) {
    return mojo::TypeConverter<NetworkConditionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NetworkConditions>::Convert(*this);
  }


  NetworkConditions();

  NetworkConditions(
      bool offline,
      ::base::TimeDelta latency,
      double download_throughput,
      double upload_throughput,
      double packet_loss,
      int32_t packet_queue_length,
      bool packet_reordering);


  ~NetworkConditions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NetworkConditionsPtr>
  NetworkConditionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NetworkConditions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NetworkConditions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NetworkConditions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NetworkConditions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NetworkConditions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NetworkConditions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NetworkConditions_UnserializedMessageContext<
            UserType, NetworkConditions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NetworkConditions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NetworkConditions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NetworkConditions_UnserializedMessageContext<
            UserType, NetworkConditions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NetworkConditions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool offline;
  
  ::base::TimeDelta latency;
  
  double download_throughput;
  
  double upload_throughput;
  
  double packet_loss;
  
  int32_t packet_queue_length;
  
  bool packet_reordering;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NetworkConditions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NetworkConditions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NetworkConditions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NetworkConditions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SharedDictionaryInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SharedDictionaryInfo, T>::value>;
  using DataView = SharedDictionaryInfoDataView;
  using Data_ = internal::SharedDictionaryInfo_Data;

  template <typename... Args>
  static SharedDictionaryInfoPtr New(Args&&... args) {
    return SharedDictionaryInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SharedDictionaryInfoPtr From(const U& u) {
    return mojo::TypeConverter<SharedDictionaryInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedDictionaryInfo>::Convert(*this);
  }


  SharedDictionaryInfo();

  SharedDictionaryInfo(
      const std::string& match,
      std::vector<::network::mojom::RequestDestination> match_dest,
      const std::string& id,
      const ::GURL& dictionary_url,
      ::base::Time last_fetch_time,
      ::base::Time response_time,
      ::base::TimeDelta expiration,
      ::base::Time last_used_time,
      uint64_t size,
      const ::net::SHA256HashValue& hash);


  ~SharedDictionaryInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SharedDictionaryInfoPtr>
  SharedDictionaryInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SharedDictionaryInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SharedDictionaryInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SharedDictionaryInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedDictionaryInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedDictionaryInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedDictionaryInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SharedDictionaryInfo_UnserializedMessageContext<
            UserType, SharedDictionaryInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SharedDictionaryInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SharedDictionaryInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SharedDictionaryInfo_UnserializedMessageContext<
            UserType, SharedDictionaryInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SharedDictionaryInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string match;
  
  std::vector<::network::mojom::RequestDestination> match_dest;
  
  std::string id;
  
  ::GURL dictionary_url;
  
  ::base::Time last_fetch_time;
  
  ::base::Time response_time;
  
  ::base::TimeDelta expiration;
  
  ::base::Time last_used_time;
  
  uint64_t size;
  
  ::net::SHA256HashValue hash;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SharedDictionaryInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SharedDictionaryInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SharedDictionaryInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SharedDictionaryInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SignedExchangeReport {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SignedExchangeReport, T>::value>;
  using DataView = SignedExchangeReportDataView;
  using Data_ = internal::SignedExchangeReport_Data;

  template <typename... Args>
  static SignedExchangeReportPtr New(Args&&... args) {
    return SignedExchangeReportPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SignedExchangeReportPtr From(const U& u) {
    return mojo::TypeConverter<SignedExchangeReportPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SignedExchangeReport>::Convert(*this);
  }


  SignedExchangeReport();

  SignedExchangeReport(
      bool success,
      const std::string& type,
      const ::GURL& outer_url,
      const ::GURL& inner_url,
      const ::GURL& cert_url,
      const std::string& referrer,
      const ::net::IPAddress& server_ip_address,
      const std::string& protocol,
      const std::string& method,
      int32_t status_code,
      ::base::TimeDelta elapsed_time);


  ~SignedExchangeReport();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SignedExchangeReportPtr>
  SignedExchangeReportPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SignedExchangeReport::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SignedExchangeReport::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SignedExchangeReport::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SignedExchangeReport::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SignedExchangeReport::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SignedExchangeReport::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SignedExchangeReport_UnserializedMessageContext<
            UserType, SignedExchangeReport::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SignedExchangeReport::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SignedExchangeReport::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SignedExchangeReport_UnserializedMessageContext<
            UserType, SignedExchangeReport::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SignedExchangeReport::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool success;
  
  std::string type;
  
  ::GURL outer_url;
  
  ::GURL inner_url;
  
  ::GURL cert_url;
  
  std::string referrer;
  
  ::net::IPAddress server_ip_address;
  
  std::string protocol;
  
  std::string method;
  
  int32_t status_code;
  
  ::base::TimeDelta elapsed_time;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SignedExchangeReport::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SignedExchangeReport::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SignedExchangeReport::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SignedExchangeReport::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  URLLoaderFactoryOverride {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<URLLoaderFactoryOverride, T>::value>;
  using DataView = URLLoaderFactoryOverrideDataView;
  using Data_ = internal::URLLoaderFactoryOverride_Data;

  template <typename... Args>
  static URLLoaderFactoryOverridePtr New(Args&&... args) {
    return URLLoaderFactoryOverridePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static URLLoaderFactoryOverridePtr From(const U& u) {
    return mojo::TypeConverter<URLLoaderFactoryOverridePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, URLLoaderFactoryOverride>::Convert(*this);
  }


  URLLoaderFactoryOverride();

  URLLoaderFactoryOverride(
      ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> overriding_factory,
      ::mojo::PendingReceiver<::network::mojom::URLLoaderFactory> overridden_factory_receiver,
      bool skip_cors_enabled_scheme_check);

URLLoaderFactoryOverride(const URLLoaderFactoryOverride&) = delete;
URLLoaderFactoryOverride& operator=(const URLLoaderFactoryOverride&) = delete;

  ~URLLoaderFactoryOverride();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = URLLoaderFactoryOverridePtr>
  URLLoaderFactoryOverridePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, URLLoaderFactoryOverride::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, URLLoaderFactoryOverride::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, URLLoaderFactoryOverride::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        URLLoaderFactoryOverride::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::URLLoaderFactoryOverride_UnserializedMessageContext<
            UserType, URLLoaderFactoryOverride::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<URLLoaderFactoryOverride::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return URLLoaderFactoryOverride::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::URLLoaderFactoryOverride_UnserializedMessageContext<
            UserType, URLLoaderFactoryOverride::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<URLLoaderFactoryOverride::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> overriding_factory;
  
  ::mojo::PendingReceiver<::network::mojom::URLLoaderFactory> overridden_factory_receiver;
  
  bool skip_cors_enabled_scheme_check;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, URLLoaderFactoryOverride::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, URLLoaderFactoryOverride::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, URLLoaderFactoryOverride::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, URLLoaderFactoryOverride::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  URLLoaderFactoryParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<URLLoaderFactoryParams, T>::value>;
  using DataView = URLLoaderFactoryParamsDataView;
  using Data_ = internal::URLLoaderFactoryParams_Data;

  template <typename... Args>
  static URLLoaderFactoryParamsPtr New(Args&&... args) {
    return URLLoaderFactoryParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static URLLoaderFactoryParamsPtr From(const U& u) {
    return mojo::TypeConverter<URLLoaderFactoryParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, URLLoaderFactoryParams>::Convert(*this);
  }


  URLLoaderFactoryParams();

  URLLoaderFactoryParams(
      int32_t process_id,
      const std::optional<::url::Origin>& request_initiator_origin_lock,
      bool is_orb_enabled,
      bool ignore_isolated_world_origin,
      bool unsafe_non_webby_initiator,
      bool disable_web_security,
      ::mojo::PendingRemote<TrustedURLLoaderHeaderClient> header_client,
      const ::net::IsolationInfo& isolation_info,
      bool disable_secure_dns,
      bool is_trusted,
      bool automatically_assign_isolation_info,
      const std::optional<::base::UnguessableToken>& top_frame_id,
      URLLoaderFactoryOverridePtr factory_override,
      ::network::mojom::ClientSecurityStatePtr client_security_state,
      ::mojo::PendingRemote<::network::mojom::CrossOriginEmbedderPolicyReporter> coep_reporter,
      ::mojo::PendingRemote<::network::mojom::DocumentIsolationPolicyReporter> dip_reporter,
      ::mojo::PendingRemote<::network::mojom::CookieAccessObserver> cookie_observer,
      ::mojo::PendingRemote<::network::mojom::TrustTokenAccessObserver> trust_token_observer,
      ::mojo::PendingRemote<::network::mojom::SharedDictionaryAccessObserver> shared_dictionary_observer,
      ::mojo::PendingRemote<::network::mojom::URLLoaderNetworkServiceObserver> url_loader_network_observer,
      ::mojo::PendingRemote<::network::mojom::DevToolsObserver> devtools_observer,
      ::mojo::PendingRemote<::network::mojom::DeviceBoundSessionAccessObserver> device_bound_session_observer,
      TrustTokenOperationPolicyVerdict trust_token_issuance_policy,
      TrustTokenOperationPolicyVerdict trust_token_redemption_policy,
      const std::string& debug_tag,
      const ::net::CookieSettingOverrides& cookie_setting_overrides,
      const ::net::CookieSettingOverrides& devtools_cookie_setting_overrides,
      bool require_cross_site_request_for_cookies,
      bool ignore_factory_reset);

URLLoaderFactoryParams(const URLLoaderFactoryParams&) = delete;
URLLoaderFactoryParams& operator=(const URLLoaderFactoryParams&) = delete;

  ~URLLoaderFactoryParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = URLLoaderFactoryParamsPtr>
  URLLoaderFactoryParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, URLLoaderFactoryParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, URLLoaderFactoryParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, URLLoaderFactoryParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        URLLoaderFactoryParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::URLLoaderFactoryParams_UnserializedMessageContext<
            UserType, URLLoaderFactoryParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<URLLoaderFactoryParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return URLLoaderFactoryParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::URLLoaderFactoryParams_UnserializedMessageContext<
            UserType, URLLoaderFactoryParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<URLLoaderFactoryParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t process_id;
  
  std::optional<::url::Origin> request_initiator_origin_lock;
  
  bool is_orb_enabled;
  
  bool ignore_isolated_world_origin;
  
  bool unsafe_non_webby_initiator;
  
  bool disable_web_security;
  
  ::mojo::PendingRemote<TrustedURLLoaderHeaderClient> header_client;
  
  ::net::IsolationInfo isolation_info;
  
  bool disable_secure_dns;
  
  bool is_trusted;
  
  bool automatically_assign_isolation_info;
  
  std::optional<::base::UnguessableToken> top_frame_id;
  
  URLLoaderFactoryOverridePtr factory_override;
  
  ::network::mojom::ClientSecurityStatePtr client_security_state;
  
  ::mojo::PendingRemote<::network::mojom::CrossOriginEmbedderPolicyReporter> coep_reporter;
  
  ::mojo::PendingRemote<::network::mojom::DocumentIsolationPolicyReporter> dip_reporter;
  
  ::mojo::PendingRemote<::network::mojom::CookieAccessObserver> cookie_observer;
  
  ::mojo::PendingRemote<::network::mojom::TrustTokenAccessObserver> trust_token_observer;
  
  ::mojo::PendingRemote<::network::mojom::SharedDictionaryAccessObserver> shared_dictionary_observer;
  
  ::mojo::PendingRemote<::network::mojom::URLLoaderNetworkServiceObserver> url_loader_network_observer;
  
  ::mojo::PendingRemote<::network::mojom::DevToolsObserver> devtools_observer;
  
  ::mojo::PendingRemote<::network::mojom::DeviceBoundSessionAccessObserver> device_bound_session_observer;
  
  TrustTokenOperationPolicyVerdict trust_token_issuance_policy;
  
  TrustTokenOperationPolicyVerdict trust_token_redemption_policy;
  
  std::string debug_tag;
  
  ::net::CookieSettingOverrides cookie_setting_overrides;
  
  ::net::CookieSettingOverrides devtools_cookie_setting_overrides;
  
  bool require_cross_site_request_for_cookies;
  
  bool ignore_factory_reset;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, URLLoaderFactoryParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, URLLoaderFactoryParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, URLLoaderFactoryParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, URLLoaderFactoryParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
CustomProxyConfigPtr CustomProxyConfig::Clone() const {
  return New(
      mojo::Clone(rules),
      mojo::Clone(should_override_existing_config),
      mojo::Clone(allow_non_idempotent_methods),
      mojo::Clone(connect_tunnel_headers)
  );
}

template <typename T, CustomProxyConfig::EnableIfSame<T>*>
bool CustomProxyConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->rules, other_struct.rules))
    return false;
  if (!mojo::Equals(this->should_override_existing_config, other_struct.should_override_existing_config))
    return false;
  if (!mojo::Equals(this->allow_non_idempotent_methods, other_struct.allow_non_idempotent_methods))
    return false;
  if (!mojo::Equals(this->connect_tunnel_headers, other_struct.connect_tunnel_headers))
    return false;
  return true;
}

template <typename T, CustomProxyConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.rules < rhs.rules)
    return true;
  if (rhs.rules < lhs.rules)
    return false;
  if (lhs.should_override_existing_config < rhs.should_override_existing_config)
    return true;
  if (rhs.should_override_existing_config < lhs.should_override_existing_config)
    return false;
  if (lhs.allow_non_idempotent_methods < rhs.allow_non_idempotent_methods)
    return true;
  if (rhs.allow_non_idempotent_methods < lhs.allow_non_idempotent_methods)
    return false;
  if (lhs.connect_tunnel_headers < rhs.connect_tunnel_headers)
    return true;
  if (rhs.connect_tunnel_headers < lhs.connect_tunnel_headers)
    return false;
  return false;
}
template <typename StructPtrType>
CertVerifierServiceRemoteParamsPtr CertVerifierServiceRemoteParams::Clone() const {
  return New(
      mojo::Clone(cert_verifier_service),
      mojo::Clone(cert_verifier_service_client_receiver)
  );
}

template <typename T, CertVerifierServiceRemoteParams::EnableIfSame<T>*>
bool CertVerifierServiceRemoteParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->cert_verifier_service, other_struct.cert_verifier_service))
    return false;
  if (!mojo::Equals(this->cert_verifier_service_client_receiver, other_struct.cert_verifier_service_client_receiver))
    return false;
  return true;
}

template <typename T, CertVerifierServiceRemoteParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.cert_verifier_service < rhs.cert_verifier_service)
    return true;
  if (rhs.cert_verifier_service < lhs.cert_verifier_service)
    return false;
  if (lhs.cert_verifier_service_client_receiver < rhs.cert_verifier_service_client_receiver)
    return true;
  if (rhs.cert_verifier_service_client_receiver < lhs.cert_verifier_service_client_receiver)
    return false;
  return false;
}
template <typename StructPtrType>
HttpAuthStaticNetworkContextParamsPtr HttpAuthStaticNetworkContextParams::Clone() const {
  return New(
      mojo::Clone(allow_default_credentials)
  );
}

template <typename T, HttpAuthStaticNetworkContextParams::EnableIfSame<T>*>
bool HttpAuthStaticNetworkContextParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->allow_default_credentials, other_struct.allow_default_credentials))
    return false;
  return true;
}

template <typename T, HttpAuthStaticNetworkContextParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.allow_default_credentials < rhs.allow_default_credentials)
    return true;
  if (rhs.allow_default_credentials < lhs.allow_default_credentials)
    return false;
  return false;
}
template <typename StructPtrType>
CTPolicyPtr CTPolicy::Clone() const {
  return New(
      mojo::Clone(excluded_hosts),
      mojo::Clone(excluded_spkis)
  );
}

template <typename T, CTPolicy::EnableIfSame<T>*>
bool CTPolicy::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->excluded_hosts, other_struct.excluded_hosts))
    return false;
  if (!mojo::Equals(this->excluded_spkis, other_struct.excluded_spkis))
    return false;
  return true;
}

template <typename T, CTPolicy::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.excluded_hosts < rhs.excluded_hosts)
    return true;
  if (rhs.excluded_hosts < lhs.excluded_hosts)
    return false;
  if (lhs.excluded_spkis < rhs.excluded_spkis)
    return true;
  if (rhs.excluded_spkis < lhs.excluded_spkis)
    return false;
  return false;
}
template <typename StructPtrType>
NetworkContextFilePathsPtr NetworkContextFilePaths::Clone() const {
  return New(
      mojo::Clone(shared_dictionary_directory),
      mojo::Clone(http_cache_directory),
      mojo::Clone(no_vary_search_directory),
      mojo::Clone(data_directory),
      mojo::Clone(unsandboxed_data_path),
      mojo::Clone(cookie_database_name),
      mojo::Clone(device_bound_sessions_database_name),
      mojo::Clone(trust_token_database_name),
      mojo::Clone(http_server_properties_file_name),
      mojo::Clone(transport_security_persister_file_name),
      mojo::Clone(reporting_and_nel_store_database_name),
      mojo::Clone(sct_auditing_pending_reports_file_name),
      mojo::Clone(trigger_migration)
  );
}

template <typename T, NetworkContextFilePaths::EnableIfSame<T>*>
bool NetworkContextFilePaths::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->shared_dictionary_directory, other_struct.shared_dictionary_directory))
    return false;
  if (!mojo::Equals(this->http_cache_directory, other_struct.http_cache_directory))
    return false;
  if (!mojo::Equals(this->no_vary_search_directory, other_struct.no_vary_search_directory))
    return false;
  if (!mojo::Equals(this->data_directory, other_struct.data_directory))
    return false;
  if (!mojo::Equals(this->unsandboxed_data_path, other_struct.unsandboxed_data_path))
    return false;
  if (!mojo::Equals(this->cookie_database_name, other_struct.cookie_database_name))
    return false;
  if (!mojo::Equals(this->device_bound_sessions_database_name, other_struct.device_bound_sessions_database_name))
    return false;
  if (!mojo::Equals(this->trust_token_database_name, other_struct.trust_token_database_name))
    return false;
  if (!mojo::Equals(this->http_server_properties_file_name, other_struct.http_server_properties_file_name))
    return false;
  if (!mojo::Equals(this->transport_security_persister_file_name, other_struct.transport_security_persister_file_name))
    return false;
  if (!mojo::Equals(this->reporting_and_nel_store_database_name, other_struct.reporting_and_nel_store_database_name))
    return false;
  if (!mojo::Equals(this->sct_auditing_pending_reports_file_name, other_struct.sct_auditing_pending_reports_file_name))
    return false;
  if (!mojo::Equals(this->trigger_migration, other_struct.trigger_migration))
    return false;
  return true;
}

template <typename T, NetworkContextFilePaths::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.shared_dictionary_directory < rhs.shared_dictionary_directory)
    return true;
  if (rhs.shared_dictionary_directory < lhs.shared_dictionary_directory)
    return false;
  if (lhs.http_cache_directory < rhs.http_cache_directory)
    return true;
  if (rhs.http_cache_directory < lhs.http_cache_directory)
    return false;
  if (lhs.no_vary_search_directory < rhs.no_vary_search_directory)
    return true;
  if (rhs.no_vary_search_directory < lhs.no_vary_search_directory)
    return false;
  if (lhs.data_directory < rhs.data_directory)
    return true;
  if (rhs.data_directory < lhs.data_directory)
    return false;
  if (lhs.unsandboxed_data_path < rhs.unsandboxed_data_path)
    return true;
  if (rhs.unsandboxed_data_path < lhs.unsandboxed_data_path)
    return false;
  if (lhs.cookie_database_name < rhs.cookie_database_name)
    return true;
  if (rhs.cookie_database_name < lhs.cookie_database_name)
    return false;
  if (lhs.device_bound_sessions_database_name < rhs.device_bound_sessions_database_name)
    return true;
  if (rhs.device_bound_sessions_database_name < lhs.device_bound_sessions_database_name)
    return false;
  if (lhs.trust_token_database_name < rhs.trust_token_database_name)
    return true;
  if (rhs.trust_token_database_name < lhs.trust_token_database_name)
    return false;
  if (lhs.http_server_properties_file_name < rhs.http_server_properties_file_name)
    return true;
  if (rhs.http_server_properties_file_name < lhs.http_server_properties_file_name)
    return false;
  if (lhs.transport_security_persister_file_name < rhs.transport_security_persister_file_name)
    return true;
  if (rhs.transport_security_persister_file_name < lhs.transport_security_persister_file_name)
    return false;
  if (lhs.reporting_and_nel_store_database_name < rhs.reporting_and_nel_store_database_name)
    return true;
  if (rhs.reporting_and_nel_store_database_name < lhs.reporting_and_nel_store_database_name)
    return false;
  if (lhs.sct_auditing_pending_reports_file_name < rhs.sct_auditing_pending_reports_file_name)
    return true;
  if (rhs.sct_auditing_pending_reports_file_name < lhs.sct_auditing_pending_reports_file_name)
    return false;
  if (lhs.trigger_migration < rhs.trigger_migration)
    return true;
  if (rhs.trigger_migration < lhs.trigger_migration)
    return false;
  return false;
}
template <typename StructPtrType>
NetworkContextParamsPtr NetworkContextParams::Clone() const {
  return New(
      mojo::Clone(user_agent),
      mojo::Clone(accept_language),
      mojo::Clone(enable_brotli),
      mojo::Clone(enable_zstd),
      mojo::Clone(enable_referrers),
      mojo::Clone(validate_referrer_policy_on_initial_request),
      mojo::Clone(proxy_resolver_factory),
      mojo::Clone(enable_encrypted_cookies),
      mojo::Clone(restore_old_session_cookies),
      mojo::Clone(persist_session_cookies),
      mojo::Clone(http_cache_enabled),
      mojo::Clone(http_cache_max_size),
      mojo::Clone(http_cache_file_operations_factory),
      mojo::Clone(disable_idle_sockets_close_on_memory_pressure),
      mojo::Clone(initial_ssl_config),
      mojo::Clone(ssl_config_client_receiver),
      mojo::Clone(initial_proxy_config),
      mojo::Clone(proxy_config_client_receiver),
      mojo::Clone(initial_custom_proxy_config),
      mojo::Clone(custom_proxy_config_client_receiver),
      mojo::Clone(custom_proxy_connection_observer_remote),
      mojo::Clone(proxy_config_poller_client),
      mojo::Clone(proxy_error_client),
      mojo::Clone(ip_protection_core_host),
      mojo::Clone(ip_protection_control),
      mojo::Clone(enable_ip_protection),
      mojo::Clone(ip_protection_incognito),
      mojo::Clone(ip_protection_data_directory),
      mojo::Clone(pac_quick_check_enabled),
      mojo::Clone(enable_certificate_reporting),
      mojo::Clone(enforce_chrome_ct_policy),
      mojo::Clone(sct_auditing_mode),
      mojo::Clone(ct_policy),
      mojo::Clone(cert_verifier_params),
      mojo::Clone(cookie_manager_params),
      mojo::Clone(cookie_manager),
      mojo::Clone(enable_domain_reliability),
      mojo::Clone(domain_reliability_upload_reporter),
      mojo::Clone(discard_domain_reliablity_uploads),
      mojo::Clone(reporting_delivery_interval),
      mojo::Clone(skip_reporting_send_permission_check),
      mojo::Clone(cors_origin_access_list),
      mojo::Clone(cors_exempt_header_list),
      mojo::Clone(allow_any_cors_exempt_header_for_browser),
      mojo::Clone(hsts_policy_bypass_list),
      mojo::Clone(http_auth_static_network_context_params),
      mojo::Clone(reset_http_cache_backend),
      mojo::Clone(split_auth_cache_by_network_anonymization_key),
      mojo::Clone(require_network_anonymization_key),
      mojo::Clone(file_paths),
      mojo::Clone(block_trust_tokens),
      mojo::Clone(shared_dictionary_enabled),
      mojo::Clone(shared_dictionary_cache_max_size),
      mojo::Clone(first_party_sets_access_delegate_params),
      mojo::Clone(first_party_sets_access_delegate_receiver),
      mojo::Clone(acam_preflight_spec_conformant),
      mojo::Clone(cookie_deprecation_label),
      mojo::Clone(cookie_encryption_provider),
      mojo::Clone(device_bound_sessions_enabled),
      mojo::Clone(bound_network),
      mojo::Clone(enterprise_reporting_endpoints),
      mojo::Clone(quic_idle_connection_timeout_seconds)
  );
}

template <typename T, NetworkContextParams::EnableIfSame<T>*>
bool NetworkContextParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->user_agent, other_struct.user_agent))
    return false;
  if (!mojo::Equals(this->accept_language, other_struct.accept_language))
    return false;
  if (!mojo::Equals(this->enable_brotli, other_struct.enable_brotli))
    return false;
  if (!mojo::Equals(this->enable_zstd, other_struct.enable_zstd))
    return false;
  if (!mojo::Equals(this->enable_referrers, other_struct.enable_referrers))
    return false;
  if (!mojo::Equals(this->validate_referrer_policy_on_initial_request, other_struct.validate_referrer_policy_on_initial_request))
    return false;
  if (!mojo::Equals(this->proxy_resolver_factory, other_struct.proxy_resolver_factory))
    return false;
  if (!mojo::Equals(this->enable_encrypted_cookies, other_struct.enable_encrypted_cookies))
    return false;
  if (!mojo::Equals(this->restore_old_session_cookies, other_struct.restore_old_session_cookies))
    return false;
  if (!mojo::Equals(this->persist_session_cookies, other_struct.persist_session_cookies))
    return false;
  if (!mojo::Equals(this->http_cache_enabled, other_struct.http_cache_enabled))
    return false;
  if (!mojo::Equals(this->http_cache_max_size, other_struct.http_cache_max_size))
    return false;
  if (!mojo::Equals(this->http_cache_file_operations_factory, other_struct.http_cache_file_operations_factory))
    return false;
  if (!mojo::Equals(this->disable_idle_sockets_close_on_memory_pressure, other_struct.disable_idle_sockets_close_on_memory_pressure))
    return false;
  if (!mojo::Equals(this->initial_ssl_config, other_struct.initial_ssl_config))
    return false;
  if (!mojo::Equals(this->ssl_config_client_receiver, other_struct.ssl_config_client_receiver))
    return false;
  if (!mojo::Equals(this->initial_proxy_config, other_struct.initial_proxy_config))
    return false;
  if (!mojo::Equals(this->proxy_config_client_receiver, other_struct.proxy_config_client_receiver))
    return false;
  if (!mojo::Equals(this->initial_custom_proxy_config, other_struct.initial_custom_proxy_config))
    return false;
  if (!mojo::Equals(this->custom_proxy_config_client_receiver, other_struct.custom_proxy_config_client_receiver))
    return false;
  if (!mojo::Equals(this->custom_proxy_connection_observer_remote, other_struct.custom_proxy_connection_observer_remote))
    return false;
  if (!mojo::Equals(this->proxy_config_poller_client, other_struct.proxy_config_poller_client))
    return false;
  if (!mojo::Equals(this->proxy_error_client, other_struct.proxy_error_client))
    return false;
  if (!mojo::Equals(this->ip_protection_core_host, other_struct.ip_protection_core_host))
    return false;
  if (!mojo::Equals(this->ip_protection_control, other_struct.ip_protection_control))
    return false;
  if (!mojo::Equals(this->enable_ip_protection, other_struct.enable_ip_protection))
    return false;
  if (!mojo::Equals(this->ip_protection_incognito, other_struct.ip_protection_incognito))
    return false;
  if (!mojo::Equals(this->ip_protection_data_directory, other_struct.ip_protection_data_directory))
    return false;
  if (!mojo::Equals(this->pac_quick_check_enabled, other_struct.pac_quick_check_enabled))
    return false;
  if (!mojo::Equals(this->enable_certificate_reporting, other_struct.enable_certificate_reporting))
    return false;
  if (!mojo::Equals(this->enforce_chrome_ct_policy, other_struct.enforce_chrome_ct_policy))
    return false;
  if (!mojo::Equals(this->sct_auditing_mode, other_struct.sct_auditing_mode))
    return false;
  if (!mojo::Equals(this->ct_policy, other_struct.ct_policy))
    return false;
  if (!mojo::Equals(this->cert_verifier_params, other_struct.cert_verifier_params))
    return false;
  if (!mojo::Equals(this->cookie_manager_params, other_struct.cookie_manager_params))
    return false;
  if (!mojo::Equals(this->cookie_manager, other_struct.cookie_manager))
    return false;
  if (!mojo::Equals(this->enable_domain_reliability, other_struct.enable_domain_reliability))
    return false;
  if (!mojo::Equals(this->domain_reliability_upload_reporter, other_struct.domain_reliability_upload_reporter))
    return false;
  if (!mojo::Equals(this->discard_domain_reliablity_uploads, other_struct.discard_domain_reliablity_uploads))
    return false;
  if (!mojo::Equals(this->reporting_delivery_interval, other_struct.reporting_delivery_interval))
    return false;
  if (!mojo::Equals(this->skip_reporting_send_permission_check, other_struct.skip_reporting_send_permission_check))
    return false;
  if (!mojo::Equals(this->cors_origin_access_list, other_struct.cors_origin_access_list))
    return false;
  if (!mojo::Equals(this->cors_exempt_header_list, other_struct.cors_exempt_header_list))
    return false;
  if (!mojo::Equals(this->allow_any_cors_exempt_header_for_browser, other_struct.allow_any_cors_exempt_header_for_browser))
    return false;
  if (!mojo::Equals(this->hsts_policy_bypass_list, other_struct.hsts_policy_bypass_list))
    return false;
  if (!mojo::Equals(this->http_auth_static_network_context_params, other_struct.http_auth_static_network_context_params))
    return false;
  if (!mojo::Equals(this->reset_http_cache_backend, other_struct.reset_http_cache_backend))
    return false;
  if (!mojo::Equals(this->split_auth_cache_by_network_anonymization_key, other_struct.split_auth_cache_by_network_anonymization_key))
    return false;
  if (!mojo::Equals(this->require_network_anonymization_key, other_struct.require_network_anonymization_key))
    return false;
  if (!mojo::Equals(this->file_paths, other_struct.file_paths))
    return false;
  if (!mojo::Equals(this->block_trust_tokens, other_struct.block_trust_tokens))
    return false;
  if (!mojo::Equals(this->shared_dictionary_enabled, other_struct.shared_dictionary_enabled))
    return false;
  if (!mojo::Equals(this->shared_dictionary_cache_max_size, other_struct.shared_dictionary_cache_max_size))
    return false;
  if (!mojo::Equals(this->first_party_sets_access_delegate_params, other_struct.first_party_sets_access_delegate_params))
    return false;
  if (!mojo::Equals(this->first_party_sets_access_delegate_receiver, other_struct.first_party_sets_access_delegate_receiver))
    return false;
  if (!mojo::Equals(this->acam_preflight_spec_conformant, other_struct.acam_preflight_spec_conformant))
    return false;
  if (!mojo::Equals(this->cookie_deprecation_label, other_struct.cookie_deprecation_label))
    return false;
  if (!mojo::Equals(this->cookie_encryption_provider, other_struct.cookie_encryption_provider))
    return false;
  if (!mojo::Equals(this->device_bound_sessions_enabled, other_struct.device_bound_sessions_enabled))
    return false;
  if (!mojo::Equals(this->bound_network, other_struct.bound_network))
    return false;
  if (!mojo::Equals(this->enterprise_reporting_endpoints, other_struct.enterprise_reporting_endpoints))
    return false;
  if (!mojo::Equals(this->quic_idle_connection_timeout_seconds, other_struct.quic_idle_connection_timeout_seconds))
    return false;
  return true;
}

template <typename T, NetworkContextParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.user_agent < rhs.user_agent)
    return true;
  if (rhs.user_agent < lhs.user_agent)
    return false;
  if (lhs.accept_language < rhs.accept_language)
    return true;
  if (rhs.accept_language < lhs.accept_language)
    return false;
  if (lhs.enable_brotli < rhs.enable_brotli)
    return true;
  if (rhs.enable_brotli < lhs.enable_brotli)
    return false;
  if (lhs.enable_zstd < rhs.enable_zstd)
    return true;
  if (rhs.enable_zstd < lhs.enable_zstd)
    return false;
  if (lhs.enable_referrers < rhs.enable_referrers)
    return true;
  if (rhs.enable_referrers < lhs.enable_referrers)
    return false;
  if (lhs.validate_referrer_policy_on_initial_request < rhs.validate_referrer_policy_on_initial_request)
    return true;
  if (rhs.validate_referrer_policy_on_initial_request < lhs.validate_referrer_policy_on_initial_request)
    return false;
  if (lhs.proxy_resolver_factory < rhs.proxy_resolver_factory)
    return true;
  if (rhs.proxy_resolver_factory < lhs.proxy_resolver_factory)
    return false;
  if (lhs.enable_encrypted_cookies < rhs.enable_encrypted_cookies)
    return true;
  if (rhs.enable_encrypted_cookies < lhs.enable_encrypted_cookies)
    return false;
  if (lhs.restore_old_session_cookies < rhs.restore_old_session_cookies)
    return true;
  if (rhs.restore_old_session_cookies < lhs.restore_old_session_cookies)
    return false;
  if (lhs.persist_session_cookies < rhs.persist_session_cookies)
    return true;
  if (rhs.persist_session_cookies < lhs.persist_session_cookies)
    return false;
  if (lhs.http_cache_enabled < rhs.http_cache_enabled)
    return true;
  if (rhs.http_cache_enabled < lhs.http_cache_enabled)
    return false;
  if (lhs.http_cache_max_size < rhs.http_cache_max_size)
    return true;
  if (rhs.http_cache_max_size < lhs.http_cache_max_size)
    return false;
  if (lhs.http_cache_file_operations_factory < rhs.http_cache_file_operations_factory)
    return true;
  if (rhs.http_cache_file_operations_factory < lhs.http_cache_file_operations_factory)
    return false;
  if (lhs.disable_idle_sockets_close_on_memory_pressure < rhs.disable_idle_sockets_close_on_memory_pressure)
    return true;
  if (rhs.disable_idle_sockets_close_on_memory_pressure < lhs.disable_idle_sockets_close_on_memory_pressure)
    return false;
  if (lhs.initial_ssl_config < rhs.initial_ssl_config)
    return true;
  if (rhs.initial_ssl_config < lhs.initial_ssl_config)
    return false;
  if (lhs.ssl_config_client_receiver < rhs.ssl_config_client_receiver)
    return true;
  if (rhs.ssl_config_client_receiver < lhs.ssl_config_client_receiver)
    return false;
  if (lhs.initial_proxy_config < rhs.initial_proxy_config)
    return true;
  if (rhs.initial_proxy_config < lhs.initial_proxy_config)
    return false;
  if (lhs.proxy_config_client_receiver < rhs.proxy_config_client_receiver)
    return true;
  if (rhs.proxy_config_client_receiver < lhs.proxy_config_client_receiver)
    return false;
  if (lhs.initial_custom_proxy_config < rhs.initial_custom_proxy_config)
    return true;
  if (rhs.initial_custom_proxy_config < lhs.initial_custom_proxy_config)
    return false;
  if (lhs.custom_proxy_config_client_receiver < rhs.custom_proxy_config_client_receiver)
    return true;
  if (rhs.custom_proxy_config_client_receiver < lhs.custom_proxy_config_client_receiver)
    return false;
  if (lhs.custom_proxy_connection_observer_remote < rhs.custom_proxy_connection_observer_remote)
    return true;
  if (rhs.custom_proxy_connection_observer_remote < lhs.custom_proxy_connection_observer_remote)
    return false;
  if (lhs.proxy_config_poller_client < rhs.proxy_config_poller_client)
    return true;
  if (rhs.proxy_config_poller_client < lhs.proxy_config_poller_client)
    return false;
  if (lhs.proxy_error_client < rhs.proxy_error_client)
    return true;
  if (rhs.proxy_error_client < lhs.proxy_error_client)
    return false;
  if (lhs.ip_protection_core_host < rhs.ip_protection_core_host)
    return true;
  if (rhs.ip_protection_core_host < lhs.ip_protection_core_host)
    return false;
  if (lhs.ip_protection_control < rhs.ip_protection_control)
    return true;
  if (rhs.ip_protection_control < lhs.ip_protection_control)
    return false;
  if (lhs.enable_ip_protection < rhs.enable_ip_protection)
    return true;
  if (rhs.enable_ip_protection < lhs.enable_ip_protection)
    return false;
  if (lhs.ip_protection_incognito < rhs.ip_protection_incognito)
    return true;
  if (rhs.ip_protection_incognito < lhs.ip_protection_incognito)
    return false;
  if (lhs.ip_protection_data_directory < rhs.ip_protection_data_directory)
    return true;
  if (rhs.ip_protection_data_directory < lhs.ip_protection_data_directory)
    return false;
  if (lhs.pac_quick_check_enabled < rhs.pac_quick_check_enabled)
    return true;
  if (rhs.pac_quick_check_enabled < lhs.pac_quick_check_enabled)
    return false;
  if (lhs.enable_certificate_reporting < rhs.enable_certificate_reporting)
    return true;
  if (rhs.enable_certificate_reporting < lhs.enable_certificate_reporting)
    return false;
  if (lhs.enforce_chrome_ct_policy < rhs.enforce_chrome_ct_policy)
    return true;
  if (rhs.enforce_chrome_ct_policy < lhs.enforce_chrome_ct_policy)
    return false;
  if (lhs.sct_auditing_mode < rhs.sct_auditing_mode)
    return true;
  if (rhs.sct_auditing_mode < lhs.sct_auditing_mode)
    return false;
  if (lhs.ct_policy < rhs.ct_policy)
    return true;
  if (rhs.ct_policy < lhs.ct_policy)
    return false;
  if (lhs.cert_verifier_params < rhs.cert_verifier_params)
    return true;
  if (rhs.cert_verifier_params < lhs.cert_verifier_params)
    return false;
  if (lhs.cookie_manager_params < rhs.cookie_manager_params)
    return true;
  if (rhs.cookie_manager_params < lhs.cookie_manager_params)
    return false;
  if (lhs.cookie_manager < rhs.cookie_manager)
    return true;
  if (rhs.cookie_manager < lhs.cookie_manager)
    return false;
  if (lhs.enable_domain_reliability < rhs.enable_domain_reliability)
    return true;
  if (rhs.enable_domain_reliability < lhs.enable_domain_reliability)
    return false;
  if (lhs.domain_reliability_upload_reporter < rhs.domain_reliability_upload_reporter)
    return true;
  if (rhs.domain_reliability_upload_reporter < lhs.domain_reliability_upload_reporter)
    return false;
  if (lhs.discard_domain_reliablity_uploads < rhs.discard_domain_reliablity_uploads)
    return true;
  if (rhs.discard_domain_reliablity_uploads < lhs.discard_domain_reliablity_uploads)
    return false;
  if (lhs.reporting_delivery_interval < rhs.reporting_delivery_interval)
    return true;
  if (rhs.reporting_delivery_interval < lhs.reporting_delivery_interval)
    return false;
  if (lhs.skip_reporting_send_permission_check < rhs.skip_reporting_send_permission_check)
    return true;
  if (rhs.skip_reporting_send_permission_check < lhs.skip_reporting_send_permission_check)
    return false;
  if (lhs.cors_origin_access_list < rhs.cors_origin_access_list)
    return true;
  if (rhs.cors_origin_access_list < lhs.cors_origin_access_list)
    return false;
  if (lhs.cors_exempt_header_list < rhs.cors_exempt_header_list)
    return true;
  if (rhs.cors_exempt_header_list < lhs.cors_exempt_header_list)
    return false;
  if (lhs.allow_any_cors_exempt_header_for_browser < rhs.allow_any_cors_exempt_header_for_browser)
    return true;
  if (rhs.allow_any_cors_exempt_header_for_browser < lhs.allow_any_cors_exempt_header_for_browser)
    return false;
  if (lhs.hsts_policy_bypass_list < rhs.hsts_policy_bypass_list)
    return true;
  if (rhs.hsts_policy_bypass_list < lhs.hsts_policy_bypass_list)
    return false;
  if (lhs.http_auth_static_network_context_params < rhs.http_auth_static_network_context_params)
    return true;
  if (rhs.http_auth_static_network_context_params < lhs.http_auth_static_network_context_params)
    return false;
  if (lhs.reset_http_cache_backend < rhs.reset_http_cache_backend)
    return true;
  if (rhs.reset_http_cache_backend < lhs.reset_http_cache_backend)
    return false;
  if (lhs.split_auth_cache_by_network_anonymization_key < rhs.split_auth_cache_by_network_anonymization_key)
    return true;
  if (rhs.split_auth_cache_by_network_anonymization_key < lhs.split_auth_cache_by_network_anonymization_key)
    return false;
  if (lhs.require_network_anonymization_key < rhs.require_network_anonymization_key)
    return true;
  if (rhs.require_network_anonymization_key < lhs.require_network_anonymization_key)
    return false;
  if (lhs.file_paths < rhs.file_paths)
    return true;
  if (rhs.file_paths < lhs.file_paths)
    return false;
  if (lhs.block_trust_tokens < rhs.block_trust_tokens)
    return true;
  if (rhs.block_trust_tokens < lhs.block_trust_tokens)
    return false;
  if (lhs.shared_dictionary_enabled < rhs.shared_dictionary_enabled)
    return true;
  if (rhs.shared_dictionary_enabled < lhs.shared_dictionary_enabled)
    return false;
  if (lhs.shared_dictionary_cache_max_size < rhs.shared_dictionary_cache_max_size)
    return true;
  if (rhs.shared_dictionary_cache_max_size < lhs.shared_dictionary_cache_max_size)
    return false;
  if (lhs.first_party_sets_access_delegate_params < rhs.first_party_sets_access_delegate_params)
    return true;
  if (rhs.first_party_sets_access_delegate_params < lhs.first_party_sets_access_delegate_params)
    return false;
  if (lhs.first_party_sets_access_delegate_receiver < rhs.first_party_sets_access_delegate_receiver)
    return true;
  if (rhs.first_party_sets_access_delegate_receiver < lhs.first_party_sets_access_delegate_receiver)
    return false;
  if (lhs.acam_preflight_spec_conformant < rhs.acam_preflight_spec_conformant)
    return true;
  if (rhs.acam_preflight_spec_conformant < lhs.acam_preflight_spec_conformant)
    return false;
  if (lhs.cookie_deprecation_label < rhs.cookie_deprecation_label)
    return true;
  if (rhs.cookie_deprecation_label < lhs.cookie_deprecation_label)
    return false;
  if (lhs.cookie_encryption_provider < rhs.cookie_encryption_provider)
    return true;
  if (rhs.cookie_encryption_provider < lhs.cookie_encryption_provider)
    return false;
  if (lhs.device_bound_sessions_enabled < rhs.device_bound_sessions_enabled)
    return true;
  if (rhs.device_bound_sessions_enabled < lhs.device_bound_sessions_enabled)
    return false;
  if (lhs.bound_network < rhs.bound_network)
    return true;
  if (rhs.bound_network < lhs.bound_network)
    return false;
  if (lhs.enterprise_reporting_endpoints < rhs.enterprise_reporting_endpoints)
    return true;
  if (rhs.enterprise_reporting_endpoints < lhs.enterprise_reporting_endpoints)
    return false;
  if (lhs.quic_idle_connection_timeout_seconds < rhs.quic_idle_connection_timeout_seconds)
    return true;
  if (rhs.quic_idle_connection_timeout_seconds < lhs.quic_idle_connection_timeout_seconds)
    return false;
  return false;
}
template <typename StructPtrType>
NetworkConditionsPtr NetworkConditions::Clone() const {
  return New(
      mojo::Clone(offline),
      mojo::Clone(latency),
      mojo::Clone(download_throughput),
      mojo::Clone(upload_throughput),
      mojo::Clone(packet_loss),
      mojo::Clone(packet_queue_length),
      mojo::Clone(packet_reordering)
  );
}

template <typename T, NetworkConditions::EnableIfSame<T>*>
bool NetworkConditions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->offline, other_struct.offline))
    return false;
  if (!mojo::Equals(this->latency, other_struct.latency))
    return false;
  if (!mojo::Equals(this->download_throughput, other_struct.download_throughput))
    return false;
  if (!mojo::Equals(this->upload_throughput, other_struct.upload_throughput))
    return false;
  if (!mojo::Equals(this->packet_loss, other_struct.packet_loss))
    return false;
  if (!mojo::Equals(this->packet_queue_length, other_struct.packet_queue_length))
    return false;
  if (!mojo::Equals(this->packet_reordering, other_struct.packet_reordering))
    return false;
  return true;
}

template <typename T, NetworkConditions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.offline < rhs.offline)
    return true;
  if (rhs.offline < lhs.offline)
    return false;
  if (lhs.latency < rhs.latency)
    return true;
  if (rhs.latency < lhs.latency)
    return false;
  if (lhs.download_throughput < rhs.download_throughput)
    return true;
  if (rhs.download_throughput < lhs.download_throughput)
    return false;
  if (lhs.upload_throughput < rhs.upload_throughput)
    return true;
  if (rhs.upload_throughput < lhs.upload_throughput)
    return false;
  if (lhs.packet_loss < rhs.packet_loss)
    return true;
  if (rhs.packet_loss < lhs.packet_loss)
    return false;
  if (lhs.packet_queue_length < rhs.packet_queue_length)
    return true;
  if (rhs.packet_queue_length < lhs.packet_queue_length)
    return false;
  if (lhs.packet_reordering < rhs.packet_reordering)
    return true;
  if (rhs.packet_reordering < lhs.packet_reordering)
    return false;
  return false;
}
template <typename StructPtrType>
SharedDictionaryInfoPtr SharedDictionaryInfo::Clone() const {
  return New(
      mojo::Clone(match),
      mojo::Clone(match_dest),
      mojo::Clone(id),
      mojo::Clone(dictionary_url),
      mojo::Clone(last_fetch_time),
      mojo::Clone(response_time),
      mojo::Clone(expiration),
      mojo::Clone(last_used_time),
      mojo::Clone(size),
      mojo::Clone(hash)
  );
}

template <typename T, SharedDictionaryInfo::EnableIfSame<T>*>
bool SharedDictionaryInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->match, other_struct.match))
    return false;
  if (!mojo::Equals(this->match_dest, other_struct.match_dest))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->dictionary_url, other_struct.dictionary_url))
    return false;
  if (!mojo::Equals(this->last_fetch_time, other_struct.last_fetch_time))
    return false;
  if (!mojo::Equals(this->response_time, other_struct.response_time))
    return false;
  if (!mojo::Equals(this->expiration, other_struct.expiration))
    return false;
  if (!mojo::Equals(this->last_used_time, other_struct.last_used_time))
    return false;
  if (!mojo::Equals(this->size, other_struct.size))
    return false;
  if (!mojo::Equals(this->hash, other_struct.hash))
    return false;
  return true;
}

template <typename T, SharedDictionaryInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.match < rhs.match)
    return true;
  if (rhs.match < lhs.match)
    return false;
  if (lhs.match_dest < rhs.match_dest)
    return true;
  if (rhs.match_dest < lhs.match_dest)
    return false;
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.dictionary_url < rhs.dictionary_url)
    return true;
  if (rhs.dictionary_url < lhs.dictionary_url)
    return false;
  if (lhs.last_fetch_time < rhs.last_fetch_time)
    return true;
  if (rhs.last_fetch_time < lhs.last_fetch_time)
    return false;
  if (lhs.response_time < rhs.response_time)
    return true;
  if (rhs.response_time < lhs.response_time)
    return false;
  if (lhs.expiration < rhs.expiration)
    return true;
  if (rhs.expiration < lhs.expiration)
    return false;
  if (lhs.last_used_time < rhs.last_used_time)
    return true;
  if (rhs.last_used_time < lhs.last_used_time)
    return false;
  if (lhs.size < rhs.size)
    return true;
  if (rhs.size < lhs.size)
    return false;
  if (lhs.hash < rhs.hash)
    return true;
  if (rhs.hash < lhs.hash)
    return false;
  return false;
}
template <typename StructPtrType>
SignedExchangeReportPtr SignedExchangeReport::Clone() const {
  return New(
      mojo::Clone(success),
      mojo::Clone(type),
      mojo::Clone(outer_url),
      mojo::Clone(inner_url),
      mojo::Clone(cert_url),
      mojo::Clone(referrer),
      mojo::Clone(server_ip_address),
      mojo::Clone(protocol),
      mojo::Clone(method),
      mojo::Clone(status_code),
      mojo::Clone(elapsed_time)
  );
}

template <typename T, SignedExchangeReport::EnableIfSame<T>*>
bool SignedExchangeReport::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->success, other_struct.success))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->outer_url, other_struct.outer_url))
    return false;
  if (!mojo::Equals(this->inner_url, other_struct.inner_url))
    return false;
  if (!mojo::Equals(this->cert_url, other_struct.cert_url))
    return false;
  if (!mojo::Equals(this->referrer, other_struct.referrer))
    return false;
  if (!mojo::Equals(this->server_ip_address, other_struct.server_ip_address))
    return false;
  if (!mojo::Equals(this->protocol, other_struct.protocol))
    return false;
  if (!mojo::Equals(this->method, other_struct.method))
    return false;
  if (!mojo::Equals(this->status_code, other_struct.status_code))
    return false;
  if (!mojo::Equals(this->elapsed_time, other_struct.elapsed_time))
    return false;
  return true;
}

template <typename T, SignedExchangeReport::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.success < rhs.success)
    return true;
  if (rhs.success < lhs.success)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.outer_url < rhs.outer_url)
    return true;
  if (rhs.outer_url < lhs.outer_url)
    return false;
  if (lhs.inner_url < rhs.inner_url)
    return true;
  if (rhs.inner_url < lhs.inner_url)
    return false;
  if (lhs.cert_url < rhs.cert_url)
    return true;
  if (rhs.cert_url < lhs.cert_url)
    return false;
  if (lhs.referrer < rhs.referrer)
    return true;
  if (rhs.referrer < lhs.referrer)
    return false;
  if (lhs.server_ip_address < rhs.server_ip_address)
    return true;
  if (rhs.server_ip_address < lhs.server_ip_address)
    return false;
  if (lhs.protocol < rhs.protocol)
    return true;
  if (rhs.protocol < lhs.protocol)
    return false;
  if (lhs.method < rhs.method)
    return true;
  if (rhs.method < lhs.method)
    return false;
  if (lhs.status_code < rhs.status_code)
    return true;
  if (rhs.status_code < lhs.status_code)
    return false;
  if (lhs.elapsed_time < rhs.elapsed_time)
    return true;
  if (rhs.elapsed_time < lhs.elapsed_time)
    return false;
  return false;
}
template <typename StructPtrType>
URLLoaderFactoryOverridePtr URLLoaderFactoryOverride::Clone() const {
  return New(
      mojo::Clone(overriding_factory),
      mojo::Clone(overridden_factory_receiver),
      mojo::Clone(skip_cors_enabled_scheme_check)
  );
}

template <typename T, URLLoaderFactoryOverride::EnableIfSame<T>*>
bool URLLoaderFactoryOverride::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->overriding_factory, other_struct.overriding_factory))
    return false;
  if (!mojo::Equals(this->overridden_factory_receiver, other_struct.overridden_factory_receiver))
    return false;
  if (!mojo::Equals(this->skip_cors_enabled_scheme_check, other_struct.skip_cors_enabled_scheme_check))
    return false;
  return true;
}

template <typename T, URLLoaderFactoryOverride::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.overriding_factory < rhs.overriding_factory)
    return true;
  if (rhs.overriding_factory < lhs.overriding_factory)
    return false;
  if (lhs.overridden_factory_receiver < rhs.overridden_factory_receiver)
    return true;
  if (rhs.overridden_factory_receiver < lhs.overridden_factory_receiver)
    return false;
  if (lhs.skip_cors_enabled_scheme_check < rhs.skip_cors_enabled_scheme_check)
    return true;
  if (rhs.skip_cors_enabled_scheme_check < lhs.skip_cors_enabled_scheme_check)
    return false;
  return false;
}
template <typename StructPtrType>
URLLoaderFactoryParamsPtr URLLoaderFactoryParams::Clone() const {
  return New(
      mojo::Clone(process_id),
      mojo::Clone(request_initiator_origin_lock),
      mojo::Clone(is_orb_enabled),
      mojo::Clone(ignore_isolated_world_origin),
      mojo::Clone(unsafe_non_webby_initiator),
      mojo::Clone(disable_web_security),
      mojo::Clone(header_client),
      mojo::Clone(isolation_info),
      mojo::Clone(disable_secure_dns),
      mojo::Clone(is_trusted),
      mojo::Clone(automatically_assign_isolation_info),
      mojo::Clone(top_frame_id),
      mojo::Clone(factory_override),
      mojo::Clone(client_security_state),
      mojo::Clone(coep_reporter),
      mojo::Clone(dip_reporter),
      mojo::Clone(cookie_observer),
      mojo::Clone(trust_token_observer),
      mojo::Clone(shared_dictionary_observer),
      mojo::Clone(url_loader_network_observer),
      mojo::Clone(devtools_observer),
      mojo::Clone(device_bound_session_observer),
      mojo::Clone(trust_token_issuance_policy),
      mojo::Clone(trust_token_redemption_policy),
      mojo::Clone(debug_tag),
      mojo::Clone(cookie_setting_overrides),
      mojo::Clone(devtools_cookie_setting_overrides),
      mojo::Clone(require_cross_site_request_for_cookies),
      mojo::Clone(ignore_factory_reset)
  );
}

template <typename T, URLLoaderFactoryParams::EnableIfSame<T>*>
bool URLLoaderFactoryParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->process_id, other_struct.process_id))
    return false;
  if (!mojo::Equals(this->request_initiator_origin_lock, other_struct.request_initiator_origin_lock))
    return false;
  if (!mojo::Equals(this->is_orb_enabled, other_struct.is_orb_enabled))
    return false;
  if (!mojo::Equals(this->ignore_isolated_world_origin, other_struct.ignore_isolated_world_origin))
    return false;
  if (!mojo::Equals(this->unsafe_non_webby_initiator, other_struct.unsafe_non_webby_initiator))
    return false;
  if (!mojo::Equals(this->disable_web_security, other_struct.disable_web_security))
    return false;
  if (!mojo::Equals(this->header_client, other_struct.header_client))
    return false;
  if (!mojo::Equals(this->isolation_info, other_struct.isolation_info))
    return false;
  if (!mojo::Equals(this->disable_secure_dns, other_struct.disable_secure_dns))
    return false;
  if (!mojo::Equals(this->is_trusted, other_struct.is_trusted))
    return false;
  if (!mojo::Equals(this->automatically_assign_isolation_info, other_struct.automatically_assign_isolation_info))
    return false;
  if (!mojo::Equals(this->top_frame_id, other_struct.top_frame_id))
    return false;
  if (!mojo::Equals(this->factory_override, other_struct.factory_override))
    return false;
  if (!mojo::Equals(this->client_security_state, other_struct.client_security_state))
    return false;
  if (!mojo::Equals(this->coep_reporter, other_struct.coep_reporter))
    return false;
  if (!mojo::Equals(this->dip_reporter, other_struct.dip_reporter))
    return false;
  if (!mojo::Equals(this->cookie_observer, other_struct.cookie_observer))
    return false;
  if (!mojo::Equals(this->trust_token_observer, other_struct.trust_token_observer))
    return false;
  if (!mojo::Equals(this->shared_dictionary_observer, other_struct.shared_dictionary_observer))
    return false;
  if (!mojo::Equals(this->url_loader_network_observer, other_struct.url_loader_network_observer))
    return false;
  if (!mojo::Equals(this->devtools_observer, other_struct.devtools_observer))
    return false;
  if (!mojo::Equals(this->device_bound_session_observer, other_struct.device_bound_session_observer))
    return false;
  if (!mojo::Equals(this->trust_token_issuance_policy, other_struct.trust_token_issuance_policy))
    return false;
  if (!mojo::Equals(this->trust_token_redemption_policy, other_struct.trust_token_redemption_policy))
    return false;
  if (!mojo::Equals(this->debug_tag, other_struct.debug_tag))
    return false;
  if (!mojo::Equals(this->cookie_setting_overrides, other_struct.cookie_setting_overrides))
    return false;
  if (!mojo::Equals(this->devtools_cookie_setting_overrides, other_struct.devtools_cookie_setting_overrides))
    return false;
  if (!mojo::Equals(this->require_cross_site_request_for_cookies, other_struct.require_cross_site_request_for_cookies))
    return false;
  if (!mojo::Equals(this->ignore_factory_reset, other_struct.ignore_factory_reset))
    return false;
  return true;
}

template <typename T, URLLoaderFactoryParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.process_id < rhs.process_id)
    return true;
  if (rhs.process_id < lhs.process_id)
    return false;
  if (lhs.request_initiator_origin_lock < rhs.request_initiator_origin_lock)
    return true;
  if (rhs.request_initiator_origin_lock < lhs.request_initiator_origin_lock)
    return false;
  if (lhs.is_orb_enabled < rhs.is_orb_enabled)
    return true;
  if (rhs.is_orb_enabled < lhs.is_orb_enabled)
    return false;
  if (lhs.ignore_isolated_world_origin < rhs.ignore_isolated_world_origin)
    return true;
  if (rhs.ignore_isolated_world_origin < lhs.ignore_isolated_world_origin)
    return false;
  if (lhs.unsafe_non_webby_initiator < rhs.unsafe_non_webby_initiator)
    return true;
  if (rhs.unsafe_non_webby_initiator < lhs.unsafe_non_webby_initiator)
    return false;
  if (lhs.disable_web_security < rhs.disable_web_security)
    return true;
  if (rhs.disable_web_security < lhs.disable_web_security)
    return false;
  if (lhs.header_client < rhs.header_client)
    return true;
  if (rhs.header_client < lhs.header_client)
    return false;
  if (lhs.isolation_info < rhs.isolation_info)
    return true;
  if (rhs.isolation_info < lhs.isolation_info)
    return false;
  if (lhs.disable_secure_dns < rhs.disable_secure_dns)
    return true;
  if (rhs.disable_secure_dns < lhs.disable_secure_dns)
    return false;
  if (lhs.is_trusted < rhs.is_trusted)
    return true;
  if (rhs.is_trusted < lhs.is_trusted)
    return false;
  if (lhs.automatically_assign_isolation_info < rhs.automatically_assign_isolation_info)
    return true;
  if (rhs.automatically_assign_isolation_info < lhs.automatically_assign_isolation_info)
    return false;
  if (lhs.top_frame_id < rhs.top_frame_id)
    return true;
  if (rhs.top_frame_id < lhs.top_frame_id)
    return false;
  if (lhs.factory_override < rhs.factory_override)
    return true;
  if (rhs.factory_override < lhs.factory_override)
    return false;
  if (lhs.client_security_state < rhs.client_security_state)
    return true;
  if (rhs.client_security_state < lhs.client_security_state)
    return false;
  if (lhs.coep_reporter < rhs.coep_reporter)
    return true;
  if (rhs.coep_reporter < lhs.coep_reporter)
    return false;
  if (lhs.dip_reporter < rhs.dip_reporter)
    return true;
  if (rhs.dip_reporter < lhs.dip_reporter)
    return false;
  if (lhs.cookie_observer < rhs.cookie_observer)
    return true;
  if (rhs.cookie_observer < lhs.cookie_observer)
    return false;
  if (lhs.trust_token_observer < rhs.trust_token_observer)
    return true;
  if (rhs.trust_token_observer < lhs.trust_token_observer)
    return false;
  if (lhs.shared_dictionary_observer < rhs.shared_dictionary_observer)
    return true;
  if (rhs.shared_dictionary_observer < lhs.shared_dictionary_observer)
    return false;
  if (lhs.url_loader_network_observer < rhs.url_loader_network_observer)
    return true;
  if (rhs.url_loader_network_observer < lhs.url_loader_network_observer)
    return false;
  if (lhs.devtools_observer < rhs.devtools_observer)
    return true;
  if (rhs.devtools_observer < lhs.devtools_observer)
    return false;
  if (lhs.device_bound_session_observer < rhs.device_bound_session_observer)
    return true;
  if (rhs.device_bound_session_observer < lhs.device_bound_session_observer)
    return false;
  if (lhs.trust_token_issuance_policy < rhs.trust_token_issuance_policy)
    return true;
  if (rhs.trust_token_issuance_policy < lhs.trust_token_issuance_policy)
    return false;
  if (lhs.trust_token_redemption_policy < rhs.trust_token_redemption_policy)
    return true;
  if (rhs.trust_token_redemption_policy < lhs.trust_token_redemption_policy)
    return false;
  if (lhs.debug_tag < rhs.debug_tag)
    return true;
  if (rhs.debug_tag < lhs.debug_tag)
    return false;
  if (lhs.cookie_setting_overrides < rhs.cookie_setting_overrides)
    return true;
  if (rhs.cookie_setting_overrides < lhs.cookie_setting_overrides)
    return false;
  if (lhs.devtools_cookie_setting_overrides < rhs.devtools_cookie_setting_overrides)
    return true;
  if (rhs.devtools_cookie_setting_overrides < lhs.devtools_cookie_setting_overrides)
    return false;
  if (lhs.require_cross_site_request_for_cookies < rhs.require_cross_site_request_for_cookies)
    return true;
  if (rhs.require_cross_site_request_for_cookies < lhs.require_cross_site_request_for_cookies)
    return false;
  if (lhs.ignore_factory_reset < rhs.ignore_factory_reset)
    return true;
  if (rhs.ignore_factory_reset < lhs.ignore_factory_reset)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::CustomProxyConfig::DataView,
                                         ::network::mojom::CustomProxyConfigPtr> {
  static bool IsNull(const ::network::mojom::CustomProxyConfigPtr& input) { return !input; }
  static void SetToNull(::network::mojom::CustomProxyConfigPtr* output) { output->reset(); }

  static const decltype(::network::mojom::CustomProxyConfig::rules)& rules(
      const ::network::mojom::CustomProxyConfigPtr& input) {
    return input->rules;
  }

  static decltype(::network::mojom::CustomProxyConfig::should_override_existing_config) should_override_existing_config(
      const ::network::mojom::CustomProxyConfigPtr& input) {
    return input->should_override_existing_config;
  }

  static decltype(::network::mojom::CustomProxyConfig::allow_non_idempotent_methods) allow_non_idempotent_methods(
      const ::network::mojom::CustomProxyConfigPtr& input) {
    return input->allow_non_idempotent_methods;
  }

  static const decltype(::network::mojom::CustomProxyConfig::connect_tunnel_headers)& connect_tunnel_headers(
      const ::network::mojom::CustomProxyConfigPtr& input) {
    return input->connect_tunnel_headers;
  }

  static bool Read(::network::mojom::CustomProxyConfig::DataView input, ::network::mojom::CustomProxyConfigPtr* output);
};


template <>
struct  StructTraits<::network::mojom::CertVerifierServiceRemoteParams::DataView,
                                         ::network::mojom::CertVerifierServiceRemoteParamsPtr> {
  static bool IsNull(const ::network::mojom::CertVerifierServiceRemoteParamsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::CertVerifierServiceRemoteParamsPtr* output) { output->reset(); }

  static  decltype(::network::mojom::CertVerifierServiceRemoteParams::cert_verifier_service)& cert_verifier_service(
       ::network::mojom::CertVerifierServiceRemoteParamsPtr& input) {
    return input->cert_verifier_service;
  }

  static  decltype(::network::mojom::CertVerifierServiceRemoteParams::cert_verifier_service_client_receiver)& cert_verifier_service_client_receiver(
       ::network::mojom::CertVerifierServiceRemoteParamsPtr& input) {
    return input->cert_verifier_service_client_receiver;
  }

  static bool Read(::network::mojom::CertVerifierServiceRemoteParams::DataView input, ::network::mojom::CertVerifierServiceRemoteParamsPtr* output);
};


template <>
struct  StructTraits<::network::mojom::HttpAuthStaticNetworkContextParams::DataView,
                                         ::network::mojom::HttpAuthStaticNetworkContextParamsPtr> {
  static bool IsNull(const ::network::mojom::HttpAuthStaticNetworkContextParamsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::HttpAuthStaticNetworkContextParamsPtr* output) { output->reset(); }

  static decltype(::network::mojom::HttpAuthStaticNetworkContextParams::allow_default_credentials) allow_default_credentials(
      const ::network::mojom::HttpAuthStaticNetworkContextParamsPtr& input) {
    return input->allow_default_credentials;
  }

  static bool Read(::network::mojom::HttpAuthStaticNetworkContextParams::DataView input, ::network::mojom::HttpAuthStaticNetworkContextParamsPtr* output);
};


template <>
struct  StructTraits<::network::mojom::CTPolicy::DataView,
                                         ::network::mojom::CTPolicyPtr> {
  static bool IsNull(const ::network::mojom::CTPolicyPtr& input) { return !input; }
  static void SetToNull(::network::mojom::CTPolicyPtr* output) { output->reset(); }

  static const decltype(::network::mojom::CTPolicy::excluded_hosts)& excluded_hosts(
      const ::network::mojom::CTPolicyPtr& input) {
    return input->excluded_hosts;
  }

  static const decltype(::network::mojom::CTPolicy::excluded_spkis)& excluded_spkis(
      const ::network::mojom::CTPolicyPtr& input) {
    return input->excluded_spkis;
  }

  static bool Read(::network::mojom::CTPolicy::DataView input, ::network::mojom::CTPolicyPtr* output);
};


template <>
struct  StructTraits<::network::mojom::NetworkContextFilePaths::DataView,
                                         ::network::mojom::NetworkContextFilePathsPtr> {
  static bool IsNull(const ::network::mojom::NetworkContextFilePathsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::NetworkContextFilePathsPtr* output) { output->reset(); }

  static  decltype(::network::mojom::NetworkContextFilePaths::shared_dictionary_directory)& shared_dictionary_directory(
       ::network::mojom::NetworkContextFilePathsPtr& input) {
    return input->shared_dictionary_directory;
  }

  static  decltype(::network::mojom::NetworkContextFilePaths::http_cache_directory)& http_cache_directory(
       ::network::mojom::NetworkContextFilePathsPtr& input) {
    return input->http_cache_directory;
  }

  static  decltype(::network::mojom::NetworkContextFilePaths::no_vary_search_directory)& no_vary_search_directory(
       ::network::mojom::NetworkContextFilePathsPtr& input) {
    return input->no_vary_search_directory;
  }

  static  decltype(::network::mojom::NetworkContextFilePaths::data_directory)& data_directory(
       ::network::mojom::NetworkContextFilePathsPtr& input) {
    return input->data_directory;
  }

  static const decltype(::network::mojom::NetworkContextFilePaths::unsandboxed_data_path)& unsandboxed_data_path(
      const ::network::mojom::NetworkContextFilePathsPtr& input) {
    return input->unsandboxed_data_path;
  }

  static const decltype(::network::mojom::NetworkContextFilePaths::cookie_database_name)& cookie_database_name(
      const ::network::mojom::NetworkContextFilePathsPtr& input) {
    return input->cookie_database_name;
  }

  static const decltype(::network::mojom::NetworkContextFilePaths::device_bound_sessions_database_name)& device_bound_sessions_database_name(
      const ::network::mojom::NetworkContextFilePathsPtr& input) {
    return input->device_bound_sessions_database_name;
  }

  static const decltype(::network::mojom::NetworkContextFilePaths::trust_token_database_name)& trust_token_database_name(
      const ::network::mojom::NetworkContextFilePathsPtr& input) {
    return input->trust_token_database_name;
  }

  static const decltype(::network::mojom::NetworkContextFilePaths::http_server_properties_file_name)& http_server_properties_file_name(
      const ::network::mojom::NetworkContextFilePathsPtr& input) {
    return input->http_server_properties_file_name;
  }

  static const decltype(::network::mojom::NetworkContextFilePaths::transport_security_persister_file_name)& transport_security_persister_file_name(
      const ::network::mojom::NetworkContextFilePathsPtr& input) {
    return input->transport_security_persister_file_name;
  }

  static const decltype(::network::mojom::NetworkContextFilePaths::reporting_and_nel_store_database_name)& reporting_and_nel_store_database_name(
      const ::network::mojom::NetworkContextFilePathsPtr& input) {
    return input->reporting_and_nel_store_database_name;
  }

  static const decltype(::network::mojom::NetworkContextFilePaths::sct_auditing_pending_reports_file_name)& sct_auditing_pending_reports_file_name(
      const ::network::mojom::NetworkContextFilePathsPtr& input) {
    return input->sct_auditing_pending_reports_file_name;
  }

  static decltype(::network::mojom::NetworkContextFilePaths::trigger_migration) trigger_migration(
      const ::network::mojom::NetworkContextFilePathsPtr& input) {
    return input->trigger_migration;
  }

  static bool Read(::network::mojom::NetworkContextFilePaths::DataView input, ::network::mojom::NetworkContextFilePathsPtr* output);
};


template <>
struct  StructTraits<::network::mojom::NetworkContextParams::DataView,
                                         ::network::mojom::NetworkContextParamsPtr> {
  static bool IsNull(const ::network::mojom::NetworkContextParamsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::NetworkContextParamsPtr* output) { output->reset(); }

  static const decltype(::network::mojom::NetworkContextParams::user_agent)& user_agent(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->user_agent;
  }

  static const decltype(::network::mojom::NetworkContextParams::accept_language)& accept_language(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->accept_language;
  }

  static decltype(::network::mojom::NetworkContextParams::enable_brotli) enable_brotli(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->enable_brotli;
  }

  static decltype(::network::mojom::NetworkContextParams::enable_zstd) enable_zstd(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->enable_zstd;
  }

  static decltype(::network::mojom::NetworkContextParams::enable_referrers) enable_referrers(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->enable_referrers;
  }

  static decltype(::network::mojom::NetworkContextParams::validate_referrer_policy_on_initial_request) validate_referrer_policy_on_initial_request(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->validate_referrer_policy_on_initial_request;
  }

  static  decltype(::network::mojom::NetworkContextParams::proxy_resolver_factory)& proxy_resolver_factory(
       ::network::mojom::NetworkContextParamsPtr& input) {
    return input->proxy_resolver_factory;
  }

  static decltype(::network::mojom::NetworkContextParams::enable_encrypted_cookies) enable_encrypted_cookies(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->enable_encrypted_cookies;
  }

  static decltype(::network::mojom::NetworkContextParams::restore_old_session_cookies) restore_old_session_cookies(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->restore_old_session_cookies;
  }

  static decltype(::network::mojom::NetworkContextParams::persist_session_cookies) persist_session_cookies(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->persist_session_cookies;
  }

  static decltype(::network::mojom::NetworkContextParams::http_cache_enabled) http_cache_enabled(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->http_cache_enabled;
  }

  static decltype(::network::mojom::NetworkContextParams::http_cache_max_size) http_cache_max_size(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->http_cache_max_size;
  }

  static  decltype(::network::mojom::NetworkContextParams::http_cache_file_operations_factory)& http_cache_file_operations_factory(
       ::network::mojom::NetworkContextParamsPtr& input) {
    return input->http_cache_file_operations_factory;
  }

  static decltype(::network::mojom::NetworkContextParams::disable_idle_sockets_close_on_memory_pressure) disable_idle_sockets_close_on_memory_pressure(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->disable_idle_sockets_close_on_memory_pressure;
  }

  static const decltype(::network::mojom::NetworkContextParams::initial_ssl_config)& initial_ssl_config(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->initial_ssl_config;
  }

  static  decltype(::network::mojom::NetworkContextParams::ssl_config_client_receiver)& ssl_config_client_receiver(
       ::network::mojom::NetworkContextParamsPtr& input) {
    return input->ssl_config_client_receiver;
  }

  static  decltype(::network::mojom::NetworkContextParams::initial_proxy_config)& initial_proxy_config(
       ::network::mojom::NetworkContextParamsPtr& input) {
    return input->initial_proxy_config;
  }

  static  decltype(::network::mojom::NetworkContextParams::proxy_config_client_receiver)& proxy_config_client_receiver(
       ::network::mojom::NetworkContextParamsPtr& input) {
    return input->proxy_config_client_receiver;
  }

  static const decltype(::network::mojom::NetworkContextParams::initial_custom_proxy_config)& initial_custom_proxy_config(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->initial_custom_proxy_config;
  }

  static  decltype(::network::mojom::NetworkContextParams::custom_proxy_config_client_receiver)& custom_proxy_config_client_receiver(
       ::network::mojom::NetworkContextParamsPtr& input) {
    return input->custom_proxy_config_client_receiver;
  }

  static  decltype(::network::mojom::NetworkContextParams::custom_proxy_connection_observer_remote)& custom_proxy_connection_observer_remote(
       ::network::mojom::NetworkContextParamsPtr& input) {
    return input->custom_proxy_connection_observer_remote;
  }

  static  decltype(::network::mojom::NetworkContextParams::proxy_config_poller_client)& proxy_config_poller_client(
       ::network::mojom::NetworkContextParamsPtr& input) {
    return input->proxy_config_poller_client;
  }

  static  decltype(::network::mojom::NetworkContextParams::proxy_error_client)& proxy_error_client(
       ::network::mojom::NetworkContextParamsPtr& input) {
    return input->proxy_error_client;
  }

  static  decltype(::network::mojom::NetworkContextParams::ip_protection_core_host)& ip_protection_core_host(
       ::network::mojom::NetworkContextParamsPtr& input) {
    return input->ip_protection_core_host;
  }

  static  decltype(::network::mojom::NetworkContextParams::ip_protection_control)& ip_protection_control(
       ::network::mojom::NetworkContextParamsPtr& input) {
    return input->ip_protection_control;
  }

  static decltype(::network::mojom::NetworkContextParams::enable_ip_protection) enable_ip_protection(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->enable_ip_protection;
  }

  static decltype(::network::mojom::NetworkContextParams::ip_protection_incognito) ip_protection_incognito(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->ip_protection_incognito;
  }

  static const decltype(::network::mojom::NetworkContextParams::ip_protection_data_directory)& ip_protection_data_directory(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->ip_protection_data_directory;
  }

  static decltype(::network::mojom::NetworkContextParams::pac_quick_check_enabled) pac_quick_check_enabled(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->pac_quick_check_enabled;
  }

  static decltype(::network::mojom::NetworkContextParams::enable_certificate_reporting) enable_certificate_reporting(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->enable_certificate_reporting;
  }

  static decltype(::network::mojom::NetworkContextParams::enforce_chrome_ct_policy) enforce_chrome_ct_policy(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->enforce_chrome_ct_policy;
  }

  static decltype(::network::mojom::NetworkContextParams::sct_auditing_mode) sct_auditing_mode(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->sct_auditing_mode;
  }

  static const decltype(::network::mojom::NetworkContextParams::ct_policy)& ct_policy(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->ct_policy;
  }

  static  decltype(::network::mojom::NetworkContextParams::cert_verifier_params)& cert_verifier_params(
       ::network::mojom::NetworkContextParamsPtr& input) {
    return input->cert_verifier_params;
  }

  static const decltype(::network::mojom::NetworkContextParams::cookie_manager_params)& cookie_manager_params(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->cookie_manager_params;
  }

  static  decltype(::network::mojom::NetworkContextParams::cookie_manager)& cookie_manager(
       ::network::mojom::NetworkContextParamsPtr& input) {
    return input->cookie_manager;
  }

  static decltype(::network::mojom::NetworkContextParams::enable_domain_reliability) enable_domain_reliability(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->enable_domain_reliability;
  }

  static const decltype(::network::mojom::NetworkContextParams::domain_reliability_upload_reporter)& domain_reliability_upload_reporter(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->domain_reliability_upload_reporter;
  }

  static decltype(::network::mojom::NetworkContextParams::discard_domain_reliablity_uploads) discard_domain_reliablity_uploads(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->discard_domain_reliablity_uploads;
  }

  static const decltype(::network::mojom::NetworkContextParams::reporting_delivery_interval)& reporting_delivery_interval(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->reporting_delivery_interval;
  }

  static decltype(::network::mojom::NetworkContextParams::skip_reporting_send_permission_check) skip_reporting_send_permission_check(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->skip_reporting_send_permission_check;
  }

  static const decltype(::network::mojom::NetworkContextParams::cors_origin_access_list)& cors_origin_access_list(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->cors_origin_access_list;
  }

  static const decltype(::network::mojom::NetworkContextParams::cors_exempt_header_list)& cors_exempt_header_list(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->cors_exempt_header_list;
  }

  static decltype(::network::mojom::NetworkContextParams::allow_any_cors_exempt_header_for_browser) allow_any_cors_exempt_header_for_browser(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->allow_any_cors_exempt_header_for_browser;
  }

  static const decltype(::network::mojom::NetworkContextParams::hsts_policy_bypass_list)& hsts_policy_bypass_list(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->hsts_policy_bypass_list;
  }

  static const decltype(::network::mojom::NetworkContextParams::http_auth_static_network_context_params)& http_auth_static_network_context_params(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->http_auth_static_network_context_params;
  }

  static decltype(::network::mojom::NetworkContextParams::reset_http_cache_backend) reset_http_cache_backend(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->reset_http_cache_backend;
  }

  static decltype(::network::mojom::NetworkContextParams::split_auth_cache_by_network_anonymization_key) split_auth_cache_by_network_anonymization_key(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->split_auth_cache_by_network_anonymization_key;
  }

  static decltype(::network::mojom::NetworkContextParams::require_network_anonymization_key) require_network_anonymization_key(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->require_network_anonymization_key;
  }

  static  decltype(::network::mojom::NetworkContextParams::file_paths)& file_paths(
       ::network::mojom::NetworkContextParamsPtr& input) {
    return input->file_paths;
  }

  static decltype(::network::mojom::NetworkContextParams::block_trust_tokens) block_trust_tokens(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->block_trust_tokens;
  }

  static decltype(::network::mojom::NetworkContextParams::shared_dictionary_enabled) shared_dictionary_enabled(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->shared_dictionary_enabled;
  }

  static decltype(::network::mojom::NetworkContextParams::shared_dictionary_cache_max_size) shared_dictionary_cache_max_size(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->shared_dictionary_cache_max_size;
  }

  static const decltype(::network::mojom::NetworkContextParams::first_party_sets_access_delegate_params)& first_party_sets_access_delegate_params(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->first_party_sets_access_delegate_params;
  }

  static  decltype(::network::mojom::NetworkContextParams::first_party_sets_access_delegate_receiver)& first_party_sets_access_delegate_receiver(
       ::network::mojom::NetworkContextParamsPtr& input) {
    return input->first_party_sets_access_delegate_receiver;
  }

  static decltype(::network::mojom::NetworkContextParams::acam_preflight_spec_conformant) acam_preflight_spec_conformant(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->acam_preflight_spec_conformant;
  }

  static const decltype(::network::mojom::NetworkContextParams::cookie_deprecation_label)& cookie_deprecation_label(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->cookie_deprecation_label;
  }

  static  decltype(::network::mojom::NetworkContextParams::cookie_encryption_provider)& cookie_encryption_provider(
       ::network::mojom::NetworkContextParamsPtr& input) {
    return input->cookie_encryption_provider;
  }

  static decltype(::network::mojom::NetworkContextParams::device_bound_sessions_enabled) device_bound_sessions_enabled(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->device_bound_sessions_enabled;
  }

  static decltype(::network::mojom::NetworkContextParams::bound_network) bound_network(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->bound_network;
  }

  static const decltype(::network::mojom::NetworkContextParams::enterprise_reporting_endpoints)& enterprise_reporting_endpoints(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->enterprise_reporting_endpoints;
  }

  static decltype(::network::mojom::NetworkContextParams::quic_idle_connection_timeout_seconds) quic_idle_connection_timeout_seconds(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->quic_idle_connection_timeout_seconds;
  }

  static bool Read(::network::mojom::NetworkContextParams::DataView input, ::network::mojom::NetworkContextParamsPtr* output);
};


template <>
struct  StructTraits<::network::mojom::NetworkConditions::DataView,
                                         ::network::mojom::NetworkConditionsPtr> {
  static bool IsNull(const ::network::mojom::NetworkConditionsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::NetworkConditionsPtr* output) { output->reset(); }

  static decltype(::network::mojom::NetworkConditions::offline) offline(
      const ::network::mojom::NetworkConditionsPtr& input) {
    return input->offline;
  }

  static const decltype(::network::mojom::NetworkConditions::latency)& latency(
      const ::network::mojom::NetworkConditionsPtr& input) {
    return input->latency;
  }

  static decltype(::network::mojom::NetworkConditions::download_throughput) download_throughput(
      const ::network::mojom::NetworkConditionsPtr& input) {
    return input->download_throughput;
  }

  static decltype(::network::mojom::NetworkConditions::upload_throughput) upload_throughput(
      const ::network::mojom::NetworkConditionsPtr& input) {
    return input->upload_throughput;
  }

  static decltype(::network::mojom::NetworkConditions::packet_loss) packet_loss(
      const ::network::mojom::NetworkConditionsPtr& input) {
    return input->packet_loss;
  }

  static decltype(::network::mojom::NetworkConditions::packet_queue_length) packet_queue_length(
      const ::network::mojom::NetworkConditionsPtr& input) {
    return input->packet_queue_length;
  }

  static decltype(::network::mojom::NetworkConditions::packet_reordering) packet_reordering(
      const ::network::mojom::NetworkConditionsPtr& input) {
    return input->packet_reordering;
  }

  static bool Read(::network::mojom::NetworkConditions::DataView input, ::network::mojom::NetworkConditionsPtr* output);
};


template <>
struct  StructTraits<::network::mojom::SharedDictionaryInfo::DataView,
                                         ::network::mojom::SharedDictionaryInfoPtr> {
  static bool IsNull(const ::network::mojom::SharedDictionaryInfoPtr& input) { return !input; }
  static void SetToNull(::network::mojom::SharedDictionaryInfoPtr* output) { output->reset(); }

  static const decltype(::network::mojom::SharedDictionaryInfo::match)& match(
      const ::network::mojom::SharedDictionaryInfoPtr& input) {
    return input->match;
  }

  static const decltype(::network::mojom::SharedDictionaryInfo::match_dest)& match_dest(
      const ::network::mojom::SharedDictionaryInfoPtr& input) {
    return input->match_dest;
  }

  static const decltype(::network::mojom::SharedDictionaryInfo::id)& id(
      const ::network::mojom::SharedDictionaryInfoPtr& input) {
    return input->id;
  }

  static const decltype(::network::mojom::SharedDictionaryInfo::dictionary_url)& dictionary_url(
      const ::network::mojom::SharedDictionaryInfoPtr& input) {
    return input->dictionary_url;
  }

  static const decltype(::network::mojom::SharedDictionaryInfo::last_fetch_time)& last_fetch_time(
      const ::network::mojom::SharedDictionaryInfoPtr& input) {
    return input->last_fetch_time;
  }

  static const decltype(::network::mojom::SharedDictionaryInfo::response_time)& response_time(
      const ::network::mojom::SharedDictionaryInfoPtr& input) {
    return input->response_time;
  }

  static const decltype(::network::mojom::SharedDictionaryInfo::expiration)& expiration(
      const ::network::mojom::SharedDictionaryInfoPtr& input) {
    return input->expiration;
  }

  static const decltype(::network::mojom::SharedDictionaryInfo::last_used_time)& last_used_time(
      const ::network::mojom::SharedDictionaryInfoPtr& input) {
    return input->last_used_time;
  }

  static decltype(::network::mojom::SharedDictionaryInfo::size) size(
      const ::network::mojom::SharedDictionaryInfoPtr& input) {
    return input->size;
  }

  static const decltype(::network::mojom::SharedDictionaryInfo::hash)& hash(
      const ::network::mojom::SharedDictionaryInfoPtr& input) {
    return input->hash;
  }

  static bool Read(::network::mojom::SharedDictionaryInfo::DataView input, ::network::mojom::SharedDictionaryInfoPtr* output);
};


template <>
struct  StructTraits<::network::mojom::SignedExchangeReport::DataView,
                                         ::network::mojom::SignedExchangeReportPtr> {
  static bool IsNull(const ::network::mojom::SignedExchangeReportPtr& input) { return !input; }
  static void SetToNull(::network::mojom::SignedExchangeReportPtr* output) { output->reset(); }

  static decltype(::network::mojom::SignedExchangeReport::success) success(
      const ::network::mojom::SignedExchangeReportPtr& input) {
    return input->success;
  }

  static const decltype(::network::mojom::SignedExchangeReport::type)& type(
      const ::network::mojom::SignedExchangeReportPtr& input) {
    return input->type;
  }

  static const decltype(::network::mojom::SignedExchangeReport::outer_url)& outer_url(
      const ::network::mojom::SignedExchangeReportPtr& input) {
    return input->outer_url;
  }

  static const decltype(::network::mojom::SignedExchangeReport::inner_url)& inner_url(
      const ::network::mojom::SignedExchangeReportPtr& input) {
    return input->inner_url;
  }

  static const decltype(::network::mojom::SignedExchangeReport::cert_url)& cert_url(
      const ::network::mojom::SignedExchangeReportPtr& input) {
    return input->cert_url;
  }

  static const decltype(::network::mojom::SignedExchangeReport::referrer)& referrer(
      const ::network::mojom::SignedExchangeReportPtr& input) {
    return input->referrer;
  }

  static const decltype(::network::mojom::SignedExchangeReport::server_ip_address)& server_ip_address(
      const ::network::mojom::SignedExchangeReportPtr& input) {
    return input->server_ip_address;
  }

  static const decltype(::network::mojom::SignedExchangeReport::protocol)& protocol(
      const ::network::mojom::SignedExchangeReportPtr& input) {
    return input->protocol;
  }

  static const decltype(::network::mojom::SignedExchangeReport::method)& method(
      const ::network::mojom::SignedExchangeReportPtr& input) {
    return input->method;
  }

  static decltype(::network::mojom::SignedExchangeReport::status_code) status_code(
      const ::network::mojom::SignedExchangeReportPtr& input) {
    return input->status_code;
  }

  static const decltype(::network::mojom::SignedExchangeReport::elapsed_time)& elapsed_time(
      const ::network::mojom::SignedExchangeReportPtr& input) {
    return input->elapsed_time;
  }

  static bool Read(::network::mojom::SignedExchangeReport::DataView input, ::network::mojom::SignedExchangeReportPtr* output);
};


template <>
struct  StructTraits<::network::mojom::URLLoaderFactoryOverride::DataView,
                                         ::network::mojom::URLLoaderFactoryOverridePtr> {
  static bool IsNull(const ::network::mojom::URLLoaderFactoryOverridePtr& input) { return !input; }
  static void SetToNull(::network::mojom::URLLoaderFactoryOverridePtr* output) { output->reset(); }

  static  decltype(::network::mojom::URLLoaderFactoryOverride::overriding_factory)& overriding_factory(
       ::network::mojom::URLLoaderFactoryOverridePtr& input) {
    return input->overriding_factory;
  }

  static  decltype(::network::mojom::URLLoaderFactoryOverride::overridden_factory_receiver)& overridden_factory_receiver(
       ::network::mojom::URLLoaderFactoryOverridePtr& input) {
    return input->overridden_factory_receiver;
  }

  static decltype(::network::mojom::URLLoaderFactoryOverride::skip_cors_enabled_scheme_check) skip_cors_enabled_scheme_check(
      const ::network::mojom::URLLoaderFactoryOverridePtr& input) {
    return input->skip_cors_enabled_scheme_check;
  }

  static bool Read(::network::mojom::URLLoaderFactoryOverride::DataView input, ::network::mojom::URLLoaderFactoryOverridePtr* output);
};


template <>
struct  StructTraits<::network::mojom::URLLoaderFactoryParams::DataView,
                                         ::network::mojom::URLLoaderFactoryParamsPtr> {
  static bool IsNull(const ::network::mojom::URLLoaderFactoryParamsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::URLLoaderFactoryParamsPtr* output) { output->reset(); }

  static decltype(::network::mojom::URLLoaderFactoryParams::process_id) process_id(
      const ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->process_id;
  }

  static const decltype(::network::mojom::URLLoaderFactoryParams::request_initiator_origin_lock)& request_initiator_origin_lock(
      const ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->request_initiator_origin_lock;
  }

  static decltype(::network::mojom::URLLoaderFactoryParams::is_orb_enabled) is_orb_enabled(
      const ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->is_orb_enabled;
  }

  static decltype(::network::mojom::URLLoaderFactoryParams::ignore_isolated_world_origin) ignore_isolated_world_origin(
      const ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->ignore_isolated_world_origin;
  }

  static decltype(::network::mojom::URLLoaderFactoryParams::unsafe_non_webby_initiator) unsafe_non_webby_initiator(
      const ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->unsafe_non_webby_initiator;
  }

  static decltype(::network::mojom::URLLoaderFactoryParams::disable_web_security) disable_web_security(
      const ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->disable_web_security;
  }

  static  decltype(::network::mojom::URLLoaderFactoryParams::header_client)& header_client(
       ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->header_client;
  }

  static const decltype(::network::mojom::URLLoaderFactoryParams::isolation_info)& isolation_info(
      const ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->isolation_info;
  }

  static decltype(::network::mojom::URLLoaderFactoryParams::disable_secure_dns) disable_secure_dns(
      const ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->disable_secure_dns;
  }

  static decltype(::network::mojom::URLLoaderFactoryParams::is_trusted) is_trusted(
      const ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->is_trusted;
  }

  static decltype(::network::mojom::URLLoaderFactoryParams::automatically_assign_isolation_info) automatically_assign_isolation_info(
      const ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->automatically_assign_isolation_info;
  }

  static const decltype(::network::mojom::URLLoaderFactoryParams::top_frame_id)& top_frame_id(
      const ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->top_frame_id;
  }

  static  decltype(::network::mojom::URLLoaderFactoryParams::factory_override)& factory_override(
       ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->factory_override;
  }

  static const decltype(::network::mojom::URLLoaderFactoryParams::client_security_state)& client_security_state(
      const ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->client_security_state;
  }

  static  decltype(::network::mojom::URLLoaderFactoryParams::coep_reporter)& coep_reporter(
       ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->coep_reporter;
  }

  static  decltype(::network::mojom::URLLoaderFactoryParams::dip_reporter)& dip_reporter(
       ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->dip_reporter;
  }

  static  decltype(::network::mojom::URLLoaderFactoryParams::cookie_observer)& cookie_observer(
       ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->cookie_observer;
  }

  static  decltype(::network::mojom::URLLoaderFactoryParams::trust_token_observer)& trust_token_observer(
       ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->trust_token_observer;
  }

  static  decltype(::network::mojom::URLLoaderFactoryParams::shared_dictionary_observer)& shared_dictionary_observer(
       ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->shared_dictionary_observer;
  }

  static  decltype(::network::mojom::URLLoaderFactoryParams::url_loader_network_observer)& url_loader_network_observer(
       ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->url_loader_network_observer;
  }

  static  decltype(::network::mojom::URLLoaderFactoryParams::devtools_observer)& devtools_observer(
       ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->devtools_observer;
  }

  static  decltype(::network::mojom::URLLoaderFactoryParams::device_bound_session_observer)& device_bound_session_observer(
       ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->device_bound_session_observer;
  }

  static decltype(::network::mojom::URLLoaderFactoryParams::trust_token_issuance_policy) trust_token_issuance_policy(
      const ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->trust_token_issuance_policy;
  }

  static decltype(::network::mojom::URLLoaderFactoryParams::trust_token_redemption_policy) trust_token_redemption_policy(
      const ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->trust_token_redemption_policy;
  }

  static const decltype(::network::mojom::URLLoaderFactoryParams::debug_tag)& debug_tag(
      const ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->debug_tag;
  }

  static const decltype(::network::mojom::URLLoaderFactoryParams::cookie_setting_overrides)& cookie_setting_overrides(
      const ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->cookie_setting_overrides;
  }

  static const decltype(::network::mojom::URLLoaderFactoryParams::devtools_cookie_setting_overrides)& devtools_cookie_setting_overrides(
      const ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->devtools_cookie_setting_overrides;
  }

  static decltype(::network::mojom::URLLoaderFactoryParams::require_cross_site_request_for_cookies) require_cross_site_request_for_cookies(
      const ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->require_cross_site_request_for_cookies;
  }

  static decltype(::network::mojom::URLLoaderFactoryParams::ignore_factory_reset) ignore_factory_reset(
      const ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->ignore_factory_reset;
  }

  static bool Read(::network::mojom::URLLoaderFactoryParams::DataView input, ::network::mojom::URLLoaderFactoryParamsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_CONTEXT_MOJOM_H_