// services/network/public/mojom/parsed_headers.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_PARSED_HEADERS_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_PARSED_HEADERS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/parsed_headers.mojom-shared-internal.h"
#include "services/network/public/mojom/content_security_policy.mojom-shared.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-shared.h"
#include "services/network/public/mojom/cross_origin_opener_policy.mojom-shared.h"
#include "services/network/public/mojom/integrity_policy.mojom-shared.h"
#include "services/network/public/mojom/document_isolation_policy.mojom-shared.h"
#include "services/network/public/mojom/link_header.mojom-shared.h"
#include "services/network/public/mojom/no_vary_search.mojom-shared.h"
#include "services/network/public/mojom/supports_loading_mode.mojom-shared.h"
#include "services/network/public/mojom/timing_allow_origin.mojom-shared.h"
#include "services/network/public/mojom/web_client_hints_types.mojom-shared.h"
#include "services/network/public/mojom/x_frame_options.mojom-shared.h"




#include "services/network/public/mojom/parsed_headers.mojom-data-view.h"




namespace std {

template <>
struct hash<::network::mojom::OriginAgentClusterValue>
    : public mojo::internal::EnumHashImpl<::network::mojom::OriginAgentClusterValue> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::OriginAgentClusterValue, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::OriginAgentClusterValue, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::OriginAgentClusterValue>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ParsedHeadersDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ParsedHeadersDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ParsedHeaders_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::content_security_policy(input)) in_content_security_policy = Traits::content_security_policy(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->content_security_policy)::BaseType>
        content_security_policy_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& content_security_policy_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::ContentSecurityPolicyDataView>>(
      in_content_security_policy,
      content_security_policy_fragment,
      &content_security_policy_validate_params);

    fragment->content_security_policy.Set(
        content_security_policy_fragment.is_null() ? nullptr : content_security_policy_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->content_security_policy.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null content_security_policy in ParsedHeaders struct");

    decltype(Traits::allow_csp_from(input)) in_allow_csp_from = Traits::allow_csp_from(input);
    mojo::internal::MessageFragment<decltype(fragment->allow_csp_from)>
        allow_csp_from_fragment(fragment.message());
    allow_csp_from_fragment.Claim(&fragment->allow_csp_from);
    
    mojo::internal::Serialize<::network::mojom::AllowCSPFromHeaderValueDataView>(
      in_allow_csp_from,
      allow_csp_from_fragment,
      true);

    decltype(Traits::cross_origin_embedder_policy(input)) in_cross_origin_embedder_policy = Traits::cross_origin_embedder_policy(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cross_origin_embedder_policy)::BaseType> cross_origin_embedder_policy_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::CrossOriginEmbedderPolicyDataView>(
      in_cross_origin_embedder_policy,
      cross_origin_embedder_policy_fragment);

    fragment->cross_origin_embedder_policy.Set(
        cross_origin_embedder_policy_fragment.is_null() ? nullptr : cross_origin_embedder_policy_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->cross_origin_embedder_policy.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cross_origin_embedder_policy in ParsedHeaders struct");

    decltype(Traits::cross_origin_opener_policy(input)) in_cross_origin_opener_policy = Traits::cross_origin_opener_policy(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cross_origin_opener_policy)::BaseType> cross_origin_opener_policy_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::CrossOriginOpenerPolicyDataView>(
      in_cross_origin_opener_policy,
      cross_origin_opener_policy_fragment);

    fragment->cross_origin_opener_policy.Set(
        cross_origin_opener_policy_fragment.is_null() ? nullptr : cross_origin_opener_policy_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->cross_origin_opener_policy.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cross_origin_opener_policy in ParsedHeaders struct");

    decltype(Traits::document_isolation_policy(input)) in_document_isolation_policy = Traits::document_isolation_policy(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->document_isolation_policy)::BaseType> document_isolation_policy_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::DocumentIsolationPolicyDataView>(
      in_document_isolation_policy,
      document_isolation_policy_fragment);

    fragment->document_isolation_policy.Set(
        document_isolation_policy_fragment.is_null() ? nullptr : document_isolation_policy_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->document_isolation_policy.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null document_isolation_policy in ParsedHeaders struct");

    decltype(Traits::integrity_policy(input)) in_integrity_policy = Traits::integrity_policy(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->integrity_policy)::BaseType> integrity_policy_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::IntegrityPolicyDataView>(
      in_integrity_policy,
      integrity_policy_fragment);

    fragment->integrity_policy.Set(
        integrity_policy_fragment.is_null() ? nullptr : integrity_policy_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->integrity_policy.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null integrity_policy in ParsedHeaders struct");

    decltype(Traits::integrity_policy_report_only(input)) in_integrity_policy_report_only = Traits::integrity_policy_report_only(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->integrity_policy_report_only)::BaseType> integrity_policy_report_only_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::IntegrityPolicyDataView>(
      in_integrity_policy_report_only,
      integrity_policy_report_only_fragment);

    fragment->integrity_policy_report_only.Set(
        integrity_policy_report_only_fragment.is_null() ? nullptr : integrity_policy_report_only_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->integrity_policy_report_only.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null integrity_policy_report_only in ParsedHeaders struct");

    
    mojo::internal::Serialize<::network::mojom::OriginAgentClusterValue>(
      Traits::origin_agent_cluster(input),
      &fragment->origin_agent_cluster);

    decltype(Traits::accept_ch(input)) in_accept_ch = Traits::accept_ch(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->accept_ch)::BaseType>
        accept_ch_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& accept_ch_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::WebClientHintsType_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::WebClientHintsType>>(
      in_accept_ch,
      accept_ch_fragment,
      &accept_ch_validate_params);

    fragment->accept_ch.Set(
        accept_ch_fragment.is_null() ? nullptr : accept_ch_fragment.data());

    decltype(Traits::critical_ch(input)) in_critical_ch = Traits::critical_ch(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->critical_ch)::BaseType>
        critical_ch_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& critical_ch_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::WebClientHintsType_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::WebClientHintsType>>(
      in_critical_ch,
      critical_ch_fragment,
      &critical_ch_validate_params);

    fragment->critical_ch.Set(
        critical_ch_fragment.is_null() ? nullptr : critical_ch_fragment.data());

    fragment->client_hints_ignored_due_to_clear_site_data_header = Traits::client_hints_ignored_due_to_clear_site_data_header(input);

    
    mojo::internal::Serialize<::network::mojom::XFrameOptionsValue>(
      Traits::xfo(input),
      &fragment->xfo);

    decltype(Traits::link_headers(input)) in_link_headers = Traits::link_headers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->link_headers)::BaseType>
        link_headers_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& link_headers_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::LinkHeaderDataView>>(
      in_link_headers,
      link_headers_fragment,
      &link_headers_validate_params);

    fragment->link_headers.Set(
        link_headers_fragment.is_null() ? nullptr : link_headers_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->link_headers.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null link_headers in ParsedHeaders struct");

    decltype(Traits::timing_allow_origin(input)) in_timing_allow_origin = Traits::timing_allow_origin(input);
    mojo::internal::MessageFragment<decltype(fragment->timing_allow_origin)>
        timing_allow_origin_fragment(fragment.message());
    timing_allow_origin_fragment.Claim(&fragment->timing_allow_origin);
    
    mojo::internal::Serialize<::network::mojom::TimingAllowOriginDataView>(
      in_timing_allow_origin,
      timing_allow_origin_fragment,
      true);

    decltype(Traits::supports_loading_mode(input)) in_supports_loading_mode = Traits::supports_loading_mode(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->supports_loading_mode)::BaseType>
        supports_loading_mode_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& supports_loading_mode_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::LoadingMode_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::LoadingMode>>(
      in_supports_loading_mode,
      supports_loading_mode_fragment,
      &supports_loading_mode_validate_params);

    fragment->supports_loading_mode.Set(
        supports_loading_mode_fragment.is_null() ? nullptr : supports_loading_mode_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->supports_loading_mode.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null supports_loading_mode in ParsedHeaders struct");

    decltype(Traits::reporting_endpoints(input)) in_reporting_endpoints = Traits::reporting_endpoints(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->reporting_endpoints)::BaseType>
        reporting_endpoints_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& reporting_endpoints_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
      in_reporting_endpoints,
      reporting_endpoints_fragment,
      &reporting_endpoints_validate_params);

    fragment->reporting_endpoints.Set(
        reporting_endpoints_fragment.is_null() ? nullptr : reporting_endpoints_fragment.data());

    decltype(Traits::cookie_indices(input)) in_cookie_indices = Traits::cookie_indices(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cookie_indices)::BaseType>
        cookie_indices_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& cookie_indices_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_cookie_indices,
      cookie_indices_fragment,
      &cookie_indices_validate_params);

    fragment->cookie_indices.Set(
        cookie_indices_fragment.is_null() ? nullptr : cookie_indices_fragment.data());

    decltype(Traits::avail_language(input)) in_avail_language = Traits::avail_language(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->avail_language)::BaseType>
        avail_language_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& avail_language_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_avail_language,
      avail_language_fragment,
      &avail_language_validate_params);

    fragment->avail_language.Set(
        avail_language_fragment.is_null() ? nullptr : avail_language_fragment.data());

    decltype(Traits::content_language(input)) in_content_language = Traits::content_language(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->content_language)::BaseType>
        content_language_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& content_language_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_content_language,
      content_language_fragment,
      &content_language_validate_params);

    fragment->content_language.Set(
        content_language_fragment.is_null() ? nullptr : content_language_fragment.data());

    decltype(Traits::no_vary_search_with_parse_error(input)) in_no_vary_search_with_parse_error = Traits::no_vary_search_with_parse_error(input);
    mojo::internal::MessageFragment<decltype(fragment->no_vary_search_with_parse_error)>
        no_vary_search_with_parse_error_fragment(fragment.message());
    no_vary_search_with_parse_error_fragment.Claim(&fragment->no_vary_search_with_parse_error);
    
    mojo::internal::Serialize<::network::mojom::NoVarySearchWithParseErrorDataView>(
      in_no_vary_search_with_parse_error,
      no_vary_search_with_parse_error_fragment,
      true);

    fragment->observe_browsing_topics = Traits::observe_browsing_topics(input);

    fragment->allow_cross_origin_event_reporting = Traits::allow_cross_origin_event_reporting(input);
  }

  static bool Deserialize(::network::mojom::internal::ParsedHeaders_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ParsedHeadersDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void ParsedHeadersDataView::GetContentSecurityPolicyDataView(
    mojo::ArrayDataView<::network::mojom::ContentSecurityPolicyDataView>* output) {
  auto pointer = data_->content_security_policy.Get();
  *output = mojo::ArrayDataView<::network::mojom::ContentSecurityPolicyDataView>(pointer, message_);
}
inline void ParsedHeadersDataView::GetAllowCspFromDataView(
    ::network::mojom::AllowCSPFromHeaderValueDataView* output) {
  auto pointer = &data_->allow_csp_from;
  *output = ::network::mojom::AllowCSPFromHeaderValueDataView(pointer, message_);
}
inline void ParsedHeadersDataView::GetCrossOriginEmbedderPolicyDataView(
    ::network::mojom::CrossOriginEmbedderPolicyDataView* output) {
  auto pointer = data_->cross_origin_embedder_policy.Get();
  *output = ::network::mojom::CrossOriginEmbedderPolicyDataView(pointer, message_);
}
inline void ParsedHeadersDataView::GetCrossOriginOpenerPolicyDataView(
    ::network::mojom::CrossOriginOpenerPolicyDataView* output) {
  auto pointer = data_->cross_origin_opener_policy.Get();
  *output = ::network::mojom::CrossOriginOpenerPolicyDataView(pointer, message_);
}
inline void ParsedHeadersDataView::GetDocumentIsolationPolicyDataView(
    ::network::mojom::DocumentIsolationPolicyDataView* output) {
  auto pointer = data_->document_isolation_policy.Get();
  *output = ::network::mojom::DocumentIsolationPolicyDataView(pointer, message_);
}
inline void ParsedHeadersDataView::GetIntegrityPolicyDataView(
    ::network::mojom::IntegrityPolicyDataView* output) {
  auto pointer = data_->integrity_policy.Get();
  *output = ::network::mojom::IntegrityPolicyDataView(pointer, message_);
}
inline void ParsedHeadersDataView::GetIntegrityPolicyReportOnlyDataView(
    ::network::mojom::IntegrityPolicyDataView* output) {
  auto pointer = data_->integrity_policy_report_only.Get();
  *output = ::network::mojom::IntegrityPolicyDataView(pointer, message_);
}
inline void ParsedHeadersDataView::GetAcceptChDataView(
    mojo::ArrayDataView<::network::mojom::WebClientHintsType>* output) {
  auto pointer = data_->accept_ch.Get();
  *output = mojo::ArrayDataView<::network::mojom::WebClientHintsType>(pointer, message_);
}
inline void ParsedHeadersDataView::GetCriticalChDataView(
    mojo::ArrayDataView<::network::mojom::WebClientHintsType>* output) {
  auto pointer = data_->critical_ch.Get();
  *output = mojo::ArrayDataView<::network::mojom::WebClientHintsType>(pointer, message_);
}
inline void ParsedHeadersDataView::GetLinkHeadersDataView(
    mojo::ArrayDataView<::network::mojom::LinkHeaderDataView>* output) {
  auto pointer = data_->link_headers.Get();
  *output = mojo::ArrayDataView<::network::mojom::LinkHeaderDataView>(pointer, message_);
}
inline void ParsedHeadersDataView::GetTimingAllowOriginDataView(
    ::network::mojom::TimingAllowOriginDataView* output) {
  auto pointer = &data_->timing_allow_origin;
  *output = ::network::mojom::TimingAllowOriginDataView(pointer, message_);
}
inline void ParsedHeadersDataView::GetSupportsLoadingModeDataView(
    mojo::ArrayDataView<::network::mojom::LoadingMode>* output) {
  auto pointer = data_->supports_loading_mode.Get();
  *output = mojo::ArrayDataView<::network::mojom::LoadingMode>(pointer, message_);
}
inline void ParsedHeadersDataView::GetReportingEndpointsDataView(
    mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output) {
  auto pointer = data_->reporting_endpoints.Get();
  *output = mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>(pointer, message_);
}
inline void ParsedHeadersDataView::GetCookieIndicesDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->cookie_indices.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void ParsedHeadersDataView::GetAvailLanguageDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->avail_language.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void ParsedHeadersDataView::GetContentLanguageDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->content_language.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void ParsedHeadersDataView::GetNoVarySearchWithParseErrorDataView(
    ::network::mojom::NoVarySearchWithParseErrorDataView* output) {
  auto pointer = &data_->no_vary_search_with_parse_error;
  *output = ::network::mojom::NoVarySearchWithParseErrorDataView(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::OriginAgentClusterValue> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::OriginAgentClusterValue value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_PARSED_HEADERS_MOJOM_SHARED_H_