// services/network/public/mojom/restricted_cookie_manager.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/restricted_cookie_manager.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/restricted_cookie_manager.mojom-params-data.h"
namespace network {
namespace mojom {

NOINLINE static const char* CookieMatchTypeToStringHelper(CookieMatchType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CookieMatchType::EQUALS:
      return "EQUALS";
    case CookieMatchType::STARTS_WITH:
      return "STARTS_WITH";
    default:
      return nullptr;
  }
}

std::string CookieMatchTypeToString(CookieMatchType value) {
  const char *str = CookieMatchTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CookieMatchType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CookieMatchType value) {
  return os << CookieMatchTypeToString(value);
}

NOINLINE static const char* RestrictedCookieManagerRoleToStringHelper(RestrictedCookieManagerRole value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RestrictedCookieManagerRole::SCRIPT:
      return "SCRIPT";
    case RestrictedCookieManagerRole::NETWORK:
      return "NETWORK";
    default:
      return nullptr;
  }
}

std::string RestrictedCookieManagerRoleToString(RestrictedCookieManagerRole value) {
  const char *str = RestrictedCookieManagerRoleToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RestrictedCookieManagerRole value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RestrictedCookieManagerRole value) {
  return os << RestrictedCookieManagerRoleToString(value);
}

namespace internal {


// static
bool CookieManagerGetOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CookieManagerGetOptions_Data* object =
      static_cast<const CookieManagerGetOptions_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::CookieMatchType_Data
        ::Validate(object->match_type, validation_context))
    return false;

  return true;
}

CookieManagerGetOptions_Data::CookieManagerGetOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookiesResponse_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CookiesResponse_Data* object =
      static_cast<const CookiesResponse_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->version_buffer, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookies, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& cookies_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->cookies, validation_context,
                                         &cookies_validate_params)) {
    return false;
  }

  return true;
}

CookiesResponse_Data::CookiesResponse_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RestrictedCookieManager_GetAllForUrl_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RestrictedCookieManager_GetAllForUrl_Params_Data* object =
      static_cast<const RestrictedCookieManager_GetAllForUrl_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->site_for_cookies, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->site_for_cookies, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->top_frame_origin, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->top_frame_origin, validation_context))
    return false;


  if (!::network::mojom::internal::StorageAccessApiStatus_Data
        ::Validate(object->storage_access_api_status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

RestrictedCookieManager_GetAllForUrl_Params_Data::RestrictedCookieManager_GetAllForUrl_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RestrictedCookieManager_GetAllForUrl_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RestrictedCookieManager_GetAllForUrl_ResponseParams_Data* object =
      static_cast<const RestrictedCookieManager_GetAllForUrl_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookies, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& cookies_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->cookies, validation_context,
                                         &cookies_validate_params)) {
    return false;
  }

  return true;
}

RestrictedCookieManager_GetAllForUrl_ResponseParams_Data::RestrictedCookieManager_GetAllForUrl_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RestrictedCookieManager_SetCanonicalCookie_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RestrictedCookieManager_SetCanonicalCookie_Params_Data* object =
      static_cast<const RestrictedCookieManager_SetCanonicalCookie_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookie, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cookie, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->site_for_cookies, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->site_for_cookies, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->top_frame_origin, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->top_frame_origin, validation_context))
    return false;


  if (!::network::mojom::internal::StorageAccessApiStatus_Data
        ::Validate(object->storage_access_api_status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->status, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->status, validation_context))
    return false;

  return true;
}

RestrictedCookieManager_SetCanonicalCookie_Params_Data::RestrictedCookieManager_SetCanonicalCookie_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RestrictedCookieManager_SetCanonicalCookie_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RestrictedCookieManager_SetCanonicalCookie_ResponseParams_Data* object =
      static_cast<const RestrictedCookieManager_SetCanonicalCookie_ResponseParams_Data*>(data);

  return true;
}

RestrictedCookieManager_SetCanonicalCookie_ResponseParams_Data::RestrictedCookieManager_SetCanonicalCookie_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RestrictedCookieManager_AddChangeListener_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RestrictedCookieManager_AddChangeListener_Params_Data* object =
      static_cast<const RestrictedCookieManager_AddChangeListener_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->site_for_cookies, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->site_for_cookies, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->top_frame_origin, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->top_frame_origin, validation_context))
    return false;


  if (!::network::mojom::internal::StorageAccessApiStatus_Data
        ::Validate(object->storage_access_api_status, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->listener, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->listener,
                                                 validation_context)) {
    return false;
  }

  return true;
}

RestrictedCookieManager_AddChangeListener_Params_Data::RestrictedCookieManager_AddChangeListener_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RestrictedCookieManager_AddChangeListener_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RestrictedCookieManager_AddChangeListener_ResponseParams_Data* object =
      static_cast<const RestrictedCookieManager_AddChangeListener_ResponseParams_Data*>(data);

  return true;
}

RestrictedCookieManager_AddChangeListener_ResponseParams_Data::RestrictedCookieManager_AddChangeListener_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RestrictedCookieManager_SetCookieFromString_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RestrictedCookieManager_SetCookieFromString_Params_Data* object =
      static_cast<const RestrictedCookieManager_SetCookieFromString_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->site_for_cookies, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->site_for_cookies, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->top_frame_origin, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->top_frame_origin, validation_context))
    return false;


  if (!::network::mojom::internal::StorageAccessApiStatus_Data
        ::Validate(object->storage_access_api_status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookie, 8, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& cookie_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->cookie, validation_context,
                                         &cookie_validate_params)) {
    return false;
  }

  return true;
}

RestrictedCookieManager_SetCookieFromString_Params_Data::RestrictedCookieManager_SetCookieFromString_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RestrictedCookieManager_SetCookieFromString_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RestrictedCookieManager_SetCookieFromString_ResponseParams_Data* object =
      static_cast<const RestrictedCookieManager_SetCookieFromString_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->response, validation_context))
    return false;

  return true;
}

RestrictedCookieManager_SetCookieFromString_ResponseParams_Data::RestrictedCookieManager_SetCookieFromString_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RestrictedCookieManager_GetCookiesString_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RestrictedCookieManager_GetCookiesString_Params_Data* object =
      static_cast<const RestrictedCookieManager_GetCookiesString_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->site_for_cookies, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->site_for_cookies, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->top_frame_origin, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->top_frame_origin, validation_context))
    return false;


  if (!::network::mojom::internal::StorageAccessApiStatus_Data
        ::Validate(object->storage_access_api_status, validation_context))
    return false;

  return true;
}

RestrictedCookieManager_GetCookiesString_Params_Data::RestrictedCookieManager_GetCookiesString_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RestrictedCookieManager_GetCookiesString_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RestrictedCookieManager_GetCookiesString_ResponseParams_Data* object =
      static_cast<const RestrictedCookieManager_GetCookiesString_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->version_buffer, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookies, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& cookies_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->cookies, validation_context,
                                         &cookies_validate_params)) {
    return false;
  }

  return true;
}

RestrictedCookieManager_GetCookiesString_ResponseParams_Data::RestrictedCookieManager_GetCookiesString_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RestrictedCookieManager_CookiesEnabledFor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RestrictedCookieManager_CookiesEnabledFor_Params_Data* object =
      static_cast<const RestrictedCookieManager_CookiesEnabledFor_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->site_for_cookies, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->site_for_cookies, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->top_frame_origin, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->top_frame_origin, validation_context))
    return false;


  if (!::network::mojom::internal::StorageAccessApiStatus_Data
        ::Validate(object->storage_access_api_status, validation_context))
    return false;

  return true;
}

RestrictedCookieManager_CookiesEnabledFor_Params_Data::RestrictedCookieManager_CookiesEnabledFor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RestrictedCookieManager_CookiesEnabledFor_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RestrictedCookieManager_CookiesEnabledFor_ResponseParams_Data* object =
      static_cast<const RestrictedCookieManager_CookiesEnabledFor_ResponseParams_Data*>(data);

  return true;
}

RestrictedCookieManager_CookiesEnabledFor_ResponseParams_Data::RestrictedCookieManager_CookiesEnabledFor_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::CookieMatchType>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::CookieMatchType value) {
  return std::move(context).WriteString(::network::mojom::CookieMatchTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::RestrictedCookieManagerRole>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::RestrictedCookieManagerRole value) {
  return std::move(context).WriteString(::network::mojom::RestrictedCookieManagerRoleToString(value));
}

} // namespace perfetto