// services/network/public/mojom/system_dns_resolution.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/system_dns_resolution.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/system_dns_resolution.mojom-params-data.h"
#include "services/network/public/mojom/system_dns_resolution.mojom-shared-message-ids.h"

#include "services/network/public/mojom/system_dns_resolution.mojom-blink-import-headers.h"
#include "services/network/public/mojom/system_dns_resolution.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace network::mojom::blink {
// The declaration includes the definition on other builds.

SystemDnsResolver::IPCStableHashFunction SystemDnsResolver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SystemDnsResolver>(message.name())) {
    case messages::SystemDnsResolver::kResolve: {
      return &SystemDnsResolver::Resolve_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SystemDnsResolver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SystemDnsResolver>(message.name())) {
      case messages::SystemDnsResolver::kResolve:
            return "Receive network::mojom::SystemDnsResolver::Resolve";
    }
  } else {
    switch (static_cast<messages::SystemDnsResolver>(message.name())) {
      case messages::SystemDnsResolver::kResolve:
            return "Receive reply network::mojom::SystemDnsResolver::Resolve";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SystemDnsResolver::Resolve_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x16b58ab2;  // IPCStableHash for network::mojom::SystemDnsResolver::Resolve
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SystemDnsResolver_Resolve_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SystemDnsResolver_Resolve_ForwardToCallback(
      SystemDnsResolver::ResolveCallback callback
      ) : callback_(std::move(callback)) {
  }

  SystemDnsResolver_Resolve_ForwardToCallback(const SystemDnsResolver_Resolve_ForwardToCallback&) = delete;
  SystemDnsResolver_Resolve_ForwardToCallback& operator=(const SystemDnsResolver_Resolve_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SystemDnsResolver::ResolveCallback callback_;
};

SystemDnsResolverProxy::SystemDnsResolverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SystemDnsResolverProxy::Resolve(
    const ::blink::String& in_hostname, ::net::AddressFamily in_addr_family, int32_t in_flags, uint64_t in_network, ResolveCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::SystemDnsResolver::Resolve", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("hostname"), in_hostname,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("addr_family"), in_addr_family,
                        "<value of type ::net::AddressFamily>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("flags"), in_flags,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("network"), in_network,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemDnsResolver::kResolve), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SystemDnsResolver_Resolve_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->hostname)::BaseType> hostname_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_hostname,
    hostname_fragment);

  params->hostname.Set(
      hostname_fragment.is_null() ? nullptr : hostname_fragment.data());

  
  mojo::internal::Serialize<::network::mojom::AddressFamily>(
    in_addr_family,
    &params->addr_family);

  params->flags = in_flags;

  params->network = in_network;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemDnsResolver::Name_);
  message.set_method_name("Resolve");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SystemDnsResolver_Resolve_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class SystemDnsResolver_Resolve_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SystemDnsResolver::ResolveCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SystemDnsResolver_Resolve_ProxyToResponder> proxy(
        new SystemDnsResolver_Resolve_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SystemDnsResolver_Resolve_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SystemDnsResolver_Resolve_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SystemDnsResolver_Resolve_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SystemDnsResolver::ResolveCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::network::mojom::blink::AddressListPtr in_addr_list, int32_t in_os_error, int32_t in_net_error);
};

bool SystemDnsResolver_Resolve_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SystemDnsResolver_Resolve_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SystemDnsResolver_Resolve_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SystemDnsResolver.0
  bool success = true;
  ::network::mojom::blink::AddressListPtr p_addr_list{};
  int32_t p_os_error{};
  int32_t p_net_error{};
  SystemDnsResolver_Resolve_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadAddrList(&p_addr_list))
    success = false;
  if (success)
    p_os_error = input_data_view.os_error();
  if (success)
    p_net_error = input_data_view.net_error();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SystemDnsResolver::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_addr_list), 
std::move(p_os_error), 
std::move(p_net_error));
  }
  return true;
}

void SystemDnsResolver_Resolve_ProxyToResponder::Run(
    ::network::mojom::blink::AddressListPtr in_addr_list, int32_t in_os_error, int32_t in_net_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::SystemDnsResolver::Resolve", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("addr_list"), in_addr_list,
                        "<value of type ::network::mojom::blink::AddressListPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("os_error"), in_os_error,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_error"), in_net_error,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemDnsResolver::kResolve), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SystemDnsResolver_Resolve_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->addr_list)::BaseType> addr_list_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::AddressListDataView>(
    in_addr_list,
    addr_list_fragment);

  params->addr_list.Set(
      addr_list_fragment.is_null() ? nullptr : addr_list_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->addr_list.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null addr_list in ");

  params->os_error = in_os_error;

  params->net_error = in_net_error;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemDnsResolver::Name_);
  message.set_method_name("Resolve");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SystemDnsResolverStubDispatch::Accept(
    SystemDnsResolver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SystemDnsResolver>(message->header()->name)) {
    case messages::SystemDnsResolver::kResolve: {
      break;
    }
  }
  return false;
}

// static
bool SystemDnsResolverStubDispatch::AcceptWithResponder(
    SystemDnsResolver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SystemDnsResolver>(message->header()->name)) {
    case messages::SystemDnsResolver::kResolve: {
      internal::SystemDnsResolver_Resolve_Params_Data* params =
          reinterpret_cast<
              internal::SystemDnsResolver_Resolve_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SystemDnsResolver.0
      bool success = true;
      ::blink::String p_hostname{};
      ::net::AddressFamily p_addr_family{};
      int32_t p_flags{};
      uint64_t p_network{};
      SystemDnsResolver_Resolve_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHostname(&p_hostname))
        success = false;
      if (success && !input_data_view.ReadAddrFamily(&p_addr_family))
        success = false;
      if (success)
        p_flags = input_data_view.flags();
      if (success)
        p_network = input_data_view.network();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SystemDnsResolver::Name_, 0, false);
        return false;
      }
      auto callback =
          SystemDnsResolver_Resolve_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Resolve(        
        std::move(p_hostname), 
        std::move(p_addr_family), 
        std::move(p_flags), 
        std::move(p_network), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSystemDnsResolverValidationInfo[] = {
    {base::to_underlying(messages::SystemDnsResolver::kResolve),
     { &internal::SystemDnsResolver_Resolve_Params_Data::Validate,
      &internal::SystemDnsResolver_Resolve_ResponseParams_Data::Validate}},
};

bool SystemDnsResolverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::blink::SystemDnsResolver::Name_,
    kSystemDnsResolverValidationInfo);
}

bool SystemDnsResolverResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::network::mojom::blink::SystemDnsResolver::Name_,
    kSystemDnsResolverValidationInfo);

}


}  // network::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom::blink {


void SystemDnsResolverInterceptorForTesting::Resolve(const ::blink::String& hostname, ::net::AddressFamily addr_family, int32_t flags, uint64_t network, ResolveCallback callback) {
  GetForwardingInterface()->Resolve(
    std::move(hostname)
    , 
    std::move(addr_family)
    , 
    std::move(flags)
    , 
    std::move(network)
    , std::move(callback));
}
SystemDnsResolverAsyncWaiter::SystemDnsResolverAsyncWaiter(
    SystemDnsResolver* proxy) : proxy_(proxy) {}

SystemDnsResolverAsyncWaiter::~SystemDnsResolverAsyncWaiter() = default;


void SystemDnsResolverAsyncWaiter::Resolve(
    const ::blink::String& hostname, ::net::AddressFamily addr_family, int32_t flags, uint64_t network, ::network::mojom::blink::AddressListPtr* out_addr_list, int32_t* out_os_error, int32_t* out_net_error) {
  base::RunLoop loop;
  proxy_->Resolve(
      std::move(hostname),
      std::move(addr_family),
      std::move(flags),
      std::move(network),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::network::mojom::blink::AddressListPtr* out_addr_list
,
             int32_t* out_os_error
,
             int32_t* out_net_error
,
             ::network::mojom::blink::AddressListPtr addr_list,
             int32_t os_error,
             int32_t net_error) {*out_addr_list = std::move(addr_list);*out_os_error = std::move(os_error);*out_net_error = std::move(net_error);
            loop->Quit();
          },
          &loop,
          out_addr_list,
          out_os_error,
          out_net_error));
  loop.Run();
}








}  // network::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif