// services/network/public/mojom/url_request.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_URL_REQUEST_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_URL_REQUEST_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/network/public/mojom/url_request.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/accept_ch_frame_observer.mojom-shared.h"
#include "services/network/public/mojom/attribution.mojom-shared.h"
#include "services/network/public/mojom/chunked_data_pipe_getter.mojom-shared.h"
#include "services/network/public/mojom/client_security_state.mojom-shared.h"
#include "services/network/public/mojom/cookie_access_observer.mojom-shared.h"
#include "services/network/public/mojom/cookie_manager.mojom-shared.h"
#include "services/network/public/mojom/cors.mojom-shared.h"
#include "services/network/public/mojom/data_pipe_getter.mojom-shared.h"
#include "services/network/public/mojom/device_bound_sessions.mojom-shared.h"
#include "services/network/public/mojom/devtools_observer.mojom-shared.h"
#include "services/network/public/mojom/fetch_api.mojom-shared.h"
#include "services/network/public/mojom/fetch_retry_options.mojom-shared.h"
#include "services/network/public/mojom/http_raw_headers.mojom-shared.h"
#include "services/network/public/mojom/http_request_headers.mojom-shared.h"
#include "services/network/public/mojom/ip_address_space.mojom-shared.h"
#include "services/network/public/mojom/isolation_info.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/permissions_policy/permissions_policy.mojom-shared.h"
#include "services/network/public/mojom/referrer_policy.mojom-shared.h"
#include "services/network/public/mojom/request_priority.mojom-shared.h"
#include "services/network/public/mojom/shared_dictionary_access_observer.mojom-shared.h"
#include "services/network/public/mojom/site_for_cookies.mojom-shared.h"
#include "services/network/public/mojom/source_type.mojom-shared.h"
#include "services/network/public/mojom/storage_access_api.mojom-shared.h"
#include "services/network/public/mojom/trust_token_access_observer.mojom-shared.h"
#include "services/network/public/mojom/trust_tokens.mojom-shared.h"
#include "services/network/public/mojom/url_loader_network_service_observer.mojom-shared.h"
#include "services/network/public/mojom/url_response_head.mojom-shared.h"
#include "services/network/public/mojom/web_bundle_handle.mojom-shared.h"
#include "services/network/public/mojom/web_client_hints_types.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace network::mojom {
class EnabledClientHintsDataView;

class TrustedUrlRequestParamsDataView;

class WebBundleTokenParamsDataView;

class URLRequestDataView;

class URLRequestBodyDataView;

class DataElementBytesDataView;

class DataElementFileDataView;

class DataElementDataPipeDataView;

class DataElementChunkedDataPipeDataView;

class SocketTagDataView;

class DataElementDataView;


}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::EnabledClientHintsDataView> {
  using Data = ::network::mojom::internal::EnabledClientHints_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::TrustedUrlRequestParamsDataView> {
  using Data = ::network::mojom::internal::TrustedUrlRequestParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::WebBundleTokenParamsDataView> {
  using Data = ::network::mojom::internal::WebBundleTokenParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::URLRequestDataView> {
  using Data = ::network::mojom::internal::URLRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::URLRequestBodyDataView> {
  using Data = ::network::mojom::internal::URLRequestBody_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::DataElementBytesDataView> {
  using Data = ::network::mojom::internal::DataElementBytes_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::DataElementFileDataView> {
  using Data = ::network::mojom::internal::DataElementFile_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::DataElementDataPipeDataView> {
  using Data = ::network::mojom::internal::DataElementDataPipe_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::DataElementChunkedDataPipeDataView> {
  using Data = ::network::mojom::internal::DataElementChunkedDataPipe_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::SocketTagDataView> {
  using Data = ::network::mojom::internal::SocketTag_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::DataElementDataView> {
  using Data = ::network::mojom::internal::DataElement_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


class EnabledClientHintsDataView {
 public:
  EnabledClientHintsDataView() = default;

  EnabledClientHintsDataView(
      internal::EnabledClientHints_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  bool is_outermost_main_frame() const {
    return data_->is_outermost_main_frame;
  }
  inline void GetHintsDataView(
      mojo::ArrayDataView<::network::mojom::WebClientHintsType>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHints(UserType* output) {
    
    auto* pointer = data_->hints.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::WebClientHintsType>>(
        pointer, output, message_);
  }
 private:
  internal::EnabledClientHints_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TrustedUrlRequestParamsDataView {
 public:
  TrustedUrlRequestParamsDataView() = default;

  TrustedUrlRequestParamsDataView(
      internal::TrustedUrlRequestParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIsolationInfoDataView(
      ::network::mojom::IsolationInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIsolationInfo(UserType* output) {
    
    auto* pointer = data_->isolation_info.Get();
    return mojo::internal::Deserialize<::network::mojom::IsolationInfoDataView>(
        pointer, output, message_);
  }
  bool disable_secure_dns() const {
    return data_->disable_secure_dns;
  }
  bool has_user_activation() const {
    return data_->has_user_activation;
  }
  bool allow_cookies_from_browser() const {
    return data_->allow_cookies_from_browser;
  }
  bool include_request_cookies_with_response() const {
    return data_->include_request_cookies_with_response;
  }
  inline void GetEnabledClientHintsDataView(
      EnabledClientHintsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEnabledClientHints(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::EnabledClientHintsDataView, UserType>(),
    "Attempting to read the optional `enabled_client_hints` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadEnabledClientHints` instead "
    "of `ReadEnabledClientHints if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->enabled_client_hints.Get();
    return mojo::internal::Deserialize<::network::mojom::EnabledClientHintsDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeCookieObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::CookieAccessObserverInterfaceBase>>(
            &data_->cookie_observer, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeTrustTokenObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::TrustTokenAccessObserverInterfaceBase>>(
            &data_->trust_token_observer, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeUrlLoaderNetworkObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderNetworkServiceObserverInterfaceBase>>(
            &data_->url_loader_network_observer, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeDevtoolsObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::DevToolsObserverInterfaceBase>>(
            &data_->devtools_observer, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeDeviceBoundSessionObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::DeviceBoundSessionAccessObserverInterfaceBase>>(
            &data_->device_bound_session_observer, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetClientSecurityStateDataView(
      ::network::mojom::ClientSecurityStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClientSecurityState(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::ClientSecurityStateDataView, UserType>(),
    "Attempting to read the optional `client_security_state` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadClientSecurityState` instead "
    "of `ReadClientSecurityState if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->client_security_state.Get();
    return mojo::internal::Deserialize<::network::mojom::ClientSecurityStateDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeAcceptChFrameObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::AcceptCHFrameObserverInterfaceBase>>(
            &data_->accept_ch_frame_observer, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeSharedDictionaryObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::SharedDictionaryAccessObserverInterfaceBase>>(
            &data_->shared_dictionary_observer, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::TrustedUrlRequestParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebBundleTokenParamsDataView {
 public:
  WebBundleTokenParamsDataView() = default;

  WebBundleTokenParamsDataView(
      internal::WebBundleTokenParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBundleUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBundleUrl(UserType* output) {
    
    auto* pointer = data_->bundle_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadToken(UserType* output) {
    
    auto* pointer = data_->token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeWebBundleHandle() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::WebBundleHandleInterfaceBase>>(
            &data_->web_bundle_handle, &result, message_);
    DCHECK(ret);
    return result;
  }
  int32_t render_process_id() const {
    return data_->render_process_id;
  }
 private:
  internal::WebBundleTokenParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class URLRequestDataView {
 public:
  URLRequestDataView() = default;

  URLRequestDataView(
      internal::URLRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMethodDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMethod(UserType* output) {
    
    auto* pointer = data_->method.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetSiteForCookiesDataView(
      ::network::mojom::SiteForCookiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSiteForCookies(UserType* output) {
    
    auto* pointer = data_->site_for_cookies.Get();
    return mojo::internal::Deserialize<::network::mojom::SiteForCookiesDataView>(
        pointer, output, message_);
  }
  bool update_first_party_url_on_redirect() const {
    return data_->update_first_party_url_on_redirect;
  }
  inline void GetRequestInitiatorDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestInitiator(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `request_initiator` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRequestInitiator` instead "
    "of `ReadRequestInitiator if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->request_initiator.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetNavigationRedirectChainDataView(
      mojo::ArrayDataView<::url::mojom::UrlDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNavigationRedirectChain(UserType* output) {
    
    auto* pointer = data_->navigation_redirect_chain.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        pointer, output, message_);
  }
  inline void GetIsolatedWorldOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIsolatedWorldOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `isolated_world_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadIsolatedWorldOrigin` instead "
    "of `ReadIsolatedWorldOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->isolated_world_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetReferrerDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReferrer(UserType* output) {
    
    auto* pointer = data_->referrer.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadReferrerPolicy(UserType* output) const {
    auto data_value = data_->referrer_policy;
    return mojo::internal::Deserialize<::network::mojom::URLRequestReferrerPolicy>(
        data_value, output);
  }
  ::network::mojom::URLRequestReferrerPolicy referrer_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::URLRequestReferrerPolicy>(data_->referrer_policy));
  }
  inline void GetHeadersDataView(
      ::network::mojom::HttpRequestHeadersDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeaders(UserType* output) {
    
    auto* pointer = data_->headers.Get();
    return mojo::internal::Deserialize<::network::mojom::HttpRequestHeadersDataView>(
        pointer, output, message_);
  }
  inline void GetCorsExemptHeadersDataView(
      ::network::mojom::HttpRequestHeadersDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCorsExemptHeaders(UserType* output) {
    
    auto* pointer = data_->cors_exempt_headers.Get();
    return mojo::internal::Deserialize<::network::mojom::HttpRequestHeadersDataView>(
        pointer, output, message_);
  }
  int32_t load_flags() const {
    return data_->load_flags;
  }
  int32_t resource_type() const {
    return data_->resource_type;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPriority(UserType* output) const {
    auto data_value = data_->priority;
    return mojo::internal::Deserialize<::network::mojom::RequestPriority>(
        data_value, output);
  }
  ::network::mojom::RequestPriority priority() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::RequestPriority>(data_->priority));
  }
  bool priority_incremental() const {
    return data_->priority_incremental;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCorsPreflightPolicy(UserType* output) const {
    auto data_value = data_->cors_preflight_policy;
    return mojo::internal::Deserialize<::network::mojom::CorsPreflightPolicy>(
        data_value, output);
  }
  ::network::mojom::CorsPreflightPolicy cors_preflight_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::CorsPreflightPolicy>(data_->cors_preflight_policy));
  }
  bool originated_from_service_worker() const {
    return data_->originated_from_service_worker;
  }
  bool skip_service_worker() const {
    return data_->skip_service_worker;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMode(UserType* output) const {
    auto data_value = data_->mode;
    return mojo::internal::Deserialize<::network::mojom::RequestMode>(
        data_value, output);
  }
  ::network::mojom::RequestMode mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::RequestMode>(data_->mode));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCredentialsMode(UserType* output) const {
    auto data_value = data_->credentials_mode;
    return mojo::internal::Deserialize<::network::mojom::CredentialsMode>(
        data_value, output);
  }
  ::network::mojom::CredentialsMode credentials_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::CredentialsMode>(data_->credentials_mode));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRedirectMode(UserType* output) const {
    auto data_value = data_->redirect_mode;
    return mojo::internal::Deserialize<::network::mojom::RedirectMode>(
        data_value, output);
  }
  ::network::mojom::RedirectMode redirect_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::RedirectMode>(data_->redirect_mode));
  }
  inline void GetFetchIntegrityDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFetchIntegrity(UserType* output) {
    
    auto* pointer = data_->fetch_integrity.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetExpectedPublicKeysDataView(
      mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExpectedPublicKeys(UserType* output) {
    
    auto* pointer = data_->expected_public_keys.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDestination(UserType* output) const {
    auto data_value = data_->destination;
    return mojo::internal::Deserialize<::network::mojom::RequestDestination>(
        data_value, output);
  }
  ::network::mojom::RequestDestination destination() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::RequestDestination>(data_->destination));
  }
  inline void GetRequestBodyDataView(
      URLRequestBodyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestBody(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::URLRequestBodyDataView, UserType>(),
    "Attempting to read the optional `request_body` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRequestBody` instead "
    "of `ReadRequestBody if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->request_body.Get();
    return mojo::internal::Deserialize<::network::mojom::URLRequestBodyDataView>(
        pointer, output, message_);
  }
  bool keepalive() const {
    return data_->keepalive;
  }
  bool browsing_topics() const {
    return data_->browsing_topics;
  }
  bool ad_auction_headers() const {
    return data_->ad_auction_headers;
  }
  bool shared_storage_writable_eligible() const {
    return data_->shared_storage_writable_eligible;
  }
  bool has_user_gesture() const {
    return data_->has_user_gesture;
  }
  bool enable_load_timing() const {
    return data_->enable_load_timing;
  }
  bool enable_upload_progress() const {
    return data_->enable_upload_progress;
  }
  bool do_not_prompt_for_login() const {
    return data_->do_not_prompt_for_login;
  }
  bool is_outermost_main_frame() const {
    return data_->is_outermost_main_frame;
  }
  int32_t transition_type() const {
    return data_->transition_type;
  }
  int32_t previews_state() const {
    return data_->previews_state;
  }
  bool upgrade_if_insecure() const {
    return data_->upgrade_if_insecure;
  }
  bool is_revalidating() const {
    return data_->is_revalidating;
  }
  inline void GetThrottlingProfileIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadThrottlingProfileId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `throttling_profile_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadThrottlingProfileId` instead "
    "of `ReadThrottlingProfileId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->throttling_profile_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetFetchWindowIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFetchWindowId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `fetch_window_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFetchWindowId` instead "
    "of `ReadFetchWindowId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->fetch_window_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetDevtoolsRequestIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolsRequestId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `devtools_request_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDevtoolsRequestId` instead "
    "of `ReadDevtoolsRequestId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->devtools_request_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDevtoolsStackIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolsStackId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `devtools_stack_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDevtoolsStackId` instead "
    "of `ReadDevtoolsStackId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->devtools_stack_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_fetch_like_api() const {
    return data_->is_fetch_like_api;
  }
  bool is_fetch_later_api() const {
    return data_->is_fetch_later_api;
  }
  bool is_favicon() const {
    return data_->is_favicon;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadOriginalDestination(UserType* output) const {
    auto data_value = data_->original_destination;
    return mojo::internal::Deserialize<::network::mojom::RequestDestination>(
        data_value, output);
  }
  ::network::mojom::RequestDestination original_destination() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::RequestDestination>(data_->original_destination));
  }
  inline void GetTrustedParamsDataView(
      TrustedUrlRequestParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrustedParams(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::TrustedUrlRequestParamsDataView, UserType>(),
    "Attempting to read the optional `trusted_params` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTrustedParams` instead "
    "of `ReadTrustedParams if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->trusted_params.Get();
    return mojo::internal::Deserialize<::network::mojom::TrustedUrlRequestParamsDataView>(
        pointer, output, message_);
  }
  inline void GetRecursivePrefetchTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRecursivePrefetchToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `recursive_prefetch_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRecursivePrefetchToken` instead "
    "of `ReadRecursivePrefetchToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->recursive_prefetch_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetTrustTokenParamsDataView(
      ::network::mojom::TrustTokenParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrustTokenParams(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::TrustTokenParamsDataView, UserType>(),
    "Attempting to read the optional `trust_token_params` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTrustTokenParams` instead "
    "of `ReadTrustTokenParams if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->trust_token_params.Get();
    return mojo::internal::Deserialize<::network::mojom::TrustTokenParamsDataView>(
        pointer, output, message_);
  }
  inline void GetWebBundleTokenParamsDataView(
      WebBundleTokenParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWebBundleTokenParams(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::WebBundleTokenParamsDataView, UserType>(),
    "Attempting to read the optional `web_bundle_token_params` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadWebBundleTokenParams` instead "
    "of `ReadWebBundleTokenParams if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->web_bundle_token_params.Get();
    return mojo::internal::Deserialize<::network::mojom::WebBundleTokenParamsDataView>(
        pointer, output, message_);
  }
  inline void GetDevtoolsAcceptedStreamTypesDataView(
      mojo::ArrayDataView<::network::mojom::SourceType>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolsAcceptedStreamTypes(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::network::mojom::SourceType>, UserType>(),
    "Attempting to read the optional `devtools_accepted_stream_types` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDevtoolsAcceptedStreamTypes` instead "
    "of `ReadDevtoolsAcceptedStreamTypes if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->devtools_accepted_stream_types.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::SourceType>>(
        pointer, output, message_);
  }
  inline void GetNetLogCreateInfoDataView(
      ::network::mojom::NetLogSourceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNetLogCreateInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::NetLogSourceDataView, UserType>(),
    "Attempting to read the optional `net_log_create_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNetLogCreateInfo` instead "
    "of `ReadNetLogCreateInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->net_log_create_info.Get();
    return mojo::internal::Deserialize<::network::mojom::NetLogSourceDataView>(
        pointer, output, message_);
  }
  inline void GetNetLogReferenceInfoDataView(
      ::network::mojom::NetLogSourceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNetLogReferenceInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::NetLogSourceDataView, UserType>(),
    "Attempting to read the optional `net_log_reference_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNetLogReferenceInfo` instead "
    "of `ReadNetLogReferenceInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->net_log_reference_info.Get();
    return mojo::internal::Deserialize<::network::mojom::NetLogSourceDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTargetIpAddressSpace(UserType* output) const {
    auto data_value = data_->target_ip_address_space;
    return mojo::internal::Deserialize<::network::mojom::IPAddressSpace>(
        data_value, output);
  }
  ::network::mojom::IPAddressSpace target_ip_address_space() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::IPAddressSpace>(data_->target_ip_address_space));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRequiredIpAddressSpace(UserType* output) const {
    auto data_value = data_->required_ip_address_space;
    return mojo::internal::Deserialize<::network::mojom::IPAddressSpace>(
        data_value, output);
  }
  ::network::mojom::IPAddressSpace required_ip_address_space() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::IPAddressSpace>(data_->required_ip_address_space));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadStorageAccessApiStatus(UserType* output) const {
    auto data_value = data_->storage_access_api_status;
    return mojo::internal::Deserialize<::network::mojom::StorageAccessApiStatus>(
        data_value, output);
  }
  ::network::mojom::StorageAccessApiStatus storage_access_api_status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::StorageAccessApiStatus>(data_->storage_access_api_status));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAttributionReportingSupport(UserType* output) const {
    auto data_value = data_->attribution_reporting_support;
    return mojo::internal::Deserialize<::network::mojom::AttributionSupport>(
        data_value, output);
  }
  ::network::mojom::AttributionSupport attribution_reporting_support() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::AttributionSupport>(data_->attribution_reporting_support));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAttributionReportingEligibility(UserType* output) const {
    auto data_value = data_->attribution_reporting_eligibility;
    return mojo::internal::Deserialize<::network::mojom::AttributionReportingEligibility>(
        data_value, output);
  }
  ::network::mojom::AttributionReportingEligibility attribution_reporting_eligibility() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::AttributionReportingEligibility>(data_->attribution_reporting_eligibility));
  }
  inline void GetAttributionReportingSrcTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAttributionReportingSrcToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `attribution_reporting_src_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAttributionReportingSrcToken` instead "
    "of `ReadAttributionReportingSrcToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->attribution_reporting_src_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetKeepaliveTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeepaliveToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `keepalive_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadKeepaliveToken` instead "
    "of `ReadKeepaliveToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->keepalive_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  bool is_ad_tagged() const {
    return data_->is_ad_tagged;
  }
  bool shared_dictionary_writer_enabled() const {
    return data_->shared_dictionary_writer_enabled;
  }
  bool client_side_content_decoding_enabled() const {
    return data_->client_side_content_decoding_enabled;
  }
  inline void GetSocketTagDataView(
      SocketTagDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSocketTag(UserType* output) {
    
    auto* pointer = data_->socket_tag.Get();
    return mojo::internal::Deserialize<::network::mojom::SocketTagDataView>(
        pointer, output, message_);
  }
  bool allows_device_bound_session_registration() const {
    return data_->allows_device_bound_session_registration;
  }
  inline void GetPermissionsPolicyDataView(
      ::network::mojom::PermissionsPolicyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPermissionsPolicy(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::PermissionsPolicyDataView, UserType>(),
    "Attempting to read the optional `permissions_policy` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPermissionsPolicy` instead "
    "of `ReadPermissionsPolicy if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->permissions_policy.Get();
    return mojo::internal::Deserialize<::network::mojom::PermissionsPolicyDataView>(
        pointer, output, message_);
  }
  inline void GetFetchRetryOptionsDataView(
      ::network::mojom::FetchRetryOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFetchRetryOptions(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::FetchRetryOptionsDataView, UserType>(),
    "Attempting to read the optional `fetch_retry_options` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFetchRetryOptions` instead "
    "of `ReadFetchRetryOptions if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->fetch_retry_options.Get();
    return mojo::internal::Deserialize<::network::mojom::FetchRetryOptionsDataView>(
        pointer, output, message_);
  }
 private:
  internal::URLRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class URLRequestBodyDataView {
 public:
  URLRequestBodyDataView() = default;

  URLRequestBodyDataView(
      internal::URLRequestBody_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetElementsDataView(
      mojo::ArrayDataView<DataElementDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadElements(UserType* output) {
    
    auto* pointer = data_->elements.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::DataElementDataView>>(
        pointer, output, message_);
  }
  uint64_t identifier() const {
    return data_->identifier;
  }
  bool contains_sensitive_info() const {
    return data_->contains_sensitive_info;
  }
  bool allow_http1_for_streaming_upload() const {
    return data_->allow_http1_for_streaming_upload;
  }
 private:
  internal::URLRequestBody_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DataElementBytesDataView {
 public:
  DataElementBytesDataView() = default;

  DataElementBytesDataView(
      internal::DataElementBytes_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataDataView(
      ::mojo_base::mojom::BigBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = !data_->data.is_null() ? &data_->data : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        pointer, output, message_);
  }
 private:
  internal::DataElementBytes_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DataElementFileDataView {
 public:
  DataElementFileDataView() = default;

  DataElementFileDataView(
      internal::DataElementFile_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  uint64_t offset() const {
    return data_->offset;
  }
  uint64_t length() const {
    return data_->length;
  }
  inline void GetExpectedModificationTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExpectedModificationTime(UserType* output) {
    
    auto* pointer = data_->expected_modification_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::DataElementFile_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DataElementDataPipeDataView {
 public:
  DataElementDataPipeDataView() = default;

  DataElementDataPipeDataView(
      internal::DataElementDataPipe_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeDataPipeGetter() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::DataPipeGetterInterfaceBase>>(
            &data_->data_pipe_getter, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::DataElementDataPipe_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DataElementChunkedDataPipeDataView {
 public:
  DataElementChunkedDataPipeDataView() = default;

  DataElementChunkedDataPipeDataView(
      internal::DataElementChunkedDataPipe_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeDataPipeGetter() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::ChunkedDataPipeGetterInterfaceBase>>(
            &data_->data_pipe_getter, &result, message_);
    DCHECK(ret);
    return result;
  }
  bool read_only_once() const {
    return data_->read_only_once;
  }
 private:
  internal::DataElementChunkedDataPipe_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SocketTagDataView {
 public:
  SocketTagDataView() = default;

  SocketTagDataView(
      internal::SocketTag_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::SocketTag_Data* data_ = nullptr;
};


class DataElementDataView {
 public:
  using Tag = internal::DataElement_Data::DataElement_Tag;

  DataElementDataView() = default;

  DataElementDataView(
      internal::DataElement_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_bytes() const { return data_->tag == Tag::kBytes; }
  inline void GetBytesDataView(
      DataElementBytesDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadBytes(UserType* output) const {
    
    CHECK(is_bytes());
    return mojo::internal::Deserialize<::network::mojom::DataElementBytesDataView>(
        data_->data.f_bytes.Get(), output, message_);
  }
  bool is_file() const { return data_->tag == Tag::kFile; }
  inline void GetFileDataView(
      DataElementFileDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFile(UserType* output) const {
    
    CHECK(is_file());
    return mojo::internal::Deserialize<::network::mojom::DataElementFileDataView>(
        data_->data.f_file.Get(), output, message_);
  }
  bool is_data_pipe() const { return data_->tag == Tag::kDataPipe; }
  inline void GetDataPipeDataView(
      DataElementDataPipeDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadDataPipe(UserType* output) const {
    
    CHECK(is_data_pipe());
    return mojo::internal::Deserialize<::network::mojom::DataElementDataPipeDataView>(
        data_->data.f_data_pipe.Get(), output, message_);
  }
  bool is_chunked_data_pipe() const { return data_->tag == Tag::kChunkedDataPipe; }
  inline void GetChunkedDataPipeDataView(
      DataElementChunkedDataPipeDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadChunkedDataPipe(UserType* output) const {
    
    CHECK(is_chunked_data_pipe());
    return mojo::internal::Deserialize<::network::mojom::DataElementChunkedDataPipeDataView>(
        data_->data.f_chunked_data_pipe.Get(), output, message_);
  }

 private:
  internal::DataElement_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_URL_REQUEST_MOJOM_DATA_VIEW_H_