// services/network/public/mojom/url_response_head.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_URL_RESPONSE_HEAD_MOJOM_SHARED_INTERNAL_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_URL_RESPONSE_HEAD_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/mojom/base/time.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared-internal.h"
#include "services/network/public/mojom/alternate_protocol_usage.mojom-shared-internal.h"
#include "services/network/public/mojom/attribution.mojom-shared-internal.h"
#include "services/network/public/mojom/cors.mojom-shared-internal.h"
#include "services/network/public/mojom/device_bound_sessions.mojom-shared-internal.h"
#include "services/network/public/mojom/encoded_body_length.mojom-shared-internal.h"
#include "services/network/public/mojom/fetch_api.mojom-shared-internal.h"
#include "services/network/public/mojom/http_request_headers.mojom-shared-internal.h"
#include "services/network/public/mojom/ip_address_space.mojom-shared-internal.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared-internal.h"
#include "services/network/public/mojom/load_timing_info.mojom-shared-internal.h"
#include "services/network/public/mojom/load_timing_internal_info.mojom-shared-internal.h"
#include "services/network/public/mojom/network_param.mojom-shared-internal.h"
#include "services/network/public/mojom/network_types.mojom-shared-internal.h"
#include "services/network/public/mojom/parsed_headers.mojom-shared-internal.h"
#include "services/network/public/mojom/parsed_request_cookie.mojom-shared-internal.h"
#include "services/network/public/mojom/service_worker_router_info.mojom-shared-internal.h"
#include "services/network/public/mojom/source_type.mojom-shared-internal.h"
#include "services/network/public/mojom/unencoded_digest.mojom-shared-internal.h"
#include "services/proxy_resolver/public/mojom/proxy_resolver.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace network::mojom {
namespace internal {
class URLResponseHead_Data;

struct NavigationDeliveryType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)
class  URLResponseHead_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::Time_Data> request_time;
  mojo::internal::Pointer<::mojo_base::mojom::internal::Time_Data> response_time;
  mojo::internal::Pointer<::mojo_base::mojom::internal::Time_Data> original_response_time;
  mojo::internal::Pointer<::network::mojom::internal::HttpResponseHeaders_Data> headers;
  mojo::internal::Pointer<mojo::internal::String_Data> mime_type;
  mojo::internal::Pointer<mojo::internal::String_Data> charset;
  int64_t content_length;
  int64_t encoded_data_length;
  mojo::internal::Pointer<::network::mojom::internal::EncodedBodyLength_Data> encoded_body_length;
  uint8_t network_accessed : 1;
  uint8_t emitted_extra_info : 1;
  uint8_t was_fetched_via_spdy : 1;
  uint8_t was_alpn_negotiated : 1;
  uint8_t was_alternate_protocol_available : 1;
  uint8_t is_validated : 1;
  uint8_t was_fetched_via_cache : 1;
  uint8_t was_fetched_via_service_worker : 1;
  uint8_t initial_service_worker_status_$flag : 1;
  uint8_t did_service_worker_navigation_preload : 1;
  uint8_t async_revalidation_requested : 1;
  uint8_t did_mime_sniff : 1;
  uint8_t is_signed_exchange_inner_response : 1;
  uint8_t is_web_bundle_inner_response : 1;
  uint8_t was_in_prefetch_cache : 1;
  uint8_t is_prefetch_with_cross_site_contamination : 1;
  uint8_t was_cookie_in_request : 1;
  uint8_t intercepted_by_plugin : 1;
  uint8_t has_range_requested : 1;
  uint8_t timing_allow_passed : 1;
  uint8_t has_authorization_covered_by_wildcard_on_preflight : 1;
  uint8_t request_include_credentials : 1;
  uint8_t should_use_source_hash_for_js_code_cache : 1;
  uint8_t did_use_shared_dictionary : 1;
  uint8_t load_with_storage_access : 1;
  uint8_t from_synthetic_response : 1;
  uint8_t bypass_redirect_checks : 1;
  int32_t connection_info;
  mojo::internal::Pointer<::network::mojom::internal::LoadTimingInfo_Data> load_timing;
  mojo::internal::Pointer<::network::mojom::internal::LoadTimingInternalInfo_Data> load_timing_internal_info;
  mojo::internal::Pointer<mojo::internal::String_Data> alpn_negotiated_protocol;
  int32_t alternate_protocol_usage;
  int32_t client_address_space;
  mojo::internal::Pointer<::network::mojom::internal::IPEndPoint_Data> remote_endpoint;
  int32_t response_address_space;
  int32_t navigation_delivery_type;
  mojo::internal::Pointer<::network::mojom::internal::ProxyChain_Data> proxy_chain;
  int32_t service_worker_response_source;
  int32_t initial_service_worker_status_$value;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::url::mojom::internal::Url_Data>>> url_list_via_service_worker;
  mojo::internal::Pointer<::network::mojom::internal::ServiceWorkerRouterInfo_Data> service_worker_router_info;
  int32_t response_type;
  uint32_t cert_status;
  int64_t padding;
  mojo::internal::Pointer<mojo::internal::String_Data> cache_storage_cache_name;
  mojo::internal::Pointer<::network::mojom::internal::SSLInfo_Data> ssl_info;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::network::mojom::internal::ParsedRequestCookie_Data>>> request_cookies;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> cors_exposed_header_names;
  mojo::internal::Pointer<::network::mojom::internal::AuthChallengeInfo_Data> auth_challenge_info;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> request_start;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> response_start;
  mojo::internal::Pointer<::network::mojom::internal::ParsedHeaders_Data> parsed_headers;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> recursive_prefetch_token;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> dns_aliases;
  int32_t private_network_access_preflight_result;
  int32_t device_bound_session_usage;
  mojo::internal::Pointer<mojo::internal::Array_Data<int32_t>> client_side_content_decoding_types;
  mojo::internal::Pointer<::network::mojom::internal::UnencodedDigests_Data> unencoded_digests;

 private:
  friend class mojo::internal::MessageFragment<URLResponseHead_Data>;

  URLResponseHead_Data();
  ~URLResponseHead_Data() = delete;
};
static_assert(sizeof(URLResponseHead_Data) == 288,
              "Bad sizeof(URLResponseHead_Data)");
// Used by URLResponseHead::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct URLResponseHead_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  URLResponseHead_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~URLResponseHead_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<URLResponseHead_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    URLResponseHead_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_URL_RESPONSE_HEAD_MOJOM_SHARED_INTERNAL_H_