// services/video_capture/public/mojom/video_capture_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/video_capture/public/mojom/video_capture_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/video_capture/public/mojom/video_capture_service.mojom-params-data.h"
#include "services/video_capture/public/mojom/video_capture_service.mojom-shared-message-ids.h"

#include "services/video_capture/public/mojom/video_capture_service.mojom-import-headers.h"
#include "services/video_capture/public/mojom/video_capture_service.mojom-test-utils.h"


namespace video_capture::mojom {
// The declaration includes the definition on other builds.

VideoCaptureService::IPCStableHashFunction VideoCaptureService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::VideoCaptureService>(message.name())) {
    case messages::VideoCaptureService::kConnectToVideoSourceProvider: {
      return &VideoCaptureService::ConnectToVideoSourceProvider_Sym::IPCStableHash;
    }
    case messages::VideoCaptureService::kBindControlsForTesting: {
      return &VideoCaptureService::BindControlsForTesting_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* VideoCaptureService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::VideoCaptureService>(message.name())) {
      case messages::VideoCaptureService::kConnectToVideoSourceProvider:
            return "Receive video_capture::mojom::VideoCaptureService::ConnectToVideoSourceProvider";
      case messages::VideoCaptureService::kBindControlsForTesting:
            return "Receive video_capture::mojom::VideoCaptureService::BindControlsForTesting";
    }
  } else {
    switch (static_cast<messages::VideoCaptureService>(message.name())) {
      case messages::VideoCaptureService::kConnectToVideoSourceProvider:
            return "Receive reply video_capture::mojom::VideoCaptureService::ConnectToVideoSourceProvider";
      case messages::VideoCaptureService::kBindControlsForTesting:
            return "Receive reply video_capture::mojom::VideoCaptureService::BindControlsForTesting";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t VideoCaptureService::ConnectToVideoSourceProvider_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x76c772c9;  // IPCStableHash for video_capture::mojom::VideoCaptureService::ConnectToVideoSourceProvider
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoCaptureService::BindControlsForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb150ccf3;  // IPCStableHash for video_capture::mojom::VideoCaptureService::BindControlsForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

VideoCaptureServiceProxy::VideoCaptureServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VideoCaptureServiceProxy::ConnectToVideoSourceProvider(
    ::mojo::PendingReceiver<::video_capture::mojom::VideoSourceProvider> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send video_capture::mojom::VideoCaptureService::ConnectToVideoSourceProvider", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::video_capture::mojom::VideoSourceProvider>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoCaptureService::kConnectToVideoSourceProvider), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoCaptureService_ConnectToVideoSourceProvider_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::video_capture::mojom::VideoSourceProviderInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in VideoCaptureService.ConnectToVideoSourceProvider request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureService::Name_);
  message.set_method_name("ConnectToVideoSourceProvider");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoCaptureServiceProxy::BindControlsForTesting(
    ::mojo::PendingReceiver<::video_capture::mojom::TestingControls> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send video_capture::mojom::VideoCaptureService::BindControlsForTesting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::video_capture::mojom::TestingControls>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoCaptureService::kBindControlsForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoCaptureService_BindControlsForTesting_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::video_capture::mojom::TestingControlsInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in VideoCaptureService.BindControlsForTesting request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureService::Name_);
  message.set_method_name("BindControlsForTesting");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool VideoCaptureServiceStubDispatch::Accept(
    VideoCaptureService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::VideoCaptureService>(message->header()->name)) {
    case messages::VideoCaptureService::kConnectToVideoSourceProvider: {
      DCHECK(message->is_serialized());
      internal::VideoCaptureService_ConnectToVideoSourceProvider_Params_Data* params =
          reinterpret_cast<internal::VideoCaptureService_ConnectToVideoSourceProvider_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoCaptureService.0
      bool success = true;
      ::mojo::PendingReceiver<::video_capture::mojom::VideoSourceProvider> p_receiver{};
      VideoCaptureService_ConnectToVideoSourceProvider_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoCaptureService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ConnectToVideoSourceProvider(        
        std::move(p_receiver));
      return true;
    }
    case messages::VideoCaptureService::kBindControlsForTesting: {
      DCHECK(message->is_serialized());
      internal::VideoCaptureService_BindControlsForTesting_Params_Data* params =
          reinterpret_cast<internal::VideoCaptureService_BindControlsForTesting_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoCaptureService.1
      bool success = true;
      ::mojo::PendingReceiver<::video_capture::mojom::TestingControls> p_receiver{};
      VideoCaptureService_BindControlsForTesting_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoCaptureService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindControlsForTesting(        
        std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool VideoCaptureServiceStubDispatch::AcceptWithResponder(
    VideoCaptureService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::VideoCaptureService>(message->header()->name)) {
    case messages::VideoCaptureService::kConnectToVideoSourceProvider: {
      break;
    }
    case messages::VideoCaptureService::kBindControlsForTesting: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kVideoCaptureServiceValidationInfo[] = {
    {base::to_underlying(messages::VideoCaptureService::kConnectToVideoSourceProvider),
     { &internal::VideoCaptureService_ConnectToVideoSourceProvider_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::VideoCaptureService::kBindControlsForTesting),
     { &internal::VideoCaptureService_BindControlsForTesting_Params_Data::Validate,
      nullptr /* no response */}},
};

bool VideoCaptureServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::video_capture::mojom::VideoCaptureService::Name_,
    kVideoCaptureServiceValidationInfo);
}



}  // video_capture::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace video_capture::mojom {


void VideoCaptureServiceInterceptorForTesting::ConnectToVideoSourceProvider(::mojo::PendingReceiver<::video_capture::mojom::VideoSourceProvider> receiver) {
  GetForwardingInterface()->ConnectToVideoSourceProvider(
    std::move(receiver)
    );
}
void VideoCaptureServiceInterceptorForTesting::BindControlsForTesting(::mojo::PendingReceiver<::video_capture::mojom::TestingControls> receiver) {
  GetForwardingInterface()->BindControlsForTesting(
    std::move(receiver)
    );
}
VideoCaptureServiceAsyncWaiter::VideoCaptureServiceAsyncWaiter(
    VideoCaptureService* proxy) : proxy_(proxy) {}

VideoCaptureServiceAsyncWaiter::~VideoCaptureServiceAsyncWaiter() = default;







}  // video_capture::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif