// services/video_capture/public/mojom/video_frame_handler.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/video_capture/public/mojom/video_frame_handler.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/video_capture/public/mojom/video_frame_handler.mojom-params-data.h"
#include "services/video_capture/public/mojom/video_frame_handler.mojom-shared-message-ids.h"

#include "services/video_capture/public/mojom/video_frame_handler.mojom-import-headers.h"
#include "services/video_capture/public/mojom/video_frame_handler.mojom-test-utils.h"


namespace video_capture::mojom {
ReadyFrameInBuffer::ReadyFrameInBuffer()
    : buffer_id(),
      frame_feedback_id(),
      frame_info() {}

ReadyFrameInBuffer::ReadyFrameInBuffer(
    int32_t buffer_id_in,
    int32_t frame_feedback_id_in,
    ::media::mojom::VideoFrameInfoPtr frame_info_in)
    : buffer_id(std::move(buffer_id_in)),
      frame_feedback_id(std::move(frame_feedback_id_in)),
      frame_info(std::move(frame_info_in)) {}

ReadyFrameInBuffer::~ReadyFrameInBuffer() = default;

void ReadyFrameInBuffer::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buffer_id"), this->buffer_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_feedback_id"), this->frame_feedback_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_info"), this->frame_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::mojom::VideoFrameInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ReadyFrameInBuffer::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

VideoFrameAccessHandler::IPCStableHashFunction VideoFrameAccessHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::VideoFrameAccessHandler>(message.name())) {
    case messages::VideoFrameAccessHandler::kOnFinishedConsumingBuffer: {
      return &VideoFrameAccessHandler::OnFinishedConsumingBuffer_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* VideoFrameAccessHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::VideoFrameAccessHandler>(message.name())) {
      case messages::VideoFrameAccessHandler::kOnFinishedConsumingBuffer:
            return "Receive video_capture::mojom::VideoFrameAccessHandler::OnFinishedConsumingBuffer";
    }
  } else {
    switch (static_cast<messages::VideoFrameAccessHandler>(message.name())) {
      case messages::VideoFrameAccessHandler::kOnFinishedConsumingBuffer:
            return "Receive reply video_capture::mojom::VideoFrameAccessHandler::OnFinishedConsumingBuffer";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t VideoFrameAccessHandler::OnFinishedConsumingBuffer_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x84eb7f98;  // IPCStableHash for video_capture::mojom::VideoFrameAccessHandler::OnFinishedConsumingBuffer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

VideoFrameAccessHandlerProxy::VideoFrameAccessHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VideoFrameAccessHandlerProxy::OnFinishedConsumingBuffer(
    int32_t in_buffer_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send video_capture::mojom::VideoFrameAccessHandler::OnFinishedConsumingBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_id"), in_buffer_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoFrameAccessHandler::kOnFinishedConsumingBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoFrameAccessHandler_OnFinishedConsumingBuffer_Params_Data> params(
          message);
  params.Allocate();

  params->buffer_id = in_buffer_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoFrameAccessHandler::Name_);
  message.set_method_name("OnFinishedConsumingBuffer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool VideoFrameAccessHandlerStubDispatch::Accept(
    VideoFrameAccessHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::VideoFrameAccessHandler>(message->header()->name)) {
    case messages::VideoFrameAccessHandler::kOnFinishedConsumingBuffer: {
      DCHECK(message->is_serialized());
      internal::VideoFrameAccessHandler_OnFinishedConsumingBuffer_Params_Data* params =
          reinterpret_cast<internal::VideoFrameAccessHandler_OnFinishedConsumingBuffer_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoFrameAccessHandler.0
      bool success = true;
      int32_t p_buffer_id{};
      VideoFrameAccessHandler_OnFinishedConsumingBuffer_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_buffer_id = input_data_view.buffer_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoFrameAccessHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFinishedConsumingBuffer(        
        std::move(p_buffer_id));
      return true;
    }
  }
  return false;
}

// static
bool VideoFrameAccessHandlerStubDispatch::AcceptWithResponder(
    VideoFrameAccessHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::VideoFrameAccessHandler>(message->header()->name)) {
    case messages::VideoFrameAccessHandler::kOnFinishedConsumingBuffer: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kVideoFrameAccessHandlerValidationInfo[] = {
    {base::to_underlying(messages::VideoFrameAccessHandler::kOnFinishedConsumingBuffer),
     { &internal::VideoFrameAccessHandler_OnFinishedConsumingBuffer_Params_Data::Validate,
      nullptr /* no response */}},
};

bool VideoFrameAccessHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::video_capture::mojom::VideoFrameAccessHandler::Name_,
    kVideoFrameAccessHandlerValidationInfo);
}

// The declaration includes the definition on other builds.

VideoFrameHandler::IPCStableHashFunction VideoFrameHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::VideoFrameHandler>(message.name())) {
    case messages::VideoFrameHandler::kOnCaptureConfigurationChanged: {
      return &VideoFrameHandler::OnCaptureConfigurationChanged_Sym::IPCStableHash;
    }
    case messages::VideoFrameHandler::kOnNewBuffer: {
      return &VideoFrameHandler::OnNewBuffer_Sym::IPCStableHash;
    }
    case messages::VideoFrameHandler::kOnFrameAccessHandlerReady: {
      return &VideoFrameHandler::OnFrameAccessHandlerReady_Sym::IPCStableHash;
    }
    case messages::VideoFrameHandler::kOnFrameReadyInBuffer: {
      return &VideoFrameHandler::OnFrameReadyInBuffer_Sym::IPCStableHash;
    }
    case messages::VideoFrameHandler::kOnBufferRetired: {
      return &VideoFrameHandler::OnBufferRetired_Sym::IPCStableHash;
    }
    case messages::VideoFrameHandler::kOnError: {
      return &VideoFrameHandler::OnError_Sym::IPCStableHash;
    }
    case messages::VideoFrameHandler::kOnFrameDropped: {
      return &VideoFrameHandler::OnFrameDropped_Sym::IPCStableHash;
    }
    case messages::VideoFrameHandler::kOnNewSubCaptureTargetVersion: {
      return &VideoFrameHandler::OnNewSubCaptureTargetVersion_Sym::IPCStableHash;
    }
    case messages::VideoFrameHandler::kOnFrameWithEmptyRegionCapture: {
      return &VideoFrameHandler::OnFrameWithEmptyRegionCapture_Sym::IPCStableHash;
    }
    case messages::VideoFrameHandler::kOnLog: {
      return &VideoFrameHandler::OnLog_Sym::IPCStableHash;
    }
    case messages::VideoFrameHandler::kOnStarted: {
      return &VideoFrameHandler::OnStarted_Sym::IPCStableHash;
    }
    case messages::VideoFrameHandler::kOnStartedUsingGpuDecode: {
      return &VideoFrameHandler::OnStartedUsingGpuDecode_Sym::IPCStableHash;
    }
    case messages::VideoFrameHandler::kOnStopped: {
      return &VideoFrameHandler::OnStopped_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* VideoFrameHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::VideoFrameHandler>(message.name())) {
      case messages::VideoFrameHandler::kOnCaptureConfigurationChanged:
            return "Receive video_capture::mojom::VideoFrameHandler::OnCaptureConfigurationChanged";
      case messages::VideoFrameHandler::kOnNewBuffer:
            return "Receive video_capture::mojom::VideoFrameHandler::OnNewBuffer";
      case messages::VideoFrameHandler::kOnFrameAccessHandlerReady:
            return "Receive video_capture::mojom::VideoFrameHandler::OnFrameAccessHandlerReady";
      case messages::VideoFrameHandler::kOnFrameReadyInBuffer:
            return "Receive video_capture::mojom::VideoFrameHandler::OnFrameReadyInBuffer";
      case messages::VideoFrameHandler::kOnBufferRetired:
            return "Receive video_capture::mojom::VideoFrameHandler::OnBufferRetired";
      case messages::VideoFrameHandler::kOnError:
            return "Receive video_capture::mojom::VideoFrameHandler::OnError";
      case messages::VideoFrameHandler::kOnFrameDropped:
            return "Receive video_capture::mojom::VideoFrameHandler::OnFrameDropped";
      case messages::VideoFrameHandler::kOnNewSubCaptureTargetVersion:
            return "Receive video_capture::mojom::VideoFrameHandler::OnNewSubCaptureTargetVersion";
      case messages::VideoFrameHandler::kOnFrameWithEmptyRegionCapture:
            return "Receive video_capture::mojom::VideoFrameHandler::OnFrameWithEmptyRegionCapture";
      case messages::VideoFrameHandler::kOnLog:
            return "Receive video_capture::mojom::VideoFrameHandler::OnLog";
      case messages::VideoFrameHandler::kOnStarted:
            return "Receive video_capture::mojom::VideoFrameHandler::OnStarted";
      case messages::VideoFrameHandler::kOnStartedUsingGpuDecode:
            return "Receive video_capture::mojom::VideoFrameHandler::OnStartedUsingGpuDecode";
      case messages::VideoFrameHandler::kOnStopped:
            return "Receive video_capture::mojom::VideoFrameHandler::OnStopped";
    }
  } else {
    switch (static_cast<messages::VideoFrameHandler>(message.name())) {
      case messages::VideoFrameHandler::kOnCaptureConfigurationChanged:
            return "Receive reply video_capture::mojom::VideoFrameHandler::OnCaptureConfigurationChanged";
      case messages::VideoFrameHandler::kOnNewBuffer:
            return "Receive reply video_capture::mojom::VideoFrameHandler::OnNewBuffer";
      case messages::VideoFrameHandler::kOnFrameAccessHandlerReady:
            return "Receive reply video_capture::mojom::VideoFrameHandler::OnFrameAccessHandlerReady";
      case messages::VideoFrameHandler::kOnFrameReadyInBuffer:
            return "Receive reply video_capture::mojom::VideoFrameHandler::OnFrameReadyInBuffer";
      case messages::VideoFrameHandler::kOnBufferRetired:
            return "Receive reply video_capture::mojom::VideoFrameHandler::OnBufferRetired";
      case messages::VideoFrameHandler::kOnError:
            return "Receive reply video_capture::mojom::VideoFrameHandler::OnError";
      case messages::VideoFrameHandler::kOnFrameDropped:
            return "Receive reply video_capture::mojom::VideoFrameHandler::OnFrameDropped";
      case messages::VideoFrameHandler::kOnNewSubCaptureTargetVersion:
            return "Receive reply video_capture::mojom::VideoFrameHandler::OnNewSubCaptureTargetVersion";
      case messages::VideoFrameHandler::kOnFrameWithEmptyRegionCapture:
            return "Receive reply video_capture::mojom::VideoFrameHandler::OnFrameWithEmptyRegionCapture";
      case messages::VideoFrameHandler::kOnLog:
            return "Receive reply video_capture::mojom::VideoFrameHandler::OnLog";
      case messages::VideoFrameHandler::kOnStarted:
            return "Receive reply video_capture::mojom::VideoFrameHandler::OnStarted";
      case messages::VideoFrameHandler::kOnStartedUsingGpuDecode:
            return "Receive reply video_capture::mojom::VideoFrameHandler::OnStartedUsingGpuDecode";
      case messages::VideoFrameHandler::kOnStopped:
            return "Receive reply video_capture::mojom::VideoFrameHandler::OnStopped";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t VideoFrameHandler::OnCaptureConfigurationChanged_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5f41e50e;  // IPCStableHash for video_capture::mojom::VideoFrameHandler::OnCaptureConfigurationChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoFrameHandler::OnNewBuffer_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf21fcaf8;  // IPCStableHash for video_capture::mojom::VideoFrameHandler::OnNewBuffer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoFrameHandler::OnFrameAccessHandlerReady_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf50f6ec3;  // IPCStableHash for video_capture::mojom::VideoFrameHandler::OnFrameAccessHandlerReady
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoFrameHandler::OnFrameReadyInBuffer_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x736c9402;  // IPCStableHash for video_capture::mojom::VideoFrameHandler::OnFrameReadyInBuffer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoFrameHandler::OnBufferRetired_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x98d49933;  // IPCStableHash for video_capture::mojom::VideoFrameHandler::OnBufferRetired
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoFrameHandler::OnError_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x91d4e192;  // IPCStableHash for video_capture::mojom::VideoFrameHandler::OnError
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoFrameHandler::OnFrameDropped_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1ea7f5bf;  // IPCStableHash for video_capture::mojom::VideoFrameHandler::OnFrameDropped
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoFrameHandler::OnNewSubCaptureTargetVersion_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6fb564e4;  // IPCStableHash for video_capture::mojom::VideoFrameHandler::OnNewSubCaptureTargetVersion
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoFrameHandler::OnFrameWithEmptyRegionCapture_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x99a82041;  // IPCStableHash for video_capture::mojom::VideoFrameHandler::OnFrameWithEmptyRegionCapture
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoFrameHandler::OnLog_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7fa835cd;  // IPCStableHash for video_capture::mojom::VideoFrameHandler::OnLog
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoFrameHandler::OnStarted_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbbae0859;  // IPCStableHash for video_capture::mojom::VideoFrameHandler::OnStarted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoFrameHandler::OnStartedUsingGpuDecode_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x863b2919;  // IPCStableHash for video_capture::mojom::VideoFrameHandler::OnStartedUsingGpuDecode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoFrameHandler::OnStopped_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3a0e952f;  // IPCStableHash for video_capture::mojom::VideoFrameHandler::OnStopped
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

VideoFrameHandlerProxy::VideoFrameHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VideoFrameHandlerProxy::OnCaptureConfigurationChanged(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send video_capture::mojom::VideoFrameHandler::OnCaptureConfigurationChanged");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoFrameHandler::kOnCaptureConfigurationChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoFrameHandler_OnCaptureConfigurationChanged_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoFrameHandler::Name_);
  message.set_method_name("OnCaptureConfigurationChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoFrameHandlerProxy::OnNewBuffer(
    int32_t in_buffer_id, ::media::mojom::VideoBufferHandlePtr in_buffer_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send video_capture::mojom::VideoFrameHandler::OnNewBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_id"), in_buffer_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_handle"), in_buffer_handle,
                        "<value of type ::media::mojom::VideoBufferHandlePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoFrameHandler::kOnNewBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoFrameHandler_OnNewBuffer_Params_Data> params(
          message);
  params.Allocate();

  params->buffer_id = in_buffer_id;
  mojo::internal::MessageFragment<decltype(params->buffer_handle)>
      buffer_handle_fragment(params.message());
  buffer_handle_fragment.Claim(&params->buffer_handle);
  
  mojo::internal::Serialize<::media::mojom::VideoBufferHandleDataView>(
    in_buffer_handle,
    buffer_handle_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->buffer_handle.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null buffer_handle in VideoFrameHandler.OnNewBuffer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoFrameHandler::Name_);
  message.set_method_name("OnNewBuffer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoFrameHandlerProxy::OnFrameAccessHandlerReady(
    ::mojo::PendingRemote<VideoFrameAccessHandler> in_frame_access_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send video_capture::mojom::VideoFrameHandler::OnFrameAccessHandlerReady", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_access_handler"), in_frame_access_handler,
                        "<value of type ::mojo::PendingRemote<VideoFrameAccessHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoFrameHandler::kOnFrameAccessHandlerReady), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoFrameHandler_OnFrameAccessHandlerReady_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::video_capture::mojom::VideoFrameAccessHandlerInterfaceBase>>(
    in_frame_access_handler,
    &params->frame_access_handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->frame_access_handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid frame_access_handler in VideoFrameHandler.OnFrameAccessHandlerReady request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoFrameHandler::Name_);
  message.set_method_name("OnFrameAccessHandlerReady");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoFrameHandlerProxy::OnFrameReadyInBuffer(
    ReadyFrameInBufferPtr in_buffer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send video_capture::mojom::VideoFrameHandler::OnFrameReadyInBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type ReadyFrameInBufferPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoFrameHandler::kOnFrameReadyInBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoFrameHandler_OnFrameReadyInBuffer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->buffer)::BaseType> buffer_fragment(
          params.message());
  
  mojo::internal::Serialize<::video_capture::mojom::ReadyFrameInBufferDataView>(
    in_buffer,
    buffer_fragment);

  params->buffer.Set(
      buffer_fragment.is_null() ? nullptr : buffer_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->buffer.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null buffer in VideoFrameHandler.OnFrameReadyInBuffer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoFrameHandler::Name_);
  message.set_method_name("OnFrameReadyInBuffer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoFrameHandlerProxy::OnBufferRetired(
    int32_t in_buffer_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send video_capture::mojom::VideoFrameHandler::OnBufferRetired", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_id"), in_buffer_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoFrameHandler::kOnBufferRetired), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoFrameHandler_OnBufferRetired_Params_Data> params(
          message);
  params.Allocate();

  params->buffer_id = in_buffer_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoFrameHandler::Name_);
  message.set_method_name("OnBufferRetired");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoFrameHandlerProxy::OnError(
    ::media::VideoCaptureError in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send video_capture::mojom::VideoFrameHandler::OnError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::media::VideoCaptureError>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoFrameHandler::kOnError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoFrameHandler_OnError_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::VideoCaptureError>(
    in_error,
    &params->error);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoFrameHandler::Name_);
  message.set_method_name("OnError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoFrameHandlerProxy::OnFrameDropped(
    ::media::VideoCaptureFrameDropReason in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send video_capture::mojom::VideoFrameHandler::OnFrameDropped", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type ::media::VideoCaptureFrameDropReason>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoFrameHandler::kOnFrameDropped), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoFrameHandler_OnFrameDropped_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::VideoCaptureFrameDropReason>(
    in_reason,
    &params->reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoFrameHandler::Name_);
  message.set_method_name("OnFrameDropped");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoFrameHandlerProxy::OnNewSubCaptureTargetVersion(
    uint32_t in_sub_capture_target_version) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send video_capture::mojom::VideoFrameHandler::OnNewSubCaptureTargetVersion", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sub_capture_target_version"), in_sub_capture_target_version,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoFrameHandler::kOnNewSubCaptureTargetVersion), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoFrameHandler_OnNewSubCaptureTargetVersion_Params_Data> params(
          message);
  params.Allocate();

  params->sub_capture_target_version = in_sub_capture_target_version;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoFrameHandler::Name_);
  message.set_method_name("OnNewSubCaptureTargetVersion");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoFrameHandlerProxy::OnFrameWithEmptyRegionCapture(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send video_capture::mojom::VideoFrameHandler::OnFrameWithEmptyRegionCapture");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoFrameHandler::kOnFrameWithEmptyRegionCapture), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoFrameHandler_OnFrameWithEmptyRegionCapture_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoFrameHandler::Name_);
  message.set_method_name("OnFrameWithEmptyRegionCapture");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoFrameHandlerProxy::OnLog(
    const std::string& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send video_capture::mojom::VideoFrameHandler::OnLog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoFrameHandler::kOnLog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoFrameHandler_OnLog_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in VideoFrameHandler.OnLog request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoFrameHandler::Name_);
  message.set_method_name("OnLog");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoFrameHandlerProxy::OnStarted(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send video_capture::mojom::VideoFrameHandler::OnStarted");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoFrameHandler::kOnStarted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoFrameHandler_OnStarted_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoFrameHandler::Name_);
  message.set_method_name("OnStarted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoFrameHandlerProxy::OnStartedUsingGpuDecode(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send video_capture::mojom::VideoFrameHandler::OnStartedUsingGpuDecode");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoFrameHandler::kOnStartedUsingGpuDecode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoFrameHandler_OnStartedUsingGpuDecode_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoFrameHandler::Name_);
  message.set_method_name("OnStartedUsingGpuDecode");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoFrameHandlerProxy::OnStopped(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send video_capture::mojom::VideoFrameHandler::OnStopped");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoFrameHandler::kOnStopped), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoFrameHandler_OnStopped_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoFrameHandler::Name_);
  message.set_method_name("OnStopped");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool VideoFrameHandlerStubDispatch::Accept(
    VideoFrameHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::VideoFrameHandler>(message->header()->name)) {
    case messages::VideoFrameHandler::kOnCaptureConfigurationChanged: {
      DCHECK(message->is_serialized());
      internal::VideoFrameHandler_OnCaptureConfigurationChanged_Params_Data* params =
          reinterpret_cast<internal::VideoFrameHandler_OnCaptureConfigurationChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoFrameHandler.0
      bool success = true;
      VideoFrameHandler_OnCaptureConfigurationChanged_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoFrameHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCaptureConfigurationChanged(        );
      return true;
    }
    case messages::VideoFrameHandler::kOnNewBuffer: {
      DCHECK(message->is_serialized());
      internal::VideoFrameHandler_OnNewBuffer_Params_Data* params =
          reinterpret_cast<internal::VideoFrameHandler_OnNewBuffer_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoFrameHandler.1
      bool success = true;
      int32_t p_buffer_id{};
      ::media::mojom::VideoBufferHandlePtr p_buffer_handle{};
      VideoFrameHandler_OnNewBuffer_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_buffer_id = input_data_view.buffer_id();
      if (success && !input_data_view.ReadBufferHandle(&p_buffer_handle))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoFrameHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNewBuffer(        
        std::move(p_buffer_id), 
        std::move(p_buffer_handle));
      return true;
    }
    case messages::VideoFrameHandler::kOnFrameAccessHandlerReady: {
      DCHECK(message->is_serialized());
      internal::VideoFrameHandler_OnFrameAccessHandlerReady_Params_Data* params =
          reinterpret_cast<internal::VideoFrameHandler_OnFrameAccessHandlerReady_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoFrameHandler.2
      bool success = true;
      ::mojo::PendingRemote<VideoFrameAccessHandler> p_frame_access_handler{};
      VideoFrameHandler_OnFrameAccessHandlerReady_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_frame_access_handler =
            input_data_view.TakeFrameAccessHandler<decltype(p_frame_access_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoFrameHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFrameAccessHandlerReady(        
        std::move(p_frame_access_handler));
      return true;
    }
    case messages::VideoFrameHandler::kOnFrameReadyInBuffer: {
      DCHECK(message->is_serialized());
      internal::VideoFrameHandler_OnFrameReadyInBuffer_Params_Data* params =
          reinterpret_cast<internal::VideoFrameHandler_OnFrameReadyInBuffer_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoFrameHandler.3
      bool success = true;
      ReadyFrameInBufferPtr p_buffer{};
      VideoFrameHandler_OnFrameReadyInBuffer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoFrameHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFrameReadyInBuffer(        
        std::move(p_buffer));
      return true;
    }
    case messages::VideoFrameHandler::kOnBufferRetired: {
      DCHECK(message->is_serialized());
      internal::VideoFrameHandler_OnBufferRetired_Params_Data* params =
          reinterpret_cast<internal::VideoFrameHandler_OnBufferRetired_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoFrameHandler.4
      bool success = true;
      int32_t p_buffer_id{};
      VideoFrameHandler_OnBufferRetired_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_buffer_id = input_data_view.buffer_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoFrameHandler::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBufferRetired(        
        std::move(p_buffer_id));
      return true;
    }
    case messages::VideoFrameHandler::kOnError: {
      DCHECK(message->is_serialized());
      internal::VideoFrameHandler_OnError_Params_Data* params =
          reinterpret_cast<internal::VideoFrameHandler_OnError_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoFrameHandler.5
      bool success = true;
      ::media::VideoCaptureError p_error{};
      VideoFrameHandler_OnError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadError(&p_error))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoFrameHandler::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnError(        
        std::move(p_error));
      return true;
    }
    case messages::VideoFrameHandler::kOnFrameDropped: {
      DCHECK(message->is_serialized());
      internal::VideoFrameHandler_OnFrameDropped_Params_Data* params =
          reinterpret_cast<internal::VideoFrameHandler_OnFrameDropped_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoFrameHandler.6
      bool success = true;
      ::media::VideoCaptureFrameDropReason p_reason{};
      VideoFrameHandler_OnFrameDropped_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoFrameHandler::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFrameDropped(        
        std::move(p_reason));
      return true;
    }
    case messages::VideoFrameHandler::kOnNewSubCaptureTargetVersion: {
      DCHECK(message->is_serialized());
      internal::VideoFrameHandler_OnNewSubCaptureTargetVersion_Params_Data* params =
          reinterpret_cast<internal::VideoFrameHandler_OnNewSubCaptureTargetVersion_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoFrameHandler.7
      bool success = true;
      uint32_t p_sub_capture_target_version{};
      VideoFrameHandler_OnNewSubCaptureTargetVersion_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_sub_capture_target_version = input_data_view.sub_capture_target_version();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoFrameHandler::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNewSubCaptureTargetVersion(        
        std::move(p_sub_capture_target_version));
      return true;
    }
    case messages::VideoFrameHandler::kOnFrameWithEmptyRegionCapture: {
      DCHECK(message->is_serialized());
      internal::VideoFrameHandler_OnFrameWithEmptyRegionCapture_Params_Data* params =
          reinterpret_cast<internal::VideoFrameHandler_OnFrameWithEmptyRegionCapture_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoFrameHandler.8
      bool success = true;
      VideoFrameHandler_OnFrameWithEmptyRegionCapture_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoFrameHandler::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFrameWithEmptyRegionCapture(        );
      return true;
    }
    case messages::VideoFrameHandler::kOnLog: {
      DCHECK(message->is_serialized());
      internal::VideoFrameHandler_OnLog_Params_Data* params =
          reinterpret_cast<internal::VideoFrameHandler_OnLog_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoFrameHandler.9
      bool success = true;
      std::string p_message{};
      VideoFrameHandler_OnLog_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoFrameHandler::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnLog(        
        std::move(p_message));
      return true;
    }
    case messages::VideoFrameHandler::kOnStarted: {
      DCHECK(message->is_serialized());
      internal::VideoFrameHandler_OnStarted_Params_Data* params =
          reinterpret_cast<internal::VideoFrameHandler_OnStarted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoFrameHandler.10
      bool success = true;
      VideoFrameHandler_OnStarted_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoFrameHandler::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStarted(        );
      return true;
    }
    case messages::VideoFrameHandler::kOnStartedUsingGpuDecode: {
      DCHECK(message->is_serialized());
      internal::VideoFrameHandler_OnStartedUsingGpuDecode_Params_Data* params =
          reinterpret_cast<internal::VideoFrameHandler_OnStartedUsingGpuDecode_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoFrameHandler.11
      bool success = true;
      VideoFrameHandler_OnStartedUsingGpuDecode_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoFrameHandler::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStartedUsingGpuDecode(        );
      return true;
    }
    case messages::VideoFrameHandler::kOnStopped: {
      DCHECK(message->is_serialized());
      internal::VideoFrameHandler_OnStopped_Params_Data* params =
          reinterpret_cast<internal::VideoFrameHandler_OnStopped_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoFrameHandler.12
      bool success = true;
      VideoFrameHandler_OnStopped_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoFrameHandler::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStopped(        );
      return true;
    }
  }
  return false;
}

// static
bool VideoFrameHandlerStubDispatch::AcceptWithResponder(
    VideoFrameHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::VideoFrameHandler>(message->header()->name)) {
    case messages::VideoFrameHandler::kOnCaptureConfigurationChanged: {
      break;
    }
    case messages::VideoFrameHandler::kOnNewBuffer: {
      break;
    }
    case messages::VideoFrameHandler::kOnFrameAccessHandlerReady: {
      break;
    }
    case messages::VideoFrameHandler::kOnFrameReadyInBuffer: {
      break;
    }
    case messages::VideoFrameHandler::kOnBufferRetired: {
      break;
    }
    case messages::VideoFrameHandler::kOnError: {
      break;
    }
    case messages::VideoFrameHandler::kOnFrameDropped: {
      break;
    }
    case messages::VideoFrameHandler::kOnNewSubCaptureTargetVersion: {
      break;
    }
    case messages::VideoFrameHandler::kOnFrameWithEmptyRegionCapture: {
      break;
    }
    case messages::VideoFrameHandler::kOnLog: {
      break;
    }
    case messages::VideoFrameHandler::kOnStarted: {
      break;
    }
    case messages::VideoFrameHandler::kOnStartedUsingGpuDecode: {
      break;
    }
    case messages::VideoFrameHandler::kOnStopped: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kVideoFrameHandlerValidationInfo[] = {
    {base::to_underlying(messages::VideoFrameHandler::kOnCaptureConfigurationChanged),
     { &internal::VideoFrameHandler_OnCaptureConfigurationChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::VideoFrameHandler::kOnNewBuffer),
     { &internal::VideoFrameHandler_OnNewBuffer_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::VideoFrameHandler::kOnFrameAccessHandlerReady),
     { &internal::VideoFrameHandler_OnFrameAccessHandlerReady_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::VideoFrameHandler::kOnFrameReadyInBuffer),
     { &internal::VideoFrameHandler_OnFrameReadyInBuffer_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::VideoFrameHandler::kOnBufferRetired),
     { &internal::VideoFrameHandler_OnBufferRetired_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::VideoFrameHandler::kOnError),
     { &internal::VideoFrameHandler_OnError_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::VideoFrameHandler::kOnFrameDropped),
     { &internal::VideoFrameHandler_OnFrameDropped_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::VideoFrameHandler::kOnNewSubCaptureTargetVersion),
     { &internal::VideoFrameHandler_OnNewSubCaptureTargetVersion_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::VideoFrameHandler::kOnFrameWithEmptyRegionCapture),
     { &internal::VideoFrameHandler_OnFrameWithEmptyRegionCapture_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::VideoFrameHandler::kOnLog),
     { &internal::VideoFrameHandler_OnLog_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::VideoFrameHandler::kOnStarted),
     { &internal::VideoFrameHandler_OnStarted_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::VideoFrameHandler::kOnStartedUsingGpuDecode),
     { &internal::VideoFrameHandler_OnStartedUsingGpuDecode_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::VideoFrameHandler::kOnStopped),
     { &internal::VideoFrameHandler_OnStopped_Params_Data::Validate,
      nullptr /* no response */}},
};

bool VideoFrameHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::video_capture::mojom::VideoFrameHandler::Name_,
    kVideoFrameHandlerValidationInfo);
}



}  // video_capture::mojom


namespace mojo {


// static
bool StructTraits<::video_capture::mojom::ReadyFrameInBuffer::DataView, ::video_capture::mojom::ReadyFrameInBufferPtr>::Read(
    ::video_capture::mojom::ReadyFrameInBuffer::DataView input,
    ::video_capture::mojom::ReadyFrameInBufferPtr* output) {
  bool success = true;
  ::video_capture::mojom::ReadyFrameInBufferPtr result(::video_capture::mojom::ReadyFrameInBuffer::New());
  
      if (success)
        result->buffer_id = input.buffer_id();
      if (success)
        result->frame_feedback_id = input.frame_feedback_id();
      if (success && !input.ReadFrameInfo(&result->frame_info))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace video_capture::mojom {


void VideoFrameAccessHandlerInterceptorForTesting::OnFinishedConsumingBuffer(int32_t buffer_id) {
  GetForwardingInterface()->OnFinishedConsumingBuffer(
    std::move(buffer_id)
    );
}
VideoFrameAccessHandlerAsyncWaiter::VideoFrameAccessHandlerAsyncWaiter(
    VideoFrameAccessHandler* proxy) : proxy_(proxy) {}

VideoFrameAccessHandlerAsyncWaiter::~VideoFrameAccessHandlerAsyncWaiter() = default;





void VideoFrameHandlerInterceptorForTesting::OnCaptureConfigurationChanged() {
  GetForwardingInterface()->OnCaptureConfigurationChanged();
}
void VideoFrameHandlerInterceptorForTesting::OnNewBuffer(int32_t buffer_id, ::media::mojom::VideoBufferHandlePtr buffer_handle) {
  GetForwardingInterface()->OnNewBuffer(
    std::move(buffer_id)
    , 
    std::move(buffer_handle)
    );
}
void VideoFrameHandlerInterceptorForTesting::OnFrameAccessHandlerReady(::mojo::PendingRemote<VideoFrameAccessHandler> frame_access_handler) {
  GetForwardingInterface()->OnFrameAccessHandlerReady(
    std::move(frame_access_handler)
    );
}
void VideoFrameHandlerInterceptorForTesting::OnFrameReadyInBuffer(ReadyFrameInBufferPtr buffer) {
  GetForwardingInterface()->OnFrameReadyInBuffer(
    std::move(buffer)
    );
}
void VideoFrameHandlerInterceptorForTesting::OnBufferRetired(int32_t buffer_id) {
  GetForwardingInterface()->OnBufferRetired(
    std::move(buffer_id)
    );
}
void VideoFrameHandlerInterceptorForTesting::OnError(::media::VideoCaptureError error) {
  GetForwardingInterface()->OnError(
    std::move(error)
    );
}
void VideoFrameHandlerInterceptorForTesting::OnFrameDropped(::media::VideoCaptureFrameDropReason reason) {
  GetForwardingInterface()->OnFrameDropped(
    std::move(reason)
    );
}
void VideoFrameHandlerInterceptorForTesting::OnNewSubCaptureTargetVersion(uint32_t sub_capture_target_version) {
  GetForwardingInterface()->OnNewSubCaptureTargetVersion(
    std::move(sub_capture_target_version)
    );
}
void VideoFrameHandlerInterceptorForTesting::OnFrameWithEmptyRegionCapture() {
  GetForwardingInterface()->OnFrameWithEmptyRegionCapture();
}
void VideoFrameHandlerInterceptorForTesting::OnLog(const std::string& message) {
  GetForwardingInterface()->OnLog(
    std::move(message)
    );
}
void VideoFrameHandlerInterceptorForTesting::OnStarted() {
  GetForwardingInterface()->OnStarted();
}
void VideoFrameHandlerInterceptorForTesting::OnStartedUsingGpuDecode() {
  GetForwardingInterface()->OnStartedUsingGpuDecode();
}
void VideoFrameHandlerInterceptorForTesting::OnStopped() {
  GetForwardingInterface()->OnStopped();
}
VideoFrameHandlerAsyncWaiter::VideoFrameHandlerAsyncWaiter(
    VideoFrameHandler* proxy) : proxy_(proxy) {}

VideoFrameHandlerAsyncWaiter::~VideoFrameHandlerAsyncWaiter() = default;







}  // video_capture::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif