// services/viz/public/mojom/compositing/surface_id.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/surface_id.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/surface_id.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/surface_id.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/surface_id.mojom-import-headers.h"
#include "services/viz/public/mojom/compositing/surface_id.mojom-test-utils.h"


namespace viz::mojom {
SurfaceId::SurfaceId()
    : frame_sink_id(),
      local_surface_id() {}

SurfaceId::SurfaceId(
    const ::viz::FrameSinkId& frame_sink_id_in,
    const ::viz::LocalSurfaceId& local_surface_id_in)
    : frame_sink_id(std::move(frame_sink_id_in)),
      local_surface_id(std::move(local_surface_id_in)) {}

SurfaceId::~SurfaceId() = default;

void SurfaceId::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_sink_id"), this->frame_sink_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::viz::FrameSinkId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "local_surface_id"), this->local_surface_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::viz::LocalSurfaceId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SurfaceId::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // viz::mojom


namespace mojo {


// static
bool StructTraits<::viz::mojom::SurfaceId::DataView, ::viz::mojom::SurfaceIdPtr>::Read(
    ::viz::mojom::SurfaceId::DataView input,
    ::viz::mojom::SurfaceIdPtr* output) {
  bool success = true;
  ::viz::mojom::SurfaceIdPtr result(::viz::mojom::SurfaceId::New());
  
      if (success && !input.ReadFrameSinkId(&result->frame_sink_id))
        success = false;
      if (success && !input.ReadLocalSurfaceId(&result->local_surface_id))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace viz::mojom {




}  // viz::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif