// services/viz/public/mojom/compositing/texture_releaser.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_TEXTURE_RELEASER_MOJOM_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_TEXTURE_RELEASER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/texture_releaser.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/texture_releaser.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/texture_releaser.mojom-forward.h"  // IWYU pragma: export
#include "gpu/ipc/common/sync_token.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace viz::mojom {

class TextureReleaserProxy;

template <typename ImplRefTraits>
class TextureReleaserStub;

class TextureReleaserRequestValidator;


class TextureReleaser
    : public TextureReleaserInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "viz.mojom.TextureReleaser";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = TextureReleaserInterfaceBase;
  using Proxy_ = TextureReleaserProxy;

  template <typename ImplRefTraits>
  using Stub_ = TextureReleaserStub<ImplRefTraits>;

  using RequestValidator_ = TextureReleaserRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kReleaseMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Release_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~TextureReleaser() = default;

  virtual void Release(const ::gpu::SyncToken& sync_token, bool is_lost) = 0;
};



class  TextureReleaserProxy
    : public TextureReleaser {
 public:
  using InterfaceType = TextureReleaser;

  explicit TextureReleaserProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Release(const ::gpu::SyncToken& sync_token, bool is_lost) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  TextureReleaserStubDispatch {
 public:
  static bool Accept(TextureReleaser* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      TextureReleaser* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<TextureReleaser>>
class TextureReleaserStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  TextureReleaserStub() = default;
  ~TextureReleaserStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TextureReleaserStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TextureReleaserStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  TextureReleaserRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // viz::mojom

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_TEXTURE_RELEASER_MOJOM_H_