// services/viz/public/mojom/compositing/tiling.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_TILING_MOJOM_DATA_VIEW_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_TILING_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/viz/public/mojom/compositing/tiling.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/transferable_resource.mojom-shared.h"
#include "skia/public/mojom/skcolor4f.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "cc/mojom/missing_tile_reason.mojom-shared.h"


namespace viz::mojom {
class TileResourceDataView;

class TileDataView;

class TilingDataView;

class TileContentsDataView;


}  // viz::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::TileResourceDataView> {
  using Data = ::viz::mojom::internal::TileResource_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::TileDataView> {
  using Data = ::viz::mojom::internal::Tile_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::TilingDataView> {
  using Data = ::viz::mojom::internal::Tiling_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::TileContentsDataView> {
  using Data = ::viz::mojom::internal::TileContents_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


class TileResourceDataView {
 public:
  TileResourceDataView() = default;

  TileResourceDataView(
      internal::TileResource_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResourceDataView(
      ::viz::mojom::TransferableResourceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResource(UserType* output) {
    
    auto* pointer = data_->resource.Get();
    return mojo::internal::Deserialize<::viz::mojom::TransferableResourceDataView>(
        pointer, output, message_);
  }
  bool is_checkered() const {
    return data_->is_checkered;
  }
 private:
  internal::TileResource_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TileDataView {
 public:
  TileDataView() = default;

  TileDataView(
      internal::Tile_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t column_index() const {
    return data_->column_index;
  }
  uint32_t row_index() const {
    return data_->row_index;
  }
  inline void GetContentsDataView(
      TileContentsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContents(UserType* output) {
    
    auto* pointer = !data_->contents.is_null() ? &data_->contents : nullptr;
    return mojo::internal::Deserialize<::viz::mojom::TileContentsDataView>(
        pointer, output, message_);
  }
 private:
  internal::Tile_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TilingDataView {
 public:
  TilingDataView() = default;

  TilingDataView(
      internal::Tiling_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t layer_id() const {
    return data_->layer_id;
  }
  inline void GetRasterTranslationDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRasterTranslation(UserType* output) {
    
    auto* pointer = data_->raster_translation.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, message_);
  }
  inline void GetRasterScaleDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRasterScale(UserType* output) {
    
    auto* pointer = data_->raster_scale.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, message_);
  }
  inline void GetTileSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTileSize(UserType* output) {
    
    auto* pointer = data_->tile_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetTilingRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTilingRect(UserType* output) {
    
    auto* pointer = data_->tiling_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetTilesDataView(
      mojo::ArrayDataView<TileDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTiles(UserType* output) {
    
    auto* pointer = data_->tiles.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::TileDataView>>(
        pointer, output, message_);
  }
  float scale_key() const {
    return data_->scale_key;
  }
  bool is_deleted() const {
    return data_->is_deleted;
  }
 private:
  internal::Tiling_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TileContentsDataView {
 public:
  using Tag = internal::TileContents_Data::TileContents_Tag;

  TileContentsDataView() = default;

  TileContentsDataView(
      internal::TileContents_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_missing_reason() const { return data_->tag == Tag::kMissingReason; }
  template <typename UserType>
  [[nodiscard]] bool ReadMissingReason(UserType* output) const {
    CHECK(is_missing_reason());
    return mojo::internal::Deserialize<::cc::mojom::MissingTileReason>(
        data_->data.f_missing_reason, output);
  }
  ::cc::mojom::MissingTileReason missing_reason() const {
    CHECK(is_missing_reason());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::cc::mojom::MissingTileReason>(data_->data.f_missing_reason));
  }
  bool is_resource() const { return data_->tag == Tag::kResource; }
  inline void GetResourceDataView(
      TileResourceDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadResource(UserType* output) const {
    
    CHECK(is_resource());
    return mojo::internal::Deserialize<::viz::mojom::TileResourceDataView>(
        data_->data.f_resource.Get(), output, message_);
  }
  bool is_solid_color() const { return data_->tag == Tag::kSolidColor; }
  inline void GetSolidColorDataView(
      ::skia::mojom::SkColor4fDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSolidColor(UserType* output) const {
    
    CHECK(is_solid_color());
    return mojo::internal::Deserialize<::skia::mojom::SkColor4fDataView>(
        data_->data.f_solid_color.Get(), output, message_);
  }

 private:
  internal::TileContents_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // viz::mojom

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_TILING_MOJOM_DATA_VIEW_H_