// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Generated from template:
//   templates/features_generated.cc.tmpl
// and input files:
//   ../../../../../qtwebengine/src/3rdparty/chromium/third_party/blink/renderer/platform/runtime_enabled_features.json5


#include "third_party/blink/public/common/features_generated.h"

namespace blink {
namespace features {

BASE_FEATURE(kAccelerated2dCanvas,
    "Accelerated2dCanvas",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kAcceleratedSmallCanvases,
    "AcceleratedSmallCanvases",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kAccessibilityExposeDisplayNone,
    "AccessibilityExposeDisplayNone",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kAccessibilityImplicitActions,
    "AccessibilityImplicitActions",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kAccessibilityMinRoleTabbable,
    "AccessibilityMinRoleTabbable",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kAccessibilityOSLevelBoldText,
    "AccessibilityOSLevelBoldText",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kAccessibilityProhibitedNames,
    "AccessibilityProhibitedNames",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kAccessibilitySerializationSizeMetrics,
    "AccessibilitySerializationSizeMetrics",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kAddressSpace,
    "AddressSpace",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kAdInterestGroupAPI,
    "AdInterestGroupAPI",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kAdjustDOMOffsetToLayoutOffsetForSecureText,
    "AdjustDOMOffsetToLayoutOffsetForSecureText",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kAdjustEndOfNextParagraphIfMovedParagraphIsUpdated,
    "AdjustEndOfNextParagraphIfMovedParagraphIsUpdated",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kAIPageContentPaidContentAnnotation,
    "AIPageContentPaidContentAnnotation",
    base::FEATURE_ENABLED_BY_DEFAULT);

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kAIPromptAPI,
    "AIPromptAPI",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kAIPromptAPI,
    "AIPromptAPI",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kAIPromptAPI,
    "AIPromptAPI",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kAIPromptAPI,
    "AIPromptAPI",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kAIPromptAPI,
    "AIPromptAPI",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kAIPromptAPI,
    "AIPromptAPI",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kAIPromptAPI,
    "AIPromptAPI",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kAIPromptAPIForExtension,
    "AIPromptAPIForExtension",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kAIPromptAPIForExtension,
    "AIPromptAPIForExtension",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kAIPromptAPIForExtension,
    "AIPromptAPIForExtension",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kAIPromptAPIForExtension,
    "AIPromptAPIForExtension",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kAIPromptAPIForExtension,
    "AIPromptAPIForExtension",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kAIPromptAPIForExtension,
    "AIPromptAPIForExtension",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kAIPromptAPIForExtension,
    "AIPromptAPIForExtension",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif

BASE_FEATURE(kAIPromptAPIForWorkers,
    "AIPromptAPIForWorkers",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kAIPromptAPIMultimodalInput,
    "AIPromptAPIMultimodalInput",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kAIPromptAPIStructuredOutput,
    "AIPromptAPIStructuredOutput",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kAIProofreadingAPI,
    "AIProofreadingAPI",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kAIRewriterAPI,
    "AIRewriterAPI",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kAIRewriterAPIForWorkers,
    "AIRewriterAPIForWorkers",
    base::FEATURE_DISABLED_BY_DEFAULT);

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kAISummarizationAPI,
    "AISummarizationAPI",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kAISummarizationAPI,
    "AISummarizationAPI",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kAISummarizationAPI,
    "AISummarizationAPI",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kAISummarizationAPI,
    "AISummarizationAPI",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kAISummarizationAPI,
    "AISummarizationAPI",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kAISummarizationAPI,
    "AISummarizationAPI",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kAISummarizationAPI,
    "AISummarizationAPI",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif

BASE_FEATURE(kAISummarizationAPIForWorkers,
    "AISummarizationAPIForWorkers",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kAIWriterAPI,
    "AIWriterAPI",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kAIWriterAPIForWorkers,
    "AIWriterAPIForWorkers",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kAliasWebkitFillAvailable,
    "AliasWebkitFillAvailable",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kAlignZoomToCenter,
    "AlignZoomToCenter",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kAllowCopyingEmptyLastTableCell,
    "AllowCopyingEmptyLastTableCell",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kAllowPreloadingWithCSPMetaTag,
    "AllowPreloadingWithCSPMetaTag",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kAllowSkippingEditingBoundaryToMergeEnd,
    "AllowSkippingEditingBoundaryToMergeEnd",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kAllowSvgUseToReferenceExternalDocumentRoot,
    "AllowSvgUseToReferenceExternalDocumentRoot",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kAnchorPositionAdjustmentWithoutOverflow,
    "AnchorPositionAdjustmentWithoutOverflow",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kAnimationProgressAPI,
    "AnimationProgressAPI",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kAnimationTrigger,
    "AnimationTrigger",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kAnimationWorklet,
    "AnimationWorklet",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kAnonymousIframe,
    "AnonymousIframe",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kAOMAriaRelationshipProperties,
    "AOMAriaRelationshipProperties",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kAOMAriaRelationshipPropertiesAriaOwns,
    "AOMAriaRelationshipPropertiesAriaOwns",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kWebAppEnableAppTitle,
    "WebAppEnableAppTitle",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kAriaActions,
    "AriaActions",
    base::FEATURE_DISABLED_BY_DEFAULT);

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kAriaNotify,
    "AriaNotify",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kAriaNotify,
    "AriaNotify",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kAriaNotify,
    "AriaNotify",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kAriaNotify,
    "AriaNotify",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kAriaNotify,
    "AriaNotify",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kAriaNotify,
    "AriaNotify",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kAriaNotify,
    "AriaNotify",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kAriaNotifyV2,
    "AriaNotifyV2",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kAriaNotifyV2,
    "AriaNotifyV2",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kAriaNotifyV2,
    "AriaNotifyV2",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kAriaNotifyV2,
    "AriaNotifyV2",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kAriaNotifyV2,
    "AriaNotifyV2",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kAriaNotifyV2,
    "AriaNotifyV2",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kAriaNotifyV2,
    "AriaNotifyV2",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif

BASE_FEATURE(kAriaRowColIndexText,
    "AriaRowColIndexText",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kAsymmetricWordBoundaryFix,
    "AsymmetricWordBoundaryFix",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kAsyncSetCookie,
    "AsyncSetCookie",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kAttributeDirectionality,
    "AttributeDirectionality",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kAudioContextOnError,
    "AudioContextOnError",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kAudioContextPlayoutStats,
    "AudioContextPlayoutStats",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kAudioContextSetSinkId,
    "AudioContextSetSinkId",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kAudioVideoTracks,
    "AudioVideoTracks",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kAutoPictureInPictureVideoHeuristics,
    "AutoPictureInPictureVideoHeuristics",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kAvoidForcedLayoutOnInvisibleDocumentClose,
    "AvoidForcedLayoutOnInvisibleDocumentClose",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kAvoidNormalizingVisiblePositionsWhenStartEqualsEnd,
    "AvoidNormalizingVisiblePositionsWhenStartEqualsEnd",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kAvoidSelectionChangeOnCanvasClick,
    "AvoidSelectionChangeOnCanvasClick",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kBackfaceVisibilityInterop,
    "BackfaceVisibilityInterop",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kBackForwardCacheSendNotRestoredReasons,
    "BackForwardCacheSendNotRestoredReasons",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kBackForwardCacheRestorationPerformanceEntry,
    "BackForwardCacheRestorationPerformanceEntry",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kBackForwardCacheUpdateNotRestoredReasonsName,
    "BackForwardCacheUpdateNotRestoredReasonsName",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kBackForwardTransitions,
    "BackForwardTransitions",
    base::FEATURE_DISABLED_BY_DEFAULT);

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kBarcodeDetector,
    "BarcodeDetector",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kBarcodeDetector,
    "BarcodeDetector",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kBarcodeDetector,
    "BarcodeDetector",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kBarcodeDetector,
    "BarcodeDetector",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kBarcodeDetector,
    "BarcodeDetector",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kBarcodeDetector,
    "BarcodeDetector",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kBarcodeDetector,
    "BarcodeDetector",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif

BASE_FEATURE(kBidiCaretAffinity,
    "BidiCaretAffinity",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kBlinkExtensionChromeOS,
    "BlinkExtensionChromeOS",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kBlinkExtensionChromeOSKiosk,
    "BlinkExtensionChromeOSKiosk",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kBlinkExtensionWebView,
    "BlinkExtensionWebView",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kBlinkExtensionWebViewMediaIntegrity,
    "BlinkExtensionWebViewMediaIntegrity",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kBlinkLifecycleScriptForbidden,
    "BlinkLifecycleScriptForbidden",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kBlinkRuntimeCallStats,
    "BlinkRuntimeCallStats",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kBlockingFocusWithoutUserActivation,
    "BlockingFocusWithoutUserActivation",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kBoundaryEventDispatchTracksNodeRemoval,
    "BoundaryEventDispatchTracksNodeRemoval",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kBrowserInitiatedAutomaticPictureInPicture,
    "BrowserInitiatedAutomaticPictureInPicture",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kBufferedBytesConsumerLimitSize,
    "BufferedBytesConsumerLimitSize",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kBuiltInAIAPI,
    "BuiltInAIAPI",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kBypassPepcSecurityForTesting,
    "BypassPepcSecurityForTesting",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCallExitNodeWithoutLayoutObject,
    "CallExitNodeWithoutLayoutObject",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCanvas2dCanvasFilter,
    "Canvas2dCanvasFilter",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCanvas2dGPUTransfer,
    "Canvas2dGPUTransfer",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCanvas2dLayers,
    "Canvas2dLayers",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCanvas2dLayersWithOptions,
    "Canvas2dLayersWithOptions",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCanvas2dMesh,
    "Canvas2dMesh",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCanvasDrawElement,
    "CanvasDrawElement",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCanvasDrawElementInSubtree,
    "CanvasDrawElementInSubtree",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCanvasFloatingPoint,
    "CanvasFloatingPoint",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCanvasGlobalHDRHeadroom,
    "CanvasGlobalHDRHeadroom",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCanvasGradientCSSColor4,
    "CanvasGradientCSSColor4",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCanvasHDR,
    "CanvasHDR",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCanvasTextCacheLimit,
    "CanvasTextCacheLimit",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCanvasTextNg,
    "CanvasTextNg",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCanvasUsesArcPaintOp,
    "CanvasUsesArcPaintOp",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCapabilityDelegationDisplayCaptureRequest,
    "CapabilityDelegationDisplayCaptureRequest",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCaptureController,
    "CaptureController",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCapturedMouseEvents,
    "CapturedMouseEvents",
    base::FEATURE_DISABLED_BY_DEFAULT);

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kCapturedSurfaceControl,
    "CapturedSurfaceControl",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kCapturedSurfaceControl,
    "CapturedSurfaceControl",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kCapturedSurfaceControl,
    "CapturedSurfaceControl",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kCapturedSurfaceControl,
    "CapturedSurfaceControl",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kCapturedSurfaceControl,
    "CapturedSurfaceControl",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kCapturedSurfaceControl,
    "CapturedSurfaceControl",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kCapturedSurfaceControl,
    "CapturedSurfaceControl",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kCapturedSurfaceResolution,
    "CapturedSurfaceResolution",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kCapturedSurfaceResolution,
    "CapturedSurfaceResolution",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kCapturedSurfaceResolution,
    "CapturedSurfaceResolution",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kCapturedSurfaceResolution,
    "CapturedSurfaceResolution",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kCapturedSurfaceResolution,
    "CapturedSurfaceResolution",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kCapturedSurfaceResolution,
    "CapturedSurfaceResolution",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kCapturedSurfaceResolution,
    "CapturedSurfaceResolution",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif

BASE_FEATURE(kCaptureHandle,
    "CaptureHandle",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCaretWithTextAffinityUpstream,
    "CaretWithTextAffinityUpstream",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCascadedAfterChangeStyle,
    "CascadedAfterChangeStyle",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCCTNewRFMPushBehavior,
    "CCTNewRFMPushBehavior",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCheckForCanonicalPositionInIdleSpellCheck,
    "CheckForCanonicalPositionInIdleSpellCheck",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCheckVisibilityExtraProperties,
    "CheckVisibilityExtraProperties",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kClearPopoverInvokerAfterBeforeToggle,
    "ClearPopoverInvokerAfterBeforeToggle",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kClientHintUAHighEntropyValuesPermissionPolicy,
    "ClientHintUAHighEntropyValuesPermissionPolicy",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kClipboardChangeEvent,
    "ClipboardChangeEvent",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kClipboardEventTargetCanBeFocusedElement,
    "ClipboardEventTargetCanBeFocusedElement",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kClipboardItemWithDOMStringSupport,
    "ClipboardItemWithDOMStringSupport",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kClipboardSnapshotResetOnWrite,
    "ClipboardSnapshotResetOnWrite",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kClipElementVisibleBoundsInLocalRoot,
    "ClipElementVisibleBoundsInLocalRoot",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kClipPathNestedRasterOptimization,
    "ClipPathNestedRasterOptimization",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCoalesceSelectionchangeEvent,
    "CoalesceSelectionchangeEvent",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCoepReflection,
    "CoepReflection",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCollapseZeroWidthSpaceWhenReuseItem,
    "CollapseZeroWidthSpaceWhenReuseItem",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kColorInputDatalistLooksNormal,
    "ColorInputDatalistLooksNormal",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCompositeBoxShadowAnimation,
    "CompositeBoxShadowAnimation",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCompositeClipPathAnimation,
    "CompositeClipPathAnimation",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCompositedAnimationsCancelledAsynchronously,
    "CompositedAnimationsCancelledAsynchronously",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCompositingDecisionAtAnimationPhaseBoundaries,
    "CompositingDecisionAtAnimationPhaseBoundaries",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCompositionForegroundMarkers,
    "CompositionForegroundMarkers",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kComputedAccessibilityInfo,
    "ComputedAccessibilityInfo",
    base::FEATURE_DISABLED_BY_DEFAULT);

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kComputePressure,
    "ComputePressure",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kComputePressure,
    "ComputePressure",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kComputePressure,
    "ComputePressure",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kComputePressure,
    "ComputePressure",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kComputePressure,
    "ComputePressure",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kComputePressure,
    "ComputePressure",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kComputePressure,
    "ComputePressure",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kComputePressureOwnContributionEstimate,
    "ComputePressureOwnContributionEstimate",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kComputePressureOwnContributionEstimate,
    "ComputePressureOwnContributionEstimate",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kComputePressureOwnContributionEstimate,
    "ComputePressureOwnContributionEstimate",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kComputePressureOwnContributionEstimate,
    "ComputePressureOwnContributionEstimate",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kComputePressureOwnContributionEstimate,
    "ComputePressureOwnContributionEstimate",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kComputePressureOwnContributionEstimate,
    "ComputePressureOwnContributionEstimate",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kComputePressureOwnContributionEstimate,
    "ComputePressureOwnContributionEstimate",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif

BASE_FEATURE(kConsiderSubOrSuperScriptAncestorAlignForCaretSelection,
    "ConsiderSubOrSuperScriptAncestorAlignForCaretSelection",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kConsiderUpstreamPositionForFindingNextLine,
    "ConsiderUpstreamPositionForFindingNextLine",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kConsiderUpstreamPositionForFindingPreviousLine,
    "ConsiderUpstreamPositionForFindingPreviousLine",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kContactsManager,
    "ContactsManager",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kContactsManagerExtraProperties,
    "ContactsManagerExtraProperties",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kContainerTiming,
    "ContainerTiming",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kContainerTypeNoLayoutContainment,
    "ContainerTypeNoLayoutContainment",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kContentIndex,
    "ContentIndex",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kContextMenu,
    "ContextMenu",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kControlledFrame,
    "ControlledFrame",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCorrectTemplateFormParsing,
    "CorrectTemplateFormParsing",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCorsRFC1918,
    "CorsRFC1918",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCrashReportingStorageAPI,
    "CrashReportingStorageAPI",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCredentialManagerReport,
    "CredentialManagerReport",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSPReportHash,
    "CSPReportHash",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSAccentColorKeyword,
    "CSSAccentColorKeyword",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSAdvancedAttrFunction,
    "CSSAdvancedAttrFunction",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSAltCounter,
    "CSSAltCounter",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSAnchorScope,
    "CSSAnchorScope",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSAnchorWithTransforms,
    "CSSAnchorWithTransforms",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSAtRuleCounterStyleImageSymbols,
    "CSSAtRuleCounterStyleImageSymbols",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSAtRuleCounterStyleSpeakAsDescriptor,
    "CSSAtRuleCounterStyleSpeakAsDescriptor",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSAttrRawString,
    "CSSAttrRawString",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSBackgroundClipUnprefix,
    "CSSBackgroundClipUnprefix",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSBorderShape,
    "CSSBorderShape",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSCalcSimplificationAndSerialization,
    "CSSCalcSimplificationAndSerialization",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSCaretAnimation,
    "CSSCaretAnimation",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSCaretShape,
    "CSSCaretShape",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSCaseSensitiveSelector,
    "CSSCaseSensitiveSelector",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSChUnitSpecCompliantFallback,
    "CSSChUnitSpecCompliantFallback",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSColorContrast,
    "CSSColorContrast",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSColorTypedOM,
    "CSSColorTypedOM",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSContainerProgressNotation,
    "CSSContainerProgressNotation",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSContainerStyleQueriesRange,
    "CSSContainerStyleQueriesRange",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSCornerShape,
    "CSSCornerShape",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSCornersShorthand,
    "CSSCornersShorthand",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSCrossFade,
    "CSSCrossFade",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSCustomMedia,
    "CSSCustomMedia",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSDoNotHideVisitedColor,
    "CSSDoNotHideVisitedColor",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSDynamicRangeLimit,
    "CSSDynamicRangeLimit",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSEnumeratedCustomProperties,
    "CSSEnumeratedCustomProperties",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSExponentialFunctions,
    "CSSExponentialFunctions",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSFallbackContainerQueries,
    "CSSFallbackContainerQueries",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSFilterBrightnessNonNegativePercentage,
    "CSSFilterBrightnessNonNegativePercentage",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCssFitWidthText,
    "CssFitWidthText",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSFontSizeAdjust,
    "CSSFontSizeAdjust",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSFunctions,
    "CSSFunctions",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSGapDecoration,
    "CSSGapDecoration",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSHexAlphaColor,
    "CSSHexAlphaColor",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSIdentFunction,
    "CSSIdentFunction",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSInert,
    "CSSInert",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSInlineIfForMediaQueries,
    "CSSInlineIfForMediaQueries",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSInlineIfForStyleQueries,
    "CSSInlineIfForStyleQueries",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSInlineIfForSupportsQueries,
    "CSSInlineIfForSupportsQueries",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSInterestDelayShorthand,
    "CSSInterestDelayShorthand",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSKeyframesRuleLength,
    "CSSKeyframesRuleLength",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSLayoutAPI,
    "CSSLayoutAPI",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSLetterAndWordSpacingPercentage,
    "CSSLetterAndWordSpacingPercentage",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSLineClamp,
    "CSSLineClamp",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSLineClampLineBreakingEllipsis,
    "CSSLineClampLineBreakingEllipsis",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSMarkerNestedPseudoElement,
    "CSSMarkerNestedPseudoElement",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSMasonryLayout,
    "CSSMasonryLayout",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSMediaProgressNotation,
    "CSSMediaProgressNotation",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSMixins,
    "CSSMixins",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSNegatedFeatureless,
    "CSSNegatedFeatureless",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSNestedPseudoElements,
    "CSSNestedPseudoElements",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSPaintAPIArguments,
    "CSSPaintAPIArguments",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSParserIgnoreCharsetForURLs,
    "CSSParserIgnoreCharsetForURLs",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSPositionStickyStaticScrollPosition,
    "CSSPositionStickyStaticScrollPosition",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSPreferredTextScale,
    "CSSPreferredTextScale",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSProgressNotation,
    "CSSProgressNotation",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSPseudoColumn,
    "CSSPseudoColumn",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSPseudoElementInterface,
    "CSSPseudoElementInterface",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSPseudoHasSlotted,
    "CSSPseudoHasSlotted",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSPseudoPlayingPaused,
    "CSSPseudoPlayingPaused",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSPseudoScrollButtons,
    "CSSPseudoScrollButtons",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSPseudoScrollMarkers,
    "CSSPseudoScrollMarkers",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSReadingFlow,
    "CSSReadingFlow",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSReadingOrder,
    "CSSReadingOrder",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSRelativeColorLateResolveAlways,
    "CSSRelativeColorLateResolveAlways",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSResizeAuto,
    "CSSResizeAuto",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSSafePrintableInset,
    "CSSSafePrintableInset",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSScopeImport,
    "CSSScopeImport",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSScrollDirectionContainerQueries,
    "CSSScrollDirectionContainerQueries",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSScrollInitialTarget,
    "CSSScrollInitialTarget",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSScrollMarkerGroupModes,
    "CSSScrollMarkerGroupModes",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSScrollSnapChangeEvent,
    "CSSScrollSnapChangeEvent",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSScrollSnapChangingEvent,
    "CSSScrollSnapChangingEvent",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSScrollSnapEventConstructorExposed,
    "CSSScrollSnapEventConstructorExposed",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSScrollSnapEvents,
    "CSSScrollSnapEvents",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSScrollStart,
    "CSSScrollStart",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSScrollTargetGroup,
    "CSSScrollTargetGroup",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCssSelectorFragmentAnchor,
    "CssSelectorFragmentAnchor",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSShortCircuitVarAttr,
    "CSSShortCircuitVarAttr",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSSiblingFunctions,
    "CSSSiblingFunctions",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSSiblingFunctionsInContainerQueries,
    "CSSSiblingFunctionsInContainerQueries",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSSignRelatedFunctions,
    "CSSSignRelatedFunctions",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSSteppedValueFunctions,
    "CSSSteppedValueFunctions",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSSupportsAtRuleFunction,
    "CSSSupportsAtRuleFunction",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSSupportsForImportRules,
    "CSSSupportsForImportRules",
    base::FEATURE_ENABLED_BY_DEFAULT);

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kCSSSystemAccentColor,
    "CSSSystemAccentColor",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kCSSSystemAccentColor,
    "CSSSystemAccentColor",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kCSSSystemAccentColor,
    "CSSSystemAccentColor",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kCSSSystemAccentColor,
    "CSSSystemAccentColor",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kCSSSystemAccentColor,
    "CSSSystemAccentColor",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kCSSSystemAccentColor,
    "CSSSystemAccentColor",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kCSSSystemAccentColor,
    "CSSSystemAccentColor",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif

BASE_FEATURE(kCSSTextAutoSpace,
    "CSSTextAutoSpace",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCssTextDecorationLineBlinkSerialization,
    "CssTextDecorationLineBlinkSerialization",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSTextSpacing,
    "CSSTextSpacing",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSTransitionNoneRunningTransitionsFix,
    "CSSTransitionNoneRunningTransitionsFix",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSTreeScopedTimelines,
    "CSSTreeScopedTimelines",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSTypedArithmetic,
    "CSSTypedArithmetic",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCSSUserSelectContain,
    "CSSUserSelectContain",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSVideoDynamicRangeMediaQueries,
    "CSSVideoDynamicRangeMediaQueries",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCSSViewTransitionAutoName,
    "CSSViewTransitionAutoName",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCustomizableSelect,
    "CustomizableSelect",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kCustomizableSelectInPage,
    "CustomizableSelectInPage",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCustomizableSelectMultiplePopup,
    "CustomizableSelectMultiplePopup",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kCustomValidityNormalizeNewlines,
    "CustomValidityNormalizeNewlines",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kDatabase,
    "Database",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kDeprecateUnloadOptOut,
    "DeprecateUnloadOptOut",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kDesktopCaptureDisableLocalEchoControl,
    "DesktopCaptureDisableLocalEchoControl",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kDesktopPWAsAdditionalWindowingControls,
    "DesktopPWAsAdditionalWindowingControls",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kDesktopPWAsSubApps,
    "DesktopPWAsSubApps",
    base::FEATURE_DISABLED_BY_DEFAULT);

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kDeviceAttributes,
    "DeviceAttributes",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kDeviceAttributes,
    "DeviceAttributes",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kDeviceAttributes,
    "DeviceAttributes",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kDeviceAttributes,
    "DeviceAttributes",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kDeviceAttributes,
    "DeviceAttributes",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kDeviceAttributes,
    "DeviceAttributes",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kDeviceAttributes,
    "DeviceAttributes",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif

BASE_FEATURE(kDeviceAttributesPermissionPolicy,
    "DeviceAttributesPermissionPolicy",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kDeviceOrientationRequestPermission,
    "DeviceOrientationRequestPermission",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kDevicePosture,
    "DevicePosture",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kDialogCloseWhenOpenRemoved,
    "DialogCloseWhenOpenRemoved",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kDialogNewFocusBehavior,
    "DialogNewFocusBehavior",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kDialogSubmitShadowBoundaries,
    "DialogSubmitShadowBoundaries",
    base::FEATURE_ENABLED_BY_DEFAULT);

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kDigitalGoodsV2_1,
    "DigitalGoodsV2_1",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kDigitalGoodsV2_1,
    "DigitalGoodsV2_1",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kDigitalGoodsV2_1,
    "DigitalGoodsV2_1",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kDigitalGoodsV2_1,
    "DigitalGoodsV2_1",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kDigitalGoodsV2_1,
    "DigitalGoodsV2_1",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kDigitalGoodsV2_1,
    "DigitalGoodsV2_1",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kDigitalGoodsV2_1,
    "DigitalGoodsV2_1",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif

BASE_FEATURE(kDirectSockets,
    "DirectSockets",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kDirectSocketsInServiceWorkers,
    "DirectSocketsInServiceWorkers",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kDirectSocketsInSharedWorkers,
    "DirectSocketsInSharedWorkers",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kDispatchHiddenVisibilityTransitions,
    "DispatchHiddenVisibilityTransitions",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kDispatchSelectionchangeEventPerElement,
    "DispatchSelectionchangeEventPerElement",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kDisplayContentsFocusable,
    "DisplayContentsFocusable",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kDocumentCookie,
    "DocumentCookie",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kDocumentDomain,
    "DocumentDomain",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kDocumentOpenOriginAliasRemoval,
    "DocumentOpenOriginAliasRemoval",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kDocumentOpenSandboxInheritanceRemoval,
    "DocumentOpenSandboxInheritanceRemoval",
    base::FEATURE_ENABLED_BY_DEFAULT);

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kDocumentPatching,
    "DocumentPatching",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kDocumentPatching,
    "DocumentPatching",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kDocumentPatching,
    "DocumentPatching",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kDocumentPatching,
    "DocumentPatching",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kDocumentPatching,
    "DocumentPatching",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kDocumentPatching,
    "DocumentPatching",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kDocumentPatching,
    "DocumentPatching",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif

BASE_FEATURE(kDocumentPictureInPictureAPI,
    "DocumentPictureInPictureAPI",
    base::FEATURE_ENABLED_BY_DEFAULT);

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kDocumentPictureInPicturePreferInitialPlacement,
    "DocumentPictureInPicturePreferInitialPlacement",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kDocumentPictureInPicturePreferInitialPlacement,
    "DocumentPictureInPicturePreferInitialPlacement",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kDocumentPictureInPicturePreferInitialPlacement,
    "DocumentPictureInPicturePreferInitialPlacement",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kDocumentPictureInPicturePreferInitialPlacement,
    "DocumentPictureInPicturePreferInitialPlacement",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kDocumentPictureInPicturePreferInitialPlacement,
    "DocumentPictureInPicturePreferInitialPlacement",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kDocumentPictureInPicturePreferInitialPlacement,
    "DocumentPictureInPicturePreferInitialPlacement",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kDocumentPictureInPicturePreferInitialPlacement,
    "DocumentPictureInPicturePreferInitialPlacement",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kDocumentPictureInPictureUserActivation,
    "DocumentPictureInPictureUserActivation",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kDocumentPictureInPictureUserActivation,
    "DocumentPictureInPictureUserActivation",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kDocumentPictureInPictureUserActivation,
    "DocumentPictureInPictureUserActivation",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kDocumentPictureInPictureUserActivation,
    "DocumentPictureInPictureUserActivation",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kDocumentPictureInPictureUserActivation,
    "DocumentPictureInPictureUserActivation",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kDocumentPictureInPictureUserActivation,
    "DocumentPictureInPictureUserActivation",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kDocumentPictureInPictureUserActivation,
    "DocumentPictureInPictureUserActivation",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif

BASE_FEATURE(kDocumentPolicyDocumentDomain,
    "DocumentPolicyDocumentDomain",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kDocumentPolicyExpectNoLinkedResources,
    "DocumentPolicyExpectNoLinkedResources",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kDocumentPolicyIncludeJSCallStacksInCrashReports,
    "DocumentPolicyIncludeJSCallStacksInCrashReports",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kDocumentPolicySyncXHR,
    "DocumentPolicySyncXHR",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kDocumentWrite,
    "DocumentWrite",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kDOMPartsAPI,
    "DOMPartsAPI",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kDOMPartsAPIMinimal,
    "DOMPartsAPIMinimal",
    base::FEATURE_DISABLED_BY_DEFAULT);

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kDynamicSafeAreaInsets,
    "DynamicSafeAreaInsets",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kDynamicSafeAreaInsets,
    "DynamicSafeAreaInsets",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kDynamicSafeAreaInsets,
    "DynamicSafeAreaInsets",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kDynamicSafeAreaInsets,
    "DynamicSafeAreaInsets",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kDynamicSafeAreaInsets,
    "DynamicSafeAreaInsets",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kDynamicSafeAreaInsets,
    "DynamicSafeAreaInsets",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kDynamicSafeAreaInsets,
    "DynamicSafeAreaInsets",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kDynamicSafeAreaInsetsOnScroll,
    "DynamicSafeAreaInsetsOnScroll",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kDynamicSafeAreaInsetsOnScroll,
    "DynamicSafeAreaInsetsOnScroll",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kDynamicSafeAreaInsetsOnScroll,
    "DynamicSafeAreaInsetsOnScroll",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kDynamicSafeAreaInsetsOnScroll,
    "DynamicSafeAreaInsetsOnScroll",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kDynamicSafeAreaInsetsOnScroll,
    "DynamicSafeAreaInsetsOnScroll",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kDynamicSafeAreaInsetsOnScroll,
    "DynamicSafeAreaInsetsOnScroll",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kDynamicSafeAreaInsetsOnScroll,
    "DynamicSafeAreaInsetsOnScroll",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif

BASE_FEATURE(kEditingFastDelete,
    "EditingFastDelete",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kEditingFastRichReplace,
    "EditingFastRichReplace",
    base::FEATURE_ENABLED_BY_DEFAULT);

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kElementCapture,
    "ElementCapture",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kElementCapture,
    "ElementCapture",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kElementCapture,
    "ElementCapture",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kElementCapture,
    "ElementCapture",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kElementCapture,
    "ElementCapture",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kElementCapture,
    "ElementCapture",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kElementCapture,
    "ElementCapture",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif

BASE_FEATURE(kElementInnerTextHandleFirstLineStyle,
    "ElementInnerTextHandleFirstLineStyle",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kElementInternalsDotType,
    "ElementInternalsDotType",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kEmptyReferenceFilterInvalidation,
    "EmptyReferenceFilterInvalidation",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kEnforceAnonymityExposure,
    "EnforceAnonymityExposure",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kEnterInOpenShadowRoots,
    "EnterInOpenShadowRoots",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kEscapeLtGtInAttributes,
    "EscapeLtGtInAttributes",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kEventTimingInteractionCount,
    "EventTimingInteractionCount",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kExperimentalJSProfilerMarkers,
    "ExperimentalJSProfilerMarkers",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kExperimentalPolicies,
    "ExperimentalPolicies",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kExposeCSSFontFeatureValuesRule,
    "ExposeCSSFontFeatureValuesRule",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kExposeRenderTimeNonTaoDelayedImage,
    "ExposeRenderTimeNonTaoDelayedImage",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kExtendedTextMetrics,
    "ExtendedTextMetrics",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kExternalPopupMenuClickEvent,
    "ExternalPopupMenuClickEvent",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kFaceDetector,
    "FaceDetector",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kFastPositionIterator,
    "FastPositionIterator",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kFastSelectionSync,
    "FastSelectionSync",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kFencedFramesAPIChanges,
    "FencedFramesAPIChanges",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kFencedFramesDefaultMode,
    "FencedFramesDefaultMode",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kFetchBodyBytes,
    "FetchBodyBytes",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kFetchLaterAPI,
    "FetchLaterAPI",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kFetchRetry,
    "FetchRetry",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kFetchUploadStreaming,
    "FetchUploadStreaming",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kFileHandlingAPI,
    "FileHandlingAPI",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kFileSystemAccess,
    "FileSystemAccess",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kFileSystemAccessAPIExperimental,
    "FileSystemAccessAPIExperimental",
    base::FEATURE_DISABLED_BY_DEFAULT);

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kFileSystemAccessGetCloudIdentifiers,
    "FileSystemAccessGetCloudIdentifiers",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kFileSystemAccessGetCloudIdentifiers,
    "FileSystemAccessGetCloudIdentifiers",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kFileSystemAccessGetCloudIdentifiers,
    "FileSystemAccessGetCloudIdentifiers",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kFileSystemAccessGetCloudIdentifiers,
    "FileSystemAccessGetCloudIdentifiers",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kFileSystemAccessGetCloudIdentifiers,
    "FileSystemAccessGetCloudIdentifiers",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kFileSystemAccessGetCloudIdentifiers,
    "FileSystemAccessGetCloudIdentifiers",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kFileSystemAccessGetCloudIdentifiers,
    "FileSystemAccessGetCloudIdentifiers",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kFileSystemAccessLocal,
    "FileSystemAccessLocal",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kFileSystemAccessLocal,
    "FileSystemAccessLocal",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kFileSystemAccessLocal,
    "FileSystemAccessLocal",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kFileSystemAccessLocal,
    "FileSystemAccessLocal",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kFileSystemAccessLocal,
    "FileSystemAccessLocal",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kFileSystemAccessLocal,
    "FileSystemAccessLocal",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kFileSystemAccessLocal,
    "FileSystemAccessLocal",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif

BASE_FEATURE(kFileSystemAccessLockingScheme,
    "FileSystemAccessLockingScheme",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kFileSystemAccessOriginPrivate,
    "FileSystemAccessOriginPrivate",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kFileSystemAccessWriteMode,
    "FileSystemAccessWriteMode",
    base::FEATURE_DISABLED_BY_DEFAULT);

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kFileSystemObserver,
    "FileSystemObserver",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kFileSystemObserver,
    "FileSystemObserver",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kFileSystemObserver,
    "FileSystemObserver",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kFileSystemObserver,
    "FileSystemObserver",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kFileSystemObserver,
    "FileSystemObserver",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kFileSystemObserver,
    "FileSystemObserver",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kFileSystemObserver,
    "FileSystemObserver",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif

BASE_FEATURE(kFileSystemObserverUnobserve,
    "FileSystemObserverUnobserve",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kFindFirstMisspellingEndWhenNonEditable,
    "FindFirstMisspellingEndWhenNonEditable",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kFixNextPositionCalculationInInsertList,
    "FixNextPositionCalculationInInsertList",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kFledgeAuctionDealSupport,
    "FledgeAuctionDealSupport",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kFledgeBiddingAndAuctionServerAPIMultiSeller,
    "FledgeBiddingAndAuctionServerAPIMultiSeller",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kFledgeClickiness,
    "FledgeClickiness",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kFledgeCustomMaxAuctionAdComponents,
    "FledgeCustomMaxAuctionAdComponents",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kFledgeDeprecatedRenderURLReplacements,
    "FledgeDeprecatedRenderURLReplacements",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kFledgeDirectFromSellerSignalsHeaderAdSlot,
    "FledgeDirectFromSellerSignalsHeaderAdSlot",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kFledgeDirectFromSellerSignalsWebBundles,
    "FledgeDirectFromSellerSignalsWebBundles",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kFledgeMultiBid,
    "FledgeMultiBid",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kFledgePrivateModelTraining,
    "FledgePrivateModelTraining",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kFledgeRealTimeReporting,
    "FledgeRealTimeReporting",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kFledgeSellerNonce,
    "FledgeSellerNonce",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kFledgeSellerScriptExecutionMode,
    "FledgeSellerScriptExecutionMode",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kFledgeTrustedSignalsKVv1CreativeScanning,
    "FledgeTrustedSignalsKVv1CreativeScanning",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kFledgeTrustedSignalsKVv2ContextualData,
    "FledgeTrustedSignalsKVv2ContextualData",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kFledgeTrustedSignalsKVv2Support,
    "FledgeTrustedSignalsKVv2Support",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kFlexWrapBalance,
    "FlexWrapBalance",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kFlowThreadLess,
    "FlowThreadLess",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kFontAccess,
    "FontAccess",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kFontFamilyPostscriptMatchingCTMigration,
    "FontFamilyPostscriptMatchingCTMigration",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kFontFamilyStyleMatchingCTMigration,
    "FontFamilyStyleMatchingCTMigration",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kFontFeatureSettingsDescriptor,
    "FontFeatureSettingsDescriptor",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kFontMatchAliasesAsLastResort,
    "FontMatchAliasesAsLastResort",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kFontPresentWin,
    "FontPresentWin",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kFontStyleObliqueZeroDegreeAsNormal,
    "FontStyleObliqueZeroDegreeAsNormal",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kFontSystemFallbackNotoCjk,
    "FontSystemFallbackNotoCjk",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kFontVariationSettingsDescriptor,
    "FontVariationSettingsDescriptor",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kForceEagerMeasureMemory,
    "ForceEagerMeasureMemory",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kForceReduceMotion,
    "ForceReduceMotion",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kFormControlRange,
    "FormControlRange",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kFormControlRestoreStateIfAutocompleteOff,
    "FormControlRestoreStateIfAutocompleteOff",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kFreezeFramesOnVisibility,
    "FreezeFramesOnVisibility",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kGamepadMultitouch,
    "GamepadMultitouch",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kGeolocationElement,
    "GeolocationElement",
    base::FEATURE_DISABLED_BY_DEFAULT);

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kGetAllScreensMedia,
    "GetAllScreensMedia",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kGetAllScreensMedia,
    "GetAllScreensMedia",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kGetAllScreensMedia,
    "GetAllScreensMedia",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kGetAllScreensMedia,
    "GetAllScreensMedia",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kGetAllScreensMedia,
    "GetAllScreensMedia",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kGetAllScreensMedia,
    "GetAllScreensMedia",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kGetAllScreensMedia,
    "GetAllScreensMedia",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif

BASE_FEATURE(kGetComputedStyleOutsideFlatTree,
    "GetComputedStyleOutsideFlatTree",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kGetDisplayMediaRequiresUserActivation,
    "GetDisplayMediaRequiresUserActivation",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kGetDisplayMediaWindowAudioCapture,
    "GetDisplayMediaWindowAudioCapture",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kGetUserMediaEchoCancellationModes,
    "GetUserMediaEchoCancellationModes",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kGroupEffect,
    "GroupEffect",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kHandleDeletionAtStartAndEndBoundaryContainingHiddenElement,
    "HandleDeletionAtStartAndEndBoundaryContainingHiddenElement",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kHandleShadowDOMInSubstringUtil,
    "HandleShadowDOMInSubstringUtil",
    base::FEATURE_ENABLED_BY_DEFAULT);

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kHandwritingRecognition,
    "HandwritingRecognition",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kHandwritingRecognition,
    "HandwritingRecognition",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kHandwritingRecognition,
    "HandwritingRecognition",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kHandwritingRecognition,
    "HandwritingRecognition",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kHandwritingRecognition,
    "HandwritingRecognition",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kHandwritingRecognition,
    "HandwritingRecognition",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kHandwritingRecognition,
    "HandwritingRecognition",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif

BASE_FEATURE(kHasUAVisualTransition,
    "HasUAVisualTransition",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kHeadingOffset,
    "HeadingOffset",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kHighlightPointerEvents,
    "HighlightPointerEvents",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kHighlightsFromPoint,
    "HighlightsFromPoint",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kHrElementGray,
    "HrElementGray",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kHTMLAnchorAttribute,
    "HTMLAnchorAttribute",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kHTMLCommandActionsV2,
    "HTMLCommandActionsV2",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kHTMLCommandRequestClose,
    "HTMLCommandRequestClose",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kHTMLElementScrollParent,
    "HTMLElementScrollParent",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kHTMLEmbedElementNotForceLayout,
    "HTMLEmbedElementNotForceLayout",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kHTMLImageElementActualNaturalSize,
    "HTMLImageElementActualNaturalSize",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kHTMLInterestForAttribute,
    "HTMLInterestForAttribute",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kHTMLLinkElementAttributeValueChanges,
    "HTMLLinkElementAttributeValueChanges",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kHTMLParserYieldAndDelayOftenForTesting,
    "HTMLParserYieldAndDelayOftenForTesting",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kHTMLParserYieldByUserTiming,
    "HTMLParserYieldByUserTiming",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kHTMLPrintingArtifactAnnotations,
    "HTMLPrintingArtifactAnnotations",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kICUCapitalization,
    "ICUCapitalization",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kIgnoreLetterSpacingInCursiveScripts,
    "IgnoreLetterSpacingInCursiveScripts",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kIgnoreOutOfFlowPositionForPreviousText,
    "IgnoreOutOfFlowPositionForPreviousText",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kImageDataPixelFormat,
    "ImageDataPixelFormat",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kImportAttributesDisallowUnknownKeys,
    "ImportAttributesDisallowUnknownKeys",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kImprovedSourceRetargeting,
    "ImprovedSourceRetargeting",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kIncludeTransformsForLayerXandLayerY,
    "IncludeTransformsForLayerXandLayerY",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kIncomingCallNotifications,
    "IncomingCallNotifications",
    base::FEATURE_DISABLED_BY_DEFAULT);

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kIncrementLocalSurfaceIdForMainframeSameDocNavigation,
    "IncrementLocalSurfaceIdForMainframeSameDocNavigation",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kIncrementLocalSurfaceIdForMainframeSameDocNavigation,
    "IncrementLocalSurfaceIdForMainframeSameDocNavigation",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kIncrementLocalSurfaceIdForMainframeSameDocNavigation,
    "IncrementLocalSurfaceIdForMainframeSameDocNavigation",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kIncrementLocalSurfaceIdForMainframeSameDocNavigation,
    "IncrementLocalSurfaceIdForMainframeSameDocNavigation",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kIncrementLocalSurfaceIdForMainframeSameDocNavigation,
    "IncrementLocalSurfaceIdForMainframeSameDocNavigation",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kIncrementLocalSurfaceIdForMainframeSameDocNavigation,
    "IncrementLocalSurfaceIdForMainframeSameDocNavigation",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kIncrementLocalSurfaceIdForMainframeSameDocNavigation,
    "IncrementLocalSurfaceIdForMainframeSameDocNavigation",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif

BASE_FEATURE(kIndexedDbGetAllRecords,
    "IndexedDbGetAllRecords",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kInertElementNonEditable,
    "InertElementNonEditable",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kInfiniteCullRect,
    "InfiniteCullRect",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kInheritUserModifyWithoutContenteditable,
    "InheritUserModifyWithoutContenteditable",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kInitialLetterRaiseBySpecified,
    "InitialLetterRaiseBySpecified",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kInlineBlockInSameLine,
    "InlineBlockInSameLine",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kInnerHTMLParserFastpathLogFailure,
    "InnerHTMLParserFastpathLogFailure",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kInputInSelect,
    "InputInSelect",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kInputMultipleFieldsUI,
    "InputMultipleFieldsUI",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kInsertBlockquoteBeforeOuterBlock,
    "InsertBlockquoteBeforeOuterBlock",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kInsertLineBreakIfInlineListItem,
    "InsertLineBreakIfInlineListItem",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kInsertLineBreakIfPhrasingContent,
    "InsertLineBreakIfPhrasingContent",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kInspectorGhostRules,
    "InspectorGhostRules",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kInstallOnDeviceSpeechRecognition,
    "InstallOnDeviceSpeechRecognition",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kInterestGroupsInSharedStorageWorklet,
    "InterestGroupsInSharedStorageWorklet",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kInteroperablePrivateAttribution,
    "InteroperablePrivateAttribution",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kIntersectionObserverScrollMargin,
    "IntersectionObserverScrollMargin",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kInvertedColors,
    "InvertedColors",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kInvisibleSVGAnimationThrottling,
    "InvisibleSVGAnimationThrottling",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kJavaScriptCompileHintsPerFunctionMagicRuntime,
    "JavaScriptCompileHintsPerFunctionMagicRuntime",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kJavaScriptSourcePhaseImports,
    "JavaScriptSourcePhaseImports",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kLangAttributeAwareFormControlUI,
    "LangAttributeAwareFormControlUI",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kLanguageDetectionAPI,
    "LanguageDetectionAPI",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kLanguageDetectionAPIForWorkers,
    "LanguageDetectionAPIForWorkers",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kLayoutAddChildBeforeDescendantFix,
    "LayoutAddChildBeforeDescendantFix",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kLayoutBoxVisualLocation,
    "LayoutBoxVisualLocation",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kLayoutFlexNewRowAlgorithm,
    "LayoutFlexNewRowAlgorithm",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kLayoutIgnoreMarginsForSticky,
    "LayoutIgnoreMarginsForSticky",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kLayoutMinSizeAutoIndefinite,
    "LayoutMinSizeAutoIndefinite",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kLayoutNewReplacedLogic,
    "LayoutNewReplacedLogic",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kLayoutNGShapeCache,
    "LayoutNGShapeCache",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kLayoutStretch,
    "LayoutStretch",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kLayoutStretchCacheFix,
    "LayoutStretchCacheFix",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kLineBreakOofNoOrc,
    "LineBreakOofNoOrc",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kListItemWithCounterSetNotSetExplicitValue,
    "ListItemWithCounterSetNotSetExplicitValue",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kListOwnerMustHaveCSSBox,
    "ListOwnerMustHaveCSSBox",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kListStylePositionQuirkStandard,
    "ListStylePositionQuirkStandard",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kLockedMode,
    "LockedMode",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kLongAnimationFrameSourceCharPosition,
    "LongAnimationFrameSourceCharPosition",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kLongAnimationFrameSourceLineColumn,
    "LongAnimationFrameSourceLineColumn",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kLongAnimationFrameSourceLineColumnInterface,
    "LongAnimationFrameSourceLineColumnInterface",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kLongPressLinkSelectText,
    "LongPressLinkSelectText",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kLongTaskFromLongAnimationFrame,
    "LongTaskFromLongAnimationFrame",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kMacCharacterFallbackCache,
    "MacCharacterFallbackCache",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kMacDisableCtrlHomeEnd,
    "MacDisableCtrlHomeEnd",
    base::FEATURE_ENABLED_BY_DEFAULT);

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kMacSystemClipboardPermissionCheck,
    "MacSystemClipboardPermissionCheck",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kMacSystemClipboardPermissionCheck,
    "MacSystemClipboardPermissionCheck",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kMacSystemClipboardPermissionCheck,
    "MacSystemClipboardPermissionCheck",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kMacSystemClipboardPermissionCheck,
    "MacSystemClipboardPermissionCheck",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kMacSystemClipboardPermissionCheck,
    "MacSystemClipboardPermissionCheck",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kMacSystemClipboardPermissionCheck,
    "MacSystemClipboardPermissionCheck",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kMacSystemClipboardPermissionCheck,
    "MacSystemClipboardPermissionCheck",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif

BASE_FEATURE(kManagedConfiguration,
    "ManagedConfiguration",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kMaskDeserializationTimeForCrossOriginMessages,
    "MaskDeserializationTimeForCrossOriginMessages",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kMathMLOperatorRTLMirroring,
    "MathMLOperatorRTLMirroring",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kMathMLSerializationOnCopy,
    "MathMLSerializationOnCopy",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kMeasureMemory,
    "MeasureMemory",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kMediaCapabilitiesEncodingInfo,
    "MediaCapabilitiesEncodingInfo",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kMediaCapabilitiesSpatialAudio,
    "MediaCapabilitiesSpatialAudio",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kMediaCapture,
    "MediaCapture",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kMediaCaptureCameraControls,
    "MediaCaptureCameraControls",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kMediaCaptureVoiceIsolation,
    "MediaCaptureVoiceIsolation",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kMediaElementVolumeGreaterThanOne,
    "MediaElementVolumeGreaterThanOne",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kMediaLatencyHint,
    "MediaLatencyHint",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kMediaPlaybackWhileNotVisiblePermissionPolicy,
    "MediaPlaybackWhileNotVisiblePermissionPolicy",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kMediaQueryNavigationControls,
    "MediaQueryNavigationControls",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kMediaSessionChapterInformation,
    "MediaSessionChapterInformation",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kMediaSessionEnterPictureInPicture,
    "MediaSessionEnterPictureInPicture",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kMediaSourceExperimental,
    "MediaSourceExperimental",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kMediaSourceNewAbortAndDuration,
    "MediaSourceNewAbortAndDuration",
    base::FEATURE_ENABLED_BY_DEFAULT);

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kMediaStreamTrackWebSpeech,
    "MediaStreamTrackWebSpeech",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kMediaStreamTrackWebSpeech,
    "MediaStreamTrackWebSpeech",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kMediaStreamTrackWebSpeech,
    "MediaStreamTrackWebSpeech",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kMediaStreamTrackWebSpeech,
    "MediaStreamTrackWebSpeech",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kMediaStreamTrackWebSpeech,
    "MediaStreamTrackWebSpeech",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kMediaStreamTrackWebSpeech,
    "MediaStreamTrackWebSpeech",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kMediaStreamTrackWebSpeech,
    "MediaStreamTrackWebSpeech",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif

BASE_FEATURE(kMenuElements,
    "MenuElements",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kMessagePortCloseEvent,
    "MessagePortCloseEvent",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kMetaRefreshNoFractional,
    "MetaRefreshNoFractional",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kMiddleClickAutoscroll,
    "MiddleClickAutoscroll",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kMixedContentAutoupgradesUseIsMixedContentRestrictedInFrame,
    "MixedContentAutoupgradesUseIsMixedContentRestrictedInFrame",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kMobileLayoutTheme,
    "MobileLayoutTheme",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kModifyParagraphCrossEditingoundary,
    "ModifyParagraphCrossEditingoundary",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kMojoJS,
    "MojoJS",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kMoveEndingSelectionToListChild,
    "MoveEndingSelectionToListChild",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kMoveToParagraphStartOrEndSkipsNonEditable,
    "MoveToParagraphStartOrEndSkipsNonEditable",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kMulticolColumnWrapping,
    "MulticolColumnWrapping",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kNavigateEventCanTransition,
    "NavigateEventCanTransition",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kNavigateEventCommitBehavior,
    "NavigateEventCommitBehavior",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kNavigateEventPopstateLimitations,
    "NavigateEventPopstateLimitations",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kNavigateEventSourceElement,
    "NavigateEventSourceElement",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kNavigationId,
    "NavigationId",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kNavigatorContentUtils,
    "NavigatorContentUtils",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kNestedViewTransition,
    "NestedViewTransition",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kNetInfoConstantType,
    "NetInfoConstantType",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kNewGetFocusableAreaBehavior,
    "NewGetFocusableAreaBehavior",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kNoFontAntialiasing,
    "NoFontAntialiasing",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kNoIdleEncodingForWebTests,
    "NoIdleEncodingForWebTests",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kNoIncreasingEndOffsetOnSplittingTextNodes,
    "NoIncreasingEndOffsetOnSplittingTextNodes",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kNonEmptyBlockquotesOnOutdenting,
    "NonEmptyBlockquotesOnOutdenting",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kNonStandardAppearanceValueSliderVertical,
    "NonStandardAppearanceValueSliderVertical",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kNotificationConstructor,
    "NotificationConstructor",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kNumberInputFullWidthChars,
    "NumberInputFullWidthChars",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kOffMainThreadCSSPaint,
    "OffMainThreadCSSPaint",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kOffscreenCanvasGetContextAttributes,
    "OffscreenCanvasGetContextAttributes",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kOffsetParentNewSpecBehaviorForFixedPosition,
    "OffsetParentNewSpecBehaviorForFixedPosition",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kOmitBlurEventOnElementRemoval,
    "OmitBlurEventOnElementRemoval",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kOnDeviceWebSpeechAvailable,
    "OnDeviceWebSpeechAvailable",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kOptionLabelAttributeWhitespace,
    "OptionLabelAttributeWhitespace",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kOrientationEvent,
    "OrientationEvent",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kOriginAPI,
    "OriginAPI",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kOriginPolicy,
    "OriginPolicy",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kOverscrollCustomization,
    "OverscrollCustomization",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kPagePopup,
    "PagePopup",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kPageRevealEvent,
    "PageRevealEvent",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kPageSwapEvent,
    "PageSwapEvent",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kPaintHighlightsForFirstLetter,
    "PaintHighlightsForFirstLetter",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kPaintHoldingForIframes,
    "PaintHoldingForIframes",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kPaintTimingMixin,
    "PaintTimingMixin",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kPaintUnderInvalidationChecking,
    "PaintUnderInvalidationChecking",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kParakeet,
    "Parakeet",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kParseDateUsesBaseTimeFromUtcString,
    "ParseDateUsesBaseTimeFromUtcString",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kPartialCompletionNotAllowedInMoveParagraphs,
    "PartialCompletionNotAllowedInMoveParagraphs",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kPartitionedPopins,
    "PartitionedPopins",
    base::FEATURE_DISABLED_BY_DEFAULT);

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kPartitionVisitedLinkDatabaseWithSelfLinks,
    "PartitionVisitedLinkDatabaseWithSelfLinks",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kPartitionVisitedLinkDatabaseWithSelfLinks,
    "PartitionVisitedLinkDatabaseWithSelfLinks",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kPartitionVisitedLinkDatabaseWithSelfLinks,
    "PartitionVisitedLinkDatabaseWithSelfLinks",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kPartitionVisitedLinkDatabaseWithSelfLinks,
    "PartitionVisitedLinkDatabaseWithSelfLinks",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kPartitionVisitedLinkDatabaseWithSelfLinks,
    "PartitionVisitedLinkDatabaseWithSelfLinks",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kPartitionVisitedLinkDatabaseWithSelfLinks,
    "PartitionVisitedLinkDatabaseWithSelfLinks",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kPartitionVisitedLinkDatabaseWithSelfLinks,
    "PartitionVisitedLinkDatabaseWithSelfLinks",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif

BASE_FEATURE(kPasswordReveal,
    "PasswordReveal",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kPaymentLinkDetection,
    "PaymentLinkDetection",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kPaymentMethodChangeEvent,
    "PaymentMethodChangeEvent",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kPerformanceMarkFeatureUsage,
    "PerformanceMarkFeatureUsage",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kPerformanceNavigateSystemEntropy,
    "PerformanceNavigateSystemEntropy",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kPerformanceNavigationTimingConfidence,
    "PerformanceNavigationTimingConfidence",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kPermissionElement,
    "PermissionElement",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kPermissionElementIcon,
    "PermissionElementIcon",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kPermissionsRequestRevoke,
    "PermissionsRequestRevoke",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kPlaceholderVisibility,
    "PlaceholderVisibility",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kPointerEventDeviceId,
    "PointerEventDeviceId",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kPointerLockOnAndroid,
    "PointerLockOnAndroid",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kPositionOutsideTabSpanCheckSiblingNode,
    "PositionOutsideTabSpanCheckSiblingNode",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kPotentialPermissionsPolicyReporting,
    "PotentialPermissionsPolicyReporting",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kPreferDefaultScrollbarStyles,
    "PreferDefaultScrollbarStyles",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kPreferNonCompositedScrolling,
    "PreferNonCompositedScrolling",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kPreferredAudioOutputDevices,
    "PreferredAudioOutputDevices",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kPrefersReducedData,
    "PrefersReducedData",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kPreloadLinkRelDataUrls,
    "PreloadLinkRelDataUrls",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kPrerender2,
    "Prerender2",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kPrerenderUntilScript,
    "PrerenderUntilScript",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kPreventUndoIfNotEditable,
    "PreventUndoIfNotEditable",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kPrivateAggregationApiErrorReporting,
    "PrivateAggregationApiErrorReporting",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kPrivateAggregationApiMaxContributions,
    "PrivateAggregationApiMaxContributions",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kProgrammaticScrollPromise,
    "ProgrammaticScrollPromise",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kPropagateOverscrollBehaviorFromRoot,
    "PropagateOverscrollBehaviorFromRoot",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kPseudoElementsFocusable,
    "PseudoElementsFocusable",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kQuotaExceededErrorUpdate,
    "QuotaExceededErrorUpdate",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kQuoteFirstLineStyle,
    "QuoteFirstLineStyle",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kRadioInputNextKeyboardFocusable,
    "RadioInputNextKeyboardFocusable",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kRadioKeyboardFocusableOptimize,
    "RadioKeyboardFocusableOptimize",
    base::FEATURE_ENABLED_BY_DEFAULT);

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kRasterInducingScroll,
    "RasterInducingScroll",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kRasterInducingScroll,
    "RasterInducingScroll",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kRasterInducingScroll,
    "RasterInducingScroll",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kRasterInducingScroll,
    "RasterInducingScroll",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kRasterInducingScroll,
    "RasterInducingScroll",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kRasterInducingScroll,
    "RasterInducingScroll",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kRasterInducingScroll,
    "RasterInducingScroll",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif

BASE_FEATURE(kReadableStreamBYOBReaderReadMinOption,
    "ReadableStreamBYOBReaderReadMinOption",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kReduceHardwareConcurrency,
    "ReduceHardwareConcurrency",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kReduceScreenSize,
    "ReduceScreenSize",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kReduceUserAgentAndroidVersionDeviceModel,
    "ReduceUserAgentAndroidVersionDeviceModel",
    base::FEATURE_DISABLED_BY_DEFAULT);

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kReduceUserAgentDataLinuxPlatformVersion,
    "ReduceUserAgentDataLinuxPlatformVersion",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kReduceUserAgentDataLinuxPlatformVersion,
    "ReduceUserAgentDataLinuxPlatformVersion",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kReduceUserAgentDataLinuxPlatformVersion,
    "ReduceUserAgentDataLinuxPlatformVersion",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kReduceUserAgentDataLinuxPlatformVersion,
    "ReduceUserAgentDataLinuxPlatformVersion",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kReduceUserAgentDataLinuxPlatformVersion,
    "ReduceUserAgentDataLinuxPlatformVersion",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kReduceUserAgentDataLinuxPlatformVersion,
    "ReduceUserAgentDataLinuxPlatformVersion",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kReduceUserAgentDataLinuxPlatformVersion,
    "ReduceUserAgentDataLinuxPlatformVersion",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif

BASE_FEATURE(kReduceUserAgentMinorVersion,
    "ReduceUserAgentMinorVersion",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kReduceUserAgentPlatformOsCpu,
    "ReduceUserAgentPlatformOsCpu",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kRegionCapture,
    "RegionCapture",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kRelaxDOMValidNames,
    "RelaxDOMValidNames",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kRelOpenerBcgDependencyHint,
    "RelOpenerBcgDependencyHint",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kRemotePlaybackBackend,
    "RemotePlaybackBackend",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kRemoveCharsetAutoDetectionForISO2022JP,
    "RemoveCharsetAutoDetectionForISO2022JP",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kRemoveDanglingMarkupInTarget,
    "RemoveDanglingMarkupInTarget",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kRemoveDataUrlInSvgUse,
    "RemoveDataUrlInSvgUse",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kRemoveNodeDetermineNodeFullySelected,
    "RemoveNodeDetermineNodeFullySelected",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kRemoveSelectionCanonicalizationInMoveParagraph,
    "RemoveSelectionCanonicalizationInMoveParagraph",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kRemoveVisibleSelectionInDOMSelection,
    "RemoveVisibleSelectionInDOMSelection",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kRenderBlockingFullFrameRate,
    "RenderBlockingFullFrameRate",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kRenderBlockingStatus,
    "RenderBlockingStatus",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kRenderPriorityAttribute,
    "RenderPriorityAttribute",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kRenderSurfaceFor2DScaleTransform,
    "RenderSurfaceFor2DScaleTransform",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kReportFirstFrameTimeAsRenderTime,
    "ReportFirstFrameTimeAsRenderTime",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kRequestMainFrameAfterFirstVideoFrame,
    "RequestMainFrameAfterFirstVideoFrame",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kResolveVarStylesOnCopy,
    "ResolveVarStylesOnCopy",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kResourceTimingContentEncoding,
    "ResourceTimingContentEncoding",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kResourceTimingContentType,
    "ResourceTimingContentType",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kResourceTimingInitiator,
    "ResourceTimingInitiator",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kResourceTimingUseCORSForBodySizes,
    "ResourceTimingUseCORSForBodySizes",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kResponsiveIframes,
    "ResponsiveIframes",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kRestrictOwnAudio,
    "RestrictOwnAudio",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kRestrictTabFocusForHiddenSVGElements,
    "RestrictTabFocusForHiddenSVGElements",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kRetargetDragEvents,
    "RetargetDragEvents",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kRevealSelectionInIframe,
    "RevealSelectionInIframe",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kRewindFloats,
    "RewindFloats",
    base::FEATURE_ENABLED_BY_DEFAULT);

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kRootScrollbarFollowsBrowserTheme,
    "RootScrollbarFollowsBrowserTheme",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kRootScrollbarFollowsBrowserTheme,
    "RootScrollbarFollowsBrowserTheme",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kRootScrollbarFollowsBrowserTheme,
    "RootScrollbarFollowsBrowserTheme",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kRootScrollbarFollowsBrowserTheme,
    "RootScrollbarFollowsBrowserTheme",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kRootScrollbarFollowsBrowserTheme,
    "RootScrollbarFollowsBrowserTheme",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kRootScrollbarFollowsBrowserTheme,
    "RootScrollbarFollowsBrowserTheme",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kRootScrollbarFollowsBrowserTheme,
    "RootScrollbarFollowsBrowserTheme",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif

BASE_FEATURE(kRTCDataChannelPriority,
    "RTCDataChannelPriority",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kRTCEncodedFrameAudioLevel,
    "RTCEncodedFrameAudioLevel",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kRTCEncodedFrameSetMetadata,
    "RTCEncodedFrameSetMetadata",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kRTCEncodedFrameTimestamps,
    "RTCEncodedFrameTimestamps",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kRTCEncodedVideoFrameAdditionalMetadata,
    "RTCEncodedVideoFrameAdditionalMetadata",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kRTCJitterBufferTarget,
    "RTCJitterBufferTarget",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kRTCRtpEncodingParametersCodec,
    "RTCRtpEncodingParametersCodec",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kRTCRtpScaleResolutionDownTo,
    "RTCRtpScaleResolutionDownTo",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kRTCRtpScriptTransform,
    "RTCRtpScriptTransform",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kRTCRtpTransport,
    "RTCRtpTransport",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kRTCSvcScalabilityMode,
    "RTCSvcScalabilityMode",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kRubyShortHeuristics,
    "RubyShortHeuristics",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kSanitizerAPI,
    "SanitizerAPI",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kSchedulerYieldDisallowCrossFrameInheritance,
    "SchedulerYieldDisallowCrossFrameInheritance",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kScopedCustomElementRegistry,
    "ScopedCustomElementRegistry",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kScopedViewTransitions,
    "ScopedViewTransitions",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kScreenDetailedHdrHeadroom,
    "ScreenDetailedHdrHeadroom",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kScriptRunIteratorCombiningMarkAlways,
    "ScriptRunIteratorCombiningMarkAlways",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kScriptRunIteratorCombiningMarks,
    "ScriptRunIteratorCombiningMarks",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kScriptTools,
    "ScriptTools",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kScrollAnchorPriorityCandidateSubtree,
    "ScrollAnchorPriorityCandidateSubtree",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kScrollbarColor,
    "ScrollbarColor",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kScrollbarWidth,
    "ScrollbarWidth",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kScrollIntoViewNearest,
    "ScrollIntoViewNearest",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kScrollIntoViewRootFrameViewportBugFix,
    "ScrollIntoViewRootFrameViewportBugFix",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kScrollIntoViewSelfScrollFix,
    "ScrollIntoViewSelfScrollFix",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kScrollTimelineCurrentTime,
    "ScrollTimelineCurrentTime",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kScrollTimelineNamedRangeScroll,
    "ScrollTimelineNamedRangeScroll",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kScrollTopLeftInterop,
    "ScrollTopLeftInterop",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kSearchTextHighlightPseudo,
    "SearchTextHighlightPseudo",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kSecurePaymentConfirmationAvailabilityAPI,
    "SecurePaymentConfirmationAvailabilityAPI",
    base::FEATURE_ENABLED_BY_DEFAULT);

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kSecurePaymentConfirmationBrowserBoundKeys,
    "SecurePaymentConfirmationBrowserBoundKeys",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kSecurePaymentConfirmationBrowserBoundKeys,
    "SecurePaymentConfirmationBrowserBoundKeys",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kSecurePaymentConfirmationBrowserBoundKeys,
    "SecurePaymentConfirmationBrowserBoundKeys",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kSecurePaymentConfirmationBrowserBoundKeys,
    "SecurePaymentConfirmationBrowserBoundKeys",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kSecurePaymentConfirmationBrowserBoundKeys,
    "SecurePaymentConfirmationBrowserBoundKeys",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kSecurePaymentConfirmationBrowserBoundKeys,
    "SecurePaymentConfirmationBrowserBoundKeys",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kSecurePaymentConfirmationBrowserBoundKeys,
    "SecurePaymentConfirmationBrowserBoundKeys",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kSecurePaymentConfirmationUxRefresh,
    "SecurePaymentConfirmationUxRefresh",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kSecurePaymentConfirmationUxRefresh,
    "SecurePaymentConfirmationUxRefresh",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kSecurePaymentConfirmationUxRefresh,
    "SecurePaymentConfirmationUxRefresh",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kSecurePaymentConfirmationUxRefresh,
    "SecurePaymentConfirmationUxRefresh",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kSecurePaymentConfirmationUxRefresh,
    "SecurePaymentConfirmationUxRefresh",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kSecurePaymentConfirmationUxRefresh,
    "SecurePaymentConfirmationUxRefresh",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kSecurePaymentConfirmationUxRefresh,
    "SecurePaymentConfirmationUxRefresh",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif

BASE_FEATURE(kSelectAccessibilityNestedInput,
    "SelectAccessibilityNestedInput",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kSelectAccessibilityReparentInput,
    "SelectAccessibilityReparentInput",
    base::FEATURE_DISABLED_BY_DEFAULT);

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kSelectAudioOutput,
    "SelectAudioOutput",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kSelectAudioOutput,
    "SelectAudioOutput",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kSelectAudioOutput,
    "SelectAudioOutput",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kSelectAudioOutput,
    "SelectAudioOutput",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kSelectAudioOutput,
    "SelectAudioOutput",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kSelectAudioOutput,
    "SelectAudioOutput",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kSelectAudioOutput,
    "SelectAudioOutput",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif

BASE_FEATURE(kSelectedcontentelementAttribute,
    "SelectedcontentelementAttribute",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kSelectionAcrossShadowDOM,
    "SelectionAcrossShadowDOM",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kSelectionAndFocusedVisiblePositionMatch,
    "SelectionAndFocusedVisiblePositionMatch",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kSelectionDeleteFromDocumentUaShadowFix,
    "SelectionDeleteFromDocumentUaShadowFix",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kSelectionUpdateToInitialSelectionInListify,
    "SelectionUpdateToInitialSelectionInListify",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kSelectivePermissionsIntervention,
    "SelectivePermissionsIntervention",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kSelectNoMouseUpForKeyboardSelection,
    "SelectNoMouseUpForKeyboardSelection",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kSelectParserRelaxation,
    "SelectParserRelaxation",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kSelectParserRelaxationOptOut,
    "SelectParserRelaxationOptOut",
    base::FEATURE_DISABLED_BY_DEFAULT);

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kWebSerialAPI,
    "WebSerialAPI",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kWebSerialAPI,
    "WebSerialAPI",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kWebSerialAPI,
    "WebSerialAPI",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kWebSerialAPI,
    "WebSerialAPI",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kWebSerialAPI,
    "WebSerialAPI",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kWebSerialAPI,
    "WebSerialAPI",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kWebSerialAPI,
    "WebSerialAPI",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif

BASE_FEATURE(kSerializeViewTransitionStateInSPA,
    "SerializeViewTransitionStateInSPA",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kServiceWorkerBackgroundSyncInDedicatedWorker,
    "ServiceWorkerBackgroundSyncInDedicatedWorker",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kServiceWorkerClientLifecycleState,
    "ServiceWorkerClientLifecycleState",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kServiceWorkerInDedicatedWorker,
    "ServiceWorkerInDedicatedWorker",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kServiceWorkerStaticRouterTimingInfo,
    "ServiceWorkerStaticRouterTimingInfo",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kSetSequentialFocusStartingPoint,
    "SetSequentialFocusStartingPoint",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kShadowRootReferenceTarget,
    "ShadowRootReferenceTarget",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kShadowRootReferenceTargetAriaOwns,
    "ShadowRootReferenceTargetAriaOwns",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kShapeResultCachedPreviousSafeToBreakOffset,
    "ShapeResultCachedPreviousSafeToBreakOffset",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kSharedStorageWebLocks,
    "SharedStorageWebLocks",
    base::FEATURE_ENABLED_BY_DEFAULT);

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kSharedWorker,
    "SharedWorker",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kSharedWorker,
    "SharedWorker",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kSharedWorker,
    "SharedWorker",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kSharedWorker,
    "SharedWorker",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kSharedWorker,
    "SharedWorker",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kSharedWorker,
    "SharedWorker",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kSharedWorker,
    "SharedWorker",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif

BASE_FEATURE(kSharedWorkerExtendedLifetime,
    "SharedWorkerExtendedLifetime",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kSignatureBasedInlineIntegrity,
    "SignatureBasedInlineIntegrity",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kSignatureBasedIntegrity,
    "SignatureBasedIntegrity",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kSkipAd,
    "SkipAd",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kSkipCallbacksWhenDevToolsNotOpen,
    "SkipCallbacksWhenDevToolsNotOpen",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kSkipLineBreakItemWhenIsCollapsed,
    "SkipLineBreakItemWhenIsCollapsed",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kSkipOofItemForBreakCandidate,
    "SkipOofItemForBreakCandidate",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kSkipTouchEventFilter,
    "SkipTouchEventFilter",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kSkipUnselectableContentInSerialization,
    "SkipUnselectableContentInSerialization",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kSmartCard,
    "SmartCard",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kSmilAutoSuspendOnLag,
    "SmilAutoSuspendOnLag",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kSmilKeyTimesKeyPointsAllowTrailingSemicolon,
    "SmilKeyTimesKeyPointsAllowTrailingSemicolon",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kSoftNavigationDetection,
    "SoftNavigationDetection",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kSoftNavigationDetectionAdvancedPaintAttribution,
    "SoftNavigationDetectionAdvancedPaintAttribution",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kSoftNavigationDetectionPrePaintBasedAttribution,
    "SoftNavigationDetectionPrePaintBasedAttribution",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kSoftNavigationHeuristics,
    "SoftNavigationHeuristics",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kSpatNavUsesCursorInheritance,
    "SpatNavUsesCursorInheritance",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kSpeakerSelection,
    "SpeakerSelection",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kSpecCompliantJsonMimeTypes,
    "SpecCompliantJsonMimeTypes",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kSpecialRulesForNestedH1Elements,
    "SpecialRulesForNestedH1Elements",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kSpeculationRulesPrefetchWithSubresources,
    "SpeculationRulesPrefetchWithSubresources",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kPrerender2InNewTab,
    "Prerender2InNewTab",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kSplitTextNotCleanupDummySpans,
    "SplitTextNotCleanupDummySpans",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kSrcsetSelectionMatchesImageSet,
    "SrcsetSelectionMatchesImageSet",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kStandardHistoryStateEmptyUrlHandling,
    "StandardHistoryStateEmptyUrlHandling",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kStandardizedBrowserZoom,
    "StandardizedBrowserZoom",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kStandardizedBrowserZoomOptOut,
    "StandardizedBrowserZoomOptOut",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kStickyUserActivationAcrossSameOriginNavigation,
    "StickyUserActivationAcrossSameOriginNavigation",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kStorageBuckets,
    "StorageBuckets",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kStorageBucketsDurability,
    "StorageBucketsDurability",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kStorageBucketsLocks,
    "StorageBucketsLocks",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kStrictMimeTypesForWorkers,
    "StrictMimeTypesForWorkers",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kSvgAnchorElementRelAttributes,
    "SvgAnchorElementRelAttributes",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kSvgAvoidCullingElementsWithTransformOperations,
    "SvgAvoidCullingElementsWithTransformOperations",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kSvgEagerPresAttrStyleUpdate,
    "SvgEagerPresAttrStyleUpdate",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kSvgExternalResources,
    "SvgExternalResources",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kSvgFeConvolveMatrixZeroDivisorBehavior,
    "SvgFeConvolveMatrixZeroDivisorBehavior",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kSvgIgnoreNegativeEllipseRadii,
    "SvgIgnoreNegativeEllipseRadii",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kSvgInlineRootPixelSnappingScaleAdjustment,
    "SvgInlineRootPixelSnappingScaleAdjustment",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kSvgNoPixelSnappingScaleAdjustment,
    "SvgNoPixelSnappingScaleAdjustment",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kSvgScriptElementAsyncAttribute,
    "SvgScriptElementAsyncAttribute",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kSvgTextCentralBaselineTextDecorationFix,
    "SvgTextCentralBaselineTextDecorationFix",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kSvgTransformOnNestedSvgElement,
    "SvgTransformOnNestedSvgElement",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kSvgUseInstancesAttributeSync,
    "SvgUseInstancesAttributeSync",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kSynthesizedKeyboardEventsForAccessibilityActions,
    "SynthesizedKeyboardEventsForAccessibilityActions",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kSystemFallbackEmojiVSSupport,
    "SystemFallbackEmojiVSSupport",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kSystemWakeLock,
    "SystemWakeLock",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kTableIsAutoFixedLayout,
    "TableIsAutoFixedLayout",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kTabSizeAncestor,
    "TabSizeAncestor",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kTabSizeWithSpacing,
    "TabSizeWithSpacing",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kTabWidthNegativePosition,
    "TabWidthNegativePosition",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kTestBlinkFeatureDefault,
    "TestBlinkFeatureDefault",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kTestFeatureStable,
    "TestFeatureStable",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kTextareaLineEndingsAsBr,
    "TextareaLineEndingsAsBr",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kTextareaMultipleIfcs,
    "TextareaMultipleIfcs",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kTextareaSplitText,
    "TextareaSplitText",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kTextDecorationShortSerialization,
    "TextDecorationShortSerialization",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kTextDetector,
    "TextDetector",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kTextDiffSplitFix,
    "TextDiffSplitFix",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kTextEmphasisLetterSpacing,
    "TextEmphasisLetterSpacing",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kTextEmphasisPositionAuto,
    "TextEmphasisPositionAuto",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kTextFragmentAPI,
    "TextFragmentAPI",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kTextFragmentAnchor,
    "TextFragmentAnchor",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kTextFragmentTapOpensContextMenu,
    "TextFragmentTapOpensContextMenu",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kTextMetricsBaselines,
    "TextMetricsBaselines",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kTextOverflowString,
    "TextOverflowString",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kTextSpacingTrimFallback,
    "TextSpacingTrimFallback",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kTextSpacingTrimFallback2,
    "TextSpacingTrimFallback2",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kTimestampBasedCLSTracking,
    "TimestampBasedCLSTracking",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kTimeZoneChangeEvent,
    "TimeZoneChangeEvent",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kToggleEventSource,
    "ToggleEventSource",
    base::FEATURE_ENABLED_BY_DEFAULT);

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kTouchDragOnShortPress,
    "TouchDragOnShortPress",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kTouchDragOnShortPress,
    "TouchDragOnShortPress",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kTouchDragOnShortPress,
    "TouchDragOnShortPress",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kTouchDragOnShortPress,
    "TouchDragOnShortPress",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kTouchDragOnShortPress,
    "TouchDragOnShortPress",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kTouchDragOnShortPress,
    "TouchDragOnShortPress",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kTouchDragOnShortPress,
    "TouchDragOnShortPress",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif

BASE_FEATURE(kTransferableRTCDataChannel,
    "TransferableRTCDataChannel",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kTranslateService,
    "TranslateService",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kTranslationAPI,
    "TranslationAPI",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kTranslationAPIForWorkers,
    "TranslationAPIForWorkers",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kTraverseFlatTreeToHandleSlots,
    "TraverseFlatTreeToHandleSlots",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kTreatMhtmlInitialDocumentLoadsAsCrossDocument,
    "TreatMhtmlInitialDocumentLoadsAsCrossDocument",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kTreatSymbolsAsWordBoundary,
    "TreatSymbolsAsWordBoundary",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kTrustedTypeBeforePolicyCreationEvent,
    "TrustedTypeBeforePolicyCreationEvent",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kTrustedTypesHTML,
    "TrustedTypesHTML",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kTrustedTypesUseCodeLike,
    "TrustedTypesUseCodeLike",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kUnclosedFormControlIsInvalid,
    "UnclosedFormControlIsInvalid",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kUnencodedDigest,
    "UnencodedDigest",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kUnexposedTaskIds,
    "UnexposedTaskIds",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kUnprefixedSpeechRecognition,
    "UnprefixedSpeechRecognition",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kUnrestrictedMeasureUserAgentSpecificMemory,
    "UnrestrictedMeasureUserAgentSpecificMemory",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kUnrestrictedUsb,
    "UnrestrictedUsb",
    base::FEATURE_ENABLED_BY_DEFAULT);

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kUpdateComplexSafaAreaConstraints,
    "UpdateComplexSafaAreaConstraints",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kUpdateComplexSafaAreaConstraints,
    "UpdateComplexSafaAreaConstraints",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kUpdateComplexSafaAreaConstraints,
    "UpdateComplexSafaAreaConstraints",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kUpdateComplexSafaAreaConstraints,
    "UpdateComplexSafaAreaConstraints",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kUpdateComplexSafaAreaConstraints,
    "UpdateComplexSafaAreaConstraints",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kUpdateComplexSafaAreaConstraints,
    "UpdateComplexSafaAreaConstraints",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kUpdateComplexSafaAreaConstraints,
    "UpdateComplexSafaAreaConstraints",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif

BASE_FEATURE(kUpdateSelectionOnNodeInsertion,
    "UpdateSelectionOnNodeInsertion",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kURLPatternCompareComponent,
    "URLPatternCompareComponent",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kURLPatternGenerate,
    "URLPatternGenerate",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kURLSearchParamsHasAndDeleteMultipleArgs,
    "URLSearchParamsHasAndDeleteMultipleArgs",
    base::FEATURE_ENABLED_BY_DEFAULT);

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kUseBeginFramePresentationFeedback,
    "UseBeginFramePresentationFeedback",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kUseBeginFramePresentationFeedback,
    "UseBeginFramePresentationFeedback",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kUseBeginFramePresentationFeedback,
    "UseBeginFramePresentationFeedback",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kUseBeginFramePresentationFeedback,
    "UseBeginFramePresentationFeedback",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kUseBeginFramePresentationFeedback,
    "UseBeginFramePresentationFeedback",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kUseBeginFramePresentationFeedback,
    "UseBeginFramePresentationFeedback",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kUseBeginFramePresentationFeedback,
    "UseBeginFramePresentationFeedback",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kUseLowQualityInterpolation,
    "UseLowQualityInterpolation",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kUseLowQualityInterpolation,
    "UseLowQualityInterpolation",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kUseLowQualityInterpolation,
    "UseLowQualityInterpolation",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kUseLowQualityInterpolation,
    "UseLowQualityInterpolation",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kUseLowQualityInterpolation,
    "UseLowQualityInterpolation",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kUseLowQualityInterpolation,
    "UseLowQualityInterpolation",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kUseLowQualityInterpolation,
    "UseLowQualityInterpolation",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif

BASE_FEATURE(kUseOriginalDomOffsetsForOffsetMap,
    "UseOriginalDomOffsetsForOffsetMap",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kUsePositionForPointInFlexibleBoxWithSingleChildElement,
    "UsePositionForPointInFlexibleBoxWithSingleChildElement",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kUsePositionIfIsVisuallyEquivalentCandidate,
    "UsePositionIfIsVisuallyEquivalentCandidate",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kUserDefinedEntryPointTiming,
    "UserDefinedEntryPointTiming",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kUseSelectionInDOMTreeAnchorInExtendSelection,
    "UseSelectionInDOMTreeAnchorInExtendSelection",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kUseShadowHostStyleCheckEditable,
    "UseShadowHostStyleCheckEditable",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kUseStyleRuleMapForSelectorStats,
    "UseStyleRuleMapForSelectorStats",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kUseUndoStepElementDispatchBeforeInput,
    "UseUndoStepElementDispatchBeforeInput",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kVideoAspectRatioNaturalDimension,
    "VideoAspectRatioNaturalDimension",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kVideoAutoFullscreen,
    "VideoAutoFullscreen",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kVideoFrameMetadataBackgroundBlur,
    "VideoFrameMetadataBackgroundBlur",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kVideoFrameMetadataRtpTimestamp,
    "VideoFrameMetadataRtpTimestamp",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kVideoFullscreenOrientationLock,
    "VideoFullscreenOrientationLock",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kVideoRotateToFullscreen,
    "VideoRotateToFullscreen",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kVideoTrackGenerator,
    "VideoTrackGenerator",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kVideoTrackGeneratorInWindow,
    "VideoTrackGeneratorInWindow",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kVideoTrackGeneratorInWorker,
    "VideoTrackGeneratorInWorker",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kViewportHeightClientHintHeader,
    "ViewportHeightClientHintHeader",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kViewportSegments,
    "ViewportSegments",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kViewTransitionAnimationDelayInherit,
    "ViewTransitionAnimationDelayInherit",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kViewTransitionAsyncFinished,
    "ViewTransitionAsyncFinished",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kViewTransitionInheritAnimationProperties,
    "ViewTransitionInheritAnimationProperties",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kViewTransitionLongCallbackTimeoutForTesting,
    "ViewTransitionLongCallbackTimeoutForTesting",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kViewTransitionUpdateLifecycleBeforeReady,
    "ViewTransitionUpdateLifecycleBeforeReady",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kVisibilityCollapseColumn,
    "VisibilityCollapseColumn",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kVisitedLinksOnErrorNavigation,
    "VisitedLinksOnErrorNavigation",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kVisualViewportOnScrollEnd,
    "VisualViewportOnScrollEnd",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kWakeLock,
    "WakeLock",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kWarnOnContentVisibilityRenderAccess,
    "WarnOnContentVisibilityRenderAccess",
    base::FEATURE_DISABLED_BY_DEFAULT);

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kWebAppInstallation,
    "WebAppInstallation",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kWebAppInstallation,
    "WebAppInstallation",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kWebAppInstallation,
    "WebAppInstallation",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kWebAppInstallation,
    "WebAppInstallation",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kWebAppInstallation,
    "WebAppInstallation",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kWebAppInstallation,
    "WebAppInstallation",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kWebAppInstallation,
    "WebAppInstallation",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif

BASE_FEATURE(kDesktopPWAsTabStrip,
    "DesktopPWAsTabStrip",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kDesktopPWAsTabStripCustomizations,
    "DesktopPWAsTabStripCustomizations",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kWebAppEnableTranslations,
    "WebAppEnableTranslations",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kWebAssemblyJSStringBuiltins,
    "WebAssemblyJSStringBuiltins",
    base::FEATURE_ENABLED_BY_DEFAULT);

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kWebAudioBypassOutputBuffering,
    "WebAudioBypassOutputBuffering",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kWebAudioBypassOutputBuffering,
    "WebAudioBypassOutputBuffering",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_CHROMEOS)
BASE_FEATURE(kWebAudioBypassOutputBuffering,
    "WebAudioBypassOutputBuffering",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_MAC)
BASE_FEATURE(kWebAudioBypassOutputBuffering,
    "WebAudioBypassOutputBuffering",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_LINUX)
BASE_FEATURE(kWebAudioBypassOutputBuffering,
    "WebAudioBypassOutputBuffering",
    base::FEATURE_ENABLED_BY_DEFAULT);
#endif
#if BUILDFLAG(IS_IOS)
BASE_FEATURE(kWebAudioBypassOutputBuffering,
    "WebAudioBypassOutputBuffering",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif
#if !BUILDFLAG(IS_ANDROID) && !BUILDFLAG(IS_WIN) && !BUILDFLAG(IS_CHROMEOS) && !BUILDFLAG(IS_MAC) && !BUILDFLAG(IS_LINUX) && !BUILDFLAG(IS_IOS)
BASE_FEATURE(kWebAudioBypassOutputBuffering,
    "WebAudioBypassOutputBuffering",
    base::FEATURE_DISABLED_BY_DEFAULT);
#endif

BASE_FEATURE(kWebAudioBypassOutputBufferingOptOut,
    "WebAudioBypassOutputBufferingOptOut",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kWebAuth,
    "WebAuth",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kWebAuthAuthenticatorAttachment,
    "WebAuthAuthenticatorAttachment",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kWebAuthenticationAttestationFormats,
    "WebAuthenticationAttestationFormats",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kWebAuthenticationChallengeUrl,
    "WebAuthenticationChallengeUrl",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kWebAuthenticationJSONSerialization,
    "WebAuthenticationJSONSerialization",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kWebAuthenticationNewBfCacheHandlingBlink,
    "WebAuthenticationNewBfCacheHandlingBlink",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kWebAuthenticationPRFExtension,
    "WebAuthenticationPRFExtension",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kWebAuthenticationSupplementalPubKeys,
    "WebAuthenticationSupplementalPubKeys",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kWebBluetoothScanning,
    "WebBluetoothScanning",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kWebCodecsCopyToRGB,
    "WebCodecsCopyToRGB",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kWebCodecsHBDFormats,
    "WebCodecsHBDFormats",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kWebCodecsOrientation,
    "WebCodecsOrientation",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kWebCodecsVideoEncoderBuffers,
    "WebCodecsVideoEncoderBuffers",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kWebFontResizeLCP,
    "WebFontResizeLCP",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kWebGLDrawingBufferStorage,
    "WebGLDrawingBufferStorage",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kWebGLOnWebGPU,
    "WebGLOnWebGPU",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kWebGPUCompatibilityMode,
    "WebGPUCompatibilityMode",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kWebGPUExperimentalFeatures,
    "WebGPUExperimentalFeatures",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kWebHID,
    "WebHID",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kWebIDLBigIntUsesToBigInt,
    "WebIDLBigIntUsesToBigInt",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kWebPreferences,
    "WebPreferences",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kWebPrinting,
    "WebPrinting",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kWebShare,
    "WebShare",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kWebSocketStream,
    "WebSocketStream",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kWebSpeechRecognitionContext,
    "WebSpeechRecognitionContext",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kWebUIBundledCodeCacheAsyncFetch,
    "WebUIBundledCodeCacheAsyncFetch",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kWebUSBOnDedicatedWorkers,
    "WebUSBOnDedicatedWorkers",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kWebVTTRegions,
    "WebVTTRegions",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kWebXRDepthPerformance,
    "WebXRDepthPerformance",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kWebXREnabledFeatures,
    "WebXREnabledFeatures",
    base::FEATURE_ENABLED_BY_DEFAULT);

BASE_FEATURE(kWebXRHitTestEntityTypes,
    "WebXRHitTestEntityTypes",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kWebXRSpecParity,
    "WebXRSpecParity",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kWidthAndHeightAsPresentationAttributesOnNestedSvg,
    "WidthAndHeightAsPresentationAttributesOnNestedSvg",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kWidthAndHeightStylePropertiesOnUseAndSymbol,
    "WidthAndHeightStylePropertiesOnUseAndSymbol",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kWindowDefaultStatus,
    "WindowDefaultStatus",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kXMLSerializerConsistentDefaultNsDeclMatching,
    "XMLSerializerConsistentDefaultNsDeclMatching",
    base::FEATURE_DISABLED_BY_DEFAULT);

BASE_FEATURE(kZeroCopyTabCapture,
    "ZeroCopyTabCapture",
    base::FEATURE_DISABLED_BY_DEFAULT);


}  // namespace features
}  // namespace blink
