// third_party/blink/public/mojom/handwriting/handwriting.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/handwriting/handwriting.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/handwriting/handwriting.mojom-params-data.h"
namespace handwriting {
namespace mojom {

NOINLINE static const char* HandwritingRecognitionTypeToStringHelper(HandwritingRecognitionType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case HandwritingRecognitionType::kText:
      return "kText";
    default:
      return nullptr;
  }
}

std::string HandwritingRecognitionTypeToString(HandwritingRecognitionType value) {
  const char *str = HandwritingRecognitionTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown HandwritingRecognitionType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, HandwritingRecognitionType value) {
  return os << HandwritingRecognitionTypeToString(value);
}

NOINLINE static const char* HandwritingInputTypeToStringHelper(HandwritingInputType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case HandwritingInputType::kMouse:
      return "kMouse";
    case HandwritingInputType::kStylus:
      return "kStylus";
    case HandwritingInputType::kTouch:
      return "kTouch";
    default:
      return nullptr;
  }
}

std::string HandwritingInputTypeToString(HandwritingInputType value) {
  const char *str = HandwritingInputTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown HandwritingInputType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, HandwritingInputType value) {
  return os << HandwritingInputTypeToString(value);
}

NOINLINE static const char* CreateHandwritingRecognizerResultToStringHelper(CreateHandwritingRecognizerResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CreateHandwritingRecognizerResult::kOk:
      return "kOk";
    case CreateHandwritingRecognizerResult::kError:
      return "kError";
    case CreateHandwritingRecognizerResult::kNotSupported:
      return "kNotSupported";
    default:
      return nullptr;
  }
}

std::string CreateHandwritingRecognizerResultToString(CreateHandwritingRecognizerResult value) {
  const char *str = CreateHandwritingRecognizerResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CreateHandwritingRecognizerResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CreateHandwritingRecognizerResult value) {
  return os << CreateHandwritingRecognizerResultToString(value);
}

namespace internal {


// static
bool HandwritingPoint_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const HandwritingPoint_Data* object =
      static_cast<const HandwritingPoint_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->location, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->location, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->t, validation_context))
    return false;

  return true;
}

HandwritingPoint_Data::HandwritingPoint_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HandwritingStroke_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const HandwritingStroke_Data* object =
      static_cast<const HandwritingStroke_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->points, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& points_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->points, validation_context,
                                         &points_validate_params)) {
    return false;
  }

  return true;
}

HandwritingStroke_Data::HandwritingStroke_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HandwritingDrawingSegment_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const HandwritingDrawingSegment_Data* object =
      static_cast<const HandwritingDrawingSegment_Data*>(data);

  return true;
}

HandwritingDrawingSegment_Data::HandwritingDrawingSegment_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HandwritingSegment_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const HandwritingSegment_Data* object =
      static_cast<const HandwritingSegment_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->grapheme, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& grapheme_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->grapheme, validation_context,
                                         &grapheme_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->drawing_segments, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& drawing_segments_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->drawing_segments, validation_context,
                                         &drawing_segments_validate_params)) {
    return false;
  }

  return true;
}

HandwritingSegment_Data::HandwritingSegment_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HandwritingPrediction_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const HandwritingPrediction_Data* object =
      static_cast<const HandwritingPrediction_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->text, validation_context,
                                         &text_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->segmentation_result, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& segmentation_result_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->segmentation_result, validation_context,
                                         &segmentation_result_validate_params)) {
    return false;
  }

  return true;
}

HandwritingPrediction_Data::HandwritingPrediction_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HandwritingHints_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const HandwritingHints_Data* object =
      static_cast<const HandwritingHints_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->recognition_type, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& recognition_type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->recognition_type, validation_context,
                                         &recognition_type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_type, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& input_type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->input_type, validation_context,
                                         &input_type_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& text_context_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->text_context, validation_context,
                                         &text_context_validate_params)) {
    return false;
  }

  return true;
}

HandwritingHints_Data::HandwritingHints_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HandwritingHintsQueryResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const HandwritingHintsQueryResult_Data* object =
      static_cast<const HandwritingHintsQueryResult_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->recognition_type, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& recognition_type_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::handwriting::mojom::internal::HandwritingRecognitionType_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->recognition_type, validation_context,
                                         &recognition_type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_type, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& input_type_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::handwriting::mojom::internal::HandwritingInputType_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->input_type, validation_context,
                                         &input_type_validate_params)) {
    return false;
  }

  return true;
}

HandwritingHintsQueryResult_Data::HandwritingHintsQueryResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QueryHandwritingRecognizerResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const QueryHandwritingRecognizerResult_Data* object =
      static_cast<const QueryHandwritingRecognizerResult_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hints, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->hints, validation_context))
    return false;

  return true;
}

QueryHandwritingRecognizerResult_Data::QueryHandwritingRecognizerResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HandwritingModelConstraint_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const HandwritingModelConstraint_Data* object =
      static_cast<const HandwritingModelConstraint_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->languages, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& languages_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->languages, validation_context,
                                         &languages_validate_params)) {
    return false;
  }

  return true;
}

HandwritingModelConstraint_Data::HandwritingModelConstraint_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HandwritingRecognizer_GetPrediction_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const HandwritingRecognizer_GetPrediction_Params_Data* object =
      static_cast<const HandwritingRecognizer_GetPrediction_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->strokes, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& strokes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->strokes, validation_context,
                                         &strokes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hints, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->hints, validation_context))
    return false;

  return true;
}

HandwritingRecognizer_GetPrediction_Params_Data::HandwritingRecognizer_GetPrediction_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HandwritingRecognizer_GetPrediction_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const HandwritingRecognizer_GetPrediction_ResponseParams_Data* object =
      static_cast<const HandwritingRecognizer_GetPrediction_ResponseParams_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& prediction_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->prediction, validation_context,
                                         &prediction_validate_params)) {
    return false;
  }

  return true;
}

HandwritingRecognizer_GetPrediction_ResponseParams_Data::HandwritingRecognizer_GetPrediction_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HandwritingRecognitionService_CreateHandwritingRecognizer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const HandwritingRecognitionService_CreateHandwritingRecognizer_Params_Data* object =
      static_cast<const HandwritingRecognitionService_CreateHandwritingRecognizer_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->constraint, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->constraint, validation_context))
    return false;

  return true;
}

HandwritingRecognitionService_CreateHandwritingRecognizer_Params_Data::HandwritingRecognitionService_CreateHandwritingRecognizer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HandwritingRecognitionService_CreateHandwritingRecognizer_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const HandwritingRecognitionService_CreateHandwritingRecognizer_ResponseParams_Data* object =
      static_cast<const HandwritingRecognitionService_CreateHandwritingRecognizer_ResponseParams_Data*>(data);


  if (!::handwriting::mojom::internal::CreateHandwritingRecognizerResult_Data
        ::Validate(object->result, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->handwriting_recognizer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

HandwritingRecognitionService_CreateHandwritingRecognizer_ResponseParams_Data::HandwritingRecognitionService_CreateHandwritingRecognizer_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HandwritingRecognitionService_QueryHandwritingRecognizer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const HandwritingRecognitionService_QueryHandwritingRecognizer_Params_Data* object =
      static_cast<const HandwritingRecognitionService_QueryHandwritingRecognizer_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->constraint, validation_context))
    return false;

  return true;
}

HandwritingRecognitionService_QueryHandwritingRecognizer_Params_Data::HandwritingRecognitionService_QueryHandwritingRecognizer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HandwritingRecognitionService_QueryHandwritingRecognizer_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const HandwritingRecognitionService_QueryHandwritingRecognizer_ResponseParams_Data* object =
      static_cast<const HandwritingRecognitionService_QueryHandwritingRecognizer_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

HandwritingRecognitionService_QueryHandwritingRecognizer_ResponseParams_Data::HandwritingRecognitionService_QueryHandwritingRecognizer_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace handwriting

namespace perfetto {

// static
void TraceFormatTraits<::handwriting::mojom::HandwritingRecognitionType>::WriteIntoTrace(
   perfetto::TracedValue context, ::handwriting::mojom::HandwritingRecognitionType value) {
  return std::move(context).WriteString(::handwriting::mojom::HandwritingRecognitionTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::handwriting::mojom::HandwritingInputType>::WriteIntoTrace(
   perfetto::TracedValue context, ::handwriting::mojom::HandwritingInputType value) {
  return std::move(context).WriteString(::handwriting::mojom::HandwritingInputTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::handwriting::mojom::CreateHandwritingRecognizerResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::handwriting::mojom::CreateHandwritingRecognizerResult value) {
  return std::move(context).WriteString(::handwriting::mojom::CreateHandwritingRecognizerResultToString(value));
}

} // namespace perfetto