// third_party/blink/public/mojom/manifest/manifest.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/manifest/manifest.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/manifest/manifest.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* TabStripMemberVisibilityToStringHelper(TabStripMemberVisibility value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TabStripMemberVisibility::kAuto:
      return "kAuto";
    case TabStripMemberVisibility::kAbsent:
      return "kAbsent";
    default:
      return nullptr;
  }
}

std::string TabStripMemberVisibilityToString(TabStripMemberVisibility value) {
  const char *str = TabStripMemberVisibilityToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TabStripMemberVisibility value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TabStripMemberVisibility value) {
  return os << TabStripMemberVisibilityToString(value);
}

NOINLINE static const char* ManifestRequestResultToStringHelper(ManifestRequestResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ManifestRequestResult::kUnexpectedFailure:
      return "kUnexpectedFailure";
    case ManifestRequestResult::kNoManifestAllowed:
      return "kNoManifestAllowed";
    case ManifestRequestResult::kNoManifestSpecified:
      return "kNoManifestSpecified";
    case ManifestRequestResult::kManifestFailedToFetch:
      return "kManifestFailedToFetch";
    case ManifestRequestResult::kManifestFailedToParse:
      return "kManifestFailedToParse";
    case ManifestRequestResult::kSuccess:
      return "kSuccess";
    default:
      return nullptr;
  }
}

std::string ManifestRequestResultToString(ManifestRequestResult value) {
  const char *str = ManifestRequestResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ManifestRequestResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ManifestRequestResult value) {
  return os << ManifestRequestResultToString(value);
}

NOINLINE static const char* Manifest_TextDirectionToStringHelper(Manifest_TextDirection value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Manifest_TextDirection::kAuto:
      return "kAuto";
    case Manifest_TextDirection::kLTR:
      return "kLTR";
    case Manifest_TextDirection::kRTL:
      return "kRTL";
    default:
      return nullptr;
  }
}

std::string Manifest_TextDirectionToString(Manifest_TextDirection value) {
  const char *str = Manifest_TextDirectionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Manifest_TextDirection value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Manifest_TextDirection value) {
  return os << Manifest_TextDirectionToString(value);
}

NOINLINE static const char* ManifestImageResource_PurposeToStringHelper(ManifestImageResource_Purpose value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ManifestImageResource_Purpose::ANY:
      return "ANY";
    case ManifestImageResource_Purpose::MONOCHROME:
      return "MONOCHROME";
    case ManifestImageResource_Purpose::MASKABLE:
      return "MASKABLE";
    default:
      return nullptr;
  }
}

std::string ManifestImageResource_PurposeToString(ManifestImageResource_Purpose value) {
  const char *str = ManifestImageResource_PurposeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ManifestImageResource_Purpose value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ManifestImageResource_Purpose value) {
  return os << ManifestImageResource_PurposeToString(value);
}

NOINLINE static const char* ManifestScreenshot_FormFactorToStringHelper(ManifestScreenshot_FormFactor value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ManifestScreenshot_FormFactor::kUnknown:
      return "kUnknown";
    case ManifestScreenshot_FormFactor::kWide:
      return "kWide";
    case ManifestScreenshot_FormFactor::kNarrow:
      return "kNarrow";
    default:
      return nullptr;
  }
}

std::string ManifestScreenshot_FormFactorToString(ManifestScreenshot_FormFactor value) {
  const char *str = ManifestScreenshot_FormFactorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ManifestScreenshot_FormFactor value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ManifestScreenshot_FormFactor value) {
  return os << ManifestScreenshot_FormFactorToString(value);
}

NOINLINE static const char* ManifestShareTarget_MethodToStringHelper(ManifestShareTarget_Method value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ManifestShareTarget_Method::kGet:
      return "kGet";
    case ManifestShareTarget_Method::kPost:
      return "kPost";
    default:
      return nullptr;
  }
}

std::string ManifestShareTarget_MethodToString(ManifestShareTarget_Method value) {
  const char *str = ManifestShareTarget_MethodToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ManifestShareTarget_Method value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ManifestShareTarget_Method value) {
  return os << ManifestShareTarget_MethodToString(value);
}

NOINLINE static const char* ManifestShareTarget_EnctypeToStringHelper(ManifestShareTarget_Enctype value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ManifestShareTarget_Enctype::kFormUrlEncoded:
      return "kFormUrlEncoded";
    case ManifestShareTarget_Enctype::kMultipartFormData:
      return "kMultipartFormData";
    default:
      return nullptr;
  }
}

std::string ManifestShareTarget_EnctypeToString(ManifestShareTarget_Enctype value) {
  const char *str = ManifestShareTarget_EnctypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ManifestShareTarget_Enctype value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ManifestShareTarget_Enctype value) {
  return os << ManifestShareTarget_EnctypeToString(value);
}

NOINLINE static const char* ManifestFileHandler_LaunchTypeToStringHelper(ManifestFileHandler_LaunchType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ManifestFileHandler_LaunchType::kSingleClient:
      return "kSingleClient";
    case ManifestFileHandler_LaunchType::kMultipleClients:
      return "kMultipleClients";
    default:
      return nullptr;
  }
}

std::string ManifestFileHandler_LaunchTypeToString(ManifestFileHandler_LaunchType value) {
  const char *str = ManifestFileHandler_LaunchTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ManifestFileHandler_LaunchType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ManifestFileHandler_LaunchType value) {
  return os << ManifestFileHandler_LaunchTypeToString(value);
}

namespace internal {
// static
bool HomeTabUnion_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const HomeTabUnion_Data* object = static_cast<const HomeTabUnion_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case HomeTabUnion_Tag::kVisibility: {


      if (!::blink::mojom::internal::TabStripMemberVisibility_Data
            ::Validate(object->data.f_visibility, validation_context))
        return false;
      return true;
    }
    case HomeTabUnion_Tag::kParams: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_params, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_params, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in HomeTabUnion");
      return false;
    }
  }
}


// static
bool Manifest_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 272, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Manifest_Data* object =
      static_cast<const Manifest_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->manifest_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->manifest_url, validation_context))
    return false;


  if (!::blink::mojom::internal::Manifest_TextDirection_Data
        ::Validate(object->dir, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->short_name, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->description, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->start_url, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->start_url, validation_context))
    return false;


  if (!::blink::mojom::internal::DisplayMode_Data
        ::Validate(object->display, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display_override, 11, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& display_override_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::DisplayMode_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->display_override, validation_context,
                                         &display_override_validate_params)) {
    return false;
  }


  if (!::device::mojom::internal::ScreenOrientationLockType_Data
        ::Validate(object->orientation, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icons, 13, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& icons_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->icons, validation_context,
                                         &icons_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->screenshots, 14, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& screenshots_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->screenshots, validation_context,
                                         &screenshots_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->shortcuts, 15, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& shortcuts_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->shortcuts, validation_context,
                                         &shortcuts_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->share_target, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file_handlers, 17, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& file_handlers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->file_handlers, validation_context,
                                         &file_handlers_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->protocol_handlers, 18, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& protocol_handlers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->protocol_handlers, validation_context,
                                         &protocol_handlers_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scope_extensions, 19, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& scope_extensions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->scope_extensions, validation_context,
                                         &scope_extensions_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->lock_screen, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->note_taking, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->related_applications, 22, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& related_applications_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->related_applications, validation_context,
                                         &related_applications_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->gcm_sender_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scope, 29, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scope, validation_context))
    return false;


  if (!::blink::mojom::internal::CaptureLinks_Data
        ::Validate(object->capture_links, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->permissions_policy, 31, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& permissions_policy_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->permissions_policy, validation_context,
                                         &permissions_policy_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->launch_handler, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->translations, 33, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& translations_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->translations, validation_context,
                                         &translations_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->tab_strip, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->version, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name_localized, 40, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_localized_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->name_localized, validation_context,
                                         &name_localized_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->short_name_localized, 41, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& short_name_localized_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->short_name_localized, validation_context,
                                         &short_name_localized_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->description_localized, 42, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& description_localized_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->description_localized, validation_context,
                                         &description_localized_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icons_localized, 43, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& icons_localized_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->icons_localized, validation_context,
                                         &icons_localized_validate_params)) {
    return false;
  }

  return true;
}

Manifest_Data::Manifest_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestLocalizedTextObject_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ManifestLocalizedTextObject_Data* object =
      static_cast<const ManifestLocalizedTextObject_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;


  if (!::blink::mojom::internal::Manifest_TextDirection_Data
        ::Validate(object->dir_$value, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->lang, validation_context))
    return false;

  return true;
}

ManifestLocalizedTextObject_Data::ManifestLocalizedTextObject_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestShortcutItem_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ManifestShortcutItem_Data* object =
      static_cast<const ManifestShortcutItem_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->short_name, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->description, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icons, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& icons_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->icons, validation_context,
                                         &icons_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name_localized, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_localized_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->name_localized, validation_context,
                                         &name_localized_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->short_name_localized, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& short_name_localized_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->short_name_localized, validation_context,
                                         &short_name_localized_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->description_localized, 8, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& description_localized_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->description_localized, validation_context,
                                         &description_localized_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icons_localized, 9, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& icons_localized_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->icons_localized, validation_context,
                                         &icons_localized_validate_params)) {
    return false;
  }

  return true;
}

ManifestShortcutItem_Data::ManifestShortcutItem_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestImageResource_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ManifestImageResource_Data* object =
      static_cast<const ManifestImageResource_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->src, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->src, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sizes, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& sizes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->sizes, validation_context,
                                         &sizes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->purpose, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& purpose_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::ManifestImageResource_Purpose_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->purpose, validation_context,
                                         &purpose_validate_params)) {
    return false;
  }

  return true;
}

ManifestImageResource_Data::ManifestImageResource_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestScreenshot_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ManifestScreenshot_Data* object =
      static_cast<const ManifestScreenshot_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->image, validation_context))
    return false;


  if (!::blink::mojom::internal::ManifestScreenshot_FormFactor_Data
        ::Validate(object->form_factor, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->label, validation_context))
    return false;

  return true;
}

ManifestScreenshot_Data::ManifestScreenshot_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestFileFilter_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ManifestFileFilter_Data* object =
      static_cast<const ManifestFileFilter_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->accept, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& accept_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->accept, validation_context,
                                         &accept_validate_params)) {
    return false;
  }

  return true;
}

ManifestFileFilter_Data::ManifestFileFilter_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestProtocolHandler_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ManifestProtocolHandler_Data* object =
      static_cast<const ManifestProtocolHandler_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->protocol, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->protocol, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

ManifestProtocolHandler_Data::ManifestProtocolHandler_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestScopeExtension_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ManifestScopeExtension_Data* object =
      static_cast<const ManifestScopeExtension_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  return true;
}

ManifestScopeExtension_Data::ManifestScopeExtension_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestLockScreen_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ManifestLockScreen_Data* object =
      static_cast<const ManifestLockScreen_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->start_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->start_url, validation_context))
    return false;

  return true;
}

ManifestLockScreen_Data::ManifestLockScreen_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestNoteTaking_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ManifestNoteTaking_Data* object =
      static_cast<const ManifestNoteTaking_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_note_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->new_note_url, validation_context))
    return false;

  return true;
}

ManifestNoteTaking_Data::ManifestNoteTaking_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestRelatedApplication_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ManifestRelatedApplication_Data* object =
      static_cast<const ManifestRelatedApplication_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->platform, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  return true;
}

ManifestRelatedApplication_Data::ManifestRelatedApplication_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestShareTargetParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ManifestShareTargetParams_Data* object =
      static_cast<const ManifestShareTargetParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->text, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& files_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->files, validation_context,
                                         &files_validate_params)) {
    return false;
  }

  return true;
}

ManifestShareTargetParams_Data::ManifestShareTargetParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestShareTarget_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ManifestShareTarget_Data* object =
      static_cast<const ManifestShareTarget_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->action, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->action, validation_context))
    return false;


  if (!::blink::mojom::internal::ManifestShareTarget_Method_Data
        ::Validate(object->method, validation_context))
    return false;


  if (!::blink::mojom::internal::ManifestShareTarget_Enctype_Data
        ::Validate(object->enctype, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

ManifestShareTarget_Data::ManifestShareTarget_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestFileHandler_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ManifestFileHandler_Data* object =
      static_cast<const ManifestFileHandler_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->action, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->action, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icons, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& icons_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->icons, validation_context,
                                         &icons_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->accept, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& accept_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->accept, validation_context,
                                         &accept_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::ManifestFileHandler_LaunchType_Data
        ::Validate(object->launch_type, validation_context))
    return false;

  return true;
}

ManifestFileHandler_Data::ManifestFileHandler_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestTranslationItem_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ManifestTranslationItem_Data* object =
      static_cast<const ManifestTranslationItem_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->short_name, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->description, validation_context))
    return false;

  return true;
}

ManifestTranslationItem_Data::ManifestTranslationItem_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestTabStrip_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ManifestTabStrip_Data* object =
      static_cast<const ManifestTabStrip_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->home_tab, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->home_tab, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_tab_button, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->new_tab_button, validation_context))
    return false;

  return true;
}

ManifestTabStrip_Data::ManifestTabStrip_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HomeTabParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const HomeTabParams_Data* object =
      static_cast<const HomeTabParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icons, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& icons_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->icons, validation_context,
                                         &icons_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scope_patterns, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& scope_patterns_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->scope_patterns, validation_context,
                                         &scope_patterns_validate_params)) {
    return false;
  }

  return true;
}

HomeTabParams_Data::HomeTabParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NewTabButtonParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NewTabButtonParams_Data* object =
      static_cast<const NewTabButtonParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

NewTabButtonParams_Data::NewTabButtonParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestDebugInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ManifestDebugInfo_Data* object =
      static_cast<const ManifestDebugInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->errors, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& errors_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->errors, validation_context,
                                         &errors_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->raw_manifest, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& raw_manifest_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->raw_manifest, validation_context,
                                         &raw_manifest_validate_params)) {
    return false;
  }

  return true;
}

ManifestDebugInfo_Data::ManifestDebugInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestError_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ManifestError_Data* object =
      static_cast<const ManifestError_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

ManifestError_Data::ManifestError_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::TabStripMemberVisibility>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::TabStripMemberVisibility value) {
  return std::move(context).WriteString(::blink::mojom::TabStripMemberVisibilityToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ManifestRequestResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::ManifestRequestResult value) {
  return std::move(context).WriteString(::blink::mojom::ManifestRequestResultToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::Manifest_TextDirection>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::Manifest_TextDirection value) {
  return std::move(context).WriteString(::blink::mojom::Manifest_TextDirectionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ManifestImageResource_Purpose>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::ManifestImageResource_Purpose value) {
  return std::move(context).WriteString(::blink::mojom::ManifestImageResource_PurposeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ManifestScreenshot_FormFactor>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::ManifestScreenshot_FormFactor value) {
  return std::move(context).WriteString(::blink::mojom::ManifestScreenshot_FormFactorToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ManifestShareTarget_Method>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::ManifestShareTarget_Method value) {
  return std::move(context).WriteString(::blink::mojom::ManifestShareTarget_MethodToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ManifestShareTarget_Enctype>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::ManifestShareTarget_Enctype value) {
  return std::move(context).WriteString(::blink::mojom::ManifestShareTarget_EnctypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ManifestFileHandler_LaunchType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::ManifestFileHandler_LaunchType value) {
  return std::move(context).WriteString(::blink::mojom::ManifestFileHandler_LaunchTypeToString(value));
}

} // namespace perfetto