// third_party/blink/public/mojom/mediasession/media_session.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASESSION_MEDIA_SESSION_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASESSION_MEDIA_SESSION_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/mediasession/media_session.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "services/media_session/public/mojom/media_session.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/mediasession/media_session.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::MediaSessionPlaybackState>
    : public mojo::internal::EnumHashImpl<::blink::mojom::MediaSessionPlaybackState> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::MediaSessionPlaybackState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::MediaSessionPlaybackState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::MediaSessionPlaybackState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::MediaSessionSeekToDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::MediaSessionSeekToDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::MediaSessionSeekToDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::seek_time(input)) in_seek_time = Traits::seek_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->seek_time)::BaseType> seek_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_seek_time,
      seek_time_fragment);

    fragment->seek_time.Set(
        seek_time_fragment.is_null() ? nullptr : seek_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->seek_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null seek_time in MediaSessionSeekToDetails struct");

    fragment->fast_seek = Traits::fast_seek(input);
  }

  static bool Deserialize(::blink::mojom::internal::MediaSessionSeekToDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::MediaSessionSeekToDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SpecMediaMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SpecMediaMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::SpecMediaMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in SpecMediaMetadata struct");

    decltype(Traits::artist(input)) in_artist = Traits::artist(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->artist)::BaseType> artist_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_artist,
      artist_fragment);

    fragment->artist.Set(
        artist_fragment.is_null() ? nullptr : artist_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->artist.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null artist in SpecMediaMetadata struct");

    decltype(Traits::album(input)) in_album = Traits::album(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->album)::BaseType> album_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_album,
      album_fragment);

    fragment->album.Set(
        album_fragment.is_null() ? nullptr : album_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->album.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null album in SpecMediaMetadata struct");

    decltype(Traits::artwork(input)) in_artwork = Traits::artwork(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->artwork)::BaseType>
        artwork_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& artwork_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::media_session::mojom::MediaImageDataView>>(
      in_artwork,
      artwork_fragment,
      &artwork_validate_params);

    fragment->artwork.Set(
        artwork_fragment.is_null() ? nullptr : artwork_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->artwork.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null artwork in SpecMediaMetadata struct");

    decltype(Traits::chapterInfo(input)) in_chapterInfo = Traits::chapterInfo(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->chapterInfo)::BaseType>
        chapterInfo_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& chapterInfo_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::media_session::mojom::ChapterInformationDataView>>(
      in_chapterInfo,
      chapterInfo_fragment,
      &chapterInfo_validate_params);

    fragment->chapterInfo.Set(
        chapterInfo_fragment.is_null() ? nullptr : chapterInfo_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->chapterInfo.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null chapterInfo in SpecMediaMetadata struct");
  }

  static bool Deserialize(::blink::mojom::internal::SpecMediaMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SpecMediaMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::MediaSessionActionDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::MediaSessionActionDetailsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::MediaSessionActionDetails_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::MediaSessionActionDetailsDataView::Tag::kSeekTo: {
    decltype(Traits::seek_to(input))
    in_seek_to = Traits::seek_to(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_seek_to)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::MediaSessionSeekToDetailsDataView>(
  in_seek_to,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null seek_to in MediaSessionActionDetails union");
    fragment->data.f_seek_to.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::blink::mojom::internal::MediaSessionActionDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::MediaSessionActionDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void MediaSessionSeekToDetailsDataView::GetSeekTimeDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->seek_time.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}


inline void SpecMediaMetadataDataView::GetTitleDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->title.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void SpecMediaMetadataDataView::GetArtistDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->artist.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void SpecMediaMetadataDataView::GetAlbumDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->album.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void SpecMediaMetadataDataView::GetArtworkDataView(
    mojo::ArrayDataView<::media_session::mojom::MediaImageDataView>* output) {
  auto pointer = data_->artwork.Get();
  *output = mojo::ArrayDataView<::media_session::mojom::MediaImageDataView>(pointer, message_);
}
inline void SpecMediaMetadataDataView::GetChapterInfoDataView(
    mojo::ArrayDataView<::media_session::mojom::ChapterInformationDataView>* output) {
  auto pointer = data_->chapterInfo.Get();
  *output = mojo::ArrayDataView<::media_session::mojom::ChapterInformationDataView>(pointer, message_);
}


inline void MediaSessionActionDetailsDataView::GetSeekToDataView(
    MediaSessionSeekToDetailsDataView* output) const {
  CHECK(is_seek_to());
  *output = MediaSessionSeekToDetailsDataView(data_->data.f_seek_to.Get(), message_);
}


}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::MediaSessionPlaybackState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::MediaSessionPlaybackState value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASESSION_MEDIA_SESSION_MOJOM_SHARED_H_