// ui/ozone/public/mojom/gesture_properties_service.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_OZONE_PUBLIC_MOJOM_GESTURE_PROPERTIES_SERVICE_MOJOM_DATA_VIEW_H_
#define UI_OZONE_PUBLIC_MOJOM_GESTURE_PROPERTIES_SERVICE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "ui/ozone/public/mojom/gesture_properties_service.mojom-shared-internal.h"


namespace ui::ozone::mojom {
class GesturePropValueDataView;


}  // ui::ozone::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::ui::ozone::mojom::GesturePropValueDataView> {
  using Data = ::ui::ozone::mojom::internal::GesturePropValue_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace ui::ozone::mojom {


enum class SetGesturePropErrorCode : int32_t {
  
  SUCCESS = 0,
  
  UNKNOWN_ERROR = 1,
  
  NOT_FOUND = 2,
  
  READ_ONLY = 3,
  
  TYPE_MISMATCH = 4,
  
  SIZE_MISMATCH = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, SetGesturePropErrorCode value);
inline bool IsKnownEnumValue(SetGesturePropErrorCode value) {
  return internal::SetGesturePropErrorCode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class GesturePropertiesServiceInterfaceBase {};

using GesturePropertiesServicePtrDataView =
    mojo::InterfacePtrDataView<GesturePropertiesServiceInterfaceBase>;
using GesturePropertiesServiceRequestDataView =
    mojo::InterfaceRequestDataView<GesturePropertiesServiceInterfaceBase>;
using GesturePropertiesServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<GesturePropertiesServiceInterfaceBase>;
using GesturePropertiesServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<GesturePropertiesServiceInterfaceBase>;


class GesturePropValueDataView {
 public:
  using Tag = internal::GesturePropValue_Data::GesturePropValue_Tag;

  GesturePropValueDataView() = default;

  GesturePropValueDataView(
      internal::GesturePropValue_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_ints() const { return data_->tag == Tag::kInts; }
  inline void GetIntsDataView(
      mojo::ArrayDataView<int32_t>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadInts(UserType* output) const {
    
    CHECK(is_ints());
    return mojo::internal::Deserialize<mojo::ArrayDataView<int32_t>>(
        data_->data.f_ints.Get(), output, message_);
  }
  bool is_shorts() const { return data_->tag == Tag::kShorts; }
  inline void GetShortsDataView(
      mojo::ArrayDataView<int16_t>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadShorts(UserType* output) const {
    
    CHECK(is_shorts());
    return mojo::internal::Deserialize<mojo::ArrayDataView<int16_t>>(
        data_->data.f_shorts.Get(), output, message_);
  }
  bool is_bools() const { return data_->tag == Tag::kBools; }
  inline void GetBoolsDataView(
      mojo::ArrayDataView<bool>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadBools(UserType* output) const {
    
    CHECK(is_bools());
    return mojo::internal::Deserialize<mojo::ArrayDataView<bool>>(
        data_->data.f_bools.Get(), output, message_);
  }
  bool is_str() const { return data_->tag == Tag::kStr; }
  inline void GetStrDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadStr(UserType* output) const {
    
    CHECK(is_str());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_str.Get(), output, message_);
  }
  bool is_reals() const { return data_->tag == Tag::kReals; }
  inline void GetRealsDataView(
      mojo::ArrayDataView<double>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadReals(UserType* output) const {
    
    CHECK(is_reals());
    return mojo::internal::Deserialize<mojo::ArrayDataView<double>>(
        data_->data.f_reals.Get(), output, message_);
  }

 private:
  internal::GesturePropValue_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // ui::ozone::mojom

#endif  // UI_OZONE_PUBLIC_MOJOM_GESTURE_PROPERTIES_SERVICE_MOJOM_DATA_VIEW_H_