/* src/bazaar.p/bz-hook.h
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#pragma once

#include <glib-object.h>
#include <gtk/gtk.h>
#include "bz-hook-dialog.h"

G_BEGIN_DECLS

typedef enum
{
  BZ_HOOK_SIGNAL_BEFORE_TRANSACTION,
  BZ_HOOK_SIGNAL_AFTER_TRANSACTION,
} BzHookSignal;
GType bz_hook_signal_get_type (void);
#define BZ_TYPE_HOOK_SIGNAL (bz_hook_signal_get_type ())

#define BZ_TYPE_HOOK (bz_hook_get_type ())
G_DECLARE_FINAL_TYPE (BzHook, bz_hook, BZ, HOOK, GObject)

BzHook *
bz_hook_new (void);

const char *
bz_hook_get_id (BzHook *self);

BzHookSignal
bz_hook_get_when (BzHook *self);

GListModel *
bz_hook_get_dialogs (BzHook *self);

const char *
bz_hook_get_shell (BzHook *self);

void
bz_hook_set_id (BzHook *self,
    const char *id);

void
bz_hook_set_when (BzHook *self,
    BzHookSignal when);

void
bz_hook_set_dialogs (BzHook *self,
    GListModel *dialogs);

void
bz_hook_set_shell (BzHook *self,
    const char *shell);

G_END_DECLS

/* End of src/bazaar.p/bz-hook.h */
