/* osdkeys.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from osdkeys.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <pulse/pulseaudio.h>
#include <gvc-mixer-control.h>
#include <gvc-mixer-stream.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_SHOW_OSD (budgie_show_osd_get_type ())
#define BUDGIE_SHOW_OSD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SHOW_OSD, BudgieShowOSD))
#define BUDGIE_IS_SHOW_OSD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SHOW_OSD))
#define BUDGIE_SHOW_OSD_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BUDGIE_TYPE_SHOW_OSD, BudgieShowOSDIface))

typedef struct _BudgieShowOSD BudgieShowOSD;
typedef struct _BudgieShowOSDIface BudgieShowOSDIface;

#define BUDGIE_TYPE_SHOW_OSD_PROXY (budgie_show_osd_proxy_get_type ())
typedef GDBusProxy BudgieShowOSDProxy;
typedef GDBusProxyClass BudgieShowOSDProxyClass;
typedef struct _budgie_show_osd_ShowReadyData budgie_show_osd_ShowReadyData;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define BUDGIE_TYPE_OSD_KEYS (budgie_osd_keys_get_type ())
#define BUDGIE_OSD_KEYS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_OSD_KEYS, BudgieOSDKeys))
#define BUDGIE_OSD_KEYS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_OSD_KEYS, BudgieOSDKeysClass))
#define BUDGIE_IS_OSD_KEYS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_OSD_KEYS))
#define BUDGIE_IS_OSD_KEYS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_OSD_KEYS))
#define BUDGIE_OSD_KEYS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_OSD_KEYS, BudgieOSDKeysClass))

typedef struct _BudgieOSDKeys BudgieOSDKeys;
typedef struct _BudgieOSDKeysClass BudgieOSDKeysClass;
typedef struct _BudgieOSDKeysPrivate BudgieOSDKeysPrivate;

#define BUDGIE_TYPE_BRIGHTNESS_MANAGER (budgie_brightness_manager_get_type ())
#define BUDGIE_BRIGHTNESS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_BRIGHTNESS_MANAGER, BudgieBrightnessManager))
#define BUDGIE_BRIGHTNESS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_BRIGHTNESS_MANAGER, BudgieBrightnessManagerClass))
#define BUDGIE_IS_BRIGHTNESS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_BRIGHTNESS_MANAGER))
#define BUDGIE_IS_BRIGHTNESS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_BRIGHTNESS_MANAGER))
#define BUDGIE_BRIGHTNESS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_BRIGHTNESS_MANAGER, BudgieBrightnessManagerClass))

typedef struct _BudgieBrightnessManager BudgieBrightnessManager;
typedef struct _BudgieBrightnessManagerClass BudgieBrightnessManagerClass;
enum  {
	BUDGIE_OSD_KEYS_0_PROPERTY,
	BUDGIE_OSD_KEYS_NUM_PROPERTIES
};
static GParamSpec* budgie_osd_keys_properties[BUDGIE_OSD_KEYS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BudgieOsdKeysSetupOsdProxyData BudgieOsdKeysSetupOsdProxyData;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _BudgieShowOSDIface {
	GTypeInterface parent_iface;
	void (*Show) (BudgieShowOSD* self, GHashTable* params, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*Show_finish) (BudgieShowOSD* self, GAsyncResult* _res_, GError** error);
};

struct _budgie_show_osd_ShowReadyData {
	GDBusMethodInvocation* _invocation_;
	GHashTable* params;
};

struct _BudgieOSDKeys {
	GObject parent_instance;
	BudgieOSDKeysPrivate * priv;
};

struct _BudgieOSDKeysClass {
	GObjectClass parent_class;
};

struct _BudgieOSDKeysPrivate {
	BudgieShowOSD* osd;
	BudgieBrightnessManager* brightness_manager;
	GdkKeymap* map;
	gboolean capslock;
	gboolean numlock;
	gboolean firstrun;
	GvcMixerControl* mixer;
	GvcMixerStream* stream;
	gulong notify_id;
	GSettings* wm_settings;
	gboolean caffeine_was_enabled;
	gboolean initialising;
};

struct _BudgieOsdKeysSetupOsdProxyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BudgieOSDKeys* self;
	gint retry_count;
	BudgieShowOSD* _tmp0_;
	BudgieShowOSD* _tmp1_;
	BudgieShowOSD* _tmp2_;
	GError* e;
	gint _tmp3_;
	GError* _tmp4_;
	const gchar* _tmp5_;
	GError* _tmp6_;
	const gchar* _tmp7_;
	GError* _inner_error0_;
};

static gint BudgieOSDKeys_private_offset;
static gpointer budgie_osd_keys_parent_class = NULL;

VALA_EXTERN GType budgie_show_osd_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint budgie_show_osd_register_object (void* object,
                                       GDBusConnection* connection,
                                       const gchar* path,
                                       GError** error);
VALA_EXTERN GType budgie_show_osd_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieShowOSD, g_object_unref)
VALA_EXTERN void budgie_show_osd_Show (BudgieShowOSD* self,
                           GHashTable* params,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_);
VALA_EXTERN void budgie_show_osd_Show_finish (BudgieShowOSD* self,
                                  GAsyncResult* _res_,
                                  GError** error);
static GType budgie_show_osd_get_type_once (void);
static void budgie_show_osd_proxy_g_signal (GDBusProxy* proxy,
                                     const gchar* sender_name,
                                     const gchar* signal_name,
                                     GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object,
                                   GAsyncResult *res,
                                   void *user_data);
static void budgie_show_osd_proxy_Show_async (BudgieShowOSD* self,
                                       GHashTable* params,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
static void budgie_show_osd_proxy_Show_finish (BudgieShowOSD* self,
                                        GAsyncResult* _res_,
                                        GError** error);
static void budgie_show_osd_proxy_budgie_show_osd_interface_init (BudgieShowOSDIface* iface);
static void _dbus_budgie_show_osd_Show (BudgieShowOSD* self,
                                 GVariant* _parameters_,
                                 GDBusMethodInvocation* invocation);
static void _dbus_budgie_show_osd_Show_ready (GObject * source_object,
                                       GAsyncResult * _res_,
                                       gpointer _user_data_);
static void budgie_show_osd_dbus_interface_method_call (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* method_name,
                                                 GVariant* parameters,
                                                 GDBusMethodInvocation* invocation,
                                                 gpointer user_data);
static GVariant* budgie_show_osd_dbus_interface_get_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GError** error,
                                                       gpointer user_data);
static gboolean budgie_show_osd_dbus_interface_set_property (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* property_name,
                                                      GVariant* value,
                                                      GError** error,
                                                      gpointer user_data);
static void _budgie_show_osd_unregister_object (gpointer user_data);
VALA_EXTERN GType budgie_osd_keys_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieOSDKeys, g_object_unref)
VALA_EXTERN GType budgie_brightness_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieBrightnessManager, g_object_unref)
static void budgie_osd_keys_setup_osd_proxy_data_free (gpointer _data);
static void budgie_osd_keys_setup_osd_proxy (BudgieOSDKeys* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static void budgie_osd_keys_setup_osd_proxy_finish (BudgieOSDKeys* self,
                                             GAsyncResult* _res_);
static gboolean budgie_osd_keys_setup_osd_proxy_co (BudgieOsdKeysSetupOsdProxyData* _data_);
static void budgie_osd_keys_setup_osd_proxy_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static gboolean ____lambda39_ (BudgieOSDKeys* self);
static gboolean _____lambda39__gsource_func (gpointer self);
VALA_EXTERN BudgieOSDKeys* budgie_osd_keys_new (void);
VALA_EXTERN BudgieOSDKeys* budgie_osd_keys_construct (GType object_type);
VALA_EXTERN BudgieBrightnessManager* budgie_brightness_manager_new (void);
VALA_EXTERN BudgieBrightnessManager* budgie_brightness_manager_construct (GType object_type);
static void __lambda40_ (BudgieOSDKeys* self);
VALA_EXTERN gboolean budgie_brightness_manager_is_available (BudgieBrightnessManager* self);
static void budgie_osd_keys_on_brightness_changed (BudgieOSDKeys* self,
                                            gdouble level);
static void _budgie_osd_keys_on_brightness_changed_budgie_brightness_manager_brightness_changed (BudgieBrightnessManager* _sender,
                                                                                          gdouble level,
                                                                                          gpointer self);
static void ___lambda40__budgie_brightness_manager_ready (BudgieBrightnessManager* _sender,
                                                   gpointer self);
VALA_EXTERN gboolean budgie_brightness_manager_get_is_ready (BudgieBrightnessManager* self);
static void budgie_osd_keys_on_mixer_state_change (BudgieOSDKeys* self,
                                            guint new_state);
static void _budgie_osd_keys_on_mixer_state_change_gvc_mixer_control_state_changed (GvcMixerControl* _sender,
                                                                             guint new_state,
                                                                             gpointer self);
static void budgie_osd_keys_on_mixer_sink_changed (BudgieOSDKeys* self,
                                            guint id);
static void _budgie_osd_keys_on_mixer_sink_changed_gvc_mixer_control_default_sink_changed (GvcMixerControl* _sender,
                                                                                    guint id,
                                                                                    gpointer self);
static gboolean __lambda49_ (BudgieOSDKeys* self);
static void budgie_osd_keys_on_keymap_state_changed (BudgieOSDKeys* self);
static void _budgie_osd_keys_on_keymap_state_changed_gdk_keymap_state_changed (GdkKeymap* _sender,
                                                                        gpointer self);
static gboolean ___lambda49__gsource_func (gpointer self);
static void budgie_osd_keys_on_caffeine_mode (BudgieOSDKeys* self);
static void _budgie_osd_keys_on_caffeine_mode_g_settings_changed (GSettings* _sender,
                                                           const gchar* key,
                                                           gpointer self);
VALA_EXTERN gboolean budgie_screenlock_get_is_dimming (void);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
static gboolean __lambda50_ (BudgieOSDKeys* self);
static gboolean ___lambda50__gsource_func (gpointer self);
static void budgie_osd_keys_set_default_mixer (BudgieOSDKeys* self);
static void budgie_osd_keys_on_stream_notify (BudgieOSDKeys* self,
                                       GObject* o,
                                       GParamSpec* p);
static void _budgie_osd_keys_on_stream_notify_g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self);
static void budgie_osd_keys_update_volume (BudgieOSDKeys* self);
static void budgie_osd_keys_finalize (GObject * obj);
static GType budgie_osd_keys_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const GDBusArgInfo _budgie_show_osd_dbus_arg_info_Show_params = {-1, "params", "a{sv}", NULL};
static const GDBusArgInfo * const _budgie_show_osd_dbus_arg_info_Show_in[] = {&_budgie_show_osd_dbus_arg_info_Show_params, NULL};
static const GDBusArgInfo * const _budgie_show_osd_dbus_arg_info_Show_out[] = {NULL};
static const GDBusMethodInfo _budgie_show_osd_dbus_method_info_Show = {-1, "Show", (GDBusArgInfo **) (&_budgie_show_osd_dbus_arg_info_Show_in), (GDBusArgInfo **) (&_budgie_show_osd_dbus_arg_info_Show_out), NULL};
static const GDBusMethodInfo * const _budgie_show_osd_dbus_method_info[] = {&_budgie_show_osd_dbus_method_info_Show, NULL};
static const GDBusSignalInfo * const _budgie_show_osd_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _budgie_show_osd_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_show_osd_dbus_interface_info = {-1, "org.budgie_desktop.BudgieOSD", (GDBusMethodInfo **) (&_budgie_show_osd_dbus_method_info), (GDBusSignalInfo **) (&_budgie_show_osd_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_show_osd_dbus_property_info), NULL};
static const GDBusInterfaceVTable _budgie_show_osd_dbus_interface_vtable = {budgie_show_osd_dbus_interface_method_call, budgie_show_osd_dbus_interface_get_property, budgie_show_osd_dbus_interface_set_property};

void
budgie_show_osd_Show (BudgieShowOSD* self,
                      GHashTable* params,
                      GAsyncReadyCallback _callback_,
                      gpointer _user_data_)
{
	BudgieShowOSDIface* _iface_;
	_iface_ = BUDGIE_SHOW_OSD_GET_INTERFACE (self);
	if (_iface_->Show) {
		_iface_->Show (self, params, _callback_, _user_data_);
	}
}

void
budgie_show_osd_Show_finish (BudgieShowOSD* self,
                             GAsyncResult* _res_,
                             GError** error)
{
	BudgieShowOSDIface* _iface_;
	_iface_ = BUDGIE_SHOW_OSD_GET_INTERFACE (self);
	if (_iface_->Show_finish) {
		_iface_->Show_finish (self, _res_, error);
	}
}

static void
budgie_show_osd_default_init (BudgieShowOSDIface * iface,
                              gpointer iface_data)
{
}

static GType
budgie_show_osd_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieShowOSDIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_show_osd_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType budgie_show_osd_type_id;
	budgie_show_osd_type_id = g_type_register_static (G_TYPE_INTERFACE, "BudgieShowOSD", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (budgie_show_osd_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (budgie_show_osd_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) budgie_show_osd_proxy_get_type);
	g_type_set_qdata (budgie_show_osd_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.budgie_desktop.BudgieOSD");
	g_type_set_qdata (budgie_show_osd_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_budgie_show_osd_dbus_interface_info));
	g_type_set_qdata (budgie_show_osd_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_show_osd_register_object);
	return budgie_show_osd_type_id;
}

GType
budgie_show_osd_get_type (void)
{
	static volatile gsize budgie_show_osd_type_id__once = 0;
	if (g_once_init_enter (&budgie_show_osd_type_id__once)) {
		GType budgie_show_osd_type_id;
		budgie_show_osd_type_id = budgie_show_osd_get_type_once ();
		g_once_init_leave (&budgie_show_osd_type_id__once, budgie_show_osd_type_id);
	}
	return budgie_show_osd_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (BudgieShowOSDProxy, budgie_show_osd_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (BUDGIE_TYPE_SHOW_OSD, budgie_show_osd_proxy_budgie_show_osd_interface_init) )
static void
budgie_show_osd_proxy_class_init (BudgieShowOSDProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = budgie_show_osd_proxy_g_signal;
}

static void
budgie_show_osd_proxy_g_signal (GDBusProxy* proxy,
                                const gchar* sender_name,
                                const gchar* signal_name,
                                GVariant* parameters)
{
}

static void
budgie_show_osd_proxy_init (BudgieShowOSDProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_budgie_show_osd_dbus_interface_info));
}

static void
_vala_g_async_ready_callback (GObject *source_object,
                              GAsyncResult *res,
                              void *user_data)
{
	g_task_return_pointer (user_data, g_object_ref (res), g_object_unref);
	g_object_unref (user_data);
}

static void
budgie_show_osd_proxy_Show_async (BudgieShowOSD* self,
                                  GHashTable* params,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp78_;
	GHashTableIter _tmp79_;
	gpointer _tmp80_;
	gpointer _tmp81_;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.budgie_desktop.BudgieOSD", "Show");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_hash_table_iter_init (&_tmp79_, params);
	g_variant_builder_init (&_tmp78_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp79_, &_tmp80_, &_tmp81_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp80_;
		_value = (GVariant*) _tmp81_;
		g_variant_builder_add (&_tmp78_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp78_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
budgie_show_osd_proxy_Show_finish (BudgieShowOSD* self,
                                   GAsyncResult* _res_,
                                   GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
budgie_show_osd_proxy_budgie_show_osd_interface_init (BudgieShowOSDIface* iface)
{
	iface->Show = budgie_show_osd_proxy_Show_async;
	iface->Show_finish = budgie_show_osd_proxy_Show_finish;
}

static void
_dbus_budgie_show_osd_Show (BudgieShowOSD* self,
                            GVariant* _parameters_,
                            GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	budgie_show_osd_ShowReadyData* _ready_data;
	GVariant* _tmp82_;
	GHashTable* _tmp83_;
	GVariantIter _tmp84_;
	GVariant* _tmp85_;
	GVariant* _tmp86_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (budgie_show_osd_ShowReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp82_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp83_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp84_, _tmp82_);
	while (g_variant_iter_loop (&_tmp84_, "{?*}", &_tmp85_, &_tmp86_)) {
		g_hash_table_insert (_tmp83_, g_variant_dup_string (_tmp85_, NULL), g_variant_get_variant (_tmp86_));
	}
	_ready_data->params = _tmp83_;
	g_variant_unref (_tmp82_);
	budgie_show_osd_Show (self, _ready_data->params, (GAsyncReadyCallback) _dbus_budgie_show_osd_Show_ready, _ready_data);
	_error:
	;
}

static void
_dbus_budgie_show_osd_Show_ready (GObject * source_object,
                                  GAsyncResult * _res_,
                                  gpointer _user_data_)
{
	budgie_show_osd_ShowReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	budgie_show_osd_Show_finish ((BudgieShowOSD*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_hash_table_unref0 (_ready_data->params);
	g_slice_free (budgie_show_osd_ShowReadyData, _ready_data);
}

static void
budgie_show_osd_dbus_interface_method_call (GDBusConnection* connection,
                                            const gchar* sender,
                                            const gchar* object_path,
                                            const gchar* interface_name,
                                            const gchar* method_name,
                                            GVariant* parameters,
                                            GDBusMethodInvocation* invocation,
                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Show") == 0) {
		_dbus_budgie_show_osd_Show (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
budgie_show_osd_dbus_interface_get_property (GDBusConnection* connection,
                                             const gchar* sender,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* property_name,
                                             GError** error,
                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
budgie_show_osd_dbus_interface_set_property (GDBusConnection* connection,
                                             const gchar* sender,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* property_name,
                                             GVariant* value,
                                             GError** error,
                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
budgie_show_osd_register_object (gpointer object,
                                 GDBusConnection* connection,
                                 const gchar* path,
                                 GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_show_osd_dbus_interface_info), &_budgie_show_osd_dbus_interface_vtable, data, _budgie_show_osd_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_budgie_show_osd_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
budgie_osd_keys_get_instance_private (BudgieOSDKeys* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieOSDKeys_private_offset);
}

static void
budgie_osd_keys_setup_osd_proxy_data_free (gpointer _data)
{
	BudgieOsdKeysSetupOsdProxyData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BudgieOsdKeysSetupOsdProxyData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
budgie_osd_keys_setup_osd_proxy (BudgieOSDKeys* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	BudgieOsdKeysSetupOsdProxyData* _data_;
	BudgieOSDKeys* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BudgieOsdKeysSetupOsdProxyData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, budgie_osd_keys_setup_osd_proxy_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	budgie_osd_keys_setup_osd_proxy_co (_data_);
}

static void
budgie_osd_keys_setup_osd_proxy_finish (BudgieOSDKeys* self,
                                        GAsyncResult* _res_)
{
	BudgieOsdKeysSetupOsdProxyData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
 * Set up connection to OSD service with retry logic
 */
static void
budgie_osd_keys_setup_osd_proxy_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	BudgieOsdKeysSetupOsdProxyData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	budgie_osd_keys_setup_osd_proxy_co (_data_);
}

static gboolean
____lambda39_ (BudgieOSDKeys* self)
{
	gboolean result;
	budgie_osd_keys_setup_osd_proxy (self, NULL, NULL);
	result = FALSE;
	return result;
}

static gboolean
_____lambda39__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda39_ ((BudgieOSDKeys*) self);
	return result;
}

static gboolean
budgie_osd_keys_setup_osd_proxy_co (BudgieOsdKeysSetupOsdProxyData* _data_)
{
	static const gint MAX_RETRIES = 10;
	static const gint RETRY_DELAY_MS = 1000;
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->retry_count = 0;
	while (TRUE) {
		if (!(_data_->retry_count < MAX_RETRIES)) {
			break;
		}
		{
			g_debug ("osdkeys.vala:61: Attempting to connect to BudgieOSD service (attempt %" \
"d/%d)", _data_->retry_count + 1, MAX_RETRIES);
			_data_->_state_ = 1;
			g_async_initable_new_async (BUDGIE_TYPE_SHOW_OSD_PROXY, 0, NULL, budgie_osd_keys_setup_osd_proxy_ready, _data_, "g-flags", 0, "g-name", "org.budgie_desktop.BudgieOSD", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/budgie_desktop/BudgieOSD", "g-interface-name", "org.budgie_desktop.BudgieOSD", NULL);
			return FALSE;
			_state_1:
			_data_->_tmp1_ = (BudgieShowOSD*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp0_ = (BudgieShowOSD*) _data_->_tmp1_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp2_ = _data_->_tmp0_;
			_data_->_tmp0_ = NULL;
			_g_object_unref0 (_data_->self->priv->osd);
			_data_->self->priv->osd = _data_->_tmp2_;
			g_debug ("osdkeys.vala:70: Successfully connected to BudgieOSD service");
			_g_object_unref0 (_data_->_tmp0_);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp3_ = _data_->retry_count;
			_data_->retry_count = _data_->_tmp3_ + 1;
			if (_data_->retry_count >= MAX_RETRIES) {
				_data_->_tmp4_ = _data_->e;
				_data_->_tmp5_ = _data_->_tmp4_->message;
				g_warning ("osdkeys.vala:76: Failed to connect to BudgieOSD after %d attempts: %s", MAX_RETRIES, _data_->_tmp5_);
				_g_error_free0 (_data_->e);
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
				if (_data_->_state_ != 0) {
					while (!g_task_get_completed (_data_->_async_result)) {
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
					}
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp6_ = _data_->e;
			_data_->_tmp7_ = _data_->_tmp6_->message;
			g_warning ("osdkeys.vala:81: Failed to connect to BudgieOSD (attempt %d/%d): %s, r" \
"etrying...", _data_->retry_count, MAX_RETRIES, _data_->_tmp7_);
			g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) RETRY_DELAY_MS, _____lambda39__gsource_func, g_object_ref (_data_->self), g_object_unref);
			_g_error_free0 (_data_->e);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		__finally0:
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_budgie_osd_keys_on_brightness_changed_budgie_brightness_manager_brightness_changed (BudgieBrightnessManager* _sender,
                                                                                     gdouble level,
                                                                                     gpointer self)
{
	budgie_osd_keys_on_brightness_changed ((BudgieOSDKeys*) self, level);
}

static void
__lambda40_ (BudgieOSDKeys* self)
{
	BudgieBrightnessManager* _tmp0_;
	g_debug ("osdkeys.vala:106: BrightnessManager is ready");
	_tmp0_ = self->priv->brightness_manager;
	if (budgie_brightness_manager_is_available (_tmp0_)) {
		BudgieBrightnessManager* _tmp1_;
		_tmp1_ = self->priv->brightness_manager;
		g_signal_connect_object (_tmp1_, "brightness-changed", (GCallback) _budgie_osd_keys_on_brightness_changed_budgie_brightness_manager_brightness_changed, self, 0);
		g_debug ("osdkeys.vala:109: Connected to brightness_changed signal");
	} else {
		g_warning ("osdkeys.vala:111: BrightnessManager not available after initialization");
	}
}

static void
___lambda40__budgie_brightness_manager_ready (BudgieBrightnessManager* _sender,
                                              gpointer self)
{
	__lambda40_ ((BudgieOSDKeys*) self);
}

static void
_budgie_osd_keys_on_mixer_state_change_gvc_mixer_control_state_changed (GvcMixerControl* _sender,
                                                                        guint new_state,
                                                                        gpointer self)
{
	budgie_osd_keys_on_mixer_state_change ((BudgieOSDKeys*) self, new_state);
}

static void
_budgie_osd_keys_on_mixer_sink_changed_gvc_mixer_control_default_sink_changed (GvcMixerControl* _sender,
                                                                               guint id,
                                                                               gpointer self)
{
	budgie_osd_keys_on_mixer_sink_changed ((BudgieOSDKeys*) self, id);
}

static void
_budgie_osd_keys_on_keymap_state_changed_gdk_keymap_state_changed (GdkKeymap* _sender,
                                                                   gpointer self)
{
	budgie_osd_keys_on_keymap_state_changed ((BudgieOSDKeys*) self);
}

static gboolean
__lambda49_ (BudgieOSDKeys* self)
{
	GdkDisplay* _tmp0_;
	GdkKeymap* _tmp1_;
	GdkKeymap* _tmp2_;
	gboolean result;
	self->priv->initialising = FALSE;
	g_debug ("osdkeys.vala:133: Initialization complete");
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = gdk_keymap_get_for_display (_tmp0_);
	self->priv->map = _tmp1_;
	_tmp2_ = self->priv->map;
	g_signal_connect_object (_tmp2_, "state-changed", (GCallback) _budgie_osd_keys_on_keymap_state_changed_gdk_keymap_state_changed, self, 0);
	result = FALSE;
	return result;
}

static gboolean
___lambda49__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda49_ ((BudgieOSDKeys*) self);
	return result;
}

static void
_budgie_osd_keys_on_caffeine_mode_g_settings_changed (GSettings* _sender,
                                                      const gchar* key,
                                                      gpointer self)
{
	budgie_osd_keys_on_caffeine_mode ((BudgieOSDKeys*) self);
}

BudgieOSDKeys*
budgie_osd_keys_construct (GType object_type)
{
	BudgieOSDKeys * self = NULL;
	BudgieBrightnessManager* _tmp0_;
	BudgieBrightnessManager* _tmp1_;
	BudgieBrightnessManager* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GvcMixerControl* _tmp7_;
	GvcMixerControl* _tmp8_;
	GvcMixerControl* _tmp9_;
	GvcMixerControl* _tmp10_;
	GSettings* _tmp11_;
	GSettings* _tmp12_;
	self = (BudgieOSDKeys*) g_object_new (object_type, NULL);
	self->priv->initialising = TRUE;
	budgie_osd_keys_setup_osd_proxy (self, NULL, NULL);
	g_debug ("osdkeys.vala:101: Creating BrightnessManager...");
	_tmp0_ = budgie_brightness_manager_new ();
	_g_object_unref0 (self->priv->brightness_manager);
	self->priv->brightness_manager = _tmp0_;
	_tmp1_ = self->priv->brightness_manager;
	g_signal_connect_object (_tmp1_, "ready", (GCallback) ___lambda40__budgie_brightness_manager_ready, self, 0);
	_tmp2_ = self->priv->brightness_manager;
	_tmp3_ = budgie_brightness_manager_get_is_ready (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		BudgieBrightnessManager* _tmp5_;
		g_debug ("osdkeys.vala:117: BrightnessManager already ready");
		_tmp5_ = self->priv->brightness_manager;
		if (budgie_brightness_manager_is_available (_tmp5_)) {
			BudgieBrightnessManager* _tmp6_;
			_tmp6_ = self->priv->brightness_manager;
			g_signal_connect_object (_tmp6_, "brightness-changed", (GCallback) _budgie_osd_keys_on_brightness_changed_budgie_brightness_manager_brightness_changed, self, 0);
			g_debug ("osdkeys.vala:120: Connected to brightness_changed signal");
		}
	}
	_tmp7_ = gvc_mixer_control_new ("BD Volume Mixer");
	_g_object_unref0 (self->priv->mixer);
	self->priv->mixer = _tmp7_;
	_tmp8_ = self->priv->mixer;
	g_signal_connect_object (_tmp8_, "state-changed", (GCallback) _budgie_osd_keys_on_mixer_state_change_gvc_mixer_control_state_changed, self, 0);
	_tmp9_ = self->priv->mixer;
	g_signal_connect_object (_tmp9_, "default-sink-changed", (GCallback) _budgie_osd_keys_on_mixer_sink_changed_gvc_mixer_control_default_sink_changed, self, 0);
	_tmp10_ = self->priv->mixer;
	gvc_mixer_control_open (_tmp10_);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, ___lambda49__gsource_func, g_object_ref (self), g_object_unref);
	_tmp11_ = g_settings_new ("com.solus-project.budgie-wm");
	_g_object_unref0 (self->priv->wm_settings);
	self->priv->wm_settings = _tmp11_;
	_tmp12_ = self->priv->wm_settings;
	g_signal_connect_object (_tmp12_, "changed::caffeine-mode", (GCallback) _budgie_osd_keys_on_caffeine_mode_g_settings_changed, self, 0);
	return self;
}

BudgieOSDKeys*
budgie_osd_keys_new (void)
{
	return budgie_osd_keys_construct (BUDGIE_TYPE_OSD_KEYS);
}

/**
 * Called when brightness changes
 */
static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_variant_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}

static void
budgie_osd_keys_on_brightness_changed (BudgieOSDKeys* self,
                                       gdouble level)
{
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	gboolean _tmp3_;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	BudgieShowOSD* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	BudgieShowOSD* _tmp11_;
	gchar* icon = NULL;
	gchar* _tmp12_;
	GHashTable* params = NULL;
	GHashTable* _tmp15_;
	GHashTable* _tmp16_;
	gchar* _tmp17_;
	GVariant* _tmp18_;
	GHashTable* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	GVariant* _tmp22_;
	const gchar* _tmp23_;
	BudgieShowOSD* _tmp24_;
	GHashTable* _tmp25_;
	g_return_if_fail (self != NULL);
	if (self->priv->initialising) {
		_tmp0_ = "true";
	} else {
		_tmp0_ = "false";
	}
	_tmp2_ = budgie_screenlock_get_is_dimming ();
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp1_ = "true";
	} else {
		_tmp1_ = "false";
	}
	if (self->priv->caffeine_was_enabled) {
		_tmp4_ = "true";
	} else {
		_tmp4_ = "false";
	}
	_tmp6_ = self->priv->osd;
	if (_tmp6_ != NULL) {
		_tmp5_ = "connected";
	} else {
		_tmp5_ = "null";
	}
	g_debug ("osdkeys.vala:147: Brightness changed to %.2f%% (initialising=%s, dimmi" \
"ng=%s, caffeine=%s, osd=%s)", level * 100, _tmp0_, _tmp1_, _tmp4_, _tmp5_);
	if (self->priv->initialising) {
		_tmp8_ = TRUE;
	} else {
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp9_ = budgie_screenlock_get_is_dimming ();
		_tmp10_ = _tmp9_;
		_tmp8_ = _tmp10_;
	}
	if (_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		_tmp7_ = self->priv->caffeine_was_enabled;
	}
	if (_tmp7_) {
		g_warning ("osdkeys.vala:155: Skipping brightness OSD (initializing or dimming or " \
"caffeine)");
		return;
	}
	_tmp11_ = self->priv->osd;
	if (_tmp11_ == NULL) {
		g_warning ("osdkeys.vala:160: Skipping brightness OSD (OSD service not connected y" \
"et)");
		return;
	}
	_tmp12_ = g_strdup ("display-brightness-symbolic");
	icon = _tmp12_;
	if (level >= 0.9) {
		gchar* _tmp13_;
		_tmp13_ = g_strdup ("display-brightness-high-symbolic");
		_g_free0 (icon);
		icon = _tmp13_;
	} else {
		if (level <= 0.1) {
			gchar* _tmp14_;
			_tmp14_ = g_strdup ("display-brightness-low-symbolic");
			_g_free0 (icon);
			icon = _tmp14_;
		}
	}
	_tmp15_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_variant_unref0_);
	_g_hash_table_unref0 (params);
	params = _tmp15_;
	_tmp16_ = params;
	_tmp17_ = g_strdup ("level");
	_tmp18_ = g_variant_new_double (level);
	g_variant_ref_sink (_tmp18_);
	g_hash_table_insert (_tmp16_, _tmp17_, _tmp18_);
	_tmp19_ = params;
	_tmp20_ = g_strdup ("icon");
	_tmp21_ = icon;
	_tmp22_ = g_variant_new_string (_tmp21_);
	g_variant_ref_sink (_tmp22_);
	g_hash_table_insert (_tmp19_, _tmp20_, _tmp22_);
	_tmp23_ = icon;
	g_debug ("osdkeys.vala:176: Showing brightness OSD with icon=%s, level=%.2f", _tmp23_, level);
	_tmp24_ = self->priv->osd;
	_tmp25_ = params;
	budgie_show_osd_Show (_tmp24_, _tmp25_, NULL, NULL);
	_g_hash_table_unref0 (params);
	_g_free0 (icon);
}

static gboolean
__lambda50_ (BudgieOSDKeys* self)
{
	gboolean result;
	self->priv->caffeine_was_enabled = FALSE;
	g_debug ("osdkeys.vala:198: Caffeine mode fully disabled");
	result = FALSE;
	return result;
}

static gboolean
___lambda50__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda50_ ((BudgieOSDKeys*) self);
	return result;
}

static void
budgie_osd_keys_on_caffeine_mode (BudgieOSDKeys* self)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->wm_settings;
	if (g_settings_get_boolean (_tmp0_, "caffeine-mode")) {
		self->priv->caffeine_was_enabled = TRUE;
		g_debug ("osdkeys.vala:187: Caffeine mode enabled");
		return;
	}
	g_debug ("osdkeys.vala:195: Caffeine mode disabled, waiting for events to settle" \
"...");
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1000, ___lambda50__gsource_func, g_object_ref (self), g_object_unref);
}

static void
budgie_osd_keys_on_mixer_sink_changed (BudgieOSDKeys* self,
                                       guint id)
{
	g_return_if_fail (self != NULL);
	budgie_osd_keys_set_default_mixer (self);
}

static void
_budgie_osd_keys_on_stream_notify_g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self)
{
	budgie_osd_keys_on_stream_notify ((BudgieOSDKeys*) self, _sender, pspec);
}

static void
budgie_osd_keys_set_default_mixer (BudgieOSDKeys* self)
{
	GvcMixerStream* _tmp0_;
	GvcMixerControl* _tmp2_;
	GvcMixerStream* _tmp3_;
	GvcMixerStream* _tmp4_;
	GvcMixerStream* _tmp5_;
	gulong _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stream;
	if (_tmp0_ != NULL) {
		GvcMixerStream* _tmp1_;
		_tmp1_ = self->priv->stream;
		g_signal_handler_disconnect (_tmp1_, self->priv->notify_id);
	}
	_tmp2_ = self->priv->mixer;
	_tmp3_ = gvc_mixer_control_get_default_sink (_tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->stream);
	self->priv->stream = _tmp4_;
	_tmp5_ = self->priv->stream;
	_tmp6_ = g_signal_connect_object ((GObject*) _tmp5_, "notify", (GCallback) _budgie_osd_keys_on_stream_notify_g_object_notify, self, 0);
	self->priv->notify_id = _tmp6_;
	budgie_osd_keys_update_volume (self);
}

static void
budgie_osd_keys_on_stream_notify (BudgieOSDKeys* self,
                                  GObject* o,
                                  GParamSpec* p)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = p->name;
	if (g_strcmp0 (_tmp1_, "volume") == 0) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = p->name;
		_tmp0_ = g_strcmp0 (_tmp2_, "is-muted") == 0;
	}
	if (_tmp0_) {
		budgie_osd_keys_update_volume (self);
	}
}

/**
 * Called when something changes on the mixer, i.e. we connected
 * This is where we hook into the stream for changes
 */
static void
budgie_osd_keys_on_mixer_state_change (BudgieOSDKeys* self,
                                       guint new_state)
{
	g_return_if_fail (self != NULL);
	if (new_state == ((guint) GVC_STATE_READY)) {
		budgie_osd_keys_set_default_mixer (self);
	}
}

/**
* Update the OSD when something changes (volume/mute)
*/
static void
budgie_osd_keys_update_volume (BudgieOSDKeys* self)
{
	BudgieShowOSD* _tmp0_;
	gdouble vol_norm = 0.0;
	GvcMixerControl* _tmp1_;
	guint32 vol = 0U;
	GvcMixerStream* _tmp2_;
	gint n = 0;
	gchar* image_name = NULL;
	gboolean _tmp3_ = FALSE;
	GvcMixerStream* _tmp4_;
	gfloat pct = 0.0F;
	gboolean _tmp9_ = FALSE;
	GHashTable* params = NULL;
	GHashTable* _tmp12_;
	GHashTable* _tmp13_;
	gchar* _tmp14_;
	GVariant* _tmp15_;
	GHashTable* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	GVariant* _tmp19_;
	BudgieShowOSD* _tmp20_;
	GHashTable* _tmp21_;
	g_return_if_fail (self != NULL);
	if (self->priv->initialising) {
		return;
	}
	_tmp0_ = self->priv->osd;
	if (_tmp0_ == NULL) {
		g_warning ("osdkeys.vala:240: Skipping volume OSD (OSD service not connected yet)");
		return;
	}
	_tmp1_ = self->priv->mixer;
	vol_norm = gvc_mixer_control_get_vol_max_norm (_tmp1_);
	_tmp2_ = self->priv->stream;
	vol = gvc_mixer_stream_get_volume (_tmp2_);
	n = ((gint) floor ((3 * vol) / vol_norm)) + 1;
	_tmp4_ = self->priv->stream;
	if (gvc_mixer_stream_get_is_muted (_tmp4_)) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = vol <= ((guint32) 0);
	}
	if (_tmp3_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("audio-volume-muted-symbolic");
		_g_free0 (image_name);
		image_name = _tmp5_;
	} else {
		switch (n) {
			case 1:
			{
				gchar* _tmp6_;
				_tmp6_ = g_strdup ("audio-volume-low-symbolic");
				_g_free0 (image_name);
				image_name = _tmp6_;
				break;
			}
			case 2:
			{
				gchar* _tmp7_;
				_tmp7_ = g_strdup ("audio-volume-medium-symbolic");
				_g_free0 (image_name);
				image_name = _tmp7_;
				break;
			}
			default:
			{
				gchar* _tmp8_;
				_tmp8_ = g_strdup ("audio-volume-high-symbolic");
				_g_free0 (image_name);
				image_name = _tmp8_;
				break;
			}
		}
	}
	pct = ((gfloat) vol) / ((gfloat) vol_norm);
	if (((gdouble) pct) > 1.0) {
		GvcMixerStream* _tmp10_;
		_tmp10_ = self->priv->stream;
		_tmp9_ = !gvc_mixer_stream_get_is_muted (_tmp10_);
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gchar* _tmp11_;
		_tmp11_ = g_strdup ("audio-volume-overamplified-symbolic");
		_g_free0 (image_name);
		image_name = _tmp11_;
	}
	_tmp12_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_variant_unref0_);
	_g_hash_table_unref0 (params);
	params = _tmp12_;
	_tmp13_ = params;
	_tmp14_ = g_strdup ("level");
	_tmp15_ = g_variant_new_double ((gdouble) pct);
	g_variant_ref_sink (_tmp15_);
	g_hash_table_insert (_tmp13_, _tmp14_, _tmp15_);
	_tmp16_ = params;
	_tmp17_ = g_strdup ("icon");
	_tmp18_ = image_name;
	_tmp19_ = g_variant_new_string (_tmp18_);
	g_variant_ref_sink (_tmp19_);
	g_hash_table_insert (_tmp16_, _tmp17_, _tmp19_);
	_tmp20_ = self->priv->osd;
	_tmp21_ = params;
	budgie_show_osd_Show (_tmp20_, _tmp21_, NULL, NULL);
	_g_hash_table_unref0 (params);
	_g_free0 (image_name);
}

static void
budgie_osd_keys_on_keymap_state_changed (BudgieOSDKeys* self)
{
	BudgieShowOSD* _tmp2_;
	GHashTable* params = NULL;
	GHashTable* _tmp3_;
	gchar* caption = NULL;
	gchar* _tmp4_;
	gboolean skip = FALSE;
	GdkKeymap* _tmp5_;
	const gchar* _tmp26_;
	g_return_if_fail (self != NULL);
	if (!self->priv->firstrun) {
		GdkKeymap* _tmp0_;
		GdkKeymap* _tmp1_;
		_tmp0_ = self->priv->map;
		self->priv->capslock = gdk_keymap_get_caps_lock_state (_tmp0_);
		_tmp1_ = self->priv->map;
		self->priv->numlock = gdk_keymap_get_num_lock_state (_tmp1_);
		self->priv->firstrun = TRUE;
	}
	_tmp2_ = self->priv->osd;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_variant_unref0_);
	params = _tmp3_;
	_tmp4_ = g_strdup ("");
	caption = _tmp4_;
	skip = FALSE;
	_tmp5_ = self->priv->map;
	if (gdk_keymap_get_caps_lock_state (_tmp5_)) {
		if (!self->priv->capslock) {
			GHashTable* _tmp6_;
			gchar* _tmp7_;
			GVariant* _tmp8_;
			gchar* _tmp9_;
			GHashTable* _tmp10_;
			gchar* _tmp11_;
			GVariant* _tmp12_;
			_tmp6_ = params;
			_tmp7_ = g_strdup ("icon");
			_tmp8_ = g_variant_new_string ("caps-lock-symbolic");
			g_variant_ref_sink (_tmp8_);
			g_hash_table_insert (_tmp6_, _tmp7_, _tmp8_);
			_tmp9_ = g_strdup (_ ("Caps Lock is on"));
			_g_free0 (caption);
			caption = _tmp9_;
			_tmp10_ = params;
			_tmp11_ = g_strdup ("icon");
			_tmp12_ = g_variant_new_string ("caps-lock-on-symbolic");
			g_variant_ref_sink (_tmp12_);
			g_hash_table_insert (_tmp10_, _tmp11_, _tmp12_);
		}
		self->priv->capslock = TRUE;
		skip = TRUE;
	} else {
		if (self->priv->capslock) {
			gchar* _tmp13_;
			GHashTable* _tmp14_;
			gchar* _tmp15_;
			GVariant* _tmp16_;
			_tmp13_ = g_strdup (_ ("Caps Lock is off"));
			_g_free0 (caption);
			caption = _tmp13_;
			_tmp14_ = params;
			_tmp15_ = g_strdup ("icon");
			_tmp16_ = g_variant_new_string ("caps-lock-off-symbolic");
			g_variant_ref_sink (_tmp16_);
			g_hash_table_insert (_tmp14_, _tmp15_, _tmp16_);
		}
		self->priv->capslock = FALSE;
		skip = TRUE;
	}
	if (!skip) {
		GdkKeymap* _tmp17_;
		_tmp17_ = self->priv->map;
		if (gdk_keymap_get_num_lock_state (_tmp17_)) {
			if (!self->priv->numlock) {
				gchar* _tmp18_;
				GHashTable* _tmp19_;
				gchar* _tmp20_;
				GVariant* _tmp21_;
				_tmp18_ = g_strdup (_ ("Num Lock is on"));
				_g_free0 (caption);
				caption = _tmp18_;
				_tmp19_ = params;
				_tmp20_ = g_strdup ("icon");
				_tmp21_ = g_variant_new_string ("num-lock-on-symbolic");
				g_variant_ref_sink (_tmp21_);
				g_hash_table_insert (_tmp19_, _tmp20_, _tmp21_);
			}
			self->priv->numlock = TRUE;
		} else {
			if (self->priv->numlock) {
				gchar* _tmp22_;
				GHashTable* _tmp23_;
				gchar* _tmp24_;
				GVariant* _tmp25_;
				_tmp22_ = g_strdup (_ ("Num Lock is off"));
				_g_free0 (caption);
				caption = _tmp22_;
				_tmp23_ = params;
				_tmp24_ = g_strdup ("icon");
				_tmp25_ = g_variant_new_string ("num-lock-off-symbolic");
				g_variant_ref_sink (_tmp25_);
				g_hash_table_insert (_tmp23_, _tmp24_, _tmp25_);
			}
			self->priv->numlock = FALSE;
		}
	}
	_tmp26_ = caption;
	if (g_strcmp0 (_tmp26_, "") != 0) {
		GHashTable* _tmp27_;
		gchar* _tmp28_;
		const gchar* _tmp29_;
		GVariant* _tmp30_;
		BudgieShowOSD* _tmp31_;
		GHashTable* _tmp32_;
		_tmp27_ = params;
		_tmp28_ = g_strdup ("label");
		_tmp29_ = caption;
		_tmp30_ = g_variant_new_string (_tmp29_);
		g_variant_ref_sink (_tmp30_);
		g_hash_table_insert (_tmp27_, _tmp28_, _tmp30_);
		_tmp31_ = self->priv->osd;
		_tmp32_ = params;
		budgie_show_osd_Show (_tmp31_, _tmp32_, NULL, NULL);
	}
	_g_free0 (caption);
	_g_hash_table_unref0 (params);
}

static void
budgie_osd_keys_class_init (BudgieOSDKeysClass * klass,
                            gpointer klass_data)
{
	budgie_osd_keys_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieOSDKeys_private_offset);
	G_OBJECT_CLASS (klass)->finalize = budgie_osd_keys_finalize;
}

static void
budgie_osd_keys_instance_init (BudgieOSDKeys * self,
                               gpointer klass)
{
	self->priv = budgie_osd_keys_get_instance_private (self);
	self->priv->osd = NULL;
	self->priv->brightness_manager = NULL;
	self->priv->firstrun = FALSE;
	self->priv->wm_settings = NULL;
	self->priv->caffeine_was_enabled = FALSE;
}

static void
budgie_osd_keys_finalize (GObject * obj)
{
	BudgieOSDKeys * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_OSD_KEYS, BudgieOSDKeys);
	_g_object_unref0 (self->priv->osd);
	_g_object_unref0 (self->priv->brightness_manager);
	_g_object_unref0 (self->priv->mixer);
	_g_object_unref0 (self->priv->stream);
	_g_object_unref0 (self->priv->wm_settings);
	G_OBJECT_CLASS (budgie_osd_keys_parent_class)->finalize (obj);
}

static GType
budgie_osd_keys_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieOSDKeysClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_osd_keys_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieOSDKeys), 0, (GInstanceInitFunc) budgie_osd_keys_instance_init, NULL };
	GType budgie_osd_keys_type_id;
	budgie_osd_keys_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieOSDKeys", &g_define_type_info, 0);
	BudgieOSDKeys_private_offset = g_type_add_instance_private (budgie_osd_keys_type_id, sizeof (BudgieOSDKeysPrivate));
	return budgie_osd_keys_type_id;
}

GType
budgie_osd_keys_get_type (void)
{
	static volatile gsize budgie_osd_keys_type_id__once = 0;
	if (g_once_init_enter (&budgie_osd_keys_type_id__once)) {
		GType budgie_osd_keys_type_id;
		budgie_osd_keys_type_id = budgie_osd_keys_get_type_once ();
		g_once_init_leave (&budgie_osd_keys_type_id__once, budgie_osd_keys_type_id);
	}
	return budgie_osd_keys_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

