/* manager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from manager.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib-object.h>
#include <theme-manager.h>
#include "session.h"
#include "budgie-waylandclient.h"
#include <gio/gio.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_SERVICE_MANAGER (budgie_service_manager_get_type ())
#define BUDGIE_SERVICE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SERVICE_MANAGER, BudgieServiceManager))
#define BUDGIE_SERVICE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SERVICE_MANAGER, BudgieServiceManagerClass))
#define BUDGIE_IS_SERVICE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SERVICE_MANAGER))
#define BUDGIE_IS_SERVICE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SERVICE_MANAGER))
#define BUDGIE_SERVICE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SERVICE_MANAGER, BudgieServiceManagerClass))

typedef struct _BudgieServiceManager BudgieServiceManager;
typedef struct _BudgieServiceManagerClass BudgieServiceManagerClass;
typedef struct _BudgieServiceManagerPrivate BudgieServiceManagerPrivate;

#define BUDGIE_TYPE_OSD_MANAGER (budgie_osd_manager_get_type ())
#define BUDGIE_OSD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_OSD_MANAGER, BudgieOSDManager))
#define BUDGIE_OSD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_OSD_MANAGER, BudgieOSDManagerClass))
#define BUDGIE_IS_OSD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_OSD_MANAGER))
#define BUDGIE_IS_OSD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_OSD_MANAGER))
#define BUDGIE_OSD_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_OSD_MANAGER, BudgieOSDManagerClass))

typedef struct _BudgieOSDManager BudgieOSDManager;
typedef struct _BudgieOSDManagerClass BudgieOSDManagerClass;

#define BUDGIE_TYPE_OSD_KEYS (budgie_osd_keys_get_type ())
#define BUDGIE_OSD_KEYS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_OSD_KEYS, BudgieOSDKeys))
#define BUDGIE_OSD_KEYS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_OSD_KEYS, BudgieOSDKeysClass))
#define BUDGIE_IS_OSD_KEYS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_OSD_KEYS))
#define BUDGIE_IS_OSD_KEYS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_OSD_KEYS))
#define BUDGIE_OSD_KEYS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_OSD_KEYS, BudgieOSDKeysClass))

typedef struct _BudgieOSDKeys BudgieOSDKeys;
typedef struct _BudgieOSDKeysClass BudgieOSDKeysClass;

#define BUDGIE_NOTIFICATIONS_TYPE_SERVER (budgie_notifications_server_get_type ())
#define BUDGIE_NOTIFICATIONS_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_NOTIFICATIONS_TYPE_SERVER, BudgieNotificationsServer))
#define BUDGIE_NOTIFICATIONS_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_NOTIFICATIONS_TYPE_SERVER, BudgieNotificationsServerClass))
#define BUDGIE_NOTIFICATIONS_IS_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_NOTIFICATIONS_TYPE_SERVER))
#define BUDGIE_NOTIFICATIONS_IS_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_NOTIFICATIONS_TYPE_SERVER))
#define BUDGIE_NOTIFICATIONS_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_NOTIFICATIONS_TYPE_SERVER, BudgieNotificationsServerClass))

typedef struct _BudgieNotificationsServer BudgieNotificationsServer;
typedef struct _BudgieNotificationsServerClass BudgieNotificationsServerClass;

#define BUDGIE_STATUS_NOTIFIER_TYPE_FREEDESKTOP_WATCHER (budgie_status_notifier_freedesktop_watcher_get_type ())
#define BUDGIE_STATUS_NOTIFIER_FREEDESKTOP_WATCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_STATUS_NOTIFIER_TYPE_FREEDESKTOP_WATCHER, BudgieStatusNotifierFreedesktopWatcher))
#define BUDGIE_STATUS_NOTIFIER_FREEDESKTOP_WATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_STATUS_NOTIFIER_TYPE_FREEDESKTOP_WATCHER, BudgieStatusNotifierFreedesktopWatcherClass))
#define BUDGIE_STATUS_NOTIFIER_IS_FREEDESKTOP_WATCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_STATUS_NOTIFIER_TYPE_FREEDESKTOP_WATCHER))
#define BUDGIE_STATUS_NOTIFIER_IS_FREEDESKTOP_WATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_STATUS_NOTIFIER_TYPE_FREEDESKTOP_WATCHER))
#define BUDGIE_STATUS_NOTIFIER_FREEDESKTOP_WATCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_STATUS_NOTIFIER_TYPE_FREEDESKTOP_WATCHER, BudgieStatusNotifierFreedesktopWatcherClass))

typedef struct _BudgieStatusNotifierFreedesktopWatcher BudgieStatusNotifierFreedesktopWatcher;
typedef struct _BudgieStatusNotifierFreedesktopWatcherClass BudgieStatusNotifierFreedesktopWatcherClass;

#define BUDGIE_TYPE_XDG_DIR_TRACKER (budgie_xdg_dir_tracker_get_type ())
#define BUDGIE_XDG_DIR_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_XDG_DIR_TRACKER, BudgieXDGDirTracker))
#define BUDGIE_XDG_DIR_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_XDG_DIR_TRACKER, BudgieXDGDirTrackerClass))
#define BUDGIE_IS_XDG_DIR_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_XDG_DIR_TRACKER))
#define BUDGIE_IS_XDG_DIR_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_XDG_DIR_TRACKER))
#define BUDGIE_XDG_DIR_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_XDG_DIR_TRACKER, BudgieXDGDirTrackerClass))

typedef struct _BudgieXDGDirTracker BudgieXDGDirTracker;
typedef struct _BudgieXDGDirTrackerClass BudgieXDGDirTrackerClass;

#define BUDGIE_TYPE_BACKGROUND (budgie_background_get_type ())
#define BUDGIE_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_BACKGROUND, BudgieBackground))
#define BUDGIE_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_BACKGROUND, BudgieBackgroundClass))
#define BUDGIE_IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_BACKGROUND))
#define BUDGIE_IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_BACKGROUND))
#define BUDGIE_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_BACKGROUND, BudgieBackgroundClass))

typedef struct _BudgieBackground BudgieBackground;
typedef struct _BudgieBackgroundClass BudgieBackgroundClass;

#define BUDGIE_TYPE_SCREENLOCK (budgie_screenlock_get_type ())
#define BUDGIE_SCREENLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SCREENLOCK, BudgieScreenlock))
#define BUDGIE_SCREENLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SCREENLOCK, BudgieScreenlockClass))
#define BUDGIE_IS_SCREENLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SCREENLOCK))
#define BUDGIE_IS_SCREENLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SCREENLOCK))
#define BUDGIE_SCREENLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SCREENLOCK, BudgieScreenlockClass))

typedef struct _BudgieScreenlock BudgieScreenlock;
typedef struct _BudgieScreenlockClass BudgieScreenlockClass;

#define BUDGIE_TYPE_NIGHT_LIGHT_MANAGER (budgie_night_light_manager_get_type ())
#define BUDGIE_NIGHT_LIGHT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_NIGHT_LIGHT_MANAGER, BudgieNightLightManager))
#define BUDGIE_NIGHT_LIGHT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_NIGHT_LIGHT_MANAGER, BudgieNightLightManagerClass))
#define BUDGIE_IS_NIGHT_LIGHT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_NIGHT_LIGHT_MANAGER))
#define BUDGIE_IS_NIGHT_LIGHT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_NIGHT_LIGHT_MANAGER))
#define BUDGIE_NIGHT_LIGHT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_NIGHT_LIGHT_MANAGER, BudgieNightLightManagerClass))

typedef struct _BudgieNightLightManager BudgieNightLightManager;
typedef struct _BudgieNightLightManagerClass BudgieNightLightManagerClass;

#define BUDGIE_TYPE_SCREENSHOT_MANAGER (budgie_screenshot_manager_get_type ())
#define BUDGIE_SCREENSHOT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SCREENSHOT_MANAGER, BudgieScreenshotManager))
#define BUDGIE_SCREENSHOT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SCREENSHOT_MANAGER, BudgieScreenshotManagerClass))
#define BUDGIE_IS_SCREENSHOT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SCREENSHOT_MANAGER))
#define BUDGIE_IS_SCREENSHOT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SCREENSHOT_MANAGER))
#define BUDGIE_SCREENSHOT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SCREENSHOT_MANAGER, BudgieScreenshotManagerClass))

typedef struct _BudgieScreenshotManager BudgieScreenshotManager;
typedef struct _BudgieScreenshotManagerClass BudgieScreenshotManagerClass;
enum  {
	BUDGIE_SERVICE_MANAGER_0_PROPERTY,
	BUDGIE_SERVICE_MANAGER_NUM_PROPERTIES
};
static GParamSpec* budgie_service_manager_properties[BUDGIE_SERVICE_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _budgie_osd_manager_unref0(var) ((var == NULL) ? NULL : (var = (budgie_osd_manager_unref (var), NULL)))
#define _budgie_background_unref0(var) ((var == NULL) ? NULL : (var = (budgie_background_unref (var), NULL)))
#define _budgie_screenlock_unref0(var) ((var == NULL) ? NULL : (var = (budgie_screenlock_unref (var), NULL)))
typedef struct _BudgieServiceManagerRegisterWithSessionData BudgieServiceManagerRegisterWithSessionData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _BudgieServiceManager {
	GObject parent_instance;
	BudgieServiceManagerPrivate * priv;
};

struct _BudgieServiceManagerClass {
	GObjectClass parent_class;
};

struct _BudgieServiceManagerPrivate {
	BudgieThemeManager* theme_manager;
	LibSessionSessionClient* sclient;
	BudgieWaylandClient* wayland_client;
	BudgieOSDManager* osd;
	BudgieOSDKeys* osdkeys;
	BudgieNotificationsServer* notifications;
	BudgieStatusNotifierFreedesktopWatcher* status_notifier;
	BudgieXDGDirTracker* xdg_tracker;
	BudgieBackground* background;
	BudgieScreenlock* screenlock;
	BudgieNightLightManager* nightlight;
	BudgieScreenshotManager* screenshot_manager;
};

struct _BudgieServiceManagerRegisterWithSessionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BudgieServiceManager* self;
	gboolean result;
	LibSessionSessionClient* _tmp0_;
	LibSessionSessionClient* _tmp1_;
	LibSessionSessionClient* _tmp2_;
	LibSessionSessionClient* _tmp3_;
	LibSessionSessionClient* _tmp4_;
};

static gint BudgieServiceManager_private_offset;
static gpointer budgie_service_manager_parent_class = NULL;

VALA_EXTERN GType budgie_service_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieServiceManager, g_object_unref)
VALA_EXTERN gpointer budgie_osd_manager_ref (gpointer instance);
VALA_EXTERN void budgie_osd_manager_unref (gpointer instance);
VALA_EXTERN GParamSpec* budgie_param_spec_osd_manager (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void budgie_value_set_osd_manager (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void budgie_value_take_osd_manager (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer budgie_value_get_osd_manager (const GValue* value);
VALA_EXTERN GType budgie_osd_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieOSDManager, budgie_osd_manager_unref)
VALA_EXTERN guint budgie_osd_manager_register_object (void* object,
                                          GDBusConnection* connection,
                                          const gchar* path,
                                          GError** error);
VALA_EXTERN GType budgie_osd_keys_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieOSDKeys, g_object_unref)
VALA_EXTERN GType budgie_notifications_server_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieNotificationsServer, g_object_unref)
VALA_EXTERN guint budgie_notifications_server_register_object (void* object,
                                                   GDBusConnection* connection,
                                                   const gchar* path,
                                                   GError** error);
VALA_EXTERN GType budgie_status_notifier_freedesktop_watcher_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieStatusNotifierFreedesktopWatcher, g_object_unref)
VALA_EXTERN guint budgie_status_notifier_freedesktop_watcher_register_object (void* object,
                                                                  GDBusConnection* connection,
                                                                  const gchar* path,
                                                                  GError** error);
VALA_EXTERN GType budgie_xdg_dir_tracker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieXDGDirTracker, g_object_unref)
VALA_EXTERN guint budgie_xdg_dir_tracker_register_object (void* object,
                                              GDBusConnection* connection,
                                              const gchar* path,
                                              GError** error);
VALA_EXTERN gpointer budgie_background_ref (gpointer instance);
VALA_EXTERN void budgie_background_unref (gpointer instance);
VALA_EXTERN GParamSpec* budgie_param_spec_background (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void budgie_value_set_background (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void budgie_value_take_background (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer budgie_value_get_background (const GValue* value);
VALA_EXTERN GType budgie_background_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieBackground, budgie_background_unref)
VALA_EXTERN gpointer budgie_screenlock_ref (gpointer instance);
VALA_EXTERN void budgie_screenlock_unref (gpointer instance);
VALA_EXTERN GParamSpec* budgie_param_spec_screenlock (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void budgie_value_set_screenlock (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void budgie_value_take_screenlock (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer budgie_value_get_screenlock (const GValue* value);
VALA_EXTERN GType budgie_screenlock_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieScreenlock, budgie_screenlock_unref)
VALA_EXTERN guint budgie_screenlock_register_object (void* object,
                                         GDBusConnection* connection,
                                         const gchar* path,
                                         GError** error);
VALA_EXTERN GType budgie_night_light_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieNightLightManager, g_object_unref)
VALA_EXTERN GType budgie_screenshot_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieScreenshotManager, g_object_unref)
VALA_EXTERN guint budgie_screenshot_manager_register_object (void* object,
                                                 GDBusConnection* connection,
                                                 const gchar* path,
                                                 GError** error);
VALA_EXTERN BudgieServiceManager* budgie_service_manager_new (gboolean replace);
VALA_EXTERN BudgieServiceManager* budgie_service_manager_construct (GType object_type,
                                                        gboolean replace);
VALA_EXTERN BudgieStatusNotifierFreedesktopWatcher* budgie_status_notifier_freedesktop_watcher_new (void);
VALA_EXTERN BudgieStatusNotifierFreedesktopWatcher* budgie_status_notifier_freedesktop_watcher_construct (GType object_type);
static void budgie_service_manager_register_with_session (BudgieServiceManager* self,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static gboolean budgie_service_manager_register_with_session_finish (BudgieServiceManager* self,
                                                              GAsyncResult* _res_);
static void __lambda57_ (BudgieServiceManager* self,
                  GObject* o,
                  GAsyncResult* res);
static void ___lambda57__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
VALA_EXTERN BudgieOSDManager* budgie_osd_manager_new (void);
VALA_EXTERN BudgieOSDManager* budgie_osd_manager_construct (GType object_type);
VALA_EXTERN void budgie_osd_manager_setup_dbus (BudgieOSDManager* self,
                                    gboolean replace);
static void __lambda58_ (BudgieServiceManager* self);
VALA_EXTERN BudgieOSDKeys* budgie_osd_keys_new (void);
VALA_EXTERN BudgieOSDKeys* budgie_osd_keys_construct (GType object_type);
static void ___lambda58__budgie_osd_manager_ready (BudgieOSDManager* _sender,
                                            gpointer self);
VALA_EXTERN BudgieNotificationsServer* budgie_notifications_server_new (void);
VALA_EXTERN BudgieNotificationsServer* budgie_notifications_server_construct (GType object_type);
VALA_EXTERN void budgie_notifications_server_setup_dbus (BudgieNotificationsServer* self,
                                             gboolean replace);
VALA_EXTERN BudgieBackground* budgie_background_new (void);
VALA_EXTERN BudgieBackground* budgie_background_construct (GType object_type);
VALA_EXTERN BudgieXDGDirTracker* budgie_xdg_dir_tracker_new (void);
VALA_EXTERN BudgieXDGDirTracker* budgie_xdg_dir_tracker_construct (GType object_type);
VALA_EXTERN void budgie_xdg_dir_tracker_setup_dbus (BudgieXDGDirTracker* self,
                                        gboolean replace);
VALA_EXTERN BudgieScreenlock* budgie_screenlock_init (void);
VALA_EXTERN void budgie_screenlock_setup_dbus (BudgieScreenlock* self);
VALA_EXTERN BudgieNightLightManager* budgie_night_light_manager_new (void);
VALA_EXTERN BudgieNightLightManager* budgie_night_light_manager_construct (GType object_type);
VALA_EXTERN BudgieScreenshotManager* budgie_screenshot_manager_new (void);
VALA_EXTERN BudgieScreenshotManager* budgie_screenshot_manager_construct (GType object_type);
VALA_EXTERN void budgie_screenshot_manager_serve (BudgieScreenshotManager* self);
static void budgie_service_manager_register_with_session_data_free (gpointer _data);
static gboolean budgie_service_manager_register_with_session_co (BudgieServiceManagerRegisterWithSessionData* _data_);
static void budgie_service_manager_register_with_session_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_);
static void __lambda54_ (BudgieServiceManager* self);
static void budgie_service_manager_end_session (BudgieServiceManager* self,
                                         gboolean quit);
static void ___lambda54__lib_session_session_client_query_end_session (LibSessionSessionClient* _sender,
                                                                guint flags,
                                                                gpointer self);
static void __lambda55_ (BudgieServiceManager* self);
static void ___lambda55__lib_session_session_client_end_session (LibSessionSessionClient* _sender,
                                                          guint flags,
                                                          gpointer self);
static void __lambda56_ (BudgieServiceManager* self);
static void ___lambda56__lib_session_session_client_stop (LibSessionSessionClient* _sender,
                                                   gpointer self);
static void budgie_service_manager_finalize (GObject * obj);
static GType budgie_service_manager_get_type_once (void);

static inline gpointer
budgie_service_manager_get_instance_private (BudgieServiceManager* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieServiceManager_private_offset);
}

/**
* Construct a new ServiceManager and initialiase appropriately
*/
static void
__lambda57_ (BudgieServiceManager* self,
             GObject* o,
             GAsyncResult* res)
{
	gboolean success = FALSE;
	g_return_if_fail (res != NULL);
	success = budgie_service_manager_register_with_session_finish (self, res);
	if (!success) {
		g_message ("manager.vala:50: Failed to register with Session manager");
	}
}

static void
___lambda57__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda57_ ((BudgieServiceManager*) self, source_object, res);
	g_object_unref (self);
}

static void
__lambda58_ (BudgieServiceManager* self)
{
	BudgieOSDKeys* _tmp0_;
	g_debug ("manager.vala:61: ServiceManager: OSDManager ready, creating OSDKeys");
	_tmp0_ = budgie_osd_keys_new ();
	_g_object_unref0 (self->priv->osdkeys);
	self->priv->osdkeys = _tmp0_;
}

static void
___lambda58__budgie_osd_manager_ready (BudgieOSDManager* _sender,
                                       gpointer self)
{
	__lambda58_ ((BudgieServiceManager*) self);
}

static gpointer
_budgie_screenlock_ref0 (gpointer self)
{
	return self ? budgie_screenlock_ref (self) : NULL;
}

BudgieServiceManager*
budgie_service_manager_construct (GType object_type,
                                  gboolean replace)
{
	BudgieServiceManager * self = NULL;
	BudgieThemeManager* _tmp0_;
	BudgieStatusNotifierFreedesktopWatcher* _tmp1_;
	BudgieOSDManager* _tmp2_;
	BudgieOSDManager* _tmp3_;
	BudgieOSDManager* _tmp4_;
	BudgieNotificationsServer* _tmp5_;
	BudgieNotificationsServer* _tmp6_;
	BudgieBackground* _tmp7_;
	BudgieXDGDirTracker* _tmp8_;
	BudgieXDGDirTracker* _tmp9_;
	BudgieScreenlock* _tmp10_;
	BudgieScreenlock* _tmp11_;
	BudgieScreenlock* _tmp12_;
	BudgieNightLightManager* _tmp13_;
	BudgieScreenshotManager* _tmp14_;
	BudgieScreenshotManager* _tmp15_;
	self = (BudgieServiceManager*) g_object_new (object_type, NULL);
	_tmp0_ = budgie_theme_manager_new ();
	_g_object_unref0 (self->priv->theme_manager);
	self->priv->theme_manager = _tmp0_;
	_tmp1_ = budgie_status_notifier_freedesktop_watcher_new ();
	_g_object_unref0 (self->priv->status_notifier);
	self->priv->status_notifier = _tmp1_;
	budgie_service_manager_register_with_session (self, ___lambda57__gasync_ready_callback, g_object_ref (self));
	g_debug ("manager.vala:55: ServiceManager: Creating OSDManager...");
	_tmp2_ = budgie_osd_manager_new ();
	_budgie_osd_manager_unref0 (self->priv->osd);
	self->priv->osd = _tmp2_;
	_tmp3_ = self->priv->osd;
	budgie_osd_manager_setup_dbus (_tmp3_, replace);
	_tmp4_ = self->priv->osd;
	g_signal_connect_object (_tmp4_, "ready", (GCallback) ___lambda58__budgie_osd_manager_ready, self, 0);
	_tmp5_ = budgie_notifications_server_new ();
	_g_object_unref0 (self->priv->notifications);
	self->priv->notifications = _tmp5_;
	_tmp6_ = self->priv->notifications;
	budgie_notifications_server_setup_dbus (_tmp6_, replace);
	_tmp7_ = budgie_background_new ();
	_budgie_background_unref0 (self->priv->background);
	self->priv->background = _tmp7_;
	_tmp8_ = budgie_xdg_dir_tracker_new ();
	_g_object_unref0 (self->priv->xdg_tracker);
	self->priv->xdg_tracker = _tmp8_;
	_tmp9_ = self->priv->xdg_tracker;
	budgie_xdg_dir_tracker_setup_dbus (_tmp9_, replace);
	_tmp10_ = budgie_screenlock_init ();
	_tmp11_ = _budgie_screenlock_ref0 (_tmp10_);
	_budgie_screenlock_unref0 (self->priv->screenlock);
	self->priv->screenlock = _tmp11_;
	_tmp12_ = self->priv->screenlock;
	budgie_screenlock_setup_dbus (_tmp12_);
	_tmp13_ = budgie_night_light_manager_new ();
	_g_object_unref0 (self->priv->nightlight);
	self->priv->nightlight = _tmp13_;
	_tmp14_ = budgie_screenshot_manager_new ();
	_g_object_unref0 (self->priv->screenshot_manager);
	self->priv->screenshot_manager = _tmp14_;
	_tmp15_ = self->priv->screenshot_manager;
	budgie_screenshot_manager_serve (_tmp15_);
	return self;
}

BudgieServiceManager*
budgie_service_manager_new (gboolean replace)
{
	return budgie_service_manager_construct (BUDGIE_TYPE_SERVICE_MANAGER, replace);
}

static void
budgie_service_manager_register_with_session_data_free (gpointer _data)
{
	BudgieServiceManagerRegisterWithSessionData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BudgieServiceManagerRegisterWithSessionData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
budgie_service_manager_register_with_session (BudgieServiceManager* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	BudgieServiceManagerRegisterWithSessionData* _data_;
	BudgieServiceManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BudgieServiceManagerRegisterWithSessionData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, budgie_service_manager_register_with_session_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	budgie_service_manager_register_with_session_co (_data_);
}

static gboolean
budgie_service_manager_register_with_session_finish (BudgieServiceManager* self,
                                                     GAsyncResult* _res_)
{
	gboolean result;
	BudgieServiceManagerRegisterWithSessionData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

/**
* Attempt registration with the Session Manager
*/
static void
budgie_service_manager_register_with_session_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_)
{
	BudgieServiceManagerRegisterWithSessionData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	budgie_service_manager_register_with_session_co (_data_);
}

static void
__lambda54_ (BudgieServiceManager* self)
{
	budgie_service_manager_end_session (self, FALSE);
}

static void
___lambda54__lib_session_session_client_query_end_session (LibSessionSessionClient* _sender,
                                                           guint flags,
                                                           gpointer self)
{
	__lambda54_ ((BudgieServiceManager*) self);
}

static void
__lambda55_ (BudgieServiceManager* self)
{
	budgie_service_manager_end_session (self, FALSE);
}

static void
___lambda55__lib_session_session_client_end_session (LibSessionSessionClient* _sender,
                                                     guint flags,
                                                     gpointer self)
{
	__lambda55_ ((BudgieServiceManager*) self);
}

static void
__lambda56_ (BudgieServiceManager* self)
{
	budgie_service_manager_end_session (self, TRUE);
}

static void
___lambda56__lib_session_session_client_stop (LibSessionSessionClient* _sender,
                                              gpointer self)
{
	__lambda56_ ((BudgieServiceManager*) self);
}

static gboolean
budgie_service_manager_register_with_session_co (BudgieServiceManagerRegisterWithSessionData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	lib_session_register_with_session ("budgie-daemon", budgie_service_manager_register_with_session_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = lib_session_register_with_session_finish (_data_->_res_);
	_g_object_unref0 (_data_->self->priv->sclient);
	_data_->self->priv->sclient = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->self->priv->sclient;
	if (_data_->_tmp1_ == NULL) {
		_data_->result = FALSE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->self->priv->sclient;
	g_signal_connect_object (_data_->_tmp2_, "query-end-session", (GCallback) ___lambda54__lib_session_session_client_query_end_session, _data_->self, 0);
	_data_->_tmp3_ = _data_->self->priv->sclient;
	g_signal_connect_object (_data_->_tmp3_, "end-session", (GCallback) ___lambda55__lib_session_session_client_end_session, _data_->self, 0);
	_data_->_tmp4_ = _data_->self->priv->sclient;
	g_signal_connect_object (_data_->_tmp4_, "stop", (GCallback) ___lambda56__lib_session_session_client_stop, _data_->self, 0);
	_data_->result = TRUE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
* Properly shutdown when asked to
*/
static void
budgie_service_manager_end_session (BudgieServiceManager* self,
                                    gboolean quit)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (quit) {
		gtk_main_quit ();
		return;
	}
	{
		LibSessionSessionClient* _tmp0_;
		_tmp0_ = self->priv->sclient;
		lib_session_session_client_EndSessionResponse (_tmp0_, TRUE, "", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("manager.vala:116: Unable to respond to session manager! %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
budgie_service_manager_class_init (BudgieServiceManagerClass * klass,
                                   gpointer klass_data)
{
	budgie_service_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieServiceManager_private_offset);
	G_OBJECT_CLASS (klass)->finalize = budgie_service_manager_finalize;
}

static void
budgie_service_manager_instance_init (BudgieServiceManager * self,
                                      gpointer klass)
{
	BudgieWaylandClient* _tmp0_;
	self->priv = budgie_service_manager_get_instance_private (self);
	_tmp0_ = budgie_wayland_client_new ();
	self->priv->wayland_client = _tmp0_;
}

static void
budgie_service_manager_finalize (GObject * obj)
{
	BudgieServiceManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_SERVICE_MANAGER, BudgieServiceManager);
	_g_object_unref0 (self->priv->theme_manager);
	_g_object_unref0 (self->priv->sclient);
	_g_object_unref0 (self->priv->wayland_client);
	_budgie_osd_manager_unref0 (self->priv->osd);
	_g_object_unref0 (self->priv->osdkeys);
	_g_object_unref0 (self->priv->notifications);
	_g_object_unref0 (self->priv->status_notifier);
	_g_object_unref0 (self->priv->xdg_tracker);
	_budgie_background_unref0 (self->priv->background);
	_budgie_screenlock_unref0 (self->priv->screenlock);
	_g_object_unref0 (self->priv->nightlight);
	_g_object_unref0 (self->priv->screenshot_manager);
	G_OBJECT_CLASS (budgie_service_manager_parent_class)->finalize (obj);
}

/**
* Main lifecycle management, handle all the various session and GTK+ bits
*/
static GType
budgie_service_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieServiceManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_service_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieServiceManager), 0, (GInstanceInitFunc) budgie_service_manager_instance_init, NULL };
	GType budgie_service_manager_type_id;
	budgie_service_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieServiceManager", &g_define_type_info, 0);
	BudgieServiceManager_private_offset = g_type_add_instance_private (budgie_service_manager_type_id, sizeof (BudgieServiceManagerPrivate));
	return budgie_service_manager_type_id;
}

GType
budgie_service_manager_get_type (void)
{
	static volatile gsize budgie_service_manager_type_id__once = 0;
	if (g_once_init_enter (&budgie_service_manager_type_id__once)) {
		GType budgie_service_manager_type_id;
		budgie_service_manager_type_id = budgie_service_manager_get_type_once ();
		g_once_init_leave (&budgie_service_manager_type_id__once, budgie_service_manager_type_id);
	}
	return budgie_service_manager_type_id__once;
}

