// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.9
// 	protoc        (unknown)
// source: buf/alpha/module/v1alpha1/module.proto

package modulev1alpha1

import (
	v1 "github.com/bufbuild/buf/private/gen/proto/go/buf/alpha/breaking/v1"
	v11 "github.com/bufbuild/buf/private/gen/proto/go/buf/alpha/lint/v1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type DigestType int32

const (
	DigestType_DIGEST_TYPE_UNSPECIFIED DigestType = 0
	DigestType_DIGEST_TYPE_SHAKE256    DigestType = 1
)

// Enum value maps for DigestType.
var (
	DigestType_name = map[int32]string{
		0: "DIGEST_TYPE_UNSPECIFIED",
		1: "DIGEST_TYPE_SHAKE256",
	}
	DigestType_value = map[string]int32{
		"DIGEST_TYPE_UNSPECIFIED": 0,
		"DIGEST_TYPE_SHAKE256":    1,
	}
)

func (x DigestType) Enum() *DigestType {
	p := new(DigestType)
	*p = x
	return p
}

func (x DigestType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DigestType) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_module_v1alpha1_module_proto_enumTypes[0].Descriptor()
}

func (DigestType) Type() protoreflect.EnumType {
	return &file_buf_alpha_module_v1alpha1_module_proto_enumTypes[0]
}

func (x DigestType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Digest represents a hash function's value.
type Digest struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_DigestType DigestType             `protobuf:"varint,1,opt,name=digest_type,json=digestType,proto3,enum=buf.alpha.module.v1alpha1.DigestType"`
	xxx_hidden_Digest     []byte                 `protobuf:"bytes,2,opt,name=digest,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *Digest) Reset() {
	*x = Digest{}
	mi := &file_buf_alpha_module_v1alpha1_module_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Digest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Digest) ProtoMessage() {}

func (x *Digest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_module_v1alpha1_module_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Digest) GetDigestType() DigestType {
	if x != nil {
		return x.xxx_hidden_DigestType
	}
	return DigestType_DIGEST_TYPE_UNSPECIFIED
}

func (x *Digest) GetDigest() []byte {
	if x != nil {
		return x.xxx_hidden_Digest
	}
	return nil
}

func (x *Digest) SetDigestType(v DigestType) {
	x.xxx_hidden_DigestType = v
}

func (x *Digest) SetDigest(v []byte) {
	if v == nil {
		v = []byte{}
	}
	x.xxx_hidden_Digest = v
}

type Digest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// digest_type describes the hash algorithm. e.g. "SHAKE256"
	DigestType DigestType
	// digest is the hash's output without encoding.
	Digest []byte
}

func (b0 Digest_builder) Build() *Digest {
	m0 := &Digest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_DigestType = b.DigestType
	x.xxx_hidden_Digest = b.Digest
	return m0
}

// Blob represents some module content with an associated digest.
type Blob struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Digest  *Digest                `protobuf:"bytes,1,opt,name=digest,proto3"`
	xxx_hidden_Content []byte                 `protobuf:"bytes,2,opt,name=content,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *Blob) Reset() {
	*x = Blob{}
	mi := &file_buf_alpha_module_v1alpha1_module_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Blob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Blob) ProtoMessage() {}

func (x *Blob) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_module_v1alpha1_module_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Blob) GetDigest() *Digest {
	if x != nil {
		return x.xxx_hidden_Digest
	}
	return nil
}

func (x *Blob) GetContent() []byte {
	if x != nil {
		return x.xxx_hidden_Content
	}
	return nil
}

func (x *Blob) SetDigest(v *Digest) {
	x.xxx_hidden_Digest = v
}

func (x *Blob) SetContent(v []byte) {
	if v == nil {
		v = []byte{}
	}
	x.xxx_hidden_Content = v
}

func (x *Blob) HasDigest() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Digest != nil
}

func (x *Blob) ClearDigest() {
	x.xxx_hidden_Digest = nil
}

type Blob_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Digest of the content.
	Digest *Digest
	// Content of the blob.
	Content []byte
}

func (b0 Blob_builder) Build() *Blob {
	m0 := &Blob{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Digest = b.Digest
	x.xxx_hidden_Content = b.Content
	return m0
}

// Module is a module.
type Module struct {
	state                        protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Files             *[]*ModuleFile         `protobuf:"bytes,1,rep,name=files,proto3"`
	xxx_hidden_Dependencies      *[]*ModulePin          `protobuf:"bytes,2,rep,name=dependencies,proto3"`
	xxx_hidden_Documentation     string                 `protobuf:"bytes,3,opt,name=documentation,proto3"`
	xxx_hidden_BreakingConfig    *v1.Config             `protobuf:"bytes,4,opt,name=breaking_config,json=breakingConfig,proto3"`
	xxx_hidden_LintConfig        *v11.Config            `protobuf:"bytes,5,opt,name=lint_config,json=lintConfig,proto3"`
	xxx_hidden_License           string                 `protobuf:"bytes,6,opt,name=license,proto3"`
	xxx_hidden_DocumentationPath string                 `protobuf:"bytes,7,opt,name=documentation_path,json=documentationPath,proto3"`
	unknownFields                protoimpl.UnknownFields
	sizeCache                    protoimpl.SizeCache
}

func (x *Module) Reset() {
	*x = Module{}
	mi := &file_buf_alpha_module_v1alpha1_module_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Module) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Module) ProtoMessage() {}

func (x *Module) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_module_v1alpha1_module_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Module) GetFiles() []*ModuleFile {
	if x != nil {
		if x.xxx_hidden_Files != nil {
			return *x.xxx_hidden_Files
		}
	}
	return nil
}

func (x *Module) GetDependencies() []*ModulePin {
	if x != nil {
		if x.xxx_hidden_Dependencies != nil {
			return *x.xxx_hidden_Dependencies
		}
	}
	return nil
}

func (x *Module) GetDocumentation() string {
	if x != nil {
		return x.xxx_hidden_Documentation
	}
	return ""
}

func (x *Module) GetBreakingConfig() *v1.Config {
	if x != nil {
		return x.xxx_hidden_BreakingConfig
	}
	return nil
}

func (x *Module) GetLintConfig() *v11.Config {
	if x != nil {
		return x.xxx_hidden_LintConfig
	}
	return nil
}

func (x *Module) GetLicense() string {
	if x != nil {
		return x.xxx_hidden_License
	}
	return ""
}

func (x *Module) GetDocumentationPath() string {
	if x != nil {
		return x.xxx_hidden_DocumentationPath
	}
	return ""
}

func (x *Module) SetFiles(v []*ModuleFile) {
	x.xxx_hidden_Files = &v
}

func (x *Module) SetDependencies(v []*ModulePin) {
	x.xxx_hidden_Dependencies = &v
}

func (x *Module) SetDocumentation(v string) {
	x.xxx_hidden_Documentation = v
}

func (x *Module) SetBreakingConfig(v *v1.Config) {
	x.xxx_hidden_BreakingConfig = v
}

func (x *Module) SetLintConfig(v *v11.Config) {
	x.xxx_hidden_LintConfig = v
}

func (x *Module) SetLicense(v string) {
	x.xxx_hidden_License = v
}

func (x *Module) SetDocumentationPath(v string) {
	x.xxx_hidden_DocumentationPath = v
}

func (x *Module) HasBreakingConfig() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_BreakingConfig != nil
}

func (x *Module) HasLintConfig() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_LintConfig != nil
}

func (x *Module) ClearBreakingConfig() {
	x.xxx_hidden_BreakingConfig = nil
}

func (x *Module) ClearLintConfig() {
	x.xxx_hidden_LintConfig = nil
}

type Module_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// files are the files that make up the set.
	//
	// Sorted by path.
	// Path must be unique.
	// Only the target files. No imports.
	//
	// Maximum total size of all content: 32MB.
	Files []*ModuleFile
	// dependencies are the dependencies.
	Dependencies []*ModulePin
	// documentation is the string representation of the contents of the file at documentation_path.
	//
	// string is used to enforce UTF-8 encoding or 7-bit ASCII text.
	Documentation string
	// breaking_config is the breaking change detection configuration set for the module.
	BreakingConfig *v1.Config
	// lint_config is the lint configuration set for the module.
	LintConfig *v11.Config
	// license is the string representation of the contents of the `LICENSE` file.
	//
	// string is used to enforce UTF-8 encoding or 7-bit ASCII text.
	License string
	// documentation_path is the path of the file which contains the module documentation.
	//
	// either `buf.md`, `README.md` or `README.markdown`.
	// if empty, assumes buf.md.
	DocumentationPath string
}

func (b0 Module_builder) Build() *Module {
	m0 := &Module{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Files = &b.Files
	x.xxx_hidden_Dependencies = &b.Dependencies
	x.xxx_hidden_Documentation = b.Documentation
	x.xxx_hidden_BreakingConfig = b.BreakingConfig
	x.xxx_hidden_LintConfig = b.LintConfig
	x.xxx_hidden_License = b.License
	x.xxx_hidden_DocumentationPath = b.DocumentationPath
	return m0
}

// ModuleFile is a file within a FileSet.
type ModuleFile struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Path    string                 `protobuf:"bytes,1,opt,name=path,proto3"`
	xxx_hidden_Content []byte                 `protobuf:"bytes,2,opt,name=content,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *ModuleFile) Reset() {
	*x = ModuleFile{}
	mi := &file_buf_alpha_module_v1alpha1_module_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ModuleFile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModuleFile) ProtoMessage() {}

func (x *ModuleFile) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_module_v1alpha1_module_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ModuleFile) GetPath() string {
	if x != nil {
		return x.xxx_hidden_Path
	}
	return ""
}

func (x *ModuleFile) GetContent() []byte {
	if x != nil {
		return x.xxx_hidden_Content
	}
	return nil
}

func (x *ModuleFile) SetPath(v string) {
	x.xxx_hidden_Path = v
}

func (x *ModuleFile) SetContent(v []byte) {
	if v == nil {
		v = []byte{}
	}
	x.xxx_hidden_Content = v
}

type ModuleFile_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// path is the relative path of the file.
	// Path can only use '/' as the separator character, and includes no ".." components.
	Path string
	// content is the content of the file.
	Content []byte
}

func (b0 ModuleFile_builder) Build() *ModuleFile {
	m0 := &ModuleFile{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Path = b.Path
	x.xxx_hidden_Content = b.Content
	return m0
}

// ModuleReference is a module reference.
type ModuleReference struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Remote     string                 `protobuf:"bytes,1,opt,name=remote,proto3"`
	xxx_hidden_Owner      string                 `protobuf:"bytes,2,opt,name=owner,proto3"`
	xxx_hidden_Repository string                 `protobuf:"bytes,3,opt,name=repository,proto3"`
	xxx_hidden_Reference  string                 `protobuf:"bytes,4,opt,name=reference,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *ModuleReference) Reset() {
	*x = ModuleReference{}
	mi := &file_buf_alpha_module_v1alpha1_module_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ModuleReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModuleReference) ProtoMessage() {}

func (x *ModuleReference) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_module_v1alpha1_module_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ModuleReference) GetRemote() string {
	if x != nil {
		return x.xxx_hidden_Remote
	}
	return ""
}

func (x *ModuleReference) GetOwner() string {
	if x != nil {
		return x.xxx_hidden_Owner
	}
	return ""
}

func (x *ModuleReference) GetRepository() string {
	if x != nil {
		return x.xxx_hidden_Repository
	}
	return ""
}

func (x *ModuleReference) GetReference() string {
	if x != nil {
		return x.xxx_hidden_Reference
	}
	return ""
}

func (x *ModuleReference) SetRemote(v string) {
	x.xxx_hidden_Remote = v
}

func (x *ModuleReference) SetOwner(v string) {
	x.xxx_hidden_Owner = v
}

func (x *ModuleReference) SetRepository(v string) {
	x.xxx_hidden_Repository = v
}

func (x *ModuleReference) SetReference(v string) {
	x.xxx_hidden_Reference = v
}

type ModuleReference_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Remote     string
	Owner      string
	Repository string
	// either tag, or commit
	Reference string
}

func (b0 ModuleReference_builder) Build() *ModuleReference {
	m0 := &ModuleReference{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Remote = b.Remote
	x.xxx_hidden_Owner = b.Owner
	x.xxx_hidden_Repository = b.Repository
	x.xxx_hidden_Reference = b.Reference
	return m0
}

// ModulePin is a module pin.
type ModulePin struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Remote         string                 `protobuf:"bytes,1,opt,name=remote,proto3"`
	xxx_hidden_Owner          string                 `protobuf:"bytes,2,opt,name=owner,proto3"`
	xxx_hidden_Repository     string                 `protobuf:"bytes,3,opt,name=repository,proto3"`
	xxx_hidden_Commit         string                 `protobuf:"bytes,5,opt,name=commit,proto3"`
	xxx_hidden_ManifestDigest string                 `protobuf:"bytes,8,opt,name=manifest_digest,json=manifestDigest,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *ModulePin) Reset() {
	*x = ModulePin{}
	mi := &file_buf_alpha_module_v1alpha1_module_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ModulePin) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModulePin) ProtoMessage() {}

func (x *ModulePin) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_module_v1alpha1_module_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ModulePin) GetRemote() string {
	if x != nil {
		return x.xxx_hidden_Remote
	}
	return ""
}

func (x *ModulePin) GetOwner() string {
	if x != nil {
		return x.xxx_hidden_Owner
	}
	return ""
}

func (x *ModulePin) GetRepository() string {
	if x != nil {
		return x.xxx_hidden_Repository
	}
	return ""
}

func (x *ModulePin) GetCommit() string {
	if x != nil {
		return x.xxx_hidden_Commit
	}
	return ""
}

func (x *ModulePin) GetManifestDigest() string {
	if x != nil {
		return x.xxx_hidden_ManifestDigest
	}
	return ""
}

func (x *ModulePin) SetRemote(v string) {
	x.xxx_hidden_Remote = v
}

func (x *ModulePin) SetOwner(v string) {
	x.xxx_hidden_Owner = v
}

func (x *ModulePin) SetRepository(v string) {
	x.xxx_hidden_Repository = v
}

func (x *ModulePin) SetCommit(v string) {
	x.xxx_hidden_Commit = v
}

func (x *ModulePin) SetManifestDigest(v string) {
	x.xxx_hidden_ManifestDigest = v
}

type ModulePin_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Remote     string
	Owner      string
	Repository string
	Commit     string
	// Module's manifest digest. Replacement for previous b1/b3 digests.
	// This is in the format '<digest_type>:<digest>`, where '<digest_type>' is the lowercase digest name ('shake256'),
	// and '<digest>' is the lowercase hex-encoded digest.
	// This value is persisted directly to the buf.lock file (https://buf.build/docs/configuration/v1/buf-lock) as the 'digest' key.
	ManifestDigest string
}

func (b0 ModulePin_builder) Build() *ModulePin {
	m0 := &ModulePin{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Remote = b.Remote
	x.xxx_hidden_Owner = b.Owner
	x.xxx_hidden_Repository = b.Repository
	x.xxx_hidden_Commit = b.Commit
	x.xxx_hidden_ManifestDigest = b.ManifestDigest
	return m0
}

var File_buf_alpha_module_v1alpha1_module_proto protoreflect.FileDescriptor

const file_buf_alpha_module_v1alpha1_module_proto_rawDesc = "" +
	"\n" +
	"&buf/alpha/module/v1alpha1/module.proto\x12\x19buf.alpha.module.v1alpha1\x1a\"buf/alpha/breaking/v1/config.proto\x1a\x1ebuf/alpha/lint/v1/config.proto\"h\n" +
	"\x06Digest\x12F\n" +
	"\vdigest_type\x18\x01 \x01(\x0e2%.buf.alpha.module.v1alpha1.DigestTypeR\n" +
	"digestType\x12\x16\n" +
	"\x06digest\x18\x02 \x01(\fR\x06digest\"[\n" +
	"\x04Blob\x129\n" +
	"\x06digest\x18\x01 \x01(\v2!.buf.alpha.module.v1alpha1.DigestR\x06digest\x12\x18\n" +
	"\acontent\x18\x02 \x01(\fR\acontent\"\x82\x03\n" +
	"\x06Module\x12;\n" +
	"\x05files\x18\x01 \x03(\v2%.buf.alpha.module.v1alpha1.ModuleFileR\x05files\x12H\n" +
	"\fdependencies\x18\x02 \x03(\v2$.buf.alpha.module.v1alpha1.ModulePinR\fdependencies\x12$\n" +
	"\rdocumentation\x18\x03 \x01(\tR\rdocumentation\x12F\n" +
	"\x0fbreaking_config\x18\x04 \x01(\v2\x1d.buf.alpha.breaking.v1.ConfigR\x0ebreakingConfig\x12:\n" +
	"\vlint_config\x18\x05 \x01(\v2\x19.buf.alpha.lint.v1.ConfigR\n" +
	"lintConfig\x12\x18\n" +
	"\alicense\x18\x06 \x01(\tR\alicense\x12-\n" +
	"\x12documentation_path\x18\a \x01(\tR\x11documentationPath\":\n" +
	"\n" +
	"ModuleFile\x12\x12\n" +
	"\x04path\x18\x01 \x01(\tR\x04path\x12\x18\n" +
	"\acontent\x18\x02 \x01(\fR\acontent\"}\n" +
	"\x0fModuleReference\x12\x16\n" +
	"\x06remote\x18\x01 \x01(\tR\x06remote\x12\x14\n" +
	"\x05owner\x18\x02 \x01(\tR\x05owner\x12\x1e\n" +
	"\n" +
	"repository\x18\x03 \x01(\tR\n" +
	"repository\x12\x1c\n" +
	"\treference\x18\x04 \x01(\tR\treference\"\xc9\x01\n" +
	"\tModulePin\x12\x16\n" +
	"\x06remote\x18\x01 \x01(\tR\x06remote\x12\x14\n" +
	"\x05owner\x18\x02 \x01(\tR\x05owner\x12\x1e\n" +
	"\n" +
	"repository\x18\x03 \x01(\tR\n" +
	"repository\x12\x16\n" +
	"\x06commit\x18\x05 \x01(\tR\x06commit\x12'\n" +
	"\x0fmanifest_digest\x18\b \x01(\tR\x0emanifestDigestJ\x04\b\x04\x10\x05J\x04\b\x06\x10\aJ\x04\b\a\x10\bR\x06branchR\vcreate_timeR\x06digest*C\n" +
	"\n" +
	"DigestType\x12\x1b\n" +
	"\x17DIGEST_TYPE_UNSPECIFIED\x10\x00\x12\x18\n" +
	"\x14DIGEST_TYPE_SHAKE256\x10\x01B\x8a\x02\n" +
	"\x1dcom.buf.alpha.module.v1alpha1B\vModuleProtoP\x01ZUgithub.com/bufbuild/buf/private/gen/proto/go/buf/alpha/module/v1alpha1;modulev1alpha1\xa2\x02\x03BAM\xaa\x02\x19Buf.Alpha.Module.V1alpha1\xca\x02\x19Buf\\Alpha\\Module\\V1alpha1\xe2\x02%Buf\\Alpha\\Module\\V1alpha1\\GPBMetadata\xea\x02\x1cBuf::Alpha::Module::V1alpha1b\x06proto3"

var file_buf_alpha_module_v1alpha1_module_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_buf_alpha_module_v1alpha1_module_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_buf_alpha_module_v1alpha1_module_proto_goTypes = []any{
	(DigestType)(0),         // 0: buf.alpha.module.v1alpha1.DigestType
	(*Digest)(nil),          // 1: buf.alpha.module.v1alpha1.Digest
	(*Blob)(nil),            // 2: buf.alpha.module.v1alpha1.Blob
	(*Module)(nil),          // 3: buf.alpha.module.v1alpha1.Module
	(*ModuleFile)(nil),      // 4: buf.alpha.module.v1alpha1.ModuleFile
	(*ModuleReference)(nil), // 5: buf.alpha.module.v1alpha1.ModuleReference
	(*ModulePin)(nil),       // 6: buf.alpha.module.v1alpha1.ModulePin
	(*v1.Config)(nil),       // 7: buf.alpha.breaking.v1.Config
	(*v11.Config)(nil),      // 8: buf.alpha.lint.v1.Config
}
var file_buf_alpha_module_v1alpha1_module_proto_depIdxs = []int32{
	0, // 0: buf.alpha.module.v1alpha1.Digest.digest_type:type_name -> buf.alpha.module.v1alpha1.DigestType
	1, // 1: buf.alpha.module.v1alpha1.Blob.digest:type_name -> buf.alpha.module.v1alpha1.Digest
	4, // 2: buf.alpha.module.v1alpha1.Module.files:type_name -> buf.alpha.module.v1alpha1.ModuleFile
	6, // 3: buf.alpha.module.v1alpha1.Module.dependencies:type_name -> buf.alpha.module.v1alpha1.ModulePin
	7, // 4: buf.alpha.module.v1alpha1.Module.breaking_config:type_name -> buf.alpha.breaking.v1.Config
	8, // 5: buf.alpha.module.v1alpha1.Module.lint_config:type_name -> buf.alpha.lint.v1.Config
	6, // [6:6] is the sub-list for method output_type
	6, // [6:6] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_buf_alpha_module_v1alpha1_module_proto_init() }
func file_buf_alpha_module_v1alpha1_module_proto_init() {
	if File_buf_alpha_module_v1alpha1_module_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_alpha_module_v1alpha1_module_proto_rawDesc), len(file_buf_alpha_module_v1alpha1_module_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_buf_alpha_module_v1alpha1_module_proto_goTypes,
		DependencyIndexes: file_buf_alpha_module_v1alpha1_module_proto_depIdxs,
		EnumInfos:         file_buf_alpha_module_v1alpha1_module_proto_enumTypes,
		MessageInfos:      file_buf_alpha_module_v1alpha1_module_proto_msgTypes,
	}.Build()
	File_buf_alpha_module_v1alpha1_module_proto = out.File
	file_buf_alpha_module_v1alpha1_module_proto_goTypes = nil
	file_buf_alpha_module_v1alpha1_module_proto_depIdxs = nil
}
